/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.rui.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.edt.rui.messages.RUIResourceKeys;

public class IsBooleanAnnotationValidator
extends AnnotationValidationRule {
    protected AnnotationType annotationType;
    protected String canonicalAnnotationName;
    private static final List<Type> acceptedTypes = new ArrayList<Type>();

    static {
        acceptedTypes.add(TypeUtils.Type_CHAR);
        acceptedTypes.add(TypeUtils.Type_BIN);
        acceptedTypes.add(TypeUtils.Type_NUM);
        acceptedTypes.add(TypeUtils.Type_NUMC);
        acceptedTypes.add(TypeUtils.Type_DECIMAL);
        acceptedTypes.add(TypeUtils.Type_PACF);
        acceptedTypes.add(TypeUtils.Type_INT);
        acceptedTypes.add(TypeUtils.Type_BIGINT);
        acceptedTypes.add(TypeUtils.Type_SMALLINT);
        acceptedTypes.add(TypeUtils.Type_FLOAT);
        acceptedTypes.add(TypeUtils.Type_MONEY);
    }

    public IsBooleanAnnotationValidator() {
        super(NameUtile.getAsCaseSensitiveName((String)"isboolean"));
    }

    public void validate(Node errorNode, Node target, Element targetElement, Map<String, Object> allAnnotationsAndFields, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        Type type = null;
        if (targetElement instanceof Type) {
            type = (Type)targetElement;
        } else if (targetElement instanceof TypedElement) {
            type = ((TypedElement)targetElement).getType();
        }
        if (type == null) {
            return;
        }
        Classifier classifier = type.getClassifier();
        if (classifier == null) {
            return;
        }
        for (Type nextType : acceptedTypes) {
            if (nextType == null || !classifier.equals(nextType).booleanValue()) continue;
            if (type instanceof FixedPrecisionType && ((FixedPrecisionType)type).getLength() != 0 && ((FixedPrecisionType)type).getLength() == ((FixedPrecisionType)type).getDecimals()) {
                problemRequestor.acceptProblem(errorNode, 3123, 2, new String[]{"isBoolean", BindingUtil.getShortTypeString((Type)type, (boolean)true)}, RUIResourceKeys.getResourceBundleForKeys());
            }
            return;
        }
        problemRequestor.acceptProblem(errorNode, 3174, 2, new String[]{"isBoolean", BindingUtil.getShortTypeString((Type)type, (boolean)true)}, RUIResourceKeys.getResourceBundleForKeys());
    }
}

