/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.pde.internal.ui.editor.IPDEDropParticipant;
import org.eclipse.pde.internal.ui.editor.IPDESourceParticipant;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.TransferData;

public class PDEDropAdapter
extends ViewerDropAdapter {
    private IPDEDropParticipant fDropParticipant;
    private IPDESourceParticipant fSourceParticipant;
    private int fLastValidOperation;

    public PDEDropAdapter(Viewer viewer, IPDEDropParticipant dropParticipant, IPDESourceParticipant sourceParticipant) {
        super(viewer);
        this.fDropParticipant = dropParticipant;
        this.fSourceParticipant = sourceParticipant;
        this.resetLastValidOperation();
    }

    protected void resetLastValidOperation() {
        this.fLastValidOperation = 0;
    }

    protected int getLastValidOperation(int currentOperation) {
        if (currentOperation != 0) {
            this.fLastValidOperation = currentOperation;
        }
        return this.fLastValidOperation;
    }

    public boolean performDrop(Object data) {
        this.resetLastValidOperation();
        Object targetObject = this.getCurrentTarget();
        int targetLocation = this.getCurrentLocation();
        Object[] sourceObjects = null;
        sourceObjects = data instanceof Object[] ? (Object[])data : new Object[]{data};
        int operation = this.getCurrentOperation();
        if (operation == 1) {
            this.fDropParticipant.doDropCopy(targetObject, sourceObjects, targetLocation);
        } else if (operation == 2) {
            this.fDropParticipant.doDropMove(targetObject, sourceObjects, targetLocation);
        } else if (operation == 4) {
            this.fDropParticipant.doDropLink(targetObject, sourceObjects, targetLocation);
        } else if (operation == 16) {
            this.fDropParticipant.doDropMove(targetObject, sourceObjects, targetLocation);
        } else {
            return false;
        }
        return true;
    }

    public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
        operation = this.getLastValidOperation(operation);
        targetObject = this.getCurrentTarget();
        int targetLocation = this.getCurrentLocation();
        if (!ModelDataTransfer.getInstance().isSupportedType(transferType)) {
            return false;
        }
        if (targetLocation == 4) {
            return false;
        }
        Object[] sourceObjects = this.fSourceParticipant.getSourceObjects();
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length == 0) {
            return false;
        }
        if (targetObject == null) {
            return false;
        }
        if (operation == 1) {
            return this.validateDropCopy(targetObject, sourceObjects, targetLocation);
        }
        if (operation == 2) {
            return this.validateDropMove(targetObject, sourceObjects, targetLocation);
        }
        if (operation == 4) {
            return this.validateDropLink(targetObject, sourceObjects, targetLocation);
        }
        if (operation == 16) {
            return this.validateDropDefault(targetObject, sourceObjects, targetLocation);
        }
        return false;
    }

    protected boolean validateDropCopy(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return this.fDropParticipant.canDropCopy(targetObject, sourceObjects, targetLocation);
    }

    protected boolean validateDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        int i = 0;
        while (i < sourceObjects.length) {
            if (targetObject.equals(sourceObjects[i])) {
                return false;
            }
            ++i;
        }
        return this.fDropParticipant.canDropMove(targetObject, sourceObjects, targetLocation);
    }

    protected boolean validateDropLink(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return this.fDropParticipant.canDropLink(targetObject, sourceObjects, targetLocation);
    }

    protected boolean validateDropDefault(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return this.validateDropMove(targetObject, sourceObjects, targetLocation);
    }
}

