/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import org.eclipse.edt.compiler.sdk.compile.EGLCArgumentProcessor;

public class EGL2IRArgumentProcessor
extends EGLCArgumentProcessor {
    private static final String SYSTEMROOT = "-systemRoot";
    private static final String XML_OUT = "-xmlOut";
    private static final String EXTENSIONS = "-extensions";

    @Override
    public EGL2IRArguments createDefaultArguments() {
        return new EGL2IRArguments();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EGL2IRArguments processArguments(String[] args) {
        EGL2IRArguments arguments = new EGL2IRArguments();
        try {
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    return arguments;
                }
                int newindex = this.processArgument(arguments, args, i);
                if (newindex == -1) {
                    System.out.println("Invalid option: " + args[i]);
                    this.processError();
                    return null;
                }
                i = newindex;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.processError();
            return null;
        }
    }

    private void processError() {
        System.out.println("Usage: eglc -systemRoot <path> -eglPath <path> -clean -irDestination <path> -xmlOut <partFiles> -extensions <comma-delimited-extensions>");
    }

    public int processArgument(EGL2IRArguments arguments, String[] args, int index) {
        int newindex = index;
        if (args[newindex].charAt(0) == '-') {
            if (args[newindex].equalsIgnoreCase(SYSTEMROOT)) {
                arguments.setSystemRoot(new File(args[newindex + 1]));
                return newindex += 2;
            }
            if (args[newindex].equalsIgnoreCase(XML_OUT)) {
                arguments.setXMLOut(true);
                return ++newindex;
            }
            if (args[newindex].equalsIgnoreCase(EXTENSIONS)) {
                arguments.setExtensions(args[newindex + 1]);
                return newindex += 2;
            }
        }
        newindex = super.processArgument(arguments, args, newindex);
        return newindex;
    }

    public class EGL2IRArguments
    extends EGLCArgumentProcessor.EGLCArguments {
        File systemRoot;
        public boolean xmlOut;
        String[] extensions;

        public EGL2IRArguments() {
            super(EGL2IRArgumentProcessor.this);
            this.systemRoot = null;
            this.xmlOut = false;
        }

        public File getSystemRoot() {
            return this.systemRoot;
        }

        protected void setSystemRoot(File root) {
            this.systemRoot = root;
        }

        public boolean getXMLOut() {
            return this.xmlOut;
        }

        public void setXMLOut(boolean value) {
            this.xmlOut = value;
        }

        public void setExtensions(String extensions) {
            this.extensions = extensions.split(",");
        }

        public String[] getExtensions() {
            return this.extensions;
        }
    }
}

