/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.List;
import org.eclipse.edt.compiler.AbstractProcessingQueue;
import org.eclipse.edt.compiler.EGL2IREnvironment;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.SDKContext;
import org.eclipse.edt.compiler.Util;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2Mof;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.Compiler;
import org.eclipse.edt.compiler.internal.sdk.compile.DefaultSDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.DependencyInfo;
import org.eclipse.edt.compiler.internal.sdk.compile.IProcessor;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.mof.MofSerializable;

public class Processor
extends AbstractProcessingQueue
implements IProcessor {
    private EGL2IREnvironment environment;
    private ISDKProblemRequestorFactory problemRequestorFactory;
    private ICompiler compiler;
    public static boolean skipSerialization;

    public Processor(IBuildNotifier notifier, ICompilerOptions compilerOptions, ISDKProblemRequestorFactory problemRequestorFactory, ICompiler compiler) {
        super(notifier, compilerOptions);
        this.problemRequestorFactory = problemRequestorFactory;
        if (problemRequestorFactory == null) {
            this.problemRequestorFactory = new DefaultSDKProblemRequestorFactory();
        }
        this.compiler = compiler;
    }

    public void setEnvironment(EGL2IREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public boolean hasExceededMaxLoop() {
        return false;
    }

    @Override
    public IPartBinding level03Compile(PackageAndPartName ppName) {
        IPartBinding binding;
        java.io.File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(ppName.getPackageName(), ppName.getPartName());
        Node partAST = ASTManager.getInstance().getAST(declaringFile, ppName.getPartName());
        if (partAST instanceof File) {
            File errorFile = ASTManager.getInstance().getFileAST(declaringFile);
            errorFile.accept(this.problemRequestorFactory.getSyntaxErrorRequestor(declaringFile));
        }
        if ((binding = this.environment.getNewPartBinding(ppName, Util.getPartType(partAST))).getKind() != 16 && binding.getKind() != 20) {
            System.out.println();
            System.out.println("Processing Part: " + ppName.getPartName());
        }
        binding.setEnvironment(this.environment);
        DependencyInfo dependencyInfo = new DependencyInfo();
        Scope scope = this.createPartScope(ppName.getPackageName(), declaringFile, binding, dependencyInfo);
        IProblemRequestor problemRequestor = this.problemRequestorFactory.getProblemRequestor(declaringFile, binding.getName());
        Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
        if (!skipSerialization && binding.getKind() != 16) {
            File fileAST = ASTManager.getInstance().getFileAST(declaringFile);
            try {
                MofSerializable part = this.createIRFromBoundAST2(partAST, declaringFile, fileAST.getImportDeclarations(), problemRequestor);
                if (part == null) {
                    System.out.println("Part is null!");
                    return binding;
                }
                this.environment.save(part, true);
            }
            catch (RuntimeException runtimeException) {
                problemRequestor.acceptProblem((Node)((Part)partAST).getName(), 3000, new String[]{((Part)partAST).getName().getCanonicalName()});
            }
        }
        return binding;
    }

    private Scope createPartScope(String packageName, java.io.File declaringFile, IPartBinding binding, IDependencyRequestor dependencyRequestor) {
        Scope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope(this.environment, dependencyRequestor);
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.environment.getPartBinding(packageName, fileName);
            scope = new FileScope(new EnvironmentScope(this.environment, dependencyRequestor), (FileBinding)fileBinding, dependencyRequestor);
        }
        return scope;
    }

    private MofSerializable createIRFromBoundAST2(Node partAST, java.io.File declaringFile, List imports, IProblemRequestor problemRequestor) {
        Egl2Mof generator = new Egl2Mof(this.environment);
        return (MofSerializable)generator.convert((Part)partAST, new SDKContext(declaringFile, this.compiler), problemRequestor);
    }

    @Override
    public IPartBinding level02Compile(PackageAndPartName ppName) {
        return SourcePathEntry.getInstance().compileLevel2Binding(ppName);
    }

    @Override
    public IPartBinding level01Compile(PackageAndPartName ppName) {
        return this.environment.level01Compile(ppName);
    }

    @Override
    public IPartBinding getPartBindingFromCache(String packageName, String partName) {
        return SourcePathEntry.getInstance().getPartBindingFromCache(packageName, partName);
    }

    @Override
    public void doAddPart(String packageName, String caseInsensitivePartName) {
        this.addPart(SourcePathInfo.getInstance().getPackageAndPartName(packageName, caseInsensitivePartName));
    }
}

