/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.math.BigDecimal;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.ETypedElement;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.NullLiteral;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.utils.EList;

public class AnnotationValueValidator {
    private static EType elistType;
    private static EType etypeType;
    IProblemRequestor problemRequestor;

    public AnnotationValueValidator(IProblemRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    public Object validateValue(Object value, Expression expr, EField field, EType eType, boolean nullable) {
        EClass typeClass;
        EClass valClass;
        EType etype;
        if (value instanceof Element && (etype = BindingUtil.getETypeFromProxy((Element)value)) != null) {
            value = etype;
        }
        if (!this.isValidExpressionForAnnotationValue(expr)) {
            this.problemRequestor.acceptProblem((Node)expr, 3127, new String[]{field.getName()});
            return null;
        }
        boolean valueIsList = value instanceof EList;
        boolean typeIsList = this.isGenericElistType(eType);
        if (valueIsList && !typeIsList) {
            this.problemRequestor.acceptProblem((Node)expr, 3290, new String[]{field.getName()});
            return null;
        }
        if (typeIsList && !valueIsList) {
            this.problemRequestor.acceptProblem((Node)expr, 3291, new String[]{field.getName()});
            return null;
        }
        if (value instanceof NullLiteral) {
            if (nullable) {
                return value;
            }
            this.problemRequestor.acceptProblem((Node)expr, 3292, new String[]{field.getName()});
            return null;
        }
        if (valueIsList && typeIsList) {
            EList listValue = (EList)value;
            ArrayLiteral arrayLit = (ArrayLiteral)expr;
            boolean foundError = false;
            int index = 0;
            EType currType = (EType)((EGenericType)eType).getETypeArguments().get(0);
            for (Object curValue : listValue) {
                Expression currExpr = arrayLit.getExpressions().get(index);
                if ((curValue = this.validateValue(curValue, currExpr, field, currType, true)) == null) {
                    foundError = true;
                }
                ++index;
            }
            if (foundError) {
                return null;
            }
            return value;
        }
        if (eType instanceof EDataType) {
            String className = ((EDataType)eType).getJavaClassName();
            if (className.equals("java.lang.Object")) {
                return value;
            }
            if (className.equals("java.lang.String")) {
                if (value instanceof String) {
                    return value;
                }
                this.problemRequestor.acceptProblem((Node)expr, 3293, new String[]{field.getName()});
                return null;
            }
            if (className.equals("java.lang.Boolean")) {
                if (value instanceof Boolean) {
                    return value;
                }
                this.problemRequestor.acceptProblem((Node)expr, 3294, new String[]{field.getName()});
                return null;
            }
            if (className.equals("java.lang.Integer")) {
                if (value instanceof Integer) {
                    return value;
                }
                this.problemRequestor.acceptProblem((Node)expr, 3295, new String[]{field.getName()});
                return null;
            }
            if (className.equals("java.lang.Float")) {
                if (value instanceof Double) {
                    return value;
                }
                this.problemRequestor.acceptProblem((Node)expr, 3296, new String[]{field.getName()});
                return null;
            }
            if (className.equals("java.math.BigDecimal")) {
                if (value instanceof BigDecimal) {
                    return value;
                }
                this.problemRequestor.acceptProblem((Node)expr, 3297, new String[]{field.getName()});
                return null;
            }
        }
        if (value instanceof ETypedElement && ((ETypedElement)value).getEType().equals(eType)) {
            return value;
        }
        if (expr.resolveType() != null && expr.resolveType().equals(eType)) {
            return value;
        }
        if (expr.resolveType() != null && expr.resolveType().getEClass().equals(eType)) {
            return value;
        }
        if (value instanceof EObject && eType instanceof EClass && this.isEqualOrSubclassOf(valClass = ((EObject)value).getEClass(), typeClass = (EClass)eType)) {
            return value;
        }
        if (eType != null && eType.equals(AnnotationValueValidator.getETypeType()) && (value instanceof Type || value instanceof EType)) {
            return value;
        }
        EObject eobject = null;
        if (value instanceof Classifier) {
            eobject = BindingUtil.getMofClassProxyFor((Classifier)value);
        }
        if (eobject == null && value instanceof EObject) {
            eobject = (EObject)value;
        }
        if (eobject instanceof EClass && eType instanceof EClass && this.isEqualOrSubclassOf((EClass)eobject, (EClass)eType)) {
            return value;
        }
        this.problemRequestor.acceptProblem((Node)expr, 3298, new String[]{field.getName()});
        return null;
    }

    private boolean isEqualOrSubclassOf(EClass child, EClass parent) {
        if (child == parent) {
            return true;
        }
        if (child == null || parent == null) {
            return false;
        }
        if (child.getETypeSignature().equals(parent.getETypeSignature())) {
            return true;
        }
        return BindingUtil.isSubClassOf(child, parent);
    }

    private boolean isValidExpressionForAnnotationValue(Expression expr) {
        final boolean[] valid = new boolean[]{true};
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(NewExpression newExpression) {
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(FunctionInvocation functionInvocation) {
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }
        };
        expr.accept(visitor);
        return valid[0];
    }

    private boolean isGenericElistType(EType type) {
        if (type instanceof EGenericType) {
            try {
                EType elistType = AnnotationValueValidator.getElistType();
                EClassifier eclassifier = ((EGenericType)type).getEClassifier();
                return elistType.equals(eclassifier);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static EType getElistType() {
        if (elistType == null) {
            try {
                elistType = (EType)Environment.getCurrentEnv().findType("org.eclipse.edt.mof.EList");
            }
            catch (Exception exception) {}
        }
        return elistType;
    }

    private static EType getETypeType() {
        if (etypeType == null) {
            try {
                etypeType = (EType)Environment.getCurrentEnv().findType("org.eclipse.edt.mof.EType");
            }
            catch (Exception exception) {}
        }
        return etypeType;
    }
}

