/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public class ExternalTypeBindingCompletor
extends FunctionContainerBindingCompletor {
    private ExternalType externalTypeBinding;

    public ExternalTypeBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(irBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.externalTypeBinding = (ExternalType)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ExternalType externalType) {
        externalType.getName().setType((Type)this.externalTypeBinding);
        externalType.accept(this.getPartSubTypeAndAnnotationCollector());
        if (externalType.isPrivate()) {
            this.externalTypeBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        this.externalTypeBinding.setIsAbstract(Boolean.valueOf(externalType.isAbstract()));
        this.processExtends(externalType);
        this.setDefaultSuperType();
        return true;
    }

    private void processExtends(org.eclipse.edt.compiler.core.ast.ExternalType externalType) {
        if (externalType.hasExtendedType()) {
            Iterator<Name> iter = externalType.getExtendedTypes().iterator();
            while (iter.hasNext()) {
                try {
                    Name name = iter.next();
                    Type typeBinding = this.bindTypeName(name);
                    if (!(typeBinding instanceof StructPart)) continue;
                    this.externalTypeBinding.getSuperTypes().add((StructPart)typeBinding);
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                }
            }
        }
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.ExternalType externalType) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(externalType);
    }

    @Override
    protected StereotypeType getDefaultStereotypeType() {
        return null;
    }
}

