/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.mof.egl.Annotation;

public class AnnotationExpression
extends Expression {
    private Name name;
    private Annotation annotation;

    public AnnotationExpression(Name name, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public String getCanonicalString() {
        return this.getName().getCanonicalString();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public Annotation resolveAnnotation() {
        return this.annotation;
    }

    @Override
    public Object resolveElement() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new AnnotationExpression((Name)this.name.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return "@" + this.getCanonicalString();
    }
}

