/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;

public class ClassDataDeclaration
extends Node {
    private boolean isPrivate;
    private boolean isStatic;
    private List<Name> ID_plus;
    private Type type;
    private boolean isNullable;
    private SettingsBlock settingsBlockOpt;
    private Expression initializerOpt;
    private boolean isConstant;

    public ClassDataDeclaration(Boolean privateAccessModifierOpt, Boolean staticAccessModifierOpt, List ID_plus, Type type, Boolean isNullable, SettingsBlock settingsBlockOpt, Expression initializerOpt, boolean isConstant, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.isPrivate = privateAccessModifierOpt;
        this.isStatic = staticAccessModifierOpt;
        this.ID_plus = this.setParent(ID_plus);
        this.type = type;
        type.setParent(this);
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        if (initializerOpt != null) {
            this.initializerOpt = initializerOpt;
            initializerOpt.setParent(this);
        }
        this.isConstant = isConstant;
        this.isNullable = isNullable;
    }

    public List<Name> getNames() {
        return this.ID_plus;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public SettingsBlock getSettingsBlockOpt() {
        return this.settingsBlockOpt;
    }

    public boolean hasInitializer() {
        return this.initializerOpt != null;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public Expression getInitializer() {
        return this.initializerOpt;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            ClassDataDeclaration.acceptChildren(visitor, this.ID_plus);
            this.type.accept(visitor);
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            if (this.initializerOpt != null) {
                this.initializerOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        Expression newInitializerOpt = this.initializerOpt != null ? (Expression)this.initializerOpt.clone() : null;
        return new ClassDataDeclaration(new Boolean(this.isPrivate), new Boolean(this.isStatic), this.cloneList(this.ID_plus), (Type)this.type.clone(), this.isNullable, newSettingsBlockOpt, newInitializerOpt, this.isConstant, this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        if (this.isPrivate) {
            buf.append("private ");
        }
        if (this.isStatic) {
            buf.append("static ");
        }
        if (this.isConstant) {
            buf.append("const ");
        }
        boolean first = true;
        for (Name name : this.ID_plus) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(name.getCaseSensitiveIdentifier());
        }
        buf.append(' ');
        buf.append(this.type.toString());
        if (this.isNullable) {
            buf.append('?');
        }
        if (this.settingsBlockOpt != null) {
            buf.append(this.settingsBlockOpt.toString());
        }
        if (this.initializerOpt != null) {
            buf.append(" = ");
            buf.append(this.initializerOpt.toString());
        }
        buf.append(';');
        return buf.toString();
    }
}

