/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.mof.utils.NameUtile;

public class FieldAccess
extends Expression {
    private Expression primary;
    private String ID;
    private Object element;

    public FieldAccess(Expression primary, String ID, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.primary = primary;
        primary.setParent(this);
        this.ID = ID;
    }

    public Expression getPrimary() {
        return this.primary;
    }

    public String getID() {
        return NameUtile.getAsName((String)this.ID);
    }

    @Override
    public String getCaseSensitiveID() {
        return this.ID;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.primary.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void setElement(Object elem) {
        this.element = elem;
        super.setElement(elem);
    }

    @Override
    public Object resolveElement() {
        return this.element;
    }

    @Override
    public String getCanonicalString() {
        return String.valueOf(this.getPrimary().getCanonicalString()) + "." + this.ID;
    }

    @Override
    public void setAttributeOnName(int attr, Object value) {
        this.primary.setAttributeOnName(attr, value);
    }

    @Override
    public Object getAttributeFromName(int attr) {
        return this.primary.getAttributeFromName(attr);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new FieldAccess((Expression)this.primary.clone(), new String(this.ID), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return String.valueOf(this.getPrimary().toString()) + "." + this.ID;
    }
}

