/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;

public class GetByPositionStatement
extends Statement {
    private Direction direction;
    private boolean inparent;
    private GetByPositionSource getByPositionSource;
    private List getByPositionOptions;

    public GetByPositionStatement(Direction direction, Boolean inparentOpt, GetByPositionSource getByPositionSource, List getByPositionOptions, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.direction = direction;
        direction.setParent(this);
        this.inparent = inparentOpt;
        this.getByPositionSource = getByPositionSource;
        getByPositionSource.setParent(this);
        this.getByPositionOptions = this.setParent(getByPositionOptions);
    }

    public boolean isNextDirection() {
        return this.direction == DefaultDirection.NEXT;
    }

    public boolean isPreviousDirection() {
        return this.direction == DefaultDirection.PREVIOUS;
    }

    public boolean isFirstDirection() {
        return this.direction == DefaultDirection.FIRST;
    }

    public boolean isLastDirection() {
        return this.direction == DefaultDirection.LAST;
    }

    public boolean isCurrentDirection() {
        return this.direction == DefaultDirection.CURRENT;
    }

    public boolean isRelativeDirection() {
        return this.direction.isRelative();
    }

    public boolean isAbsoluteDirection() {
        return this.direction.isAbsolute();
    }

    public boolean hasPosition() {
        return this.direction.hasExpression();
    }

    public Expression getPosition() {
        return this.direction.getExpression();
    }

    public boolean hasFromExpr() {
        return this.getByPositionSource.hasFromExpr();
    }

    public Expression getFromExpr() {
        return this.getByPositionSource.getFromExpr();
    }

    public boolean hasTargetRecords() {
        return this.getByPositionSource.hasExpressions();
    }

    public List getTargetRecords() {
        return this.getByPositionSource.getExpressions();
    }

    public List getTargets() {
        return this.getTargetRecords();
    }

    public boolean isGetInParent() {
        return this.inparent;
    }

    public List getGetByPositionOptions() {
        return this.getByPositionOptions;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.direction.accept(visitor);
            this.getByPositionSource.accept(visitor);
            GetByPositionStatement.acceptChildren(visitor, this.getByPositionOptions);
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        return this.hasTargetRecords() ? this.getTargetRecords() : Collections.EMPTY_LIST;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new GetByPositionStatement((Direction)this.direction.clone(), new Boolean(this.inparent), (GetByPositionSource)this.getByPositionSource.clone(), this.cloneList(this.getByPositionOptions), this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class AbsoluteDirection
    extends ExpressionDirection {
        public AbsoluteDirection(Expression expr) {
            super(expr);
        }

        @Override
        boolean isAbsolute() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new AbsoluteDirection((Expression)this.expr.clone());
        }
    }

    public static class DefaultDirection
    extends Direction {
        public static final DefaultDirection NEXT = new DefaultDirection();
        public static final DefaultDirection PREVIOUS = new DefaultDirection();
        public static final DefaultDirection FIRST = new DefaultDirection();
        public static final DefaultDirection LAST = new DefaultDirection();
        public static final DefaultDirection CURRENT = new DefaultDirection();

        private DefaultDirection() {
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return this;
        }
    }

    public static abstract class Direction
    implements Cloneable {
        boolean isRelative() {
            return false;
        }

        boolean isAbsolute() {
            return false;
        }

        boolean hasExpression() {
            return false;
        }

        Expression getExpression() {
            return null;
        }

        void setParent(Node parent) {
        }

        void accept(IASTVisitor visitor) {
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static abstract class ExpressionDirection
    extends Direction {
        Expression expr;

        public ExpressionDirection(Expression expr) {
            this.expr = expr;
        }

        @Override
        boolean hasExpression() {
            return true;
        }

        @Override
        Expression getExpression() {
            return this.expr;
        }

        @Override
        void setParent(Node parent) {
            this.expr.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.expr.accept(visitor);
        }

        @Override
        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class ExpressionFromResultSetSource
    extends GetByPositionSource {
        Expression expr;
        Expression fromExpr;

        public ExpressionFromResultSetSource(Expression expr, Expression fromExpr) {
            this.expr = expr;
            this.fromExpr = fromExpr;
        }

        @Override
        boolean hasExpressions() {
            return true;
        }

        @Override
        List getExpressions() {
            return Arrays.asList(this.expr);
        }

        @Override
        boolean hasFromExpr() {
            return true;
        }

        @Override
        Expression getFromExpr() {
            return this.fromExpr;
        }

        @Override
        void setParent(Node parent) {
            this.expr.setParent(parent);
            this.fromExpr.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.expr.accept(visitor);
            this.fromExpr.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ExpressionFromResultSetSource((Expression)this.expr.clone(), (Expression)this.fromExpr.clone());
        }
    }

    public static class ExpressionListSource
    extends GetByPositionSource {
        List exprList;

        public ExpressionListSource(List exprList) {
            this.exprList = exprList;
        }

        @Override
        boolean hasExpressions() {
            return true;
        }

        @Override
        List getExpressions() {
            return this.exprList;
        }

        @Override
        void setParent(Node parent) {
            Iterator iter = this.exprList.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setParent(parent);
            }
        }

        @Override
        void accept(IASTVisitor visitor) {
            Iterator iter = this.exprList.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).accept(visitor);
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            ArrayList<Object> newExprList = new ArrayList<Object>();
            Iterator iter = this.exprList.iterator();
            while (iter.hasNext()) {
                newExprList.add(((Expression)iter.next()).clone());
            }
            return new ExpressionListSource(newExprList);
        }
    }

    public static class FromResultSetSource
    extends GetByPositionSource {
        Expression expression;

        public FromResultSetSource(Expression expression) {
            this.expression = expression;
        }

        @Override
        boolean hasFromExpr() {
            return true;
        }

        @Override
        Expression getFromExpr() {
            return this.expression;
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.expression.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new FromResultSetSource((Expression)this.expression.clone());
        }
    }

    public static abstract class GetByPositionSource
    implements Cloneable {
        boolean hasExpressions() {
            return false;
        }

        boolean hasFromExpr() {
            return false;
        }

        List getExpressions() {
            return null;
        }

        Expression getFromExpr() {
            return null;
        }

        void setParent(Node parent) {
        }

        void accept(IASTVisitor visitor) {
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class RelativeDirection
    extends ExpressionDirection {
        public RelativeDirection(Expression expr) {
            super(expr);
        }

        @Override
        boolean isRelative() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new RelativeDirection((Expression)this.expr.clone());
        }
    }
}

