/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Type;

public class NameType
extends Type {
    private Name name;
    private List<Expression> arguments;

    public NameType(Name name, List<Expression> arguments, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
        if (arguments == null) {
            arguments = Collections.emptyList();
        }
        this.arguments = this.setParent(arguments);
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public boolean isNameType() {
        return true;
    }

    @Override
    public org.eclipse.edt.mof.egl.Type resolveType() {
        return this.name.resolveType();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            NameType.acceptChildren(visitor, this.arguments);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        if (this.arguments == null || this.arguments.size() == 0) {
            return this.name.getCanonicalName();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.name.getCanonicalName());
        buf.append('(');
        int i = 0;
        while (i < this.arguments.size()) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.arguments.get(i));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.size() > 0;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new NameType((Name)this.name.clone(), this.cloneList(this.arguments), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public Type getBaseType() {
        return this;
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

