/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class NonTerminalSubstitutionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int missingNonTerminal;

    public NonTerminalSubstitutionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        short[] nonterminalCandidates = this.errorStack.getNonTerminalCandidates(this.errorStack.getCurrentState());
        int i = 0;
        while (i < nonterminalCandidates.length) {
            ParseStack trialStack = this.errorStack.createCopy();
            ITokenStream trialStream = this.tokenStream.createTokenStreamAtOffset(1);
            trialStack.processNonTerminal(nonterminalCandidates[i]);
            int trialDistance = trialStack.parseCheck(trialStream);
            if (trialDistance > this.parseCheckDistance) {
                this.parseCheckDistance = trialDistance;
                this.missingNonTerminal = nonterminalCandidates[i];
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance + 1;
    }

    @Override
    public int performRecovery() {
        Terminal lookAhead = this.tokenStream.getLookAhead();
        int left = lookAhead.left;
        int right = lookAhead.right;
        int errorNodeType = this.tokenStream.peekLookAhead((int)0).symbolType;
        this.tokenStream.advanceLookAhead();
        int lookAheadTerminalType = this.tokenStream.getLookAhead().symbolType;
        ParseStack newStack = this.errorStack.createCopy();
        newStack.processNonTerminal(this.missingNonTerminal);
        int highestNonTerminalType = newStack.getHighestNonTerminal(lookAheadTerminalType);
        if (lookAhead.symbolType == 0) {
            Symbol lastRealSymbol = this.getLastRealSymbol(this.realStack);
            this.problemRequestor.incorrectNonTerminal(highestNonTerminalType, lastRealSymbol.left, lastRealSymbol.right);
        } else if (51 == highestNonTerminalType && EGLKeywordHandler.getKeywordHashSet().contains(NodeNameUtility.getTerminalName(errorNodeType).toLowerCase())) {
            this.problemRequestor.keywordAsName(errorNodeType, left, right);
        } else {
            this.problemRequestor.incorrectNonTerminal(highestNonTerminalType, left, right);
        }
        int currentState = this.errorStack.getCurrentState();
        short gotoState = this.errorStack.get_reduce(currentState, highestNonTerminalType);
        Symbol nonTerminal = new Symbol(highestNonTerminalType, gotoState);
        this.realStack.push(nonTerminal);
        this.errorStack.processNonTerminal(highestNonTerminalType);
        return this.realStack.size() - 1;
    }
}

