/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Statement;

public class WhileStatement
extends Statement {
    private Expression expr;
    private List stmts;

    public WhileStatement(Expression expr, List stmts, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.stmts = this.setParent(stmts);
    }

    public Expression getExpr() {
        return this.expr;
    }

    public List getStmts() {
        return this.stmts;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            WhileStatement.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    public List getStatementBlocks() {
        return Arrays.asList(this.stmts);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new WhileStatement((Expression)this.expr.clone(), this.cloneList(this.stmts), this.getOffset(), this.getOffset() + this.getLength());
    }
}

