/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.MemberScope;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class AbstractBinder
extends AbstractASTVisitor {
    protected Scope currentScope;
    protected IDependencyRequestor dependencyRequestor;
    protected Part currentBinding;
    protected String packageName;
    protected ICompilerOptions compilerOptions;

    public AbstractBinder(Scope currentScope, String packageName, IDependencyRequestor dependencyRequestor, ICompilerOptions compilerOptions) {
        this.currentScope = currentScope;
        this.packageName = packageName;
        this.currentBinding = null;
        this.dependencyRequestor = dependencyRequestor;
        this.compilerOptions = compilerOptions;
    }

    public AbstractBinder(Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, ICompilerOptions compilerOptions) {
        this.currentScope = currentScope;
        this.packageName = currentBinding.getPackageName();
        this.currentBinding = currentBinding;
        this.dependencyRequestor = dependencyRequestor;
        this.compilerOptions = compilerOptions;
    }

    public org.eclipse.edt.mof.egl.Type bindType(Type type) throws ResolutionException {
        return this.bindType(type, false);
    }

    public org.eclipse.edt.mof.egl.Type bindType(Type type, boolean bindingNewExpr) throws ResolutionException {
        switch (type.getKind()) {
            case 1: {
                ArrayType arrayType = (ArrayType)type;
                org.eclipse.edt.mof.egl.Type elementType = this.bindType(arrayType.getElementType());
                org.eclipse.edt.mof.egl.ArrayType arrayTypeBinding = BindingUtil.getArrayType(elementType, arrayType.isNullable());
                arrayType.setType(arrayTypeBinding);
                return arrayTypeBinding;
            }
            case 0: {
                org.eclipse.edt.mof.egl.Type parmType;
                NameType nameType = (NameType)type;
                org.eclipse.edt.mof.egl.Type result = this.bindTypeName(nameType.getName());
                if (result != null && nameType.getArguments() != null && nameType.getArguments().size() > 0 && (parmType = this.getParameterizedType(nameType, bindingNewExpr)) != result) {
                    result = parmType;
                    nameType.getName().setType(result);
                }
                return result;
            }
        }
        throw new RuntimeException("Shouldn't come into here");
    }

    private org.eclipse.edt.mof.egl.Type getParameterizedType(NameType nameType, boolean bindingNewExpr) throws ResolutionException {
        org.eclipse.edt.mof.egl.Type baseType = nameType.resolveType();
        if (!BindingUtil.isParameterizableType(baseType)) {
            if (bindingNewExpr) {
                return baseType;
            }
            throw new ResolutionException(nameType.getName().getOffset(), nameType.getName().getOffset() + nameType.getName().getLength(), 3281, new String[]{nameType.getName().getCanonicalName()});
        }
        ParameterizableType parmableType = (ParameterizableType)baseType;
        EClass parameterizedTypeClass = parmableType.getParameterizedType();
        if (parameterizedTypeClass != null) {
            ParameterizedType type = (ParameterizedType)parameterizedTypeClass.newInstance();
            List<String> args = this.getTypeArguments(nameType);
            if (args.size() > type.getMaxNumberOfParms() || args.size() < type.getMinNumberOfParms()) {
                throw new ResolutionException(nameType.getOffset(), nameType.getOffset() + nameType.getLength(), 3283, new String[]{nameType.getName().getCanonicalName()});
            }
            type.setParameterizableType(parmableType);
            int argIndex = 0;
            for (String arg : args) {
                int fieldIndex = parameterizedTypeClass.getAllEFields().size() - type.getMaxNumberOfParms() + argIndex;
                try {
                    EField field = (EField)parameterizedTypeClass.getAllEFields().get(fieldIndex);
                    Object converted = MofFactory.INSTANCE.createFromString((EDataType)field.getEType(), arg);
                    type.eSet(field, converted);
                }
                catch (Exception exception) {
                    Expression expr = nameType.getArguments().get(argIndex);
                    throw new ResolutionException(expr.getOffset(), expr.getOffset() + expr.getLength(), 3282, new String[]{expr.getCanonicalString(), nameType.getName().getCanonicalName()});
                }
                ++argIndex;
            }
            return type;
        }
        return baseType;
    }

    private List<String> getTypeArguments(NameType nameType) throws ResolutionException {
        List<Expression> args = nameType.getArguments();
        ArrayList<String> list = new ArrayList<String>();
        for (Expression expr : args) {
            final boolean[] isValid = new boolean[1];
            final String[] value = new String[1];
            final boolean[] negative = new boolean[1];
            expr.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(IntegerLiteral integerLiteral) {
                    isValid[0] = true;
                    value[0] = integerLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    isValid[0] = true;
                    value[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(BooleanLiteral booleanLiteral) {
                    isValid[0] = true;
                    value[0] = booleanLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(DecimalLiteral decimalLiteral) {
                    isValid[0] = true;
                    value[0] = decimalLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(FloatLiteral floatLiteral) {
                    isValid[0] = true;
                    value[0] = floatLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                        negative[0] = !negative[0];
                    } else if (unaryExpression.getOperator() != UnaryExpression.Operator.PLUS) {
                        isValid[0] = false;
                        return false;
                    }
                    return true;
                }
            });
            if (!isValid[0]) {
                throw new ResolutionException(expr.getOffset(), expr.getOffset() + expr.getLength(), 3282, new String[]{expr.getCanonicalString(), nameType.getName().getCanonicalName()});
            }
            if (negative[0]) {
                value[0] = "-" + value[0];
            }
            list.add(value[0]);
        }
        return list;
    }

    public org.eclipse.edt.mof.egl.Type bindTypeName(Name name) throws ResolutionException {
        Object result = null;
        if (name.isSimpleName()) {
            List<org.eclipse.edt.mof.egl.Type> types = this.currentScope.findType(name.getIdentifier());
            if (types == null) {
                result = BindingUtil.findAliasedType(name.getIdentifier());
            } else {
                if (types.size() > 1) {
                    name.setBindAttempted(true);
                    this.dependencyRequestor.recordName(name);
                    int[] errorOffsets = this.getLastIdentifierOffsets(name);
                    throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3262, new String[]{name.getCanonicalName()});
                }
                result = types.get(0);
            }
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            IPackageBinding packageBinding = this.bindPackageName(qualifiedName.getQualifier());
            Part part = BindingUtil.getPart(packageBinding.resolveType(qualifiedName.getIdentifier()));
            if (part != null) {
                result = BindingUtil.isPrivate(part) && !NameUtile.equals((String)part.getPackageName(), (String)this.packageName) ? null : part;
            }
        }
        if (result == null) {
            name.setBindAttempted(true);
            this.dependencyRequestor.recordName(name);
            int[] errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3260, new String[]{name.getCanonicalName()});
        }
        this.dependencyRequestor.recordType((org.eclipse.edt.mof.egl.Type)result);
        name.setType((org.eclipse.edt.mof.egl.Type)result);
        return result;
    }

    public Object bindExpressionName(Name name) throws ResolutionException {
        return this.bindExpressionName(name, false);
    }

    private List<Member> removePrivateMembersNotInCurrentPart(List<Member> list) {
        if (list == null || this.currentBinding == null) {
            return list;
        }
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member mbr : list) {
            if (mbr.getAccessKind() == AccessKind.ACC_PRIVATE) {
                if (!this.isContainedBy(mbr, (Element)this.currentBinding)) continue;
                result.add(mbr);
                continue;
            }
            result.add(mbr);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    private boolean isContainedBy(Member mbr, Element container) {
        if (mbr.getContainer() == container) {
            return true;
        }
        if (mbr.getContainer() instanceof org.eclipse.edt.mof.egl.Type && container instanceof org.eclipse.edt.mof.egl.Type && ((org.eclipse.edt.mof.egl.Type)mbr.getContainer()).equals((org.eclipse.edt.mof.egl.Type)container).booleanValue()) {
            return true;
        }
        if (mbr.getContainer() instanceof Member) {
            return this.isContainedBy((Member)mbr.getContainer(), container);
        }
        return false;
    }

    public Object bindExpressionName(Name name, boolean isFunctionInvocation) throws ResolutionException {
        int[] errorOffsets;
        List<Member> result = null;
        if (name.isSimpleName()) {
            List<Member> mbrs = this.currentScope.findMember(name.getIdentifier());
            result = mbrs = this.removePrivateMembersNotInCurrentPart(mbrs);
            if (result == null) {
                result = this.currentScope.findType(name.getIdentifier());
            }
        } else {
            org.eclipse.edt.mof.egl.Type type;
            QualifiedName qualifiedName = (QualifiedName)name;
            Name qualifier = qualifiedName.getQualifier();
            String identifier = qualifiedName.getIdentifier();
            Object binding = this.bindUnknownName(qualifier);
            if (binding instanceof Member) {
                Member dynMbr;
                Member member = (Member)binding;
                org.eclipse.edt.mof.egl.Type type2 = BindingUtil.getType(member);
                result = this.findData(type2, identifier);
                if (result == null && (dynMbr = BindingUtil.createExplicitDynamicAccessMember(type2, qualifiedName.getCaseSensitiveIdentifier())) != null) {
                    ArrayList<Member> list = new ArrayList<Member>();
                    list.add(dynMbr);
                    result = list;
                }
            } else if (binding instanceof org.eclipse.edt.mof.egl.Type && (result = this.findData(type = (org.eclipse.edt.mof.egl.Type)binding, identifier)) == null) {
                try {
                    binding = this.bindPackageName(qualifier);
                }
                catch (ResolutionException resolutionException) {}
            }
            if (binding instanceof IPackageBinding) {
                Part resolvedPart;
                IPackageBinding packageBinding = (IPackageBinding)binding;
                if (identifier != null && identifier.length() > 0) {
                    this.dependencyRequestor.recordSimpleName(identifier);
                }
                if ((resolvedPart = BindingUtil.getPart(packageBinding.resolveType(identifier))) != null) {
                    if (!NameUtile.equals((String)resolvedPart.getPackageName(), (String)this.packageName) && BindingUtil.isPrivate(resolvedPart)) {
                        this.dependencyRequestor.recordName(new QualifiedName(qualifier, name.getIdentifier(), qualifier.getOffset(), name.getOffset() + name.getLength()));
                        result = null;
                    } else {
                        ArrayList<Member> tempList = new ArrayList<Member>();
                        tempList.add((Member)resolvedPart);
                        result = tempList;
                    }
                } else {
                    this.dependencyRequestor.recordName(new QualifiedName(qualifier, name.getIdentifier(), qualifier.getOffset(), name.getOffset() + name.getLength()));
                    result = null;
                }
            }
        }
        if (result == null) {
            name.setBindAttempted(true);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6619, new String[]{name.getCanonicalName()});
        }
        if (!(result.size() <= 1 || this.isFunctionSet(result) && isFunctionInvocation)) {
            name.setBindAttempted(true);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6620, new String[]{name.getCanonicalName()});
        }
        if (result.size() == 1) {
            Member value = result.get(0);
            name.setElement(value);
            org.eclipse.edt.mof.egl.Type type = BindingUtil.getType((Object)value);
            name.setType(type);
            if (type != null) {
                this.dependencyRequestor.recordType(type);
            }
            return value;
        }
        name.setElement(result);
        return result;
    }

    private int[] getLastIdentifierOffsets(Name name) {
        if (name.isQualifiedName()) {
            String id = name.getIdentifier();
            int endOffset = name.getOffset() + name.getLength();
            return new int[]{endOffset - id.length(), endOffset};
        }
        return new int[]{name.getOffset(), name.getOffset() + name.getLength()};
    }

    public IPackageBinding bindPackageName(Name name) throws ResolutionException {
        IPackageBinding result;
        if (name.isSimpleName()) {
            result = this.currentScope.findPackage(name.getIdentifier());
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            IPackageBinding packageBinding = this.bindPackageName(qualifiedName.getQualifier());
            result = packageBinding.resolvePackage(qualifiedName.getIdentifier());
        }
        if (result == null) {
            this.dependencyRequestor.recordName(name);
            throw new ResolutionException(name, 6619, new String[]{name.getCanonicalName()});
        }
        name.setElement(result);
        this.dependencyRequestor.recordPackageBinding(result);
        return result;
    }

    private Object bindUnknownName(Name name) throws ResolutionException {
        int[] errorOffsets;
        String identifier = name.getIdentifier();
        List<Member> result = null;
        if (name.isSimpleName()) {
            IPackageBinding pkg;
            org.eclipse.edt.mof.egl.Type type;
            List<Member> mbrs;
            result = mbrs = this.currentScope.findMember(identifier);
            if (mbrs != null && mbrs.size() == 1) {
                Member mbr = mbrs.get(0);
                type = BindingUtil.getType(mbr);
                name.setType(type);
                if (type != null) {
                    this.dependencyRequestor.recordType(type);
                }
            }
            if (result == null) {
                List<org.eclipse.edt.mof.egl.Type> types = this.currentScope.findType(identifier);
                result = types;
                if (types != null && types.size() == 1) {
                    type = types.get(0);
                    name.setType(type);
                }
            }
            if (result == null && (pkg = this.currentScope.findPackage(identifier)) != null) {
                ArrayList<Member> list = new ArrayList<Member>();
                list.add((Member)pkg);
                result = list;
            }
        } else {
            org.eclipse.edt.mof.egl.Type type;
            ArrayList<Member> list;
            QualifiedName qualifiedName = (QualifiedName)name;
            Name qualifier = qualifiedName.getQualifier();
            Object object = this.bindUnknownName(qualifier);
            if (object == null) {
                return null;
            }
            if (object instanceof Member) {
                Member dynMbr;
                Member member = (Member)object;
                org.eclipse.edt.mof.egl.Type type2 = BindingUtil.getType(member);
                result = this.findData(type2, identifier);
                if (result == null && (dynMbr = BindingUtil.createExplicitDynamicAccessMember(type2, qualifiedName.getCaseSensitiveIdentifier())) != null) {
                    list = new ArrayList<Member>();
                    list.add(dynMbr);
                    result = list;
                }
            } else if (object instanceof org.eclipse.edt.mof.egl.Type && (result = this.findData(type = (org.eclipse.edt.mof.egl.Type)object, identifier)) == null) {
                try {
                    object = this.bindPackageName(qualifier);
                }
                catch (ResolutionException resolutionException) {}
            }
            if (object instanceof IPackageBinding) {
                IPackageBinding pkg;
                IPackageBinding packageBinding = (IPackageBinding)object;
                Part part = BindingUtil.getPart(packageBinding.resolveType(identifier));
                if (part != null) {
                    if (part.getAccessKind() == AccessKind.ACC_PRIVATE && !NameUtile.equals((String)part.getPackageName(), (String)this.packageName)) {
                        result = null;
                    } else {
                        name.setType((org.eclipse.edt.mof.egl.Type)part);
                        ArrayList<Member> list2 = new ArrayList<Member>();
                        list2.add((Member)part);
                        result = list2;
                    }
                }
                if (result == null && (pkg = packageBinding.resolvePackage(identifier)) != null) {
                    list = new ArrayList();
                    list.add((Member)pkg);
                    result = list;
                }
            }
        }
        if (result == null) {
            name.setBindAttempted(true);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 6619, new String[]{name.getCanonicalName()});
        }
        if (result.size() > 1) {
            name.setBindAttempted(true);
            this.dependencyRequestor.recordName(name);
            errorOffsets = this.getLastIdentifierOffsets(name);
            throw new ResolutionException(errorOffsets[0], errorOffsets[1], 3262, new String[]{name.getCanonicalName()});
        }
        Member value = result.get(0);
        name.setElement(value);
        org.eclipse.edt.mof.egl.Type type = BindingUtil.getType((Object)value);
        name.setType(type);
        if (type != null) {
            this.dependencyRequestor.recordType(type);
        }
        return value;
    }

    public void bindInvocationTarget(Expression invocationTarget) {
        final AbstractBinder thisVisitor = this;
        invocationTarget.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisit(StringLiteral stringLiteral) {
                this.bindFromString(stringLiteral, stringLiteral.getValue());
            }

            private void bindFromString(Expression expr, String value) {
                org.eclipse.edt.mof.egl.Type result = null;
                Name name = new ExpressionParser(AbstractBinder.this.compilerOptions).parseAsName(value);
                if (name != null) {
                    try {
                        result = AbstractBinder.this.bindTypeName(name);
                        if (result != null) {
                            AbstractBinder.this.dependencyRequestor.recordType(result);
                        }
                    }
                    catch (ResolutionException resolutionException) {}
                }
                expr.setType(result);
            }

            @Override
            public void endVisitExpression(Expression expression) {
                expression.accept(thisVisitor);
            }
        });
    }

    protected List<Member> findData(org.eclipse.edt.mof.egl.Type aType, String identifier) {
        if (aType == null) {
            return null;
        }
        List<Member> result = null;
        Classifier type = aType.getClassifier();
        if (type != null && type.equals((org.eclipse.edt.mof.egl.Type)this.currentBinding).booleanValue()) {
            result = BindingUtil.findMembers((org.eclipse.edt.mof.egl.Type)type, identifier);
            result = this.removePrivateMembersNotInCurrentPart(result);
        } else {
            result = BindingUtil.findPublicMembers((org.eclipse.edt.mof.egl.Type)type, identifier);
        }
        if (result != null) {
            return result;
        }
        org.eclipse.edt.mof.egl.Type baseType = BindingUtil.getBaseType(aType);
        if (aType != baseType) {
            return this.findData(baseType, identifier);
        }
        return null;
    }

    protected static void setBindAttemptedForNames(Node node) {
        node.accept(new AbstractASTVisitor(){

            @Override
            public void endVisit(SimpleName simpleName) {
                simpleName.setBindAttempted(true);
            }

            @Override
            public void endVisit(QualifiedName qualifiedName) {
                qualifiedName.setBindAttempted(true);
            }
        });
    }

    protected void processSettingsBlock(ClassDataDeclaration classDataDeclaration, Part functionContainerBinding, Scope functionContainerScope, IProblemRequestor problemRequestor) {
        for (Name name : classDataDeclaration.getNames()) {
            if (!classDataDeclaration.hasSettingsBlock() || name.resolveMember() == null) continue;
            Member member = name.resolveMember();
            MemberScope scope = new MemberScope(NullScope.INSTANCE, member);
            AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(scope, (Element)member, member.getType(), (Element)member);
            Scope fcScope = functionContainerScope;
            classDataDeclaration.getSettingsBlockOpt().accept(new SettingsBlockAnnotationBindingsCompletor(fcScope, functionContainerBinding, annotationScope, this.dependencyRequestor, problemRequestor, this.compilerOptions));
        }
    }

    public boolean isFunctionSet(List<?> list) {
        if (list == null) {
            return false;
        }
        for (Object obj : list) {
            if (obj instanceof Function) continue;
            return false;
        }
        return true;
    }

    protected Annotation getAnnotation(AnnotationExpression annotationExpression, IProblemRequestor problemRequestor) {
        Annotation ann;
        org.eclipse.edt.mof.egl.Type type = null;
        try {
            type = this.bindTypeName(annotationExpression.getName());
        }
        catch (ResolutionException e) {
            problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return null;
        }
        if (type == null || !(type instanceof AnnotationType)) {
            problemRequestor.acceptProblem((Node)annotationExpression, 2065, new String[]{annotationExpression.getCanonicalString()});
            annotationExpression.getName().setType(null);
            return null;
        }
        if (annotationExpression.getName().resolveElement() instanceof Annotation) {
            ann = (Annotation)annotationExpression.getName().resolveElement();
        } else {
            ann = (Annotation)((AnnotationType)type).newInstance();
            annotationExpression.getName().setElement(ann);
            annotationExpression.setAnnotation(ann);
        }
        annotationExpression.setType(type);
        annotationExpression.getName().setType(type);
        return ann;
    }
}

