/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class PropertyApplicableForCertainPrimitiveTypeOnlyAnnotationValidator
extends AnnotationValidationRule {
    protected String canonicalAnnotationName;

    protected PropertyApplicableForCertainPrimitiveTypeOnlyAnnotationValidator(String canonicalAnnotationName) {
        super(NameUtile.getAsCaseSensitiveName((String)"PropertyApplicableForCertainPrimitiveOnly"));
        this.canonicalAnnotationName = canonicalAnnotationName;
    }

    @Override
    public void validate(Node errorNode, Node target, Element targetElement, Map<String, Object> allAnnotationsAndFields, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        Annotation annotationBinding = (Annotation)allAnnotationsAndFields.get(NameUtile.getAsName((String)this.canonicalAnnotationName));
        if (annotationBinding != null && annotationBinding.getValue() != null) {
            Type type = null;
            if (targetElement instanceof Type) {
                type = (Type)targetElement;
            } else if (targetElement instanceof TypedElement) {
                type = ((TypedElement)targetElement).getType();
            }
            if (type != null) {
                this.validateType(errorNode, annotationBinding, problemRequestor, type, this.getCanonicalName(target));
            }
        }
    }

    protected abstract void validateType(Node var1, Annotation var2, IProblemRequestor var3, Type var4, String var5);

    private String getCanonicalName(Node node) {
        final String[] result = new String[]{""};
        node.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                result[0] = structureItem.getName().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(SimpleName simpleName) {
                result[0] = simpleName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                result[0] = qualifiedName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                result[0] = dataItem.getName().getCanonicalName();
                return false;
            }
        });
        return result[0];
    }
}

