/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IInvocationValidationRule;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;

public class ThrowsInvocationValidator
implements IInvocationValidationRule {
    private static final String JavaObjectExceptionMofKey = NameUtile.getAsName((String)"egl:eglx.java.JavaObjectException");
    private List<StructPart> validExceptions = new ArrayList<StructPart>();

    @Override
    public void validate(Node node, Element element, Part declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (node == null || declaringPart == null || element == null) {
            return;
        }
        Type joe = TypeUtils.getType((String)JavaObjectExceptionMofKey);
        if (joe instanceof StructPart) {
            this.buildAllValidExceptions(this.validExceptions, (StructPart)joe);
        }
        if (!this.isInTryCatchException(node)) {
            problemRequestor.acceptProblem(node, 3428, new String[0]);
        }
    }

    private boolean isInTryCatchException(Node node) {
        TryStatement tryStmt = this.getTryStatement(node);
        if (tryStmt == null) {
            return false;
        }
        if (this.hasCatchException(tryStmt)) {
            return true;
        }
        return this.isInTryCatchException(tryStmt.getParent());
    }

    private boolean hasCatchException(TryStatement tryStmt) {
        List<Node> blocks = tryStmt.getOnExceptionBlocks();
        if (blocks.size() == 0) {
            return true;
        }
        for (Node node : blocks) {
            org.eclipse.edt.compiler.core.ast.Type type = ((OnExceptionBlock)node).getExceptionType();
            if (type == null || !this.validExceptions.contains(type.resolveType())) continue;
            return true;
        }
        return false;
    }

    private TryStatement getTryStatement(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof TryStatement) {
            return (TryStatement)node;
        }
        if (node instanceof OnExceptionBlock) {
            if (node.getParent() != null) {
                return this.getTryStatement(node.getParent().getParent());
            }
            return null;
        }
        return this.getTryStatement(node.getParent());
    }

    private void buildAllValidExceptions(List<StructPart> list, StructPart baseException) {
        if (baseException == null || list.contains(baseException)) {
            return;
        }
        list.add(baseException);
        for (StructPart superType : baseException.getSuperTypes()) {
            this.buildAllValidExceptions(list, superType);
        }
    }
}

