/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SetStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.CaseStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ContinueStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ExitStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ForStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FunctionDataDeclarationValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.GotoStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IfStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.LabelStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.MoveStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ReturnStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SetStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ThrowStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.TryStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.WhileStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.utils.NameUtile;

public class FunctionValidator
extends AbstractASTVisitor {
    IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;
    private String functionName;
    private HashMap labelMap = new HashMap();
    private ArrayList gotoList = new ArrayList();
    ICompilerOptions compilerOptions;
    private boolean nextStatementIsUnreachable;
    private LabelStatement labelPrecedingStatement;
    private Map labeledLoops = new HashMap();

    public FunctionValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        this.compilerOptions = compilerOptions;
    }

    public FunctionValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this(problemRequestor, null, compilerOptions);
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        this.functionName = nestedFunction.getName().getCanonicalName();
        this.checkFunctionName(nestedFunction.getName(), true);
        this.checkNumberOfParms(nestedFunction.getFunctionParameters(), nestedFunction.getName(), this.functionName);
        this.checkForConstructorCalls(nestedFunction);
        this.checkAbstract(nestedFunction);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(nestedFunction);
        return true;
    }

    @Override
    public boolean visit(Constructor constructor) {
        this.functionName = "constructor";
        this.checkNumberOfParms(constructor.getParameters(), constructor, this.functionName);
        this.checkForConstructorCalls(constructor);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(constructor);
        return true;
    }

    @Override
    public boolean visit(ReturnsDeclaration returnsDeclaration) {
        Type type = returnsDeclaration.getType();
        TypeValidator.validate(type, this.enclosingPart, this.problemRequestor, this.compilerOptions);
        TypeValidator.validateTypeDeclaration(type, this.enclosingPart, this.problemRequestor);
        return true;
    }

    private void checkForConstructorCalls(Node node) {
        List superTypes;
        org.eclipse.edt.mof.egl.Type type;
        Node parent;
        final boolean[] invokesConstructor = new boolean[1];
        node.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionInvocation functionInvocation) {
                if (functionInvocation.getTarget() instanceof SuperExpression || functionInvocation.getTarget() instanceof ThisExpression) {
                    Constructor constructor;
                    invokesConstructor[0] = true;
                    if (functionInvocation.getParent() instanceof FunctionInvocationStatement && functionInvocation.getParent().getParent() instanceof Constructor && (constructor = (Constructor)functionInvocation.getParent().getParent()).getStmts().get(0) == functionInvocation.getParent()) {
                        return true;
                    }
                    FunctionValidator.this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 6756, new String[0]);
                }
                return true;
            }
        });
        if (!invokesConstructor[0] && node instanceof Constructor && !(node.getParent() instanceof ExternalType) && (parent = node.getParent()) instanceof Part && (type = ((Part)parent).getName().resolveType()) instanceof StructPart && (superTypes = ((StructPart)type).getSuperTypes()) != null && superTypes.size() > 0 && !TypeValidator.hasPublicDefaultConstructor((org.eclipse.edt.mof.egl.Type)superTypes.get(0))) {
            this.problemRequestor.acceptProblem(node, 6757, new String[]{String.valueOf(BindingUtil.getShortTypeString((org.eclipse.edt.mof.egl.Type)superTypes.get(0), false)) + "()"});
        }
    }

    private void checkAbstract(NestedFunction func) {
        if (func.isAbstract()) {
            FunctionMember irFunc = (FunctionMember)func.getName().resolveMember();
            if (func.getParent() instanceof Part && !((Part)func.getParent()).isAbstract()) {
                this.problemRequestor.acceptProblem((Node)func, 3402, new String[]{String.valueOf(func.getName().getCaseSensitiveIdentifier()) + "(" + FunctionContainerValidator.getTypeNamesList(irFunc.getParameters()) + ")"});
            }
            if (func.isPrivate()) {
                this.problemRequestor.acceptProblem((Node)func, 3403, new String[]{String.valueOf(func.getName().getCaseSensitiveIdentifier()) + "(" + FunctionContainerValidator.getTypeNamesList(irFunc.getParameters()) + ")"});
            }
            if (func.isStatic()) {
                this.problemRequestor.acceptProblem((Node)func, 3404, new String[]{String.valueOf(func.getName().getCaseSensitiveIdentifier()) + "(" + FunctionContainerValidator.getTypeNamesList(irFunc.getParameters()) + ")"});
            }
        }
    }

    void checkNumberOfParms(List parms, Node name, String nameString) {
        if (parms.size() > 255) {
            this.problemRequestor.acceptProblem(name, 3028, new String[]{nameString, Integer.toString(parms.size())});
        }
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        Type parmType = functionParameter.getType();
        Member member = functionParameter.getName().resolveMember();
        if (member instanceof FunctionParameter) {
            TypeValidator.validate(parmType, this.enclosingPart, this.problemRequestor, this.compilerOptions);
            this.checkParmTypeNotStaticArray(functionParameter, parmType);
            org.eclipse.edt.mof.egl.Type type = member.getType();
            if (type != null) {
                this.checkParmNotEmptyRecord(functionParameter, type);
                switch (((FunctionParameter)member).getParameterKind()) {
                    case PARM_IN: {
                        this.checkInputParm(functionParameter);
                        break;
                    }
                    case PARM_OUT: {
                        this.checkOutputParm(functionParameter);
                        break;
                    }
                    case PARM_INOUT: {
                        this.checkInputOutputParm(functionParameter);
                    }
                }
            }
            EGLNameValidator.validate(functionParameter.getName(), 1, this.problemRequestor, this.compilerOptions);
        }
        return true;
    }

    private void checkFunctionName(Name name, boolean nested) {
        if (nested) {
            EGLNameValidator.validate(name, 41, this.problemRequestor, this.compilerOptions);
        } else {
            EGLNameValidator.validate(name, 4, this.problemRequestor, this.compilerOptions);
        }
    }

    private void checkParmTypeNotStaticArray(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter, Type parmType) {
        if (parmType.isArrayType()) {
            if (((ArrayType)parmType).hasInitialSize()) {
                this.problemRequestor.acceptProblem((Node)parmType, 3067, new String[]{functionParameter.getName().getCanonicalName(), this.functionName});
            } else {
                this.checkParmTypeNotStaticArray(functionParameter, ((ArrayType)parmType).getElementType());
            }
        }
    }

    private boolean hasSupertypeNotAnyRecord(StructPart part) {
        StructPart anyRec = (StructPart)BindingUtil.findPart(NameUtile.getAsName((String)"eglx.lang"), NameUtile.getAsName((String)"AnyRecord"));
        for (StructPart superType : part.getSuperTypes()) {
            if (superType.equals((org.eclipse.edt.mof.egl.Type)anyRec).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void checkParmNotEmptyRecord(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter, org.eclipse.edt.mof.egl.Type parmType) {
        if (parmType instanceof org.eclipse.edt.mof.egl.Part) {
            boolean isEmptyRecord = false;
            int partType = BindingUtil.getPartTypeConstant((org.eclipse.edt.mof.egl.Part)parmType);
            if (partType == 7) {
                boolean bl = isEmptyRecord = ((Record)parmType).getFields().isEmpty() && !this.hasSupertypeNotAnyRecord((StructPart)((Record)parmType));
            }
            if (isEmptyRecord) {
                this.problemRequestor.acceptProblem((Node)functionParameter.getType(), 3118, new String[]{functionParameter.getName().getCanonicalName(), functionParameter.getType().getCanonicalName()});
            }
        }
    }

    private void checkInputParm(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
    }

    private void checkOutputParm(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        if (functionParameter.isParmConst()) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 4958, new String[]{"out".toUpperCase(), "interval".toUpperCase()});
        }
    }

    private void checkInputOutputParm(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
    }

    private void preVisitStatement(Statement statement) {
        this.preVisitStatement(statement, true);
    }

    private void preVisitStatement(Statement statement, boolean issueWarningIfUnreachable) {
        if (issueWarningIfUnreachable && this.nextStatementIsUnreachable) {
            this.problemRequestor.acceptProblem((Node)statement, 7755, 1);
            this.nextStatementIsUnreachable = false;
        }
        this.labelPrecedingStatement = null;
    }

    private void postVisitStatement(Statement statement) {
        if (statement.canIncludeOtherStatements()) {
            Iterator<List<Node>> iter = statement.getStatementBlocks().iterator();
            while (iter.hasNext()) {
                Iterator<Node> stmtIter = iter.next().iterator();
                while (stmtIter.hasNext()) {
                    stmtIter.next().accept(this);
                }
                this.nextStatementIsUnreachable = false;
            }
        }
    }

    @Override
    public boolean visit(AddStatement addStatement) {
        this.preVisitStatement(addStatement);
        this.validateStatement(addStatement);
        this.postVisitStatement(addStatement);
        return false;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        this.preVisitStatement(assignmentStatement);
        assignmentStatement.accept(new AssignmentStatementValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        this.postVisitStatement(assignmentStatement);
        return false;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        this.preVisitStatement(callStatement);
        this.validateStatement(callStatement);
        this.postVisitStatement(callStatement);
        return false;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(caseStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(caseStatement);
        caseStatement.accept(new CaseStatementValidator(this.problemRequestor, this.compilerOptions));
        this.postVisitStatement(caseStatement);
        return false;
    }

    @Override
    public boolean visit(CloseStatement closeStatement) {
        this.preVisitStatement(closeStatement);
        this.validateStatement(closeStatement);
        this.postVisitStatement(closeStatement);
        return false;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement) {
        this.preVisitStatement(continueStatement);
        continueStatement.accept(new ContinueStatementValidator(this.problemRequestor, this.labeledLoops));
        this.nextStatementIsUnreachable = true;
        this.postVisitStatement(continueStatement);
        return false;
    }

    @Override
    public boolean visit(DeleteStatement deleteStatement) {
        this.preVisitStatement(deleteStatement);
        this.validateStatement(deleteStatement);
        this.postVisitStatement(deleteStatement);
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement executeStatement) {
        this.preVisitStatement(executeStatement);
        this.validateStatement(executeStatement);
        this.postVisitStatement(executeStatement);
        return false;
    }

    @Override
    public boolean visit(ExitStatement exitStatement) {
        this.preVisitStatement(exitStatement);
        exitStatement.accept(new ExitStatementValidator(this.problemRequestor, this.labeledLoops, this.enclosingPart, this.compilerOptions));
        this.nextStatementIsUnreachable = true;
        this.postVisitStatement(exitStatement);
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(forEachStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(forEachStatement);
        this.validateStatement(forEachStatement);
        this.postVisitStatement(forEachStatement);
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(forStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(forStatement);
        forStatement.accept(new ForStatementValidator(this.problemRequestor, this.compilerOptions));
        this.postVisitStatement(forStatement);
        return false;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        this.preVisitStatement(functionInvocationStatement);
        this.postVisitStatement(functionInvocationStatement);
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        this.preVisitStatement(functionDataDeclaration);
        functionDataDeclaration.accept(new FunctionDataDeclarationValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        this.postVisitStatement(functionDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement getByKeyStatement) {
        this.preVisitStatement(getByKeyStatement);
        this.validateStatement(getByKeyStatement);
        this.postVisitStatement(getByKeyStatement);
        return false;
    }

    @Override
    public boolean visit(GetByPositionStatement getByPositionStatement) {
        this.preVisitStatement(getByPositionStatement);
        this.validateStatement(getByPositionStatement);
        this.postVisitStatement(getByPositionStatement);
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        this.preVisitStatement(gotoStatement);
        gotoStatement.accept(new GotoStatementValidator(this.problemRequestor, this.compilerOptions));
        this.gotoList.add(gotoStatement);
        this.postVisitStatement(gotoStatement);
        return false;
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(ifStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(ifStatement);
        ifStatement.accept(new IfStatementValidator(this.problemRequestor));
        this.postVisitStatement(ifStatement);
        return false;
    }

    @Override
    public boolean visit(LabelStatement labelStatement) {
        this.nextStatementIsUnreachable = false;
        this.preVisitStatement(labelStatement);
        this.labelPrecedingStatement = labelStatement;
        labelStatement.accept(new LabelStatementValidator(this.problemRequestor, this.compilerOptions));
        if (this.labelMap.containsKey(labelStatement.getLabel())) {
            this.problemRequestor.acceptProblem((Node)labelStatement, 6625, new String[]{labelStatement.getLabel(), this.functionName});
        } else {
            this.labelMap.put(labelStatement.getLabel(), labelStatement);
        }
        this.postVisitStatement(labelStatement);
        return false;
    }

    @Override
    public boolean visit(MoveStatement moveStatement) {
        this.preVisitStatement(moveStatement);
        moveStatement.accept(new MoveStatementValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        this.postVisitStatement(moveStatement);
        return false;
    }

    @Override
    public boolean visit(OpenStatement openStatement) {
        this.preVisitStatement(openStatement);
        this.validateStatement(openStatement);
        this.postVisitStatement(openStatement);
        return false;
    }

    @Override
    public boolean visit(PrepareStatement prepareStatement) {
        this.preVisitStatement(prepareStatement);
        this.validateStatement(prepareStatement);
        this.postVisitStatement(prepareStatement);
        return false;
    }

    @Override
    public boolean visit(ReplaceStatement replaceStatement) {
        this.preVisitStatement(replaceStatement);
        this.validateStatement(replaceStatement);
        this.postVisitStatement(replaceStatement);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        this.preVisitStatement(returnStatement);
        returnStatement.accept(new ReturnStatementValidator(this.problemRequestor, this.compilerOptions));
        this.postVisitStatement(returnStatement);
        return false;
    }

    @Override
    public boolean visit(SetStatement setStatement) {
        this.preVisitStatement(setStatement);
        setStatement.accept(new SetStatementValidator(this.problemRequestor, this.enclosingPart, this.compilerOptions));
        this.postVisitStatement(setStatement);
        return false;
    }

    @Override
    public boolean visit(SetValuesStatement setValuesStatement) {
        this.preVisitStatement(setValuesStatement);
        this.postVisitStatement(setValuesStatement);
        return false;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        this.preVisitStatement(throwStatement);
        throwStatement.accept(new ThrowStatementValidator(this.problemRequestor, this.enclosingPart));
        this.postVisitStatement(throwStatement);
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.preVisitStatement(tryStatement);
        tryStatement.accept(new TryStatementValidator(this.problemRequestor, this.enclosingPart));
        this.postVisitStatement(tryStatement);
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(whileStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(whileStatement);
        whileStatement.accept(new WhileStatementValidator(this.problemRequestor));
        this.postVisitStatement(whileStatement);
        return false;
    }

    @Override
    public void endVisit(NestedFunction nestedFunction) {
        this.validateGotoLabels();
    }

    private void validateStatement(Statement stmt) {
        List<ASTValidator> validators = this.enclosingPart.getEnvironment().getCompiler().getValidatorsFor(stmt);
        if (validators != null && validators.size() > 0) {
            for (ASTValidator validator : validators) {
                validator.validate(stmt, this.enclosingPart, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void validateGotoLabels() {
        for (GotoStatement gotoStatement : this.gotoList) {
            if (!this.labelMap.containsKey(gotoStatement.getLabel())) {
                this.problemRequestor.acceptProblem((Node)gotoStatement, 6624, new String[]{gotoStatement.getLabel(), this.functionName});
                continue;
            }
            if (this.inParents(gotoStatement, ((Node)this.labelMap.get(gotoStatement.getLabel())).getParent())) continue;
            this.problemRequestor.acceptProblem((Node)gotoStatement, 6728, new String[]{gotoStatement.getLabel(), this.functionName});
        }
    }

    private boolean inParents(Node child, Node node) {
        while (child != null) {
            if (child == node) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public static String getName(Statement statement) {
        final String[] result = new String[1];
        statement.accept(new DefaultASTVisitor(){

            @Override
            public void endVisit(AddStatement addStatement) {
                result[0] = "add";
            }

            @Override
            public void endVisit(CallStatement callStatement) {
                result[0] = "call";
            }

            @Override
            public void endVisit(CaseStatement caseStatement) {
                result[0] = "case";
            }

            @Override
            public void endVisit(CloseStatement closeStatement) {
                result[0] = "close";
            }

            @Override
            public void endVisit(ContinueStatement continueStatement) {
                result[0] = "continue";
            }

            @Override
            public void endVisit(DeleteStatement deleteStatement) {
                result[0] = "delete";
            }

            @Override
            public void endVisit(ExecuteStatement executeStatement) {
                result[0] = "execute";
            }

            @Override
            public void endVisit(ExitStatement exitStatement) {
                result[0] = "exit";
            }

            @Override
            public void endVisit(ForEachStatement forEachStatement) {
                result[0] = "forEach";
            }

            @Override
            public void endVisit(ForStatement forStatement) {
                result[0] = "for";
            }

            @Override
            public void endVisit(ForwardStatement forwardStatement) {
                result[0] = "forward";
            }

            @Override
            public void endVisit(GetByKeyStatement getByKeyStatement) {
                result[0] = "get";
            }

            @Override
            public void endVisit(GetByPositionStatement getByPositionStatement) {
                result[0] = "get";
            }

            @Override
            public void endVisit(GotoStatement gotoStatement) {
                result[0] = "goto";
            }

            @Override
            public void endVisit(IfStatement ifStatement) {
                result[0] = "if";
            }

            @Override
            public void endVisit(MoveStatement moveStatement) {
                result[0] = "move";
            }

            @Override
            public void endVisit(OpenStatement openStatement) {
                result[0] = "open";
            }

            @Override
            public void endVisit(ReplaceStatement replaceStatement) {
                result[0] = "replace";
            }

            @Override
            public void endVisit(ThrowStatement throwStatement) {
                result[0] = "throw";
            }

            @Override
            public void endVisit(TryStatement tryStatement) {
                result[0] = "try";
            }

            @Override
            public void endVisit(WhileStatement whileStatement) {
                result[0] = "while";
            }

            @Override
            public void endVisit(ReturnStatement returnStatement) {
                result[0] = "return";
            }

            @Override
            public void endVisit(SetStatement setStatement) {
                result[0] = "set";
            }

            @Override
            public void endVisit(PrepareStatement prepareStatement) {
                result[0] = "prepare";
            }
        });
        if (result[0] == null) {
            throw new RuntimeException("Must define visit() for class " + statement.getClass() + " in " + FunctionValidator.class.getSimpleName() + "::getName()");
        }
        return result[0];
    }
}

