/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.FieldAccessValidationRule;
import org.eclipse.edt.compiler.binding.IValidationProxy;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class LValueValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private Member member;
    private Expression lValue;
    private ILValueValidationRules validationRules;

    public LValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, Member member, Expression lValue) {
        this(problemRequestor, compilerOptions, member, lValue, new DefaultLValueValidationRules());
    }

    public LValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, Member member, Expression lValue, ILValueValidationRules validationRules) {
        this.problemRequestor = problemRequestor;
        this.member = member;
        this.lValue = lValue;
        this.validationRules = validationRules;
        this.compilerOptions = compilerOptions;
    }

    private boolean invokeFieldAccessValidators() {
        boolean result = true;
        if (this.member == null) {
            return result;
        }
        for (Annotation annot : this.member.getAnnotations()) {
            IValidationProxy proxy = AnnotationValidator.getValidationProxy(annot);
            if (proxy == null) continue;
            for (FieldAccessValidationRule rule : proxy.getFieldAccessValidators()) {
                boolean bl = result = rule.validateLValue(this.lValue, this.member, this.problemRequestor, this.compilerOptions) && result;
            }
        }
        return result;
    }

    public boolean validate() {
        Name constName;
        Member constMember;
        boolean result = true;
        if (this.validationRules.shouldRunAccessRules()) {
            result = this.invokeFieldAccessValidators();
        }
        Member member = constMember = (constName = LValueValidator.findConstName(this.lValue)) == null ? null : constName.resolveMember();
        if (constMember != null) {
            boolean canAssignToConst;
            boolean bl = canAssignToConst = constMember instanceof FunctionParameter ? this.validationRules.canAssignToFunctionParmConst() : this.validationRules.canAssignToConstantVariables();
            if (!canAssignToConst && (constName == this.lValue || constMember.getType() != null && TypeUtils.isValueType((Type)constMember.getType()))) {
                this.problemRequestor.acceptProblem((Node)this.lValue, 6646, new String[]{this.member.getCaseSensitiveName()});
                result = false;
            }
        }
        if (this.member instanceof FunctionMember && !this.validationRules.canAssignToFunctionReferences()) {
            this.problemRequestor.acceptProblem((Node)this.lValue, 7954, new String[]{this.member.getCaseSensitiveName()});
            result = false;
        }
        return result;
    }

    public static Name findConstName(Expression e) {
        if (e == null) {
            return null;
        }
        final Name[] value = new Name[1];
        e.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(SimpleName simpleName) {
                Member m = simpleName.resolveMember();
                if (m instanceof ConstantField || m instanceof FunctionParameter && ((FunctionParameter)m).isConst().booleanValue()) {
                    value[0] = simpleName;
                }
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                Member m = qualifiedName.resolveMember();
                if (m instanceof ConstantField || m instanceof FunctionParameter && ((FunctionParameter)m).isConst().booleanValue()) {
                    value[0] = qualifiedName;
                    return false;
                }
                return true;
            }
        });
        return value[0];
    }

    public static class DefaultLValueValidationRules
    implements ILValueValidationRules {
        @Override
        public boolean canAssignToConstantVariables() {
            return false;
        }

        @Override
        public boolean canAssignToReadOnlyVariables() {
            return false;
        }

        @Override
        public boolean canAssignToFunctionReferences() {
            return false;
        }

        @Override
        public boolean canAssignToFunctionParmConst() {
            return false;
        }

        @Override
        public boolean shouldRunAccessRules() {
            return true;
        }
    }

    public static interface ILValueValidationRules {
        public boolean canAssignToConstantVariables();

        public boolean canAssignToReadOnlyVariables();

        public boolean canAssignToFunctionReferences();

        public boolean canAssignToFunctionParmConst();

        public boolean shouldRunAccessRules();
    }
}

