/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public class ReturnStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;

    public ReturnStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        Node current = returnStatement.getParent();
        Function[] fBinding = new Function[1];
        ParentASTVisitor visitor = new ParentASTVisitor((FunctionMember[])fBinding){
            private final /* synthetic */ FunctionMember[] val$fBinding;
            {
                this.val$fBinding = functionMemberArray;
            }

            @Override
            public boolean visit(NestedFunction nFunction) {
                this.bcontinue = false;
                this.val$fBinding[0] = (Function)nFunction.getName().resolveMember();
                if (this.val$fBinding[0] != null) {
                    this.returnField = ((Function)this.val$fBinding[0]).getReturnField();
                }
                return false;
            }
        };
        while (current != null && visitor.canContinue()) {
            current.accept(visitor);
            current = current.getParent();
        }
        if (returnStatement.getParenthesizedExprOpt() != null && !visitor.hasReturnType()) {
            this.problemRequestor.acceptProblem(returnStatement, 6608);
        }
        this.validateNoSetValues(returnStatement);
        if (visitor.hasReturnType() && returnStatement.getParenthesizedExprOpt() != null) {
            HashMap<Expression, Type> rhsExprMap = new HashMap<Expression, Type>();
            TypeValidator.collectExprsForTypeCompatibility(returnStatement.getParenthesizedExprOpt(), rhsExprMap);
            for (Map.Entry entry : rhsExprMap.entrySet()) {
                boolean compatible = BindingUtil.isMoveCompatible(visitor.getReturnType(), (Member)visitor.getReturnField(), (Type)entry.getValue(), (Expression)entry.getKey());
                if (compatible) continue;
                this.problemRequestor.acceptProblem((Node)entry.getKey(), 6691, new String[]{BindingUtil.getShortTypeString((Expression)entry.getKey(), (Type)entry.getValue()), BindingUtil.getShortTypeString(visitor.getReturnType())});
            }
        }
        if (returnStatement.getParenthesizedExprOpt() != null) {
            returnStatement.getParenthesizedExprOpt().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(AnnotationExpression annotationExpression) {
                    ReturnStatementValidator.this.problemRequestor.acceptProblem(annotationExpression.getOffset(), annotationExpression.getOffset() + 1, 2, 2002, new String[]{"@"});
                    return false;
                }

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }
            });
        }
        return false;
    }

    protected void validateNoSetValues(ReturnStatement returnStatement) {
        returnStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                ReturnStatementValidator.this.problemRequestor.acceptProblem(setValuesExpression, 7516);
                return false;
            }
        });
    }

    private class ParentASTVisitor
    extends AbstractASTVisitor {
        Field returnField;
        boolean bcontinue = true;

        public boolean hasReturnType() {
            return this.returnField != null && this.returnField.getType() != null;
        }

        public Type getReturnType() {
            return this.returnField == null ? null : this.returnField.getType();
        }

        public Field getReturnField() {
            return this.returnField;
        }

        public boolean canContinue() {
            return this.bcontinue;
        }
    }
}

