/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.type;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.TernaryExpression;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class TypeValidator {
    public static void validate(Type type, final IPartBinding declaringPart, final IProblemRequestor problemRequestor, final ICompilerOptions compilerOptions) {
        if (type == null) {
            return;
        }
        org.eclipse.edt.mof.egl.Type typeBinding = type.getBaseType().resolveType();
        if (typeBinding != null) {
            boolean valid;
            boolean bl = valid = !TypeUtils.isStaticType((org.eclipse.edt.mof.egl.Type)typeBinding);
            if (valid) {
                boolean bl2 = valid = !(typeBinding instanceof AnnotationType) || declaringPart instanceof IRPartBinding && ((IRPartBinding)declaringPart).getIrPart() instanceof AnnotationType;
            }
            if (!valid) {
                problemRequestor.acceptProblem((Node)type, 4926, new String[]{typeBinding.getTypeSignature()});
                return;
            }
        }
        type.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NameType nameType) {
                List<ASTValidator> validators = declaringPart.getEnvironment().getCompiler().getValidatorsFor(nameType);
                if (validators != null && validators.size() > 0) {
                    for (ASTValidator validator : validators) {
                        validator.validate(nameType, declaringPart, problemRequestor, compilerOptions);
                    }
                }
                return false;
            }
        });
    }

    public static void validateInstantiatable(Type type, IPartBinding declaringPart, boolean isNullable, IProblemRequestor problemRequestor) {
        if (!isNullable) {
            boolean isValid = true;
            org.eclipse.edt.mof.egl.Type typeBinding = type.resolveType();
            if (!(typeBinding == null || typeBinding instanceof ParameterizedType || !TypeUtils.isReferenceType((org.eclipse.edt.mof.egl.Type)typeBinding) || TypeValidator.hasPublicDefaultConstructor(typeBinding) || declaringPart != null && (declaringPart.getKind() == 28 || declaringPart instanceof IRPartBinding && typeBinding.equals((org.eclipse.edt.mof.egl.Type)((IRPartBinding)declaringPart).getIrPart()).booleanValue()))) {
                isValid = false;
            }
            if (isValid && BindingUtil.isAbstract(typeBinding)) {
                isValid = false;
            }
            if (!isValid) {
                problemRequestor.acceptProblem((Node)type, 3433, new String[]{type.getCanonicalName()});
            }
        }
    }

    public static boolean hasPublicDefaultConstructor(org.eclipse.edt.mof.egl.Type typeBinding) {
        if (typeBinding != null && typeBinding.getClassifier() instanceof StructPart) {
            List constructors = ((StructPart)typeBinding.getClassifier()).getConstructors();
            if (constructors.size() == 0) {
                return true;
            }
            for (Constructor con : constructors) {
                if (con.getParameters().size() != 0 || BindingUtil.isPrivate((Member)con)) continue;
                return true;
            }
        }
        return false;
    }

    public static void validateTypeDeclaration(Type type, IPartBinding declaringPart, IProblemRequestor problemRequestor) {
        if (type.isArrayType()) {
            while (type.isArrayType()) {
                if (((ArrayType)type).hasInitialSize()) {
                    problemRequestor.acceptProblem(type, 3248);
                }
                type = ((ArrayType)type).getElementType();
            }
        }
    }

    public static void collectExprsForTypeCompatibility(Expression rootExpr, final Map<Expression, org.eclipse.edt.mof.egl.Type> exprMap) {
        rootExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(TernaryExpression ternaryExpression) {
                ternaryExpression.getSecondExpr().accept(this);
                ternaryExpression.getThirdExpr().accept(this);
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                exprMap.put(expression, BindingUtil.resolveGenericType(expression.resolveType(), expression));
                return false;
            }
        });
    }
}

