/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.compiler.Context;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EEnum;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.MofConversion;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;
import org.eclipse.edt.mof.egl.TypeParameter;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.lookup.ProxyElement;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEClass;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.utils.EList;

abstract class Egl2MofBase
extends AbstractASTVisitor
implements MofConversion {
    private static Map<String, MofSerializable> processed = new HashMap<String, MofSerializable>();
    protected Stack<MofSerializable> partProcessingStack = new Stack();
    private static String TempEClassMarker = "eze_temp";
    MofFactory mof;
    IrFactory factory;
    IEnvironment env;
    Context context;
    boolean inMofContext = false;
    boolean inMofProxyContext = false;
    boolean inEMetadataTypeContext = false;
    boolean inAnnotationTypeContext = false;
    boolean visitFunctionBody = false;
    protected Stack<Object> stack;
    protected Map<Object, EObject> eObjects;
    protected Map<Object, ProxyEObject> proxies;

    Egl2MofBase(IEnvironment env) {
        this.env = env;
        this.mof = MofFactory.INSTANCE;
        this.factory = IrFactory.INSTANCE;
        this.stack = new Stack();
        this.eObjects = new HashMap<Object, EObject>();
        this.proxies = new HashMap<Object, ProxyEObject>();
    }

    public void setEnvironment(IEnvironment env) {
        this.env = env;
    }

    protected EObject eStackPop() {
        return (EObject)this.stack.pop();
    }

    private MofSerializable getPartBeingProcessed() {
        return this.partProcessingStack.isEmpty() ? null : this.partProcessingStack.peek();
    }

    protected EObject getEObjectFor(Member mbr) {
        if (mbr == null) {
            return null;
        }
        Object result = this.eObjects.get(mbr);
        if (result == null) {
            result = (EObject)this.proxies.get(mbr);
        }
        if (result == null) {
            result = this.inMofContext ? new ProxyEObject() : new ProxyElement();
            this.proxies.put(mbr, (ProxyEObject)result);
        }
        return result;
    }

    protected EObject getEObjectFor(Object element) {
        if (element == null) {
            return null;
        }
        Object result = this.eObjects.get(element);
        if (result == null) {
            result = (EObject)this.proxies.get(element);
        }
        if (result == null) {
            result = this.inMofContext ? new ProxyEObject() : new ProxyElement();
            this.proxies.put(element, (ProxyEObject)result);
        }
        return result;
    }

    protected Annotation getAnnotation(Element binding, String typeName) {
        if (binding != null) {
            return binding.getAnnotation(typeName);
        }
        return null;
    }

    protected EMetadataObject getEMetadataObject(EModelElement elem, String typeName) {
        if (elem != null) {
            return elem.getMetadata(typeName);
        }
        return null;
    }

    protected void createAnnotations(Element binding, EModelElement element) {
        if (binding == null) {
            return;
        }
        for (Annotation annotation : binding.getAnnotations()) {
            element.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(org.eclipse.edt.mof.egl.Part binding, Element eClass) {
        for (Annotation annotation : binding.getAnnotations()) {
            eClass.addAnnotation((Annotation)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(org.eclipse.edt.mof.egl.Part binding, EClass eClass) {
        Stereotype subtype = binding.getStereotype();
        for (Annotation annotation : binding.getAnnotations()) {
            if (subtype == annotation) continue;
            eClass.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(Element binding, Element element) {
        if (binding == null) {
            return;
        }
        for (Annotation annotation : binding.getAnnotations()) {
            element.getAnnotations().add(this.createAnnotation(annotation));
        }
    }

    protected void createAnnotations(org.eclipse.edt.mof.egl.Part binding, org.eclipse.edt.mof.egl.Part part) {
        Stereotype subtype = binding.getStereotype();
        boolean bypass = subtype != null && this.isEGLReflectType(binding);
        for (Annotation annotation : binding.getAnnotations()) {
            if (bypass && subtype == annotation) continue;
            if (this.inMofContext) {
                ((EClass)part).getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
                continue;
            }
            part.getAnnotations().add((Annotation)this.mofValueFrom(annotation));
        }
    }

    private Annotation createAnnotation(Annotation annBinding) {
        EObject ann = this.mofValueFrom(annBinding);
        if (ann instanceof Annotation) {
            return (Annotation)ann;
        }
        throw new IllegalArgumentException("Type " + ann.getEClass().getETypeSignature() + " is not an AnnotationType");
    }

    private MemberName createMemberName(Element binding) {
        MemberName name = this.factory.createMemberName();
        if (binding instanceof NamedElement) {
            name.setId(((NamedElement)binding).getCaseSensitiveName());
        }
        name.setMember((Member)this.getEObjectFor(binding));
        return name;
    }

    protected Object getValue(Object annotationValue, boolean isMetaDataFieldValue) {
        if (annotationValue instanceof Integer[] || annotationValue instanceof Integer[][] || annotationValue instanceof int[] || annotationValue instanceof int[][] || annotationValue instanceof String[] || annotationValue instanceof String[][]) {
            return annotationValue;
        }
        if (annotationValue == Boolean.NO) {
            return java.lang.Boolean.FALSE;
        }
        if (annotationValue == Boolean.YES) {
            return java.lang.Boolean.TRUE;
        }
        if (annotationValue instanceof EnumerationEntry) {
            return annotationValue;
        }
        if (annotationValue instanceof org.eclipse.edt.mof.egl.Part) {
            EObject value = this.mofTypeFor((Type)((org.eclipse.edt.mof.egl.Part)annotationValue));
            if (value instanceof org.eclipse.edt.mof.egl.Part && !annotationValue.equals(value) && !isMetaDataFieldValue) {
                value = this.createTypeName((Type)((org.eclipse.edt.mof.egl.Part)value));
            }
            return value;
        }
        if (annotationValue instanceof Annotation) {
            return this.mofValueFrom((Annotation)annotationValue);
        }
        if (annotationValue instanceof org.eclipse.edt.compiler.core.ast.Expression) {
            ((org.eclipse.edt.compiler.core.ast.Expression)annotationValue).accept(this);
            return (Expression)this.stack.pop();
        }
        if (annotationValue instanceof Member) {
            Member valueBinding = (Member)annotationValue;
            Container declarer = valueBinding.getContainer();
            if (this.getPartBeingProcessed() != null && declarer instanceof org.eclipse.edt.mof.egl.Part && !this.getPartBeingProcessed().getMofSerializationKey().equalsIgnoreCase(((MofSerializable)declarer).getMofSerializationKey())) {
                PartName nameType = this.factory.createPartName();
                nameType.setId(((org.eclipse.edt.mof.egl.Part)declarer).getCaseSensitiveName());
                nameType.setPackageName(((org.eclipse.edt.mof.egl.Part)declarer).getCaseSensitivePackageName());
                MemberAccess access = this.factory.createMemberAccess();
                access.setId(valueBinding.getCaseSensitiveName());
                access.setQualifier((Expression)nameType);
                return access;
            }
            return this.createMemberName(valueBinding);
        }
        if (annotationValue instanceof Type) {
            EObject value = this.mofTypeFor((Type)annotationValue);
            if (value instanceof Type) {
                value = this.createTypeName((Type)value);
            }
            return value;
        }
        if (annotationValue instanceof Object[]) {
            Object[] arrVal = (Object[])annotationValue;
            Object[] value = new Object[arrVal.length];
            int i = 0;
            while (i < value.length) {
                value[i] = this.getValue(arrVal[i], isMetaDataFieldValue);
                ++i;
            }
            return value;
        }
        if (annotationValue instanceof EList) {
            EList value = new EList(((EList)annotationValue).size());
            for (Object obj : (EList)annotationValue) {
                value.add(this.getValue(obj, isMetaDataFieldValue));
            }
            return value;
        }
        return annotationValue;
    }

    private MemberName createMemberName(Member mbr) {
        MemberName name = this.factory.createMemberName();
        name.setId(mbr.getCaseSensitiveName());
        name.setMember((Member)this.getEObjectFor(mbr));
        return name;
    }

    private TypeName createTypeName(Type type) {
        if (type instanceof org.eclipse.edt.mof.egl.Part) {
            org.eclipse.edt.mof.egl.Part part = (org.eclipse.edt.mof.egl.Part)type;
            PartName partName = this.factory.createPartName();
            partName.setId(part.getCaseSensitiveName());
            partName.setPackageName(part.getCaseSensitivePackageName());
            return partName;
        }
        String key = type.getMofSerializationKey();
        TypeName typeName = this.factory.createTypeName();
        typeName.setId(key);
        return typeName;
    }

    private Library getLibraryContainer(Type binding) {
        Container part;
        if (binding == null) {
            return null;
        }
        if (binding instanceof Library) {
            return (Library)binding;
        }
        if (binding instanceof Member && (part = ((Member)binding).getContainer()) instanceof Library) {
            return (Library)part;
        }
        return null;
    }

    private void eAdd(EObject target, String fieldName, Object value) {
        ((List)target.eGet(fieldName)).add(value);
    }

    private boolean shouldReflect(AnnotationType reflectAnnotationType, String fieldName) {
        if (reflectAnnotationType == null) {
            return false;
        }
        EField field = reflectAnnotationType.getEField(fieldName);
        if (field == null) {
            return false;
        }
        return field.getMetadata("NoReflect") == null;
    }

    private boolean isSpecialNamedElementCase(Object o, EType type) {
        return o instanceof String && type instanceof EClass && this.isSubClassOf((EClass)type, this.factory.getNamedElementEClass());
    }

    private List<EField> getFieldsBelowEClass(EClass target) {
        EList fields = new EList();
        if (target == null || target.getETypeSignature().equalsIgnoreCase("org.eclipse.edt.mof.EClass")) {
            return fields;
        }
        fields.addAll(target.getEFields());
        if (!target.getSuperTypes().isEmpty()) {
            fields.addAll(0, this.getFieldsBelowEClass((EClass)target.getSuperTypes().get(0)));
        }
        return fields;
    }

    protected void setReflectTypeValues(EObject target, AnnotationType reflectTypeBinding) {
        if (reflectTypeBinding == null) {
            return;
        }
        EClass eClass = target.getEClass();
        for (EField field : this.getFieldsBelowEClass(eClass)) {
            Object obj;
            EField reflectField = reflectTypeBinding.getEClass().getEField(field.getName());
            if (reflectField == null || reflectField.getCaseSensitiveName().equals("annotations") || (obj = this.mofValueFrom(reflectTypeBinding.eGet(field))) == null) continue;
            if (obj instanceof List) {
                for (Object o : (List)obj) {
                    EType cfr_ignored_0 = (EType)((EGenericType)field.getEType()).getETypeArguments().get(0);
                    if (o instanceof PartName) {
                        o = ((PartName)o).getPart();
                    }
                    ((List)target.eGet(field)).add(o);
                }
                continue;
            }
            EClassifier type = (EClassifier)field.getEType();
            if (obj instanceof PartName) {
                obj = ((PartName)obj).getPart();
            }
            if (obj instanceof String && type == this.mof.getETypeClass()) {
                obj = this.createProxyPart((String)obj);
            }
            target.eSet(field, obj);
        }
    }

    protected boolean hasAnnotationField(String name, Annotation ann) {
        if (ann.getEClass() != null) {
            for (EField field : ann.getEClass().getEFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected void setReflectTypeValues(EObject target, Annotation reflectTypeBinding) {
        if (reflectTypeBinding == null) {
            return;
        }
        EClass eClass = target.getEClass();
        for (EField field : eClass.getAllEFields()) {
            Object obj = this.mofValueFrom(this.getFieldValue(reflectTypeBinding, field.getName()));
            if (obj == null || !this.shouldReflect((AnnotationType)reflectTypeBinding.getEClass(), field.getName())) continue;
            if (obj instanceof List) {
                for (Object o : (List)obj) {
                    EType type;
                    if (this.isSpecialNamedElementCase(o, type = (EType)((EGenericType)field.getEType()).getETypeArguments().get(0))) {
                        o = this.convertStringValueToNamedElementType((String)o, (EClass)type);
                    } else if (o instanceof PartName) {
                        o = ((PartName)o).getPart();
                    }
                    ((List)target.eGet(field)).add(o);
                }
                continue;
            }
            EClassifier type = (EClassifier)field.getEType();
            if (obj instanceof String && type instanceof EClass && this.isSubClassOf((EClass)type, this.mof.getENamedElementClass())) {
                obj = this.convertStringValueToNamedElementType((String)obj, (EClass)type);
            } else if (obj instanceof PartName) {
                obj = ((PartName)obj).getPart();
            }
            if (obj instanceof String && type == this.mof.getETypeClass()) {
                obj = this.createProxyPart((String)obj);
            }
            target.eSet(field, obj);
        }
    }

    private Object getFieldValue(Annotation annotation, String fieldName) {
        Object result = null;
        if (this.hasAnnotationField(fieldName, annotation)) {
            Object obj = annotation.getValue(fieldName);
            if (obj instanceof String && ((String)obj).length() == 0) {
                return null;
            }
            result = this.getValue(obj, false);
        }
        return result;
    }

    private EObject convertStringValueToNamedElementType(String obj, EClass eClass) {
        EObject result = eClass.newInstance();
        result.eSet("name", (Object)obj);
        return result;
    }

    protected void updateProxyReferences(Object element, EObject obj) {
        ProxyEObject proxy = this.proxies.get(element);
        if (proxy != null) {
            proxy.updateReferences((Object)obj);
        }
    }

    private List<Object> mofValueFrom(Object[] array) {
        EList result = new EList();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add(this.mofValueFrom(obj));
            ++n2;
        }
        return result;
    }

    private List<Object> mofValueFrom(List<Object> list) {
        EList result = new EList();
        for (Object obj : list) {
            result.add(this.mofValueFrom(obj));
        }
        return result;
    }

    protected Object mofValueFrom(EEnumLiteral enumLiteral) {
        Object convertedValue;
        EEnum eenum = (EEnum)enumLiteral.getDeclarer();
        String name = enumLiteral.getCaseSensitiveName();
        if (eenum.getETypeSignature().equals("org.eclipse.edt.mof.egl.ElementKind")) {
            if (this.inEMetadataTypeContext) {
                convertedValue = name.equals("ExternalTypePart") ? this.getMofSerializable("org.eclipse.edt.mof.EClass") : (name.equals("Part") ? this.getMofSerializable("org.eclipse.edt.mof.EClass") : (name.equals("FieldMbr") ? this.getMofSerializable("org.eclipse.edt.mof.EField") : (name.equals("FunctionMbr") ? this.getMofSerializable("org.eclipse.edt.mof.EFunction") : this.mof.getEModelElementClass())));
            } else {
                try {
                    Class<?> enumClass = Class.forName("org.eclipse.edt.mof.egl.ElementKind");
                    convertedValue = Enum.valueOf(enumClass, name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    convertedValue = enumLiteral;
                }
            }
        } else {
            try {
                Class<?> enumClass = Class.forName(eenum.getETypeSignature());
                convertedValue = Enum.valueOf(enumClass, name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                convertedValue = enumLiteral;
            }
        }
        return convertedValue;
    }

    protected Object mofValueFrom(Object value) {
        if (value instanceof Annotation) {
            return this.mofValueFrom((Annotation)value);
        }
        if (value instanceof EEnumLiteral) {
            return this.mofValueFrom((EEnumLiteral)value);
        }
        if (value instanceof Member) {
            return this.getEObjectFor((Member)value);
        }
        if (value instanceof Type) {
            return this.mofTypeFor((Type)value);
        }
        if (value instanceof org.eclipse.edt.mof.egl.Part) {
            return this.mofValueFrom((org.eclipse.edt.mof.egl.Part)value);
        }
        if (value instanceof Object[]) {
            return this.mofValueFrom((Object[])value);
        }
        if (value instanceof List) {
            return this.mofValueFrom((List)value);
        }
        return value;
    }

    private EObject mofValueFrom(org.eclipse.edt.mof.egl.Part part) {
        if (!(part instanceof ProxyPart) && this.isMofProxy(part)) {
            return this.resolveProxy(part);
        }
        return part;
    }

    protected EObject mofValueFrom(Annotation binding) {
        if (binding == null || binding.getEClass() == null) {
            return binding;
        }
        EObject value = null;
        if (this.isEMetadataType((Type)((org.eclipse.edt.mof.egl.Part)binding.getEClass()))) {
            try {
                EClassifier clzz = MofFactory.INSTANCE.getTypeNamed(binding.getEClass().getETypeSignature());
                if (clzz instanceof EClass) {
                    value = ((EClass)clzz).newInstance();
                }
            }
            catch (Exception exception) {}
        }
        if (value == null) {
            value = binding.getEClass().newInstance();
        }
        for (Annotation subAnnotation : binding.getAnnotations()) {
            if (value instanceof Annotation) {
                ((Annotation)value).getAnnotations().add((Annotation)this.mofValueFrom(subAnnotation));
                continue;
            }
            ((EMetadataObject)value).getMetadataList().add((EMetadataObject)this.mofValueFrom(subAnnotation));
        }
        boolean isEMetadataObject = !(value instanceof Annotation);
        for (EField field : binding.getEClass().getEFields()) {
            EField valueField = null;
            if (value.getEClass() != null) {
                valueField = value.getEClass().getEField(field.getCaseSensitiveName());
            }
            if (valueField == null) continue;
            Object oldVale = binding.eGet(field);
            Object fieldValue = this.mofValueFrom(this.getValue(oldVale, isEMetadataObject));
            value.eSet(valueField, fieldValue);
        }
        return value;
    }

    protected EClass mofMemberTypeFor(Element binding) {
        Annotation opAnn;
        EClass mbrType = binding instanceof Function ? ((opAnn = binding.getAnnotation("egl.lang.reflect.mof.Operation")) == null ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Function") : (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Operation")) : (binding instanceof Constructor ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Constructor") : (binding instanceof ConstantField ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.ConstantField") : (binding instanceof Field ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Field") : (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Field"))));
        return mbrType;
    }

    protected EObject mofTypeFromTypedElement(Element element) {
        Type type = null;
        if (element instanceof Function) {
            type = ((Function)element).getType();
        } else if (element instanceof Constructor) {
            type = (org.eclipse.edt.mof.egl.Part)((Constructor)element).getContainer();
        } else if (element instanceof TypedElement) {
            type = ((TypedElement)element).getType();
        } else if (element instanceof Type) {
            type = (Type)element;
        }
        if (type != null) {
            return this.mofTypeFor(type);
        }
        return null;
    }

    protected EObject mofTypeFor(Type type) {
        Object eType = null;
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            EObject mofType = this.mofTypeFor(elementType);
            if (this.inMofContext && mofType instanceof EType) {
                EGenericType generic = this.mof.createEGenericType(true);
                generic.setEClassifier((EClassifier)this.mof.getEListEDataType());
                generic.getETypeArguments().add((EType)mofType);
                eType = generic;
            } else {
                ArrayType generic = this.factory.createArrayType();
                generic.setClassifier((Classifier)this.getMofSerializable("egl:eglx.lang.EList"));
                generic.getTypeArguments().add((Type)mofType);
                generic.setElementsNullable(((ArrayType)type).elementsNullable());
                eType = generic;
            }
        } else if (type != null) {
            String key = this.mofTypeSignatureFor(type);
            eType = this.getMofSerializable(key);
            if (eType == null && !key.startsWith("egl:") && type instanceof Annotation) {
                key = "egl:" + key;
                eType = this.getMofSerializable(key);
            }
            if (eType == null && type instanceof org.eclipse.edt.mof.egl.Part) {
                eType = this.inMofContext && this.isMofClass((org.eclipse.edt.mof.egl.Part)type) && type instanceof ExternalType ? this.createTempEClass((ExternalType)type) : this.createProxyPart(((org.eclipse.edt.mof.egl.Part)type).getFullyQualifiedName());
            }
        }
        return eType;
    }

    private String getMofDataTypeSignatureFor(Type type) {
        if (type == null) {
            return null;
        }
        Classifier classifier = type.getClassifier();
        if (classifier == null) {
            return null;
        }
        if (classifier.equals(TypeUtils.Type_ANY).booleanValue()) {
            return "org.eclipse.edt.mof.JavaObject";
        }
        if (classifier.equals(TypeUtils.Type_BOOLEAN).booleanValue()) {
            return "org.eclipse.edt.mof.EBoolean";
        }
        if (classifier.equals(TypeUtils.Type_STRING).booleanValue()) {
            return "org.eclipse.edt.mof.EString";
        }
        if (classifier.equals(TypeUtils.Type_INT).booleanValue() || type.equals(TypeUtils.Type_SMALLINT).booleanValue() || type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
            return "org.eclipse.edt.mof.EInt32";
        }
        if (classifier.equals(TypeUtils.Type_FLOAT).booleanValue() || type.equals(TypeUtils.Type_SMALLFLOAT).booleanValue()) {
            return "org.eclipse.edt.mof.EFloat";
        }
        if (classifier.equals(TypeUtils.Type_DECIMAL).booleanValue()) {
            return "org.eclipse.edt.mof.EDecimal";
        }
        return null;
    }

    protected String mofTypeSignatureFor(Type type) {
        String typeSignature;
        if (this.inMofContext) {
            typeSignature = this.getMofDataTypeSignatureFor(type);
            if (typeSignature != null) {
                return typeSignature;
            }
            String sig = BindingUtil.getETypeSignatureFromProxy((Element)type);
            if (sig != null) {
                return sig;
            }
        }
        if (type instanceof AnnotationType) {
            typeSignature = this.inMofContext && !this.inAnnotationTypeContext || this.isEMetadataType(type) ? ((AnnotationType)type).getETypeSignature() : type.getMofSerializationKey();
        } else if (type instanceof org.eclipse.edt.mof.egl.Part) {
            Stereotype ann;
            if (this.inMofProxyContext) {
                typeSignature = ((org.eclipse.edt.mof.egl.Part)type).getFullyQualifiedName();
            } else if (this.isMofProxy((org.eclipse.edt.mof.egl.Part)type)) {
                ann = ((org.eclipse.edt.mof.egl.Part)type).getStereotype();
                typeSignature = (String)this.getFieldValue((Annotation)ann, "packageName");
                if (typeSignature == null) {
                    typeSignature = ((org.eclipse.edt.mof.egl.Part)type).getCaseSensitivePackageName();
                }
                typeSignature = String.valueOf(typeSignature) + ".";
                String name = (String)this.getFieldValue((Annotation)ann, "name");
                if (name == null || "".equals(name)) {
                    name = ((org.eclipse.edt.mof.egl.Part)type).getCaseSensitiveName();
                }
                typeSignature = String.valueOf(typeSignature) + name;
            } else if (this.isReflectType((Type)((org.eclipse.edt.mof.egl.Part)type))) {
                ann = ((org.eclipse.edt.mof.egl.Part)type).getStereotype();
                String name = (String)this.getFieldValue((Annotation)ann, "name");
                if (name == null) {
                    name = ((org.eclipse.edt.mof.egl.Part)type).getCaseSensitiveName();
                }
                typeSignature = String.valueOf(((org.eclipse.edt.mof.egl.Part)type).getCaseSensitivePackageName()) + "." + name;
                if (!this.isMofReflectType((org.eclipse.edt.mof.egl.Part)type) && this.isEGLReflectType((org.eclipse.edt.mof.egl.Part)type)) {
                    typeSignature = "egl:" + typeSignature;
                }
            } else {
                typeSignature = type.getMofSerializationKey();
            }
        } else {
            typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EObject" : type.getMofSerializationKey();
        }
        return typeSignature;
    }

    String mofEDTReflectTypeSignature(IPartBinding binding) {
        boolean isMofTypeRef;
        boolean bl = isMofTypeRef = this.inMofContext && !this.inAnnotationTypeContext;
        String typeSignature = binding.getName().equalsIgnoreCase("fieldRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EField" : "egl.lang.reflect.reftypes.EGLFieldRef") : (binding.getName().equalsIgnoreCase("fieldInTargetRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EModelElement" : "egl.lang.reflect.reftypes.EGLFieldInTargetRef") : (binding.getName().equalsIgnoreCase("internalRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EModelElement" : "egl.lang.reflect.reftypes.EGLInternalRef") : (binding.getName().equalsIgnoreCase("partRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLPartRef") : (binding.getName().equalsIgnoreCase("functionRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EFunction" : "egl.lang.reflect.reftypes.EGLFunctionRef") : (binding.getName().equalsIgnoreCase("functionMemberRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EFunction" : "egl.lang.reflect.reftypes.EGLFunctionMemberRef") : (binding.getName().equalsIgnoreCase("typeRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EType" : "egl.lang.reflect.reftypes.EGLTypeRef") : (binding.getName().equalsIgnoreCase("serviceRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLServiceRef") : (binding.getName().equalsIgnoreCase("recordRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLRecordRef") : (binding.getName().equalsIgnoreCase("sqlString") ? (isMofTypeRef ? "org.eclipse.edt.mof.EString" : "egl.lang.reflect.reftypes.EGLSQLStringRef") : "org.eclipse.edt.mof.EObject")))))))));
        return typeSignature;
    }

    protected EObject getMofSerializable(String mofSignature) {
        EObject result = null;
        try {
            result = this.env.find(mofSignature);
        }
        catch (MofObjectNotFoundException mofObjectNotFoundException) {
            result = (EObject)processed.get(mofSignature);
        }
        catch (DeserializationException e2) {
            e2.printStackTrace();
            result = null;
        }
        return result;
    }

    private EObject newEObject(String typeSignature) {
        EClass eClass = (EClass)this.getMofSerializable(typeSignature);
        return eClass.newInstance();
    }

    private EClass createTempEClass(ExternalType part) {
        EClass eClass = this.mof.createEClass(true);
        eClass.setName(part.getCaseSensitiveName());
        eClass.setPackageName(part.getCaseSensitivePackageName());
        String key = part.getMofSerializationKey();
        this.env.save(key, (EObject)eClass, false);
        for (Field binding : part.getFields()) {
            EField field = this.mof.createEField(true);
            field.setName(binding.getCaseSensitiveName());
            EClass type = null;
            try {
                type = (EType)this.mofTypeFor(binding.getType());
                field.setEType((EType)type);
                field.setIsNullable(binding.isNullable());
            }
            catch (CircularBuildRequestException circularBuildRequestException) {
                type = MofFactory.INSTANCE.getEObjectClass();
            }
            eClass.addMember((EMember)field);
            field.setDeclarer((EMemberContainer)eClass);
        }
        Stereotype subtype = part.getStereotype();
        this.setReflectTypeValues((EObject)eClass, (Annotation)subtype);
        eClass.getMetadataList().add(this.getTempClassMarker());
        ArrayList<EClass> superTypes = new ArrayList<EClass>();
        for (StructPart superType : part.getSuperTypes()) {
            EObject obj = this.mofTypeFor((Type)superType);
            if (!(obj instanceof EClass)) continue;
            superTypes.add((EClass)obj);
        }
        eClass.addSuperTypes(superTypes);
        return eClass;
    }

    private boolean isTempEClass(EObject eclass) {
        return eclass instanceof EClass ? ((EClass)eclass).getMetadata(TempEClassMarker) != null : false;
    }

    private EMetadataObject getTempClassMarker() {
        EMetadataType temp = (EMetadataType)this.getMofSerializable(TempEClassMarker);
        if (temp == null) {
            temp = this.mof.createEMetadataType(true);
            temp.setName(TempEClassMarker);
            EField value = this.mof.createEField(true);
            value.setName("value");
            value.setEType((EType)this.mof.getEBooleanEDataType());
            value.setDeclarer((EMemberContainer)temp);
            value.setInitialValue((Object)true);
            temp.getEFields().add(value);
            this.env.save(TempEClassMarker, (EObject)temp, false);
        }
        return (EMetadataObject)temp.newInstance();
    }

    private ProxyEObject createProxyPart(String name) {
        String key;
        ProxyEClass type;
        if (this.inMofContext) {
            type = new ProxyEClass(name);
            key = type.getMofSerializationKey();
        } else {
            type = new ProxyPart(name);
            key = ((ProxyPart)type).getMofSerializationKey();
        }
        this.env.save(key, (EObject)type, false);
        return type;
    }

    private String concatWithSeparator(String[] fragments, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < fragments.length) {
            result.append(fragments[i]);
            if (i < fragments.length - 1) {
                result.append(separator);
            }
            ++i;
        }
        return result.toString();
    }

    private void eSet(EObject target, String fieldName, Object value) {
        EField field = target.getEClass().getEField(fieldName);
        this.eSet(target, field, value);
    }

    protected void eSet(EObject target, EField field, Object value) {
        Object convertedValue = this.mofValueFrom(value);
        if (field.getEType() instanceof EEnum && convertedValue instanceof Name) {
            EEnumLiteral lit = ((EEnum)field.getEType()).getEEnumLiteral(((Name)convertedValue).getId());
            if (lit != null) {
                convertedValue = lit;
            }
        } else if (field.getEType() instanceof EGenericType && ((EGenericType)field.getEType()).getETypeArguments().size() > 0 && ((EGenericType)field.getEType()).getETypeArguments().get(0) instanceof EEnum && convertedValue instanceof EList) {
            EEnum enumObj = (EEnum)((EGenericType)field.getEType()).getETypeArguments().get(0);
            EList newValue = new EList();
            Iterator iterator = ((EList)convertedValue).iterator();
            while (iterator.hasNext()) {
                EEnumLiteral lit;
                Object obj;
                Object val = obj = iterator.next();
                if (obj instanceof Name && (lit = enumObj.getEEnumLiteral(((Name)obj).getId())) != null) {
                    val = lit;
                }
                newValue.add(val);
            }
            convertedValue = newValue;
        }
        target.eSet(field, convertedValue);
    }

    private void eAdd(List list, Object value) {
        Object convertedValue = null;
        if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                convertedValue = this.mofValueFrom(obj);
                list.add(convertedValue);
                ++n2;
            }
        } else {
            for (Object obj : (List)value) {
                convertedValue = this.mofValueFrom(obj);
                list.add(convertedValue);
            }
        }
    }

    private boolean isAbstractFunction(Function function) {
        return function != null && function.getContainer() instanceof org.eclipse.edt.compiler.core.ast.ExternalType;
    }

    private boolean isReflectType(Type typeBinding) {
        boolean isReflectType;
        if (!(typeBinding instanceof org.eclipse.edt.mof.egl.Part)) {
            return false;
        }
        boolean bl = isReflectType = typeBinding instanceof AnnotationType || this.isEMetadataType((Type)((org.eclipse.edt.mof.egl.Part)typeBinding));
        if (!isReflectType) {
            org.eclipse.edt.mof.egl.Part part;
            boolean bl2 = isReflectType = this.getAnnotation((Element)typeBinding, "egl.lang.reflect.PartType") != null;
            if (!isReflectType && (part = (org.eclipse.edt.mof.egl.Part)typeBinding).getStereotype() != null) {
                isReflectType = this.getAnnotation((Element)((StereotypeType)part.getStereotype().getEClass()), "egl.lang.reflect.PartType") != null || this.getEMetadataObject((EModelElement)((StereotypeType)part.getStereotype().getEClass()), "PartType") != null;
            }
        }
        return isReflectType;
    }

    private MofSerializable getDefaultSuperType(Type typeBinding) {
        if (!(typeBinding instanceof org.eclipse.edt.mof.egl.Part)) {
            return null;
        }
        Stereotype subtype = ((org.eclipse.edt.mof.egl.Part)typeBinding).getStereotype();
        String superTypeName = null;
        if (subtype != null) {
            superTypeName = this.getDefaultSuperTypeSignature((org.eclipse.edt.mof.egl.Part)typeBinding);
        }
        return superTypeName != null ? (MofSerializable)this.getMofSerializable(superTypeName) : null;
    }

    private EClass getReflectedType(org.eclipse.edt.mof.egl.Part typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        Stereotype subtype = typeBinding.getStereotype();
        String reflectedTypeName = null;
        if (subtype != null) {
            reflectedTypeName = this.getReflectedTypeSignature(typeBinding);
        }
        return reflectedTypeName != null ? (EClass)this.getMofSerializable(reflectedTypeName) : null;
    }

    protected boolean isMofReflectType(org.eclipse.edt.mof.egl.Part typeBinding) {
        EClass reflectedType = this.getReflectedType(typeBinding);
        if (reflectedType != null) {
            return this.isSubClassOf(reflectedType, MofFactory.INSTANCE.getEModelElementClass());
        }
        return false;
    }

    private boolean isEGLReflectType(org.eclipse.edt.mof.egl.Part typeBinding) {
        EClass reflectedType = this.getReflectedType(typeBinding);
        if (reflectedType != null) {
            return this.isSubClassOf(reflectedType, IrFactory.INSTANCE.getElementEClass());
        }
        return false;
    }

    private String getDefaultSuperTypeSignature(org.eclipse.edt.mof.egl.Part type) {
        Stereotype subtype = type.getStereotype();
        Annotation reflectType = this.getAnnotation((Element)subtype, "egl.lang.reflect.DefaultSuperType");
        if (reflectType != null) {
            return ((Type)reflectType.getValue()).getMofSerializationKey();
        }
        if (this.isEMetadataType((Type)type)) {
            return "org.eclipse.edt.mof.EMetadataObject";
        }
        if (type instanceof AnnotationType) {
            return "org.eclipse.edt.mof.egl.Annotation";
        }
        if (type instanceof StereotypeType) {
            return "org.eclipse.edt.mof.egl.Stereotype";
        }
        return null;
    }

    private String getReflectedTypeSignature(org.eclipse.edt.mof.egl.Part type) {
        Stereotype subtype = type.getStereotype();
        if (subtype != null) {
            Annotation ann = this.getAnnotation((Element)((AnnotationType)subtype.getEClass()), "egl.lang.reflect.PartType");
            if (ann != null) {
                return (String)ann.getValue();
            }
            EMetadataObject meta = this.getEMetadataObject((EModelElement)((AnnotationType)subtype.getEClass()), "PartType");
            if (meta != null) {
                return (String)meta.eGet("value");
            }
        }
        if (this.isEMetadataType((Type)type)) {
            return "org.eclipse.edt.mof.EMetadataType";
        }
        if (type instanceof StereotypeType) {
            return "org.eclipse.edt.mof.egl.StereotypeType";
        }
        if (type instanceof AnnotationType) {
            return "org.eclipse.edt.mof.egl.AnnotationType";
        }
        return null;
    }

    protected boolean isEMetadataType(Type edtType) {
        if ("IsEMetadataType".equalsIgnoreCase(BindingUtil.getName((Element)edtType))) {
            return true;
        }
        Annotation ann = this.getAnnotation((Element)edtType, "egl.lang.reflect.IsEMetadataType");
        return ann != null && ((java.lang.Boolean)ann.getValue()).equals(java.lang.Boolean.TRUE);
    }

    protected boolean isEMetadataObject(Annotation ann) {
        return this.isEMetadataType((Type)((AnnotationType)ann.getEClass()));
    }

    private boolean isMofClass(org.eclipse.edt.mof.egl.Part edtType) {
        Stereotype ann = edtType.getStereotype();
        return ann != null && ann.getEClass().getName().equalsIgnoreCase("MofClass");
    }

    private boolean isMofDataType(org.eclipse.edt.mof.egl.Part edtType) {
        Stereotype ann = edtType.getStereotype();
        return ann != null && ann.getEClass().getName().equalsIgnoreCase("MofDataType");
    }

    private boolean isMofBaseType(org.eclipse.edt.mof.egl.Part edtType) {
        Stereotype ann = edtType.getStereotype();
        return ann != null && ann.getEClass().getName().equalsIgnoreCase("MofBaseType");
    }

    protected boolean isMofProxy(org.eclipse.edt.mof.egl.Part part) {
        Stereotype ann = part.getStereotype();
        return ann != null && ann.getEClass().getName().equalsIgnoreCase("MofClass") && (java.lang.Boolean)ann.eGet("isProxy") != false;
    }

    private EClass resolveProxy(org.eclipse.edt.mof.egl.Part part) {
        Stereotype ann = part.getStereotype();
        String packageName = (String)ann.eGet("packageName");
        String name = (String)ann.eGet("name");
        if (name == null || name.equals("")) {
            name = part.getName();
        }
        return (EClass)this.getMofSerializable(String.valueOf(packageName) + "." + name);
    }

    protected void setElementInformation(Node node, EObject obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            Annotation ann = this.factory.createDynamicAnnotation("EGL_Location");
            ann.setValue("len", (Object)new Integer(node.getLength()));
            ann.setValue("off", (Object)new Integer(node.getOffset()));
            ann.setValue("line", (Object)new Integer(this.getLine(node)));
            elem.addAnnotation(ann);
        }
        if (obj instanceof Classifier) {
            int packageSegmentCount = ((Classifier)obj).getCaseSensitivePackageName().split("\\.").length;
            String absPath = this.context.getAbsolutePath();
            if (!absPath.contains("/")) {
                absPath = absPath.replace("\\", "/");
            }
            String[] absPathSegments = absPath.split("\\/");
            StringBuilder fileName = new StringBuilder(100);
            int i = absPathSegments.length - packageSegmentCount - 1;
            while (i < absPathSegments.length) {
                fileName.append(absPathSegments[i]);
                if (i + 1 < absPathSegments.length) {
                    fileName.append("/");
                }
                ++i;
            }
            ((Classifier)obj).setFileName(fileName.toString());
        }
    }

    private int getLine(Node node) {
        if (this.context != null) {
            return this.context.getLineNumber(node);
        }
        return 0;
    }

    protected void setUpEglTypedElement(TypedElement obj, Member edtObj) {
        Type type = null;
        EObject mofType = this.mofTypeFor(edtObj.getType());
        if (mofType instanceof Type) {
            type = (Type)mofType;
        }
        if (this.getPartBeingProcessed() == null) {
            System.out.println("Null processing part: " + obj.toStringHeader());
        } else {
            type = this.handleGenericType(type);
        }
        obj.setType(type);
        obj.setName(edtObj.getCaseSensitiveName());
        obj.setIsNullable(edtObj.isNullable());
    }

    protected String mofPartTypeSignatureFor(Part node) {
        org.eclipse.edt.mof.egl.Part part = (org.eclipse.edt.mof.egl.Part)node.getName().resolveType();
        return this.mofPartTypeSignatureFor(part);
    }

    protected String mofPartTypeSignatureFor(org.eclipse.edt.mof.egl.Part part) {
        if (this.isReflectType((Type)part)) {
            return this.getReflectedTypeSignature(part);
        }
        if (this.inMofContext) {
            if (part instanceof Enumeration) {
                return "org.eclipse.edt.mof.EEnum";
            }
            if (part instanceof ExternalType) {
                return "org.eclipse.edt.mof.EClass";
            }
        }
        return part.getEClass().getETypeSignature();
    }

    private boolean isSubClassOf(EClass child, EClass parent) {
        return BindingUtil.isSubClassOf(child, parent);
    }

    private Type handleGenericType(Type type) {
        Classifier part;
        if (type != null && type.getTypeSignature().equals("eglx.lang.EAny") && !(part = (Classifier)this.getPartBeingProcessed()).getTypeParameters().isEmpty()) {
            type = this.factory.createGenericType();
            ((GenericType)type).setTypeParameter((TypeParameter)part.getTypeParameters().get(0));
            return type;
        }
        if (type instanceof ArrayType) {
            ArrayType arrType = (ArrayType)type;
            Type newType = this.handleGenericType(arrType.getElementType());
            if (newType != null && newType != arrType.getElementType()) {
                arrType.getTypeArguments().remove(0);
                arrType.getTypeArguments().add(0, newType);
            }
            return arrType;
        }
        return type;
    }
}

