/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.sdk.compile;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;

public class EGLCArgumentProcessor {
    private static final String SOURCE_PATH = "-eglPath";
    private static final String IR_OUTPUT_PATH = "-irDestination";
    private static final String CLEAN = "-clean";
    private static final String NLSCODE = "-nlsCode";
    private static final String MSGTABLEPREFIX = "-msgTablePrefix";

    public EGLCArguments createDefaultArguments() {
        return new EGLCArguments();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EGLCArguments processArguments(String[] args) {
        EGLCArguments arguments = new EGLCArguments();
        try {
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    return arguments;
                }
                int newindex = this.processArgument(arguments, args, i);
                if (newindex == -1) {
                    System.out.println("Invalid option: " + args[i]);
                    this.processError();
                    return null;
                }
                i = newindex;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.processError();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processArgument(EGLCArguments arguments, String[] args, int index) {
        int newindex = index;
        if (args[newindex].charAt(0) == '-') {
            if (args[newindex].equalsIgnoreCase(SOURCE_PATH)) {
                arguments.setSourcePath(EGLCArgumentProcessor.processPath(args[newindex + 1]));
                arguments.setPartPath(EGLCArgumentProcessor.processPath(args[newindex + 1]));
                newindex += 2;
                return newindex;
            } else if (args[newindex].equalsIgnoreCase(CLEAN)) {
                arguments.setClean(true);
                ++newindex;
                return newindex;
            } else if (args[newindex].equalsIgnoreCase(NLSCODE)) {
                arguments.setNlsCode(args[newindex + 1]);
                newindex += 2;
                return newindex;
            } else if (args[newindex].equalsIgnoreCase(MSGTABLEPREFIX)) {
                arguments.setMsgTablePrefix(args[newindex + 1]);
                newindex += 2;
                return newindex;
            } else {
                if (!args[newindex].equalsIgnoreCase(IR_OUTPUT_PATH)) return -1;
                arguments.setIROutputPath(new File(args[newindex + 1]));
                newindex += 2;
            }
            return newindex;
        } else {
            arguments.initPartFiles(args[newindex]);
            ++newindex;
        }
        return newindex;
    }

    private void processError() {
        System.out.println("Usage: eglc -eglPath <path> -clean -irDestination <path> <partFiles>");
    }

    private static File[] processPath(String partPath) {
        ArrayList<File> partPathLocations = new ArrayList<File>();
        StringTokenizer partPathTokenizer = new StringTokenizer(partPath, File.pathSeparator);
        while (partPathTokenizer.hasMoreTokens()) {
            partPathLocations.add(new File(partPathTokenizer.nextToken()));
        }
        return partPathLocations.toArray(new File[partPathLocations.size()]);
    }

    public class EGLCArguments {
        private File[] sourcePath = null;
        private File[] partPath = null;
        private File irOutputPath = null;
        private File[] partFiles = null;
        private boolean bClean = false;
        private ArrayList list = new ArrayList();
        private String nlsCode = null;
        private String msgTablePrefix = null;

        public boolean isClean() {
            return this.bClean;
        }

        public String getNlsCode() {
            return this.nlsCode;
        }

        public void setNlsCode(String str) {
            this.nlsCode = str;
        }

        public String getMsgTablePrefix() {
            return this.msgTablePrefix;
        }

        public void setMsgTablePrefix(String str) {
            this.msgTablePrefix = str;
        }

        public void setClean(boolean clean) {
            this.bClean = clean;
        }

        public File[] getSourcePathEntries() {
            if (this.sourcePath == null) {
                return this.getPartPathEntries();
            }
            return this.sourcePath;
        }

        public File[] getPartPathEntries() {
            if (this.partPath == null) {
                return new File[]{new File(System.getProperty("user.dir"))};
            }
            return this.partPath;
        }

        public File getIROutputPath() {
            return this.irOutputPath;
        }

        public File[] getPartFiles() {
            if (this.partFiles == null) {
                this.partFiles = this.list.toArray(new File[this.list.size()]);
            }
            return this.partFiles;
        }

        protected void initPartFiles(String pattern) {
            this.list.addAll(Util.getPartFiles(pattern, ".egl"));
        }

        protected void setPartPath(File[] partPath) {
            this.partPath = partPath;
        }

        protected void setSourcePath(File[] sourcePath) {
            this.sourcePath = sourcePath;
        }

        protected void setIROutputPath(File file) {
            this.irOutputPath = file;
        }
    }
}

