/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUIStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Include;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.FileBrowseDialog;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EGLDDImportsFormPage
extends EGLDDBaseFormPage {
    private static final int COLINDEX_LOCATION = 0;
    private static final int DEFAULT_COLUMN_WIDTH = 300;
    private Button fBtnRemoveInclude;
    private Button fBtnOpenInclude;
    private TableViewer fIncludeTV;
    private static final String[] TABLE_INCLUDE_COLUMN_PROPERTIES = new String[]{"COL_LOCATION"};

    public EGLDDImportsFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(SOAMessages.ImportPageLabel);
        EGLDeploymentRoot eglDDRoot = this.getModelRoot();
        managedForm.setInput((Object)eglDDRoot);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        form.getBody().setLayout((Layout)layout);
        this.createIncludesSection(form, toolkit, eglDDRoot);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), this.getHelpID());
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.fIncludeTV.refresh();
        }
    }

    public void setFocus() {
        if (this.fIncludeTV != null) {
            this.fIncludeTV.getTable().setFocus();
        }
    }

    private void createIncludesSection(ScrolledForm form, FormToolkit toolkit, Object input) {
        Composite client = EGLDDImportsFormPage.createNonExpandableSection(form, toolkit, SOAMessages.ImportsSectionTitle, SOAMessages.ImportsSectionDescription, 2);
        Table t = this.createIncludeTableControl(client, toolkit, "", "");
        Composite buttonComposite = toolkit.createComposite(client);
        GridLayout layout = new GridLayout(1, true);
        GridData gd = new GridData(2);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gd);
        Button btnAdd = toolkit.createButton(buttonComposite, SOAMessages.AddLabel, 8);
        gd = new GridData(800);
        btnAdd.setLayoutData((Object)gd);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDImportsFormPage.this.HandleAddIncludePressed();
            }
        });
        this.fBtnRemoveInclude = toolkit.createButton(buttonComposite, SOAMessages.RemoveLabel, 8);
        gd = new GridData(800);
        this.fBtnRemoveInclude.setLayoutData((Object)gd);
        this.fBtnRemoveInclude.setEnabled(false);
        this.fBtnRemoveInclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDImportsFormPage.this.HandleRemoveIncludePressed();
            }
        });
        this.fBtnOpenInclude = toolkit.createButton(buttonComposite, SOAMessages.OpenLabel, 8);
        gd = new GridData(800);
        this.fBtnOpenInclude.setLayoutData((Object)gd);
        this.fBtnOpenInclude.setEnabled(false);
        this.fBtnOpenInclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDImportsFormPage.this.HandleOpenIncludePressed();
            }
        });
        this.fIncludeTV = new TableViewer(t);
        this.fIncludeTV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EGLDDImportsFormPage.this.fBtnRemoveInclude.setEnabled(true);
                EGLDDImportsFormPage.this.fBtnOpenInclude.setEnabled(true);
            }
        });
        TextCellEditor[] cellEditors = new TextCellEditor[TABLE_INCLUDE_COLUMN_PROPERTIES.length];
        cellEditors[0] = new TextCellEditor((Composite)t);
        this.fIncludeTV.setCellEditors((CellEditor[])cellEditors);
        this.fIncludeTV.setCellModifier((ICellModifier)new IncludeCellModifier());
        this.fIncludeTV.setColumnProperties(TABLE_INCLUDE_COLUMN_PROPERTIES);
        this.fIncludeTV.setContentProvider((IContentProvider)new IncludeListContentProvider());
        this.fIncludeTV.setLabelProvider((IBaseLabelProvider)new IncludeListLabelProvider());
        this.fIncludeTV.setInput((Object)this.getModelRoot());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, IUIHelpConstants.EGLDD_EDITOR_IMPORTPAGE);
    }

    protected void HandleOpenIncludePressed() {
        Object obj;
        IStructuredSelection ssel = (IStructuredSelection)this.fIncludeTV.getSelection();
        if (ssel.size() == 1 && (obj = ssel.getFirstElement()) instanceof Include) {
            IProject proj = ((EGLDeploymentDescriptorEditor)this.getEditor()).getProject();
            Include include = (Include)obj;
            String includeLocation = include.getLocation();
            IFile includeFile = proj.getWorkspace().getRoot().getFile((IPath)new Path(includeLocation));
            if (includeFile != null && includeFile.exists()) {
                try {
                    EditorUtility.openInEditor((Object)includeFile, true);
                }
                catch (PartInitException e) {
                    EDTUIPlugin.log(e);
                }
                catch (EGLModelException e) {
                    EDTUIPlugin.log(e);
                }
            } else {
                IStatus status = EGLUIStatus.createError(-1, SOAMessages.bind((String)SOAMessages.ModuleBaseDetailPageFileNotExist, (Object)includeFile), null);
                ErrorDialog.openError((Shell)this.getSite().getShell(), null, null, (IStatus)status);
            }
        }
    }

    protected void HandleRemoveIncludePressed() {
        IStructuredSelection ssel = (IStructuredSelection)this.fIncludeTV.getSelection();
        if (ssel.size() == 1) {
            Deployment deployment;
            boolean success;
            EGLDeploymentRoot root;
            Object obj = ssel.getFirstElement();
            int selectionIndex = this.fIncludeTV.getTable().getSelectionIndex();
            if (obj instanceof Include && (root = this.getModelRoot()) != null && (success = (deployment = root.getDeployment()).getInclude().remove(obj))) {
                EGLDDImportsFormPage.updateTableViewerAfterRemove(selectionIndex, this.fIncludeTV, this.fBtnRemoveInclude);
                int newCnt = this.fIncludeTV.getTable().getItemCount();
                if (newCnt <= 0) {
                    this.fBtnOpenInclude.setEnabled(false);
                }
            }
        }
    }

    protected void HandleAddIncludePressed() {
        Object obj;
        IProject proj = ((EGLDeploymentDescriptorEditor)this.getEditor()).getProject();
        EGLDeploymentRoot root = this.getModelRoot();
        Deployment deployment = root.getDeployment();
        ElementTreeSelectionDialog dialog = FileBrowseDialog.openBrowseFileOnEGLPathDialog(this.getSite().getShell(), proj, null, IUIHelpConstants.EGLDDWIZ_INCLUDEEGLDD, "egldd", SOAMessages.IncludeDialogTitle, SOAMessages.IncludeDialogDescription, SOAMessages.IncludeDialogMsg, (EList<Include>)deployment.getInclude(), ((EGLDeploymentDescriptorEditor)this.getEditor()).getEditorInputFile());
        if (dialog.open() == 0 && (obj = dialog.getFirstResult()) instanceof IFile) {
            Include newInclude = DeploymentFactory.eINSTANCE.createInclude();
            newInclude.setLocation(((IFile)obj).getFullPath().toString());
            deployment.getInclude().add((Object)newInclude);
            EGLDDImportsFormPage.updateTableViewerAfterAdd(this.fIncludeTV, newInclude);
        }
    }

    private Table createIncludeTableControl(Composite client, FormToolkit toolkit, String nameColText, String valColText) {
        Table t = toolkit.createTable(client, 66308);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        TableColumn col = new TableColumn(t, 16384, 0);
        col.setText(SOAMessages.TableColInlcudeFile);
        col.pack();
        int maxWidth = 300;
        int tableColWidth = Math.max(300, col.getWidth());
        maxWidth = Math.max(maxWidth, tableColWidth);
        ColumnWeightData colData = new ColumnWeightData(tableColWidth, tableColWidth, true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)colData);
        t.setLayout((Layout)tableLayout);
        toolkit.paintBordersFor(client);
        return t;
    }

    public boolean selectReveal(Object object) {
        this.fIncludeTV.setSelection((ISelection)object, true);
        return super.selectReveal(object);
    }

    @Override
    protected String getHelpID() {
        return IUIHelpConstants.EGLDD_EDITOR_IMPORTPAGE;
    }

    private class IncludeCellModifier
    implements ICellModifier {
        private IncludeCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return false;
        }

        public Object getValue(Object element, String property) {
            String value = "";
            if (element instanceof Include) {
                value = ((Include)element).getLocation();
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem;
            Object tableitemdata;
            if (element instanceof TableItem && (tableitemdata = (tableItem = (TableItem)element).getData()) instanceof Include) {
                String newVal = (String)value;
                ((Include)tableitemdata).setLocation(newVal);
                tableItem.setText(0, newVal);
            }
        }
    }

    public static class IncludeListContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            ArrayList children = new ArrayList();
            if (inputElement instanceof EGLDeploymentRoot) {
                EGLDeploymentRoot root = (EGLDeploymentRoot)inputElement;
                Deployment deployment = root.getDeployment();
                children.addAll(deployment.getInclude());
            }
            return children.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class IncludeListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Include) {
                return ((Include)element).getLocation();
            }
            return "";
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

