/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.folding;

import java.util.Hashtable;
import java.util.List;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class FoldingVisitor
extends AbstractASTVisitor {
    private Hashtable fRegions;
    private IDocument fEGLDocument;
    private boolean fCollapseComments;
    private boolean fCollapseParts;
    private boolean fCollapseFunctions;
    private boolean fCollapseImportContainer;
    private boolean fCollapsePartition;
    private boolean fCollapseProperties;
    private int fPropThreshold;
    private boolean fAllowCollapsing;
    private int fImportStartLine = -1;
    private int fImportEndLine = -1;

    public FoldingVisitor(IDocument document, Hashtable regions, boolean allowCollapsing) {
        this.fEGLDocument = document;
        this.fRegions = regions;
        this.fAllowCollapsing = allowCollapsing;
        this.initializePreferences();
    }

    private void initializePreferences() {
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        this.fCollapseComments = store.getBoolean("editor_folding_comments");
        this.fCollapseParts = store.getBoolean("editor_folding_parts");
        this.fCollapseFunctions = store.getBoolean("editor_folding_functions");
        this.fCollapseImportContainer = store.getBoolean("editor_folding_imports");
        this.fCollapseProperties = store.getBoolean("editor_folding_propertiesblocks");
        this.fPropThreshold = store.getInt("editor_folding_propertiesblocks_threshold");
        this.fCollapsePartition = store.getBoolean("editor_folding_partitions");
    }

    public boolean visit(DataItem dataItem) {
        this.addNodeToFoldingRegion(dataItem, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(File file) {
        return true;
    }

    public void endVisit(File file) {
        try {
            if (this.fImportStartLine != -1 && this.fImportEndLine != -1) {
                FoldingVisitor.addToFoldingRegion(this.fEGLDocument, this.fRegions, this.fCollapseImportContainer && this.fAllowCollapsing, this.fImportStartLine, this.fImportEndLine, 2);
            }
            List listBlockComments = file.getBlockComments();
            for (Symbol blockComment : listBlockComments) {
                int startingline = this.fEGLDocument.getLineOfOffset(blockComment.left);
                if (blockComment.right > this.fEGLDocument.getLength()) continue;
                int endingline = this.fEGLDocument.getLineOfOffset(blockComment.right);
                FoldingVisitor.addToFoldingRegion(this.fEGLDocument, this.fRegions, this.fCollapseComments && this.fAllowCollapsing, startingline, endingline, 2);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        try {
            if (this.fImportStartLine == -1) {
                this.fImportStartLine = this.fEGLDocument.getLineOfOffset(importDeclaration.getOffset());
            }
            this.fImportEndLine = this.fEGLDocument.getLineOfOffset(importDeclaration.getOffset() + importDeclaration.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean visit(NestedFunction nestedFunction) {
        this.addNodeToFoldingRegion(nestedFunction, this.fCollapseFunctions && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Interface interfacePart) {
        this.addNodeToFoldingRegion(interfacePart, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Library library) {
        this.addNodeToFoldingRegion(library, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Program program) {
        this.addNodeToFoldingRegion(program, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Class eglClass) {
        this.addNodeToFoldingRegion(eglClass, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(ExternalType externalType) {
        this.addNodeToFoldingRegion(externalType, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Delegate delegate) {
        this.addNodeToFoldingRegion(delegate, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Enumeration enumeration) {
        this.addNodeToFoldingRegion(enumeration, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(SettingsBlock propertyBlock) {
        this.addNodeToFoldingRegion(propertyBlock, this.fCollapseProperties && this.fAllowCollapsing, this.fPropThreshold);
        return false;
    }

    public boolean visit(Record record) {
        this.addNodeToFoldingRegion(record, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Handler reportHandler) {
        this.addNodeToFoldingRegion(reportHandler, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(Service service) {
        this.addNodeToFoldingRegion(service, this.fCollapseParts && this.fAllowCollapsing);
        return true;
    }

    public boolean visit(InlineSQLStatement inlineSQLStatement) {
        this.addNodeToFoldingRegion(inlineSQLStatement, this.fCollapsePartition && this.fAllowCollapsing);
        return false;
    }

    private void addNodeToFoldingRegion(Object obj, boolean isCollapsed) {
        this.addNodeToFoldingRegion(obj, isCollapsed, 2);
    }

    private void addNodeToFoldingRegion(Object obj, boolean isCollapsed, int numLines) {
        try {
            if (obj instanceof Node) {
                Node partnode = (Node)obj;
                int partStartLine = this.fEGLDocument.getLineOfOffset(partnode.getOffset());
                int partEndLine = this.fEGLDocument.getLineOfOffset(partnode.getOffset() + partnode.getLength());
                FoldingVisitor.addToFoldingRegion(this.fEGLDocument, this.fRegions, isCollapsed, partStartLine, partEndLine, numLines);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void addToFoldingRegion(IDocument doc, Hashtable regions, boolean isCollapsed, int startLine, int endLine, int numLines) throws BadLocationException {
        if (endLine - startLine + 1 >= numLines) {
            int start = doc.getLineOffset(startLine);
            int end = doc.getLineOffset(endLine) + doc.getLineLength(endLine);
            Position position = new Position(start, end - start);
            Boolean IsCollapsed = new Boolean(isCollapsed);
            regions.put(position, IsCollapsed);
        }
    }

    public Hashtable getRegions() {
        return this.fRegions;
    }
}

