/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerUtil;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarPackageWizardPage;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public abstract class AbstractEglarDestinationWizardPage
extends WizardExportResourcesPage
implements IEglarPackageWizardPage {
    private final String fStoreDestinationNamesId;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private final EglarPackageData fEglarPackage;

    public AbstractEglarDestinationWizardPage(String pageName, IStructuredSelection selection, EglarPackageData eglarPackage) {
        super(pageName, selection);
        this.fStoreDestinationNamesId = String.valueOf(pageName) + ".DESTINATION_NAMES_ID";
        this.fEglarPackage = eglarPackage;
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        String label = this.getDestinationLabel();
        if (label != null) {
            new Label(destinationSelectionGroup, 0).setText(label);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.fDestinationNamesCombo = new Combo(destinationSelectionGroup, 2052);
        SWTUtil.setDefaultVisibleItemCount(this.fDestinationNamesCombo);
        this.fDestinationNamesCombo.addListener(24, (Listener)this);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = label == null ? 2 : 1;
        this.fDestinationNamesCombo.setLayoutData((Object)data);
        if (label == null) {
            SWTUtil.setAccessibilityText((Control)this.fDestinationNamesCombo, EglarPackagerMessages.AbstractEglarDestinationWizardPage_destinationCombo_AccessibilityText);
        }
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(EglarPackagerMessages.EglarPackageWizardPage_browseButton_text);
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowseButton);
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEglarDestinationWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 0x10000000);
        dialog.setMessage(this.getBrowseDialogTitle());
        String dirName = this.getDestinationValue();
        if (dirName.length() == 0) {
            dialog.setFilterPath(EDTUIPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        this.fDestinationNamesCombo.setText(selectedDirectory);
    }

    protected abstract String getBrowseDialogTitle();

    protected String getDestinationValue() {
        String destinationText = this.fDestinationNamesCombo.getText().trim();
        return destinationText;
    }

    protected void setDestinationValue(String valueToSet) {
        this.fDestinationNamesCombo.setText(valueToSet);
    }

    protected String getDestinationLabel() {
        return EglarPackagerMessages.EglarPackageWizardPage_destination_label;
    }

    protected String getOutputSuffix() {
        return ".eglar";
    }

    protected void restoreLocation() {
        if (this.fEglarPackage.getEglarLocation().isEmpty()) {
            this.fDestinationNamesCombo.setText("");
        } else {
            this.fDestinationNamesCombo.setText(this.fEglarPackage.getEglarLocation().toOSString());
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                return;
            }
            if (!this.fDestinationNamesCombo.getText().equals(directoryNames[0])) {
                this.fDestinationNamesCombo.add(this.fDestinationNamesCombo.getText());
            }
            int i = 0;
            while (i < directoryNames.length) {
                this.fDestinationNamesCombo.add(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void updateModel() {
        String comboText = this.fDestinationNamesCombo.getText();
        IPath path = Path.fromOSString((String)comboText);
        this.fEglarPackage.setEglarLocation(path);
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.setErrorMessage(EglarPackagerMessages.EglarPackageWizardPage_error_EglarFileExistsAndNotWritable);
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation != null && workspaceLocation.isPrefixOf(this.fEglarPackage.getAbsoluteEglarLocation())) {
            int segments = workspaceLocation.matchingFirstSegments(this.fEglarPackage.getAbsoluteEglarLocation());
            IPath path = this.fEglarPackage.getAbsoluteEglarLocation().removeFirstSegments(segments);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 1 && EglarPackagerUtil.contains(EglarPackagerUtil.asResources(this.fEglarPackage.getElements()), (IFile)resource)) {
                this.setErrorMessage(EglarPackagerMessages.EglarPackageWizardPage_error_cantExportEglarIntoItself);
                return false;
            }
        }
        String currentMessage = this.getMessage();
        if (!new File(this.fDestinationNamesCombo.getText()).isAbsolute()) {
            if (currentMessage == null) {
                this.setMessage(EglarPackagerMessages.EglarPackageWizardPage_info_relativeExportDestination, 1);
            }
        } else if (currentMessage != null) {
            this.setMessage(null);
        }
        return this.ensureTargetFileIsValid(this.fEglarPackage.getAbsoluteEglarLocation().toFile());
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(this.fStoreDestinationNamesId, directoryNames);
        }
    }

    protected void initializeEglarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.fStoreDestinationNamesId);
            if (directoryNames == null) {
                return;
            }
            this.fEglarPackage.setEglarLocation(Path.fromOSString((String)directoryNames[0]));
        }
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }
}

