/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.utils.ResourceAndTLFMap;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.utils.EGLProjectInfoUtility;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarFileExportOperation;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarOutputStream;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerUtil;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarUtility;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarWriterUtility;
import org.eclipse.edt.ide.ui.internal.property.pages.BasicElementLabels;
import org.eclipse.edt.ide.ui.internal.property.pages.Messages;
import org.eclipse.swt.widgets.Shell;

public class NewEglarFileExportOperation
extends EglarFileExportOperation {
    public static final String EGLBLD_EXTENSION = "eglbld";
    public static final String EGLDD_EXTENSION = "egldd";
    public static final String EGL_EXTENSION = "egl";
    public static final String EGL_GEN_FOLDER = "EGLGen";
    public static final String EGL_BIN_FOLDER = "EGLBin";
    public static final String EGL_WEB_CONTENT = "WebContent";
    public static final String EGL_ICONS = "icons";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String EGL_GEN_JAVA_FOLDER = "JavaSource";
    public static final String CUI_MESSAGE_SOURCE_FOLDER = "MessageSource";

    public NewEglarFileExportOperation(EglarPackageData eglarPackage, Shell parent) {
        super(eglarPackage, parent);
    }

    @Override
    protected void exportSelectedElements(IProgressMonitor progressMonitor) throws InterruptedException, CoreException {
        Object element;
        int n = this.getfEglarPackage().getElements().length;
        HashMap<IEGLProject, ResourceAndTLFMap[]> prjAndTlfMap = new HashMap<IEGLProject, ResourceAndTLFMap[]>();
        boolean haveTLF = false;
        int i = 0;
        while (i < n) {
            element = this.getfEglarPackage().getElements()[i];
            IEGLProject eglProj = (IEGLProject)element;
            ResourceAndTLFMap[] tlfSources = EglarPackagerUtil.getTopLevelFunctionFiles(eglProj);
            if (tlfSources != null && tlfSources.length > 0) {
                haveTLF = true;
                prjAndTlfMap.put(eglProj, tlfSources);
            }
            ++i;
        }
        if (haveTLF) {
            if (!EglarPackagerUtil.askToExportTLFSource(this.getfParentShell())) {
                this.getfEglarPackage().setExportTLFSrcFiles(false);
            } else {
                this.getfEglarPackage().setExportTLFSrcFiles(true);
            }
        }
        i = 0;
        while (i < n) {
            block20: {
                element = this.getfEglarPackage().getElements()[i];
                try {
                    try {
                        IEGLProject eglProject = (IEGLProject)element;
                        Path path = new Path(this.getfEglarPackage().getBaseEglarLocation().toOSString());
                        path = path.append(String.valueOf(eglProject.getElementName()) + ".eglar");
                        this.getfEglarPackage().setEglarLocation((IPath)path);
                        this.setfEglarBuilder(this.getfEglarPackage().getEglarBuilder());
                        this.getfEglarBuilder().open(this.getfEglarPackage(), this.getfParentShell(), this.getfStatus());
                        this.exportEGLProject2NewEGLAR(eglProject, progressMonitor, (ResourceAndTLFMap[])prjAndTlfMap.get(eglProject));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        try {
                            if (this.getfEglarBuilder() != null) {
                                this.getfEglarBuilder().close();
                            }
                        }
                        catch (CoreException ex) {
                            this.addToStatus(ex);
                        }
                        progressMonitor.done();
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (this.getfEglarBuilder() != null) {
                            this.getfEglarBuilder().close();
                        }
                    }
                    catch (CoreException ex) {
                        this.addToStatus(ex);
                    }
                    progressMonitor.done();
                    throw throwable;
                }
                try {
                    if (this.getfEglarBuilder() != null) {
                        this.getfEglarBuilder().close();
                    }
                }
                catch (CoreException ex) {
                    this.addToStatus(ex);
                }
                progressMonitor.done();
            }
            ++i;
        }
    }

    protected void exportEGLProject2NewEGLAR(IEGLProject eglProject, IProgressMonitor progressMonitor, ResourceAndTLFMap[] resAndTLFMap) throws CoreException {
        IResource srcFolder;
        IResource ruiIcons;
        IResource ruiResFolder;
        IResource genFolder;
        IResource[] binJavaClassFolders;
        this.getfEglarBuilder().writeFolder((IResource)eglProject.getProject(), eglProject.getProject().getFullPath());
        IResource binIRFolder = this.getBinaryIRFolder(eglProject);
        if (binIRFolder != null) {
            this.exportIR(binIRFolder, resAndTLFMap, progressMonitor);
        }
        if ((binJavaClassFolders = EglarUtility.getGeneratedJavaClassFolder(eglProject.getProject())) != null) {
            HashSet addedSet = new HashSet();
            this.exportJavaClassFolders(eglProject.getProject(), binJavaClassFolders, progressMonitor);
            int i = 0;
            while (i < binJavaClassFolders.length) {
                if (binJavaClassFolders[i].exists()) {
                    this.exportJavaDeployFiles(eglProject.getProject(), binJavaClassFolders[i], progressMonitor, addedSet);
                }
                ++i;
            }
            IFolder javaSourceFolder = eglProject.getProject().getFolder(EGLProjectInfoUtility.getGeneratedJavaFolder((IProject)eglProject.getProject())[0]);
            this.exportJavaDeployFiles(eglProject.getProject(), (IResource)javaSourceFolder, progressMonitor, addedSet);
        }
        if ((genFolder = this.getGenFolder(eglProject.getProject())) != null && genFolder.exists() && genFolder instanceof IContainer) {
            IResource[] subFolders;
            IResource[] iResourceArray = subFolders = ((IContainer)genFolder).members();
            int n = subFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource subFolder = iResourceArray[n2];
                if (!subFolder.getName().equals(EGL_GEN_JAVA_FOLDER)) {
                    this.exportGeneralFolder(subFolder, (IPath)new Path(""), progressMonitor);
                }
                ++n2;
            }
        }
        if ((ruiResFolder = this.getRuiResourceFolder(eglProject.getProject())) != null && ruiResFolder.exists()) {
            this.exportGeneralFolder(ruiResFolder, (IPath)new Path(""), progressMonitor);
        }
        if ((ruiIcons = this.getRuiIconsFolder(eglProject.getProject())) != null && ruiIcons.exists()) {
            this.exportGeneralFolder(ruiIcons, (IPath)new Path(""), progressMonitor);
        }
        if ((srcFolder = this.getSrcFolder(eglProject)) != null && srcFolder.exists()) {
            this.exportEGLSrcFolder(srcFolder, (IPath)new Path(""), progressMonitor, this.getfEglarPackage().areEGLSrcFilesExported());
        }
        if (this.getfEglarPackage().areTLFSrcFilesExported() && resAndTLFMap != null) {
            this.exportEGLSourceFiles(resAndTLFMap, (IPath)new Path(""), progressMonitor);
        }
        this.exportEGLbinFiles(this.getBinFolder(eglProject.getProject()), progressMonitor);
    }

    private void exportEGLSourceFiles(ResourceAndTLFMap[] maps, IPath rootFolder, IProgressMonitor progressMonitor) throws CoreException {
        ResourceAndTLFMap[] resourceAndTLFMapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceAndTLFMap map = resourceAndTLFMapArray[n2];
            if (map.getResource() instanceof IFile) {
                IPath relPath = map.getResource().getFullPath().removeFirstSegments(1);
                this.getfEglarBuilder().writeFile((IFile)map.getResource(), rootFolder.append(relPath));
            }
            ++n2;
        }
    }

    private void exportEGLbinFiles(IResource eglbin, final IProgressMonitor progressMonitor) throws CoreException {
        eglbin.accept(new IResourceVisitor(){
            int i = 0;

            public boolean visit(IResource resource) throws CoreException {
                progressMonitor.worked(this.i++);
                progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                IPath relPath = resource.getFullPath().removeFirstSegments(1);
                switch (resource.getType()) {
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (((IFile)resource).getFileExtension().equals(NewEglarFileExportOperation.EGLDD_EXTENSION)) {
                            NewEglarFileExportOperation.this.getfEglarBuilder().writeFile((IFile)resource, relPath);
                        }
                        return false;
                    }
                }
                return false;
            }
        });
    }

    private IResource getRuiResourceFolder(IProject project) {
        Path newPath = new Path(EGL_WEB_CONTENT);
        return project.getFolder((IPath)newPath);
    }

    private IResource getRuiIconsFolder(IProject project) {
        Path newPath = new Path(EGL_ICONS);
        return project.getFolder((IPath)newPath);
    }

    private IResource getGenFolder(IProject project) {
        Path newPath = new Path(EGL_GEN_FOLDER);
        return project.getFolder((IPath)newPath);
    }

    private IResource getBinFolder(IProject project) {
        Path newPath = new Path(EGL_BIN_FOLDER);
        return project.getFolder((IPath)newPath);
    }

    private IResource getBinaryIRFolder(IEGLProject eglProject) {
        try {
            IPath output = eglProject.getOutputLocation();
            if (output != null && "bin".equalsIgnoreCase(output.lastSegment())) {
                output = eglProject.getPath().append(EGL_BIN_FOLDER);
            }
            return eglProject.getProject().getFolder(output.removeFirstSegments(1));
        }
        catch (EGLModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IResource getSrcFolder(IEGLProject project) {
        try {
            if (EGLProject.hasEGLNature((IProject)project.getProject())) {
                IEGLPathEntry[] entries;
                IEGLPathEntry[] iEGLPathEntryArray = entries = project.getRawEGLPath();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IEGLPathEntry classpathEntry = iEGLPathEntryArray[n2];
                    if (classpathEntry.getEntryKind() == 3) {
                        return project.getProject().getFolder(classpathEntry.getPath().removeFirstSegments(1));
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void exportJavaClassFolders(IProject project, IResource[] javaClassFolders, final IProgressMonitor progressMonitor) throws CoreException {
        IPath newPath = new Path("Java_Jars/").append(String.valueOf(project.getName()) + JAR_FILE_EXTENSION);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            try {
                EglarOutputStream jarOutputStream = new EglarOutputStream(new BufferedOutputStream(outputStream));
                final EglarWriterUtility eglarWriterUtility = new EglarWriterUtility(jarOutputStream, this.getfParentShell());
                IResource[] iResourceArray = javaClassFolders;
                int n = javaClassFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    final IResource javaClassFolder = iResourceArray[n2];
                    javaClassFolder.accept(new IResourceVisitor(){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public boolean visit(IResource resource) throws CoreException {
                            progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                            IPath path = resource.getFullPath();
                            path = path.removeFirstSegments(javaClassFolder.getFullPath().segmentCount());
                            try {
                                switch (resource.getType()) {
                                    case 2: {
                                        eglarWriterUtility.addDirectories(path);
                                        return true;
                                    }
                                    case 1: {
                                        eglarWriterUtility.addFile((IFile)resource, path);
                                        return false;
                                    }
                                }
                                return false;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return true;
                            }
                        }
                    });
                    ++n2;
                }
                IFolder msgSourceFolder = project.getFolder(CUI_MESSAGE_SOURCE_FOLDER);
                if (msgSourceFolder != null && msgSourceFolder.exists()) {
                    msgSourceFolder.accept(new IResourceVisitor(){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public boolean visit(IResource resource) throws CoreException {
                            progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                            IPath path = resource.getFullPath();
                            try {
                                switch (resource.getType()) {
                                    case 2: {
                                        return true;
                                    }
                                    case 1: {
                                        eglarWriterUtility.addFile((IFile)resource, (IPath)new Path(path.lastSegment()));
                                        return false;
                                    }
                                }
                                return false;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return true;
                            }
                        }
                    });
                }
                jarOutputStream.close();
            }
            catch (Exception exception) {
                byte[] bytes = outputStream.toByteArray();
                if (bytes.length > 0) {
                    this.getfEglarBuilder().writeFileFromBytes(bytes, newPath);
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            byte[] bytes = outputStream.toByteArray();
            if (bytes.length > 0) {
                this.getfEglarBuilder().writeFileFromBytes(bytes, newPath);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void exportJavaDeployFiles(IProject project, IResource javaClassFolder, final IProgressMonitor progressMonitor, HashSet addedSet) throws CoreException {
        Path rootPath = new Path(EGLProjectInfoUtility.getGeneratedJavaFolder((IProject)project)[0]);
        try {
            javaClassFolder.accept(new IResourceVisitor((IPath)rootPath, javaClassFolder, addedSet){
                private final /* synthetic */ IPath val$rootPath;
                private final /* synthetic */ IResource val$javaClassFolder;
                private final /* synthetic */ HashSet val$addedSet;
                {
                    this.val$rootPath = iPath;
                    this.val$javaClassFolder = iResource;
                    this.val$addedSet = hashSet;
                }

                public boolean visit(IResource resource) throws CoreException {
                    progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                    IPath path = resource.getFullPath();
                    path = this.val$rootPath.append(path.removeFirstSegments(this.val$javaClassFolder.getProjectRelativePath().segmentCount() + 1));
                    switch (resource.getType()) {
                        case 2: {
                            if (!this.val$addedSet.contains(path)) {
                                NewEglarFileExportOperation.this.getfEglarBuilder().writeFolder(resource, path);
                                this.val$addedSet.add(path);
                            }
                            return true;
                        }
                        case 1: {
                            if (!("class".equals(resource.getFileExtension()) || "java".equals(resource.getFileExtension()) || this.val$addedSet.contains(resource.getName()))) {
                                NewEglarFileExportOperation.this.getfEglarBuilder().writeFile((IFile)resource, path);
                                this.val$addedSet.add(resource.getName());
                            }
                            return false;
                        }
                    }
                    return false;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportGeneralFolder(IResource jsFolder, final IPath rootFolder, final IProgressMonitor progressMonitor) throws CoreException {
        jsFolder.accept(new IResourceVisitor(){
            int i = 0;

            public boolean visit(IResource resource) throws CoreException {
                progressMonitor.worked(this.i++);
                progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                IPath relPath = resource.getFullPath().removeFirstSegments(1);
                switch (resource.getType()) {
                    case 2: {
                        NewEglarFileExportOperation.this.getfEglarBuilder().writeFolder(resource, rootFolder.append(relPath));
                        return true;
                    }
                    case 1: {
                        NewEglarFileExportOperation.this.getfEglarBuilder().writeFile((IFile)resource, rootFolder.append(relPath));
                        return false;
                    }
                }
                return false;
            }
        });
    }

    private void exportEGLSrcFolder(IResource eglSRCFolder, final IPath rootFolder, final IProgressMonitor progressMonitor, final boolean exportEglSource) throws CoreException {
        eglSRCFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                IPath relPath = resource.getFullPath().removeFirstSegments(1);
                switch (resource.getType()) {
                    case 2: {
                        NewEglarFileExportOperation.this.getfEglarBuilder().writeFolder(resource, rootFolder.append(relPath));
                        return true;
                    }
                    case 1: {
                        if (exportEglSource || !NewEglarFileExportOperation.this.isEGL(resource)) {
                            NewEglarFileExportOperation.this.getfEglarBuilder().writeFile((IFile)resource, relPath);
                        }
                        return false;
                    }
                }
                return false;
            }
        });
    }

    private void exportIR(IResource resource, final ResourceAndTLFMap[] resAndTLFMap, final IProgressMonitor progressMonitor) throws CoreException {
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IPath path = resource.getFullPath();
                path = path.removeFirstSegments(2);
                progressMonitor.worked(1);
                progressMonitor.subTask(Messages.format(EglarPackagerMessages.EglarFileExportOperation_exporting, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                switch (resource.getType()) {
                    case 2: {
                        NewEglarFileExportOperation.this.getfEglarBuilder().writeFolder(resource, path);
                        return true;
                    }
                    case 1: {
                        if (NewEglarFileExportOperation.this.isEGLBLDDD(resource)) {
                            return false;
                        }
                        if (!NewEglarFileExportOperation.this.getfEglarPackage().areTLFSrcFilesExported() && resAndTLFMap != null) {
                            IPath irPath = ((IFile)resource).getFullPath().removeFirstSegments(2).removeFileExtension();
                            ResourceAndTLFMap[] resourceAndTLFMapArray = resAndTLFMap;
                            int n = resAndTLFMap.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ResourceAndTLFMap resourceAndTLFMap = resourceAndTLFMapArray[n2];
                                if (resourceAndTLFMap.isSamePackage(resource) && resourceAndTLFMap.includedPath(irPath)) {
                                    return false;
                                }
                                ++n2;
                            }
                        }
                        NewEglarFileExportOperation.this.getfEglarBuilder().writeFile((IFile)resource, path);
                        return false;
                    }
                }
                return false;
            }
        });
    }

    private boolean isEGL(IResource resource) {
        if (resource == null) {
            return false;
        }
        String fileExtension = resource.getFullPath().getFileExtension();
        return fileExtension != null && fileExtension.equalsIgnoreCase(EGL_EXTENSION);
    }

    private boolean isEGLBLDDD(IResource resource) {
        if (resource == null) {
            return false;
        }
        String fileExtension = resource.getFullPath().getFileExtension();
        return fileExtension != null && (fileExtension.equalsIgnoreCase(EGLBLD_EXTENSION) || fileExtension.equalsIgnoreCase(EGLDD_EXTENSION));
    }
}

