/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.services.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProperty;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.edt.ide.ui.internal.services.wizards.ServiceConfiguration;
import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceOperation;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Type;

public class ServiceOperation
extends EGLFileOperation {
    private ServiceConfiguration configuration;
    private List interfaces;
    private List calledPrograms;

    public ServiceOperation(ServiceConfiguration configuration, List interfaces, List programs) {
        super(configuration);
        this.configuration = configuration;
        this.interfaces = interfaces;
        this.calledPrograms = programs;
    }

    public ServiceOperation(ServiceConfiguration configuration, List interfaces, List programs, ISchedulingRule rule) {
        super(configuration, rule);
        this.configuration = configuration;
        this.interfaces = interfaces;
        this.calledPrograms = programs;
    }

    private String getFileContentsFromTemplate() throws PartTemplateException {
        String serviceOutputString = "";
        String templateName = "service";
        String templateid = "org.eclipse.edt.ide.ui.templates.service";
        String templateVariableInterfaceName = "${serviceName}";
        if (this.configuration.getChosenTemplateSelection() == 1) {
            serviceOutputString = TemplateEngine.getCustomizedTemplateString(templateName, templateid);
        } else if (this.configuration.getChosenTemplateSelection() == 0) {
            serviceOutputString = TemplateEngine.getDefaultTemplateString(templateName, templateid);
        }
        if (serviceOutputString.compareTo("") != 0) {
            String newVariableValue = this.configuration.getServiceName();
            int variableBegin = serviceOutputString.indexOf(templateVariableInterfaceName);
            if (variableBegin == -1) {
                throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_CORRUPTED);
            }
            String firstHalfOutputString = serviceOutputString.substring(0, variableBegin);
            String secondHalfOutputString = serviceOutputString.substring(variableBegin + templateVariableInterfaceName.length(), serviceOutputString.length());
            serviceOutputString = String.valueOf(firstHalfOutputString) + newVariableValue + secondHalfOutputString;
            serviceOutputString = this.RemoveRemainingTemplateTags(serviceOutputString, firstHalfOutputString, secondHalfOutputString);
            return serviceOutputString;
        }
        throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_NOT_FOUND);
    }

    private String getServiceStringFromInterfaces() {
        StringBuffer strBuf = new StringBuffer();
        StringBuffer strImportSection = new StringBuffer();
        StringBuffer strServiceName = new StringBuffer();
        StringBuffer strServiceImpl = new StringBuffer();
        StringBuffer strServiceBody = new StringBuffer();
        String myServicePkgName = this.configuration.getFPackage();
        strServiceName.append(newLine);
        strServiceName.append("service");
        strServiceName.append(" ");
        strServiceName.append(this.configuration.getServiceName());
        int iSize = this.interfaces.size();
        if (iSize > 0) {
            strServiceImpl.append(" ");
            strServiceImpl.append("implements");
            strServiceImpl.append(" ");
        }
        Iterator it = this.interfaces.iterator();
        HashSet<String> functionSet = new HashSet<String>();
        while (it.hasNext()) {
            Type interfaceNameBinding;
            String interfaceFQName = (String)it.next();
            IPart interfaceobj = this.configuration.getInterface(interfaceFQName);
            if (interfaceobj == null || !(interfaceobj instanceof IPart)) continue;
            IPart interfacepart = interfaceobj;
            if (!myServicePkgName.equalsIgnoreCase(interfacepart.getPackageFragment().getElementName())) {
                strImportSection.append("import");
                strImportSection.append(" ");
                strImportSection.append(interfaceFQName);
                strImportSection.append(";");
                strImportSection.append(newLine);
            }
            strServiceImpl.append(interfacepart.getElementName());
            if (it.hasNext()) {
                strServiceImpl.append(", ");
            } else {
                strServiceImpl.append(newLine);
            }
            if (interfacepart instanceof BinaryPart) {
                try {
                    IProperty[] properties = ((BinaryPart)interfacepart).getProperties("XML");
                    if (properties != null) {
                        strServiceImpl.append(ServiceOperation.getXMLAnnotationString(properties));
                    }
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                }
                strServiceBody.append(this.geAllFunctionsBody(interfacepart, functionSet));
                continue;
            }
            Interface boundInterfacePart = this.getBoundInterfacePart(interfacepart);
            strServiceBody.append(this.geAllFunctionsBody(boundInterfacePart, functionSet));
            if (iSize != 1 || (interfaceNameBinding = boundInterfacePart.getName().resolveType()) == null) continue;
            StringBuffer nameVal = new StringBuffer();
            StringBuffer namespaceVal = new StringBuffer();
            EGLFileConfiguration.getXMLAnnotationValueFromBinding((Element)interfaceNameBinding, nameVal, namespaceVal);
            strServiceImpl.append(ServiceOperation.getXMLAnnotationString(namespaceVal.toString(), nameVal.toString()));
        }
        strServiceBody.append(this.getProgramCallFunctionContent(myServicePkgName, functionSet));
        strBuf.append(strImportSection);
        strBuf.append(newLine);
        strBuf.append(strServiceName);
        strBuf.append(strServiceImpl);
        strBuf.append(strServiceBody);
        strBuf.append(newLine);
        strBuf.append("end");
        return strBuf.toString();
    }

    private StringBuffer getProgramCallFunctionContent(String myServicePkgName, HashSet<String> functionSet) {
        StringBuffer strbuf = new StringBuffer();
        for (String programFQName : this.calledPrograms) {
            Program pgmProgram;
            IPart programpart = this.configuration.getCalledBasicPgm(programFQName);
            if (programpart == null) continue;
            if (programpart instanceof SourcePart) {
                pgmProgram = this.configuration.getBoundCalledBasicProgramPgm(programFQName);
                strbuf.append(this.getProgramCallFunction(programFQName, pgmProgram, myServicePkgName, programpart, functionSet));
                continue;
            }
            if (!(programpart instanceof BinaryPart)) continue;
            pgmProgram = this.configuration.getBinaryCalledBasicProgramPgm(programFQName);
            strbuf.append(this.getProgramCallFunction(programFQName, (BinaryPart)pgmProgram, myServicePkgName, programpart, functionSet));
        }
        return strbuf;
    }

    private String getUniqueFunctionName(HashSet<String> functionSet, String proposedFunctionName) {
        int iCnt = 0;
        String uniqueName = proposedFunctionName;
        while (functionSet.contains(uniqueName)) {
            uniqueName = String.valueOf(proposedFunctionName) + Integer.toString(++iCnt);
        }
        return uniqueName;
    }

    private StringBuffer getProgramCallFunction(String programFQName, Program pgmProgram, String currFilePkg, IPart programpart, HashSet<String> functionSet) {
        final StringBuffer strbuf = new StringBuffer();
        StringBuffer strbufParamList = new StringBuffer();
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("function");
        strbuf.append(" ");
        String functionname = pgmProgram.getName().getIdentifier();
        functionname = String.valueOf(functionname) + "_function";
        functionname = this.getUniqueFunctionName(functionSet, functionname);
        strbuf.append(functionname);
        functionSet.add(functionname);
        (new boolean[1])[0] = true;
        pgmProgram.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Program program) {
                strbuf.append("(");
                return true;
            }

            public void endVisit(Program program) {
                strbuf.append(")");
            }
        });
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("\t");
        strbuf.append("call");
        strbuf.append(" ");
        if (!currFilePkg.equalsIgnoreCase(programpart.getPackageFragment().getElementName())) {
            strbuf.append(programFQName);
        } else {
            strbuf.append(pgmProgram.getIdentifier());
        }
        strbuf.append("(");
        strbuf.append(strbufParamList);
        strbuf.append(")");
        strbuf.append(';');
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("end");
        strbuf.append(newLine);
        return strbuf;
    }

    private StringBuffer getProgramCallFunction(String programFQName, BinaryPart pgmProgram, String currFilePkg, IPart programpart, HashSet<String> functionSet) {
        StringBuffer strbuf = new StringBuffer();
        StringBuffer strbufParamList = new StringBuffer();
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("function");
        strbuf.append(" ");
        String functionname = pgmProgram.getElementName();
        functionname = String.valueOf(functionname) + "_function";
        functionname = this.getUniqueFunctionName(functionSet, functionname);
        strbuf.append(functionname);
        functionSet.add(functionname);
        strbuf.append("(");
        try {
            SourcePartElementInfo pgmElementInfo = (SourcePartElementInfo)pgmProgram.getElementInfo();
            if (pgmElementInfo.getParameterNames() != null) {
                int i = 0;
                while (i < pgmElementInfo.getParameterNames().length) {
                    if (i > 0) {
                        strbuf.append(", ");
                        strbufParamList.append(", ");
                    }
                    strbuf.append(pgmElementInfo.getParameterNames()[i]);
                    strbufParamList.append(pgmElementInfo.getParameterNames()[i]);
                    strbuf.append(" ");
                    strbuf.append(pgmElementInfo.getParameterTypeNames()[i]);
                    ++i;
                }
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        strbuf.append(")");
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("\t");
        strbuf.append("call");
        strbuf.append(" ");
        if (!currFilePkg.equalsIgnoreCase(programpart.getPackageFragment().getElementName())) {
            strbuf.append(programFQName);
        } else {
            strbuf.append(pgmProgram.getElementName());
        }
        strbuf.append("(");
        strbuf.append(strbufParamList);
        strbuf.append(")");
        strbuf.append(';');
        strbuf.append(newLine);
        strbuf.append("\t");
        strbuf.append("end");
        strbuf.append(newLine);
        return strbuf;
    }

    private StringBuffer geAllFunctionsBody(Interface boundInterface, final HashSet<String> functionSet) {
        final StringBuffer strFuncs = new StringBuffer();
        boundInterface.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Interface interfaceNode) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                if (!nestedFunction.isPrivate()) {
                    strFuncs.append(ServiceOperation.this.getFunctionBody(nestedFunction, (HashSet<String>)functionSet));
                    strFuncs.append(newLine);
                }
                return false;
            }
        });
        return strFuncs;
    }

    private StringBuffer geAllFunctionsBody(IPart interfacePart, HashSet<String> functionSet) {
        StringBuffer strFuncs = new StringBuffer();
        try {
            IFunction[] functions;
            IFunction[] iFunctionArray = functions = interfacePart.getFunctions();
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                IFunction func = iFunctionArray[n2];
                if (func.isPublic()) {
                    strFuncs.append(this.getFunctionBody(func, functionSet));
                    strFuncs.append(newLine);
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return strFuncs;
    }

    private StringBuffer getFunctionBody(NestedFunction func, HashSet<String> functionSet) {
        StringBuffer strBuf = new StringBuffer();
        String funcSignature = ExtractInterfaceOperation.getFunctionFullSignature(func, this.configuration.getFPackage());
        if (!functionSet.contains(funcSignature)) {
            functionSet.add(funcSignature);
            strBuf.append(newLine);
            strBuf.append("\t");
            strBuf.append(funcSignature);
            strBuf.append(newLine);
            strBuf.append("\t// \tTODO Auto-generated function");
            strBuf.append(newLine);
            strBuf.append("\t");
            strBuf.append("end");
        }
        return strBuf;
    }

    private StringBuffer getFunctionBody(IFunction func, HashSet<String> functionSet) throws EGLModelException {
        StringBuffer strBuf = new StringBuffer();
        String funcSignature = ExtractInterfaceOperation.getFunctionFullSignature(func, this.configuration.getFPackage());
        if (!functionSet.contains(funcSignature)) {
            functionSet.add(funcSignature);
            strBuf.append(newLine);
            strBuf.append("\t");
            strBuf.append(funcSignature);
            strBuf.append(newLine);
            strBuf.append("\t// \tTODO Auto-generated function");
            strBuf.append(newLine);
            strBuf.append("\t");
            strBuf.append("end");
        }
        return strBuf;
    }

    private Interface getBoundInterfacePart(IPart interfacepart) {
        IEGLFile eglFile;
        Part boundPart;
        if (interfacepart.getParent() instanceof IEGLFile && (boundPart = EGLFileConfiguration.getBoundPart(eglFile = (IEGLFile)interfacepart.getParent(), interfacepart.getElementName())) != null) {
            return (Interface)boundPart;
        }
        return null;
    }

    @Override
    public String getFileContents() throws PartTemplateException {
        if (this.interfaces.isEmpty() && this.calledPrograms.isEmpty()) {
            return this.getFileContentsFromTemplate();
        }
        return this.getServiceStringFromInterfaces();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile eglddFile;
        super.execute(monitor);
        if ((this.configuration.IsGenAsWebService() || this.configuration.isGenAsRestService()) && (eglddFile = CoreUtility.getOrCreateEGLDDFileHandle(this.configuration)) != null) {
            EGLDeploymentRoot deploymentRoot = null;
            try {
                if (eglddFile.exists()) {
                    String fullyQualifiedServiceName = this.configuration.getFPackage();
                    if (fullyQualifiedServiceName.length() > 0) {
                        fullyQualifiedServiceName = String.valueOf(fullyQualifiedServiceName) + '.';
                    }
                    fullyQualifiedServiceName = String.valueOf(fullyQualifiedServiceName) + this.configuration.getFileName();
                    deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                    Deployment deployment = deploymentRoot.getDeployment();
                    DeploymentFactory factory = DeploymentFactory.eINSTANCE;
                    this.configuration.IsGenAsWebService();
                    if (this.configuration.isGenAsRestService()) {
                        Services rss = deployment.getServices();
                        if (rss == null) {
                            rss = factory.createServices();
                            deployment.setServices(rss);
                        }
                        Service newRS = factory.createService();
                        Parameters params = factory.createParameters();
                        newRS.setParameters(params);
                        newRS.setType(org.eclipse.edt.ide.deployment.core.model.Service.SERVICE_REST);
                        newRS.setImplementation(fullyQualifiedServiceName);
                        EGLDDRootHelper.addOrUpdateParameter(params, "enableGeneration", true);
                        EGLDDRootHelper.addOrUpdateParameter(params, "uriFragment", EGLDDRootHelper.getValidURI(deployment, this.configuration.getServiceName()));
                        rss.getService().add((Object)newRS);
                    }
                    if (!EGLDDRootHelper.isWorkingModelSharedByUserClients(eglddFile)) {
                        EGLDDRootHelper.saveEGLDDFile(eglddFile, deploymentRoot);
                    }
                }
            }
            finally {
                if (deploymentRoot != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                }
            }
        }
    }

    @Override
    protected void updateExistingFile(IPackageFragmentRoot root, IPackageFragment frag, IFile file, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IEGLElement eglElem = EGLCore.create((IFile)file);
        if (eglElem instanceof IEGLFile) {
            IEGLFile eglLibFile = (IEGLFile)eglElem;
            IPart servicePart = eglLibFile.getPart(this.configuration.getFileName());
            if (servicePart.exists()) {
                IFunction[] functions = servicePart.getFunctions();
                StringBuffer functionBuffer = new StringBuffer();
                HashSet<String> functionSet = new HashSet<String>();
                int i = 0;
                while (i < functions.length) {
                    functionSet.add(functions[i].getElementName());
                    ++i;
                }
                String servicePkgName = this.configuration.getFPackage();
                functionBuffer = this.getProgramCallFunctionContent(servicePkgName, functionSet);
                this.insertMemeberPart(eglLibFile, servicePart, functionBuffer.toString());
            }
            this.saveExistingFileWithNewBuffer(frag, eglLibFile, file, monitor);
        }
    }

    @Override
    protected int getInsertPosition(IEGLFile eglfile, IPart sourcePart, StringBuffer insertStringBuf) throws EGLModelException {
        final int[] insertposition = new int[1];
        try {
            File fileast = EGLModelUtility.getEGLFileAST(eglfile, EGLUI.getBufferFactory());
            fileast.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(File file) {
                    return true;
                }

                public void endVisit(org.eclipse.edt.compiler.core.ast.Service service) {
                    insertposition[0] = service.getOffset() + service.getLength() - "end".length();
                }
            });
        }
        catch (Exception e) {
            if (e instanceof EGLModelException) {
                throw (EGLModelException)((Object)e);
            }
            e.printStackTrace();
        }
        insertStringBuf.insert(0, "\t");
        return insertposition[0];
    }
}

