/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.GSSTokenVault;
import com.ibm.as400.access.IdentityTokenVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ManagedProfileTokenVault;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandler;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.ToolboxSignonHandler;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class AS400
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400";
    static final long serialVersionUID = 4L;
    private static final boolean PASSWORD_TRACE = false;
    public static final int FILE = 0;
    public static final int PRINT = 1;
    public static final int COMMAND = 2;
    public static final int DATAQUEUE = 3;
    public static final int DATABASE = 4;
    public static final int RECORDACCESS = 5;
    public static final int CENTRAL = 6;
    public static final int SIGNON = 7;
    public static final int USE_PORT_MAPPER = -1;
    public static final int AUTHENTICATION_SCHEME_PASSWORD = 0;
    public static final int AUTHENTICATION_SCHEME_GSS_TOKEN = 1;
    public static final int AUTHENTICATION_SCHEME_PROFILE_TOKEN = 2;
    public static final int AUTHENTICATION_SCHEME_IDENTITY_TOKEN = 3;
    public static final int GSS_OPTION_MANDATORY = 0;
    public static final int GSS_OPTION_FALLBACK = 1;
    public static final int GSS_OPTION_NONE = 2;
    static boolean onAS400;
    static ServerVersion nativeVRM;
    static Class defaultSignonHandlerClass_;
    static SignonHandler defaultSignonHandler_;
    private static boolean defaultGuiAvailable_;
    private static boolean defaultMustAddLanguageLibrary_;
    private static boolean defaultMustUseSockets_;
    private static boolean defaultMustUseNetSockets_;
    private static boolean defaultMustUseSuppliedProfile_;
    private static boolean defaultThreadUsed_;
    private static Vector systemList;
    private static Hashtable defaultUsers;
    private static int expirationWarning;
    private static int alreadyCheckedForMultipleVersions_;
    private String systemName_ = "";
    private boolean systemNameLocal_ = false;
    private String userId_ = "";
    private transient CredentialVault credVault_;
    private transient Object gssCredential_ = null;
    private String gssName_ = "";
    int gssOption_ = 1;
    private transient String proxyServer_ = "";
    private transient Object proxyClientConnection_ = null;
    private boolean guiAvailable_ = defaultGuiAvailable_;
    private boolean usePasswordCache_ = true;
    private boolean useDefaultUser_ = true;
    private boolean showCheckboxes_ = true;
    private boolean signingOn_ = false;
    SSLOptions useSSLConnection_ = null;
    private boolean mustAddLanguageLibrary_ = defaultMustAddLanguageLibrary_;
    private boolean mustUseSockets_ = defaultMustUseSockets_;
    private boolean mustUseNetSockets_ = defaultMustUseNetSockets_;
    private boolean mustUseSuppliedProfile_ = defaultMustUseSuppliedProfile_;
    private boolean threadUsed_ = defaultThreadUsed_;
    private Locale locale_ = Locale.getDefault();
    private String nlv_ = ExecutionEnvironment.getNlv(Locale.getDefault());
    private transient TimeZone timezone_;
    private SocketProperties socketProperties_ = new SocketProperties();
    private transient int ccsid_ = 0;
    private transient Vector connectionListeners_ = null;
    private transient ConnectionListener dispatcher_ = null;
    transient PropertyChangeSupport propertyChangeListeners_ = null;
    transient VetoableChangeSupport vetoableChangeListeners_ = null;
    transient boolean propertiesFrozen_ = false;
    private transient AS400Impl impl_ = null;
    private transient SignonInfo signonInfo_ = null;
    private String ddmRDB_ = null;
    private transient SignonHandler signonHandler_ = null;
    private transient boolean handlerCanceled_ = false;
    private boolean forcePrompt_ = false;
    private static int nativeVersion;
    private static final int FINISHED = 0;
    private static final int VALIDATE = 1;
    private static final int PROMPT = 2;
    private static final int MAX_ITERATIONS = 20;
    private static boolean currentUserAvailable;
    private static boolean currentUserTried;
    private int bidiStringType = 0;
    public boolean bidiAS400Text = false;
    static /* synthetic */ Class class$com$ibm$as400$access$ToolboxSignonHandler;

    public AS400() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object.");
        }
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal("");
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String string, ProfileTokenCredential profileTokenCredential) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object with profile token, system name: '" + string + "'");
        }
        if (profileTokenCredential == null) {
            throw new NullPointerException("profileToken");
        }
        this.constructWithProfileToken(string, new ProfileTokenVault(profileTokenCredential));
    }

    public AS400(String string, ProfileTokenProvider profileTokenProvider) {
        this(string, profileTokenProvider, null);
    }

    public AS400(String string, ProfileTokenProvider profileTokenProvider, int n) {
        this(string, profileTokenProvider, new Integer(n));
    }

    private AS400(String string, ProfileTokenProvider profileTokenProvider, Integer n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object with a profile token provider, system name: '" + string + "'");
        }
        if (profileTokenProvider == null) {
            throw new NullPointerException("tokenProvider");
        }
        if (n != null) {
            this.constructWithProfileToken(string, new ManagedProfileTokenVault(profileTokenProvider, n));
        } else {
            this.constructWithProfileToken(string, new ManagedProfileTokenVault(profileTokenProvider));
        }
    }

    private void constructWithProfileToken(String string, ProfileTokenVault profileTokenVault) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.credVault_ = profileTokenVault;
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, String string2, String string3) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        if (string3 == null) {
            throw new NullPointerException("password");
        }
        if (string3.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + string3.length() + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.credVault_ = new PasswordVault(string3);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    private AS400(String string, String string2, CredentialVault credentialVault) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing internal AS400 object, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.credVault_ = (CredentialVault)credentialVault.clone();
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String string, String string2, String string3, String string4) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string4 + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        if (string3 == null) {
            throw new NullPointerException("password");
        }
        if (string3.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + string3.length() + ")", 1);
        }
        if (string4 == null) {
            throw new NullPointerException("proxyServer");
        }
        this.construct();
        this.systemName_ = string;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        this.userId_ = string2.toUpperCase();
        this.credVault_ = new PasswordVault(string3);
        this.proxyServer_ = AS400.resolveProxyServer(string4);
    }

    public AS400(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system: " + aS400);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.construct();
        this.systemName_ = aS400.systemName_;
        this.systemNameLocal_ = aS400.systemNameLocal_;
        this.userId_ = aS400.userId_;
        this.credVault_ = (CredentialVault)aS400.credVault_.clone();
        this.gssCredential_ = aS400.gssCredential_;
        this.gssName_ = aS400.gssName_;
        this.gssOption_ = aS400.gssOption_;
        this.proxyServer_ = aS400.proxyServer_;
        this.guiAvailable_ = aS400.guiAvailable_;
        this.usePasswordCache_ = aS400.usePasswordCache_;
        this.useDefaultUser_ = aS400.useDefaultUser_;
        this.showCheckboxes_ = aS400.showCheckboxes_;
        this.mustAddLanguageLibrary_ = aS400.mustAddLanguageLibrary_;
        this.mustUseSockets_ = aS400.mustUseSockets_;
        this.mustUseNetSockets_ = aS400.mustUseNetSockets_;
        this.mustUseSuppliedProfile_ = aS400.mustUseSuppliedProfile_;
        this.threadUsed_ = aS400.threadUsed_;
        this.locale_ = aS400.locale_;
        this.nlv_ = aS400.nlv_;
        this.socketProperties_ = aS400.socketProperties_;
        this.ccsid_ = aS400.ccsid_;
        this.ddmRDB_ = aS400.ddmRDB_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding connection listener.");
        }
        if (connectionListener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ == null) {
                this.connectionListeners_ = new Vector();
                this.dispatcher_ = new ConnectionListener(){

                    public void connected(ConnectionEvent connectionEvent) {
                        AS400.this.fireConnectEvent(connectionEvent, true);
                    }

                    public void disconnected(ConnectionEvent connectionEvent) {
                        AS400.this.fireConnectEvent(connectionEvent, false);
                    }
                };
            }
            if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
            this.connectionListeners_.addElement(connectionListener);
        }
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(string, string2, string3));
    }

    public static void addPasswordCacheEntry(String string, String string2, String string3, String string4) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + string + "' user ID: '" + string2 + "' proxy server: '" + string4 + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(string, string2, string3, string4));
    }

    static void addPasswordCacheEntry(AS400 aS400) throws AS400SecurityException, IOException {
        aS400.validateSignon();
        AS400.setCacheEntry(aS400.systemName_, aS400.userId_, aS400.credVault_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean arePropertiesFrozen() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if properties are frozen:", this.propertiesFrozen_);
        }
        return this.propertiesFrozen_;
    }

    public boolean authenticate(String string, String string2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Authenticating signon information:", string);
        }
        return this.validateSignon(string, string2);
    }

    private static int getNativeVersion() {
        try {
            if (nativeVersion == -1) {
                nativeVersion = Class.forName("com.ibm.as400.access.NativeVersion").newInstance().hashCode();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not using native optimizations; class 'NativeVersion' is not found.");
            }
            nativeVersion = 0;
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not using native optimizations; unexpected exception while loading native version:", (Throwable)exception);
            }
            nativeVersion = 0;
        }
        return nativeVersion;
    }

    public boolean canUseNativeOptimizations() {
        if (onAS400 && !this.mustUseSockets_ && this.systemNameLocal_ && this.proxyServer_.length() == 0 && this.credVault_.getType() == 0 && AS400.getNativeVersion() == 2) {
            if (Trace.traceOn_) {
                Trace.log(1, "Using native optimizations.");
            }
            return true;
        }
        if (Trace.traceOn_) {
            int n;
            Trace.log(1, "Not using native optimizations. Reason follows:");
            if (!onAS400) {
                Trace.log(1, "  onAS400:", onAS400);
            }
            if (this.mustUseSockets_) {
                Trace.log(1, "  mustUseSockets:", this.mustUseSockets_);
            }
            if (!this.systemNameLocal_) {
                Trace.log(1, "  systemNameLocal:", this.systemNameLocal_);
            }
            if (this.proxyServer_.length() != 0) {
                Trace.log(1, "  proxyServer:", this.proxyServer_);
            }
            if ((n = this.credVault_.getType()) != 0) {
                Trace.log(1, "  authenticationScheme:", n + " (" + AS400.credTypeToString(n) + ")");
            }
            if (AS400.getNativeVersion() != 2) {
                Trace.log(1, "  nativeVersion:", AS400.getNativeVersion());
            }
        }
        return false;
    }

    private static final String credTypeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "password";
                break;
            }
            case 1: {
                string = "GSS token";
                break;
            }
            case 2: {
                string = "profile token";
                break;
            }
            case 3: {
                string = "identity token";
                break;
            }
            default: {
                string = "unrecognized";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String string, String string2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing password.");
        }
        if (string == null) {
            throw new NullPointerException("oldPassword");
        }
        if (string.length() > 128) {
            throw new ExtendedIllegalArgumentException("oldPassword.length {" + string.length() + ")", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("newPassword");
        }
        if (string2.length() > 128) {
            throw new ExtendedIllegalArgumentException("newPassword.length {" + string2.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot change password before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot change password before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            byte[] byArray = new byte[9];
            CredentialVault.rng.nextBytes(byArray);
            byte[] byArray2 = this.impl_.exchangeSeed(byArray);
            this.signonInfo_ = this.impl_.changePassword(this.systemName_, this.systemNameLocal_, this.userId_, CredentialVault.encode(byArray, byArray2, BinaryConverter.charArrayToByteArray(string.toCharArray())), CredentialVault.encode(byArray, byArray2, BinaryConverter.charArrayToByteArray(string2.toCharArray())));
            if (Trace.traceOn_) {
                Trace.log(1, "Password changed successfully.");
            }
            this.credVault_.empty();
            this.credVault_ = new PasswordVault(string2);
        }
    }

    private synchronized void chooseImpl() {
        if (this.impl_ == null) {
            this.impl_ = (AS400Impl)this.loadImpl2("com.ibm.as400.access.AS400ImplRemote", "com.ibm.as400.access.AS400ImplProxy");
            if (this.connectionListeners_ != null && !this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
        }
        if (!this.propertiesFrozen_) {
            this.impl_.setState(this.useSSLConnection_, this.canUseNativeOptimizations(), this.threadUsed_, this.ccsid_, this.nlv_, this.socketProperties_, this.ddmRDB_, this.mustUseNetSockets_, this.mustUseSuppliedProfile_, this.mustAddLanguageLibrary_);
            this.propertiesFrozen_ = true;
        }
        this.impl_.setBidiStringType(this.getBidiStringType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache.");
        }
        Vector vector = systemList;
        synchronized (vector) {
            systemList.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache(String string) {
        int n;
        String string2 = null;
        boolean bl = false;
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache, system name:", string);
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        boolean bl2 = (string = AS400.resolveSystem(string)).equals("localhost");
        if (bl2) {
            bl = true;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = string.indexOf(".")) > 0) {
            string2 = string;
            string = string.substring(0, n);
        }
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                String string3 = (String)((Object[])systemList.elementAt(i))[0];
                if (string.equalsIgnoreCase(string3)) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (bl && "localhost".equalsIgnoreCase(string3)) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase(string3)) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectService(int n) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting service:", n);
        }
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        this.chooseImpl();
        if (this.credVault_ instanceof ProfileTokenVault) {
            if (Trace.traceOn_) {
                Trace.log(3, "Before service connected, block the thread of refreshing profile token credential");
            }
            ((ProfileTokenVault)this.credVault_).preventRefresh();
        }
        try {
            this.signon(n == 7);
            this.impl_.connect(n);
            if (Trace.traceOn_) {
                Trace.log(1, "Service connected:", AS400.getServerName(n));
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.credVault_ instanceof ProfileTokenVault) {
                if (Trace.traceOn_) {
                    Trace.log(3, "After service connected, notify the thread of refreshing profile token credential");
                }
                ((ProfileTokenVault)this.credVault_).allowRefresh();
            }
            throw throwable;
        }
        if (this.credVault_ instanceof ProfileTokenVault) {
            if (Trace.traceOn_) {
                Trace.log(3, "After service connected, notify the thread of refreshing profile token credential");
            }
            ((ProfileTokenVault)this.credVault_).allowRefresh();
        }
    }

    public Socket connectToPort(int n) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting port:", n);
        }
        this.chooseImpl();
        this.signon(false);
        Socket socket = this.impl_.connectToPort(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Port connected:", socket.getPort());
        }
        return socket;
    }

    private void construct() {
        if (onAS400) {
            if (Trace.traceOn_) {
                Trace.log(1, "Running on IBM i.");
            }
            this.guiAvailable_ = false;
        }
    }

    public void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services...");
        }
        if (this.impl_ != null) {
            this.impl_.disconnect(0);
            this.impl_.disconnect(1);
            this.impl_.disconnect(2);
            this.impl_.disconnect(3);
            this.impl_.disconnect(4);
            this.impl_.disconnect(5);
            this.impl_.disconnect(6);
            this.impl_.disconnect(7);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected.");
        }
    }

    public void disconnectService(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting service:", n);
        }
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return;
        }
        this.impl_.disconnect(n);
    }

    private void fireConnectEvent(ConnectionEvent connectionEvent, boolean bl) {
        connectionEvent.setSource(this);
        Vector vector = (Vector)this.connectionListeners_.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ConnectionListener connectionListener = (ConnectionListener)vector.elementAt(i);
            if (bl) {
                connectionListener.connected(connectionEvent);
                continue;
            }
            connectionListener.disconnected(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential generateProfileToken(String string, int n, int n2) throws AS400SecurityException, IOException {
        this.connectService(7);
        if (string == null) {
            throw new NullPointerException("userIdentity");
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10, propertyVetoException.getMessage());
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileTokenCredential, string);
        }
        return profileTokenCredential;
    }

    public static int generateVRM(int n, int n2, int n3) {
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("version (" + n + ")", 4);
        }
        if (n2 < 0 || n2 > 255) {
            throw new ExtendedIllegalArgumentException("release (" + n2 + ")", 4);
        }
        if (n3 < 0 || n3 > 255) {
            throw new ExtendedIllegalArgumentException("modification (" + n3 + ")", 4);
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    public int getAuthenticationScheme() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting authentication scheme, scheme:", this.credVault_.getType());
        }
        return this.credVault_.getType();
    }

    public int getCcsid() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting CCSID.");
        }
        if (this.ccsid_ == 0) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Retrieving CCSID from system...");
                }
                this.chooseImpl();
                this.signon(false);
                this.ccsid_ = this.signonInfo_.serverCCSID;
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Taking best guess CCSID:", (Throwable)exception);
                }
                this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    private int getDaysToExpiration() {
        if (this.signonInfo_ != null) {
            GregorianCalendar gregorianCalendar = this.signonInfo_.expirationDate;
            GregorianCalendar gregorianCalendar2 = this.signonInfo_.currentSignonDate;
            if (gregorianCalendar != null && gregorianCalendar2 != null) {
                long l = gregorianCalendar.getTime().getTime();
                long l2 = gregorianCalendar2.getTime().getTime();
                int n = (int)((l - l2) / 86400000L + 1L);
                return n;
            }
        }
        return 365;
    }

    public static SignonHandler getDefaultSignonHandler() {
        if (defaultSignonHandler_ != null) {
            return defaultSignonHandler_;
        }
        try {
            return (SignonHandler)defaultSignonHandlerClass_.newInstance();
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to cast specified default sign-on handler to a SignonHandler: " + defaultSignonHandlerClass_.getName(), (Throwable)exception);
            return new ToolboxSignonHandler();
        }
    }

    public String getDDMRDB() {
        return this.ddmRDB_;
    }

    public static String getDefaultUser(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the default user, system name:", string);
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        String string2 = (String)defaultUsers.get(AS400.resolveSystem(string));
        if (Trace.traceOn_) {
            Trace.log(1, "Default user:", string2);
        }
        return string2;
    }

    public synchronized String getGSSName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS name:", this.gssName_);
        }
        return this.gssName_;
    }

    public int getGSSOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS option:", this.gssOption_);
        }
        return this.gssOption_;
    }

    AS400Impl getImpl() {
        this.chooseImpl();
        return this.impl_;
    }

    int getJobCcsid() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID.");
        }
        this.chooseImpl();
        this.signon(false);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID:", this.signonInfo_.serverCCSID);
        }
        return this.signonInfo_.serverCCSID;
    }

    public String getJobCCSIDEncoding() throws AS400SecurityException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID encoding.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.serverCCSID;
        String string = this.impl_.ccsidToEncoding(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID encoding:", string);
        }
        return string;
    }

    public Job[] getJobs(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting jobs, service:", n);
        }
        if (n < 0 || n > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", n);
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return new Job[0];
        }
        String[] stringArray = this.impl_.getJobs(n);
        Job[] jobArray = new Job[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Trace.traceOn_) {
                Trace.log(1, "Constructing Job for job:", stringArray[i]);
            }
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                return new Job[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "/");
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            jobArray[i] = new Job(this, string3, string2, string);
        }
        return jobArray;
    }

    public Locale getLocale() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting locale: " + this.locale_);
        }
        return this.locale_;
    }

    public int getModification() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting modification level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getModificationLevel();
        if (Trace.traceOn_) {
            Trace.log(1, "Modification level:", n);
        }
        return n;
    }

    public String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV:", this.nlv_);
        }
        return this.nlv_;
    }

    public GregorianCalendar getPasswordExpirationDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting password expiration date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.expirationDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Password expiration date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)((Calendar)gregorianCalendar).clone();
    }

    public static int getPasswordExpirationWarningDays() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the password expiration warning days:", expirationWarning);
        }
        return expirationWarning;
    }

    public GregorianCalendar getPreviousSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting previous signon date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.lastSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Previous signon date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)((Calendar)gregorianCalendar).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken() throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.signonInfo_.profileToken != null) {
            return (ProfileTokenCredential)this.signonInfo_.profileToken;
        }
        if (this.credVault_.isEmpty() && this.credVault_.getType() != 1) {
            throw new AS400SecurityException(22);
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(1);
            profileTokenCredential.setTimeoutInterval(3600);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10, propertyVetoException.getMessage());
        }
        byte[] byArray = new byte[9];
        CredentialVault.rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            CredentialVault credentialVault = (CredentialVault)this.credVault_.clone();
            credentialVault.storeEncodedUsingExternalSeeds(byArray, this.impl_.exchangeSeed(byArray));
            this.impl_.generateProfileToken(profileTokenCredential, this.userId_, credentialVault, this.gssName_);
        }
        this.signonInfo_.profileToken = profileTokenCredential;
        return profileTokenCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(int n, int n2) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.credVault_.isEmpty() && this.credVault_.getType() != 1) {
            throw new AS400SecurityException(22);
        }
        if (n == 3) {
            Trace.log(2, "Request not supported for renewable token type.");
            throw new AS400SecurityException(37);
        }
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10, propertyVetoException.getMessage());
        }
        byte[] byArray = new byte[9];
        CredentialVault.rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            CredentialVault credentialVault = (CredentialVault)this.credVault_.clone();
            credentialVault.storeEncodedUsingExternalSeeds(byArray, this.impl_.exchangeSeed(byArray));
            this.impl_.generateProfileToken(profileTokenCredential, this.userId_, credentialVault, this.gssName_);
        }
        return profileTokenCredential;
    }

    public ProfileTokenCredential getProfileToken(String string, String string2) throws AS400SecurityException, IOException, InterruptedException {
        return this.getProfileToken(string, string2, 1, 3600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(String string, String string2, int n, int n2) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (string == null) {
            throw new NullPointerException("userId");
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        if (string2.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length (" + string2.length() + ")", 1);
        }
        string = AS400.resolveUserId(string.toUpperCase());
        ProfileTokenCredential profileTokenCredential = new ProfileTokenCredential();
        try {
            profileTokenCredential.setSystem(this);
            profileTokenCredential.setTokenType(n);
            profileTokenCredential.setTimeoutInterval(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10, propertyVetoException.getMessage());
        }
        byte[] byArray = new byte[9];
        CredentialVault.rng.nextBytes(byArray);
        AS400 aS400 = this;
        synchronized (aS400) {
            PasswordVault passwordVault = new PasswordVault(string2);
            passwordVault.storeEncodedUsingExternalSeeds(byArray, this.impl_.exchangeSeed(byArray));
            this.impl_.generateProfileToken(profileTokenCredential, string, passwordVault, this.gssName_);
        }
        return profileTokenCredential;
    }

    public String getProxyServer() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting proxy server:", this.proxyServer_);
        }
        return this.proxyServer_;
    }

    public int getRelease() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting release level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getRelease();
        if (Trace.traceOn_) {
            Trace.log(1, "Release level:", n);
        }
        return n;
    }

    static String getServerName(int n) {
        switch (n) {
            case 0: {
                return "as-file";
            }
            case 1: {
                return "as-netprt";
            }
            case 2: {
                return "as-rmtcmd";
            }
            case 3: {
                return "as-dtaq";
            }
            case 4: {
                return "as-database";
            }
            case 5: {
                return "as-ddm";
            }
            case 6: {
                return "as-central";
            }
            case 7: {
                return "as-signon";
            }
        }
        throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
    }

    public int getServicePort(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting service port, service:", n);
        }
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot get service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        int n2 = this.impl_.getServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, n);
        if (Trace.traceOn_) {
            Trace.log(1, "Service port:", n2);
        }
        return n2;
    }

    public GregorianCalendar getSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting signon date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar gregorianCalendar = this.signonInfo_.currentSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Signon date: " + gregorianCalendar);
        }
        return gregorianCalendar == null ? null : (GregorianCalendar)((Calendar)gregorianCalendar).clone();
    }

    public SignonHandler getSignonHandler() {
        if (this.signonHandler_ != null) {
            return this.signonHandler_;
        }
        return AS400.getDefaultSignonHandler();
    }

    public SocketProperties getSocketProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting socket properties.");
        }
        SocketProperties socketProperties = new SocketProperties();
        socketProperties.copyValues(this.socketProperties_);
        return socketProperties;
    }

    public String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system name: " + this.systemName_ + ", is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    public TimeZone getSystemTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getTimeZone();
    }

    public TimeZone getTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting time zone for System");
        }
        if (this.timezone_ == null) {
            this.timezone_ = DateTimeConverter.timeZoneForSystem(this);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Time zone:", this.timezone_.getDisplayName());
        }
        return this.timezone_;
    }

    public static TimeZone getDefaultTimeZone(AS400 aS400) {
        TimeZone timeZone;
        block5: {
            timeZone = null;
            if (aS400 != null) {
                try {
                    timeZone = aS400.getTimeZone();
                }
                catch (Exception exception) {
                    if (!Trace.traceOn_) break block5;
                    Trace.log(1, "Exception obtaining timezone ", (Throwable)exception);
                }
            }
        }
        if (timeZone == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Defaulting to local timezone");
            }
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user ID:", this.userId_);
        }
        this.userId_ = AS400.resolveUserId(this.userId_, this.credVault_.getType(), this.mustUseSuppliedProfile_);
        return this.userId_;
    }

    public String getUserId(boolean bl) {
        if (!bl) {
            return this.getUserId();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Getting current user ID:", this.userId_);
        }
        String string = this.userId_;
        if (this.systemNameLocal_ && onAS400) {
            try {
                string = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
                if (string == null || string.length() == 0) {
                    string = this.userId_;
                }
            }
            catch (Throwable throwable) {
                if (Trace.traceOn_) {
                    Trace.log(1, throwable);
                }
                string = this.userId_;
            }
        }
        return string;
    }

    public int getVersion() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting version level.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getVersion();
        if (Trace.traceOn_) {
            Trace.log(1, "Version level:", n);
        }
        return n;
    }

    public int getVRM() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting VRM.");
        }
        this.chooseImpl();
        this.signon(false);
        int n = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] byArray = new byte[4];
            BinaryConverter.intToByteArray(n, byArray, 0);
            Trace.log(1, "VRM:", byArray);
        }
        return n;
    }

    public void initializeConverter(int n) throws UnsupportedEncodingException {
        if (Trace.traceOn_) {
            Trace.log(1, "Initializing converter for CCSID:", n);
        }
        this.chooseImpl();
        try {
            this.signon(false);
            this.impl_.newConverter(n);
        }
        catch (Exception exception) {
            Trace.log(4, "Error initializing converter:", (Throwable)exception);
            throw new UnsupportedEncodingException();
        }
    }

    public boolean isConnected() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for any service connection...");
        }
        if (this.isConnected(0) || this.isConnected(1) || this.isConnected(2) || this.isConnected(3) || this.isConnected(4) || this.isConnected(5) || this.isConnected(6) || this.isConnected(7)) {
            if (Trace.traceOn_) {
                Trace.log(1, "A service is connected.");
            }
            return true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "No service is connected.");
        }
        return false;
    }

    public boolean isConnected(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection:", n);
        }
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            return false;
        }
        boolean bl = this.impl_.isConnected(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Service connection:", bl);
        }
        return bl;
    }

    public boolean isConnectionAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Testing connection...");
        }
        boolean bl = this.impl_ == null ? false : this.impl_.isConnectionAlive();
        if (Trace.traceOn_) {
            Trace.log(1, "Connection status:", bl);
        }
        return bl;
    }

    public boolean isConnectionAlive(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Testing connection...");
        }
        boolean bl = this.impl_ == null ? false : this.impl_.isConnectionAlive(n);
        if (Trace.traceOn_) {
            Trace.log(1, "Connection status:", bl);
        }
        return bl;
    }

    public boolean isGuiAvailable() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if GUI is available:", this.guiAvailable_);
        }
        return this.guiAvailable_;
    }

    public boolean isLocal() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_;
    }

    public boolean isMustUseSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use sockets:", this.mustUseSockets_);
        }
        return this.mustUseSockets_;
    }

    public boolean isShowCheckboxes() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if checkboxes are shown:", this.showCheckboxes_);
        }
        return this.showCheckboxes_;
    }

    private static boolean isSystemNameLocal(String string) {
        if (string.equalsIgnoreCase("localhost")) {
            if (Trace.traceOn_) {
                Trace.log(1, "System name is 'localhost'.");
            }
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Comparing local address " + inetAddress + " to " + inetAddressArray[i]);
                }
                if (!inetAddress.equals(inetAddressArray[i])) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.log(2, "Error retrieving host address information:", (Throwable)unknownHostException);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "System name is not local.");
        }
        return false;
    }

    public boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    public boolean isUseDefaultUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if default user is used:", this.useDefaultUser_);
        }
        return this.useDefaultUser_;
    }

    public boolean isUsePasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if password cache is used:", this.usePasswordCache_);
        }
        return this.usePasswordCache_;
    }

    static Object loadImpl(String string) {
        if (string.indexOf(46) == -1) {
            string = "com.ibm.as400.access." + string;
        }
        if (Trace.traceOn_ && alreadyCheckedForMultipleVersions_++ < 10) {
            Trace.log(1, "Checking for multiple Toolbox versions.");
            try {
                String string2 = "com/ibm/as400/access/AS400.class";
                String string3 = string.replace('.', '/') + ".class";
                ClassLoader classLoader = Class.forName(CLASSNAME).getClassLoader();
                ClassLoader classLoader2 = Class.forName(string).getClassLoader();
                if (classLoader != null && classLoader2 != null) {
                    URL uRL = classLoader.getResource(string2);
                    URL uRL2 = classLoader2.getResource(string3);
                    if (uRL != null && uRL2 != null) {
                        String string4;
                        String string5 = uRL.getPath();
                        String string6 = uRL2.getPath();
                        Trace.log(1, "Path of AS400 class:", string5);
                        Trace.log(1, "Path of loaded impl class:", string6);
                        String string7 = string5.length() <= string2.length() ? "" : string5.substring(0, string5.length() - string2.length() - 1);
                        String string8 = string4 = string6.length() <= string3.length() ? "" : string6.substring(0, string6.length() - string3.length() - 1);
                        if (!string7.equals(string4)) {
                            Trace.log(4, "Toolbox classes found in two different locations: " + string7 + " and " + string4);
                        }
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.log(1, "Class not found:", classNotFoundException.getMessage());
            }
            catch (Throwable throwable) {
                Trace.log(1, throwable);
            }
        }
        try {
            return Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.traceOn_) {
                Trace.log(1, "Class not found:", classNotFoundException.getMessage());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.log(2, "Unexpected IllegalAccessException:", (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Trace.log(2, "Unexpected InstantiationException:", (Throwable)instantiationException);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Load of implementation failed:", string);
        }
        return null;
    }

    Object loadImpl(String string, String string2) {
        Object object;
        if (this.canUseNativeOptimizations()) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl2(String string, String string2) {
        Object object;
        if (this.proxyServer_.length() > 0) {
            object = this;
            synchronized (object) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            object = (ProxyImpl)AS400.loadImpl(string2);
            if (object != null) {
                object.construct((ProxyClientConnection)this.proxyClientConnection_);
                return object;
            }
        }
        if ((object = AS400.loadImpl(string)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string + "' failed.");
        throw new ExtendedIllegalStateException(string, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl3(String string, String string2, String string3) {
        Object object;
        if (this.proxyServer_.length() > 0) {
            object = this;
            synchronized (object) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            object = (ProxyImpl)AS400.loadImpl(string3);
            if (object != null) {
                object.construct((ProxyClientConnection)this.proxyClientConnection_);
                return object;
            }
        }
        if (this.canUseNativeOptimizations()) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptSignon() throws AS400SecurityException, IOException {
        if (this.signingOn_) {
            Trace.log(2, "AS400.promptSignon() called while already signing on.  SignonHandler may have called a prohibited method.");
            throw new ExtendedIllegalStateException(16);
        }
        try {
            this.signingOn_ = true;
            boolean bl = this.signonInfo_ != null;
            int n = 1;
            SignonHandler signonHandler = this.getSignonHandler();
            if (this.credVault_.getType() == 0 && (this.systemName_.length() == 0 || this.userId_.length() == 0 || this.credVault_.isEmpty() || !(signonHandler instanceof ToolboxSignonHandler) || this.forcePrompt_)) {
                n = 2;
            }
            int n2 = 0;
            boolean bl2 = true;
            do {
                SignonEvent signonEvent;
                ++n2;
                try {
                    SignonEvent signonEvent2;
                    switch (n) {
                        case 1: {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Validate security...");
                            }
                            this.sendSignonRequest();
                            break;
                        }
                        case 2: {
                            if (!this.isGuiAvailable() && this.forcePrompt_) {
                                Trace.log(2, "No GUI available for signon dialog.");
                                this.handlerCanceled_ = true;
                                throw new AS400SecurityException(63);
                            }
                            if (Trace.traceOn_) {
                                Trace.log(1, "Calling SignonHandler...");
                            }
                            if (!(bl2 = signonHandler.connectionInitiated(signonEvent2 = new SignonEvent(this, bl), this.credVault_.isEmpty()))) {
                                Trace.log(1, "User canceled.");
                                this.handlerCanceled_ = true;
                                throw new AS400SecurityException(25);
                            }
                            this.sendSignonRequest();
                            if (!this.isUsePasswordCache() || this.credVault_.getType() != 0) break;
                            if (Trace.traceOn_) {
                                Trace.log(1, "Setting password cache entry from SignonHandler...");
                            }
                            AS400.setCacheEntry(this.systemName_, this.userId_, this.credVault_);
                            break;
                        }
                        default: {
                            Trace.log(2, "Invalid password prompt state:", n);
                            throw new InternalErrorException(8, n);
                        }
                    }
                    if (this.getDaysToExpiration() < expirationWarning && !(bl2 = signonHandler.passwordAboutToExpire(signonEvent2 = new SignonEvent(this, bl), this.getDaysToExpiration()))) {
                        this.handlerCanceled_ = true;
                        throw new AS400SecurityException(25);
                    }
                    n = 0;
                }
                catch (AS400SecurityException aS400SecurityException) {
                    if (this.handlerCanceled_) {
                        throw aS400SecurityException;
                    }
                    Trace.log(2, "Security exception in sign-on:", (Throwable)aS400SecurityException);
                    signonEvent = new SignonEvent(this, bl, aS400SecurityException);
                    switch (aS400SecurityException.getReturnCode()) {
                        case 7: {
                            bl2 = signonHandler.passwordExpired(signonEvent);
                            break;
                        }
                        case 22: {
                            bl2 = signonHandler.passwordMissing(signonEvent);
                            break;
                        }
                        case 8: 
                        case 23: {
                            bl2 = signonHandler.passwordIncorrect(signonEvent);
                            break;
                        }
                        case 10: 
                        case 19: 
                        case 20: {
                            bl2 = signonHandler.passwordLengthIncorrect(signonEvent);
                            break;
                        }
                        case 9: {
                            bl2 = signonHandler.userIdAboutToBeDisabled(signonEvent);
                            break;
                        }
                        case 32: {
                            bl2 = signonHandler.userIdUnknown(signonEvent);
                            break;
                        }
                        case 31: {
                            bl2 = signonHandler.userIdDisabled(signonEvent);
                            break;
                        }
                        default: {
                            signonHandler.exceptionOccurred(signonEvent);
                        }
                    }
                    if (!bl2) {
                        throw aS400SecurityException;
                    }
                    n = 1;
                }
                catch (UnknownHostException unknownHostException) {
                    signonEvent = new SignonEvent(this, bl);
                    bl2 = signonHandler.systemNameUnknown(signonEvent, unknownHostException);
                    if (!bl2) {
                        throw unknownHostException;
                    }
                    n = 1;
                }
            } while (n != 0 && n2 < 20);
            if (n != 0) {
                Trace.log(2, "Possible infinite loop while interacting with SignonHandler.");
                throw new AS400SecurityException(26);
            }
        }
        finally {
            this.signingOn_ = false;
            this.forcePrompt_ = false;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing AS400 object.");
        }
        objectInputStream.defaultReadObject();
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(this.systemName_);
        this.proxyServer_ = AS400.resolveProxyServer("");
        this.ccsid_ = 0;
        this.propertiesFrozen_ = false;
        this.credVault_ = new PasswordVault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing connection listener.");
        }
        if (connectionListener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ != null) {
                this.connectionListeners_.removeElement(connectionListener);
                if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                    this.impl_.removeConnectionListener(this.dispatcher_);
                }
            }
        }
    }

    public static void removeDefaultUser(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing the default user, system name:", string);
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        defaultUsers.remove(AS400.resolveSystem(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePasswordCacheEntry(String string, String string2) {
        int n;
        boolean bl = false;
        String string3 = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Removing password cache entry, system name: " + string + " user ID: " + string2);
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        boolean bl2 = (string = AS400.resolveSystem(string)).equals("localhost");
        if (bl2) {
            bl = true;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = string.indexOf(".")) > 0) {
            string3 = string;
            string = string.substring(0, n);
        }
        string2 = AS400.resolveUserId(string2.toUpperCase());
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] objectArray = (Object[])systemList.elementAt(i);
                if (string.equalsIgnoreCase((String)objectArray[0]) && string2.equals(objectArray[1])) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (bl && "localhost".equalsIgnoreCase((String)objectArray[0]) && string2.equals(objectArray[1])) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (string3 == null || !string3.equalsIgnoreCase((String)objectArray[0]) || !string2.equals(objectArray[1])) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void resetAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Resetting all services.");
        }
        this.disconnectAllServices();
        this.signonInfo_ = null;
        this.propertiesFrozen_ = false;
        this.ccsid_ = 0;
    }

    private static String resolveProxyServer(String string) {
        if (string.length() == 0 && (string = SystemProperties.getProperty("com.ibm.as400.access.AS400.proxyServer")) == null) {
            return "";
        }
        return string;
    }

    static String resolveSystem(String string) {
        if (onAS400) {
            if (string.length() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial system name to 'localhost'.");
                }
                return "localhost";
            }
            if (AS400.isSystemNameLocal(string)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving system name to 'localhost'.");
                }
                return "localhost";
            }
        }
        return string;
    }

    static boolean resolveSystemNameLocal(String string) {
        return onAS400 && (string.length() == 0 || AS400.isSystemNameLocal(string));
    }

    static String resolveUserId(String string) {
        return AS400.resolveUserId(string, 0, false);
    }

    static boolean currentUserAvailable() {
        if (!currentUserTried) {
            try {
                Class.forName("com.ibm.as400.access.CurrentUser");
            }
            catch (Throwable throwable) {
                if (Trace.traceOn_) {
                    Trace.log(1, "CurrentUser class is not available:", throwable);
                }
                currentUserAvailable = false;
            }
            currentUserTried = true;
        }
        return currentUserAvailable;
    }

    static String resolveUserId(String string, int n, boolean bl) {
        if (onAS400 && !bl && AS400.currentUserAvailable()) {
            boolean bl2 = false;
            if (string.length() == 0 && n == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial user ID.");
                }
                bl2 = true;
            }
            if (string.equals("*CURRENT")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Replacing *CURRENT as user ID.");
                }
                bl2 = true;
            }
            if (bl2) {
                String string2 = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID:", string2);
                }
                if (string2 != null) {
                    return string2;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID information not available, user ID: '" + string + "'");
                }
            }
        }
        if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            if (Trace.traceOn_) {
                Trace.log(1, "Prepending 'Q' to numeric user ID.");
            }
            string = "Q" + string;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "User ID: '" + string + "'");
        }
        return string;
    }

    private void sendSignonRequest() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Signing-on without prompting...");
        }
        if (this.credVault_.isEmpty() && !AS400.userIdMatchesLocal(this.userId_, this.mustUseSuppliedProfile_)) {
            throw new AS400SecurityException(22);
        }
        if (this.credVault_.getType() == 1) {
            this.signonInfo_ = this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, this.credVault_, this.gssName_);
            if (this.gssCredential_ != null) {
                this.impl_.setGSSCredential(this.gssCredential_);
            }
            this.credVault_.empty();
        } else {
            byte[] byArray = new byte[9];
            CredentialVault.rng.nextBytes(byArray);
            CredentialVault credentialVault = (CredentialVault)this.credVault_.clone();
            credentialVault.storeEncodedUsingExternalSeeds(byArray, this.impl_.exchangeSeed(byArray));
            this.signonInfo_ = this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, credentialVault, this.gssName_);
        }
        if (this.userId_.length() == 0) {
            this.userId_ = this.signonInfo_.userId;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Sign-on completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityToken(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting identity token.");
        }
        if (byArray == null) {
            throw new NullPointerException("identityToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new IdentityTokenVault(byArray);
            this.signonInfo_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCacheEntry(String string, String string2, CredentialVault credentialVault) {
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] objectArray = (Object[])systemList.elementAt(i);
                if (!string.equalsIgnoreCase((String)objectArray[0]) || !string2.equals(objectArray[1])) continue;
                if (Trace.traceOn_) {
                    Trace.log(1, "Adding password cache entry, removing previous entry.");
                }
                systemList.removeElementAt(i);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Adding password cache entry for " + string + ":" + string2 + ".");
            }
            systemList.addElement(new Object[]{string, string2, credentialVault.clone()});
        }
    }

    public void setCcsid(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting CCSID:", n);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set CCSID after connection has been made.");
            throw new ExtendedIllegalStateException("ccsid", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.ccsid_ = n;
        } else {
            Integer n2 = new Integer(this.ccsid_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("ccsid", n2, n3);
            }
            this.ccsid_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("ccsid", n2, n3);
            }
        }
    }

    public void setDDMRDB(String string) {
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set RDB name after connection has been made.");
            throw new ExtendedIllegalStateException("ddmRDB", 5);
        }
        if (string != null && string.length() > 18) {
            throw new ExtendedIllegalArgumentException("ddmRDB", 1);
        }
        if (this.isConnected(5)) {
            throw new ExtendedIllegalStateException("ddmRDB", 4);
        }
        this.ddmRDB_ = string == null ? null : string.toUpperCase();
    }

    public static void setDefaultSignonHandler(SignonHandler signonHandler) {
        if (Trace.traceOn_) {
            if (signonHandler == null) {
                Trace.log(1, "Setting the default sign-on handler to null.");
            } else if (defaultSignonHandler_ != null) {
                Trace.log(1, "Replacing default sign-on handler, formerly an instance of " + defaultSignonHandler_.getClass().getName());
            }
        }
        defaultSignonHandler_ = signonHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDefaultUser(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the default user, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string2 == null) {
            throw new NullPointerException("userId");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string2 + ")", 1);
        }
        string = AS400.resolveSystem(string);
        string2 = AS400.resolveUserId(string2.toUpperCase());
        Hashtable hashtable = defaultUsers;
        synchronized (hashtable) {
            if (defaultUsers.get(string) == null) {
                defaultUsers.put(string, string2);
                return true;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(4, "Default user already set, set default user failed.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSCredential(Object object) {
        if (object == null) {
            throw new NullPointerException("gssCredential");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential: '" + object + "'");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssCredential_ = object;
            this.gssName_ = "";
            this.credVault_.empty();
            this.credVault_ = new GSSTokenVault();
            this.signonInfo_ = null;
            if (this.impl_ != null) {
                this.impl_.setGSSCredential(this.gssCredential_);
            }
        }
    }

    public void setGSSOption(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS option:", n);
        }
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("gssOption (" + n + ")", 2);
        }
        this.gssOption_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS name: '" + string + "'");
        }
        if (string == null) {
            throw new NullPointerException("gssName");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssName_ = string;
            this.gssCredential_ = null;
            this.credVault_.empty();
            this.credVault_ = new GSSTokenVault();
            this.signonInfo_ = null;
        }
    }

    public void setGuiAvailable(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GUI available:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.guiAvailable_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.guiAvailable_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("guiAvailable", bl2, bl3);
            }
            this.guiAvailable_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("guiAvailable", bl2, bl3);
            }
        }
    }

    public void setLocale(Locale locale) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale);
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
        } else {
            Locale locale2 = this.locale_;
            Locale locale3 = locale;
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
            this.propertyChangeListeners_.firePropertyChange("locale", locale2, locale3);
        }
    }

    public void setLocale(Locale locale, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale + ", nlv: " + this.nlv_);
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (string == null) {
            throw new NullPointerException("nlv");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        this.locale_ = locale;
        this.nlv_ = string;
    }

    public void setMustAddLanguageLibrary(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting must add language library:", this.mustAddLanguageLibrary_);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set must add language library after connection has been made.");
            throw new ExtendedIllegalStateException("mustAddLanguageLibrary", 5);
        }
        this.mustAddLanguageLibrary_ = bl;
    }

    public boolean isMustAddLanguageLibrary() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must add language library:", this.mustAddLanguageLibrary_);
        }
        return this.mustAddLanguageLibrary_;
    }

    public void setMustUseSockets(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use sockets':", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use sockets' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSockets", 5);
        }
        this.mustUseSockets_ = bl;
    }

    public boolean isMustUseNetSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use net sockets:", this.mustUseNetSockets_);
        }
        return this.mustUseNetSockets_;
    }

    public void setMustUseNetSockets(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use net sockets':", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use net sockets' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseNetSockets", 5);
        }
        this.mustUseNetSockets_ = bl;
    }

    public boolean isMustUseSuppliedProfile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use supplied profile:", this.mustUseSuppliedProfile_);
        }
        return this.mustUseSuppliedProfile_;
    }

    public void setMustUseSuppliedProfile(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use supplied profile':", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use supplied profile' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSuppliedProfile", 5);
        }
        this.mustUseSuppliedProfile_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting password.");
        }
        if (string == null) {
            throw new NullPointerException("password");
        }
        if (string.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + string.length() + ")", 1);
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new PasswordVault(string);
            this.signonInfo_ = null;
        }
    }

    public static void setPasswordExpirationWarningDays(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the password expiration warning days:", n);
        }
        expirationWarning = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileToken(ProfileTokenCredential profileTokenCredential) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting profile token.");
        }
        if (profileTokenCredential == null) {
            throw new NullPointerException("profileToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new ProfileTokenVault(profileTokenCredential);
            this.signonInfo_ = null;
        }
    }

    public void setProxyServer(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting proxy server:", string);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set proxy server after connection has been made.");
            throw new ExtendedIllegalStateException("proxyServer", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.proxyServer_ = AS400.resolveProxyServer(string);
        } else {
            String string2 = this.proxyServer_;
            String string3 = AS400.resolveProxyServer(string);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("proxyServer", string2, string3);
            }
            this.proxyServer_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("proxyServer", string2, string3);
            }
        }
    }

    public void setServicePort(int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service port, service " + n + ", port " + n2);
        }
        if (n < 0 || n > 7) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        if (n2 < -1) {
            throw new ExtendedIllegalArgumentException("port (" + n2 + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, n, n2);
    }

    public void setServicePortsToDefault() {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service ports to default.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port to default before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePortsToDefault(this.systemNameLocal_ ? "localhost" : this.systemName_);
    }

    public void setShowCheckboxes(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting show checkboxes:", bl);
        }
        this.showCheckboxes_ = bl;
    }

    public void setSignonHandler(SignonHandler signonHandler) {
        if (Trace.traceOn_) {
            if (signonHandler == null) {
                Trace.log(1, "Setting the sign-on handler to null.");
            }
            if (this.signonHandler_ != null) {
                Trace.log(1, "Sign-on handler was formerly an instance of " + this.signonHandler_.getClass().getName());
            }
        }
        this.signonHandler_ = signonHandler;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket properties: " + socketProperties);
        }
        if (socketProperties == null) {
            throw new NullPointerException("socketProperties");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set socket properties after connection has been made.");
            throw new ExtendedIllegalStateException("socketProperties", 5);
        }
        this.socketProperties_.copyValues(socketProperties);
    }

    public void setSystemName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system name:", string);
        }
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string.equals(this.systemName_)) {
            return;
        }
        if (this.propertiesFrozen_ && (this.systemNameLocal_ || this.systemName_.length() != 0)) {
            Trace.log(2, "Cannot set system name after connection has been made.");
            throw new ExtendedIllegalStateException("systemName", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.systemName_ = string;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
        } else {
            String string2 = this.systemName_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("systemName", string2, string3);
            }
            this.systemName_ = string;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(string);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("systemName", string2, string3);
            }
        }
    }

    public void setThreadUsed(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread used:", bl);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set thread used after connection has been made.");
            throw new ExtendedIllegalStateException("threadUsed", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.threadUsed_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.threadUsed_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("threadUsed", bl2, bl3);
            }
            this.threadUsed_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("threadUsed", bl2, bl3);
            }
        }
    }

    public void setUseDefaultUser(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use default user:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.useDefaultUser_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.useDefaultUser_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("useDefaultUser", bl2, bl3);
            }
            this.useDefaultUser_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("useDefaultUser", bl2, bl3);
            }
        }
    }

    public void setUsePasswordCache(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use password cache:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.usePasswordCache_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.usePasswordCache_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("usePasswordCache", bl2, bl3);
            }
            this.usePasswordCache_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("usePasswordCache", bl2, bl3);
            }
        }
    }

    public void setUserId(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user ID: '" + string + "'");
        }
        if (string == null) {
            throw new NullPointerException("userId");
        }
        if (string.equals(this.userId_)) {
            return;
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string + ")", 1);
        }
        if (this.signonInfo_ != null) {
            Trace.log(2, "Cannot set user ID after connection has been made.");
            throw new ExtendedIllegalStateException("userId", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.userId_ = string.toUpperCase();
        } else {
            String string2 = this.userId_;
            String string3 = string.toUpperCase();
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("userId", string2, string3);
            }
            this.userId_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("userId", string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void signon(boolean bl) throws AS400SecurityException, IOException {
        if (this.signonInfo_ == null) {
            Object object;
            this.chooseImpl();
            this.userId_ = AS400.resolveUserId(this.userId_, this.credVault_.getType(), this.mustUseSuppliedProfile_);
            if (this.systemName_.length() != 0) {
                if (this.userId_.length() == 0 && this.useDefaultUser_ && (object = AS400.getDefaultUser(this.systemName_)) != null) {
                    this.userId_ = object;
                }
                if (this.userId_.length() != 0 && this.credVault_.isEmpty() && this.usePasswordCache_) {
                    object = systemList;
                    synchronized (object) {
                        for (int i = systemList.size() - 1; i >= 0; --i) {
                            Object[] objectArray = (Object[])systemList.elementAt(i);
                            if (!this.systemName_.equalsIgnoreCase((String)objectArray[0]) || !this.userId_.equals(objectArray[1])) continue;
                            this.credVault_ = (CredentialVault)((CredentialVault)objectArray[2]).clone();
                        }
                    }
                }
            }
            try {
                if (this.systemName_.length() != 0 && this.proxyServer_.length() == 0 && this.credVault_.isEmpty() && (this.credVault_.getType() == 1 || this.gssOption_ != 2)) {
                    object = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                    this.credVault_ = new GSSTokenVault((byte[])object);
                }
            }
            catch (Throwable throwable) {
                if (this.credVault_.getType() == 1 || this.gssOption_ == 0) {
                    Trace.log(2, "Error retrieving GSSToken:", throwable);
                    throw new AS400SecurityException(62);
                }
                Trace.log(1, "GSSToken is not available:", throwable.getMessage());
            }
            this.promptSignon();
            if (!bl) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Disconnecting temporary connection for validating signon info.");
                }
                this.impl_.disconnect(7);
            }
        }
    }

    public String toString() {
        return "AS400 (system name: '" + this.systemName_ + "' user ID: '" + this.userId_ + "'):" + super.toString();
    }

    private static boolean userIdMatchesLocal(String string, boolean bl) {
        boolean bl2;
        if (Trace.traceOn_) {
            Trace.log(1, "Determining if specified userID (" + string + ") matches current userID.");
        }
        if (onAS400 && !bl && AS400.currentUserAvailable()) {
            String string2 = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
            if (string2 == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Current userID information not available.");
                }
                bl2 = false;
            } else {
                bl2 = string.equals(string2);
                if (Trace.traceOn_ && !bl2) {
                    Trace.log(1, "Specified userID (" + string + ") does not match current userID (" + string2 + ").");
                }
            }
        } else {
            bl2 = false;
            if (Trace.traceOn_) {
                if (!onAS400) {
                    Trace.log(1, "Not running on IBM i.");
                }
                if (bl) {
                    Trace.log(1, "Caller specified must use supplied profile.");
                }
                if (!AS400.currentUserAvailable()) {
                    Trace.log(1, "Class CurrentUser is not available.");
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Determined that specified userID (" + string + ") " + (bl2 ? "matches" : "does not match") + " current userID.");
        }
        return bl2;
    }

    public boolean validateSignon() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        return this.validateSignon(this.userId_, this.credVault_);
    }

    public boolean validateSignon(String string) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon, with password.");
        }
        if (string == null) {
            throw new NullPointerException("password");
        }
        if (string.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + string.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        PasswordVault passwordVault = new PasswordVault(string);
        return this.validateSignon(this.userId_, passwordVault);
    }

    public boolean validateSignon(String string, String string2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating signon, user ID: '" + string + "'");
        }
        if (string == null) {
            throw new NullPointerException("userId");
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + string + ")", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        if (string2.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + string2.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        PasswordVault passwordVault = new PasswordVault(string2);
        return this.validateSignon(string.toUpperCase(), passwordVault);
    }

    private boolean validateSignon(String string, CredentialVault credentialVault) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating temporary connection for validating signon info.");
        }
        AS400 aS400 = new AS400(this.systemName_, string, credentialVault);
        aS400.proxyServer_ = this.proxyServer_;
        aS400.guiAvailable_ = false;
        aS400.usePasswordCache_ = false;
        aS400.useDefaultUser_ = false;
        aS400.useSSLConnection_ = this.useSSLConnection_;
        aS400.mustUseSockets_ = true;
        aS400.mustUseNetSockets_ = this.mustUseNetSockets_;
        aS400.mustUseSuppliedProfile_ = this.mustUseSuppliedProfile_;
        aS400.socketProperties_ = this.socketProperties_;
        aS400.signon(false);
        return true;
    }

    void forcePrompt() {
        this.forcePrompt_ = true;
    }

    public void setBidiStringType(int n) {
        this.bidiStringType = n;
    }

    public int getBidiStringType() {
        return this.bidiStringType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        onAS400 = false;
        nativeVRM = null;
        defaultSignonHandlerClass_ = class$com$ibm$as400$access$ToolboxSignonHandler == null ? (class$com$ibm$as400$access$ToolboxSignonHandler = AS400.class$("com.ibm.as400.access.ToolboxSignonHandler")) : class$com$ibm$as400$access$ToolboxSignonHandler;
        defaultGuiAvailable_ = true;
        defaultMustAddLanguageLibrary_ = false;
        defaultMustUseSockets_ = false;
        defaultMustUseNetSockets_ = false;
        defaultMustUseSuppliedProfile_ = false;
        defaultThreadUsed_ = true;
        try {
            string = System.getProperty("os.name");
            if (Trace.traceOn_) {
                Trace.log(1, "Detected os.name:", string);
            }
            if (string != null && string.equalsIgnoreCase("OS/400")) {
                char[] cArray;
                String string2 = System.getProperty("os.version");
                if (Trace.traceOn_) {
                    Trace.log(1, "Detected os.version:", string2);
                }
                if (string2 != null && (cArray = string2.toCharArray()).length == 6) {
                    int n = ((cArray[1] & 0xF) << 16) + ((cArray[3] & 0xF) << 8) + (cArray[5] & 0xF);
                    nativeVRM = new ServerVersion(n);
                }
                onAS400 = true;
            }
        }
        catch (SecurityException securityException) {
            Trace.log(4, "Error retrieving os.name:", (Throwable)securityException);
        }
        string = SystemProperties.getProperty("com.ibm.as400.access.AS400.signonHandler");
        if (string != null) {
            try {
                defaultSignonHandlerClass_ = Class.forName(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving default sign-on handler (specified by property):", (Throwable)exception);
                Class clazz = defaultSignonHandlerClass_ = class$com$ibm$as400$access$ToolboxSignonHandler == null ? (class$com$ibm$as400$access$ToolboxSignonHandler = AS400.class$("com.ibm.as400.access.ToolboxSignonHandler")) : class$com$ibm$as400$access$ToolboxSignonHandler;
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.guiAvailable")) != null) {
            try {
                defaultGuiAvailable_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving guiAvailable property value:", (Throwable)exception);
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustAddLanguageLibrary")) != null) {
            try {
                defaultMustAddLanguageLibrary_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving mustAddLanguageLibrary property value:", (Throwable)exception);
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseSockets")) != null) {
            try {
                defaultMustUseSockets_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving mustUseSockets property value:", (Throwable)exception);
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseNetSockets")) != null) {
            try {
                defaultMustUseNetSockets_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving mustUseNetSockets property value:", (Throwable)exception);
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseSuppliedProfile")) != null) {
            try {
                defaultMustUseSuppliedProfile_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving mustUseSuppliedProfile property value:", (Throwable)exception);
            }
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.AS400.threadUsed")) != null) {
            try {
                defaultThreadUsed_ = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Trace.log(4, "Error retrieving threadUsed property value:", (Throwable)exception);
            }
        }
        systemList = new Vector();
        defaultUsers = new Hashtable();
        expirationWarning = 7;
        alreadyCheckedForMultipleVersions_ = 0;
        nativeVersion = -1;
        currentUserAvailable = true;
        currentUserTried = false;
    }
}

