/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSRandomAccessFileImpl;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class IFSRandomAccessFile
implements DataInput,
DataOutput,
Serializable {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    public static final int FAIL_OR_CREATE = 2;
    public static final int OPEN_OR_CREATE = 0;
    public static final int OPEN_OR_FAIL = 3;
    public static final int REPLACE_OR_CREATE = 1;
    public static final int REPLACE_OR_FAIL = 4;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private int existenceOption_;
    private IFSFileDescriptor fd_;
    private transient Vector fileListeners_;
    private String mode_ = "";
    private boolean forceToStorage_ = false;
    private transient byte[] bytes1;
    private transient byte[] bytes2;
    private transient byte[] bytes4;
    private transient byte[] bytes8;
    private transient IFSRandomAccessFileImpl impl_;

    public IFSRandomAccessFile() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSRandomAccessFile(AS400 aS400, String string, String string2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(string2);
        this.mode_ = string2;
        this.existenceOption_ = string2.equals("r") ? 3 : 0;
        this.fd_ = new IFSFileDescriptor(aS400, string, -1, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(AS400 aS400, String string, String string2, int n, int n2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(string2);
        this.mode_ = string2;
        IFSRandomAccessFile.validateShareOption(n);
        IFSRandomAccessFile.validateExistenceOption(n2);
        this.existenceOption_ = n2;
        this.fd_ = new IFSFileDescriptor(aS400, string, n, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(AS400 aS400, IFSFile iFSFile, String string, int n, int n2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(string);
        this.mode_ = string;
        IFSRandomAccessFile.validateShareOption(n);
        IFSRandomAccessFile.validateExistenceOption(n2);
        this.existenceOption_ = n2;
        this.fd_ = new IFSFileDescriptor(aS400, iFSFile.getAbsolutePath(), n, this);
        this.connectAndOpen();
    }

    public IFSRandomAccessFile(IFSFile iFSFile, String string, int n, int n2) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.initializeTransient();
        IFSRandomAccessFile.validateMode(string);
        this.mode_ = string;
        IFSRandomAccessFile.validateShareOption(n);
        IFSRandomAccessFile.validateExistenceOption(n2);
        this.existenceOption_ = n2;
        this.fd_ = new IFSFileDescriptor(iFSFile.getSystem(), iFSFile.getAbsolutePath(), n, this);
        this.connectAndOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(fileListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    void chooseImpl() {
        if (this.impl_ == null) {
            AS400 aS400 = this.fd_.getSystem();
            if (aS400 == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSRandomAccessFileImpl)aS400.loadImpl2("com.ibm.as400.access.IFSRandomAccessFileImplRemote", "com.ibm.as400.access.IFSRandomAccessFileImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
            this.impl_.setExistenceOption(this.existenceOption_);
            this.impl_.setForceToStorage(this.forceToStorage_);
            this.impl_.setMode(this.mode_);
        }
    }

    public void close() throws IOException {
        if (this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    public void flush() throws IOException {
        this.open();
        this.impl_.flush();
    }

    public int getExistenceOption() {
        return this.existenceOption_;
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    public long getFilePointer() throws IOException {
        this.open();
        return this.fd_.getFileOffset();
    }

    IFSRandomAccessFileImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.bytes1 = new byte[1];
        this.bytes2 = new byte[2];
        this.bytes4 = new byte[4];
        this.bytes8 = new byte[8];
        this.impl_ = null;
    }

    public long length() throws IOException {
        this.open();
        return this.impl_.length();
    }

    public IFSKey lock(int n, int n2) throws IOException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("offset (" + Integer.toString(n) + ")", 2);
        }
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(n2) + ")", 2);
        }
        this.open();
        return this.impl_.lock(n, n2);
    }

    public IFSKey lock(long l, long l2) throws IOException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("offset (" + Long.toString(l) + ")", 2);
        }
        if (l2 <= 0L) {
            throw new ExtendedIllegalArgumentException("length (" + Long.toString(l2) + ")", 2);
        }
        this.open();
        return this.impl_.lock(l, l2);
    }

    private void open() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)aS400SecurityException);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    public int read() throws IOException {
        int n;
        int n2 = this.read(this.bytes1, 0, 1);
        if (n2 == 1) {
            n = this.bytes1[0];
            n &= 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n2 == 0) {
            return 0;
        }
        this.open();
        return this.impl_.read(byArray, n, n2, false);
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read(this.bytes1, 0, 1);
        if (n != 1) {
            throw new EOFException();
        }
        return this.bytes1[0];
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final double readDouble() throws IOException {
        long l = this.readLong();
        return Double.longBitsToDouble(l);
    }

    public final float readFloat() throws IOException {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    public final void readFully(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open();
        this.impl_.read(byArray, n, n2, true);
    }

    public final int readInt() throws IOException {
        int n = this.read(this.bytes4, 0, 4);
        if (n != 4) {
            throw new EOFException();
        }
        return (this.bytes4[0] & 0xFF) << 24 | (this.bytes4[1] & 0xFF) << 16 | (this.bytes4[2] & 0xFF) << 8 | this.bytes4[3] & 0xFF;
    }

    public final String readLine() throws IOException {
        this.open();
        return this.impl_.readLine();
    }

    public final long readLong() throws IOException {
        int n = this.read(this.bytes8, 0, 8);
        if (n != 8) {
            throw new EOFException();
        }
        return ((long)this.bytes8[0] & 0xFFL) << 56 | ((long)this.bytes8[1] & 0xFFL) << 48 | ((long)this.bytes8[2] & 0xFFL) << 40 | ((long)this.bytes8[3] & 0xFFL) << 32 | ((long)this.bytes8[4] & 0xFFL) << 24 | ((long)this.bytes8[5] & 0xFFL) << 16 | ((long)this.bytes8[6] & 0xFFL) << 8 | (long)this.bytes8[7] & 0xFFL;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public final short readShort() throws IOException {
        int n = this.read(this.bytes2, 0, 2);
        if (n != 2) {
            throw new EOFException();
        }
        return (short)((this.bytes2[0] & 0xFF) << 8 | this.bytes2[1] & 0xFF);
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read(this.bytes1, 0, 1);
        if (n != 1) {
            throw new EOFException();
        }
        int n2 = this.bytes1[0];
        return n2 &= 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.read(this.bytes2, 0, 2);
        if (n != 2) {
            throw new EOFException();
        }
        int n2 = (this.bytes2[0] & 0xFF) << 8 | this.bytes2[1] & 0xFF;
        if (n2 < 0) {
            n2 += 65536;
        }
        return n2;
    }

    public final String readUTF() throws IOException {
        this.open();
        return this.impl_.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(fileListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("position (" + Long.toString(l) + ")", 2);
        }
        this.open();
        this.fd_.setFileOffset(l);
    }

    public void setExistenceOption(int n) throws PropertyVetoException {
        IFSRandomAccessFile.validateExistenceOption(n);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("existenceOption", 5);
        }
        Integer n2 = new Integer(this.existenceOption_);
        Integer n3 = new Integer(n);
        this.vetos_.fireVetoableChange("existenceOption", n2, n3);
        this.existenceOption_ = n;
        this.changes_.firePropertyChange("existenceOption", n2, n3);
    }

    void setForceToStorage(boolean bl) {
        this.forceToStorage_ = bl;
        if (this.impl_ != null) {
            this.impl_.setForceToStorage(bl);
        }
    }

    public void setLength(int n) throws IOException {
        this.setLength((long)n);
    }

    public void setLength(long l) throws IOException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("length + (" + Long.toString(l) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.setLength(l);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }

    public void setMode(String string) throws PropertyVetoException {
        IFSRandomAccessFile.validateMode(string);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("mode", 5);
        }
        String string2 = this.mode_;
        this.vetos_.fireVetoableChange("mode", string2, string);
        this.mode_ = string;
        this.changes_.firePropertyChange("mode", string2, string);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = this.fd_.getPath();
        String string3 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        this.vetos_.fireVetoableChange("path", string2, string3);
        this.fd_.setPath(string3);
        this.changes_.firePropertyChange("path", string2, string3);
    }

    public void setShareOption(int n) throws PropertyVetoException {
        IFSRandomAccessFile.validateShareOption(n);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer n2 = new Integer(this.fd_.getShareOption());
        Integer n3 = new Integer(n);
        this.vetos_.fireVetoableChange("shareOption", n2, n3);
        this.fd_.setShareOption(n);
        this.changes_.firePropertyChange("shareOption", n2, n3);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.fd_.setSystem(aS400);
        this.changes_.firePropertyChange("system", aS4002, aS400);
    }

    public int skipBytes(int n) throws IOException {
        long l = this.skipBytes((long)n);
        if (l > (long)n) {
            Trace.log(2, "Returned bytesSkipped value (" + l + ") exceeds requested number of bytes to skip (" + n + ").");
            throw new InternalErrorException(6);
        }
        return (int)l;
    }

    public long skipBytes(long l) throws IOException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("bytesToSkip (" + Long.toString(l) + ")", 2);
        }
        this.open();
        this.fd_.incrementFileOffset(l);
        return l;
    }

    public void unlock(IFSKey iFSKey) throws IOException {
        if (iFSKey == null) {
            throw new NullPointerException("key");
        }
        this.open();
        this.impl_.unlock(iFSKey);
    }

    private static final void validateExistenceOption(int n) {
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("existenceOption (" + Integer.toString(n) + ")", 2);
        }
    }

    private static final void validateMode(String string) {
        if (string == null) {
            throw new NullPointerException("mode");
        }
        if (!(string.equals("r") || string.equals("w") || string.equals("rw"))) {
            throw new ExtendedIllegalArgumentException("mode (" + string + ")", 2);
        }
    }

    private static final void validateShareOption(int n) {
        if (n < -4 || n > -1) {
            throw new ExtendedIllegalArgumentException("shareOption (" + Integer.toString(n) + ")", 2);
        }
    }

    public void write(int n) throws IOException {
        this.bytes1[0] = (byte)n;
        this.writeBytes(this.bytes1, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.writeBytes(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.bytes1[0] = (byte)n;
        this.writeBytes(this.bytes1, 0, 1);
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open();
        this.impl_.writeBytes(byArray, n, n2);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }

    public final void writeBytes(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("s");
        }
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            byArray[i] = (byte)(c & 0xFF);
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public final void writeChar(int n) throws IOException {
        char c = (char)n;
        this.bytes2[0] = (byte)(c >>> 8);
        this.bytes2[1] = (byte)(c & 0xFF);
        this.writeBytes(this.bytes2, 0, 2);
    }

    public final void writeChars(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("s");
        }
        byte[] byArray = new byte[string.length() * 2];
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            byArray[n2 + 1] = (byte)(c & 0xFF);
            byArray[n2] = (byte)(c >>> 8);
            ++n;
            n2 += 2;
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        int n2 = n;
        int n3 = 0;
        while (n3 < 4) {
            this.bytes4[3 - n3] = (byte)n2;
            ++n3;
            n2 >>>= 8;
        }
        this.writeBytes(this.bytes4, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        long l2 = l;
        int n = 0;
        while (n < 8) {
            this.bytes8[7 - n] = (byte)l2;
            ++n;
            l2 >>>= 8;
        }
        this.writeBytes(this.bytes8, 0, 8);
    }

    public final void writeShort(int n) throws IOException {
        this.bytes2[1] = (byte)n;
        this.bytes2[0] = (byte)(n >>> 8);
        this.writeBytes(this.bytes2, 0, 2);
    }

    public final void writeUTF(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("s");
        }
        this.open();
        this.impl_.writeUTF(string);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }
}

