/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionPool;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.JDTrace;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

class PoolConnectionEventListener
implements ConnectionEventListener {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private transient AS400JDBCConnectionPool pool_;

    public PoolConnectionEventListener(AS400JDBCConnectionPool aS400JDBCConnectionPool) {
        this.pool_ = aS400JDBCConnectionPool;
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        JDTrace.logInformation(this, "PooledConnection is in error...");
        this.pool_.closePooledConnection((AS400JDBCPooledConnection)connectionEvent.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent connectionEvent) {
        block16: {
            AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)connectionEvent.getSource();
            Object object = this.pool_.activePool_;
            synchronized (object) {
                this.pool_.activePool_.removeElement(aS400JDBCPooledConnection);
            }
            if (this.pool_.getMaxLifetime() != -1L && aS400JDBCPooledConnection.getLifeSpan() > this.pool_.getMaxLifetime() || this.pool_.getMaxUseCount() != -1 && aS400JDBCPooledConnection.getUseCount() == this.pool_.getMaxUseCount() || this.pool_.getMaxConnections() != -1 && this.pool_.activePool_.size() > this.pool_.getMaxConnections()) {
                JDTrace.logInformation(this, "Connection has expired.  Removed from the pool.");
                this.pool_.closePooledConnection(aS400JDBCPooledConnection);
                if (this.pool_.poolListeners_ != null) {
                    object = new ConnectionPoolEvent(aS400JDBCPooledConnection, 4);
                    this.pool_.poolListeners_.fireConnectionExpiredEvent((ConnectionPoolEvent)object);
                }
            } else {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Returning active connection to the pool.");
                }
                object = aS400JDBCPooledConnection.getInternalConnection();
                try {
                    if (!((AS400JDBCConnection)object).isClosed()) {
                        Serializable serializable = this.pool_.availablePool_;
                        synchronized (serializable) {
                            this.pool_.availablePool_.addElement(aS400JDBCPooledConnection);
                        }
                        if (this.pool_.poolListeners_ != null) {
                            serializable = new ConnectionPoolEvent(aS400JDBCPooledConnection, 3);
                            this.pool_.poolListeners_.fireConnectionReturnedEvent((ConnectionPoolEvent)serializable);
                        }
                        break block16;
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Removing closed connection from pool.");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (!this.pool_.isThreadUsed() && this.pool_.isRunMaintenance() && System.currentTimeMillis() - this.pool_.lastSingleThreadRun_ > this.pool_.getCleanupInterval()) {
            this.pool_.cleanupConnections();
        }
    }
}

