/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCallCancelThread;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ProgramCall
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.ProgramCall";
    static final long serialVersionUID = 4L;
    private static final int UNSPECIFIED = 0;
    private static final int SPECIFIED_BY_PROPERTY = 1;
    private static final int SPECIFIED_BY_SETTER = 2;
    static final Boolean THREADSAFE_TRUE;
    static final Boolean THREADSAFE_FALSE;
    AS400 system_ = null;
    String program_ = "";
    Job job_ = null;
    String library_ = "";
    String name_ = "";
    ProgramParameter[] parameterList_ = new ProgramParameter[0];
    AS400Message[] messageList_ = new AS400Message[0];
    transient Boolean threadSafetyValue_ = THREADSAFE_FALSE;
    boolean threadSafety_ = false;
    private int threadSafetyDetermined_ = 0;
    int messageOption_ = 0;
    transient RemoteCommandImpl impl_ = null;
    transient Vector actionCompletedListeners_ = null;
    transient PropertyChangeSupport propertyChangeListeners_ = null;
    transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private int timeOut_ = 0;
    private boolean running_ = false;
    private boolean cancelling_ = false;
    private ProgramCallCancelThread cancelThread_;
    private Object cancelLock_ = new CancelLock();

    public void setTimeOut(int n) {
        this.timeOut_ = n;
    }

    public int getTimeout() {
        return this.timeOut_;
    }

    public boolean isRunning() {
        return this.running_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.cancelLock_;
        synchronized (object) {
            this.cancelling_ = true;
            if (Trace.traceOn_) {
                Trace.log(3, "Cancelling program " + this.getProgram());
            }
            try {
                Job job = new Job(new AS400(this.system_), this.job_.getName(), this.job_.getUser(), this.job_.getNumber());
                job.end(0);
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(3, "Cancelling program " + this.getProgram(), (Throwable)exception);
                }
            }
            finally {
                this.cancelling_ = false;
                this.cancelLock_.notifyAll();
            }
        }
    }

    private void startCancelThread() {
        if (this.timeOut_ != 0) {
            this.running_ = true;
            this.cancelThread_ = new ProgramCallCancelThread(this);
            this.cancelThread_.setDaemon(true);
            this.cancelThread_.start();
        }
    }

    private void endCancelThread() {
        if (this.timeOut_ != 0) {
            this.running_ = false;
            this.cancelThread_.programCall_ = null;
            this.cancelThread_.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancel() {
        Object object = this.cancelLock_;
        synchronized (object) {
            while (this.cancelling_) {
                try {
                    this.cancelLock_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public ProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ProgramCall object.");
        }
        this.checkThreadSafetyProperty();
    }

    public ProgramCall(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ProgramCall object, system: " + aS400);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.checkThreadSafetyProperty();
    }

    public ProgramCall(AS400 aS400, String string, ProgramParameter[] programParameterArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ProgramCall object, system: " + aS400 + " program: " + string);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.checkThreadSafetyProperty();
        try {
            this.setProgram(string, programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding action completed listener.");
        }
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.actionCompletedListeners_ == null) {
                this.actionCompletedListeners_ = new Vector();
            }
            this.actionCompletedListeners_.addElement(actionCompletedListener);
        }
    }

    public void addParameter(ProgramParameter programParameter) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding parameter to parameter list.");
        }
        if (programParameter == null) {
            throw new NullPointerException("parameter");
        }
        int n = this.parameterList_.length;
        ProgramParameter[] programParameterArray = new ProgramParameter[n + 1];
        System.arraycopy(this.parameterList_, 0, programParameterArray, 0, n);
        programParameterArray[n] = programParameter;
        this.setParameterList(programParameterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        ProgramCall programCall = this;
        synchronized (programCall) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Attempt to connect to command server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (RemoteCommandImpl)this.system_.loadImpl3("com.ibm.as400.access.RemoteCommandImplNative", "com.ibm.as400.access.RemoteCommandImplRemote", "com.ibm.as400.access.RemoteCommandImplProxy");
            this.impl_.setSystem(this.system_.getImpl());
        }
    }

    void fireActionCompleted() {
        Vector vector = (Vector)this.actionCompletedListeners_.clone();
        ActionCompletedEvent actionCompletedEvent = new ActionCompletedEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            ActionCompletedListener actionCompletedListener = (ActionCompletedListener)vector.elementAt(i);
            actionCompletedListener.actionCompleted(actionCompletedEvent);
        }
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list.");
        }
        return this.messageList_;
    }

    public int getMessageOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message option:", this.messageOption_);
        }
        return this.messageOption_;
    }

    public ProgramParameter[] getParameterList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting parameter list.");
        }
        return this.parameterList_;
    }

    public String getProgram() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting program: " + this.program_);
        }
        return this.program_;
    }

    public Job getServerJob() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job.");
        }
        this.chooseImpl();
        String string = this.impl_.getJobInfo(this.threadSafetyValue_);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job for job: " + string);
        }
        return new Job(this.system_, string.substring(0, 10).trim(), string.substring(10, 20).trim(), string.substring(20, 26).trim());
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public Thread getSystemThread() throws AS400SecurityException, IOException {
        Thread thread;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system thread.");
        }
        this.chooseImpl();
        Thread thread2 = thread = this.impl_.isNative() ? Thread.currentThread() : null;
        if (Trace.traceOn_) {
            Trace.log(1, "System thread: " + thread);
        }
        return thread;
    }

    static String getThreadSafetyProperty() {
        String string = SystemProperties.getProperty("com.ibm.as400.access.ProgramCall.threadSafe");
        return string == null || string.length() == 0 ? null : string.toLowerCase();
    }

    static Boolean getDefaultThreadSafety() {
        return new Boolean(ProgramCall.getThreadSafetyProperty());
    }

    private void checkThreadSafetyProperty() {
        String string = ProgramCall.getThreadSafetyProperty();
        if (string == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Thread safe system property not set, thread safety property remains unspecified.");
            }
        } else {
            this.threadSafetyValue_ = string.equals("true") ? THREADSAFE_TRUE : THREADSAFE_FALSE;
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
            this.threadSafetyDetermined_ = 1;
            if (Trace.traceOn_) {
                Trace.log(1, "Thread safe system property: " + string);
            }
        }
    }

    public boolean isStayOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        boolean bl;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if program will actually get run on the current thread.");
        }
        this.chooseImpl();
        boolean bl2 = bl = THREADSAFE_TRUE.equals(this.threadSafetyValue_) && this.impl_.isNative();
        if (Trace.traceOn_) {
            Trace.log(1, "Will program actually get run on the current thread:", bl);
        }
        return bl;
    }

    public boolean isThreadSafe() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if program will be assumed thread-safe.");
        }
        return this.threadSafetyValue_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing ProgramCall object.");
        }
        objectInputStream.defaultReadObject();
        if (this.threadSafetyDetermined_ == 2) {
            this.threadSafetyValue_ = this.threadSafety_ ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        } else {
            String string = ProgramCall.getThreadSafetyProperty();
            if (string == null) {
                this.threadSafetyValue_ = THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(1, "Thread safe system property not set, thread safety property changed to unspecified.");
                }
            } else {
                this.threadSafetyValue_ = string.equals("true") ? THREADSAFE_TRUE : THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 1;
                if (Trace.traceOn_) {
                    Trace.log(1, "Thread safe system property: " + string);
                }
            }
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
        }
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing action completed listener.");
        }
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.actionCompletedListeners_ != null) {
            this.actionCompletedListeners_.removeElement(actionCompletedListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        boolean bl;
        if (Trace.traceOn_) {
            Trace.log(3, "Running program: " + this.program_);
        }
        if (this.program_.length() == 0) {
            Trace.log(2, "Attempt to run before setting program.");
            throw new ExtendedIllegalStateException("program", 4);
        }
        for (bl = false; bl < this.parameterList_.length; bl += 1) {
            if (this.parameterList_[bl] != null) continue;
            throw new ExtendedIllegalArgumentException("parameterList[" + (int)(bl ? 1 : 0) + "] (" + this.parameterList_[bl] + ")", 2);
        }
        this.chooseImpl();
        try {
            this.job_ = this.getServerJob();
            this.checkCancel();
            this.startCancelThread();
            bl = this.impl_.runProgram(this.library_, this.name_, this.parameterList_, this.threadSafetyValue_, this.messageOption_);
            this.endCancelThread();
            this.messageList_ = this.impl_.getMessageList();
            if (this.system_ != null) {
                for (int i = 0; i < this.messageList_.length; ++i) {
                    this.messageList_[i].setSystem(this.system_);
                }
            }
            if (this.actionCompletedListeners_ != null) {
                this.fireActionCompleted();
            }
            return bl;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.messageList_ = this.impl_.getMessageList();
            if (this.system_ != null) {
                for (int i = 0; i < this.messageList_.length; ++i) {
                    this.messageList_[i].setSystem(this.system_);
                }
            }
            throw objectDoesNotExistException;
        }
    }

    public boolean run(String string, ProgramParameter[] programParameterArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, PropertyVetoException {
        this.setProgram(string, programParameterArray);
        return this.run();
    }

    public void setParameterList(ProgramParameter[] programParameterArray) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting parameter list.");
        }
        if (programParameterArray == null) {
            throw new NullPointerException("parameterList");
        }
        if (programParameterArray.length > 35) {
            Trace.log(2, "Parameter list length exceeds limit of 35 parameters:", programParameterArray.length);
            throw new ExtendedIllegalArgumentException("parameterList.length (" + programParameterArray.length + ")", 1);
        }
        ProgramParameter[] programParameterArray2 = this.parameterList_;
        ProgramParameter[] programParameterArray3 = programParameterArray;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("parameterList", programParameterArray2, programParameterArray3);
        }
        this.parameterList_ = programParameterArray3;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("parameterList", programParameterArray2, programParameterArray3);
        }
    }

    public void setProgram(String string, ProgramParameter[] programParameterArray) throws PropertyVetoException {
        this.setProgram(string);
        this.setParameterList(programParameterArray);
    }

    public void setProgram(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting program: " + string);
        }
        if (string == null) {
            throw new NullPointerException("program");
        }
        if (Trace.traceOn_ && string.length() == 0) {
            Trace.log(4, "Parameter 'program' is has length of 0.");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "PGM");
        String string2 = this.program_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("program", string2, string3);
        }
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.program_ = string3;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("program", string2, string3);
        }
    }

    public void setMessageOption(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message option:", n);
        }
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("messageOption (" + n + ")", 2);
        }
        this.messageOption_ = n;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        AS400 aS4003 = aS400;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
        }
        this.system_ = aS4003;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
        }
    }

    public void setThreadSafe(boolean bl) {
        Boolean bl2;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread safe: " + bl);
        }
        Boolean bl3 = bl2 = bl ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        if (this.propertyChangeListeners_ != null) {
            Boolean bl4 = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", bl4, bl2);
        }
        this.threadSafetyValue_ = bl2;
        this.threadSafety_ = bl;
        this.threadSafetyDetermined_ = 2;
    }

    public void suggestThreadsafe() {
        if (ProgramCall.getThreadSafetyProperty() == null) {
            this.setThreadSafe(true);
        }
    }

    public String toString() {
        return "ProgramCall (system: " + this.system_ + " program: " + this.program_ + "):" + super.toString();
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        THREADSAFE_TRUE = CommandCall.THREADSAFE_TRUE;
        THREADSAFE_FALSE = CommandCall.THREADSAFE_FALSE;
    }

    private class CancelLock
    implements Serializable {
        private CancelLock() {
        }
    }
}

