/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLSmallint
implements SQLData {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int truncated_ = 0;
    private boolean outOfBounds_ = false;
    private short value_ = 0;
    private int scale_;
    private BigDecimal bigDecimalValue_ = null;
    private int vrm_;

    SQLSmallint(int n) {
        this(0, n);
    }

    SQLSmallint(int n, int n2) {
        this.scale_ = n;
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_));
        }
        this.vrm_ = n2;
    }

    public Object clone() {
        return new SQLSmallint(this.scale_, this.vrm_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToShort(byArray, n);
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = (short)this.bigDecimalValue_.intValue();
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.shortToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (object instanceof String) {
            boolean bl = false;
            try {
                int n2 = Integer.parseInt((String)object);
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    this.truncated_ = 6;
                    this.outOfBounds_ = true;
                    if (this.vrm_ >= JDUtilities.vrm610) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                this.value_ = (short)n2;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                try {
                    double d = Double.valueOf((String)object);
                    if (d > 32767.0 || d < -32768.0) {
                        this.truncated_ = 6;
                        this.outOfBounds_ = true;
                        if (this.vrm_ >= JDUtilities.vrm610) {
                            JDError.throwSQLException(this, "07006");
                        }
                    }
                    this.value_ = (short)d;
                }
                catch (NumberFormatException numberFormatException) {
                    JDError.throwSQLException(this, "07006");
                }
            }
        } else if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l > 32767L || l < -32768L) {
                this.truncated_ = 6;
                this.outOfBounds_ = true;
            }
            this.value_ = (short)l;
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? (short)1 : 0;
        } else {
            JDError.throwSQLException(this, "07006");
        }
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Short.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = (short)this.bigDecimalValue_.intValue();
        }
    }

    public int getSQLType() {
        return 26;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 6;
    }

    public String getJavaClassName() {
        return "java.lang.Integer";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "SMALLINT";
    }

    public int getMaximumPrecision() {
        return 5;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 500;
    }

    public int getPrecision() {
        return 5;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return this.scale_;
    }

    public int getType() {
        return 5;
    }

    public String getTypeName() {
        return "SMALLINT";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 2;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            if (n >= 0) {
                return this.bigDecimalValue_.setScale(n);
            }
            return this.bigDecimalValue_;
        }
        if (n <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(n);
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 127 || this.value_ < -128) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.doubleValue();
        }
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.floatValue();
        }
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new Integer(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Short.toString(this.value_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getNCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Short.toString(this.value_);
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

