/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationRule;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.IValidationProxy;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.validation.AbstractFunctionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Class;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.NullLiteral;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.jtopen.ext.Utils;
import org.eclipse.edt.mof.eglx.jtopen.messages.IBMiResourceKeys;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.utils.EList;
import org.eclipse.edt.mof.utils.NameUtile;

public class IBMiFunctionValidator
extends AbstractFunctionValidator {
    private Annotation annotation;
    private NestedFunction nestedFunction;
    private Map<Object, Object> parameterAnnotations;

    public boolean visit(NestedFunction nestedFunction) {
        if (nestedFunction.getName().resolveMember() instanceof Function) {
            this.validateContainerIsCorrect(((IRPartBinding)this.declaringPart).getIrPart(), nestedFunction);
            this.validateFunctionBodyIsEmpty((Function)nestedFunction.getName().resolveMember(), nestedFunction);
            this.nestedFunction = nestedFunction;
            this.annotation = nestedFunction.getName().resolveMember().getAnnotation("eglx.jtopen.annotations.IBMiProgram");
            Object obj = this.annotation.getValue("parameterAnnotations");
            if (((EList)obj).size() > 0) {
                if (((EList)obj).size() != nestedFunction.getFunctionParameters().size()) {
                    this.problemRequestor.acceptProblem((Node)nestedFunction, 5701, 2, new String[]{nestedFunction.getName().getCaseSensitiveIdentifier()}, IBMiResourceKeys.getResourceBundleForKeys());
                }
            } else {
                Iterator iterator = nestedFunction.getFunctionParameters().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ((EList)obj).add((Object)IrFactory.INSTANCE.createNullLiteral());
                }
            }
            int size = Math.min(((EList)obj).size(), nestedFunction.getFunctionParameters().size());
            this.parameterAnnotations = new HashMap<Object, Object>(size);
            int idx = 0;
            while (idx < size) {
                this.parameterAnnotations.put(nestedFunction.getFunctionParameters().get(idx), ((EList)obj).get(idx));
                ++idx;
            }
        }
        return true;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        Member parm = functionParameter.getName().resolveMember();
        if (parm.getType() != null) {
            Object parmAnn = this.parameterAnnotations.get(functionParameter);
            boolean requiresAS400TypeAnnotationTest = true;
            if (parmAnn != null && !(parmAnn instanceof NullLiteral)) {
                if (parmAnn instanceof Annotation) {
                    IValidationProxy proxy = AnnotationValidator.getValidationProxy((Annotation)((Annotation)parmAnn));
                    if (proxy != null) {
                        for (AnnotationValidationRule rule : proxy.getAnnotationValidators()) {
                            requiresAS400TypeAnnotationTest = false;
                            HashMap<String, Object> annotations = new HashMap<String, Object>(1);
                            annotations.put(NameUtile.getAsName((String)((Annotation)parmAnn).getEClass().getETypeSignature()), parmAnn);
                            rule.validate((Node)functionParameter, (Node)functionParameter, (Element)parm, annotations, this.problemRequestor, this.compilerOptions);
                        }
                    }
                } else {
                    requiresAS400TypeAnnotationTest = false;
                    this.problemRequestor.acceptProblem((Node)functionParameter, 5702, 2, new String[]{parmAnn.toString(), functionParameter.getName().getCaseSensitiveIdentifier()}, IBMiResourceKeys.getResourceBundleForKeys());
                }
            }
            if (requiresAS400TypeAnnotationTest && Utils.requiresAS400TypeAnnotation(parm.getType())) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 5715, 2, new String[]{parm.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if (!Utils.isValidAS400Type(parm.getType())) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 5717, 2, new String[]{parm.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if (parm.isNullable()) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 5718, 2, new String[]{BindingUtil.getTypeName((Member)parm), parm.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if (parm.getType() instanceof ArrayType && ((ArrayType)parm.getType()).getElementType() != null && ((ArrayType)parm.getType()).elementsNullable()) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 5719, 2, new String[]{BindingUtil.getShortTypeString((Type)((ArrayType)parm.getType()).getElementType(), (boolean)true), parm.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if (parm.getType() instanceof Record || parm.getType() instanceof Handler || parm.getType() instanceof ArrayType) {
                parm.getType().accept((EVisitor)new ComplexTypes((FunctionParameter)parm, functionParameter));
            }
        }
        return false;
    }

    public boolean visit(ReturnsDeclaration returnsDeclaration) {
        Type returnType;
        Type type = returnType = returnsDeclaration.getType() != null ? returnsDeclaration.getType().resolveType() : null;
        if (returnType != null) {
            Object isServiceProgram = this.annotation.getValue("isServiceProgram");
            if (isServiceProgram == null || isServiceProgram instanceof java.lang.Boolean && !((java.lang.Boolean)isServiceProgram).booleanValue() || isServiceProgram instanceof Boolean && !((Boolean)isServiceProgram).booleanValue()) {
                this.problemRequestor.acceptProblem((Node)returnsDeclaration, 5705, 2, new String[]{this.nestedFunction.getName().getCaseSensitiveIdentifier()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if (!TypeUtils.Type_INT.equals(returnType).booleanValue()) {
                this.problemRequestor.acceptProblem((Node)returnsDeclaration, 5706, 2, new String[]{this.nestedFunction.getName().getCaseSensitiveIdentifier()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
        }
        return false;
    }

    private void validateFunctionBodyIsEmpty(Function function, NestedFunction nestedFunction) {
        if (nestedFunction != null && nestedFunction.getStmts() != null) {
            for (Statement stmt : nestedFunction.getStmts()) {
                this.problemRequestor.acceptProblem((Node)stmt, 5704, 2, new String[]{function.getCaseSensitiveName()});
            }
        }
    }

    private void validateContainerIsCorrect(Part part, NestedFunction errorNode) {
        if (part != null) {
            if (part instanceof Program) {
                return;
            }
            if (part instanceof Library) {
                return;
            }
            if (part instanceof Service) {
                return;
            }
            if (part instanceof Class) {
                return;
            }
            if (part instanceof Handler && ((Handler)part).getStereotype() == null) {
                return;
            }
        }
        this.problemRequestor.acceptProblem((Node)errorNode, 5703, 2, new String[]{errorNode.getName().getCaseSensitiveIdentifier()}, IBMiResourceKeys.getResourceBundleForKeys());
    }

    protected class ComplexTypes
    extends AbstractVisitor {
        private FunctionParameter parameter;
        private org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter;
        private List<String> analyzedTypes = new ArrayList<String>();

        public ComplexTypes(FunctionParameter parameter, org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
            this.parameter = parameter;
            this.functionParameter = functionParameter;
        }

        public boolean visit(Type type) {
            if (!this.analyzedTypes.contains(type.getTypeSignature()) && (type instanceof Record || type instanceof Handler)) {
                this.analyzedTypes.add(type.getTypeSignature());
                return true;
            }
            return false;
        }

        public boolean visit(ArrayType arrayType) {
            arrayType.getElementType().accept((EVisitor)this);
            return false;
        }

        public boolean visit(Field field) {
            this.validateField(this.parameter, field);
            return true;
        }

        private void validateField(FunctionParameter parm, Field field) {
            if (field.getType() == null) {
                return;
            }
            String containerName = "";
            if (field.getContainer() instanceof NamedElement) {
                containerName = ((NamedElement)field.getContainer()).getCaseSensitiveName();
            }
            if (!Utils.isValidAS400Type(field.getType())) {
                IBMiFunctionValidator.this.problemRequestor.acceptProblem((Node)this.functionParameter, 5720, 2, new String[]{parm.getCaseSensitiveName(), containerName, field.getCaseSensitiveName(), BindingUtil.getTypeName((Member)field)}, IBMiResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (field.isNullable()) {
                IBMiFunctionValidator.this.problemRequestor.acceptProblem((Node)this.functionParameter, 5721, 2, new String[]{parm.getCaseSensitiveName(), containerName, field.getCaseSensitiveName(), BindingUtil.getTypeName((Member)field)}, IBMiResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (field.getType() instanceof ArrayType && ((ArrayType)field.getType()).getElementType() != null && ((ArrayType)field.getType()).elementsNullable()) {
                IBMiFunctionValidator.this.problemRequestor.acceptProblem((Node)this.functionParameter, 5722, 2, new String[]{parm.getCaseSensitiveName(), containerName, field.getCaseSensitiveName(), BindingUtil.getTypeName((Member)field)}, IBMiResourceKeys.getResourceBundleForKeys());
                return;
            }
            if (!this.hasStructAnnotation(field) && Utils.requiresAS400TypeAnnotation(field.getType())) {
                IBMiFunctionValidator.this.problemRequestor.acceptProblem((Node)this.functionParameter, 5723, 2, new String[]{parm.getCaseSensitiveName(), containerName, field.getCaseSensitiveName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
        }

        private boolean hasStructAnnotation(Field binding) {
            for (Annotation annotation : binding.getAnnotations()) {
                if (!NameUtile.equals((String)"eglx.jtopen.annotations", (String)annotation.getEClass().getPackageName())) continue;
                return true;
            }
            return false;
        }
    }
}

