/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.services.validation;

import java.util.HashMap;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.services.ext.Utils;
import org.eclipse.edt.mof.eglx.services.messages.ResourceKeys;
import org.eclipse.edt.mof.eglx.services.validation.ServiceProxyFunctionValidator;
import org.eclipse.edt.mof.utils.NameUtile;

public class RestServiceProxyFunctionValidator
extends ServiceProxyFunctionValidator {
    @Override
    protected Annotation getAnnotation(Function function) {
        return function.getAnnotation("eglx.rest.Rest");
    }

    @Override
    protected void validate(NestedFunction nestedFunction) {
        Function function = (Function)nestedFunction.getName().resolveMember();
        Annotation restAnnotation = this.getAnnotation(function);
        if (function.getReturnType() != null) {
            EnumerationEntry respForm;
            if (!this.isResourceType(function.getReturnType(), restAnnotation)) {
                this.problemRequestor.acceptProblem((Node)nestedFunction.getReturnType(), 3403, 2, new String[]{function.getCaseSensitiveName(), this.getName()}, ResourceKeys.getResourceBundleForKeys());
            }
            if (function.getReturnType().equals(TypeUtils.Type_STRING).booleanValue() && (respForm = (EnumerationEntry)restAnnotation.getValue("responseFormat")) != null) {
                this.problemRequestor.acceptProblem((Node)nestedFunction.getReturnType(), 3407, 2, new String[]{"responseFormat"}, ResourceKeys.getResourceBundleForKeys());
            }
        }
        HashMap<String, FunctionParameter> parmNamesToNodes = new HashMap<String, FunctionParameter>();
        for (Object parm : nestedFunction.getFunctionParameters()) {
            parmNamesToNodes.put(((FunctionParameter)parm).getName().getCanonicalName().toLowerCase(), (FunctionParameter)parm);
            if (((FunctionParameter)parm).getUseType() == FunctionParameter.UseType.IN) continue;
            this.problemRequestor.acceptProblem((Node)((FunctionParameter)parm), 3401, 2, new String[]{((FunctionParameter)parm).getName().getCanonicalName(), function.getCaseSensitiveName(), this.getName()}, ResourceKeys.getResourceBundleForKeys());
        }
        HashMap<String, SubstitutionVar> namesToSubstitutionVars = this.parseSubtitutionVars(restAnnotation);
        boolean foundResourceParm = false;
        for (FunctionParameter parm : parmNamesToNodes.values()) {
            Member member;
            if (namesToSubstitutionVars.get(NameUtile.getAsName((String)parm.getName().getCanonicalName())) == null) {
                if (this.supportsResourceParm(restAnnotation)) {
                    Type type;
                    EnumerationEntry reqForm;
                    if (foundResourceParm) {
                        this.problemRequestor.acceptProblem((Node)parm, 3402, 2, new String[]{function.getCaseSensitiveName(), this.getName(), parm.getName().getCanonicalName()}, ResourceKeys.getResourceBundleForKeys());
                        continue;
                    }
                    foundResourceParm = true;
                    if (parm.getType().resolveType() == null) continue;
                    if (!this.isResourceType(parm.getType().resolveType(), restAnnotation)) {
                        this.problemRequestor.acceptProblem((Node)parm, 3406, 2, new String[]{parm.getName().getCanonicalName(), function.getCaseSensitiveName(), this.getName()}, ResourceKeys.getResourceBundleForKeys());
                        continue;
                    }
                    if (parm.getType().resolveType().equals(TypeUtils.Type_STRING).booleanValue() && (reqForm = (EnumerationEntry)restAnnotation.getValue("requestFormat")) != null && !NameUtile.equals((String)NameUtile.getAsName((String)"none"), (String)reqForm.getName())) {
                        this.problemRequestor.acceptProblem(Utils.getRequestFormat(nestedFunction), 3407, 2, new String[]{"requestFormat"}, ResourceKeys.getResourceBundleForKeys());
                    }
                    if ((reqForm = (EnumerationEntry)restAnnotation.getValue("requestFormat")) == null || !NameUtile.equals((String)NameUtile.getAsName((String)"_form"), (String)reqForm.getName()) || this.isFlatRecord(type = parm.getType().resolveType())) continue;
                    this.problemRequestor.acceptProblem((Node)parm, 3409, 2, new String[]{parm.getName().getCanonicalName(), function.getCaseSensitiveName()}, ResourceKeys.getResourceBundleForKeys());
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)nestedFunction, 3411, 2, new String[]{function.getCaseSensitiveName(), this.getName(), parm.getName().getCanonicalName()}, ResourceKeys.getResourceBundleForKeys());
                continue;
            }
            if (parm.getType().resolveType() == null || (member = parm.getName().resolveMember()) == null || IRUtils.isMoveCompatible((Type)TypeUtils.Type_STRING, (Type)member.getType(), (Member)member)) continue;
            this.problemRequestor.acceptProblem((Node)parm, 3404, 2, new String[]{parm.getName().getCanonicalName(), function.getCaseSensitiveName(), this.getName()}, ResourceKeys.getResourceBundleForKeys());
        }
        for (String key : namesToSubstitutionVars.keySet()) {
            SubstitutionVar var = namesToSubstitutionVars.get(key);
            int absStart = Utils.getUriTemplateNode(nestedFunction).getOffset() + 1;
            FunctionParameter parm = (FunctionParameter)parmNamesToNodes.get(key);
            if (parm != null) continue;
            this.problemRequestor.acceptProblem(absStart + var.getStartOffset(), absStart + var.getEndOffset(), 2, 3405, new String[]{var.getVarName(), function.getCaseSensitiveName()}, ResourceKeys.getResourceBundleForKeys());
        }
    }

    private boolean isResourceType(Type type, Annotation restAnnotation) {
        if (type == null) {
            return false;
        }
        EnumerationEntry responseFormat = (EnumerationEntry)restAnnotation.getValue("responseFormat");
        if (responseFormat != null && NameUtile.equals((String)NameUtile.getAsName((String)"json"), (String)responseFormat.getName()) && type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        if (type.equals(TypeUtils.Type_STRING).booleanValue()) {
            return true;
        }
        return type instanceof Record;
    }

    private boolean isFlatRecord(Type type) {
        if (type == null) {
            return false;
        }
        if (this.isSupportedContainer(type)) {
            for (Member member : ((Container)type).getMembers()) {
                if (!(member.getType() instanceof Record)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof Handler) {
            for (Member member : ((Handler)type).getMembers()) {
                if (!this.isSupportedContainer(member.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isSupportedContainer(Type type) {
        return type instanceof Record || type instanceof Handler;
    }

    private HashMap<String, SubstitutionVar> parseSubtitutionVars(Annotation restAnnotation) {
        HashMap<String, SubstitutionVar> namesToSubstitutionVars = new HashMap<String, SubstitutionVar>();
        String uriTemp = (String)restAnnotation.getValue("uriTemplate");
        char[] chars = uriTemp != null ? uriTemp.toCharArray() : new char[]{};
        int lOffset = 0;
        boolean lookingForL = true;
        int i = 0;
        while (i < chars.length) {
            if (lookingForL) {
                if (chars[i] == '{') {
                    lOffset = i;
                    lookingForL = false;
                }
            } else if (chars[i] == '}') {
                SubstitutionVar var = new SubstitutionVar(lOffset + 1, i, uriTemp);
                namesToSubstitutionVars.put(NameUtile.getAsName((String)var.getVarName()), var);
                lookingForL = true;
            }
            ++i;
        }
        return namesToSubstitutionVars;
    }

    private boolean supportsResourceParm(Annotation restAnnotation) {
        EnumerationEntry method = (EnumerationEntry)restAnnotation.getValue("method");
        return method == null || !"_get".equalsIgnoreCase(method.getName());
    }

    @Override
    protected String getName() {
        return "REST";
    }

    private static class SubstitutionVar {
        int startOffset;
        int endOffset;
        String varName;

        public SubstitutionVar(int startOffset, int endOffset, String uriTemplate) {
            this.endOffset = endOffset;
            this.startOffset = startOffset;
            this.varName = uriTemplate.substring(startOffset, endOffset);
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getVarName() {
            return this.varName;
        }
    }
}

