/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.services.validation;

import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.validation.AbstractFunctionValidator;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Class;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.eglx.services.messages.ResourceKeys;

public abstract class ServiceProxyFunctionValidator
extends AbstractFunctionValidator {
    public boolean visit(NestedFunction nestedFunction) {
        if (nestedFunction.getName().resolveMember() instanceof Function) {
            this.validateContainerIsCorrect(((IRPartBinding)this.declaringPart).getIrPart(), nestedFunction);
            this.validateFunctionBodyIsEmpty((Function)nestedFunction.getName().resolveMember(), nestedFunction);
            this.validate(nestedFunction);
        }
        return true;
    }

    private void validateFunctionBodyIsEmpty(Function function, NestedFunction nestedFunction) {
        if (nestedFunction != null && nestedFunction.getStmts() != null) {
            for (Statement stmt : nestedFunction.getStmts()) {
                this.problemRequestor.acceptProblem((Node)stmt, 5704, 2, new String[]{function.getCaseSensitiveName()});
            }
        }
    }

    private void validateContainerIsCorrect(Part part, NestedFunction errorNode) {
        if (part != null) {
            if (part instanceof Program) {
                return;
            }
            if (part instanceof Library) {
                return;
            }
            if (part instanceof Service) {
                return;
            }
            if (part instanceof Class) {
                return;
            }
            if (part instanceof Handler) {
                return;
            }
        }
        Annotation annotation = this.getAnnotation((Function)errorNode.getName().resolveMember());
        this.problemRequestor.acceptProblem((Node)errorNode, 3400, 2, new String[]{annotation == null ? "" : annotation.getEClass().getETypeSignature(), errorNode.getName().getCaseSensitiveIdentifier()}, ResourceKeys.getResourceBundleForKeys());
    }

    protected abstract void validate(NestedFunction var1);

    protected abstract String getName();

    protected abstract Annotation getAnnotation(Function var1);
}

