/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbTransientClass;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTransientClass
extends AbstractJavaType
implements JaxbTransientClass {
    protected JaxbClass superClass = this.buildSuperClass();
    protected XmlAccessType specifiedAccessType = this.getResourceAccessType();
    protected XmlAccessOrder specifiedAccessOrder = this.getResourceAccessOrder();

    public GenericJavaTransientClass(JaxbContextRoot parent, JavaResourceType resourceType) {
        super(parent, resourceType);
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return (JavaResourceType)super.getJavaResourceType();
    }

    @Override
    public JaxbContextRoot getParent() {
        return (JaxbContextRoot)super.getParent();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedAccessType_(this.getResourceAccessType());
        this.setSpecifiedAccessOrder_(this.getResourceAccessOrder());
    }

    @Override
    public void update() {
        super.update();
        this.setSuperClass(this.buildSuperClass());
    }

    protected XmlTransientAnnotation getXmlTransientAnnotation() {
        return (XmlTransientAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlTransient");
    }

    @Override
    public JaxbType.Kind getKind() {
        return JaxbType.Kind.TRANSIENT;
    }

    @Override
    public JaxbClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(JaxbClass superClass) {
        JaxbClass old = this.superClass;
        this.superClass = superClass;
        this.firePropertyChanged("superClass", old, superClass);
    }

    protected JaxbClass buildSuperClass() {
        HashSet<JavaResourceType> visited = new HashSet<JavaResourceType>();
        visited.add(this.getJavaResourceType());
        JaxbClass spc = this.getSuperClass(this.getJavaResourceType().getSuperclassQualifiedName(), visited);
        if (spc == null) {
            return null;
        }
        if (CollectionTools.contains(spc.getInheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return spc;
    }

    protected JaxbClass getSuperClass(String typeName, Collection<JavaResourceType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourceType resourceType = (JavaResourceType)this.getJaxbProject().getJavaResourceType(typeName, JavaResourceAbstractType.Kind.TYPE);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        JaxbClass spc = this.getClass(typeName);
        return spc != null && resourceType.isMapped() ? spc : this.getSuperClass(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected JaxbClass getClass(String fullyQualifiedTypeName) {
        return this.getParent().getClass(fullyQualifiedTypeName);
    }

    @Override
    public Iterable<JaxbClass> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterable<JaxbClass> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superClass);
    }

    protected Iterable<JaxbClass> getInheritanceHierarchyOf(JaxbClass start) {
        return new ChainIterable<JaxbClass>(start){

            protected JaxbClass nextLink(JaxbClass jaxbClass) {
                return jaxbClass.getSuperClass();
            }
        };
    }

    @Override
    public XmlAccessType getAccessType() {
        return this.specifiedAccessType != null ? this.specifiedAccessType : this.getDefaultAccessType();
    }

    @Override
    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    @Override
    public void setSpecifiedAccessType(XmlAccessType access) {
        this.getAccessorTypeAnnotation().setValue(XmlAccessType.toJavaResourceModel(access));
        this.setSpecifiedAccessType_(access);
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", (Object)old, (Object)access);
    }

    @Override
    public XmlAccessType getDefaultAccessType() {
        return null;
    }

    protected XmlAccessType getResourceAccessType() {
        return XmlAccessType.fromJavaResourceModel(this.getAccessorTypeAnnotation().getValue());
    }

    protected XmlAccessorTypeAnnotation getAccessorTypeAnnotation() {
        return (XmlAccessorTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorType");
    }

    @Override
    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.getDefaultAccessOrder();
    }

    @Override
    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    @Override
    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getAccessorOrderAnnotation().setValue(XmlAccessOrder.toJavaResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", (Object)old, (Object)accessOrder);
    }

    @Override
    public XmlAccessOrder getDefaultAccessOrder() {
        return null;
    }

    protected XmlAccessOrder getResourceAccessOrder() {
        return XmlAccessOrder.fromJavaResourceModel(this.getAccessorOrderAnnotation().getValue());
    }

    protected XmlAccessorOrderAnnotation getAccessorOrderAnnotation() {
        return (XmlAccessorOrderAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getXmlTransientAnnotation().getTextRange(astRoot);
    }
}

