/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.edt.ide.internal.testserver.ContributionConfiguration;
import org.eclipse.edt.ide.internal.testserver.DefaultServlet;
import org.eclipse.edt.ide.testserver.AbstractConfigurator;
import org.eclipse.edt.ide.testserver.LogLevel;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class TestServer {
    private boolean debug;
    private final Integer port;
    private final Integer idePort;
    private final String contextRoot;
    private final List<AbstractConfigurator> configurators;
    private Server jettyServer;
    private WebAppContext webApp;
    private boolean ready;
    private String tempDirectory;

    public static void main(String[] args) throws Exception {
        ArrayList<String> remainingArgs = new ArrayList<String>(args.length);
        String[] contributionClassNames = null;
        Integer port = null;
        Integer idePort = null;
        String contextRoot = null;
        String tempDir = null;
        boolean debug = false;
        int i = 0;
        while (i < args.length) {
            if ("-p".equals(args[i])) {
                if (i + 1 < args.length) {
                    try {
                        port = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TestServer.logWarning("Unable to parse port value \"" + args[i + 1] + "\"");
                    }
                } else {
                    TestServer.logWarning("Missing port value for argument \"" + args[i] + "\"");
                }
            } else if ("-i".equals(args[i])) {
                if (i + 1 < args.length) {
                    try {
                        idePort = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TestServer.logWarning("Unable to parse IDE port value \"" + args[i + 1] + "\"");
                    }
                } else {
                    TestServer.logWarning("Missing IDE port value for argument \"" + args[i] + "\"");
                }
            } else if ("-c".equals(args[i])) {
                if (i + 1 < args.length) {
                    contextRoot = args[i + 1].trim();
                    ++i;
                } else {
                    TestServer.logWarning("Missing context root value for argument \"" + args[i] + "\"");
                }
            } else if ("-d".equals(args[i])) {
                debug = true;
            } else if ("-contribs".equals(args[i])) {
                if (i + 1 < args.length) {
                    contributionClassNames = args[i + 1].split(";");
                    ++i;
                } else {
                    TestServer.logWarning("Missing value for argument \"" + args[i] + "\"");
                }
            } else if ("-td".equals(args[i])) {
                if (i + 1 < args.length) {
                    tempDir = args[i + 1];
                    ++i;
                } else {
                    TestServer.logWarning("Missing value for argument \"" + args[i] + "\"");
                }
            } else {
                remainingArgs.add(args[i]);
            }
            ++i;
        }
        ArrayList<AbstractConfigurator> configurators = new ArrayList<AbstractConfigurator>(contributionClassNames == null ? 0 : contributionClassNames.length);
        if (contributionClassNames != null && contributionClassNames.length > 0) {
            String[] stringArray = contributionClassNames;
            int n = contributionClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                void contrib = stringArray[n2];
                try {
                    Class<?> c = Class.forName((String)contrib);
                    Object o = c.newInstance();
                    if (o instanceof AbstractConfigurator) {
                        configurators.add((AbstractConfigurator)o);
                    } else {
                        TestServer.logWarning("Contribution class \"" + (String)contrib + "\" does not extend \"" + AbstractConfigurator.class.getCanonicalName() + "\". Some functionality may be missing.");
                    }
                }
                catch (Exception e) {
                    TestServer.logWarning("Could not load contribution class \"" + (String)contrib + "\". Some functionality may be missing. Error: " + e.getMessage());
                }
                ++n2;
            }
        }
        TestServer server = new TestServer(port, idePort, contextRoot, tempDir, configurators, debug);
        int size = remainingArgs.size();
        int i2 = 0;
        while (i2 < size) {
            boolean processed = false;
            for (AbstractConfigurator contrib : configurators) {
                int newIndex = contrib.processNextArgument(remainingArgs, i2);
                if (newIndex == i2) continue;
                processed = true;
                i2 = newIndex;
                break;
            }
            if (processed) continue;
            if (((String)remainingArgs.get(i2)).startsWith("-")) {
                TestServer.logWarning("Unrecognized argument \"" + (String)remainingArgs.get(i2) + "\"");
            } else {
                TestServer.logWarning("Skipping argument value \"" + (String)remainingArgs.get(i2) + "\"");
            }
            ++i2;
        }
        server.start();
    }

    public TestServer(Integer port, Integer idePort, String contextRoot, String tempDir, List<AbstractConfigurator> configurators, boolean debug) {
        block4: {
            this.port = port;
            this.idePort = idePort;
            this.configurators = configurators;
            this.tempDirectory = tempDir;
            Log.setLog((Logger)new org.eclipse.edt.ide.internal.testserver.Logger());
            this.setDebug(debug, true);
            if (contextRoot != null) {
                try {
                    contextRoot = String.valueOf('/') + URLEncoder.encode(contextRoot.charAt(0) == '/' ? contextRoot.substring(1) : contextRoot, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (contextRoot.charAt(0) == '/') break block4;
                    contextRoot = "/" + contextRoot;
                }
            }
        }
        this.contextRoot = contextRoot;
        for (AbstractConfigurator config : configurators) {
            config.setTestServer(this);
        }
    }

    private void start() throws Exception {
        if (this.contextRoot == null || this.contextRoot.length() == 0) {
            throw new Exception("Context root argument not specified, cannot start the server");
        }
        if (this.port == null) {
            throw new Exception("Port argument not specified, cannot start the server");
        }
        if (this.port < 0) {
            throw new Exception("Port argument \"" + this.port + "\" is invalid, cannot start the server");
        }
        if (this.idePort == null) {
            throw new Exception("IDE port argument not specified, cannot start the server");
        }
        if (this.idePort < 0) {
            throw new Exception("IDE port argument \"" + this.idePort + "\" is invalid, cannot start the server");
        }
        this.webApp = new WebAppContext(null, this.contextRoot);
        this.webApp.setDefaultsDescriptor(null);
        this.webApp.setThrowUnavailableOnStartupException(true);
        this.webApp.setErrorHandler(new ErrorHandler(){

            public void handle(String arg0, Request arg1, HttpServletRequest arg2, HttpServletResponse arg3) throws IOException {
            }
        });
        if (this.tempDirectory != null && this.tempDirectory.length() > 0) {
            File temp = new File(this.tempDirectory);
            if (!temp.exists()) {
                temp.mkdirs();
            }
            this.webApp.setTempDirectory(temp);
        }
        this.jettyServer = new Server(this.port.intValue());
        this.jettyServer.setHandler((Handler)this.webApp);
        if (this.webApp.getResourceBase() == null) {
            this.webApp.setResourceBase(new File(".").getAbsolutePath());
        }
        this.webApp.addServlet(new ServletHolder((Servlet)new DefaultServlet(this)), "/default");
        ContributionConfiguration contributionConfig = new ContributionConfiguration();
        contributionConfig.setContributions(this.configurators);
        this.appendConfiguration((Configuration)contributionConfig);
        for (AbstractConfigurator config : this.configurators) {
            config.preStartup();
        }
        this.jettyServer.start();
        for (AbstractConfigurator config : this.configurators) {
            config.postStartup();
        }
        this.ready = true;
        this.jettyServer.join();
    }

    public void appendConfiguration(Configuration config) throws Exception {
        if (config == null) {
            this.log("Attempted to add a null configuration.", LogLevel.WARN);
            return;
        }
        if (this.webApp == null) {
            this.log("Attempted to add configuration class " + config.getClass().getCanonicalName() + " before the webapp was created.", LogLevel.WARN);
            return;
        }
        Configuration[] configs = this.webApp.getConfigurations();
        if (configs == null) {
            String[] configNames = this.webApp.getConfigurationClasses();
            if (configNames != null) {
                configs = new Configuration[configNames.length];
                int i = 0;
                while (i < configNames.length) {
                    configs[i] = (Configuration)Loader.loadClass(this.getClass(), (String)configNames[i]).newInstance();
                    ++i;
                }
            } else {
                configs = new Configuration[]{};
            }
            this.webApp.setConfigurations(configs);
        }
        Class<?> configClass = config.getClass();
        Configuration[] configurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration next = configurationArray[n2];
            if (configClass.equals(next.getClass())) {
                this.log("Configuration class " + configClass.getCanonicalName() + " was already added to the webapp - skipping.", LogLevel.WARN);
                return;
            }
            ++n2;
        }
        Configuration[] newConfigs = new Configuration[configs.length + 1];
        System.arraycopy(configs, 0, newConfigs, 0, configs.length);
        newConfigs[configs.length] = config;
        this.webApp.setConfigurations(newConfigs);
        this.log("Configuration " + configClass.getCanonicalName() + " successfully added to the webapp.", LogLevel.INFO);
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getIDEPort() {
        return this.idePort;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public Server getJettyServer() {
        return this.jettyServer;
    }

    public WebAppContext getWebApp() {
        return this.webApp;
    }

    public void setDebug(boolean debug, boolean quiet) {
        this.debug = debug;
        Log.getRootLogger().setDebugEnabled(debug);
        if (!quiet) {
            System.out.println("Tracing messages " + (debug ? "enabled" : "disabled"));
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void log(String msg, LogLevel level) {
        if (this.debug) {
            switch (level) {
                case INFO: {
                    System.out.println("INFO: " + msg);
                    break;
                }
                case WARN: {
                    System.err.println("WARN: " + msg);
                    break;
                }
                case ERROR: {
                    System.err.println("ERROR: " + msg);
                    break;
                }
                default: {
                    System.err.println(msg);
                }
            }
        }
    }

    public void log(Exception e) {
        e.printStackTrace();
    }

    public static void logWarning(String msg) {
        System.err.println("WARN: " + msg);
    }

    public static void logInfo(String msg) {
        System.out.println("INFO: " + msg);
    }
}

