/*******************************************************************************
 * Copyright © 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/action2d/Magnify":function(){define("dojox/charting/action2d/Magnify",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_119,_11a,m,gf,df,dfe){var _11b=2;return _119("dojox.charting.action2d.Magnify",_11a,{defaultParams:{duration:400,easing:dfe.backOut,scale:_11b},optionalParams:{},constructor:function(_11c,plot,_11d){this.scale=_11d&&typeof _11d.scale=="number"?_11d.scale:_11b;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _11e=o.run.name,_11f=o.index,_120=[],anim,init,_121;if(_11e in this.anim){anim=this.anim[_11e][_11f];}else{this.anim[_11e]={};}if(anim){anim.action.stop(true);}else{this.anim[_11e][_11f]=anim={};}if(o.type=="onmouseover"){init=m.identity;_121=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_121=1/this.scale;}var _122={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_121,o.cx,o.cy]},init]};if(o.shape){_120.push(gf.animateTransform(_122));}if(o.oultine){_122.shape=o.outline;_120.push(gf.animateTransform(_122));}if(o.shadow){_122.shape=o.shadow;_120.push(gf.animateTransform(_122));}if(!_120.length){delete this.anim[_11e][_11f];return;}anim.action=df.combine(_120);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_11e]){delete this.anim[_11e][_11f];}});}anim.action.play();}});});},"url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"onclick:_onTitleClick, onkeypress:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"arrowNode\" class=\"dijitArrowNode\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","dojo/date":function(){define("dojo/date",["./_base/kernel","./_base/lang"],function(dojo,lang){lang.getObject("date",true,dojo);dojo.date.getDaysInMonth=function(_123){var _124=_123.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_124==1&&dojo.date.isLeapYear(_123)){return 29;}return days[_124];};dojo.date.isLeapYear=function(_125){var year=_125.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};dojo.date.getTimezoneName=function(_126){var str=_126.toString();var tz="";var _127;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_127=str.match(pat))){tz=_127[1];}else{str=_126.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_127=str.match(pat))){tz=_127[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};dojo.date.compare=function(_128,_129,_12a){_128=new Date(+_128);_129=new Date(+(_129||new Date()));if(_12a=="date"){_128.setHours(0,0,0,0);_129.setHours(0,0,0,0);}else{if(_12a=="time"){_128.setFullYear(0,0,0);_129.setFullYear(0,0,0);}}if(_128>_129){return 1;}if(_128<_129){return -1;}return 0;};dojo.date.add=function(date,_12b,_12c){var sum=new Date(+date);var _12d=false;var _12e="Date";switch(_12b){case "day":break;case "weekday":var days,_12f;var mod=_12c%5;if(!mod){days=(_12c>0)?5:-5;_12f=(_12c>0)?((_12c-5)/5):((_12c+5)/5);}else{days=mod;_12f=parseInt(_12c/5);}var strt=date.getDay();var adj=0;if(strt==6&&_12c>0){adj=1;}else{if(strt==0&&_12c<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_12c>0)?2:-2;}_12c=(7*_12f)+days+adj;break;case "year":_12e="FullYear";_12d=true;break;case "week":_12c*=7;break;case "quarter":_12c*=3;case "month":_12d=true;_12e="Month";break;default:_12e="UTC"+_12b.charAt(0).toUpperCase()+_12b.substring(1)+"s";}if(_12e){sum["set"+_12e](sum["get"+_12e]()+_12c);}if(_12d&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};dojo.date.difference=function(_130,_131,_132){_131=_131||new Date();_132=_132||"day";var _133=_131.getFullYear()-_130.getFullYear();var _134=1;switch(_132){case "quarter":var m1=_130.getMonth();var m2=_131.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_133*4);_134=q2-q1;break;case "weekday":var days=Math.round(dojo.date.difference(_130,_131,"day"));var _135=parseInt(dojo.date.difference(_130,_131,"week"));var mod=days%7;if(mod==0){days=_135*5;}else{var adj=0;var aDay=_130.getDay();var bDay=_131.getDay();_135=parseInt(days/7);mod=days%7;var _136=new Date(_130);_136.setDate(_136.getDate()+(_135*7));var _137=_136.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_137+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_137+mod)<0:adj=2;}}}days+=adj;days-=(_135*2);}_134=days;break;case "year":_134=_133;break;case "month":_134=(_131.getMonth()-_130.getMonth())+(_133*12);break;case "week":_134=parseInt(dojo.date.difference(_130,_131,"day")/7);break;case "day":_134/=24;case "hour":_134/=60;case "minute":_134/=60;case "second":_134/=1000;case "millisecond":_134*=_131.getTime()-_130.getTime();}return Math.round(_134);};return dojo.date;});},"dojo/_base/array":function(){define("dojo/_base/array",["./kernel","../has","./lang"],function(dojo,has,lang){var _138={},u,_139;function _13a(){_138={};};function _13b(fn){return _138[fn]=new Function("item","index","array",fn);};function _13c(some){var _13d=!some;return function(a,fn,o){var i=0,l=a&&a.length||0,_13e;if(l&&typeof a=="string"){a=a.split("");}if(typeof fn=="string"){fn=_138[fn]||_13b(fn);}if(o){for(;i<l;++i){_13e=!fn.call(o,a[i],i,a);if(some^_13e){return !_13e;}}}else{for(;i<l;++i){_13e=!fn(a[i],i,a);if(some^_13e){return !_13e;}}}return _13d;};};function _13f(up){var _140=1,_141=0,_142=0;if(!up){_140=_141=_142=-1;}return function(a,x,from,last){if(last&&_140>0){return _139.lastIndexOf(a,x,from);}var l=a&&a.length||0,end=up?l+_142:_141,i;if(from===u){i=up?_141:l+_142;}else{if(from<0){i=l+from;if(i<0){i=_141;}}else{i=from>=l?l+_142:from;}}if(l&&typeof a=="string"){a=a.split("");}for(;i!=end;i+=_140){if(a[i]==x){return i;}}return -1;};};function _143(a,fn,o){var i=0,l=a&&a.length||0;if(l&&typeof a=="string"){a=a.split("");}if(typeof fn=="string"){fn=_138[fn]||_13b(fn);}if(o){for(;i<l;++i){fn.call(o,a[i],i,a);}}else{for(;i<l;++i){fn(a[i],i,a);}}};function map(a,fn,o,Ctr){var i=0,l=a&&a.length||0,out=new (Ctr||Array)(l);if(l&&typeof a=="string"){a=a.split("");}if(typeof fn=="string"){fn=_138[fn]||_13b(fn);}if(o){for(;i<l;++i){out[i]=fn.call(o,a[i],i,a);}}else{for(;i<l;++i){out[i]=fn(a[i],i,a);}}return out;};function _144(a,fn,o){var i=0,l=a&&a.length||0,out=[],_145;if(l&&typeof a=="string"){a=a.split("");}if(typeof fn=="string"){fn=_138[fn]||_13b(fn);}if(o){for(;i<l;++i){_145=a[i];if(fn.call(o,_145,i,a)){out.push(_145);}}}else{for(;i<l;++i){_145=a[i];if(fn(_145,i,a)){out.push(_145);}}}return out;};_139={every:_13c(false),some:_13c(true),indexOf:_13f(true),lastIndexOf:_13f(false),forEach:_143,map:map,filter:_144,clearCache:_13a};1&&lang.mixin(dojo,_139);return _139;});},"dojo/currency":function(){define("dojo/currency",["./_base/kernel","./_base/lang","./_base/array","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(dojo,lang,_146,_147,i18n,_148,_149){lang.getObject("currency",true,dojo);dojo.currency._mixInDefaults=function(_14a){_14a=_14a||{};_14a.type="currency";var _14b=i18n.getLocalization("dojo.cldr","currency",_14a.locale)||{};var iso=_14a.currency;var data=_149.getData(iso);_146.forEach(["displayName","symbol","group","decimal"],function(prop){data[prop]=_14b[iso+"_"+prop];});data.fractional=[true,false];return lang.mixin(data,_14a);};dojo.currency.format=function(_14c,_14d){return _147.format(_14c,dojo.currency._mixInDefaults(_14d));};dojo.currency.regexp=function(_14e){return _147.regexp(dojo.currency._mixInDefaults(_14e));};dojo.currency.parse=function(_14f,_150){return _147.parse(_14f,dojo.currency._mixInDefaults(_150));};return dojo.currency;});},"dojox/charting/plot2d/ClusteredColumns":function(){define("dojox/charting/plot2d/ClusteredColumns",["dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(arr,_151,_152,dc,df,dfr,du){var _153=dfr.lambda("item.purgeGroup()");return _151("dojox.charting.plot2d.ClusteredColumns",_152,{render:function(dim,_154){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_154);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_153);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_155,_156,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_157=Math.max(0,this._vScaler.bounds.lower),_158=vt(_157),_159=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_155=_156=f.size;for(var i=0;i<this.series.length;++i){var run=this.series[i],_15a=_156*i;if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _15b=t.next("column",[this.opt,run]),s=run.group,_15c=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _15d=run.data[j];if(_15d!==null){var v=typeof _15d=="number"?_15d:_15d.y,vv=vt(v),_15e=vv-_158,h=Math.abs(_15e),_15f=typeof _15d!="number"?t.addMixin(_15b,"column",_15d,true):t.post(_15b,"column");if(_155>=1&&h>=0){var rect={x:_154.l+ht(j+0.5)+gap+_15a,y:dim.height-_154.b-(v>_157?vv:_158),width:_155,height:h};var _160=this._plotFill(_15f.series.fill,dim,_154);_160=this._shapeFill(_160,rect);var _161=s.createRect(rect).setFill(_160).setStroke(_15f.series.stroke);run.dyn.fill=_161.getFill();run.dyn.stroke=_161.getStroke();if(_159){var o={element:"column",index:j,run:run,shape:_161,x:j+0.5,y:v};this._connectEvents(o);_15c[j]=o;}if(this.animate){this._animateColumn(_161,dim.height-_154.b-_158,h);}}}}this._eventSeries[run.name]=_15c;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/lang/functional/scan":function(){define("dojox/lang/functional/scan",["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(d,_162,df){var _163={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _163)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_164=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _163)){if(_164){t=[z=a[i]];_164=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/grid/DataGrid":function(){define("dojox/grid/DataGrid",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html"],function(_165,_166,lang,json,has,_167,_168,_169,html){var _16a=_167("dojox.grid.DataGrid",_168,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){this._pages=[];this._store_connects=[];this._by_idty={};this._by_idx=[];this._cache=[];this._pending_requests={};this._setStore(this.store);this.inherited(arguments);},destroy:function(){this.selection.destroy();this.inherited(arguments);},createSelection:function(){this.selection=new _169(this);},get:function(_16b,_16c){if(_16c&&this.field=="_item"&&!this.fields){return _16c;}else{if(_16c&&this.fields){var ret=[];var s=this.grid.store;_166.forEach(this.fields,function(f){ret=ret.concat(s.getValues(_16c,f));});return ret;}else{if(!_16c&&typeof _16b==="string"){return this.inherited(arguments);}}}return (!_16c?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_16c:this.grid.store.getValue(_16c,this.field))));},_checkUpdateStatus:function(){if(this.updateDelay>0){var _16d=false;if(this._endUpdateDelay){clearTimeout(this._endUpdateDelay);delete this._endUpdateDelay;_16d=true;}if(!this.updating){this.beginUpdate();_16d=true;}if(_16d){var _16e=this;this._endUpdateDelay=setTimeout(function(){delete _16e._endUpdateDelay;_16e.endUpdate();},this.updateDelay);}}},_onSet:function(item,_16f,_170,_171){this._checkUpdateStatus();var idx=this.getItemIndex(item);if(idx>-1){this.updateRow(idx);}},_createItem:function(item,_172){var idty=this._hasIdentity?this.store.getIdentity(item):json.toJson(this.query)+":idx:"+_172+":sort:"+json.toJson(this.getSortProps());var o=this._by_idty[idty]={idty:idty,item:item};return o;},_addItem:function(item,_173,_174){this._by_idx[_173]=this._createItem(item,_173);if(!_174){this.updateRow(_173);}},_onNew:function(item,_175){this._checkUpdateStatus();var _176=this.get("rowCount");this._addingItem=true;this.updateRowCount(_176+1);this._addingItem=false;this._addItem(item,_176);this.showMessage();},_onDelete:function(item){this._checkUpdateStatus();var idx=this._getItemIndex(item,true);if(idx>=0){this._pages=[];this._bop=-1;this._eop=-1;var o=this._by_idx[idx];this._by_idx.splice(idx,1);delete this._by_idty[o.idty];this.updateRowCount(this.get("rowCount")-1);if(this.get("rowCount")===0){this.showMessage(this.noDataMessage);}}if(this.selection.isSelected(idx)){this.selection.deselect(idx);this.selection.selected.splice(idx,1);}},_onRevert:function(){this._refresh();},setStore:function(_177,_178,_179){if(this._requestsPending(0)){return;}this._setQuery(_178,_179);this._setStore(_177);this._refresh(true);},setQuery:function(_17a,_17b){if(this._requestsPending(0)){return;}this._setQuery(_17a,_17b);this._refresh(true);},setItems:function(_17c){this.items=_17c;this._setStore(this.store);this._refresh(true);},_setQuery:function(_17d,_17e){this.query=_17d;this.queryOptions=_17e||this.queryOptions;},_setStore:function(_17f){if(this.store&&this._store_connects){_166.forEach(this._store_connects,this.disconnect,this);}this.store=_17f;if(this.store){var f=this.store.getFeatures();var h=[];this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];this._hasIdentity=!!f["dojo.data.api.Identity"];if(!!f["dojo.data.api.Notification"]&&!this.items){h.push(this.connect(this.store,"onSet","_onSet"));h.push(this.connect(this.store,"onNew","_onNew"));h.push(this.connect(this.store,"onDelete","_onDelete"));}if(this._canEdit){h.push(this.connect(this.store,"revert","_onRevert"));}this._store_connects=h;}},_onFetchBegin:function(size,req){if(!this.scroller){return;}if(this.rowCount!=size){if(req.isRender){this.scroller.init(size,this.keepRows,this.rowsPerPage);this.rowCount=size;this._setAutoHeightAttr(this.autoHeight,true);this._skipRowRenormalize=true;this.prerender();this._skipRowRenormalize=false;}else{this.updateRowCount(size);}}if(!size){this.views.render();this._resize();this.showMessage(this.noDataMessage);this.focus.initFocusView();}else{this.showMessage();}},_onFetchComplete:function(_180,req){if(!this.scroller){return;}if(_180&&_180.length>0){_166.forEach(_180,function(item,idx){this._addItem(item,req.start+idx,true);},this);this.updateRows(req.start,_180.length);if(req.isRender){this.setScrollTop(0);this.postrender();}else{if(this._lastScrollTop){this.setScrollTop(this._lastScrollTop);}}if(has("ie")){html.setSelectable(this.domNode,this.selectable);}}delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;}this._pending_requests[req.start]=false;},_onFetchError:function(err,req){delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;this.showMessage(this.errorMessage);}this._pending_requests[req.start]=false;this.onFetchError(err,req);},onFetchError:function(err,req){},_fetch:function(_181,_182){_181=_181||0;if(this.store&&!this._pending_requests[_181]){if(!this._isLoaded&&!this._isLoading){this._isLoading=true;this.showMessage(this.loadingMessage);}this._pending_requests[_181]=true;try{if(this.items){var _183=this.items;var _184=this.store;this.rowsPerPage=_183.length;var req={start:_181,count:this.rowsPerPage,isRender:_182};this._onFetchBegin(_183.length,req);var _185=0;_166.forEach(_183,function(i){if(!_184.isItemLoaded(i)){_185++;}});if(_185===0){this._onFetchComplete(_183,req);}else{var _186=function(item){_185--;if(_185===0){this._onFetchComplete(_183,req);}};_166.forEach(_183,function(i){if(!_184.isItemLoaded(i)){_184.loadItem({item:i,onItem:_186,scope:this});}},this);}}else{this.store.fetch({start:_181,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_182,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")});}}catch(e){this._onFetchError(e,{start:_181,count:this.rowsPerPage});}}},_clearData:function(){this.updateRowCount(0);this._by_idty={};this._by_idx=[];this._pages=[];this._bop=this._eop=-1;this._isLoaded=false;this._isLoading=false;},getItem:function(idx){var data=this._by_idx[idx];if(!data||(data&&!data.item)){this._preparePage(idx);return null;}return data.item;},getItemIndex:function(item){return this._getItemIndex(item,false);},_getItemIndex:function(item,_187){if(!_187&&!this.store.isItem(item)){return -1;}var idty=this._hasIdentity?this.store.getIdentity(item):null;for(var i=0,l=this._by_idx.length;i<l;i++){var d=this._by_idx[i];if(d&&((idty&&d.idty==idty)||(d.item===item))){return i;}}return -1;},filter:function(_188,_189){this.query=_188;if(_189){this._clearData();}this._fetch();},_getItemAttr:function(idx,attr){var item=this.getItem(idx);return (!item?this.fetchText:this.store.getValue(item,attr));},_render:function(){if(this.domNode.parentNode){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this._fetch(0,true);}},_requestsPending:function(_18a){return this._pending_requests[_18a];},_rowToPage:function(_18b){return (this.rowsPerPage?Math.floor(_18b/this.rowsPerPage):_18b);},_pageToRow:function(_18c){return (this.rowsPerPage?this.rowsPerPage*_18c:_18c);},_preparePage:function(_18d){if((_18d<this._bop||_18d>=this._eop)&&!this._addingItem){var _18e=this._rowToPage(_18d);this._needPage(_18e);this._bop=_18e*this.rowsPerPage;this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));}},_needPage:function(_18f){if(!this._pages[_18f]){this._pages[_18f]=true;this._requestPage(_18f);}},_requestPage:function(_190){var row=this._pageToRow(_190);var _191=Math.min(this.rowsPerPage,this.get("rowCount")-row);if(_191>0){this._requests++;if(!this._requestsPending(row)){setTimeout(lang.hitch(this,"_fetch",row,false),1);}}},getCellName:function(_192){return _192.field;},_refresh:function(_193){this._clearData();this._fetch(0,_193);},sort:function(){this.edit.apply();this._lastScrollTop=this.scrollTop;this._refresh();},canSort:function(){return (!this._isLoading);},getSortProps:function(){var c=this.getCell(this.getSortIndex());if(!c){if(this.sortFields){return this.sortFields;}return null;}else{var desc=c["sortDesc"];var si=!(this.sortInfo>0);if(typeof desc=="undefined"){desc=si;}else{desc=si?!desc:desc;}return [{attribute:c.field,descending:desc}];}},styleRowState:function(_194){if(this.store&&this.store.getState){var _195=this.store.getState(_194.index),c="";for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){if(_195[s]){c=" dojoxGridRow-"+s;break;}}_194.customClasses+=c;}},onStyleRow:function(_196){this.styleRowState(_196);this.inherited(arguments);},canEdit:function(_197,_198){return this._canEdit;},_copyAttr:function(idx,attr){var row={};var _199={};var src=this.getItem(idx);return this.store.getValue(src,attr);},doStartEdit:function(_19a,_19b){if(!this._cache[_19b]){this._cache[_19b]=this._copyAttr(_19b,_19a.field);}this.onStartEdit(_19a,_19b);},doApplyCellEdit:function(_19c,_19d,_19e){this.store.fetchItemByIdentity({identity:this._by_idx[_19d].idty,onItem:lang.hitch(this,function(item){var _19f=this.store.getValue(item,_19e);if(typeof _19f=="number"){_19c=isNaN(_19c)?_19c:parseFloat(_19c);}else{if(typeof _19f=="boolean"){_19c=_19c=="true"?true:_19c=="false"?false:_19c;}else{if(_19f instanceof Date){var _1a0=new Date(_19c);_19c=isNaN(_1a0.getTime())?_19c:_1a0;}}}this.store.setValue(item,_19e,_19c);this.onApplyCellEdit(_19c,_19d,_19e);})});},doCancelEdit:function(_1a1){var _1a2=this._cache[_1a1];if(_1a2){this.updateRow(_1a1);delete this._cache[_1a1];}this.onCancelEdit.apply(this,arguments);},doApplyEdit:function(_1a3,_1a4){var _1a5=this._cache[_1a3];this.onApplyEdit(_1a3);},removeSelectedRows:function(){if(this._canEdit){this.edit.apply();var fx=lang.hitch(this,function(_1a6){if(_1a6.length){_166.forEach(_1a6,this.store.deleteItem,this.store);this.selection.clear();}});if(this.allItemsSelected){this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});}else{fx(this.selection.getSelected());}}}});_16a.cell_markupFactory=function(_1a7,node,_1a8){var _1a9=lang.trim(html.attr(node,"field")||"");if(_1a9){_1a8.field=_1a9;}_1a8.field=_1a8.field||_1a8.name;var _1aa=lang.trim(html.attr(node,"fields")||"");if(_1aa){_1a8.fields=_1aa.split(",");}if(_1a7){_1a7(node,_1a8);}};_16a.markupFactory=function(_1ab,node,ctor,_1ac){return _168.markupFactory(_1ab,node,ctor,lang.partial(_16a.cell_markupFactory,_1ac));};return _16a;});},"dojo/dom-form":function(){define("dojo/dom-form",["./_base/lang","./dom","./io-query","./json"],function(lang,dom,ioq,json){function _1ad(obj,name,_1ae){if(_1ae===null){return;}var val=obj[name];if(typeof val=="string"){obj[name]=[val,_1ae];}else{if(lang.isArray(val)){val.push(_1ae);}else{obj[name]=_1ae;}}};var _1af="file|submit|image|reset|button";var form={fieldToObject:function fieldToObject(_1b0){var ret=null;_1b0=dom.byId(_1b0);if(_1b0){var _1b1=_1b0.name,type=(_1b0.type||"").toLowerCase();if(_1b1&&type&&!_1b0.disabled){if(type=="radio"||type=="checkbox"){if(_1b0.checked){ret=_1b0.value;}}else{if(_1b0.multiple){ret=[];var _1b2=[_1b0.firstChild];while(_1b2.length){for(var node=_1b2.pop();node;node=node.nextSibling){if(node.nodeType==1&&node.tagName.toLowerCase()=="option"){if(node.selected){ret.push(node.value);}}else{if(node.nextSibling){_1b2.push(node.nextSibling);}if(node.firstChild){_1b2.push(node.firstChild);}break;}}}}else{ret=_1b0.value;}}}}return ret;},toObject:function formToObject(_1b3){var ret={},_1b4=dom.byId(_1b3).elements;for(var i=0,l=_1b4.length;i<l;++i){var item=_1b4[i],_1b5=item.name,type=(item.type||"").toLowerCase();if(_1b5&&type&&_1af.indexOf(type)<0&&!item.disabled){_1ad(ret,_1b5,form.fieldToObject(item));if(type=="image"){ret[_1b5+".x"]=ret[_1b5+".y"]=ret[_1b5].x=ret[_1b5].y=0;}}}return ret;},toQuery:function formToQuery(_1b6){return ioq.objectToQuery(form.toObject(_1b6));},toJson:function formToJson(_1b7,_1b8){return json.stringify(form.toObject(_1b7),null,_1b8?4:0);}};return form;});},"dijit/_editor/range":function(){define("dijit/_editor/range",["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/window",".."],function(_1b9,_1ba,lang,win,_1bb){_1bb.range={};_1bb.range.getIndex=function(node,_1bc){var ret=[],retR=[];var _1bd=node;var _1be,n;while(node!=_1bc){var i=0;_1be=node.parentNode;while((n=_1be.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-_1be.childNodes.length);node=_1be;}if(ret.length>0&&_1bd.nodeType==3){n=_1bd.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=_1bd.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};};_1bb.range.getNode=function(_1bf,_1c0){if(!lang.isArray(_1bf)||_1bf.length==0){return _1c0;}var node=_1c0;_1b9.every(_1bf,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;};_1bb.range.getCommonAncestor=function(n1,n2,root){root=root||n1.ownerDocument.body;var _1c1=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_1c1(n1);var n2as=_1c1(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;};_1bb.range.getAncestor=function(node,_1c2,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(_1c2.test(name)){return node;}node=node.parentNode;}return null;};_1bb.range.BlockTagNames=/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/;_1bb.range.getBlockAncestor=function(node,_1c3,root){root=root||node.ownerDocument.body;_1c3=_1c3||_1bb.range.BlockTagNames;var _1c4=null,_1c5;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!_1c4&&_1c3.test(name)){_1c4=node;}if(!_1c5&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_1c5=node;}node=node.parentNode;}return {blockNode:_1c4,blockContainer:_1c5||node.ownerDocument.body};};_1bb.range.atBeginningOfContainer=function(_1c6,node,_1c7){var _1c8=false;var _1c9=(_1c7==0);if(!_1c9&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_1c7))){_1c9=true;}}if(_1c9){var _1ca=node;_1c8=true;while(_1ca&&_1ca!==_1c6){if(_1ca.previousSibling){_1c8=false;break;}_1ca=_1ca.parentNode;}}return _1c8;};_1bb.range.atEndOfContainer=function(_1cb,node,_1cc){var _1cd=false;var _1ce=(_1cc==(node.length||node.childNodes.length));if(!_1ce&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_1cc))){_1ce=true;}}if(_1ce){var _1cf=node;_1cd=true;while(_1cf&&_1cf!==_1cb){if(_1cf.nextSibling){_1cd=false;break;}_1cf=_1cf.parentNode;}}return _1cd;};_1bb.range.adjacentNoneTextNode=function(_1d0,next){var node=_1d0;var len=(0-_1d0.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];};_1bb.range._w3c=Boolean(window["getSelection"]);_1bb.range.create=function(_1d1){if(_1bb.range._w3c){return (_1d1||win.global).document.createRange();}else{return new _1bb.range.W3CRange;}};_1bb.range.getSelection=function(win,_1d2){if(_1bb.range._w3c){return win.getSelection();}else{var s=new _1bb.range.ie.selection(win);if(!_1d2){s._getCurrentSelection();}return s;}};if(!_1bb.range._w3c){_1bb.range.ie={cachedSelection:{},selection:function(win){this._ranges=[];this.addRange=function(r,_1d3){this._ranges.push(r);if(!_1d3){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _1d4=function(){var r=win.document.selection.createRange();var type=win.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _1bb.range.W3CRange(_1bb.range.ie.decomposeControlRange(r));}else{return new _1bb.range.W3CRange(_1bb.range.ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_1d4();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(_1d5){var _1d6=_1d5.item(0),_1d7=_1d5.item(_1d5.length-1);var _1d8=_1d6.parentNode,_1d9=_1d7.parentNode;var _1da=_1bb.range.getIndex(_1d6,_1d8).o[0];var _1db=_1bb.range.getIndex(_1d7,_1d9).o[0]+1;return [_1d8,_1da,_1d9,_1db];},getEndPoint:function(_1dc,end){var _1dd=_1dc.duplicate();_1dd.collapse(!end);var _1de="EndTo"+(end?"End":"Start");var _1df=_1dd.parentElement();var _1e0,_1e1,_1e2;if(_1df.childNodes.length>0){_1b9.every(_1df.childNodes,function(node,i){var _1e3;if(node.nodeType!=3){_1dd.moveToElementText(node);if(_1dd.compareEndPoints(_1de,_1dc)>0){if(_1e2&&_1e2.nodeType==3){_1e0=_1e2;_1e3=true;}else{_1e0=_1df;_1e1=i;return false;}}else{if(i==_1df.childNodes.length-1){_1e0=_1df;_1e1=_1df.childNodes.length;return false;}}}else{if(i==_1df.childNodes.length-1){_1e0=node;_1e3=true;}}if(_1e3&&_1e0){var _1e4=_1bb.range.adjacentNoneTextNode(_1e0)[0];if(_1e4){_1e0=_1e4.nextSibling;}else{_1e0=_1df.firstChild;}var _1e5=_1bb.range.adjacentNoneTextNode(_1e0);_1e4=_1e5[0];var _1e6=_1e5[1];if(_1e4){_1dd.moveToElementText(_1e4);_1dd.collapse(false);}else{_1dd.moveToElementText(_1df);}_1dd.setEndPoint(_1de,_1dc);_1e1=_1dd.text.length-_1e6;return false;}_1e2=node;return true;});}else{_1e0=_1df;_1e1=0;}if(!end&&_1e0.nodeType==1&&_1e1==_1e0.childNodes.length){var _1e7=_1e0.nextSibling;if(_1e7&&_1e7.nodeType==3){_1e0=_1e7;_1e1=0;}}return [_1e0,_1e1];},setEndPoint:function(_1e8,_1e9,_1ea){var _1eb=_1e8.duplicate(),node,len;if(_1e9.nodeType!=3){if(_1ea>0){node=_1e9.childNodes[_1ea-1];if(node){if(node.nodeType==3){_1e9=node;_1ea=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_1e9=node.nextSibling;_1ea=0;}else{_1eb.moveToElementText(node.nextSibling?node:_1e9);var _1ec=node.parentNode;var _1ed=_1ec.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_1eb.collapse(false);_1ec.removeChild(_1ed);}}}}else{_1eb.moveToElementText(_1e9);_1eb.collapse(true);}}if(_1e9.nodeType==3){var _1ee=_1bb.range.adjacentNoneTextNode(_1e9);var _1ef=_1ee[0];len=_1ee[1];if(_1ef){_1eb.moveToElementText(_1ef);_1eb.collapse(false);if(_1ef.contentEditable!="inherit"){len++;}}else{_1eb.moveToElementText(_1e9.parentNode);_1eb.collapse(true);}_1ea+=len;if(_1ea>0){if(_1eb.move("character",_1ea)!=_1ea){console.error("Error when moving!");}}}return _1eb;},decomposeTextRange:function(_1f0){var _1f1=_1bb.range.ie.getEndPoint(_1f0);var _1f2=_1f1[0],_1f3=_1f1[1];var _1f4=_1f1[0],_1f5=_1f1[1];if(_1f0.htmlText.length){if(_1f0.htmlText==_1f0.text){_1f5=_1f3+_1f0.text.length;}else{_1f1=_1bb.range.ie.getEndPoint(_1f0,true);_1f4=_1f1[0],_1f5=_1f1[1];}}return [_1f2,_1f3,_1f4,_1f5];},setRange:function(_1f6,_1f7,_1f8,_1f9,_1fa,_1fb){var _1fc=_1bb.range.ie.setEndPoint(_1f6,_1f7,_1f8);_1f6.setEndPoint("StartToStart",_1fc);if(!_1fb){var end=_1bb.range.ie.setEndPoint(_1f6,_1f9,_1fa);}_1f6.setEndPoint("EndToEnd",end||_1fc);return _1f6;}};_1ba("dijit.range.W3CRange",null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_1bb.range.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_1fd){_1fd=parseInt(_1fd);if(this.startContainer===node&&this.startOffset==_1fd){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_1fd;if(!this.endContainer){this.setEnd(node,_1fd);}else{this._updateInternal();}},setEnd:function(node,_1fe){_1fe=parseInt(_1fe);if(this.endContainer===node&&this.endOffset==_1fe){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_1fe;if(!this.startContainer){this.setStart(node,_1fe);}else{this._updateInternal();}},setStartAfter:function(node,_1ff){this._setPoint("setStart",node,_1ff,1);},setStartBefore:function(node,_200){this._setPoint("setStart",node,_200,0);},setEndAfter:function(node,_201){this._setPoint("setEnd",node,_201,1);},setEndBefore:function(node,_202){this._setPoint("setEnd",node,_202,0);},_setPoint:function(what,node,_203,ext){var _204=_1bb.range.getIndex(node,node.parentNode).o;this[what](node.parentNode,_204.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();_1bb.range.ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _1bb.range.W3CRange([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}return _1bb.range;});},"dijit/Dialog":function(){require({cache:{"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"></span>\n\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t</span>\n\t</div>\n\t\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n"}});define("dijit/Dialog",["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/fx","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/sniff","dojo/_base/window","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html",".","dojo/i18n!./nls/common"],function(_205,_206,_207,_208,_209,dom,_20a,_20b,_20c,_20d,fx,i18n,_20e,keys,lang,on,_20f,has,win,_210,_211,_212,_213,_214,_215,_216,_217,_218,_219,_21a,_21b,_21c,_21d){var _21e=_208("dijit._DialogBase",[_216,_218,_219,_217],{templateString:_21c,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],open:false,duration:_214.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,"aria-describedby":"",postMixInProperties:function(){var _21f=i18n.getLocalization("dijit","common");lang.mixin(this,_21f);this.inherited(arguments);},postCreate:function(){_20c.set(this.domNode,{display:"none",position:"absolute"});win.body().appendChild(this.domNode);this.inherited(arguments);this.connect(this,"onExecute","hide");this.connect(this,"onCancel","hide");this._modalconnects=[];},onLoad:function(){this._position();if(this.autofocus&&_220.isTop(this)){this._getFocusItems(this.domNode);_213.focus(this._firstFocusItem);}this.inherited(arguments);},_endDrag:function(){var _221=_20b.position(this.domNode),_222=_210.getBox();_221.y=Math.min(Math.max(_221.y,0),(_222.h-_221.h));_221.x=Math.min(Math.max(_221.x,0),(_222.w-_221.w));this._relativePosition=_221;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_212:_211)(node,{handle:this.titleBar});this.connect(this._moveable,"onMoveStop","_endDrag");}else{_20a.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_206.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" ")};},_size:function(){this._checkIfSingleChild();if(this._singleChild){if(this._singleChildOriginalStyle){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;}delete this._singleChildOriginalStyle;}else{_20c.set(this.containerNode,{width:"auto",height:"auto"});}var bb=_20b.position(this.domNode);var _223=_210.getBox();if(bb.w>=_223.w||bb.h>=_223.h){var w=Math.min(bb.w,Math.floor(_223.w*0.75)),h=Math.min(bb.h,Math.floor(_223.h*0.75));if(this._singleChild&&this._singleChild.resize){this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;this._singleChild.resize({w:w,h:h});}else{_20c.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});}}else{if(this._singleChild&&this._singleChild.resize){this._singleChild.resize();}}},_position:function(){if(!_20a.contains(win.body(),"dojoMove")){var node=this.domNode,_224=_210.getBox(),p=this._relativePosition,bb=p?null:_20b.position(node),l=Math.floor(_224.l+(p?p.x:(_224.w-bb.w)/2)),t=Math.floor(_224.t+(p?p.y:(_224.h-bb.h)/2));_20c.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.charOrCode){var node=evt.target;if(evt.charOrCode===keys.TAB){this._getFocusItems(this.domNode);}var _225=(this._firstFocusItem==this._lastFocusItem);if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){if(!_225){_213.focus(this._lastFocusItem);}_20d.stop(evt);}else{if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){if(!_225){_213.focus(this._firstFocusItem);}_20d.stop(evt);}else{while(node){if(node==this.domNode||_20a.contains(node,"dijitPopup")){if(evt.charOrCode==keys.ESCAPE){this.onCancel();}else{return;}}node=node.parentNode;}if(evt.charOrCode!==keys.TAB){_20d.stop(evt);}else{if(!has("opera")){try{this._firstFocusItem.focus();}catch(e){}}}}}}},show:function(){if(this.open){return;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}this._modalconnects.push(on(window,"scroll",lang.hitch(this,"layout")));this._modalconnects.push(on(window,"resize",lang.hitch(this,function(){var _226=_210.getBox();if(!this._oldViewport||_226.h!=this._oldViewport.h||_226.w!=this._oldViewport.w){this.layout();this._oldViewport=_226;}})));this._modalconnects.push(on(this.domNode,_207._keypress,lang.hitch(this,"_onKey")));_20c.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this._size();this._position();var _227;this._fadeInDeferred=new _209(lang.hitch(this,function(){_227.stop();delete this._fadeInDeferred;}));_227=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_220.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_220.isTop(this)){this._getFocusItems(this.domNode);_213.focus(this._firstFocusItem);}this._fadeInDeferred.callback(true);delete this._fadeInDeferred;})}).play();return this._fadeInDeferred;},hide:function(){if(!this._alreadyInitialized){return;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _228;this._fadeOutDeferred=new _209(lang.hitch(this,function(){_228.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(lang.hitch(this,"onHide"));_228=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_220.hide(this);this._fadeOutDeferred.callback(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return this._fadeOutDeferred;},layout:function(){if(this.domNode.style.display!="none"){if(_21d._underlay){_21d._underlay.layout();}this._position();}},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_220.hide(this);this.inherited(arguments);}});var _229=_208("dijit.Dialog",[_21b,_21e],{});_229._DialogBase=_21e;var _220=_229._DialogLevelManager={_beginZIndex:950,show:function(_22a,_22b){ds[ds.length-1].focus=_213.curNode;var _22c=_21d._underlay;if(!_22c||_22c._destroyed){_22c=_21d._underlay=new _21a(_22b);}else{_22c.set(_22a.underlayAttrs);}var _22d=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_229._DialogLevelManager._beginZIndex;if(ds.length==1){_22c.show();}_20c.set(_21d._underlay.domNode,"zIndex",_22d-1);_20c.set(_22a.domNode,"zIndex",_22d);ds.push({dialog:_22a,underlayAttrs:_22b,zIndex:_22d});},hide:function(_22e){if(ds[ds.length-1].dialog==_22e){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){if(!_21d._underlay._destroyed){_21d._underlay.hide();}}else{_20c.set(_21d._underlay.domNode,"zIndex",pd.zIndex-1);_21d._underlay.set(pd.underlayAttrs);}if(_22e.refocus){var _22f=pd.focus;if(pd.dialog&&(!_22f||!dom.isDescendant(_22f,pd.dialog.domNode))){pd.dialog._getFocusItems(pd.dialog.domNode);_22f=pd.dialog._firstFocusItem;}if(_22f){_22f.focus();}}}else{var idx=_206.indexOf(_206.map(ds,function(elem){return elem.dialog;}),_22e);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_230){return ds[ds.length-1].dialog==_230;}};var ds=_229._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];if(!_20e.isAsync){_20f(0,function(){var _231=["dijit/TooltipDialog"];_205(_231);});}return _229;});},"dojox/html/metrics":function(){define("dojox/html/metrics",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_232,lang,has,_233,_234,_235,_236){var dhm=lang.getObject("dojox.html.metrics",true);var _237=lang.getObject("dojox");dhm.getFontMeasurements=function(){var _238={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(has("ie")){_235.doc.documentElement.style.fontSize="100%";}var div=_235.doc.createElement("div");var ds=div.style;ds.position="absolute";ds.left="-100px";ds.top="0";ds.width="30px";ds.height="1000em";ds.borderWidth="0";ds.margin="0";ds.padding="0";ds.outline="0";ds.lineHeight="1";ds.overflow="hidden";_235.body().appendChild(div);for(var p in _238){ds.fontSize=p;_238[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}_235.body().removeChild(div);div=null;return _238;};var _239=null;dhm.getCachedFontMeasurements=function(_23a){if(_23a||!_239){_239=dhm.getFontMeasurements();}return _239;};var _23b=null,_23c={};dhm.getTextBox=function(text,_23d,_23e){var m,s;if(!_23b){m=_23b=_235.doc.createElement("div");var c=_235.doc.createElement("div");c.appendChild(m);s=c.style;s.overflow="scroll";s.position="absolute";s.left="0px";s.top="-10000px";s.width="1px";s.height="1px";s.visibility="hidden";s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";_235.body().appendChild(c);}else{m=_23b;}m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(arguments.length>1&&_23d){for(var i in _23d){if(i in _23c){continue;}s[i]=_23d[i];}}if(arguments.length>2&&_23e){m.className=_23e;}m.innerHTML=text;var box=_236.position(m);box.w=m.parentNode.scrollWidth;return box;};var _23f={w:16,h:16};dhm.getScrollbar=function(){return {w:_23f.w,h:_23f.h};};dhm._fontResizeNode=null;dhm.initOnFontResize=function(_240){var f=dhm._fontResizeNode=_235.doc.createElement("iframe");var fs=f.style;fs.position="absolute";fs.width="5em";fs.height="10em";fs.top="-10000px";if(has("ie")){f.onreadystatechange=function(){if(f.contentWindow.document.readyState=="complete"){f.onresize=f.contentWindow.parent[_237._scopeName].html.metrics._fontresize;}};}else{f.onload=function(){f.contentWindow.onresize=f.contentWindow.parent[_237._scopeName].html.metrics._fontresize;};}f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");_235.body().appendChild(f);dhm.initOnFontResize=function(){};};dhm.onFontResize=function(){};dhm._fontresize=function(){dhm.onFontResize();};_234.addOnUnload(function(){var f=dhm._fontResizeNode;if(f){if(has("ie")&&f.onresize){f.onresize=null;}else{if(f.contentWindow&&f.contentWindow.onresize){f.contentWindow.onresize=null;}}dhm._fontResizeNode=null;}});_233(function(){try{var n=_235.doc.createElement("div");n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";_235.body().appendChild(n);_23f.w=n.offsetWidth-n.clientWidth;_23f.h=n.offsetHeight-n.clientHeight;_235.body().removeChild(n);delete n;}catch(e){}if("fontSizeWatch" in _232.config&&!!_232.config.fontSizeWatch){dhm.initOnFontResize();}});return dhm;});},"dojo/dom-construct":function(){define("dojo/dom-construct",["exports","./_base/kernel","./_base/sniff","./_base/window","./dom","./dom-attr","./on"],function(_241,dojo,has,win,dom,attr,on){var _242={option:["select"],tbody:["table"],thead:["table"],tfoot:["table"],tr:["table","tbody"],td:["table","tbody","tr"],th:["table","thead","tr"],legend:["fieldset"],caption:["table"],colgroup:["table"],col:["table","colgroup"],li:["ul"]},_243=/<\s*([\w\:]+)/,_244={},_245=0,_246="__"+dojo._scopeName+"ToDomId";for(var _247 in _242){if(_242.hasOwnProperty(_247)){var tw=_242[_247];tw.pre=_247=="option"?"<select multiple=\"multiple\">":"<"+tw.join("><")+">";tw.post="</"+tw.reverse().join("></")+">";}}function _248(node,ref){var _249=ref.parentNode;if(_249){_249.insertBefore(node,ref);}};function _24a(node,ref){var _24b=ref.parentNode;if(_24b){if(_24b.lastChild==ref){_24b.appendChild(node);}else{_24b.insertBefore(node,ref.nextSibling);}}};var _24c=null,_24d;on(window,"unload",function(){_24c=null;});_241.toDom=function toDom(frag,doc){doc=doc||win.doc;var _24e=doc[_246];if(!_24e){doc[_246]=_24e=++_245+"";_244[_24e]=doc.createElement("div");}frag+="";var _24f=frag.match(_243),tag=_24f?_24f[1].toLowerCase():"",_250=_244[_24e],wrap,i,fc,df;if(_24f&&_242[tag]){wrap=_242[tag];_250.innerHTML=wrap.pre+frag+wrap.post;for(i=wrap.length;i;--i){_250=_250.firstChild;}}else{_250.innerHTML=frag;}if(_250.childNodes.length==1){return _250.removeChild(_250.firstChild);}df=doc.createDocumentFragment();while(fc=_250.firstChild){df.appendChild(fc);}return df;};_241.place=function place(node,_251,_252){_251=dom.byId(_251);if(typeof node=="string"){node=/^\s*</.test(node)?_241.toDom(node,_251.ownerDocument):dom.byId(node);}if(typeof _252=="number"){var cn=_251.childNodes;if(!cn.length||cn.length<=_252){_251.appendChild(node);}else{_248(node,cn[_252<0?0:_252]);}}else{switch(_252){case "before":_248(node,_251);break;case "after":_24a(node,_251);break;case "replace":_251.parentNode.replaceChild(node,_251);break;case "only":_241.empty(_251);_251.appendChild(node);break;case "first":if(_251.firstChild){_248(node,_251.firstChild);break;}default:_251.appendChild(node);}}return node;};_241.create=function create(tag,_253,_254,pos){var doc=win.doc;if(_254){_254=dom.byId(_254);doc=_254.ownerDocument;}if(typeof tag=="string"){tag=doc.createElement(tag);}if(_253){attr.set(tag,_253);}if(_254){_241.place(tag,_254,pos);}return tag;};_241.empty=has("ie")?function(node){node=dom.byId(node);for(var c;c=node.lastChild;){_241.destroy(c);}}:function(node){dom.byId(node).innerHTML="";};_241.destroy=function destroy(node){node=dom.byId(node);try{var doc=node.ownerDocument;if(!_24c||_24d!=doc){_24c=doc.createElement("div");_24d=doc;}_24c.appendChild(node.parentNode?node.parentNode.removeChild(node):node);_24c.innerHTML="";}catch(e){}};});},"dojo/date/locale":function(){define("dojo/date/locale",["../_base/kernel","../_base/lang","../_base/array","../date","../cldr/supplemental","../regexp","../string","../i18n!../cldr/nls/gregorian"],function(dojo,lang,_255,date,cldr,_256,_257,_258){lang.getObject("date.locale",true,dojo);function _259(_25a,_25b,_25c,_25d){return _25d.replace(/([a-z])\1*/ig,function(_25e){var s,pad,c=_25e.charAt(0),l=_25e.length,_25f=["abbr","wide","narrow"];switch(c){case "G":s=_25b[(l<4)?"eraAbbr":"eraNames"][_25a.getFullYear()<0?0:1];break;case "y":s=_25a.getFullYear();switch(l){case 1:break;case 2:if(!_25c.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_25a.getMonth()+1)/3);pad=true;break;case "M":var m=_25a.getMonth();if(l<3){s=m+1;pad=true;}else{var _260=["months","format",_25f[l-3]].join("-");s=_25b[_260][m];}break;case "w":var _261=0;s=dojo.date.locale._getWeekOfYear(_25a,_261);pad=true;break;case "d":s=_25a.getDate();pad=true;break;case "D":s=dojo.date.locale._getDayOfYear(_25a);pad=true;break;case "E":var d=_25a.getDay();if(l<3){s=d+1;pad=true;}else{var _262=["days","format",_25f[l-3]].join("-");s=_25b[_262][d];}break;case "a":var _263=(_25a.getHours()<12)?"am":"pm";s=_25c[_263]||_25b["dayPeriods-format-wide-"+_263];break;case "h":case "H":case "K":case "k":var h=_25a.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_25a.getMinutes();pad=true;break;case "s":s=_25a.getSeconds();pad=true;break;case "S":s=Math.round(_25a.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=dojo.date.locale._getZone(_25a,true,_25c);if(s){break;}l=4;case "Z":var _264=dojo.date.locale._getZone(_25a,false,_25c);var tz=[(_264<=0?"+":"-"),_257.pad(Math.floor(Math.abs(_264)/60),2),_257.pad(Math.abs(_264)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_25d);}if(pad){s=_257.pad(s,l);}return s;});};dojo.date.locale._getZone=function(_265,_266,_267){if(_266){return date.getTimezoneName(_265);}else{return _265.getTimezoneOffset();}};dojo.date.locale.format=function(_268,_269){_269=_269||{};var _26a=dojo.i18n.normalizeLocale(_269.locale),_26b=_269.formatLength||"short",_26c=dojo.date.locale._getGregorianBundle(_26a),str=[],_26d=lang.hitch(this,_259,_268,_26c,_269);if(_269.selector=="year"){return _26e(_26c["dateFormatItem-yyyy"]||"yyyy",_26d);}var _26f;if(_269.selector!="date"){_26f=_269.timePattern||_26c["timeFormat-"+_26b];if(_26f){str.push(_26e(_26f,_26d));}}if(_269.selector!="time"){_26f=_269.datePattern||_26c["dateFormat-"+_26b];if(_26f){str.push(_26e(_26f,_26d));}}return str.length==1?str[0]:_26c["dateTimeFormat-"+_26b].replace(/\{(\d+)\}/g,function(_270,key){return str[key];});};dojo.date.locale.regexp=function(_271){return dojo.date.locale._parseInfo(_271).regexp;};dojo.date.locale._parseInfo=function(_272){_272=_272||{};var _273=dojo.i18n.normalizeLocale(_272.locale),_274=dojo.date.locale._getGregorianBundle(_273),_275=_272.formatLength||"short",_276=_272.datePattern||_274["dateFormat-"+_275],_277=_272.timePattern||_274["timeFormat-"+_275],_278;if(_272.selector=="date"){_278=_276;}else{if(_272.selector=="time"){_278=_277;}else{_278=_274["dateTimeFormat-"+_275].replace(/\{(\d+)\}/g,function(_279,key){return [_277,_276][key];});}}var _27a=[],re=_26e(_278,lang.hitch(this,_27b,_27a,_274,_272));return {regexp:re,tokens:_27a,bundle:_274};};dojo.date.locale.parse=function(_27c,_27d){var _27e=/[\u200E\u200F\u202A\u202E]/g,info=dojo.date.locale._parseInfo(_27d),_27f=info.tokens,_280=info.bundle,re=new RegExp("^"+info.regexp.replace(_27e,"")+"$",info.strict?"":"i"),_281=re.exec(_27c&&_27c.replace(_27e,""));if(!_281){return null;}var _282=["abbr","wide","narrow"],_283=[1970,0,1,0,0,0,0],amPm="",_284=dojo.every(_281,function(v,i){if(!i){return true;}var _285=_27f[i-1];var l=_285.length;switch(_285.charAt(0)){case "y":if(l!=2&&_27d.strict){_283[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_286=year.substring(0,2)*100,_287=Math.min(Number(year.substring(2,4))+20,99);_283[0]=(v<_287)?_286+v:_286-100+v;}else{if(_27d.strict){return false;}_283[0]=v;}}break;case "M":if(l>2){var _288=_280["months-format-"+_282[l-3]].concat();if(!_27d.strict){v=v.replace(".","").toLowerCase();_288=dojo.map(_288,function(s){return s.replace(".","").toLowerCase();});}v=dojo.indexOf(_288,v);if(v==-1){return false;}}else{v--;}_283[1]=v;break;case "E":case "e":var days=_280["days-format-"+_282[l-3]].concat();if(!_27d.strict){v=v.toLowerCase();days=dojo.map(days,function(d){return d.toLowerCase();});}v=dojo.indexOf(days,v);if(v==-1){return false;}break;case "D":_283[1]=0;case "d":_283[2]=v;break;case "a":var am=_27d.am||_280["dayPeriods-format-wide-am"],pm=_27d.pm||_280["dayPeriods-format-wide-pm"];if(!_27d.strict){var _289=/\./g;v=v.replace(_289,"").toLowerCase();am=am.replace(_289,"").toLowerCase();pm=pm.replace(_289,"").toLowerCase();}if(_27d.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_283[3]=v;break;case "m":_283[4]=v;break;case "s":_283[5]=v;break;case "S":_283[6]=v;}return true;});var _28a=+_283[3];if(amPm==="p"&&_28a<12){_283[3]=_28a+12;}else{if(amPm==="a"&&_28a==12){_283[3]=0;}}var _28b=new Date(_283[0],_283[1],_283[2],_283[3],_283[4],_283[5],_283[6]);if(_27d.strict){_28b.setFullYear(_283[0]);}var _28c=_27f.join(""),_28d=_28c.indexOf("d")!=-1,_28e=_28c.indexOf("M")!=-1;if(!_284||(_28e&&_28b.getMonth()>_283[1])||(_28d&&_28b.getDate()>_283[2])){return null;}if((_28e&&_28b.getMonth()<_283[1])||(_28d&&_28b.getDate()<_283[2])){_28b=date.add(_28b,"hour",1);}return _28b;};function _26e(_28f,_290,_291,_292){var _293=function(x){return x;};_290=_290||_293;_291=_291||_293;_292=_292||_293;var _294=_28f.match(/(''|[^'])+/g),_295=_28f.charAt(0)=="'";dojo.forEach(_294,function(_296,i){if(!_296){_294[i]="";}else{_294[i]=(_295?_291:_290)(_296.replace(/''/g,"'"));_295=!_295;}});return _292(_294.join(""));};function _27b(_297,_298,_299,_29a){_29a=_256.escapeString(_29a);if(!_299.strict){_29a=_29a.replace(" a"," ?a");}return _29a.replace(/([a-z])\1*/ig,function(_29b){var s,c=_29b.charAt(0),l=_29b.length,p2="",p3="";if(_299.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":s="\\S+";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_299.am||_298["dayPeriods-format-wide-am"],pm=_299.pm||_298["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_299.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_297){_297.push(_29b);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _29c=[];dojo.date.locale.addCustomFormats=function(_29d,_29e){_29c.push({pkg:_29d,name:_29e});};dojo.date.locale._getGregorianBundle=function(_29f){var _2a0={};dojo.forEach(_29c,function(desc){var _2a1=dojo.i18n.getLocalization(desc.pkg,desc.name,_29f);_2a0=lang.mixin(_2a0,_2a1);},this);return _2a0;};dojo.date.locale.addCustomFormats("dojo.cldr","gregorian");dojo.date.locale.getNames=function(item,type,_2a2,_2a3){var _2a4,_2a5=dojo.date.locale._getGregorianBundle(_2a3),_2a6=[item,_2a2,type];if(_2a2=="standAlone"){var key=_2a6.join("-");_2a4=_2a5[key];if(_2a4[0]==1){_2a4=undefined;}}_2a6[1]="format";return (_2a4||_2a5[_2a6.join("-")]).concat();};dojo.date.locale.isWeekend=function(_2a7,_2a8){var _2a9=cldr.getWeekend(_2a8),day=(_2a7||new Date()).getDay();if(_2a9.end<_2a9.start){_2a9.end+=7;if(day<_2a9.start){day+=7;}}return day>=_2a9.start&&day<=_2a9.end;};dojo.date.locale._getDayOfYear=function(_2aa){return date.difference(new Date(_2aa.getFullYear(),0,1,_2aa.getHours()),_2aa)+1;};dojo.date.locale._getWeekOfYear=function(_2ab,_2ac){if(arguments.length==1){_2ac=0;}var _2ad=new Date(_2ab.getFullYear(),0,1).getDay(),adj=(_2ad-_2ac+7)%7,week=Math.floor((dojo.date.locale._getDayOfYear(_2ab)+adj-1)/7);if(_2ad==_2ac){week++;}return week;};return dojo.date.locale;});},"dojox/charting/plot2d/Default":function(){define("dojox/charting/plot2d/Default",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2ae,arr,Base,dc,df,dfr,du,fx){var _2af=dfr.lambda("item.purgeGroup()");var _2b0=1200;return _2ae("dojox.charting.plot2d.Default",Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_2b1,_2b2){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2b2);du.updateWithPattern(this.opt,_2b2,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},createPath:function(run,_2b3,_2b4){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_2b4);_2b3.add(path);}else{path=_2b3.createPath(_2b4);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},render:function(dim,_2b5){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_2b5);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_2af);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_2b6,_2b7,_2b8,_2b9=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _2ba=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_2bb=[],_2bc=[],rseg=null,_2bd,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_2be=this._eventSeries[run.name]=new Array(run.data.length);var _2bf=typeof run.data[0]=="number";var min=_2bf?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_2bf?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;j++){if(run.data[j]!=null){if(!rseg){rseg=[];_2bc.push(j);_2bb.push(rseg);}rseg.push(run.data[j]);}else{rseg=null;}}for(var seg=0;seg<_2bb.length;seg++){if(typeof _2bb[seg][0]=="number"){_2bd=arr.map(_2bb[seg],function(v,i){return {x:ht(i+_2bc[seg]+1)+_2b5.l,y:dim.height-_2b5.b-vt(v)};},this);}else{_2bd=arr.map(_2bb[seg],function(v,i){return {x:ht(v.x)+_2b5.l,y:dim.height-_2b5.b-vt(v.y)};},this);}var _2c0=this.opt.tension?dc.curve(_2bd,this.opt.tension):"";if(this.opt.areas&&_2bd.length>1){var fill=_2ba.series.fill;var _2c1=lang.clone(_2bd);if(this.opt.tension){var _2c2="L"+_2c1[_2c1.length-1].x+","+(dim.height-_2b5.b)+" L"+_2c1[0].x+","+(dim.height-_2b5.b)+" L"+_2c1[0].x+","+_2c1[0].y;run.dyn.fill=s.createPath(_2c0+" "+_2c2).setFill(fill).getFill();}else{_2c1.push({x:_2bd[_2bd.length-1].x,y:dim.height-_2b5.b});_2c1.push({x:_2bd[0].x,y:dim.height-_2b5.b});_2c1.push(_2bd[0]);run.dyn.fill=s.createPolyline(_2c1).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_2b6=_2ba.series.stroke;if(_2ba.series.outline){_2b7=run.dyn.outline=dc.makeStroke(_2ba.series.outline);_2b7.width=2*_2b7.width+_2b6.width;}}if(this.opt.markers){run.dyn.marker=_2ba.symbol;}var _2c3=null,_2c4=null,_2c5=null;if(_2b6&&_2ba.series.shadow&&_2bd.length>1){var _2c6=_2ba.series.shadow,_2c7=arr.map(_2bd,function(c){return {x:c.x+_2c6.dx,y:c.y+_2c6.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_2c7,this.opt.tension)).setStroke(_2c6).getStroke();}else{run.dyn.shadow=s.createPolyline(_2c7).setStroke(_2c6).getStroke();}}if(this.opt.markers&&_2ba.marker.shadow){_2c6=_2ba.marker.shadow;_2c5=arr.map(_2c7,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_2ba.symbol).setStroke(_2c6).setFill(_2c6.color);},this);}}if(this.opt.lines&&_2bd.length>1){if(_2b7){if(this.opt.tension){run.dyn.outline=s.createPath(_2c0).setStroke(_2b7).getStroke();}else{run.dyn.outline=s.createPolyline(_2bd).setStroke(_2b7).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_2c0).setStroke(_2b6).getStroke();}else{run.dyn.stroke=s.createPolyline(_2bd).setStroke(_2b6).getStroke();}}if(this.opt.markers){_2c3=new Array(_2bd.length);_2c4=new Array(_2bd.length);_2b7=null;if(_2ba.marker.outline){_2b7=dc.makeStroke(_2ba.marker.outline);_2b7.width=2*_2b7.width+(_2ba.marker.stroke?_2ba.marker.stroke.width:0);}arr.forEach(_2bd,function(c,i){var path="M"+c.x+" "+c.y+" "+_2ba.symbol;if(_2b7){_2c4[i]=this.createPath(run,s,path).setStroke(_2b7);}_2c3[i]=this.createPath(run,s,path).setStroke(_2ba.marker.stroke).setFill(_2ba.marker.fill);},this);run.dyn.markerFill=_2ba.marker.fill;run.dyn.markerStroke=_2ba.marker.stroke;if(_2b9){arr.forEach(_2c3,function(s,i){var o={element:"marker",index:i+_2bc[seg],run:run,shape:s,outline:_2c4[i]||null,shadow:_2c5&&_2c5[i]||null,cx:_2bd[i].x,cy:_2bd[i].y};if(typeof _2bb[seg][0]=="number"){o.x=i+_2bc[seg]+1;o.y=_2bb[seg][i];}else{o.x=_2bb[seg][i].x;o.y=_2bb[seg][i].y;}this._connectEvents(o);_2be[i+_2bc[seg]]=o;},this);}else{delete this._eventSeries[run.name];}}}run.dirty=false;}if(this.animate){var _2c8=this.group;fx.animateTransform(lang.delegate({shape:_2c8,duration:_2b0,transform:[{name:"translate",start:[0,dim.height-_2b5.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/form/Slider":function(){define("dijit/form/Slider",["dojo/_base/kernel","./HorizontalSlider","./VerticalSlider","./HorizontalRule","./VerticalRule","./HorizontalRuleLabels","./VerticalRuleLabels"],function(_2c9){_2c9.deprecated("Call require() for HorizontalSlider / VerticalRule, explicitly rather than 'dijit.form.Slider' itself","","2.0");});},"dijit/_editor/RichText":function(){define("dijit/_editor/RichText",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/ready","dojo/_base/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/_base/window","../_Widget","../_CssStateMixin","./selection","./range","./html","../focus",".."],function(_2ca,_2cb,_2cc,_2cd,dom,_2ce,_2cf,_2d0,_2d1,_2d2,_2d3,_2d4,keys,lang,on,_2d5,_2d6,has,_2d7,_2d8,_2d9,win,_2da,_2db,_2dc,_2dd,_2de,_2df,_2e0){var _2e1=_2cc("dijit._editor.RichText",[_2da,_2db],{constructor:function(_2e2){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_2e2&&lang.isString(_2e2.value)){this.value=_2e2.value;}this.onLoadDeferred=new _2cd();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,this._stripBreakerNodes)].concat(this.contentDomPostFilters);}this.inherited(arguments);_2d7.publish(_2e0._scopeName+"._editor.RichText::init",this);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _2e3={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_2e3.Z=exec("redo");}var key;for(key in _2e3){this.addKeyHandler(key,true,false,_2e3[key]);}},events:["onKeyPress","onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_2e1._editorCommandsLocalized){this._local2NativeFormatNames=_2e1._local2NativeFormatNames;this._native2LocalFormatNames=_2e1._native2LocalFormatNames;return;}_2e1._editorCommandsLocalized=true;_2e1._local2NativeFormatNames={};_2e1._native2LocalFormatNames={};this._local2NativeFormatNames=_2e1._local2NativeFormatNames;this._native2LocalFormatNames=_2e1._native2LocalFormatNames;var _2e4=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _2e5="",_2e6,i=0;while((_2e6=_2e4[i++])){if(_2e6.charAt(1)!=="l"){_2e5+="<"+_2e6+"><span>content</span></"+_2e6+"><br/>";}else{_2e5+="<"+_2e6+"><li>content</li></"+_2e6+"><br/>";}}var _2e7={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_2d0.create("div",{style:_2e7,innerHTML:_2e5});win.body().appendChild(div);var _2e8=lang.hitch(this,function(){var node=div.firstChild;while(node){try{_2dc.selectElement(node.firstChild);var _2e9=node.tagName.toLowerCase();this._local2NativeFormatNames[_2e9]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_2e9]]=_2e9;node=node.nextSibling.nextSibling;}catch(e){}}div.parentNode.removeChild(div);div.innerHTML="";});setTimeout(_2e8,0);},open:function(_2ea){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _2cd();}if(!this.isClosed){this.close();}_2d7.publish(_2e0._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_2ea.nodeName){this.domNode=_2ea;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;delete this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=win.doc.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_2d0.place(dn,ta,"before");var _2eb=lang.hitch(this,function(){_2d2.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){setTimeout(_2eb,10);}else{_2eb();}if(ta.form){var _2ec=ta.value;this.reset=function(){var _2ed=this.getValue();if(_2ed!==_2ec){this.replaceValue(_2ec);}};on(ta.form,"submit",lang.hitch(this,function(){_2ce.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_2de.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_2cb["useXDomain"]||_2cb["allowXdRichTextSave"])){var _2ee=dom.byId(_2e0._scopeName+"._editor.RichText.value");if(_2ee&&_2ee.value!==""){var _2ef=_2ee.value.split(this._SEPARATOR),i=0,dat;while((dat=_2ef[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){html=data[1];_2ef=_2ef.splice(i,1);_2ee.value=_2ef.join(this._SEPARATOR);break;}}}if(!_2e1._globalSaveHandler){_2e1._globalSaveHandler={};_2d8.addOnUnload(function(){var id;for(id in _2e1._globalSaveHandler){var f=_2e1._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_2e1._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=win.doc.createElement("iframe"));ifr.id=this.id+"_iframe";this._iframeSrc=this._getIframeDocTxt();ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=this.window.document;if(has("ie")){this._localizeEditorCommands();}this.onLoad(html);});var _2f0="parent."+_2e0._scopeName+".byId(\""+this.id+"\")._iframeSrc";var s="javascript:(function(){try{return "+_2f0+"}catch(e){document.open();document.domain=\""+document.domain+"\";document.write("+_2f0+");document.close();}})()";ifr.setAttribute("src",s);this.editingArea.appendChild(ifr);if(has("safari")<=4){var src=ifr.getAttribute("src");if(!src||src.indexOf("javascript")===-1){setTimeout(function(){ifr.setAttribute("src",s);},0);}}if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_2cf.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _2f1=_2d2.getComputedStyle(this.domNode);var html="";var _2f2=true;if(has("ie")||has("webkit")||(!this.height&&!has("mozilla"))){html="<div id='dijitEditorBody'></div>";_2f2=false;}else{if(has("mozilla")){this._cursorToStart=true;html="&#160;";}}var font=[_2f1.fontWeight,_2f1.fontSize,_2f1.fontFamily].join(" ");var _2f3=_2f1.lineHeight;if(_2f3.indexOf("px")>=0){_2f3=parseFloat(_2f3)/parseFloat(_2f1.fontSize);}else{if(_2f3.indexOf("em")>=0){_2f3=parseFloat(_2f3);}else{_2f3="normal";}}var _2f4="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_2f5){_2f5=_2f5.replace(/^;/ig,"")+";";var s=_2f5.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_2d2.set(self.domNode,sC,"");}_2f4+=_2f5+";";});var _2f6=_2d5("label[for=\""+this.id+"\"]");return [this.isLeftToRight()?"<html>\n<head>\n":"<html dir='rtl'>\n<head>\n",(has("mozilla")&&_2f6.length?"<title>"+_2f6[0].innerHTML+"</title>\n":""),"<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n",((has("webkit"))?"\t\twidth: 100%;\n":""),((has("webkit"))?"\t\theight: 100%;\n":""),"\t}\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tmin-height:",this.minHeight,";\n","\t\tline-height:",_2f3,";\n","\t}\n","\tp{ margin: 1em 0; }\n",(!_2f2&&!this.height?"\tbody,html {overflow-y: hidden;}\n":""),"\t#dijitEditorBody{overflow-x: auto; overflow-y:"+(this.height?"auto;":"hidden;")+" outline: 0px;}\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body ",(_2f2?"id='dijitEditorBody' ":""),"onload='frameElement._loadFunc(window,document)' style='"+_2f4+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var _2f7=[];if(this.styleSheets){_2f7=this.styleSheets.split(";");this.styleSheets="";}_2f7=_2f7.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url;while((url=_2f7[i++])){var _2f8=(new _2d9(win.global.location,url)).toString();this.editingAreaStyleSheets.push(_2f8);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_2f8+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString();if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _2d9(win.global.location,url)).toString();}if(_2ca.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.addCallback(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _2f9=this.document.createElement("link");_2f9.rel="stylesheet";_2f9.type="text/css";_2f9.href=url;head.appendChild(_2f9);}}));},removeStyleSheet:function(uri){var url=uri.toString();if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _2d9(win.global.location,url)).toString();}var _2fa=_2ca.indexOf(this.editingAreaStyleSheets,url);if(_2fa===-1){return;}delete this.editingAreaStyleSheets[_2fa];win.withGlobal(this.window,"query",dojo,["link:[href=\""+url+"\"]"]).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_2fb){_2fb=!!_2fb;this._set("disabled",_2fb);if(!this.isLoaded){return;}if(has("ie")||has("webkit")||has("opera")){var _2fc=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_2fc){this.editNode.unselectable="on";}this.editNode.contentEditable=!_2fb;if(_2fc){var _2fd=this;setTimeout(function(){if(_2fd.editNode){_2fd.editNode.unselectable="off";}},0);}}else{try{this.document.designMode=(_2fb?"off":"on");}catch(e){return;}if(!_2fb&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=_2df.registerIframe(this.iframe);}if(!has("ie")&&!has("webkit")&&(this.height||has("mozilla"))){this.editNode=this.document.body;}else{this.editNode=this.document.body.firstChild;var _2fe=this;if(has("ie")){this.tabStop=_2d0.create("div",{tabIndex:-1},this.editingArea);this.iframe.onfocus=function(){_2fe.editNode.setActive();};}}this.focusNode=this.editNode;var _2ff=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;_2ca.forEach(_2ff,function(item){this.connect(ap,item.toLowerCase(),item);},this);this.connect(ap,"onmouseup","onClick");if(has("ie")){this.connect(this.document,"onmousedown","_onIEMouseDown");this.editNode.style.zoom=1;}else{this.connect(this.document,"onmousedown",function(){delete this._cursorToStart;});}if(has("webkit")){this._webkitListener=this.connect(this.document,"onmouseup","onDisplayChanged");this.connect(this.document,"onmousedown",function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){setTimeout(lang.hitch(this,"placeCursorAtEnd"),0);}});}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _300=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred){this.onLoadDeferred.callback(true);}this.onDisplayChanged();if(this.focusOnLoad){_2d6(lang.hitch(this,function(){setTimeout(lang.hitch(this,"focus"),this.updateInterval);}));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.addCallback(_300);}else{_300();}},onKeyDown:function(e){if(e.keyCode===keys.TAB&&this.isTabIndent){_2d3.stop(e);if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(has("ie")){if(e.keyCode==keys.TAB&&!this.isTabIndent){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){this.iframe.focus();}else{if(!e.shiftKey&&!e.ctrlKey&&!e.altKey){this.tabStop.focus();}}}else{if(e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){_2d3.stop(e);this.execCommand("delete");}else{if((65<=e.keyCode&&e.keyCode<=90)||(e.keyCode>=37&&e.keyCode<=40)){e.charCode=e.keyCode;this.onKeyPress(e);}}}}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}return true;},onKeyUp:function(){},setDisabled:function(_301){_2d4.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_301);},_setValueAttr:function(_302){this.setValue(_302);},_setDisableSpellCheckAttr:function(_303){if(this.document){_2ce.set(this.document.body,"spellcheck",!_303);}else{this.onLoadDeferred.addCallback(lang.hitch(this,function(){_2ce.set(this.document.body,"spellcheck",!_303);}));}this._set("disableSpellCheck",_303);},onKeyPress:function(e){var c=(e.keyChar&&e.keyChar.toLowerCase())||e.keyCode,_304=this._keyHandlers[c],args=arguments;if(_304&&!e.altKey){_2ca.some(_304,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}if(!this._onKeyHitch){this._onKeyHitch=lang.hitch(this,"onKeyPressed");}setTimeout(this._onKeyHitch,1);return true;},addKeyHandler:function(key,ctrl,_305,_306){if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:_305||false,ctrl:ctrl||false,handler:_306});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){this.inherited(arguments);var _307=this.getValue(true);if(_307!==this.value){this.onChange(_307);}this._set("value",_307);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(win.doc.body.focus){win.doc.body.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(this._cursorToStart){delete this._cursorToStart;if(this.editNode.childNodes){this.placeCursorAtStart();return;}}if(!has("ie")){_2df.focus(this.iframe);}else{if(this.editNode&&this.editNode.focus){this.iframe.fireEvent("onfocus",document.createEventObject());}}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){clearTimeout(this._updateTimer);}if(!this._updateHandler){this._updateHandler=lang.hitch(this,"onNormalizedDisplayChanged");}this._updateTimer=setTimeout(this._updateHandler,this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_308){var _309=cmd.toLowerCase();if(_309==="formatblock"){if(has("safari")&&_308===undefined){_309="heading";}}else{if(_309==="hilitecolor"&&!has("mozilla")){_309="backcolor";}}return _309;},_qcaCache:{},queryCommandAvailable:function(_30a){var ca=this._qcaCache[_30a];if(ca!==undefined){return ca;}return (this._qcaCache[_30a]=this._queryCommandAvailable(_30a));},_queryCommandAvailable:function(_30b){var ie=1;var _30c=1<<1;var _30d=1<<2;var _30e=1<<3;function _30f(_310){return {ie:Boolean(_310&ie),mozilla:Boolean(_310&_30c),webkit:Boolean(_310&_30d),opera:Boolean(_310&_30e)};};var _311=null;switch(_30b.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":_311=_30f(_30c|ie|_30d|_30e);break;case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":_311=_30f(_30c|ie|_30e|_30d);break;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":_311=_30f(ie);break;case "cut":case "copy":case "paste":_311=_30f(ie|_30c|_30d);break;case "inserttable":_311=_30f(_30c|ie);break;case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":_311=_30f(ie|_30c);break;default:return false;}return (has("ie")&&_311.ie)||(has("mozilla")&&_311.mozilla)||(has("webkit")&&_311.webkit)||(has("opera")&&_311.opera);},execCommand:function(_312,_313){var _314;this.focus();_312=this._normalizeCommand(_312,_313);if(_313!==undefined){if(_312==="heading"){throw new Error("unimplemented");}else{if((_312==="formatblock")&&has("ie")){_313="<"+_313+">";}}}var _315="_"+_312+"Impl";if(this[_315]){_314=this[_315](_313);}else{_313=arguments.length>1?_313:null;if(_313||_312!=="createlink"){_314=this.document.execCommand(_312,false,_313);}}this.onDisplayChanged();return _314;},queryCommandEnabled:function(_316){if(this.disabled||!this._disabledOK){return false;}_316=this._normalizeCommand(_316);var _317="_"+_316+"EnabledImpl";if(this[_317]){return this[_317](_316);}else{return this._browserQueryCommandEnabled(_316);}},queryCommandState:function(_318){if(this.disabled||!this._disabledOK){return false;}_318=this._normalizeCommand(_318);try{return this.document.queryCommandState(_318);}catch(e){return false;}},queryCommandValue:function(_319){if(this.disabled||!this._disabledOK){return false;}var r;_319=this._normalizeCommand(_319);if(has("ie")&&_319==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_319)];}else{if(has("mozilla")&&_319==="hilitecolor"){var _31a;try{_31a=this.document.queryCommandValue("styleWithCSS");}catch(e){_31a=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_319);this.document.execCommand("styleWithCSS",false,_31a);}else{r=this.document.queryCommandValue(_319);}}return r;},_sCall:function(name,args){return win.withGlobal(this.window,name,_2dc,args);},placeCursorAtStart:function(){this.focus();var _31b=false;if(has("mozilla")){var _31c=this.editNode.firstChild;while(_31c){if(_31c.nodeType===3){if(_31c.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_31b=true;this._sCall("selectElement",[_31c]);break;}}else{if(_31c.nodeType===1){_31b=true;var tg=_31c.tagName?_31c.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this._sCall("selectElement",[_31c]);}else{this._sCall("selectElementChildren",[_31c]);}break;}}_31c=_31c.nextSibling;}}else{_31b=true;this._sCall("selectElementChildren",[this.editNode]);}if(_31b){this._sCall("collapse",[true]);}},placeCursorAtEnd:function(){this.focus();var _31d=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_31d=true;this._sCall("selectElement",[last]);break;}}else{if(last.nodeType===1){_31d=true;if(last.lastChild){this._sCall("selectElement",[last.lastChild]);}else{this._sCall("selectElement",[last]);}break;}}last=last.previousSibling;}}else{_31d=true;this._sCall("selectElementChildren",[this.editNode]);}if(_31d){this._sCall("collapse",[false]);}},getValue:function(_31e){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this._postFilterContent(null,_31e);},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.addCallback(lang.hitch(this,function(){this.setValue(html);}));return;}this._cursorToStart=true;if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;if(html&&has("mozilla")&&html.toLowerCase()==="<p></p>"){html="<p>&#160;</p>";}if(!html&&has("webkit")){html="&#160;";}node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");if(!html){this._cursorToStart=true;html="&#160;";}this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;_2ca.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;_2ca.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_31f){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_31f){dom=lang.clone(dom);}_2ca.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_2de.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}_2ca.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _320=dom.byId(_2e0._scopeName+"._editor.RichText.value");if(_320){if(_320.value){_320.value+=this._SEPARATOR;}_320.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_321){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_321){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_2d4.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _2de.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_2d4.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _2de.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this.disconnect(this._webkitListener);delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_2d0.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_2cf.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){clearTimeout(this._updateTimer);}this.inherited(arguments);if(_2e1._globalSaveHandler){delete _2e1._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_322){if(!_322){return false;}var elem=has("ie")?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_322);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _323=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_323=true;}else{_323=this.document.queryCommandEnabled("createlink");}}else{_323=this._browserQueryCommandEnabled("createlink");}return _323;},_unlinkEnabledImpl:function(){var _324=true;if(has("mozilla")||has("webkit")){_324=this._sCall("hasAncestorElement",["a"]);}else{_324=this._browserQueryCommandEnabled("unlink");}return _324;},_inserttableEnabledImpl:function(){var _325=true;if(has("mozilla")||has("webkit")){_325=true;}else{_325=this._browserQueryCommandEnabled("inserttable");}return _325;},_cutEnabledImpl:function(){var _326=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_326=!!sel;}else{_326=this._browserQueryCommandEnabled("cut");}return _326;},_copyEnabledImpl:function(){var _327=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_327=!!sel;}else{_327=this._browserQueryCommandEnabled("copy");}return _327;},_pasteEnabledImpl:function(){var _328=true;if(has("webkit")){return true;}else{_328=this._browserQueryCommandEnabled("paste");}return _328;},_inserthorizontalruleImpl:function(_329){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_329);},_unlinkImpl:function(_32a){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this._sCall("getAncestorElement",["a"]);this._sCall("selectElement",[a]);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_32a);},_hilitecolorImpl:function(_32b){var _32c;var _32d=this._handleTextColorOrProperties("hilitecolor",_32b);if(!_32d){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_32c=this.document.execCommand("hilitecolor",false,_32b);this.document.execCommand("styleWithCSS",false,false);}else{_32c=this.document.execCommand("hilitecolor",false,_32b);}}return _32c;},_backcolorImpl:function(_32e){if(has("ie")){_32e=_32e?_32e:null;}var _32f=this._handleTextColorOrProperties("backcolor",_32e);if(!_32f){_32f=this.document.execCommand("backcolor",false,_32e);}return _32f;},_forecolorImpl:function(_330){if(has("ie")){_330=_330?_330:null;}var _331=false;_331=this._handleTextColorOrProperties("forecolor",_330);if(!_331){_331=this.document.execCommand("forecolor",false,_330);}return _331;},_inserthtmlImpl:function(_332){_332=this._preFilterContent(_332);var rv=true;if(has("ie")){var _333=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_333.item(0);while(_333.length){_333.remove(_333.item(0));}n.outerHTML=_332;}else{_333.pasteHTML(_332);}_333.select();}else{if(has("mozilla")&&!_332.length){this._sCall("remove");}else{rv=this.document.execCommand("inserthtml",false,_332);}}return rv;},_boldImpl:function(_334){var _335=false;if(has("ie")){this._adaptIESelection();_335=this._adaptIEFormatAreaAndExec("bold");}if(!_335){_335=this.document.execCommand("bold",false,_334);}return _335;},_italicImpl:function(_336){var _337=false;if(has("ie")){this._adaptIESelection();_337=this._adaptIEFormatAreaAndExec("italic");}if(!_337){_337=this.document.execCommand("italic",false,_336);}return _337;},_underlineImpl:function(_338){var _339=false;if(has("ie")){this._adaptIESelection();_339=this._adaptIEFormatAreaAndExec("underline");}if(!_339){_339=this.document.execCommand("underline",false,_338);}return _339;},_strikethroughImpl:function(_33a){var _33b=false;if(has("ie")){this._adaptIESelection();_33b=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_33b){_33b=this.document.execCommand("strikethrough",false,_33a);}return _33b;},_superscriptImpl:function(_33c){var _33d=false;if(has("ie")){this._adaptIESelection();_33d=this._adaptIEFormatAreaAndExec("superscript");}if(!_33d){_33d=this.document.execCommand("superscript",false,_33c);}return _33d;},_subscriptImpl:function(_33e){var _33f=false;if(has("ie")){this._adaptIESelection();_33f=this._adaptIEFormatAreaAndExec("subscript");}if(!_33f){_33f=this.document.execCommand("subscript",false,_33e);}return _33f;},_fontnameImpl:function(_340){var _341;if(has("ie")){_341=this._handleTextColorOrProperties("fontname",_340);}if(!_341){_341=this.document.execCommand("fontname",false,_340);}return _341;},_fontsizeImpl:function(_342){var _343;if(has("ie")){_343=this._handleTextColorOrProperties("fontsize",_342);}if(!_343){_343=this.document.execCommand("fontsize",false,_342);}return _343;},_insertorderedlistImpl:function(_344){var _345=false;if(has("ie")){_345=this._adaptIEList("insertorderedlist",_344);}if(!_345){_345=this.document.execCommand("insertorderedlist",false,_344);}return _345;},_insertunorderedlistImpl:function(_346){var _347=false;if(has("ie")){_347=this._adaptIEList("insertunorderedlist",_346);}if(!_347){_347=this.document.execCommand("insertunorderedlist",false,_346);}return _347;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_2d1.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_348){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_348);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_348)==="");}}return false;},_removeStartingRangeFromRange:function(node,_349){if(node.nextSibling){_349.setStart(node.nextSibling,0);}else{var _34a=node.parentNode;while(_34a&&_34a.nextSibling==null){_34a=_34a.parentNode;}if(_34a){_349.setStart(_34a.nextSibling,0);}}return _349;},_adaptIESelection:function(){var _34b=_2dd.getSelection(this.window);if(_34b&&_34b.rangeCount&&!_34b.isCollapsed){var _34c=_34b.getRangeAt(0);var _34d=_34c.startContainer;var _34e=_34c.startOffset;while(_34d.nodeType===3&&_34e>=_34d.length&&_34d.nextSibling){_34e=_34e-_34d.length;_34d=_34d.nextSibling;}var _34f=null;while(this._isNodeEmpty(_34d,_34e)&&_34d!==_34f){_34f=_34d;_34c=this._removeStartingRangeFromRange(_34d,_34c);_34d=_34c.startContainer;_34e=0;}_34b.removeAllRanges();_34b.addRange(_34c);}},_adaptIEFormatAreaAndExec:function(_350){var _351=_2dd.getSelection(this.window);var doc=this.document;var rs,ret,_352,txt,_353,_354,_355,_356;if(_350&&_351&&_351.isCollapsed){var _357=this.queryCommandValue(_350);if(_357){var _358=this._tagNamesForCommand(_350);_352=_351.getRangeAt(0);var fs=_352.startContainer;if(fs.nodeType===3){var _359=_352.endOffset;if(fs.length<_359){ret=this._adjustNodeAndOffset(rs,_359);fs=ret.node;_359=ret.offset;}}var _35a;while(fs&&fs!==this.editNode){var _35b=fs.tagName?fs.tagName.toLowerCase():"";if(_2ca.indexOf(_358,_35b)>-1){_35a=fs;break;}fs=fs.parentNode;}if(_35a){rs=_352.startContainer;var _35c=doc.createElement(_35a.tagName);_2d0.place(_35c,_35a,"after");if(rs&&rs.nodeType===3){var _35d,_35e;var _35f=_352.endOffset;if(rs.length<_35f){ret=this._adjustNodeAndOffset(rs,_35f);rs=ret.node;_35f=ret.offset;}txt=rs.nodeValue;_353=doc.createTextNode(txt.substring(0,_35f));var _360=txt.substring(_35f,txt.length);if(_360){_354=doc.createTextNode(_360);}_2d0.place(_353,rs,"before");if(_354){_355=doc.createElement("span");_355.className="ieFormatBreakerSpan";_2d0.place(_355,rs,"after");_2d0.place(_354,_355,"after");_354=_355;}_2d0.destroy(rs);var _361=_353.parentNode;var _362=[];var _363;while(_361!==_35a){var tg=_361.tagName;_363={tagName:tg};_362.push(_363);var _364=doc.createElement(tg);if(_361.style){if(_364.style){if(_361.style.cssText){_364.style.cssText=_361.style.cssText;_363.cssText=_361.style.cssText;}}}if(_361.tagName==="FONT"){if(_361.color){_364.color=_361.color;_363.color=_361.color;}if(_361.face){_364.face=_361.face;_363.face=_361.face;}if(_361.size){_364.size=_361.size;_363.size=_361.size;}}if(_361.className){_364.className=_361.className;_363.className=_361.className;}if(_354){_35d=_354;while(_35d){_35e=_35d.nextSibling;_364.appendChild(_35d);_35d=_35e;}}if(_364.tagName==_361.tagName){_355=doc.createElement("span");_355.className="ieFormatBreakerSpan";_2d0.place(_355,_361,"after");_2d0.place(_364,_355,"after");}else{_2d0.place(_364,_361,"after");}_353=_361;_354=_364;_361=_361.parentNode;}if(_354){_35d=_354;if(_35d.nodeType===1||(_35d.nodeType===3&&_35d.nodeValue)){_35c.innerHTML="";}while(_35d){_35e=_35d.nextSibling;_35c.appendChild(_35d);_35d=_35e;}}if(_362.length){_363=_362.pop();var _365=doc.createElement(_363.tagName);if(_363.cssText&&_365.style){_365.style.cssText=_363.cssText;}if(_363.className){_365.className=_363.className;}if(_363.tagName==="FONT"){if(_363.color){_365.color=_363.color;}if(_363.face){_365.face=_363.face;}if(_363.size){_365.size=_363.size;}}_2d0.place(_365,_35c,"before");while(_362.length){_363=_362.pop();var _366=doc.createElement(_363.tagName);if(_363.cssText&&_366.style){_366.style.cssText=_363.cssText;}if(_363.className){_366.className=_363.className;}if(_363.tagName==="FONT"){if(_363.color){_366.color=_363.color;}if(_363.face){_366.face=_363.face;}if(_363.size){_366.size=_363.size;}}_365.appendChild(_366);_365=_366;}_356=doc.createTextNode(".");_355.appendChild(_356);_365.appendChild(_356);win.withGlobal(this.window,lang.hitch(this,function(){var _367=_2dd.create();_367.setStart(_356,0);_367.setEnd(_356,_356.length);_351.removeAllRanges();_351.addRange(_367);_2dc.collapse(false);_356.parentNode.innerHTML="";}));}else{_355=doc.createElement("span");_355.className="ieFormatBreakerSpan";_356=doc.createTextNode(".");_355.appendChild(_356);_2d0.place(_355,_35c,"before");win.withGlobal(this.window,lang.hitch(this,function(){var _368=_2dd.create();_368.setStart(_356,0);_368.setEnd(_356,_356.length);_351.removeAllRanges();_351.addRange(_368);_2dc.collapse(false);_356.parentNode.innerHTML="";}));}if(!_35c.firstChild){_2d0.destroy(_35c);}return true;}}return false;}else{_352=_351.getRangeAt(0);rs=_352.startContainer;if(rs&&rs.nodeType===3){win.withGlobal(this.window,lang.hitch(this,function(){var _369=_352.startOffset;if(rs.length<_369){ret=this._adjustNodeAndOffset(rs,_369);rs=ret.node;_369=ret.offset;}txt=rs.nodeValue;_353=doc.createTextNode(txt.substring(0,_369));var _36a=txt.substring(_369);if(_36a!==""){_354=doc.createTextNode(txt.substring(_369));}_355=doc.createElement("span");_356=doc.createTextNode(".");_355.appendChild(_356);if(_353.length){_2d0.place(_353,rs,"after");}else{_353=rs;}_2d0.place(_355,_353,"after");if(_354){_2d0.place(_354,_355,"after");}_2d0.destroy(rs);var _36b=_2dd.create();_36b.setStart(_356,0);_36b.setEnd(_356,_356.length);_351.removeAllRanges();_351.addRange(_36b);doc.execCommand(_350);_2d0.place(_355.firstChild,_355,"before");_2d0.destroy(_355);_36b.setStart(_356,0);_36b.setEnd(_356,_356.length);_351.removeAllRanges();_351.addRange(_36b);_2dc.collapse(false);_356.parentNode.innerHTML="";}));return true;}}}else{return false;}},_adaptIEList:function(_36c){var _36d=_2dd.getSelection(this.window);if(_36d.isCollapsed){if(_36d.rangeCount&&!this.queryCommandValue(_36c)){var _36e=_36d.getRangeAt(0);var sc=_36e.startContainer;if(sc&&sc.nodeType==3){if(!_36e.startOffset){win.withGlobal(this.window,lang.hitch(this,function(){var _36f="ul";if(_36c==="insertorderedlist"){_36f="ol";}var list=_2d0.create(_36f);var li=_2d0.create("li",null,list);_2d0.place(list,sc,"before");li.appendChild(sc);_2d0.create("br",null,list,"after");var _370=_2dd.create();_370.setStart(sc,0);_370.setEnd(sc,sc.length);_36d.removeAllRanges();_36d.addRange(_370);_2dc.collapse(true);}));return true;}}}}return false;},_handleTextColorOrProperties:function(_371,_372){var _373=_2dd.getSelection(this.window);var doc=this.document;var rs,ret,_374,txt,_375,_376,_377,_378;_372=_372||null;if(_371&&_373&&_373.isCollapsed){if(_373.rangeCount){_374=_373.getRangeAt(0);rs=_374.startContainer;if(rs&&rs.nodeType===3){win.withGlobal(this.window,lang.hitch(this,function(){var _379=_374.startOffset;if(rs.length<_379){ret=this._adjustNodeAndOffset(rs,_379);rs=ret.node;_379=ret.offset;}txt=rs.nodeValue;_375=doc.createTextNode(txt.substring(0,_379));var _37a=txt.substring(_379);if(_37a!==""){_376=doc.createTextNode(txt.substring(_379));}_377=_2d0.create("span");_378=doc.createTextNode(".");_377.appendChild(_378);var _37b=_2d0.create("span");_377.appendChild(_37b);if(_375.length){_2d0.place(_375,rs,"after");}else{_375=rs;}_2d0.place(_377,_375,"after");if(_376){_2d0.place(_376,_377,"after");}_2d0.destroy(rs);var _37c=_2dd.create();_37c.setStart(_378,0);_37c.setEnd(_378,_378.length);_373.removeAllRanges();_373.addRange(_37c);if(has("webkit")){var _37d="color";if(_371==="hilitecolor"||_371==="backcolor"){_37d="backgroundColor";}_2d2.set(_377,_37d,_372);_2dc.remove();_2d0.destroy(_37b);_377.innerHTML="&#160;";_2dc.selectElement(_377);this.focus();}else{this.execCommand(_371,_372);_2d0.place(_377.firstChild,_377,"before");_2d0.destroy(_377);_37c.setStart(_378,0);_37c.setEnd(_378,_378.length);_373.removeAllRanges();_373.addRange(_37c);_2dc.collapse(false);_378.parentNode.removeChild(_378);}}));return true;}}}return false;},_adjustNodeAndOffset:function(node,_37e){while(node.length<_37e&&node.nextSibling&&node.nextSibling.nodeType===3){_37e=_37e-node.length;node=node.nextSibling;}return {"node":node,"offset":_37e};},_tagNamesForCommand:function(_37f){if(_37f==="bold"){return ["b","strong"];}else{if(_37f==="italic"){return ["i","em"];}else{if(_37f==="strikethrough"){return ["s","strike"];}else{if(_37f==="superscript"){return ["sup"];}else{if(_37f==="subscript"){return ["sub"];}else{if(_37f==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){win.withGlobal(this.window,lang.hitch(this,function(){var _380=_2d5(".ieFormatBreakerSpan",node);var i;for(i=0;i<_380.length;i++){var b=_380[i];while(b.firstChild){_2d0.place(b.firstChild,b,"before");}_2d0.destroy(b);}}));return node;}});return _2e1;});},"dijit/ToolbarSeparator":function(){define("dijit/ToolbarSeparator",["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_381,dom,_382,_383){return _381("dijit.ToolbarSeparator",[_382,_383],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/RadioButton":function(){define("dijit/form/RadioButton",["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_384,_385,_386){return _384("dijit.form.RadioButton",[_385,_386],{baseClass:"dijitRadio"});});},"dijit/MenuSeparator":function(){require({cache:{"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>"}});define("dijit/MenuSeparator",["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_387,dom,_388,_389,_38a,_38b){return _387("dijit.MenuSeparator",[_388,_389,_38a],{templateString:_38b,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/ToggleButton":function(){define("dijit/form/ToggleButton",["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_38c,_38d,_38e,_38f){return _38c("dijit.form.ToggleButton",[_38e,_38f],{baseClass:"dijitToggleButton",setChecked:function(_390){_38d.deprecated("setChecked("+_390+") is deprecated. Use set('checked',"+_390+") instead.","","2.0");this.set("checked",_390);}});});},"dojo/dom-prop":function(){define("dojo/dom-prop",["exports","./_base/kernel","./_base/sniff","./_base/lang","./dom","./dom-style","./dom-construct","./_base/connect"],function(_391,dojo,has,lang,dom,_392,ctr,conn){var _393={},_394=0,_395=dojo._scopeName+"attrid";var _396={col:1,colgroup:1,table:1,tbody:1,tfoot:1,thead:1,tr:1,title:1};_391.names={"class":"className","for":"htmlFor",tabindex:"tabIndex",readonly:"readOnly",colspan:"colSpan",frameborder:"frameBorder",rowspan:"rowSpan",valuetype:"valueType"};_391.get=function getProp(node,name){node=dom.byId(node);var lc=name.toLowerCase(),_397=_391.names[lc]||name;return node[_397];};_391.set=function setProp(node,name,_398){node=dom.byId(node);var l=arguments.length;if(l==2&&typeof name!="string"){for(var x in name){_391.set(node,x,name[x]);}return node;}var lc=name.toLowerCase(),_399=_391.names[lc]||name;if(_399=="style"&&typeof _398!="string"){_392.style(node,_398);return node;}if(_399=="innerHTML"){if(has("ie")&&node.tagName.toLowerCase() in _396){ctr.empty(node);node.appendChild(ctr.toDom(_398,node.ownerDocument));}else{node[_399]=_398;}return node;}if(lang.isFunction(_398)){var _39a=node[_395];if(!_39a){_39a=_394++;node[_395]=_39a;}if(!_393[_39a]){_393[_39a]={};}var h=_393[_39a][_399];if(h){conn.disconnect(h);}else{try{delete node[_399];}catch(e){}}if(_398){_393[_39a][_399]=conn.connect(node,_399,_398);}else{node[_399]=null;}return node;}node[_399]=_398;return node;};});},"dijit/CheckedMenuItem":function(){require({cache:{"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n"}});define("dijit/CheckedMenuItem",["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_39b,_39c,_39d,_39e){return _39b("dijit.CheckedMenuItem",_39d,{templateString:_39e,checked:false,_setCheckedAttr:function(_39f){_39c.toggle(this.domNode,"dijitCheckedMenuItemChecked",_39f);this.domNode.setAttribute("aria-checked",_39f);this._set("checked",_39f);},iconClass:"",onChange:function(){},_onClick:function(e){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.inherited(arguments);}});});},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","dojox/lang/functional":function(){define("dojox/lang/functional",["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dijit/_DialogMixin":function(){define("dijit/_DialogMixin",["dojo/_base/declare","./a11y"],function(_3a0,a11y){return _3a0("dijit._DialogMixin",null,{execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _3a1=a11y._getTabNavigable(this.containerNode);this._firstFocusItem=_3a1.lowest||_3a1.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_3a1.last||_3a1.highest||this._firstFocusItem;}});});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3a2,_3a3,_3a4,_3a5,_3a6,lang,_3a7,_3a8,_3a9,_3aa,_3ab,_3ac){function _3ad(){};function _3ae(_3af){return function(obj,_3b0,_3b1,_3b2){if(obj&&typeof _3b0=="string"&&obj[_3b0]==_3ad){return obj.on(_3b0.substring(2).toLowerCase(),lang.hitch(_3b1,_3b2));}return _3af.apply(_3a4,arguments);};};_3a2.around(_3a4,"connect",_3ae);if(_3a6.connect){_3a2.around(_3a6,"connect",_3ae);}var _3b3=_3a5("dijit._Widget",[_3aa,_3ab,_3ac],{onClick:_3ad,onDblClick:_3ad,onKeyDown:_3ad,onKeyPress:_3ad,onKeyUp:_3ad,onMouseDown:_3ad,onMouseMove:_3ad,onMouseOut:_3ad,onMouseOver:_3ad,onMouseLeave:_3ad,onMouseEnter:_3ad,onMouseUp:_3ad,constructor:function(_3b4){this._toConnect={};for(var name in _3b4){if(this[name]===_3ad){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3b4[name];delete _3b4[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3ad){return _3a4.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3b5){_3a6.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3b5);},attr:function(name,_3b6){if(_3a3.isDebug){var _3b7=arguments.callee._ach||(arguments.callee._ach={}),_3b8=(arguments.callee.caller||"unknown caller").toString();if(!_3b7[_3b8]){_3a6.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_3b8,"","2.0");_3b7[_3b8]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3a6.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3a7("[widgetId]",this.containerNode).map(_3a9.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(!_3a6.isAsync){_3a8(0,function(){var _3b9=["dijit/_base"];require(_3b9);});}return _3b3;});},"dojox/fx":function(){define("dojox/fx",["./fx/_base"],function(_3ba){return _3ba;});},"dijit/layout/AccordionContainer":function(){require({cache:{"url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='onclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeypress:_onTitleKeyPress'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon\" data-dojo-attach-point='iconNode' style=\"vertical-align: middle\" role=\"presentation\"/>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n"}});define("dijit/layout/AccordionContainer",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/_base/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html"],function(_3bb,_3bc,_3bd,_3be,fx,dom,_3bf,_3c0,_3c1,_3c2,_3c3,keys,lang,has,_3c4,_3c5,_3c6,_3c7,_3c8,_3c9,_3ca,_3cb,_3cc,_3cd,_3ce){var _3cf=_3bd("dijit.layout._AccordionButton",[_3c8,_3ca,_3cb],{templateString:_3ce,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _3d0=this.id.replace(" ","_");_3bf.set(this.titleTextNode,"id",_3d0+"_title");this.focusNode.setAttribute("aria-labelledby",_3bf.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _3c2.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _3d1=this.getParent();_3d1.selectChild(this.contentWidget,true);_3c5.focus(this.focusNode);},_onTitleKeyPress:function(evt){return this.getParent()._onKeyPress(evt,this.contentWidget);},_setSelectedAttr:function(_3d2){this._set("selected",_3d2);this.focusNode.setAttribute("aria-expanded",_3d2);this.focusNode.setAttribute("aria-selected",_3d2);this.focusNode.setAttribute("tabIndex",_3d2?"0":"-1");}});var _3d3=_3bd("dijit.layout._AccordionInnerContainer",[_3c8,_3cb],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_3c1.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _3d4=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_3d4._buttonWidget=(new cls({contentWidget:_3d4,label:_3d4.title,title:_3d4.tooltip,dir:_3d4.dir,lang:_3d4.lang,textDir:_3d4.textDir,iconClass:_3d4.iconClass,id:_3d4.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_3c1.place("<div class='dijitAccordionChildWrapper' style='display:none'>",this.domNode);_3c1.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _3d5=this.button;this._contentWidgetWatches=[this.contentWidget.watch("title",lang.hitch(this,function(name,_3d6,_3d7){_3d5.set("label",_3d7);})),this.contentWidget.watch("tooltip",lang.hitch(this,function(name,_3d8,_3d9){_3d5.set("title",_3d9);})),this.contentWidget.watch("iconClass",lang.hitch(this,function(name,_3da,_3db){_3d5.set("iconClass",_3db);}))];},_setSelectedAttr:function(_3dc){this._set("selected",_3dc);this.button.set("selected",_3dc);if(_3dc){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_3bc.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_3dd){this.contentWidget.destroyRecursive(_3dd);}});var _3de=_3bd("dijit.layout.AccordionContainer",_3cc,{duration:_3c6.defaultDuration,buttonWidget:_3cf,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){var _3df=this.selectedChildWidget.containerNode.style;_3df.display="";_3df.overflow="auto";this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _3e0=this.selectedChildWidget;if(!_3e0){return;}var _3e1=_3e0._wrapperWidget.domNode,_3e2=_3c2.getMarginExtents(_3e1),_3e3=_3c2.getPadBorderExtents(_3e1),_3e4=_3e0._wrapperWidget.containerNode,_3e5=_3c2.getMarginExtents(_3e4),_3e6=_3c2.getPadBorderExtents(_3e4),_3e7=this._contentBox;var _3e8=0;_3bc.forEach(this.getChildren(),function(_3e9){if(_3e9!=_3e0){_3e8+=_3c2.getMarginSize(_3e9._wrapperWidget.domNode).h;}});this._verticalSpace=_3e7.h-_3e8-_3e2.h-_3e3.h-_3e5.h-_3e6.h-_3e0._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_3e2.w-_3e3.w-_3e5.w-_3e6.w};if(_3e0){_3e0.resize(this._containerContentBox);}},_setupChild:function(_3ea){_3ea._wrapperWidget=_3d3({contentWidget:_3ea,buttonWidget:this.buttonWidget,id:_3ea.id+"_wrapper",dir:_3ea.dir,lang:_3ea.lang,textDir:_3ea.textDir,parent:this});this.inherited(arguments);},addChild:function(_3eb,_3ec){if(this._started){var _3ed=this.containerNode;if(_3ec&&typeof _3ec=="number"){var _3ee=_3c8.prototype.getChildren.call(this);if(_3ee&&_3ee.length>=_3ec){_3ed=_3ee[_3ec-1].domNode;_3ec="after";}}_3c1.place(_3eb.domNode,_3ed,_3ec);if(!_3eb._started){_3eb.startup();}this._setupChild(_3eb);_3c4.publish(this.id+"-addChild",_3eb,_3ec);this.layout();if(!this.selectedChildWidget){this.selectChild(_3eb);}}else{this.inherited(arguments);}},removeChild:function(_3ef){if(_3ef._wrapperWidget){_3c1.place(_3ef.domNode,_3ef._wrapperWidget.domNode,"after");_3ef._wrapperWidget.destroy();delete _3ef._wrapperWidget;}_3c0.remove(_3ef.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _3bc.map(this.inherited(arguments),function(_3f0){return _3f0.declaredClass=="dijit.layout._AccordionInnerContainer"?_3f0.contentWidget:_3f0;},this);},destroy:function(){if(this._animation){this._animation.stop();}_3bc.forEach(this.getChildren(),function(_3f1){if(_3f1._wrapperWidget){_3f1._wrapperWidget.destroy();}else{_3f1.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_3f2){_3f2._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_3f3){_3f3._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_3f4,_3f5,_3f6){if(has("ie")<8){_3f6=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_3f4){_3f4._wrapperWidget.set("selected",true);var d=this._showChild(_3f4);if(this.doLayout&&_3f4.resize){_3f4.resize(this._containerContentBox);}}if(_3f5){_3f5._wrapperWidget.set("selected",false);if(!_3f6){this._hideChild(_3f5);}}if(_3f6){var _3f7=_3f4._wrapperWidget.containerNode,_3f8=_3f5._wrapperWidget.containerNode;var _3f9=_3f4._wrapperWidget.containerNode,_3fa=_3c2.getMarginExtents(_3f9),_3fb=_3c2.getPadBorderExtents(_3f9),_3fc=_3fa.h+_3fb.h;_3f8.style.height=(self._verticalSpace-_3fc)+"px";this._animation=new fx.Animation({node:_3f7,duration:this.duration,curve:[1,this._verticalSpace-_3fc-1],onAnimate:function(_3fd){_3fd=Math.floor(_3fd);_3f7.style.height=_3fd+"px";_3f8.style.height=(self._verticalSpace-_3fc-_3fd)+"px";},onEnd:function(){delete self._animation;_3f7.style.height="auto";_3f5._wrapperWidget.containerNode.style.display="none";_3f8.style.height="auto";self._hideChild(_3f5);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyPress:function(e,_3fe){if(this.disabled||e.altKey||!(_3fe||e.ctrlKey)){return;}var c=e.charOrCode;if((_3fe&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();_3be.stop(e);}else{if((_3fe&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();_3be.stop(e);}}}});if(!_3c3.isAsync){_3c7(0,function(){var _3ff=["dijit/layout/AccordionPane"];_3bb(_3ff);});}_3de._InnerContainer=_3d3;_3de._Button=_3cf;return _3de;});},"url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n","dojo/_base/browser":function(){if(require.has){require.has.add("config-selectorEngine","acme");}define("dojo/_base/browser",["../ready","./kernel","./connect","./unload","./window","./event","./html","./NodeList","../query","./xhr","./fx"],function(dojo){return dojo;});},"dijit/form/SimpleTextarea":function(){define("dijit/form/SimpleTextarea",["dojo/_base/declare","dojo/dom-class","dojo/_base/sniff","dojo/_base/window","./TextBox"],function(_400,_401,has,win,_402){return _400("dijit.form.SimpleTextarea",_402,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_401.add(this.textbox,"dijitTextAreaCols");}},filter:function(_403){if(_403){_403=_403.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _404=parseInt(this.maxLength);var _405=this.textbox.value.replace(/\r/g,"");var _406=_405.length-_404;if(_406>0){var _407=this.textbox;if(_407.selectionStart){var pos=_407.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_405.substring(0,pos-_406-cr)+_405.substring(pos-cr);_407.setSelectionRange(pos-_406,pos-_406);}else{if(win.doc.selection){_407.focus();var _408=win.doc.selection.createRange();_408.moveStart("character",-_406);_408.text="";_408.select();}}}}this.inherited(arguments);}});});},"dojo/_base/Deferred":function(){define("dojo/_base/Deferred",["./kernel","./lang"],function(dojo,lang){var _409=function(){};var _40a=Object.freeze||function(){};dojo.Deferred=function(_40b){var _40c,_40d,_40e,head,_40f;var _410=(this.promise={});function _411(_412){if(_40d){throw new Error("This deferred has already been resolved");}_40c=_412;_40d=true;_413();};function _413(){var _414;while(!_414&&_40f){var _415=_40f;_40f=_40f.next;if((_414=(_415.progress==_409))){_40d=false;}var func=(_40e?_415.error:_415.resolved);if(func){try{var _416=func(_40c);if(_416&&typeof _416.then==="function"){_416.then(lang.hitch(_415.deferred,"resolve"),lang.hitch(_415.deferred,"reject"),lang.hitch(_415.deferred,"progress"));continue;}var _417=_414&&_416===undefined;if(_414&&!_417){_40e=_416 instanceof Error;}_415.deferred[_417&&_40e?"reject":"resolve"](_417?_40c:_416);}catch(e){_415.deferred.reject(e);}}else{if(_40e){_415.deferred.reject(_40c);}else{_415.deferred.resolve(_40c);}}}};this.resolve=this.callback=function(_418){this.fired=0;this.results=[_418,null];_411(_418);};this.reject=this.errback=function(_419){_40e=true;this.fired=1;_411(_419);this.results=[null,_419];if(!_419||_419.log!==false){(dojo.config.deferredOnError||function(x){console.error(x);})(_419);}};this.progress=function(_41a){var _41b=_40f;while(_41b){var _41c=_41b.progress;_41c&&_41c(_41a);_41b=_41b.next;}};this.addCallbacks=function(_41d,_41e){this.then(_41d,_41e,_409);return this;};_410.then=this.then=function(_41f,_420,_421){var _422=_421==_409?this:new dojo.Deferred(_410.cancel);var _423={resolved:_41f,error:_420,progress:_421,deferred:_422};if(_40f){head=head.next=_423;}else{_40f=head=_423;}if(_40d){_413();}return _422.promise;};var _424=this;_410.cancel=this.cancel=function(){if(!_40d){var _425=_40b&&_40b(_424);if(!_40d){if(!(_425 instanceof Error)){_425=new Error(_425);}_425.log=false;_424.reject(_425);}}};_40a(_410);};lang.extend(dojo.Deferred,{addCallback:function(_426){return this.addCallbacks(lang.hitch.apply(dojo,arguments));},addErrback:function(_427){return this.addCallbacks(null,lang.hitch.apply(dojo,arguments));},addBoth:function(_428){var _429=lang.hitch.apply(dojo,arguments);return this.addCallbacks(_429,_429);},fired:-1});dojo.Deferred.when=dojo.when=function(_42a,_42b,_42c,_42d){if(_42a&&typeof _42a.then==="function"){return _42a.then(_42b,_42c,_42d);}return _42b?_42b(_42a):_42a;};return dojo.Deferred;});},"dojo/keys":function(){define("dojo/keys",["./_base/kernel","./_base/sniff"],function(dojo,has){return dojo.keys={BACKSPACE:8,TAB:9,CLEAR:12,ENTER:13,SHIFT:16,CTRL:17,ALT:18,META:has("safari")?91:224,PAUSE:19,CAPS_LOCK:20,ESCAPE:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,INSERT:45,DELETE:46,HELP:47,LEFT_WINDOW:91,RIGHT_WINDOW:92,SELECT:93,NUMPAD_0:96,NUMPAD_1:97,NUMPAD_2:98,NUMPAD_3:99,NUMPAD_4:100,NUMPAD_5:101,NUMPAD_6:102,NUMPAD_7:103,NUMPAD_8:104,NUMPAD_9:105,NUMPAD_MULTIPLY:106,NUMPAD_PLUS:107,NUMPAD_ENTER:108,NUMPAD_MINUS:109,NUMPAD_PERIOD:110,NUMPAD_DIVIDE:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,F13:124,F14:125,F15:126,NUM_LOCK:144,SCROLL_LOCK:145,UP_DPAD:175,DOWN_DPAD:176,LEFT_DPAD:177,RIGHT_DPAD:178,copyKey:has("mac")&&!has("air")?(has("safari")?91:224):17};});},"dojox/grid/_RowSelector":function(){define("dojox/grid/_RowSelector",["dojo/_base/declare","./_View"],function(_42e,_42f){return _42e("dojox.grid._RowSelector",_42f,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){this.inherited("buildRendering",arguments);this.scrollboxNode.style.overflow="hidden";this.headerNode.style.visibility="hidden";},getWidth:function(){return this.viewWidth||this.defaultWidth;},buildRowContent:function(_430,_431){var w=this.contentWidth||0;_431.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";},renderHeader:function(){},updateRow:function(){},resize:function(){this.adaptHeight();},adaptWidth:function(){if(!("contentWidth" in this)&&this.contentNode){this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;}},doStyleRowNode:function(_432,_433){var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];if(this.grid.rows.isOver(_432)){n.push("dojoxGridRowbarOver");}if(this.grid.selection.isSelected(_432)){n.push("dojoxGridRowbarSelected");}_433.className=n.join(" ");},domouseover:function(e){this.grid.onMouseOverRow(e);},domouseout:function(e){if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}});});},"dojox/charting/plot2d/Scatter":function(){define("dojox/charting/plot2d/Scatter",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(lang,arr,_434,Base,dc,df,dfr,du,fx,_435){var _436=dfr.lambda("item.purgeGroup()");return _434("dojox.charting.plot2d.Scatter",Base,{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_437,_438){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_438);du.updateWithPattern(this.opt,_438,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_439){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_439);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_436);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_43a=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _43b=t.next("marker",[this.opt,run]),s=run.group,_43c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_43c=arr.map(run.data,function(v,i){return {x:ht(i+1)+_439.l,y:dim.height-_439.b-vt(v)};},this);}else{_43c=arr.map(run.data,function(v,i){return {x:ht(v.x)+_439.l,y:dim.height-_439.b-vt(v.y)};},this);}var _43d=new Array(_43c.length),_43e=new Array(_43c.length),_43f=new Array(_43c.length);arr.forEach(_43c,function(c,i){var _440=typeof run.data[i]=="number"?t.post(_43b,"marker"):t.addMixin(_43b,"marker",run.data[i],true),path="M"+c.x+" "+c.y+" "+_440.symbol;if(_440.marker.shadow){_43d[i]=s.createPath("M"+(c.x+_440.marker.shadow.dx)+" "+(c.y+_440.marker.shadow.dy)+" "+_440.symbol).setStroke(_440.marker.shadow).setFill(_440.marker.shadow.color);if(this.animate){this._animateScatter(_43d[i],dim.height-_439.b);}}if(_440.marker.outline){var _441=dc.makeStroke(_440.marker.outline);_441.width=2*_441.width+_440.marker.stroke.width;_43f[i]=s.createPath(path).setStroke(_441);if(this.animate){this._animateScatter(_43f[i],dim.height-_439.b);}}var _442=dc.makeStroke(_440.marker.stroke),fill=this._plotFill(_440.marker.fill,dim,_439);if(fill&&(fill.type==="linear"||fill.type=="radial")){var _443=_435.getColor(fill,{x:c.x,y:c.y});if(_442){_442.color=_443;}_43e[i]=s.createPath(path).setStroke(_442).setFill(_443);}else{_43e[i]=s.createPath(path).setStroke(_442).setFill(fill);}if(this.animate){this._animateScatter(_43e[i],dim.height-_439.b);}},this);if(_43e.length){run.dyn.stroke=_43e[_43e.length-1].getStroke();run.dyn.fill=_43e[_43e.length-1].getFill();}if(_43a){var _444=new Array(_43e.length);arr.forEach(_43e,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_43f&&_43f[i]||null,shadow:_43d&&_43d[i]||null,cx:_43c[i].x,cy:_43c[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_444[i]=o;},this);this._eventSeries[run.name]=_444;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateScatter:function(_445,_446){fx.animateTransform(lang.delegate({shape:_445,duration:1200,transform:[{name:"translate",start:[0,_446],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/action2d/Base":function(){define("dojox/charting/action2d/Base",["dojo/_base/lang","dojo/_base/declare"],function(lang,_447){return _447("dojox.charting.action2d.Base",null,{constructor:function(_448,plot){this.chart=_448;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/main":function(){define(["./_base/kernel","./has","require","./_base/sniff","./_base/lang","./_base/array","./ready","./_base/declare","./_base/connect","./_base/Deferred","./_base/json","./_base/Color","./has!dojo-firebug?./_firebug/firebug","./_base/browser","./_base/loader"],function(dojo,has,_449,_44a,lang,_44b,_44c){if(dojo.config.isDebug){_449(["./_firebug/firebug"]);}true||has.add("dojo-config-require",1);if(1){var deps=dojo.config.require;if(deps){deps=_44b.map(lang.isArray(deps)?deps:[deps],function(item){return item.replace(/\./g,"/");});if(dojo.isAsync){_449(deps);}else{_44c(1,function(){_449(deps);});}}}return dojo;});},"dojox/charting/plot2d/StackedBars":function(){define("dojox/charting/plot2d/StackedBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_44d,Bars,dc,df,dfr,dfs){var _44e=dfr.lambda("item.purgeGroup()");return _44d("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _44f=dc.collectStackedStats(this.series),t;this._maxRunLength=_44f.hmax;_44f.hmin-=0.5;_44f.hmax+=0.5;t=_44f.hmin,_44f.hmin=_44f.vmin,_44f.vmin=t;t=_44f.hmax,_44f.hmax=_44f.vmax,_44f.vmax=t;return _44f;},render:function(dim,_450){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _451=run.data[j];if(_451!==null){var v=typeof _451=="number"?_451:_451.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_450);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_44e);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_452,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_453=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_452=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _454=t.next("bar",[this.opt,run]),s=run.group,_455=new Array(acc.length);for(var j=0;j<acc.length;++j){var _451=run.data[j];if(_451!==null){var v=acc[j],_456=ht(v),_457=typeof _451!="number"?t.addMixin(_454,"bar",_451,true):t.post(_454,"bar");if(_456>=0&&_452>=1){var rect={x:_450.l,y:dim.height-_450.b-vt(j+1.5)+gap,width:_456,height:_452};var _458=this._plotFill(_457.series.fill,dim,_450);_458=this._shapeFill(_458,rect);var _459=s.createRect(rect).setFill(_458).setStroke(_457.series.stroke);run.dyn.fill=_459.getFill();run.dyn.stroke=_459.getStroke();if(_453){var o={element:"bar",index:j,run:run,shape:_459,x:v,y:j+1.5};this._connectEvents(o);_455[j]=o;}if(this.animate){this._animateBar(_459,_450.l,-_456);}}}}this._eventSeries[run.name]=_455;run.dirty=false;for(var j=0;j<run.data.length;++j){var _451=run.data[j];if(_451!==null){var v=typeof _451=="number"?_451:_451.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojox/grid/_Layout":function(){define("dojox/grid/_Layout",["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_45a,_45b,_45c,lang,_45d){return _45b("dojox.grid._Layout",null,{constructor:function(_45e){this.grid=_45e;},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_45f,_460,_461,_462,_463){var _464=this.structure[_45f].cells[0];var _465=this.structure[_460].cells[0];var cell=null;var _466=0;var _467=0;for(var i=0,c;c=_464[i];i++){if(c.index==_461){_466=i;break;}}cell=_464.splice(_466,1)[0];cell.view=this.grid.views.views[_460];for(i=0,c=null;c=_465[i];i++){if(c.index==_462){_467=i;break;}}if(!_463){_467+=1;}_465.splice(_467,0,cell);var _468=this.grid.getCell(this.grid.getSortIndex());if(_468){_468._currentlySorted=this.grid.getSortAsc();}this.cells=[];_461=0;var v;for(i=0;v=this.structure[i];i++){for(var j=0,cs;cs=v.cells[j];j++){for(var k=0;c=cs[k];k++){c.index=_461;this.cells.push(c);if("_currentlySorted" in c){var si=_461+1;si*=c._currentlySorted?1:-1;this.grid.sortInfo=si;delete c._currentlySorted;}_461++;}}}_45c.forEach(this.cells,function(c){var _469=c.markup[2].split(" ");var _46a=parseInt(_469[1].substring(5));if(_46a!=c.index){_469[1]="idx=\""+c.index+"\"";c.markup[2]=_469.join(" ");}});this.grid.setupHeaderMenu();},setColumnVisibility:function(_46b,_46c){var cell=this.cells[_46b];if(cell.hidden==_46c){cell.hidden=!_46c;var v=cell.view,w=v.viewWidth;if(w&&w!="auto"){v._togglingColumn=_45d.getMarginBox(cell.getHeaderNode()).w||0;}v.update();return true;}else{return false;}},addCellDef:function(_46d,_46e,_46f){var self=this;var _470=function(_471){var w=0;if(_471.colSpan>1){w=0;}else{w=_471.width||self._defaultCellProps.width||self.defaultWidth;if(!isNaN(w)){w=w+"em";}}return w;};var _472={grid:this.grid,subrow:_46d,layoutIndex:_46e,index:this.cells.length};if(_46f&&_46f instanceof _45a.grid.cells._Base){var _473=lang.clone(_46f);_472.unitWidth=_470(_473._props);_473=lang.mixin(_473,this._defaultCellProps,_46f._props,_472);return _473;}var _474=_46f.type||_46f.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_45a.grid.cells.Cell;if(lang.isString(_474)){_474=lang.getObject(_474);}_472.unitWidth=_470(_46f);return new _474(lang.mixin({},this._defaultCellProps,_46f,_472));},addRowDef:function(_475,_476){var _477=[];var _478=0,_479=0,_47a=true;for(var i=0,def,cell;(def=_476[i]);i++){cell=this.addCellDef(_475,i,def);_477.push(cell);this.cells.push(cell);if(_47a&&cell.relWidth){_478+=cell.relWidth;}else{if(cell.width){var w=cell.width;if(typeof w=="string"&&w.slice(-1)=="%"){_479+=window.parseInt(w,10);}else{if(w=="auto"){_47a=false;}}}}}if(_478&&_47a){_45c.forEach(_477,function(cell){if(cell.relWidth){cell.width=cell.unitWidth=((cell.relWidth/_478)*(100-_479))+"%";}});}return _477;},addRowsDef:function(_47b){var _47c=[];if(lang.isArray(_47b)){if(lang.isArray(_47b[0])){for(var i=0,row;_47b&&(row=_47b[i]);i++){_47c.push(this.addRowDef(i,row));}}else{_47c.push(this.addRowDef(0,_47b));}}return _47c;},addViewDef:function(_47d){this._defaultCellProps=_47d.defaultCell||{};if(_47d.width&&_47d.width=="auto"){delete _47d.width;}return lang.mixin({},_47d,{cells:this.addRowsDef(_47d.rows||_47d.cells)});},setStructure:function(_47e){this.fieldIndex=0;this.cells=[];var s=this.structure=[];if(this.grid.rowSelector){var sel={type:_45a._scopeName+".grid._RowSelector"};if(lang.isString(this.grid.rowSelector)){var _47f=this.grid.rowSelector;if(_47f=="false"){sel=null;}else{if(_47f!="true"){sel["width"]=_47f;}}}else{if(!this.grid.rowSelector){sel=null;}}if(sel){s.push(this.addViewDef(sel));}}var _480=function(def){return ("name" in def||"field" in def||"get" in def);};var _481=function(def){if(lang.isArray(def)){if(lang.isArray(def[0])||_480(def[0])){return true;}}return false;};var _482=function(def){return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_480(def))));};if(lang.isArray(_47e)){var _483=false;for(var i=0,st;(st=_47e[i]);i++){if(_482(st)){_483=true;break;}}if(!_483){s.push(this.addViewDef({cells:_47e}));}else{for(i=0;(st=_47e[i]);i++){if(_481(st)){s.push(this.addViewDef({cells:st}));}else{if(_482(st)){s.push(this.addViewDef(st));}}}}}else{if(_482(_47e)){s.push(this.addViewDef(_47e));}}this.cellCount=this.cells.length;this.grid.setupHeaderMenu();}});});},"dojo/data/util/filter":function(){define(["dojo/_base/lang"],function(lang){var _484=lang.getObject("dojo.data.util.filter",true);_484.patternToRegExp=function(_485,_486){var rxp="^";var c=null;for(var i=0;i<_485.length;i++){c=_485.charAt(i);switch(c){case "\\":rxp+=c;i++;rxp+=_485.charAt(i);break;case "*":rxp+=".*";break;case "?":rxp+=".";break;case "$":case "^":case "/":case "+":case ".":case "|":case "(":case ")":case "{":case "}":case "[":case "]":rxp+="\\";default:rxp+=c;}}rxp+="$";if(_486){return new RegExp(rxp,"mi");}else{return new RegExp(rxp,"m");}};return _484;});},"dojo/dnd/common":function(){define(["../main"],function(dojo){dojo.getObject("dnd",true,dojo);dojo.dnd.getCopyKeyState=dojo.isCopyKey;dojo.dnd._uniqueId=0;dojo.dnd.getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++dojo.dnd._uniqueId);}while(dojo.byId(id));return id;};dojo.dnd._empty={};dojo.dnd.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return dojo.dnd;});},"dojox/charting/themes/PlotKit/green":function(){define("dojox/charting/themes/PlotKit/green",["./base","../../Theme"],function(pk,_487){pk.green=pk.base.clone();pk.green.chart.fill=pk.green.plotarea.fill="#eff5e6";pk.green.colors=_487.defineColors({hue:82,saturation:60,low:40,high:88});return pk.green;});},"dijit/tree/ForestStoreModel":function(){define("dijit/tree/ForestStoreModel",["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/window","./TreeStoreModel"],function(_488,_489,lang,win,_48a){return _489("dijit.tree.ForestStoreModel",_48a,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_48b){this.root={store:this,root:true,id:_48b.rootId,label:_48b.rootLabel,children:_48b.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_48c,_48d,_48e){if(_48c===this.root){if(this.root.children){_48d(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_48f){this.root.children=_48f;_48d(_48f);}),onError:_48e});}}else{this.inherited(arguments);}},isItem:function(_490){return (_490===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_491){if(_491.identity==this.root.id){var _492=_491.scope?_491.scope:win.global;if(_491.onItem){_491.onItem.call(_492,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_493,_494){if(_493===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_495,_496,_497,_498,_499){if(_496===this.root){if(!_498){this.onLeaveRoot(_495);}}this.inherited(arguments,[_495,_496===this.root?null:_496,_497===this.root?null:_497,_498,_499]);if(_497===this.root){this.onAddToRoot(_495);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _49a=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_49b){this.root.children=_49b;if(_49a.length!=_49b.length||_488.some(_49a,function(item,idx){return _49b[idx]!=item;})){this.onChildrenChange(this.root,_49b);}})});},onNewItem:function(item,_49c){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_488.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_49d,_49e,_49f){this._requeryTop();this.inherited(arguments);}});});},"dijit/_Calendar":function(){define("dijit/_Calendar",["dojo/_base/kernel","./Calendar","."],function(_4a0,_4a1,_4a2){_4a0.deprecated("dijit._Calendar is deprecated","dijit._Calendar moved to dijit.Calendar",2);_4a2._Calendar=_4a1;});},"dijit/form/TimeTextBox":function(){define("dijit/form/TimeTextBox",["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_4a3,keys,lang,_4a4,_4a5){return _4a3("dijit.form.TimeTextBox",_4a5,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_4a4,_selector:"time",value:new Date(""),_onKey:function(evt){if(this.disabled||this.readOnly){return;}this.inherited(arguments);switch(evt.keyCode){case keys.ENTER:case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:break;default:setTimeout(lang.hitch(this,function(){var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();}),0);}}});});},"dijit/layout/SplitContainer":function(){define("dijit/layout/SplitContainer",["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window","../registry","../_WidgetBase","./_LayoutWidget"],function(_4a6,_4a7,_4a8,dom,_4a9,_4aa,_4ab,_4ac,_4ad,_4ae,lang,on,has,win,_4af,_4b0,_4b1){lang.extend(_4b0,{sizeMin:10,sizeShare:10});return _4a8("dijit.layout.SplitContainer",_4b1,{constructor:function(){_4ae.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){this.inherited("postMixInProperties",arguments);this.isHorizontal=(this.orientation=="horizontal");},postCreate:function(){this.inherited(arguments);this.sizers=[];if(has("mozilla")){this.domNode.style.overflow="-moz-scrollbars-none";}if(typeof this.sizerWidth=="object"){try{this.sizerWidth=parseInt(this.sizerWidth.toString());}catch(e){this.sizerWidth=7;}}var _4b2=win.doc.createElement("div");this.virtualSizer=_4b2;_4b2.style.position="relative";_4b2.style.zIndex=10;_4b2.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";this.domNode.appendChild(_4b2);dom.setSelectable(_4b2,false);},destroy:function(){delete this.virtualSizer;if(this._ownconnects){var h;while(h=this._ownconnects.pop()){h.remove();}}this.inherited(arguments);},startup:function(){if(this._started){return;}_4a6.forEach(this.getChildren(),function(_4b3,i,_4b4){this._setupChild(_4b3);if(i<_4b4.length-1){this._addSizer();}},this);if(this.persist){this._restoreState();}this.inherited(arguments);},_setupChild:function(_4b5){this.inherited(arguments);_4b5.domNode.style.position="absolute";_4a9.add(_4b5.domNode,"dijitSplitPane");},_onSizerMouseDown:function(e){if(e.target.id){for(var i=0;i<this.sizers.length;i++){if(this.sizers[i].id==e.target.id){break;}}if(i<this.sizers.length){this.beginSizing(e,i);}}},_addSizer:function(_4b6){_4b6=_4b6===undefined?this.sizers.length:_4b6;var _4b7=win.doc.createElement("div");_4b7.id=_4af.getUniqueId("dijit_layout_SplitterContainer_Splitter");this.sizers.splice(_4b6,0,_4b7);this.domNode.appendChild(_4b7);_4b7.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";var _4b8=win.doc.createElement("div");_4b8.className="thumb";_4b7.appendChild(_4b8);this.connect(_4b7,"onmousedown","_onSizerMouseDown");dom.setSelectable(_4b7,false);},removeChild:function(_4b9){if(this.sizers.length){var i=_4a6.indexOf(this.getChildren(),_4b9);if(i!=-1){if(i==this.sizers.length){i--;}_4aa.destroy(this.sizers[i]);this.sizers.splice(i,1);}}this.inherited(arguments);if(this._started){this.layout();}},addChild:function(_4ba,_4bb){this.inherited(arguments);if(this._started){var _4bc=this.getChildren();if(_4bc.length>1){this._addSizer(_4bb);}this.layout();}},layout:function(){this.paneWidth=this._contentBox.w;this.paneHeight=this._contentBox.h;var _4bd=this.getChildren();if(!_4bd.length){return;}var _4be=this.isHorizontal?this.paneWidth:this.paneHeight;if(_4bd.length>1){_4be-=this.sizerWidth*(_4bd.length-1);}var _4bf=0;_4a6.forEach(_4bd,function(_4c0){_4bf+=_4c0.sizeShare;});var _4c1=_4be/_4bf;var _4c2=0;_4a6.forEach(_4bd.slice(0,_4bd.length-1),function(_4c3){var size=Math.round(_4c1*_4c3.sizeShare);_4c3.sizeActual=size;_4c2+=size;});_4bd[_4bd.length-1].sizeActual=_4be-_4c2;this._checkSizes();var pos=0;var size=_4bd[0].sizeActual;this._movePanel(_4bd[0],pos,size);_4bd[0].position=pos;pos+=size;if(!this.sizers){return;}_4a6.some(_4bd.slice(1),function(_4c4,i){if(!this.sizers[i]){return true;}this._moveSlider(this.sizers[i],pos,this.sizerWidth);this.sizers[i].position=pos;pos+=this.sizerWidth;size=_4c4.sizeActual;this._movePanel(_4c4,pos,size);_4c4.position=pos;pos+=size;},this);},_movePanel:function(_4c5,pos,size){var box;if(this.isHorizontal){_4c5.domNode.style.left=pos+"px";_4c5.domNode.style.top=0;box={w:size,h:this.paneHeight};if(_4c5.resize){_4c5.resize(box);}else{_4ab.setMarginBox(_4c5.domNode,box);}}else{_4c5.domNode.style.left=0;_4c5.domNode.style.top=pos+"px";box={w:this.paneWidth,h:size};if(_4c5.resize){_4c5.resize(box);}else{_4ab.setMarginBox(_4c5.domNode,box);}}},_moveSlider:function(_4c6,pos,size){if(this.isHorizontal){_4c6.style.left=pos+"px";_4c6.style.top=0;_4ab.setMarginBox(_4c6,{w:size,h:this.paneHeight});}else{_4c6.style.left=0;_4c6.style.top=pos+"px";_4ab.setMarginBox(_4c6,{w:this.paneWidth,h:size});}},_growPane:function(_4c7,pane){if(_4c7>0){if(pane.sizeActual>pane.sizeMin){if((pane.sizeActual-pane.sizeMin)>_4c7){pane.sizeActual=pane.sizeActual-_4c7;_4c7=0;}else{_4c7-=pane.sizeActual-pane.sizeMin;pane.sizeActual=pane.sizeMin;}}}return _4c7;},_checkSizes:function(){var _4c8=0;var _4c9=0;var _4ca=this.getChildren();_4a6.forEach(_4ca,function(_4cb){_4c9+=_4cb.sizeActual;_4c8+=_4cb.sizeMin;});if(_4c8<=_4c9){var _4cc=0;_4a6.forEach(_4ca,function(_4cd){if(_4cd.sizeActual<_4cd.sizeMin){_4cc+=_4cd.sizeMin-_4cd.sizeActual;_4cd.sizeActual=_4cd.sizeMin;}});if(_4cc>0){var list=this.isDraggingLeft?_4ca.reverse():_4ca;_4a6.forEach(list,function(_4ce){_4cc=this._growPane(_4cc,_4ce);},this);}}else{_4a6.forEach(_4ca,function(_4cf){_4cf.sizeActual=Math.round(_4c9*(_4cf.sizeMin/_4c8));});}},beginSizing:function(e,i){var _4d0=this.getChildren();this.paneBefore=_4d0[i];this.paneAfter=_4d0[i+1];this.isSizing=true;this.sizingSplitter=this.sizers[i];if(!this.cover){this.cover=_4aa.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);}else{this.cover.style.zIndex=5;}this.sizingSplitter.style.zIndex=6;this.originPos=_4ab.position(_4d0[0].domNode,true);var _4d1,_4d2;if(this.isHorizontal){_4d1=e.layerX||e.offsetX||0;_4d2=e.pageX;this.originPos=this.originPos.x;}else{_4d1=e.layerY||e.offsetY||0;_4d2=e.pageY;this.originPos=this.originPos.y;}this.startPoint=this.lastPoint=_4d2;this.screenToClientOffset=_4d2-_4d1;this.dragOffset=this.lastPoint-this.paneBefore.sizeActual-this.originPos-this.paneBefore.position;if(!this.activeSizing){this._showSizingLine();}this._ownconnects=[on(win.doc.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(win.doc.documentElement,"mouseup",lang.hitch(this,"endSizing"))];_4ad.stop(e);},changeSizing:function(e){if(!this.isSizing){return;}this.lastPoint=this.isHorizontal?e.pageX:e.pageY;this.movePoint();if(this.activeSizing){this._updateSize();}else{this._moveSizingLine();}_4ad.stop(e);},endSizing:function(){if(!this.isSizing){return;}if(this.cover){this.cover.style.zIndex=-1;}if(!this.activeSizing){this._hideSizingLine();}this._updateSize();this.isSizing=false;if(this.persist){this._saveState(this);}var h;while(h=this._ownconnects.pop()){h.remove();}},movePoint:function(){var p=this.lastPoint-this.screenToClientOffset;var a=p-this.dragOffset;a=this.legaliseSplitPoint(a);p=a+this.dragOffset;this.lastPoint=p+this.screenToClientOffset;},legaliseSplitPoint:function(a){a+=this.sizingSplitter.position;this.isDraggingLeft=!!(a>0);if(!this.activeSizing){var min=this.paneBefore.position+this.paneBefore.sizeMin;if(a<min){a=min;}var max=this.paneAfter.position+(this.paneAfter.sizeActual-(this.sizerWidth+this.paneAfter.sizeMin));if(a>max){a=max;}}a-=this.sizingSplitter.position;this._checkSizes();return a;},_updateSize:function(){var pos=this.lastPoint-this.dragOffset-this.originPos;var _4d3=this.paneBefore.position;var _4d4=this.paneAfter.position+this.paneAfter.sizeActual;this.paneBefore.sizeActual=pos-_4d3;this.paneAfter.position=pos+this.sizerWidth;this.paneAfter.sizeActual=_4d4-this.paneAfter.position;_4a6.forEach(this.getChildren(),function(_4d5){_4d5.sizeShare=_4d5.sizeActual;});if(this._started){this.layout();}},_showSizingLine:function(){this._moveSizingLine();_4ab.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});this.virtualSizer.style.display="block";},_hideSizingLine:function(){this.virtualSizer.style.display="none";},_moveSizingLine:function(){var pos=(this.lastPoint-this.startPoint)+this.sizingSplitter.position;_4ac.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");},_getCookieName:function(i){return this.id+"_"+i;},_restoreState:function(){_4a6.forEach(this.getChildren(),function(_4d6,i){var _4d7=this._getCookieName(i);var _4d8=_4a7(_4d7);if(_4d8){var pos=parseInt(_4d8);if(typeof pos=="number"){_4d6.sizeShare=pos;}}},this);},_saveState:function(){if(!this.persist){return;}_4a6.forEach(this.getChildren(),function(_4d9,i){_4a7(this._getCookieName(i),_4d9.sizeShare,{expires:365});},this);}});});},"dijit/Menu":function(){define("dijit/Menu",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_4da,_4db,_4dc,_4dd,dom,_4de,_4df,_4e0,_4e1,keys,lang,on,has,win,_4e2,pm,_4e3,_4e4){if(!_4e1.isAsync){_4e4(0,function(){var _4e5=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_4da(_4e5);});}return _4dc("dijit.Menu",_4e3,{constructor:function(){this._bindings=[];},targetNodeIds:[],contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(win.body());}else{_4db.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_4e6){return _4e2.get(this._iframeContentDocument(_4e6))||this._iframeContentDocument(_4e6)["__parent__"]||(_4e6.name&&win.doc.frames[_4e6.name])||null;},_iframeContentDocument:function(_4e7){return _4e7.contentDocument||(_4e7.contentWindow&&_4e7.contentWindow.document)||(_4e7.name&&win.doc.frames[_4e7.name]&&win.doc.frames[_4e7.name].document)||null;},bindDomNode:function(node){node=dom.byId(node);var cn;if(node.tagName.toLowerCase()=="iframe"){var _4e8=node,_4e9=this._iframeContentWindow(_4e8);cn=win.withGlobal(_4e9,win.body);}else{cn=(node==win.body()?win.doc.documentElement:node);}var _4ea={node:node,iframe:_4e8};_4de.set(node,"_dijitMenu"+this.id,this._bindings.push(_4ea));var _4eb=lang.hitch(this,function(cn){return [on(cn,this.leftClickToOpen?"click":"contextmenu",lang.hitch(this,function(evt){_4dd.stop(evt);this._scheduleOpen(evt.target,_4e8,{x:evt.pageX,y:evt.pageY});})),on(cn,"keydown",lang.hitch(this,function(evt){if(evt.shiftKey&&evt.keyCode==keys.F10){_4dd.stop(evt);this._scheduleOpen(evt.target,_4e8);}}))];});_4ea.connects=cn?_4eb(cn):[];if(_4e8){_4ea.onloadHandler=lang.hitch(this,function(){var _4ec=this._iframeContentWindow(_4e8);cn=win.withGlobal(_4ec,win.body);_4ea.connects=_4eb(cn);});if(_4e8.addEventListener){_4e8.addEventListener("load",_4ea.onloadHandler,false);}else{_4e8.attachEvent("onload",_4ea.onloadHandler);}}},unBindDomNode:function(_4ed){var node;try{node=dom.byId(_4ed);}catch(e){return;}var _4ee="_dijitMenu"+this.id;if(node&&_4de.has(node,_4ee)){var bid=_4de.get(node,_4ee)-1,b=this._bindings[bid],h;while(h=b.connects.pop()){h.remove();}var _4ef=b.iframe;if(_4ef){if(_4ef.removeEventListener){_4ef.removeEventListener("load",b.onloadHandler,false);}else{_4ef.detachEvent("onload",b.onloadHandler);}}_4de.remove(node,_4ee);delete this._bindings[bid];}},_scheduleOpen:function(_4f0,_4f1,_4f2){if(!this._openTimer){this._openTimer=setTimeout(lang.hitch(this,function(){delete this._openTimer;this._openMyself({target:_4f0,iframe:_4f1,coords:_4f2});}),1);}},_openMyself:function(args){var _4f3=args.target,_4f4=args.iframe,_4f5=args.coords;if(_4f5){if(_4f4){var ifc=_4df.position(_4f4,true),_4f6=this._iframeContentWindow(_4f4),_4f7=win.withGlobal(_4f6,"_docScroll",dojo);var cs=_4e0.getComputedStyle(_4f4),tp=_4e0.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_4f4,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_4f4,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_4f4,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_4f4,cs.borderTopWidth):0);_4f5.x+=ifc.x+left-_4f7.x;_4f5.y+=ifc.y+top-_4f7.y;}}else{_4f5=_4df.position(_4f3,true);_4f5.x+=10;_4f5.y+=10;}var self=this;var _4f8=this._focusManager.get("prevNode");var _4f9=this._focusManager.get("curNode");var _4fa=!_4f9||(dom.isDescendant(_4f9,this.domNode))?_4f8:_4f9;function _4fb(){if(self.refocus&&_4fa){_4fa.focus();}pm.close(self);};pm.open({popup:this,x:_4f5.x,y:_4f5.y,onExecute:_4fb,onCancel:_4fb,orient:this.isLeftToRight()?"L":"R"});this.focus();this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},uninitialize:function(){_4db.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dojo/dom-attr":function(){define(["exports","./_base/sniff","./_base/lang","./dom","./dom-style","./dom-prop"],function(_4fc,has,lang,dom,_4fd,prop){var _4fe={innerHTML:1,className:1,htmlFor:has("ie"),value:1},_4ff={classname:"class",htmlfor:"for",tabindex:"tabIndex",readonly:"readOnly"};function _500(node,name){var attr=node.getAttributeNode&&node.getAttributeNode(name);return attr&&attr.specified;};_4fc.has=function hasAttr(node,name){var lc=name.toLowerCase();return _4fe[prop.names[lc]||name]||_500(dom.byId(node),_4ff[lc]||name);};_4fc.get=function getAttr(node,name){node=dom.byId(node);var lc=name.toLowerCase(),_501=prop.names[lc]||name,_502=_4fe[_501];value=node[_501];if(_502&&typeof value!="undefined"){return value;}if(_501!="href"&&(typeof value=="boolean"||lang.isFunction(value))){return value;}var _503=_4ff[lc]||name;return _500(node,_503)?node.getAttribute(_503):null;};_4fc.set=function setAttr(node,name,_504){node=dom.byId(node);if(arguments.length==2){for(var x in name){_4fc.set(node,x,name[x]);}return node;}var lc=name.toLowerCase(),_505=prop.names[lc]||name,_506=_4fe[_505];if(_505=="style"&&typeof _504!="string"){_4fd.set(node,_504);return node;}if(_506||typeof _504=="boolean"||lang.isFunction(_504)){return prop.set(node,name,_504);}node.setAttribute(_4ff[lc]||name,_504);return node;};_4fc.remove=function removeAttr(node,name){dom.byId(node).removeAttribute(_4ff[name.toLowerCase()]||name);};_4fc.getNodeProp=function getNodeProp(node,name){node=dom.byId(node);var lc=name.toLowerCase(),_507=prop.names[lc]||name;if((_507 in node)&&_507!="href"){return node[_507];}var _508=_4ff[lc]||name;return _500(node,_508)?node.getAttribute(_508):null;};});},"dijit/_base/window":function(){define("dijit/_base/window",["dojo/window",".."],function(_509,_50a){_50a.getDocumentWindow=function(doc){return _509.get(doc);};});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dijit/form/MappedTextBox":function(){define("dijit/form/MappedTextBox",["dojo/_base/declare","dojo/dom-construct","./ValidationTextBox"],function(_50b,_50c,_50d){return _50b("dijit.form.MappedTextBox",_50d,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:null,serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_50c.place("<input type='hidden'"+(this.name?" name='"+this.name.replace(/'/g,"&quot;")+"'":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dojox/grid/util":function(){define("dojox/grid/util",["../main","dojo/_base/lang","dojo/dom"],function(_50e,lang,dom){var dgu=lang.getObject("grid.util",true,_50e);dgu.na="...";dgu.rowIndexTag="gridRowIndex";dgu.gridViewTag="gridView";dgu.fire=function(ob,ev,args){var fn=ob&&ev&&ob[ev];return fn&&(args?fn.apply(ob,args):ob[ev]());};dgu.setStyleHeightPx=function(_50f,_510){if(_510>=0){var s=_50f.style;var v=_510+"px";if(_50f&&s["height"]!=v){s["height"]=v;}}};dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];dgu.keyEvents=["keyup","keydown","keypress"];dgu.funnelEvents=function(_511,_512,_513,_514){var evts=(_514?_514:dgu.mouseEvents.concat(dgu.keyEvents));for(var i=0,l=evts.length;i<l;i++){_512.connect(_511,"on"+evts[i],_513);}};dgu.removeNode=function(_515){_515=dom.byId(_515);_515&&_515.parentNode&&_515.parentNode.removeChild(_515);return _515;};dgu.arrayCompare=function(inA,inB){for(var i=0,l=inA.length;i<l;i++){if(inA[i]!=inB[i]){return false;}}return (inA.length==inB.length);};dgu.arrayInsert=function(_516,_517,_518){if(_516.length<=_517){_516[_517]=_518;}else{_516.splice(_517,0,_518);}};dgu.arrayRemove=function(_519,_51a){_519.splice(_51a,1);};dgu.arraySwap=function(_51b,inI,inJ){var _51c=_51b[inI];_51b[inI]=_51b[inJ];_51b[inJ]=_51c;};return _50e.grid.util;});},"dojox/gfx/arc":function(){define("dojox/gfx/arc",["./_base","dojo/_base/lang","./matrix"],function(g,lang,m){var _51d=2*Math.PI,pi4=Math.PI/4,pi8=Math.PI/8,pi48=pi4+pi8,_51e=_51f(pi8);function _51f(_520){var cosa=Math.cos(_520),sina=Math.sin(_520),p2={x:cosa+(4/3)*(1-cosa),y:sina-(4/3)*cosa*(1-cosa)/sina};return {s:{x:cosa,y:-sina},c1:{x:p2.x,y:-p2.y},c2:p2,e:{x:cosa,y:sina}};};var arc=g.arc={unitArcAsBezier:_51f,curvePI4:_51e,arcAsBezier:function(last,rx,ry,_521,_522,_523,x,y){_522=Boolean(_522);_523=Boolean(_523);var xRot=m._degToRad(_521),rx2=rx*rx,ry2=ry*ry,pa=m.multiplyPoint(m.rotate(-xRot),{x:(last.x-x)/2,y:(last.y-y)/2}),pax2=pa.x*pa.x,pay2=pa.y*pa.y,c1=Math.sqrt((rx2*ry2-rx2*pay2-ry2*pax2)/(rx2*pay2+ry2*pax2));if(isNaN(c1)){c1=0;}var ca={x:c1*rx*pa.y/ry,y:-c1*ry*pa.x/rx};if(_522==_523){ca={x:-ca.x,y:-ca.y};}var c=m.multiplyPoint([m.translate((last.x+x)/2,(last.y+y)/2),m.rotate(xRot)],ca);var _524=m.normalize([m.translate(c.x,c.y),m.rotate(xRot),m.scale(rx,ry)]);var _525=m.invert(_524),sp=m.multiplyPoint(_525,last),ep=m.multiplyPoint(_525,x,y),_526=Math.atan2(sp.y,sp.x),_527=Math.atan2(ep.y,ep.x),_528=_526-_527;if(_523){_528=-_528;}if(_528<0){_528+=_51d;}else{if(_528>_51d){_528-=_51d;}}var _529=pi8,_52a=_51e,step=_523?_529:-_529,_52b=[];for(var _52c=_528;_52c>0;_52c-=pi4){if(_52c<pi48){_529=_52c/2;_52a=_51f(_529);step=_523?_529:-_529;_52c=0;}var c2,e,M=m.normalize([_524,m.rotate(_526+step)]);if(_523){c1=m.multiplyPoint(M,_52a.c1);c2=m.multiplyPoint(M,_52a.c2);e=m.multiplyPoint(M,_52a.e);}else{c1=m.multiplyPoint(M,_52a.c2);c2=m.multiplyPoint(M,_52a.c1);e=m.multiplyPoint(M,_52a.s);}_52b.push([c1.x,c1.y,c2.x,c2.y,e.x,e.y]);_526+=2*step;}return _52b;}};return arc;});},"dojox/grid/_RowManager":function(){define("dojox/grid/_RowManager",["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_52d,lang,_52e){var _52f=function(_530,_531){if(_530.style.cssText==undefined){_530.setAttribute("style",_531);}else{_530.style.cssText=_531;}};return _52d("dojox.grid._RowManager",null,{constructor:function(_532){this.grid=_532;},linesToEms:2,overRow:-2,prepareStylingRow:function(_533,_534){return {index:_533,node:_534,odd:Boolean(_533&1),selected:!!this.grid.selection.isSelected(_533),over:this.isOver(_533),customStyles:"",customClasses:"dojoxGridRow"};},styleRowNode:function(_535,_536){var row=this.prepareStylingRow(_535,_536);this.grid.onStyleRow(row);this.applyStyles(row);},applyStyles:function(_537){var i=_537;i.node.className=i.customClasses;var h=i.node.style.height;_52f(i.node,i.customStyles+";"+(i.node._style||""));i.node.style.height=h;},updateStyles:function(_538){this.grid.updateRowStyles(_538);},setOverRow:function(_539){var last=this.overRow;this.overRow=_539;if((last!=this.overRow)&&(lang.isString(last)||last>=0)){this.updateStyles(last);}this.updateStyles(this.overRow);},isOver:function(_53a){return (this.overRow==_53a&&!_52e.contains(this.grid.domNode,"dojoxGridColumnResizing"));}});});},"dojox/gfx/renderer":function(){define("dojox/gfx/renderer",["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_53b){var _53c=null;return {load:function(id,_53d,load){if(_53c&&id!="force"){load(_53c);return;}var _53e=_53b.forceGfxRenderer,_53f=!_53e&&(lang.isString(_53b.gfxRenderer)?_53b.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_540,_541;while(!_53e&&_53f.length){switch(_53f.shift()){case "svg":if("SVGAngle" in win.global){_53e="svg";}break;case "vml":if(has("ie")){_53e="vml";}break;case "silverlight":try{if(has("ie")){_540=new ActiveXObject("AgControl.AgControl");if(_540&&_540.IsVersionSupported("1.0")){_541=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_541=true;}}}catch(e){_541=false;}finally{_540=null;}if(_541){_53e="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_53e="canvas";}break;}}if(_53e==="canvas"&&_53b.canvasEvents!==false){_53e="canvasWithEvents";}if(_53b.isDebug){}function _542(){_53d(["dojox/gfx/"+_53e],function(_543){g.renderer=_53e;_53c=_543;load(_543);});};if(_53e=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_542);}else{_542();}}};});},"dojo/dnd/Moveable":function(){define(["../main","../Evented","../touch","./Mover"],function(dojo,_544,_545){dojo.declare("dojo.dnd.Moveable",[_544],{handle:"",delay:0,skip:false,constructor:function(node,_546){this.node=dojo.byId(node);if(!_546){_546={};}this.handle=_546.handle?dojo.byId(_546.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_546.delay>0?_546.delay:0;this.skip=_546.skip;this.mover=_546.mover?_546.mover:dojo.dnd.Mover;this.events=[dojo.connect(this.handle,_545.press,this,"onMouseDown"),dojo.connect(this.handle,"ondragstart",this,"onSelectStart"),dojo.connect(this.handle,"onselectstart",this,"onSelectStart")];},markupFactory:function(_547,node,ctor){return new ctor(node,_547);},destroy:function(){dojo.forEach(this.events,dojo.disconnect);this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dojo.dnd.isFormElement(e)){return;}if(this.delay){this.events.push(dojo.connect(this.handle,_545.move,this,"onMouseMove"),dojo.connect(this.handle,_545.release,this,"onMouseUp"));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}dojo.stopEvent(e);},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}dojo.stopEvent(e);},onMouseUp:function(e){for(var i=0;i<2;++i){dojo.disconnect(this.events.pop());}dojo.stopEvent(e);},onSelectStart:function(e){if(!this.skip||!dojo.dnd.isFormElement(e)){dojo.stopEvent(e);}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_548){dojo.publish("/dnd/move/start",[_548]);dojo.addClass(dojo.body(),"dojoMove");dojo.addClass(this.node,"dojoMoveItem");},onMoveStop:function(_549){dojo.publish("/dnd/move/stop",[_549]);dojo.removeClass(dojo.body(),"dojoMove");dojo.removeClass(this.node,"dojoMoveItem");},onFirstMove:function(_54a,e){},onMove:function(_54b,_54c,e){this.onMoving(_54b,_54c);var s=_54b.node.style;s.left=_54c.l+"px";s.top=_54c.t+"px";this.onMoved(_54b,_54c);},onMoving:function(_54d,_54e){},onMoved:function(_54f,_550){}});return dojo.dnd.Moveable;});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../_base/Deferred"],function(_551,lang,_552){var util=lang.getObject("dojo.store.util",true);util.QueryResults=function(_553){if(!_553){return _553;}if(_553.then){_553=lang.delegate(_553);}function _554(_555){if(!_553[_555]){_553[_555]=function(){var args=arguments;return _552.when(_553,function(_556){Array.prototype.unshift.call(args,_556);return util.QueryResults(_551[_555].apply(_551,args));});};}};_554("forEach");_554("filter");_554("map");if(!_553.total){_553.total=_552.when(_553,function(_557){return _557.length;});}return _553;};return util.QueryResults;});},"url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"onclick:_onClick\">\n\t<div role=\"presentation\" class=\"dijitTabInnerDiv\" data-dojo-attach-point=\"innerDiv,focusNode\">\n\t\t<div role=\"presentation\" class=\"dijitTabContent dijitButtonContents\" data-dojo-attach-point=\"tabContent\">\n\t\t\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n\t\t</div>\n\t</div>\n</div>","dijit/form/CheckBox":function(){require({cache:{"url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n"}});define("dijit/form/CheckBox",["require","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom"],function(_558,_559,_55a,_55b,_55c,_55d,_55e,_55f,_560){if(!_55b.isAsync){_55d(0,function(){var _561=["dijit/form/RadioButton"];_558(_561);});}return _559("dijit.form.CheckBox",[_55e,_55f],{templateString:_560,baseClass:"dijitCheckBox",_setValueAttr:function(_562,_563){if(typeof _562=="string"){this._set("value",_562);_55a.set(this.focusNode,"value",_562);_562=true;}if(this._created){this.set("checked",_562,_563);}},_getValueAttr:function(){return (this.checked?this.value:false);},_setIconClassAttr:null,postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting=this.checked?"checked":"";},_fillContent:function(){},_onFocus:function(){if(this.id){_55c("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_55c("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/nls/common":function(){define({root:({buttonOk:"OK",buttonCancel:"Cancel",buttonSave:"Save",itemClose:"Close"}),"zh":true,"zh-tw":true,"tr":true,"th":true,"sv":true,"sl":true,"sk":true,"ru":true,"ro":true,"pt":true,"pt-pt":true,"pl":true,"nl":true,"nb":true,"ko":true,"kk":true,"ja":true,"it":true,"hu":true,"he":true,"fr":true,"fi":true,"es":true,"el":true,"de":true,"da":true,"cs":true,"ca":true,"ar":true});},"dojox/gfx/shape":function(){define("dojox/gfx/shape",["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_564,win,has,_565,arr,_566,_567,_568){var _569=g.shape={};var _56a={};var _56b={};_569.register=function(_56c){var t=_56c.declaredClass.split(".").pop();var i=t in _56a?++_56a[t]:((_56a[t]=0));var uid=t+i;_56b[uid]=_56c;return uid;};_569.byId=function(id){return _56b[id];};_569.dispose=function(_56d){delete _56b[_56d.getUID()];};_564("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;var uid=_569.register(this);this.getUID=function(){return uid;};},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_568;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setShape:function(_56e){this.shape=g.makeParameters(this.shape,_56e);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_56f){if(!_56f){this.strokeStyle=null;return this;}if(typeof _56f=="string"||lang.isArray(_56f)||_56f instanceof _567){_56f={color:_56f};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_56f);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_570){this.matrix=_568.clone(_570?_568.normalize(_570):_568.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_571){return _571?this.setTransform([this.matrix,_571]):this;},applyLeftTransform:function(_572){return _572?this.setTransform([_572,this.matrix]):this;},applyTransform:function(_573){return _573?this.setTransform([this.matrix,_573]):this;},removeShape:function(_574){if(this.parent){this.parent.remove(this,_574);}return this;},_setParent:function(_575,_576){this.parent=_575;return this._updateParentMatrix(_576);},_updateParentMatrix:function(_577){this.parentMatrix=_577?_568.clone(_577):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_568.multiply(p.matrix,m);}p=p.parent;}return m;}});_569._eventsProcessing={connect:function(name,_578,_579){return _565.connect(this.getEventSource(),name,_569.fixCallback(this,g.fixTarget,_578,_579));},disconnect:function(_57a){_565.disconnect(_57a);}};_569.fixCallback=function(_57b,_57c,_57d,_57e){if(!_57e){_57e=_57d;_57d=null;}if(lang.isString(_57e)){_57d=_57d||win.global;if(!_57d[_57e]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_57e,"\"] is null (scope=\"",_57d,"\")"].join(""));}return function(e){return _57c(e,_57b)?_57d[_57e].apply(_57d,arguments||[]):undefined;};}return !_57d?function(e){return _57c(e,_57b)?_57e.apply(_57d,arguments):undefined;}:function(e){return _57c(e,_57b)?_57e.apply(_57d,arguments||[]):undefined;};};lang.extend(_569.Shape,_569._eventsProcessing);_569.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(_57f){var _580=_57f.getParent();if(_580){_580.remove(_57f,true);}this.children.push(_57f);return _57f._setParent(this,this._getRealMatrix());},remove:function(_581,_582){for(var i=0;i<this.children.length;++i){if(this.children[i]==_581){if(_582){}else{_581.parent=null;_581.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(){var _583;for(var i=0;i<this.children.length;++i){_583=this.children[i];_583.parent=null;_583.parentMatrix=null;}this.children=[];return this;},_moveChildToFront:function(_584){for(var i=0;i<this.children.length;++i){if(this.children[i]==_584){this.children.splice(i,1);this.children.push(_584);break;}}return this;},_moveChildToBack:function(_585){for(var i=0;i<this.children.length;++i){if(this.children[i]==_585){this.children.splice(i,1);this.children.unshift(_585);break;}}return this;}};_564("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_566.destroy);this._nodes=[];arr.forEach(this._events,_565.disconnect);this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_566.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_586){},whenLoaded:function(_587,_588){var f=lang.hitch(_587,_588);if(this.isLoaded){f(this);}else{var h=_565.connect(this,"onLoad",function(_589){_565.disconnect(h);f(_589);});}}});lang.extend(_569.Surface,_569._eventsProcessing);_564("dojox.gfx.Point",null,{});_564("dojox.gfx.Rectangle",null,{});_564("dojox.gfx.shape.Rect",_569.Shape,{constructor:function(_58a){this.shape=g.getDefault("Rect");this.rawNode=_58a;},getBoundingBox:function(){return this.shape;}});_564("dojox.gfx.shape.Ellipse",_569.Shape,{constructor:function(_58b){this.shape=g.getDefault("Ellipse");this.rawNode=_58b;},getBoundingBox:function(){if(!this.bbox){var _58c=this.shape;this.bbox={x:_58c.cx-_58c.rx,y:_58c.cy-_58c.ry,width:2*_58c.rx,height:2*_58c.ry};}return this.bbox;}});_564("dojox.gfx.shape.Circle",_569.Shape,{constructor:function(_58d){this.shape=g.getDefault("Circle");this.rawNode=_58d;},getBoundingBox:function(){if(!this.bbox){var _58e=this.shape;this.bbox={x:_58e.cx-_58e.r,y:_58e.cy-_58e.r,width:2*_58e.r,height:2*_58e.r};}return this.bbox;}});_564("dojox.gfx.shape.Line",_569.Shape,{constructor:function(_58f){this.shape=g.getDefault("Line");this.rawNode=_58f;},getBoundingBox:function(){if(!this.bbox){var _590=this.shape;this.bbox={x:Math.min(_590.x1,_590.x2),y:Math.min(_590.y1,_590.y2),width:Math.abs(_590.x2-_590.x1),height:Math.abs(_590.y2-_590.y1)};}return this.bbox;}});_564("dojox.gfx.shape.Polyline",_569.Shape,{constructor:function(_591){this.shape=g.getDefault("Polyline");this.rawNode=_591;},setShape:function(_592,_593){if(_592&&_592 instanceof Array){this.inherited(arguments,[{points:_592}]);if(_593&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_592]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _594=[];for(var i=0;i<l;i+=2){_594.push({x:p[i],y:p[i+1]});}this.shape.points=_594;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_564("dojox.gfx.shape.Image",_569.Shape,{constructor:function(_595){this.shape=g.getDefault("Image");this.rawNode=_595;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_564("dojox.gfx.shape.Text",_569.Shape,{constructor:function(_596){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_596;},getFont:function(){return this.fontStyle;},setFont:function(_597){this.fontStyle=typeof _597=="string"?g.splitFontString(_597):g.makeParameters(g.defaultFont,_597);this._setFont();return this;}});_569.Creator={createShape:function(_598){switch(_598.type){case g.defaultPath.type:return this.createPath(_598);case g.defaultRect.type:return this.createRect(_598);case g.defaultCircle.type:return this.createCircle(_598);case g.defaultEllipse.type:return this.createEllipse(_598);case g.defaultLine.type:return this.createLine(_598);case g.defaultPolyline.type:return this.createPolyline(_598);case g.defaultImage.type:return this.createImage(_598);case g.defaultText.type:return this.createText(_598);case g.defaultTextPath.type:return this.createTextPath(_598);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_599){return this.createObject(g.Ellipse,_599);},createCircle:function(_59a){return this.createObject(g.Circle,_59a);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_59b){return this.createObject(g.Polyline,_59b);},createImage:function(_59c){return this.createObject(g.Image,_59c);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_59d,_59e){return null;}};return _569;});},"dijit/form/DropDownButton":function(){require({cache:{"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\"\n/></span>\n"}});define("dijit/form/DropDownButton",["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_59f,lang,_5a0,_5a1,_5a2,_5a3,_5a4,_5a5,_5a6){return _59f("dijit.form.DropDownButton",[_5a3,_5a4,_5a5],{baseClass:"dijitDropDownButton",templateString:_5a6,_fillContent:function(){if(this.srcNodeRef){var _5a7=_5a0("*",this.srcNodeRef);this.inherited(arguments,[_5a7[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){var _5a8=_5a0("[widgetId]",this.dropDownContainer)[0];this.dropDown=_5a1.byNode(_5a8);delete this.dropDownContainer;}if(this.dropDown){_5a2.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _5a9=this.dropDown;return (!!_5a9&&(!_5a9.href||_5a9.isLoaded));},loadDropDown:function(_5aa){var _5ab=this.dropDown;var _5ac=_5ab.on("load",lang.hitch(this,function(){_5ac.remove();_5aa();}));_5ab.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dijit/_base/scroll":function(){define("dijit/_base/scroll",["dojo/window",".."],function(_5ad,_5ae){_5ae.scrollIntoView=function(node,pos){_5ad.scrollIntoView(node,pos);};});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){lang.getObject("regexp",true,dojo);dojo.regexp.escapeString=function(str,_5af){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){if(_5af&&_5af.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};dojo.regexp.buildGroupRE=function(arr,re,_5b0){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return dojo.regexp.group(b.join("|"),_5b0);};dojo.regexp.group=function(_5b1,_5b2){return "("+(_5b2?"?:":"")+_5b1+")";};return dojo.regexp;});},"dojo/_base/config":function(){define(["../has","require"],function(has,_5b3){var _5b4={};if(1){var src=_5b3.rawConfig,p;for(p in src){_5b4[p]=src[p];}}else{var _5b5=function(_5b6,_5b7,_5b8){for(p in _5b6){p!="has"&&has.add(_5b7+p,_5b6[p],0,_5b8);}};_5b4=1?_5b3.rawConfig:this.dojoConfig||this.djConfig||{};_5b5(_5b4,"config",1);_5b5(_5b4.has,"",1);}return _5b4;});},"dojox/charting/plot2d/ClusteredBars":function(){define("dojox/charting/plot2d/ClusteredBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(lang,arr,_5b9,Bars,dc,df,dfr,du){var _5ba=dfr.lambda("item.purgeGroup()");return _5b9("dojox.charting.plot2d.ClusteredBars",Bars,{render:function(dim,_5bb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_5bb);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_5ba);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_5bc,_5bd,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_5be=Math.max(0,this._hScaler.bounds.lower),_5bf=ht(_5be),_5c0=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_5bc=_5bd=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_5c1=_5bd*(this.series.length-i-1);if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _5c2=t.next("bar",[this.opt,run]),s=run.group,_5c3=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _5c4=run.data[j];if(_5c4!==null){var v=typeof _5c4=="number"?_5c4:_5c4.y,hv=ht(v),_5c5=hv-_5bf,w=Math.abs(_5c5),_5c6=typeof _5c4!="number"?t.addMixin(_5c2,"bar",_5c4,true):t.post(_5c2,"bar");if(w>=0&&_5bc>=1){var rect={x:_5bb.l+(v<_5be?hv:_5bf),y:dim.height-_5bb.b-vt(j+1.5)+gap+_5c1,width:w,height:_5bc};var _5c7=this._plotFill(_5c6.series.fill,dim,_5bb);_5c7=this._shapeFill(_5c7,rect);var _5c8=s.createRect(rect).setFill(_5c7).setStroke(_5c6.series.stroke);run.dyn.fill=_5c8.getFill();run.dyn.stroke=_5c8.getStroke();if(_5c0){var o={element:"bar",index:j,run:run,shape:_5c8,x:v,y:j+1.5};this._connectEvents(o);_5c3[j]=o;}if(this.animate){this._animateBar(_5c8,_5bb.l+_5bf,-_5c5);}}}}this._eventSeries[run.name]=_5c3;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/grid/_FocusManager":function(){define("dojox/grid/_FocusManager",["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_5c9,lang,_5ca,_5cb,_5cc,has,_5cd,util,html){return _5ca("dojox.grid._FocusManager",null,{constructor:function(_5ce){this.grid=_5ce;this.cell=null;this.rowIndex=-1;this._connects=[];this._headerConnects=[];this.headerMenu=this.grid.headerMenu;this._connects.push(_5cb.connect(this.grid.domNode,"onfocus",this,"doFocus"));this._connects.push(_5cb.connect(this.grid.domNode,"onblur",this,"doBlur"));this._connects.push(_5cb.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));this._connects.push(_5cb.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));this._connects.push(_5cb.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));this._connects.push(_5cb.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));this._connects.push(_5cb.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));this._connects.push(_5cb.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));this._connects.push(_5cb.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));},destroy:function(){_5c9.forEach(this._connects,_5cb.disconnect);_5c9.forEach(this._headerConnects,_5cb.disconnect);delete this.grid;delete this.cell;},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];this._initColumnHeaders();},isFocusCell:function(_5cf,_5d0){return (this.cell==_5cf)&&(this.rowIndex==_5d0);},isLastFocusCell:function(){if(this.cell){return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);}return false;},isFirstFocusCell:function(){if(this.cell){return (this.rowIndex===0)&&(this.cell.index===0);}return false;},isNoFocusCell:function(){return (this.rowIndex<0)||!this.cell;},isNavHeader:function(){return (!!this._colHeadNode);},getHeaderIndex:function(){if(this._colHeadNode){return _5c9.indexOf(this._findHeaderCells(),this._colHeadNode);}else{return -1;}},_focusifyCellNode:function(_5d1){var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){html.toggleClass(n,this.focusClass,_5d1);if(_5d1){var sl=this.scrollIntoView();try{if(!this.grid.edit.isEditing()){util.fire(n,"focus");if(sl){this.cell.view.scrollboxNode.scrollLeft=sl;}}}catch(e){}}}},_delayedCellFocus:function(){if(this.isNavHeader()||!this.grid.focused){return;}var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){try{if(!this.grid.edit.isEditing()){html.toggleClass(n,this.focusClass,true);if(this._colHeadNode){this.blurHeader();}util.fire(n,"focus");}}catch(e){}}},_delayedHeaderFocus:function(){if(this.isNavHeader()){this.focusHeader();this.grid.domNode.focus();}},_initColumnHeaders:function(){_5c9.forEach(this._headerConnects,_5cb.disconnect);this._headerConnects=[];var _5d2=this._findHeaderCells();for(var i=0;i<_5d2.length;i++){this._headerConnects.push(_5cb.connect(_5d2[i],"onfocus",this,"doColHeaderFocus"));this._headerConnects.push(_5cb.connect(_5d2[i],"onblur",this,"doColHeaderBlur"));}},_findHeaderCells:function(){var _5d3=_5cd("th",this.grid.viewsHeaderNode);var _5d4=[];for(var i=0;i<_5d3.length;i++){var _5d5=_5d3[i];var _5d6=html.hasAttr(_5d5,"tabIndex");var _5d7=html.attr(_5d5,"tabIndex");if(_5d6&&_5d7<0){_5d4.push(_5d5);}}return _5d4;},_setActiveColHeader:function(_5d8,_5d9,_5da){this.grid.domNode.setAttribute("aria-activedescendant",_5d8.id);if(_5da!=null&&_5da>=0&&_5da!=_5d9){html.toggleClass(this._findHeaderCells()[_5da],this.focusClass,false);}html.toggleClass(_5d8,this.focusClass,true);this._colHeadNode=_5d8;this._colHeadFocusIdx=_5d9;this._scrollHeader(this._colHeadFocusIdx);},scrollIntoView:function(){var info=(this.cell?this._scrollInfo(this.cell):null);if(!info||!info.s){return null;}var rt=this.grid.scroller.findScrollTop(this.rowIndex);if(info.n&&info.sr){if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}}}if(info.r&&info.sr){if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);}else{if(rt<info.sr.t){this.grid.setScrollTop(rt);}}}return info.s.scrollLeft;},_scrollInfo:function(cell,_5db){if(cell){var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);return {c:cl,s:sbn,sr:sbnr,n:(_5db?_5db:cell.getNode(this.rowIndex)),r:rn};}return null;},_scrollHeader:function(_5dc){var info=null;if(this._colHeadNode){var cell=this.grid.getCell(_5dc);if(!cell){return;}info=this._scrollInfo(cell,cell.getNode(0));}if(info&&info.s&&info.sr&&info.n){var _5dd=info.sr.l+info.sr.w;if(info.n.offsetLeft+info.n.offsetWidth>_5dd){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}else{if(has("ie")<=7&&cell&&cell.view.headerNode){cell.view.headerNode.scrollLeft=info.s.scrollLeft;}}}}},_isHeaderHidden:function(){var _5de=this.focusView;if(!_5de){for(var i=0,_5df;(_5df=this.grid.views.views[i]);i++){if(_5df.headerNode){_5de=_5df;break;}}}return (_5de&&html.getComputedStyle(_5de.headerNode).display=="none");},colSizeAdjust:function(e,_5e0,_5e1){var _5e2=this._findHeaderCells();var view=this.focusView;if(!view){for(var i=0,_5e3;(_5e3=this.grid.views.views[i]);i++){if(_5e3.header.tableMap.map){view=_5e3;break;}}}var _5e4=_5e2[_5e0];if(!view||(_5e0==_5e2.length-1&&_5e0===0)){return;}view.content.baseDecorateEvent(e);e.cellNode=_5e4;e.cellIndex=view.content.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);if(view.header.canResize(e)){var _5e5={l:_5e1};var drag=view.header.colResizeSetup(e,false);view.header.doResizeColumn(drag,null,_5e5);view.update();}},styleRow:function(_5e6){return;},setFocusIndex:function(_5e7,_5e8){this.setFocusCell(this.grid.getCell(_5e8),_5e7);},setFocusCell:function(_5e9,_5ea){if(_5e9&&!this.isFocusCell(_5e9,_5ea)){this.tabbingOut=false;if(this._colHeadNode){this.blurHeader();}this._colHeadNode=this._colHeadFocusIdx=null;this.focusGridView();this._focusifyCellNode(false);this.cell=_5e9;this.rowIndex=_5ea;this._focusifyCellNode(true);}if(has("opera")){setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);}else{this.grid.onCellFocus(this.cell,this.rowIndex);}},next:function(){if(this.cell){var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;if(col>cc){col=0;row++;}if(row>rc){col=cc;row=rc;}if(this.grid.edit.isEditing()){var _5eb=this.grid.getCell(col);if(!this.isLastFocusCell()&&(!_5eb.editable||this.grid.canEdit&&!this.grid.canEdit(_5eb,row))){this.cell=_5eb;this.rowIndex=row;this.next();return;}}this.setFocusIndex(row,col);}},previous:function(){if(this.cell){var row=(this.rowIndex||0),col=(this.cell.index||0)-1;if(col<0){col=this.grid.layout.cellCount-1;row--;}if(row<0){row=0;col=0;}if(this.grid.edit.isEditing()){var _5ec=this.grid.getCell(col);if(!this.isFirstFocusCell()&&!_5ec.editable){this.cell=_5ec;this.rowIndex=row;this.previous();return;}}this.setFocusIndex(row,col);}},move:function(_5ed,_5ee){var _5ef=_5ee<0?-1:1;if(this.isNavHeader()){var _5f0=this._findHeaderCells();var _5f1=currentIdx=_5c9.indexOf(_5f0,this._colHeadNode);currentIdx+=_5ee;while(currentIdx>=0&&currentIdx<_5f0.length&&_5f0[currentIdx].style.display=="none"){currentIdx+=_5ef;}if((currentIdx>=0)&&(currentIdx<_5f0.length)){this._setActiveColHeader(_5f0[currentIdx],currentIdx,_5f1);}}else{if(this.cell){var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_5ed));if(_5ed){if(_5ed>0){if(row>sc.getLastPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));}}else{if(_5ed<0){if(row<=sc.getPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));}}}}var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_5ee));var cell=this.grid.getCell(col);while(col>=0&&col<cc&&cell&&cell.hidden===true){col+=_5ef;cell=this.grid.getCell(col);}if(!cell||cell.hidden===true){col=i;}var n=cell.getNode(row);if(!n&&_5ed){if((row+_5ed)>=0&&(row+_5ed)<=rc){this.move(_5ed>0?++_5ed:--_5ed,_5ee);}return;}else{if((!n||html.style(n,"display")==="none")&&_5ee){if((col+_5ed)>=0&&(col+_5ed)<=cc){this.move(_5ed,_5ee>0?++_5ee:--_5ee);}return;}}this.setFocusIndex(row,col);if(_5ed){this.grid.updateRow(r);}}}},previousKey:function(e){if(this.grid.edit.isEditing()){_5cc.stop(e);this.previous();}else{if(!this.isNavHeader()&&!this._isHeaderHidden()){this.grid.domNode.focus();_5cc.stop(e);}else{this.tabOut(this.grid.domNode);if(this._colHeadFocusIdx!=null){html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);this._colHeadFocusIdx=null;}this._focusifyCellNode(false);}}},nextKey:function(e){var _5f2=(this.grid.rowCount===0);if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){this.focusHeader();_5cc.stop(e);}else{if(this.isNavHeader()){this.blurHeader();if(!this.findAndFocusGridCell()){this.tabOut(this.grid.lastFocusNode);}this._colHeadNode=this._colHeadFocusIdx=null;}else{if(this.grid.edit.isEditing()){_5cc.stop(e);this.next();}else{this.tabOut(this.grid.lastFocusNode);}}}},tabOut:function(_5f3){this.tabbingOut=true;_5f3.focus();},focusGridView:function(){util.fire(this.focusView,"focus");},focusGrid:function(_5f4){this.focusGridView();this._focusifyCellNode(true);},findAndFocusGridCell:function(){var _5f5=true;var _5f6=(this.grid.rowCount===0);if(this.isNoFocusCell()&&!_5f6){var _5f7=0;var cell=this.grid.getCell(_5f7);if(cell.hidden){_5f7=this.isNavHeader()?this._colHeadFocusIdx:0;}this.setFocusIndex(0,_5f7);}else{if(this.cell&&!_5f6){if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){this.grid.scrollToRow(this.rowIndex);}this.focusGrid();}else{_5f5=false;}}this._colHeadNode=this._colHeadFocusIdx=null;return _5f5;},focusHeader:function(){var _5f8=this._findHeaderCells();var _5f9=this._colHeadFocusIdx;if(this._isHeaderHidden()){this.findAndFocusGridCell();}else{if(!this._colHeadFocusIdx){if(this.isNoFocusCell()){this._colHeadFocusIdx=0;}else{this._colHeadFocusIdx=this.cell.index;}}}this._colHeadNode=_5f8[this._colHeadFocusIdx];while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_5f8.length&&this._colHeadNode.style.display=="none"){this._colHeadFocusIdx++;this._colHeadNode=_5f8[this._colHeadFocusIdx];}if(this._colHeadNode&&this._colHeadNode.style.display!="none"){if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);this.headerMenu.bindDomNode(this.grid.domNode);this._contextMenuBindNode=this.grid.domNode;}this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_5f9);this._scrollHeader(this._colHeadFocusIdx);this._focusifyCellNode(false);}else{this.findAndFocusGridCell();}},blurHeader:function(){html.removeClass(this._colHeadNode,this.focusClass);html.removeAttr(this.grid.domNode,"aria-activedescendant");if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){var _5fa=this.grid.viewsHeaderNode;this.headerMenu.unBindDomNode(this.grid.domNode);this.headerMenu.bindDomNode(_5fa);this._contextMenuBindNode=_5fa;}},doFocus:function(e){if(e&&e.target!=e.currentTarget){_5cc.stop(e);return;}if(this._clickFocus){return;}if(!this.tabbingOut){this.focusHeader();}this.tabbingOut=false;_5cc.stop(e);},doBlur:function(e){_5cc.stop(e);},doContextMenu:function(e){if(!this.headerMenu){_5cc.stop(e);}},doLastNodeFocus:function(e){if(this.tabbingOut){this._focusifyCellNode(false);}else{if(this.grid.rowCount>0){if(this.isNoFocusCell()){this.setFocusIndex(0,0);}this._focusifyCellNode(true);}else{this.focusHeader();}}this.tabbingOut=false;_5cc.stop(e);},doLastNodeBlur:function(e){_5cc.stop(e);},doColHeaderFocus:function(e){this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);this._scrollHeader(this.getHeaderIndex());_5cc.stop(e);},doColHeaderBlur:function(e){html.toggleClass(e.target,this.focusClass,false);},_mouseDown:function(e){this._clickFocus=dojo.some(this.grid.views.views,function(v){return v.scrollboxNode===e.target;});},_mouseUp:function(e){this._clickFocus=false;}});});},"dijit/_TimePicker":function(){require({cache:{"url:dijit/templates/TimePicker.html":"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n"}});define("dijit/_TimePicker",["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/_base/sniff","dojo/query","dijit/typematic","./_Widget","./_TemplatedMixin","./form/_FormValueWidget","dojo/text!./templates/TimePicker.html"],function(_5fb,_5fc,_5fd,_5fe,_5ff,_600,_601,_602,_603,keys,lang,has,_604,_605,_606,_607,_608,_609){return _5ff("dijit._TimePicker",[_606,_607],{templateString:_609,baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",visibleRange:"T05:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_5fe.toISOString,setValue:function(_60a){_603.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_60a);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_60b,_60c,_60d,_60e){var _60f=[],_610=_60e?_60e.date:this._refDate,n,i=_60b,max=this._maxIncrement+Math.abs(i),chk=_60d?-1:1,dec=_60d?1:0,inc=1-dec;do{i=i-dec;n=this._createOption(i);if(n){if((_60d&&n.date>_610)||(!_60d&&n.date<_610)){break;}_60f[_60d?"unshift":"push"](n);_610=n.date;}i=i+inc;}while(_60f.length<_60c&&(i*chk)<max);return _60f;},_showText:function(){var _611=_5fe.fromISOString;this.timeMenu.innerHTML="";this._clickableIncrementDate=_611(this.clickableIncrement);this._visibleIncrementDate=_611(this.visibleIncrement);this._visibleRangeDate=_611(this.visibleRange);var _612=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_613=_612(this._clickableIncrementDate),_614=_612(this._visibleIncrementDate),_615=_612(this._visibleRangeDate),time=(this.value||this.currentFocus).getTime();this._refDate=new Date(time-time%(_614*1000));this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._totalIncrements=_615/_613;this._visibleIncrement=_614/_613;this._maxIncrement=(60*60*24)/_613;var _616=this._getFilteredNodes(0,Math.min(this._totalIncrements>>1,10)-1),_617=this._getFilteredNodes(0,Math.min(this._totalIncrements,10)-_616.length,true,_616[0]);_5fb.forEach(_617.concat(_616),function(n){this.timeMenu.appendChild(n);},this);},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_618){lang.mixin(this,_618);if(!_618.locale){_618.locale=this.lang;}},postCreate:function(){this.connect(this.timeMenu,has("ie")?"onmousewheel":"DOMMouseScroll","_mouseWheeled");this._connects.push(_605.addMouseListener(this.upArrow,this,"_onArrowUp",33,250));this._connects.push(_605.addMouseListener(this.downArrow,this,"_onArrowDown",33,250));this.inherited(arguments);},_buttonMouse:function(e){_600.toggle(e.currentTarget,e.currentTarget==this.upArrow?"dijitUpArrowHover":"dijitDownArrowHover",e.type=="mouseenter"||e.type=="mouseover");},_createOption:function(_619){var date=new Date(this._refDate);var _61a=this._clickableIncrementDate;date.setHours(date.getHours()+_61a.getHours()*_619,date.getMinutes()+_61a.getMinutes()*_619,date.getSeconds()+_61a.getSeconds()*_619);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _61b=_5fd.format(date,this.constraints);if(this.filterString&&_61b.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=_601.create("div",{"class":this.baseClass+"Item"});div.date=date;div.index=_619;_601.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_61b},div);if(_619%this._visibleIncrement<1&&_619%this._visibleIncrement>-1){_600.add(div,this.baseClass+"Marker");}else{if(!(_619%this._clickableIncrement)){_600.add(div,this.baseClass+"Tick");}}if(this.isDisabledDate(date)){_600.add(div,this.baseClass+"ItemDisabled");}if(this.value&&!_5fc.compare(this.value,date,this.constraints.selector)){div.selected=true;_600.add(div,this.baseClass+"ItemSelected");if(_600.contains(div,this.baseClass+"Marker")){_600.add(div,this.baseClass+"MarkerSelected");}else{_600.add(div,this.baseClass+"TickSelected");}this._highlightOption(div,true);}return div;},_onOptionSelected:function(tgt){var _61c=tgt.target.date||tgt.target.parentNode.date;if(!_61c||this.isDisabledDate(_61c)){return;}this._highlighted_option=null;this.set("value",_61c);this.onChange(_61c);},onChange:function(){},_highlightOption:function(node,_61d){if(!node){return;}if(_61d){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_600.toggle(node,this.baseClass+"ItemHover",_61d);if(_600.contains(node,this.baseClass+"Marker")){_600.toggle(node,this.baseClass+"MarkerHover",_61d);}else{_600.toggle(node,this.baseClass+"TickHover",_61d);}},onmouseover:function(e){this._keyboardSelected=null;var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;if(!_600.contains(tgr,this.baseClass+"Item")){return;}this._highlightOption(tgr,true);},onmouseout:function(e){this._keyboardSelected=null;var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;this._highlightOption(tgr,false);},_mouseWheeled:function(e){this._keyboardSelected=null;_602.stop(e);var _61e=(has("ie")?e.wheelDelta:-e.detail);this[(_61e>0?"_onArrowUp":"_onArrowDown")]();},_onArrowUp:function(_61f){if(typeof _61f=="number"&&_61f==-1){return;}if(!this.timeMenu.childNodes.length){return;}var _620=this.timeMenu.childNodes[0].index;var divs=this._getFilteredNodes(_620,1,true,this.timeMenu.childNodes[0]);if(divs.length){this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);this.timeMenu.insertBefore(divs[0],this.timeMenu.childNodes[0]);}},_onArrowDown:function(_621){if(typeof _621=="number"&&_621==-1){return;}if(!this.timeMenu.childNodes.length){return;}var _622=this.timeMenu.childNodes[this.timeMenu.childNodes.length-1].index+1;var divs=this._getFilteredNodes(_622,1,false,this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);if(divs.length){this.timeMenu.removeChild(this.timeMenu.childNodes[0]);this.timeMenu.appendChild(divs[0]);}},handleKey:function(e){if(e.charOrCode==keys.DOWN_ARROW||e.charOrCode==keys.UP_ARROW){_602.stop(e);if(this._highlighted_option&&!this._highlighted_option.parentNode){this._highlighted_option=null;}var _623=this.timeMenu,tgt=this._highlighted_option||_604("."+this.baseClass+"ItemSelected",_623)[0];if(!tgt){tgt=_623.childNodes[0];}else{if(_623.childNodes.length){if(e.charOrCode==keys.DOWN_ARROW&&!tgt.nextSibling){this._onArrowDown();}else{if(e.charOrCode==keys.UP_ARROW&&!tgt.previousSibling){this._onArrowUp();}}if(e.charOrCode==keys.DOWN_ARROW){tgt=tgt.nextSibling;}else{tgt=tgt.previousSibling;}}}this._highlightOption(tgt,true);this._keyboardSelected=tgt;return false;}else{if(e.charOrCode==keys.ENTER||e.charOrCode===keys.TAB){if(!this._keyboardSelected&&e.charOrCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option});}return e.charOrCode===keys.TAB;}}}});});},"dojox/charting/action2d/Highlight":function(){define("dojox/charting/action2d/Highlight",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(dojo,lang,_624,_625,hub,c,_626,dfe,dgf){var _627=100,_628=75,_629=50,cc=function(_62a){return function(){return _62a;};},hl=function(_62b){var a=new c.Color(_62b),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_627;if(x.l<_629){x.l=_628;}else{if(x.l>_628){x.l=_629;}else{x.l=x.l-_629>_628-x.l?_629:_628;}}}return c.fromHsl(x);};return _624("dojox.charting.action2d.Highlight",_626,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_62c,plot,_62d){var a=_62d&&_62d.highlight;this.colorFun=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _62e=o.run.name,_62f=o.index,anim,_630,_631;if(_62e in this.anim){anim=this.anim[_62e][_62f];}else{this.anim[_62e]={};}if(anim){anim.action.stop(true);}else{var _632=o.shape.getFill();if(!_632||!(_632 instanceof _625)){return;}this.anim[_62e][_62f]=anim={start:_632,end:this.colorFun(_632)};}var _633=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_633;_633=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_633,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_62e]){delete this.anim[_62e][_62f];}});}anim.action.play();}});});},"dojo/Evented":function(){define(["./aspect","./on"],function(_634,on){"use strict";var _635=_634.after;function _636(){};_636.prototype={on:function(type,_637){return on.parse(this,type,_637,function(_638,type){return _635(_638,"on"+type,_637,true);});},emit:function(type,_639){var args=[this];args.push.apply(args,arguments);return on.emit.apply(on,args);}};return _636;});},"dojo/dnd/Avatar":function(){define(["../main","./common"],function(dojo){dojo.declare("dojo.dnd.Avatar",null,{constructor:function(_63a){this.manager=_63a;this.construct();},construct:function(){this.isA11y=dojo.hasClass(dojo.body(),"dijit_a11y");var a=dojo.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_63b=this.manager.source,node,b=dojo.create("tbody",null,a),tr=dojo.create("tr",null,b),td=dojo.create("td",null,tr),icon=this.isA11y?dojo.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td):null,span=dojo.create("span",{innerHTML:_63b.generateText?this._generateText():""},td),k=Math.min(5,this.manager.nodes.length),i=0;dojo.attr(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});for(;i<k;++i){if(_63b.creator){node=_63b._normalizedCreator(_63b.getItem(this.manager.nodes[i].id).data,"avatar").node;}else{node=this.manager.nodes[i].cloneNode(true);if(node.tagName.toLowerCase()=="tr"){var _63c=dojo.create("table"),_63d=dojo.create("tbody",null,_63c);_63d.appendChild(node);node=_63c;}}node.id="";tr=dojo.create("tr",null,b);td=dojo.create("td",null,tr);td.appendChild(node);dojo.attr(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});}this.node=a;},destroy:function(){dojo.destroy(this.node);this.node=false;},update:function(){dojo[(this.manager.canDropFlag?"add":"remove")+"Class"](this.node,"dojoDndAvatarCanDrop");if(this.isA11y){var icon=dojo.byId("a11yIcon");var text="+";if(this.manager.canDropFlag&&!this.manager.copy){text="< ";}else{if(!this.manager.canDropFlag&&!this.manager.copy){text="o";}else{if(!this.manager.canDropFlag){text="x";}}}icon.innerHTML=text;}dojo.query(("tr.dojoDndAvatarHeader td span"+(this.isA11y?" span":"")),this.node).forEach(function(node){node.innerHTML=this._generateText();},this);},_generateText:function(){return this.manager.nodes.length.toString();}});return dojo.dnd.Avatar;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){lang.getObject("string",true,dojo);dojo.string.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};dojo.string.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=dojo.string.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};dojo.string.substitute=function(_63e,map,_63f,_640){_640=_640||dojo.global;_63f=_63f?lang.hitch(_640,_63f):function(v){return v;};return _63e.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_641,key,_642){var _643=lang.getObject(key,false,map);if(_642){_643=lang.getObject(_642,false,_640).call(_640,_643,key);}return _63f(_643,key).toString();});};dojo.string.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return dojo.string;});},"dijit/_Contained":function(){define("dijit/_Contained",["dojo/_base/declare","./registry"],function(_644,_645){return _644("dijit._Contained",null,{_getSibling:function(_646){var node=this.domNode;do{node=node[_646+"Sibling"];}while(node&&node.nodeType!=1);return node&&_645.byNode(node);},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dojox/charting/scaler/common":function(){define("dojox/charting/scaler/common",["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _647=lang.getObject("dojox.charting.scaler.common",true);var _648={};return lang.mixin(_647,{doIfLoaded:function(_649,_64a,_64b){if(_648[_649]==undefined){try{_648[_649]=require(_649);}catch(e){_648[_649]=null;}}if(_648[_649]){return _64a(_648[_649]);}else{return _64b();}},findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}return false;},getNumericLabel:function(_64c,_64d,_64e){var def="";_647.doIfLoaded("dojo/number",function(_64f){def=(_64e.fixed?_64f.format(_64c,{places:_64d<0?-_64d:0}):_64f.format(_64c))||"";},function(){def=_64e.fixed?_64c.toFixed(_64d<0?-_64d:0):_64c.toString();});if(_64e.labelFunc){var r=_64e.labelFunc(def,_64c,_64d);if(r){return r;}}if(_64e.labels){var l=_64e.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_64c){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_64c)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_64c)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_64c)){return l[lo].text;}}return def;}});});},"dojox/grid/_Builder":function(){define("dojox/grid/_Builder",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html"],function(_650,_651,lang,win,_652,has,_653,_654,_655,util,html){var dg=_650.grid;var _656=function(td){return td.cellIndex>=0?td.cellIndex:_651.indexOf(td.parentNode.cells,td);};var _657=function(tr){return tr.rowIndex>=0?tr.rowIndex:_651.indexOf(tr.parentNode.childNodes,tr);};var _658=function(_659,_65a){return _659&&((_659.rows||0)[_65a]||_659.childNodes[_65a]);};var _65b=function(node){for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){}return n;};var _65c=function(_65d,_65e){for(var n=_65d;n&&_65e(n);n=n.parentNode){}return n;};var _65f=function(_660){var name=_660.toUpperCase();return function(node){return node.tagName!=name;};};var _661=util.rowIndexTag;var _662=util.gridViewTag;var _663=dg._Builder=lang.extend(function(view){if(view){this.view=view;this.grid=view.grid;}},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){var html=[this._table];if(this.view.viewWidth){html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));}html.push(">");return html;},generateCellMarkup:function(_664,_665,_666,_667){var _668=[],html;if(_667){var _669=_664.index!=_664.grid.getSortIndex()?"":_664.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";if(!_664.id){_664.id=this.grid.id+"Hdr"+_664.index;}html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_669,"id=\"",_664.id,"\""];}else{var _66a=this.grid.editable&&!_664.editable?"aria-readonly=\"true\"":"";html=["<td tabIndex=\"-1\" role=\"gridcell\"",_66a];}if(_664.colSpan){html.push(" colspan=\"",_664.colSpan,"\"");}if(_664.rowSpan){html.push(" rowspan=\"",_664.rowSpan,"\"");}html.push(" class=\"dojoxGridCell ");if(_664.classes){html.push(_664.classes," ");}if(_666){html.push(_666," ");}_668.push(html.join(""));_668.push("");html=["\" idx=\"",_664.index,"\" style=\""];if(_665&&_665[_665.length-1]!=";"){_665+=";";}html.push(_664.styles,_665||"",_664.hidden?"display:none;":"");if(_664.unitWidth){html.push("width:",_664.unitWidth,";");}_668.push(html.join(""));_668.push("");html=["\""];if(_664.attrs){html.push(" ",_664.attrs);}html.push(">");_668.push(html.join(""));_668.push("");_668.push(_667?"</th>":"</td>");return _668;},isCellNode:function(_66b){return Boolean(_66b&&_66b!=win.doc&&html.attr(_66b,"idx"));},getCellNodeIndex:function(_66c){return _66c?Number(html.attr(_66c,"idx")):-1;},getCellNode:function(_66d,_66e){for(var i=0,row;((row=_658(_66d.firstChild,i))&&row.cells);i++){for(var j=0,cell;(cell=row.cells[j]);j++){if(this.getCellNodeIndex(cell)==_66e){return cell;}}}return null;},findCellTarget:function(_66f,_670){var n=_66f;while(n&&(!this.isCellNode(n)||(n.offsetParent&&_662 in n.offsetParent.parentNode&&n.offsetParent.parentNode[_662]!=this.view.id))&&(n!=_670)){n=n.parentNode;}return n!=_670?n:null;},baseDecorateEvent:function(e){e.dispatch="do"+e.type;e.grid=this.grid;e.sourceView=this.view;e.cellNode=this.findCellTarget(e.target,e.rowNode);e.cellIndex=this.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);},findTarget:function(_671,_672){var n=_671;while(n&&(n!=this.domNode)&&(!(_672 in n)||(_662 in n&&n[_662]!=this.view.id))){n=n.parentNode;}return (n!=this.domNode)?n:null;},findRowTarget:function(_673){return this.findTarget(_673,_661);},isIntraNodeEvent:function(e){try{return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));}catch(x){return false;}},isIntraRowEvent:function(e){try{var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);}catch(x){return false;}},dispatchEvent:function(e){if(e.dispatch in this){return this[e.dispatch](e);}return false;},domouseover:function(e){if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){this.lastOverCellNode=e.cellNode;this.grid.onMouseOver(e);}this.grid.onMouseOverRow(e);},domouseout:function(e){if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){this.lastOverCellNode=null;this.grid.onMouseOut(e);if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}},domousedown:function(e){if(e.cellNode){this.grid.onMouseDown(e);}this.grid.onMouseDownRow(e);}});var _674=dg._ContentBuilder=lang.extend(function(view){_663.call(this,view);},_663.prototype,{update:function(){this.prepareHtml();},prepareHtml:function(){var _675=this.grid.get,_676=this.view.structure.cells;for(var j=0,row;(row=_676[j]);j++){for(var i=0,cell;(cell=row[i]);i++){cell.get=cell.get||(cell.value==undefined)&&_675;cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);if(!this.grid.editable&&cell.editable){this.grid.editable=true;}}}},generateHtml:function(_677,_678){var html=this.getTableArray(),v=this.view,_679=v.structure.cells,item=this.grid.getItem(_678);util.fire(this.view,"onBeforeRow",[_678,_679]);for(var j=0,row;(row=_679[j]);j++){if(row.hidden||row.header){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){m=cell.markup;cc=cell.customClasses=[];cs=cell.customStyles=[];m[5]=cell.format(_678,item);if(has("ie")<8&&(m[5]===null||m[5]===""||/^\s+$/.test(m[5]))){m[5]="&nbsp;";}m[1]=cc.join(" ");m[3]=cs.join(";");html.push.apply(html,m);}html.push("</tr>");}html.push("</table>");return html.join("");},decorateEvent:function(e){e.rowNode=this.findRowTarget(e.target);if(!e.rowNode){return false;}e.rowIndex=e.rowNode[_661];this.baseDecorateEvent(e);e.cell=this.grid.getCell(e.cellIndex);return true;}});var _67a=dg._HeaderBuilder=lang.extend(function(view){this.moveable=null;_663.call(this,view);},_663.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){if(this.tableMap){this.tableMap.mapRows(this.view.structure.cells);}else{this.tableMap=new dg._TableMap(this.view.structure.cells);}},generateHtml:function(_67b,_67c){var html=this.getTableArray(),_67d=this.view.structure.cells;util.fire(this.view,"onBeforeRow",[-1,_67d]);for(var j=0,row;(row=_67d[j]);j++){if(row.hidden){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,_67e;(cell=row[i]);i++){cell.customClasses=[];cell.customStyles=[];if(this.view.simpleStructure){if(cell.draggable){if(cell.headerClasses){if(cell.headerClasses.indexOf("dojoDndItem")==-1){cell.headerClasses+=" dojoDndItem";}}else{cell.headerClasses="dojoDndItem";}}if(cell.attrs){if(cell.attrs.indexOf("dndType='gridColumn_")==-1){cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";}}else{cell.attrs="dndType='gridColumn_"+this.grid.id+"'";}}_67e=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);_67e[5]=(_67c!=undefined?_67c:_67b(cell));_67e[3]=cell.customStyles.join(";");_67e[1]=cell.customClasses.join(" ");html.push(_67e.join(""));}html.push("</tr>");}html.push("</table>");return html.join("");},getCellX:function(e){var n,x=e.layerX;if(has("mozilla")||has("ie")>=9){n=_65c(e.target,_65f("th"));x-=(n&&n.offsetLeft)||0;var t=e.sourceView.getScrollbarWidth();if(!this.grid.isLeftToRight()){table=_65c(n,_65f("table"));x-=(table&&table.offsetLeft)||0;}}n=_65c(e.target,function(){if(!n||n==e.cellNode){return false;}x+=(n.offsetLeft<0?0:n.offsetLeft);return true;});return x;},decorateEvent:function(e){this.baseDecorateEvent(e);e.rowIndex=-1;e.cellX=this.getCellX(e);return true;},prepareResize:function(e,mod){do{var i=e.cellIndex;e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);}while(e.cellNode&&e.cellNode.style.display=="none");return Boolean(e.cellNode);},canResize:function(e){if(!e.cellNode||e.cellNode.colSpan>1){return false;}var cell=this.grid.getCell(e.cellIndex);return !cell.noresize&&cell.canResize();},overLeftResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);}var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);return t;},overRightResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);}return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);},domousemove:function(e){if(!this.moveable){var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));if(c&&!this.canResize(e)){c="dojoxGridColNoResize";}html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));if(c){_652.stop(e);}}},domousedown:function(e){if(!this.moveable){if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){this.beginColumnResize(e);}else{this.grid.onMouseDown(e);this.grid.onMouseOverRow(e);}}},doclick:function(e){if(this._skipBogusClicks){_652.stop(e);return true;}return false;},colResizeSetup:function(e,_67f){var _680=html.contentBox(e.sourceView.headerNode);if(_67f){this.lineDiv=document.createElement("div");var vw=html.position(e.sourceView.headerNode,true);var _681=html.contentBox(e.sourceView.domNode);var l=e.pageX;if(!this.grid.isLeftToRight()&&has("ie")<8){l-=_655.getScrollbar().w;}html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_681.h+_680.h)+"px"});html.addClass(this.lineDiv,"dojoxGridResizeColLine");this.lineDiv._origLeft=l;win.body().appendChild(this.lineDiv);}var _682=[],_683=this.tableMap.findOverlappingNodes(e.cellNode);for(var i=0,cell;(cell=_683[i]);i++){_682.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});}var view=e.sourceView;var adj=this.grid.isLeftToRight()?1:-1;var _684=e.grid.views.views;var _685=[];for(var j=view.idx+adj,_686;(_686=_684[j]);j=j+adj){_685.push({node:_686.headerNode,left:window.parseInt(_686.headerNode.style.left)});}var _687=view.headerContentNode.firstChild;var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_680.w,table:_687,tw:html.contentBox(_687).w,spanners:_682,followers:_685};return drag;},beginColumnResize:function(e){this.moverDiv=document.createElement("div");html.style(this.moverDiv,{position:"absolute",left:0});win.body().appendChild(this.moverDiv);html.addClass(this.grid.domNode,"dojoxGridColumnResizing");var m=(this.moveable=new _654(this.moverDiv));var drag=this.colResizeSetup(e,true);m.onMove=lang.hitch(this,"doResizeColumn",drag);_653.connect(m,"onMoveStop",lang.hitch(this,function(){this.endResizeColumn(drag);if(drag.node.releaseCapture){drag.node.releaseCapture();}this.moveable.destroy();delete this.moveable;this.moveable=null;html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");}));if(e.cellNode.setCapture){e.cellNode.setCapture();}m.onMouseDown(e);},doResizeColumn:function(_688,_689,_68a){var _68b=_68a.l;var data={deltaX:_68b,w:_688.w+(this.grid.isLeftToRight()?_68b:-_68b),vw:_688.vw+_68b,tw:_688.tw+_68b};this.dragRecord={inDrag:_688,mover:_689,leftTop:_68a};if(data.w>=this.minColWidth){if(!_689){this.doResizeNow(_688,data);}else{html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");}}},endResizeColumn:function(_68c){if(this.dragRecord){var _68d=this.dragRecord.leftTop;var _68e=this.grid.isLeftToRight()?_68d.l:-_68d.l;_68e+=Math.max(_68c.w+_68e,this.minColWidth)-(_68c.w+_68e);if(has("webkit")&&_68c.spanners.length){_68e+=html._getPadBorderExtents(_68c.spanners[0].node).w;}var data={deltaX:_68e,w:_68c.w+_68e,vw:_68c.vw+_68e,tw:_68c.tw+_68e};this.doResizeNow(_68c,data);delete this.dragRecord;}html.destroy(this.lineDiv);html.destroy(this.moverDiv);html.destroy(this.moverDiv);delete this.moverDiv;this._skipBogusClicks=true;_68c.view.update();this._skipBogusClicks=false;this.grid.onResizeColumn(_68c.index);},doResizeNow:function(_68f,data){_68f.view.convertColPctToFixed();if(_68f.view.flexCells&&!_68f.view.testFlexCells()){var t=_65b(_68f.node);if(t){(t.style.width="");}}var i,s,sw,f,fl;for(i=0;(s=_68f.spanners[i]);i++){sw=s.width+data.deltaX;if(sw>0){s.node.style.width=sw+"px";_68f.view.setColWidth(s.index,sw);}}if(this.grid.isLeftToRight()||!has("ie")){for(i=0;(f=_68f.followers[i]);i++){fl=f.left+data.deltaX;f.node.style.left=fl+"px";}}_68f.node.style.width=data.w+"px";_68f.view.setColWidth(_68f.index,data.w);_68f.view.headerNode.style.width=data.vw+"px";_68f.view.setColumnsWidth(data.tw);if(!this.grid.isLeftToRight()){_68f.view.headerNode.scrollLeft=_68f.scrollLeft+data.deltaX;}}});dg._TableMap=lang.extend(function(rows){this.mapRows(rows);},{map:null,mapRows:function(_690){var _691=_690.length;if(!_691){return;}this.map=[];var row;for(var k=0;(row=_690[k]);k++){this.map[k]=[];}for(var j=0;(row=_690[j]);j++){for(var i=0,x=0,cell,_692,_693;(cell=row[i]);i++){while(this.map[j][x]){x++;}this.map[j][x]={c:i,r:j};_693=cell.rowSpan||1;_692=cell.colSpan||1;for(var y=0;y<_693;y++){for(var s=0;s<_692;s++){this.map[j+y][x+s]=this.map[j][x];}}x+=_692;}}},dumpMap:function(){for(var j=0,row,h="";(row=this.map[j]);j++,h=""){for(var i=0,cell;(cell=row[i]);i++){h+=cell.r+","+cell.c+"   ";}}},getMapCoords:function(_694,_695){for(var j=0,row;(row=this.map[j]);j++){for(var i=0,cell;(cell=row[i]);i++){if(cell.c==_695&&cell.r==_694){return {j:j,i:i};}}}return {j:-1,i:-1};},getNode:function(_696,_697,_698){var row=_696&&_696.rows[_697];return row&&row.cells[_698];},_findOverlappingNodes:function(_699,_69a,_69b){var _69c=[];var m=this.getMapCoords(_69a,_69b);for(var j=0,row;(row=this.map[j]);j++){if(j==m.j){continue;}var rw=row[m.i];var n=(rw?this.getNode(_699,rw.r,rw.c):null);if(n){_69c.push(n);}}return _69c;},findOverlappingNodes:function(_69d){return this._findOverlappingNodes(_65b(_69d),_657(_69d.parentNode),_656(_69d));}});return {_Builder:_663,_HeaderBuilder:_67a,_ContentBuilder:_674};});},"dojox/fx/_base":function(){define("dojox/fx/_base",["dojo/_base/array","dojo/_base/lang","dojo/_base/fx","dojo/fx","dojo/dom","dojo/dom-style","dojo/dom-geometry","dojo/_base/connect","dojo/_base/html"],function(_69e,lang,_69f,_6a0,dom,_6a1,_6a2,_6a3,_6a4){var _6a5=lang.getObject("dojox.fx",true);_6a5.sizeTo=function(args){var node=args.node=dom.byId(args.node),abs="absolute";var _6a6=args.method||"chain";if(!args.duration){args.duration=500;}if(_6a6=="chain"){args.duration=Math.floor(args.duration/2);}var top,_6a7,left,_6a8,_6a9,_6aa=null;var init=(function(n){return function(){var cs=_6a1.getComputedStyle(n),pos=cs.position,w=cs.width,h=cs.height;top=(pos==abs?n.offsetTop:parseInt(cs.top)||0);left=(pos==abs?n.offsetLeft:parseInt(cs.left)||0);_6a9=(w=="auto"?0:parseInt(w));_6aa=(h=="auto"?0:parseInt(h));_6a8=left-Math.floor((args.width-_6a9)/2);_6a7=top-Math.floor((args.height-_6aa)/2);if(pos!=abs&&pos!="relative"){var ret=_6a1.coords(n,true);top=ret.y;left=ret.x;n.style.position=abs;n.style.top=top+"px";n.style.left=left+"px";}};})(node);var _6ab=_69f.animateProperty(lang.mixin({properties:{height:function(){init();return {end:args.height||0,start:_6aa};},top:function(){return {start:top,end:_6a7};}}},args));var _6ac=_69f.animateProperty(lang.mixin({properties:{width:function(){return {start:_6a9,end:args.width||0};},left:function(){return {start:left,end:_6a8};}}},args));var anim=_6a0[(args.method=="combine"?"combine":"chain")]([_6ab,_6ac]);return anim;};_6a5.slideBy=function(args){var node=args.node=dom.byId(args.node),top,left;var init=(function(n){return function(){var cs=_6a1.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=_6a2.coords(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var _6ad=_69f.animateProperty(lang.mixin({properties:{top:top+(args.top||0),left:left+(args.left||0)}},args));_6a3.connect(_6ad,"beforeBegin",_6ad,init);return _6ad;};_6a5.crossFade=function(args){var _6ae=args.nodes[0]=dom.byId(args.nodes[0]),op1=_6a4.style(_6ae,"opacity"),_6af=args.nodes[1]=dom.byId(args.nodes[1]),op2=_6a4.style(_6af,"opacity");var _6b0=_6a0.combine([_69f[(op1==0?"fadeIn":"fadeOut")](lang.mixin({node:_6ae},args)),_69f[(op1==0?"fadeOut":"fadeIn")](lang.mixin({node:_6af},args))]);return _6b0;};_6a5.highlight=function(args){var node=args.node=dom.byId(args.node);args.duration=args.duration||400;var _6b1=args.color||"#ffff99",_6b2=_6a4.style(node,"backgroundColor");if(_6b2=="rgba(0, 0, 0, 0)"){_6b2="transparent";}var anim=_69f.animateProperty(lang.mixin({properties:{backgroundColor:{start:_6b1,end:_6b2}}},args));if(_6b2=="transparent"){_6a3.connect(anim,"onEnd",anim,function(){node.style.backgroundColor=_6b2;});}return anim;};_6a5.wipeTo=function(args){args.node=dom.byId(args.node);var node=args.node,s=node.style;var dir=(args.width?"width":"height"),_6b3=args[dir],_6b4={};_6b4[dir]={start:function(){s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s[dir]="1px";s.display="";s.visibility="";return 1;}else{var now=_6a4.style(node,dir);return Math.max(now,1);}},end:_6b3};var anim=_69f.animateProperty(lang.mixin({properties:_6b4},args));return anim;};return _6a5;});},"dijit/_Container":function(){define("dijit/_Container",["dojo/_base/array","dojo/_base/declare","dojo/dom-construct","./registry"],function(_6b5,_6b6,_6b7,_6b8){return _6b6("dijit._Container",null,{buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}},addChild:function(_6b9,_6ba){var _6bb=this.containerNode;if(_6ba&&typeof _6ba=="number"){var _6bc=this.getChildren();if(_6bc&&_6bc.length>=_6ba){_6bb=_6bc[_6ba-1].domNode;_6ba="after";}}_6b7.place(_6b9.domNode,_6bb,_6ba);if(this._started&&!_6b9._started){_6b9.startup();}},removeChild:function(_6bd){if(typeof _6bd=="number"){_6bd=this.getChildren()[_6bd];}if(_6bd){var node=_6bd.domNode;if(node&&node.parentNode){node.parentNode.removeChild(node);}}},hasChildren:function(){return this.getChildren().length>0;},_getSiblingOfChild:function(_6be,dir){var node=_6be.domNode,_6bf=(dir>0?"nextSibling":"previousSibling");do{node=node[_6bf];}while(node&&(node.nodeType!=1||!_6b8.byNode(node)));return node&&_6b8.byNode(node);},getIndexOfChild:function(_6c0){return _6b5.indexOf(this.getChildren(),_6c0);}});});},"dojox/charting/axis2d/Base":function(){define("dojox/charting/axis2d/Base",["dojo/_base/declare","../Element"],function(_6c1,_6c2){return _6c1("dojox.charting.axis2d.Base",_6c2,{constructor:function(_6c3,_6c4){this.vertical=_6c4&&_6c4.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_6c5){this.dirty=false;return this;}});});},"dijit/layout/BorderContainer":function(){define("dijit/layout/BorderContainer",["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","dojo/_base/window","../_WidgetBase","../_Widget","../_TemplatedMixin","./_LayoutWidget","./utils"],function(_6c6,_6c7,_6c8,_6c9,_6ca,_6cb,_6cc,_6cd,keys,lang,on,_6ce,win,_6cf,_6d0,_6d1,_6d2,_6d3){var _6d4=_6c8("dijit.layout._Splitter",[_6d0,_6d1],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeypress:_onKeyPress,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_6c9.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _6d5=_6c7(this._cookieName);if(_6d5){this.child.domNode.style[this.horizontal?"height":"width"]=_6d5;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_6d6=_6cb.getMarginBox(this.child.domNode)[dim],_6d7=_6c6.filter(this.container.getChildren(),function(_6d8){return _6d8.region=="center";})[0],_6d9=_6cb.getMarginBox(_6d7.domNode)[dim];return Math.min(this.child.maxSize,_6d6+_6d9);},_startDrag:function(e){if(!this.cover){this.cover=win.doc.createElement("div");_6c9.add(this.cover,"dijitSplitterCover");_6ca.place(this.cover,this.child.domNode,"after");}_6c9.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_6ca.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_6c9.add(this.domNode,"dijitSplitterShadow");_6ca.place(this.fake,this.domNode,"after");}_6c9.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_6c9.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _6da=this._factor,_6db=this.horizontal,axis=_6db?"pageY":"pageX",_6dc=e[axis],_6dd=this.domNode.style,dim=_6db?"h":"w",_6de=_6cb.getMarginBox(this.child.domNode)[dim],max=this._computeMaxSize(),min=this.child.minSize||20,_6df=this.region,_6e0=_6df=="top"||_6df=="bottom"?"top":"left",_6e1=parseInt(_6dd[_6e0],10),_6e2=this._resize,_6e3=lang.hitch(this.container,"_layoutChildren",this.child.id),de=win.doc;this._handlers=this._handlers.concat([on(de,_6ce.move,this._drag=function(e,_6e4){var _6e5=e[axis]-_6dc,_6e6=_6da*_6e5+_6de,_6e7=Math.max(Math.min(_6e6,max),min);if(_6e2||_6e4){_6e3(_6e7);}_6dd[_6e0]=_6e5+_6e1+_6da*(_6e7-_6e6)+"px";}),on(de,"dragstart",_6cd.stop),on(win.body(),"selectstart",_6cd.stop),on(de,_6ce.release,lang.hitch(this,"_stopDrag"))]);_6cd.stop(e);},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_6c9.toggle(this.domNode,"dijitSplitterHover",o);_6c9.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_6c9.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_6ca.destroy(this.fake);}_6c9.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_6c7(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyPress:function(e){this._resize=true;var _6e8=this.horizontal;var tick=1;switch(e.charOrCode){case _6e8?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _6e8?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _6e9=_6cb.getMarginSize(this.child.domNode)[_6e8?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_6e9,this._computeMaxSize()),this.child.minSize));_6cd.stop(e);},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _6ea=_6c8("dijit.layout._Gutter",[_6d0,_6d1],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_6c9.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _6eb=_6c8("dijit.layout.BorderContainer",_6d2,{design:"headline",gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_6d4,postMixInProperties:function(){if(!this.gutters){this.baseClass+="NoGutter";}this.inherited(arguments);},startup:function(){if(this._started){return;}_6c6.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_6ec){var _6ed=_6ec.region;if(_6ed){this.inherited(arguments);_6c9.add(_6ec.domNode,this.baseClass+"Pane");var ltr=this.isLeftToRight();if(_6ed=="leading"){_6ed=ltr?"left":"right";}if(_6ed=="trailing"){_6ed=ltr?"right":"left";}if(_6ed!="center"&&(_6ec.splitter||this.gutters)&&!_6ec._splitterWidget){var _6ee=_6ec.splitter?this._splitterClass:_6ea;if(lang.isString(_6ee)){_6ee=lang.getObject(_6ee);}var _6ef=new _6ee({id:_6ec.id+"_splitter",container:this,child:_6ec,region:_6ed,live:this.liveSplitters});_6ef.isSplitter=true;_6ec._splitterWidget=_6ef;_6ca.place(_6ef.domNode,_6ec.domNode,"after");_6ef.startup();}_6ec.region=_6ed;}},layout:function(){this._layoutChildren();},addChild:function(_6f0,_6f1){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_6f2){var _6f3=_6f2.region;var _6f4=_6f2._splitterWidget;if(_6f4){_6f4.destroy();delete _6f2._splitterWidget;}this.inherited(arguments);if(this._started){this._layoutChildren();}_6c9.remove(_6f2.domNode,this.baseClass+"Pane");_6cc.set(_6f2.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_6cc.set(_6f2.domNode,_6f3=="top"||_6f3=="bottom"?"width":"height","auto");},getChildren:function(){return _6c6.filter(this.inherited(arguments),function(_6f5){return !_6f5.isSplitter;});},getSplitter:function(_6f6){return _6c6.filter(this.getChildren(),function(_6f7){return _6f7.region==_6f6;})[0]._splitterWidget;},resize:function(_6f8,_6f9){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_6cc.getComputedStyle(node);this.pe=_6cb.getPadExtents(node,this.cs);this.pe.r=_6cc.toPixelValue(node,this.cs.paddingRight);this.pe.b=_6cc.toPixelValue(node,this.cs.paddingBottom);_6cc.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_6fa,_6fb){if(!this._borderBox||!this._borderBox.h){return;}var _6fc=_6c6.map(this.getChildren(),function(_6fd,idx){return {pane:_6fd,weight:[_6fd.region=="center"?Infinity:0,_6fd.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_6fd.region)?1:-1),idx]};},this);_6fc.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});var _6fe=[];_6c6.forEach(_6fc,function(_6ff){var pane=_6ff.pane;_6fe.push(pane);if(pane._splitterWidget){_6fe.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_6d3.layoutChildren(this.domNode,dim,_6fe,_6fa,_6fb);},destroyRecursive:function(){_6c6.forEach(this.getChildren(),function(_700){var _701=_700._splitterWidget;if(_701){_701.destroy();}delete _700._splitterWidget;});this.inherited(arguments);}});lang.extend(_6cf,{region:"",layoutPriority:0,splitter:false,minSize:0,maxSize:Infinity});_6eb._Splitter=_6d4;_6eb._Gutter=_6ea;return _6eb;});},"dojox/charting/Series":function(){define("dojox/charting/Series",["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_702,_703){return _702("dojox.charting.Series",_703,{constructor:function(_704,data,_705){lang.mixin(this,_705);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dijit/_base/wai":function(){define("dijit/_base/wai",["dojo/dom-attr","dojo/_base/lang","..","../hccss"],function(_706,lang,_707){lang.mixin(_707,{hasWaiRole:function(elem,role){var _708=this.getWaiRole(elem);return role?(_708.indexOf(role)>-1):(_708.length>0);},getWaiRole:function(elem){return lang.trim((_706.get(elem,"role")||"").replace("wairole:",""));},setWaiRole:function(elem,role){_706.set(elem,"role",role);},removeWaiRole:function(elem,role){var _709=_706.get(elem,"role");if(!_709){return;}if(role){var t=lang.trim((" "+_709+" ").replace(" "+role+" "," "));_706.set(elem,"role",t);}else{elem.removeAttribute("role");}},hasWaiState:function(elem,_70a){return elem.hasAttribute?elem.hasAttribute("aria-"+_70a):!!elem.getAttribute("aria-"+_70a);},getWaiState:function(elem,_70b){return elem.getAttribute("aria-"+_70b)||"";},setWaiState:function(elem,_70c,_70d){elem.setAttribute("aria-"+_70c,_70d);},removeWaiState:function(elem,_70e){elem.removeAttribute("aria-"+_70e);}});return _707;});},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","dojo/dnd/Mover":function(){define(["../main","../Evented","../touch","./common","./autoscroll"],function(dojo,_70f,_710){dojo.declare("dojo.dnd.Mover",[_70f],{constructor:function(node,e,host){this.node=dojo.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;this.events=[dojo.connect(d,_710.move,this,"onFirstMove"),dojo.connect(d,_710.move,this,"onMouseMove"),dojo.connect(d,_710.release,this,"onMouseUp"),dojo.connect(d,"ondragstart",dojo.stopEvent),dojo.connect(d.body,"onselectstart",dojo.stopEvent)];if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){dojo.dnd.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);dojo.stopEvent(e);},onMouseUp:function(e){if(dojo.isWebKit&&dojo.isMac&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}dojo.stopEvent(e);},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=dojo.marginBox(this.node);var b=dojo.doc.body;var bs=dojo.getComputedStyle(b);var bm=dojo._getMarginBox(b,bs);var bc=dojo._getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}dojo.disconnect(this.events.shift());},destroy:function(){dojo.forEach(this.events,dojo.disconnect);var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});return dojo.dnd.Mover;});},"dojox/lang/functional/lambda":function(){define("dojox/lang/functional/lambda",["../..","dojo/_base/kernel","dojo/_base/lang","dojo/_base/array"],function(_711,dojo,lang,arr){var df=lang.getObject("lang.functional",true,_711);var _712={};var _713="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _714=function(s){var args=[],_715=_713.call(s,/\s*->\s*/m);if(_715.length>1){while(_715.length){s=_715.pop();args=_715.pop().split(/\s*,\s*|\s+/m);if(_715.length){_715.push("(function("+args+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(vars,function(v){if(!(v in t)){args.push(v);t[v]=1;}});}}}return {args:args,body:s};};var _716=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};lang.mixin(df,{rawLambda:function(s){return _714(s);},buildLambda:function(s){s=_714(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _716(s);}if(s in _712){return _712[s];}s=_714(s);return _712[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_712={};}});return df;});},"dojox/charting/Element":function(){define("dojox/charting/Element",["dojo/_base/lang","dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx"],function(lang,arr,_717,_718,gfx){return _718("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_719){this.chart=_719;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},createGroup:function(_71a){if(!_71a){_71a=this.chart.surface;}if(!this.group){this.group=_71a.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_71b){this.destroyHtmlElements();if(!_71b){_71b=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_71b.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_717.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_71c,_71d){if(!s||s.length<=0){return {text:"",truncated:_71d||false};}if(!_71c||_71c<=0){return {text:s,truncated:_71d||false};}var _71e=2,_71f=0.618,_720=s.substring(0,1)+this.trailingSymbol,_721=this.getTextWidth(_720,font);if(_71c<=_721){return {text:_720,truncated:true};}var _722=this.getTextWidth(s,font);if(_722<=_71c){return {text:s,truncated:_71d||false};}else{var _723=0,end=s.length;while(_723<end){if(end-_723<=_71e){while(this.getTextWidth(s.substring(0,_723)+this.trailingSymbol,font)>_71c){_723-=1;}return {text:(s.substring(0,_723)+this.trailingSymbol),truncated:true};}var _724=_723+Math.round((end-_723)*_71f),_725=this.getTextWidth(s.substring(0,_724),font);if(_725<_71c){_723=_724;end=end;}else{_723=_723;end=_724;}}}},getTextWithLimitCharCount:function(s,font,_726,_727){if(!s||s.length<=0){return {text:"",truncated:_727||false};}if(!_726||_726<=0||s.length<=_726){return {text:s,truncated:_727||false};}return {text:s.substring(0,_726)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_728){if(!fill||!fill.type||!fill.space){return fill;}var _729=fill.space;switch(fill.type){case "linear":if(_729==="plot"||_729==="shapeX"||_729==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_729;if(_729==="plot"||_729==="shapeX"){var span=dim.height-_728.t-_728.b;fill.y1=_728.t+span*fill.y1/100;fill.y2=_728.t+span*fill.y2/100;}if(_729==="plot"||_729==="shapeY"){var span=dim.width-_728.l-_728.r;fill.x1=_728.l+span*fill.x1/100;fill.x2=_728.l+span*fill.x2/100;}}break;case "radial":if(_729==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_729;var _72a=dim.width-_728.l-_728.r,_72b=dim.height-_728.t-_728.b;fill.cx=_728.l+_72a*fill.cx/100;fill.cy=_728.t+_72b*fill.cy/100;fill.r=fill.r*Math.sqrt(_72a*_72a+_72b*_72b)/200;}break;case "pattern":if(_729==="plot"||_729==="shapeX"||_729==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_729;if(_729==="plot"||_729==="shapeX"){var span=dim.height-_728.t-_728.b;fill.y=_728.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_729==="plot"||_729==="shapeY"){var span=dim.width-_728.l-_728.r;fill.x=_728.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _72c=fill.space;switch(fill.type){case "linear":if(_72c==="shape"||_72c==="shapeX"||_72c==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_72c;if(_72c==="shape"||_72c==="shapeX"){var span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_72c==="shape"||_72c==="shapeY"){var span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_72c==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_72c;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_72c==="shape"||_72c==="shapeX"||_72c==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_72c;if(_72c==="shape"||_72c==="shapeX"){var span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_72c==="shape"||_72c==="shapeY"){var span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_72d,_72e,_72f,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _730=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_730;if(arguments.length<4){fill.cx=_72d.x;fill.cy=_72d.y;fill.r=fill.r*_72e/100;return fill;}var _731=arguments.length<5?_72f:(end+_72f)/2;return {type:"linear",x1:_72d.x,y1:_72d.y,x2:_72d.x+fill.r*_72e*Math.cos(_731)/100,y2:_72d.y+fill.r*_72e*Math.sin(_731)/100,colors:fill.colors};return fill;}});});},"dijit/form/ComboBoxMixin":function(){require({cache:{"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n"}});define("dijit/form/ComboBoxMixin",["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_732,_733,_734,lang,_735,_736,_737,_738,_739){return _732("dijit.form.ComboBoxMixin",[_738,_736],{dropDownClass:_737,hasDownArrow:true,templateString:_739,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_73a){if(!_73a.get){lang.mixin(_73a,{_oldAPI:true,get:function(id){var _73b=new _733();this.fetchItemByIdentity({identity:id,onItem:function(_73c){_73b.resolve(_73c);},onError:function(_73d){_73b.reject(_73d);}});return _73b.promise;},query:function(_73e,_73f){var _740=new _733(function(){_741.abort&&_741.abort();});var _741=this.fetch(lang.mixin({query:_73e,onBegin:function(_742){_740.total=_742;},onComplete:function(_743){_740.resolve(_743);},onError:function(_744){_740.reject(_744);}},_73f));return _735(_740);}});}this._set("store",_73a);},postMixInProperties:function(){if(this.params.store){this._setStoreAttr(this.params.store);}this.inherited(arguments);if(!this.params.store){var _745=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_734.deprecated(_745+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_734.deprecated(_745+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_734.deprecated(_745+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_746){new _746({objectStore:this}).fetch(args);}));}});}}});});},"dijit/Calendar":function(){define("dijit/Calendar",["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/_base/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton","./hccss"],function(_747,date,_748,_749,_74a,_74b,_74c,_74d,keys,lang,has,_74e,_74f,_750,_751,_752){var _753=_749("dijit.Calendar",[_74e,_74f,_750],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_754){_74d.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_754);},_createMonthWidget:function(){return new _753._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){this.inherited(arguments);this.connect(this.domNode,"onkeypress","_onKeyPress");this.connect(this.dateRowsNode,"onmouseover","_onDayMouseOver");this.connect(this.dateRowsNode,"onmouseout","_onDayMouseOut");this.connect(this.dateRowsNode,"onmousedown","_onDayMouseDown");this.connect(this.dateRowsNode,"onmouseup","_onDayMouseUp");},_onMonthSelect:function(_755){this._setCurrentFocusAttr(this.dateFuncObj.add(this.currentFocus,"month",_755-this.currentFocus.getMonth()));},_onDayMouseOver:function(evt){var node=_74b.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_74b.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_74b.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_74b.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_74b.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_74b.contains(node,"dijitCalendarDisabledDate")){_74b.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_74b.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _756=-1,_757,_758=this.currentFocus;switch(evt.charOrCode){case keys.RIGHT_ARROW:_756=1;case keys.LEFT_ARROW:_757="day";if(!this.isLeftToRight()){_756*=-1;}break;case keys.DOWN_ARROW:_756=1;case keys.UP_ARROW:_757="week";break;case keys.PAGE_DOWN:_756=1;case keys.PAGE_UP:_757=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_758=this.dateFuncObj.add(_758,"month",1);_757="day";case keys.HOME:_758=new this.dateClassObj(_758);_758.setDate(1);break;case keys.ENTER:case " ":this.set("value",this.currentFocus);break;default:return true;}if(_757){_758=this.dateFuncObj.add(_758,_757,_756);}this._setCurrentFocusAttr(_758);return false;},_onKeyPress:function(evt){if(!this.handleKey(evt)){_74c.stop(evt);}},onValueSelected:function(){},onChange:function(_759){this.onValueSelected(_759);},getClassForDate:function(){}});_753._MonthDropDownButton=_749("dijit.Calendar._MonthDropDownButton",_752,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _753._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_75a){var _75b=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_75a);this.dropDown.set("months",_75b);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_75b[_75a.getMonth()]+"</div>";}});_753._MonthDropDown=_749("dijit.Calendar._MonthDropDown",[_74f,_751],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_75c){this.domNode.innerHTML=_747.map(_75c,function(_75d,idx){return _75d?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+_75d+"</div>":"";}).join("");},_onClick:function(evt){this.onChange(_74a.get(evt.target,"month"));},onChange:function(){},_onMenuHover:function(evt){_74b.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");}});return _753;});},"dojo/topic":function(){define(["./Evented"],function(_75e){var hub=new _75e;return {publish:function(_75f,_760){return hub.emit.apply(hub,arguments);},subscribe:function(_761,_762){return hub.on.apply(hub,arguments);}};});},"dojox/validate/regexp":function(){define("dojox/validate/regexp",["dojo/_base/lang","dojo/regexp","dojox/main"],function(lang,_763,_764){var _765=lang.getObject("validate.regexp",true,_764);_765=_764.validate.regexp={ipAddress:function(_766){_766=(typeof _766=="object")?_766:{};if(typeof _766.allowDottedDecimal!="boolean"){_766.allowDottedDecimal=true;}if(typeof _766.allowDottedHex!="boolean"){_766.allowDottedHex=true;}if(typeof _766.allowDottedOctal!="boolean"){_766.allowDottedOctal=true;}if(typeof _766.allowDecimal!="boolean"){_766.allowDecimal=true;}if(typeof _766.allowHex!="boolean"){_766.allowHex=true;}if(typeof _766.allowIPv6!="boolean"){_766.allowIPv6=true;}if(typeof _766.allowHybrid!="boolean"){_766.allowHybrid=true;}var _767="((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";var _768="(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";var _769="(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";var _76a="(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|"+"4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";var _76b="0[xX]0*[\\da-fA-F]{1,8}";var _76c="([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";var _76d="([\\da-fA-F]{1,4}\\:){6}"+"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";var a=[];if(_766.allowDottedDecimal){a.push(_767);}if(_766.allowDottedHex){a.push(_768);}if(_766.allowDottedOctal){a.push(_769);}if(_766.allowDecimal){a.push(_76a);}if(_766.allowHex){a.push(_76b);}if(_766.allowIPv6){a.push(_76c);}if(_766.allowHybrid){a.push(_76d);}var _76e="";if(a.length>0){_76e="("+a.join("|")+")";}return _76e;},host:function(_76f){_76f=(typeof _76f=="object")?_76f:{};if(typeof _76f.allowIP!="boolean"){_76f.allowIP=true;}if(typeof _76f.allowLocal!="boolean"){_76f.allowLocal=false;}if(typeof _76f.allowPort!="boolean"){_76f.allowPort=true;}if(typeof _76f.allowNamed!="boolean"){_76f.allowNamed=false;}var _770="(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";var _771="(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)";var _772=_76f.allowPort?"(\\:\\d+)?":"";var _773="((?:"+_770+"\\.)+"+_771+"\\.?)";if(_76f.allowIP){_773+="|"+_765.ipAddress(_76f);}if(_76f.allowLocal){_773+="|localhost";}if(_76f.allowNamed){_773+="|^[^-][a-zA-Z0-9_-]*";}return "("+_773+")"+_772;},url:function(_774){_774=(typeof _774=="object")?_774:{};if(!("scheme" in _774)){_774.scheme=[true,false];}var _775=_763.buildGroupRE(_774.scheme,function(q){if(q){return "(https?|ftps?)\\://";}return "";});var _776="(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";return _775+_765.host(_774)+_776;},emailAddress:function(_777){_777=(typeof _777=="object")?_777:{};if(typeof _777.allowCruft!="boolean"){_777.allowCruft=false;}_777.allowPort=false;var _778="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";var _779=_778+"@"+_765.host(_777);if(_777.allowCruft){_779="<?(mailto\\:)?"+_779+">?";}return _779;},emailAddressList:function(_77a){_77a=(typeof _77a=="object")?_77a:{};if(typeof _77a.listSeparator!="string"){_77a.listSeparator="\\s;,";}var _77b=_765.emailAddress(_77a);var _77c="("+_77b+"\\s*["+_77a.listSeparator+"]\\s*)*"+_77b+"\\s*["+_77a.listSeparator+"]?\\s*";return _77c;},numberFormat:function(_77d){_77d=(typeof _77d=="object")?_77d:{};if(typeof _77d.format=="undefined"){_77d.format="###-###-####";}var _77e=function(_77f){return _763.escapeString(_77f,"?").replace(/\?/g,"\\d?").replace(/#/g,"\\d");};return _763.buildGroupRE(_77d.format,_77e);},ca:{postalCode:function(){return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";},province:function(){return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";}},us:{state:function(_780){_780=(typeof _780=="object")?_780:{};if(typeof _780.allowTerritories!="boolean"){_780.allowTerritories=true;}if(typeof _780.allowMilitary!="boolean"){_780.allowMilitary=true;}var _781="AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|"+"NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";var _782="AS|FM|GU|MH|MP|PW|PR|VI";var _783="AA|AE|AP";if(_780.allowTerritories){_781+="|"+_782;}if(_780.allowMilitary){_781+="|"+_783;}return "("+_781+")";}}};return _765;});},"dijit/_base/manager":function(){define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","../registry",".."],function(_784,_785,_786,_787){_784.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_787[name]=_786[name];});_787.defaultDuration=_785["defaultDuration"]||200;return _787;});},"dojo/data/ItemFileReadStore":function(){define(["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","../_base/window","./util/filter","./util/simpleFetch","../date/stamp"],function(_788,lang,_789,_78a,xhr,_78b,_78c,_78d,_78e,_78f){var _790=_789("dojo.data.ItemFileReadStore",[_78b],{constructor:function(_791){this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._jsonFileUrl=_791.url;this._ccUrl=_791.url;this.url=_791.url;this._jsonData=_791.data;this.data=null;this._datatypeMap=_791.typeMap||{};if(!this._datatypeMap["Date"]){this._datatypeMap["Date"]={type:Date,deserialize:function(_792){return _78f.fromISOString(_792);}};}this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};this._itemsByIdentity=null;this._storeRefPropName="_S";this._itemNumPropName="_0";this._rootItemPropName="_RI";this._reverseRefMap="_RRM";this._loadInProgress=false;this._queuedFetches=[];if(_791.urlPreventCache!==undefined){this.urlPreventCache=_791.urlPreventCache?true:false;}if(_791.hierarchical!==undefined){this.hierarchical=_791.hierarchical?true:false;}if(_791.clearOnClose){this.clearOnClose=true;}if("failOk" in _791){this.failOk=_791.failOk?true:false;}},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(item){if(!this.isItem(item)){throw new Error("dojo.data.ItemFileReadStore: Invalid item argument.");}},_assertIsAttribute:function(_793){if(typeof _793!=="string"){throw new Error("dojo.data.ItemFileReadStore: Invalid attribute argument.");}},getValue:function(item,_794,_795){var _796=this.getValues(item,_794);return (_796.length>0)?_796[0]:_795;},getValues:function(item,_797){this._assertIsItem(item);this._assertIsAttribute(_797);return (item[_797]||[]).slice(0);},getAttributes:function(item){this._assertIsItem(item);var _798=[];for(var key in item){if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){_798.push(key);}}return _798;},hasAttribute:function(item,_799){this._assertIsItem(item);this._assertIsAttribute(_799);return (_799 in item);},containsValue:function(item,_79a,_79b){var _79c=undefined;if(typeof _79b==="string"){_79c=_78d.patternToRegExp(_79b,false);}return this._containsValue(item,_79a,_79b,_79c);},_containsValue:function(item,_79d,_79e,_79f){return _78a.some(this.getValues(item,_79d),function(_7a0){if(_7a0!==null&&!lang.isObject(_7a0)&&_79f){if(_7a0.toString().match(_79f)){return true;}}else{if(_79e===_7a0){return true;}}});},isItem:function(_7a1){if(_7a1&&_7a1[this._storeRefPropName]===this){if(this._arrayOfAllItems[_7a1[this._itemNumPropName]]===_7a1){return true;}}return false;},isItemLoaded:function(_7a2){return this.isItem(_7a2);},loadItem:function(_7a3){this._assertIsItem(_7a3.item);},getFeatures:function(){return this._features;},getLabel:function(item){if(this._labelAttr&&this.isItem(item)){return this.getValue(item,this._labelAttr);}return undefined;},getLabelAttributes:function(item){if(this._labelAttr){return [this._labelAttr];}return null;},_fetchItems:function(_7a4,_7a5,_7a6){var self=this,_7a7=function(_7a8,_7a9){var _7aa=[],i,key;if(_7a8.query){var _7ab,_7ac=_7a8.queryOptions?_7a8.queryOptions.ignoreCase:false;var _7ad={};for(key in _7a8.query){_7ab=_7a8.query[key];if(typeof _7ab==="string"){_7ad[key]=_78d.patternToRegExp(_7ab,_7ac);}else{if(_7ab instanceof RegExp){_7ad[key]=_7ab;}}}for(i=0;i<_7a9.length;++i){var _7ae=true;var _7af=_7a9[i];if(_7af===null){_7ae=false;}else{for(key in _7a8.query){_7ab=_7a8.query[key];if(!self._containsValue(_7af,key,_7ab,_7ad[key])){_7ae=false;}}}if(_7ae){_7aa.push(_7af);}}_7a5(_7aa,_7a8);}else{for(i=0;i<_7a9.length;++i){var item=_7a9[i];if(item!==null){_7aa.push(item);}}_7a5(_7aa,_7a8);}};if(this._loadFinished){_7a7(_7a4,this._getItemsArray(_7a4.queryOptions));}else{if(this._jsonFileUrl!==this._ccUrl){_788.deprecated("dojo.data.ItemFileReadStore: ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_7a4,filter:_7a7});}else{this._loadInProgress=true;var _7b0={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _7b1=xhr.get(_7b0);_7b1.addCallback(function(data){try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;_7a7(_7a4,self._getItemsArray(_7a4.queryOptions));self._handleQueuedFetches();}catch(e){self._loadFinished=true;self._loadInProgress=false;_7a6(e,_7a4);}});_7b1.addErrback(function(_7b2){self._loadInProgress=false;_7a6(_7b2,_7a4);});var _7b3=null;if(_7a4.abort){_7b3=_7a4.abort;}_7a4.abort=function(){var df=_7b1;if(df&&df.fired===-1){df.cancel();df=null;}if(_7b3){_7b3.call(_7a4);}};}}else{if(this._jsonData){try{this._loadFinished=true;this._getItemsFromLoadedData(this._jsonData);this._jsonData=null;_7a7(_7a4,this._getItemsArray(_7a4.queryOptions));}catch(e){_7a6(e,_7a4);}}else{_7a6(new Error("dojo.data.ItemFileReadStore: No JSON source data was provided as either URL or a nested Javascript object."),_7a4);}}}},_handleQueuedFetches:function(){if(this._queuedFetches.length>0){for(var i=0;i<this._queuedFetches.length;i++){var _7b4=this._queuedFetches[i],_7b5=_7b4.args,_7b6=_7b4.filter;if(_7b6){_7b6(_7b5,this._getItemsArray(_7b5.queryOptions));}else{this.fetchItemByIdentity(_7b5);}}this._queuedFetches=[];}},_getItemsArray:function(_7b7){if(_7b7&&_7b7.deep){return this._arrayOfAllItems;}return this._arrayOfTopLevelItems;},close:function(_7b8){if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){}this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._itemsByIdentity=null;this._loadInProgress=false;this._queuedFetches=[];}},_getItemsFromLoadedData:function(_7b9){var _7ba=false,self=this;function _7bb(_7bc){return (_7bc!==null)&&(typeof _7bc==="object")&&(!lang.isArray(_7bc)||_7ba)&&(!lang.isFunction(_7bc))&&(_7bc.constructor==Object||lang.isArray(_7bc))&&(typeof _7bc._reference==="undefined")&&(typeof _7bc._type==="undefined")&&(typeof _7bc._value==="undefined")&&self.hierarchical;};function _7bd(_7be){self._arrayOfAllItems.push(_7be);for(var _7bf in _7be){var _7c0=_7be[_7bf];if(_7c0){if(lang.isArray(_7c0)){var _7c1=_7c0;for(var k=0;k<_7c1.length;++k){var _7c2=_7c1[k];if(_7bb(_7c2)){_7bd(_7c2);}}}else{if(_7bb(_7c0)){_7bd(_7c0);}}}}};this._labelAttr=_7b9.label;var i,item;this._arrayOfAllItems=[];this._arrayOfTopLevelItems=_7b9.items;for(i=0;i<this._arrayOfTopLevelItems.length;++i){item=this._arrayOfTopLevelItems[i];if(lang.isArray(item)){_7ba=true;}_7bd(item);item[this._rootItemPropName]=true;}var _7c3={},key;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){if(key!==this._rootItemPropName){var _7c4=item[key];if(_7c4!==null){if(!lang.isArray(_7c4)){item[key]=[_7c4];}}else{item[key]=[null];}}_7c3[key]=key;}}while(_7c3[this._storeRefPropName]){this._storeRefPropName+="_";}while(_7c3[this._itemNumPropName]){this._itemNumPropName+="_";}while(_7c3[this._reverseRefMap]){this._reverseRefMap+="_";}var _7c5;var _7c6=_7b9.identifier;if(_7c6){this._itemsByIdentity={};this._features["dojo.data.api.Identity"]=_7c6;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];_7c5=item[_7c6];var _7c7=_7c5[0];if(!Object.hasOwnProperty.call(this._itemsByIdentity,_7c7)){this._itemsByIdentity[_7c7]=item;}else{if(this._jsonFileUrl){throw new Error("dojo.data.ItemFileReadStore:  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_7c6+"].  Value collided: ["+_7c7+"]");}else{if(this._jsonData){throw new Error("dojo.data.ItemFileReadStore:  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_7c6+"].  Value collided: ["+_7c7+"]");}}}}}else{this._features["dojo.data.api.Identity"]=Number;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];item[this._storeRefPropName]=this;item[this._itemNumPropName]=i;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){_7c5=item[key];for(var j=0;j<_7c5.length;++j){_7c4=_7c5[j];if(_7c4!==null&&typeof _7c4=="object"){if(("_type" in _7c4)&&("_value" in _7c4)){var type=_7c4._type;var _7c8=this._datatypeMap[type];if(!_7c8){throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+type+"'");}else{if(lang.isFunction(_7c8)){_7c5[j]=new _7c8(_7c4._value);}else{if(lang.isFunction(_7c8.deserialize)){_7c5[j]=_7c8.deserialize(_7c4._value);}else{throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");}}}}if(_7c4._reference){var _7c9=_7c4._reference;if(!lang.isObject(_7c9)){_7c5[j]=this._getItemByIdentity(_7c9);}else{for(var k=0;k<this._arrayOfAllItems.length;++k){var _7ca=this._arrayOfAllItems[k],_7cb=true;for(var _7cc in _7c9){if(_7ca[_7cc]!=_7c9[_7cc]){_7cb=false;}}if(_7cb){_7c5[j]=_7ca;}}}if(this.referenceIntegrity){var _7cd=_7c5[j];if(this.isItem(_7cd)){this._addReferenceToMap(_7cd,item,key);}}}else{if(this.isItem(_7c4)){if(this.referenceIntegrity){this._addReferenceToMap(_7c4,item,key);}}}}}}}},_addReferenceToMap:function(_7ce,_7cf,_7d0){},getIdentity:function(item){var _7d1=this._features["dojo.data.api.Identity"];if(_7d1===Number){return item[this._itemNumPropName];}else{var _7d2=item[_7d1];if(_7d2){return _7d2[0];}}return null;},fetchItemByIdentity:function(_7d3){var item,_7d4;if(!this._loadFinished){var self=this;if(this._jsonFileUrl!==this._ccUrl){_788.deprecated("dojo.data.ItemFileReadStore: ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null&&this._jsonData==null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_7d3});}else{this._loadInProgress=true;var _7d5={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _7d6=xhr.get(_7d5);_7d6.addCallback(function(data){var _7d7=_7d3.scope?_7d3.scope:_78c.global;try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;item=self._getItemByIdentity(_7d3.identity);if(_7d3.onItem){_7d3.onItem.call(_7d7,item);}self._handleQueuedFetches();}catch(error){self._loadInProgress=false;if(_7d3.onError){_7d3.onError.call(_7d7,error);}}});_7d6.addErrback(function(_7d8){self._loadInProgress=false;if(_7d3.onError){var _7d9=_7d3.scope?_7d3.scope:_78c.global;_7d3.onError.call(_7d9,_7d8);}});}}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;item=self._getItemByIdentity(_7d3.identity);if(_7d3.onItem){_7d4=_7d3.scope?_7d3.scope:_78c.global;_7d3.onItem.call(_7d4,item);}}}}else{item=this._getItemByIdentity(_7d3.identity);if(_7d3.onItem){_7d4=_7d3.scope?_7d3.scope:_78c.global;_7d3.onItem.call(_7d4,item);}}},_getItemByIdentity:function(_7da){var item=null;if(this._itemsByIdentity){if(Object.hasOwnProperty.call(this._itemsByIdentity,_7da)){item=this._itemsByIdentity[_7da];}}else{if(Object.hasOwnProperty.call(this._arrayOfAllItems,_7da)){item=this._arrayOfAllItems[_7da];}}if(item===undefined){item=null;}return item;},getIdentityAttributes:function(item){var _7db=this._features["dojo.data.api.Identity"];if(_7db===Number){return null;}else{return [_7db];}},_forceLoad:function(){var self=this;if(this._jsonFileUrl!==this._ccUrl){_788.deprecated("dojo.data.ItemFileReadStore: ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){var _7dc={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};var _7dd=xhr.get(_7dc);_7dd.addCallback(function(data){try{if(self._loadInProgress!==true&&!self._loadFinished){self._getItemsFromLoadedData(data);self._loadFinished=true;}else{if(self._loadInProgress){throw new Error("dojo.data.ItemFileReadStore:  Unable to perform a synchronous load, an async load is in progress.");}}}catch(e){throw e;}});_7dd.addErrback(function(_7de){throw _7de;});}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;}}}});lang.extend(_790,_78e);return _790;});},"dojox/lang/functional/array":function(){define("dojox/lang/functional/array",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(dojo,lang,arr,win,df){var _7df={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _7df)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _7df)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _7df)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _7df)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _7df)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dijit/form/ComboButton":function(){require({cache:{"url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\"\n\t\t/></td></tr></tbody\n></table>\n"}});define("dijit/form/ComboButton",["dojo/_base/declare","dojo/_base/event","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_7e0,_7e1,keys,_7e2,_7e3,_7e4){return _7e0("dijit.form.ComboButton",_7e3,{templateString:_7e4,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyPress:function(evt){if(evt.charOrCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_7e2.focus(this._popupStateNode);_7e1.stop(evt);}},_onArrowKeyPress:function(evt){if(evt.charOrCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_7e2.focus(this.titleNode);_7e1.stop(evt);}},focus:function(_7e5){if(!this.disabled){_7e2.focus(_7e5=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/WidgetSet":function(){define("dijit/WidgetSet",["dojo/_base/array","dojo/_base/declare","dojo/_base/window","./registry"],function(_7e6,_7e7,win,_7e8){var _7e9=_7e7("dijit.WidgetSet",null,{constructor:function(){this._hash={};this.length=0;},add:function(_7ea){if(this._hash[_7ea.id]){throw new Error("Tried to register widget with id=="+_7ea.id+" but that id is already registered");}this._hash[_7ea.id]=_7ea;this.length++;},remove:function(id){if(this._hash[id]){delete this._hash[id];this.length--;}},forEach:function(func,_7eb){_7eb=_7eb||win.global;var i=0,id;for(id in this._hash){func.call(_7eb,this._hash[id],i++,this._hash);}return this;},filter:function(_7ec,_7ed){_7ed=_7ed||win.global;var res=new _7e9(),i=0,id;for(id in this._hash){var w=this._hash[id];if(_7ec.call(_7ed,w,i++,this._hash)){res.add(w);}}return res;},byId:function(id){return this._hash[id];},byClass:function(cls){var res=new _7e9(),id,_7ee;for(id in this._hash){_7ee=this._hash[id];if(_7ee.declaredClass==cls){res.add(_7ee);}}return res;},toArray:function(){var ar=[];for(var id in this._hash){ar.push(this._hash[id]);}return ar;},map:function(func,_7ef){return _7e6.map(this.toArray(),func,_7ef);},every:function(func,_7f0){_7f0=_7f0||win.global;var x=0,i;for(i in this._hash){if(!func.call(_7f0,this._hash[i],x++,this._hash)){return false;}}return true;},some:function(func,_7f1){_7f1=_7f1||win.global;var x=0,i;for(i in this._hash){if(func.call(_7f1,this._hash[i],x++,this._hash)){return true;}}return false;}});_7e6.forEach(["forEach","filter","byClass","map","every","some"],function(func){_7e8[func]=_7e9.prototype[func];});return _7e9;});},"dijit/form/RangeBoundTextBox":function(){define("dijit/form/RangeBoundTextBox",["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_7f2,i18n,_7f3){return _7f2("dijit.form.RangeBoundTextBox",_7f3,{rangeMessage:"",rangeCheck:function(_7f4,_7f5){return ("min" in _7f5?(this.compare(_7f4,_7f5.min)>=0):true)&&("max" in _7f5?(this.compare(_7f4,_7f5.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");var _7f6=false;var _7f7=false;if("min" in this.constraints){var min=this.constraints.min;min=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min);_7f6=(typeof min=="number")&&min<0;}if("max" in this.constraints){var max=this.constraints.max;max=this.compare(val,((typeof max!="number")||max>0)?max:0);_7f7=(typeof max=="number")&&max>0;}return _7f6||_7f7;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_7f8){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_7f8));},getErrorMessage:function(_7f9){var v=this.get("value");if(v!==null&&v!==""&&v!==undefined&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_7f9)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}},_setConstraintsAttr:function(_7fa){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(_7fb,_7fc){this.focusNode.setAttribute("aria-valuenow",_7fb);this.inherited(arguments);},applyTextDir:function(){}});});},"dojo/dom-class":function(){define(["./_base/lang","./_base/array","./dom"],function(lang,_7fd,dom){var _7fe="className";var cls,_7ff=/\s+/,a1=[""];function _800(s){if(typeof s=="string"||s instanceof String){if(s&&!_7ff.test(s)){a1[0]=s;return a1;}var a=s.split(_7ff);if(a.length&&!a[0]){a.shift();}if(a.length&&!a[a.length-1]){a.pop();}return a;}if(!s){return [];}return _7fd.filter(s,function(x){return x;});};var _801={};cls={contains:function containsClass(node,_802){return ((" "+dom.byId(node)[_7fe]+" ").indexOf(" "+_802+" ")>=0);},add:function addClass(node,_803){node=dom.byId(node);_803=_800(_803);var cls=node[_7fe],_804;cls=cls?" "+cls+" ":" ";_804=cls.length;for(var i=0,len=_803.length,c;i<len;++i){c=_803[i];if(c&&cls.indexOf(" "+c+" ")<0){cls+=c+" ";}}if(_804<cls.length){node[_7fe]=cls.substr(1,cls.length-2);}},remove:function removeClass(node,_805){node=dom.byId(node);var cls;if(_805!==undefined){_805=_800(_805);cls=" "+node[_7fe]+" ";for(var i=0,len=_805.length;i<len;++i){cls=cls.replace(" "+_805[i]+" "," ");}cls=lang.trim(cls);}else{cls="";}if(node[_7fe]!=cls){node[_7fe]=cls;}},replace:function replaceClass(node,_806,_807){node=dom.byId(node);_801[_7fe]=node[_7fe];cls.remove(_801,_807);cls.add(_801,_806);if(node[_7fe]!==_801[_7fe]){node[_7fe]=_801[_7fe];}},toggle:function toggleClass(node,_808,_809){node=dom.byId(node);if(_809===undefined){_808=_800(_808);for(var i=0,len=_808.length,c;i<len;++i){c=_808[i];cls[cls.contains(node,c)?"remove":"add"](node,c);}}else{cls[_809?"add":"remove"](node,_808);}return _809;}};return cls;});},"dojox/gfx/vml":function(){define("dojox/gfx/vml",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/Color","dojo/_base/sniff","dojo/_base/config","dojo/dom","dojo/dom-geometry","dojo/_base/window","./_base","./shape","./path","./arc","./gradient","./matrix"],function(lang,_80a,arr,_80b,has,_80c,dom,_80d,win,g,gs,_80e,_80f,_810,m){var vml=g.vml={};vml.xmlns="urn:schemas-microsoft-com:vml";document.namespaces.add("v",vml.xmlns);var _811=["*","group","roundrect","oval","shape","rect","imagedata","path","textpath","text"],i=0,l=1,s=document.createStyleSheet();if(has("ie")>=8){i=1;l=_811.length;}for(;i<l;++i){s.addRule("v\\:"+_811[i],"behavior:url(#default#VML); display:inline-block");}vml.text_alignment={start:"left",middle:"center",end:"right"};vml._parseFloat=function(str){return str.match(/^\d+f$/i)?parseInt(str)/65536:parseFloat(str);};vml._bool={"t":1,"true":1};_80a("dojox.gfx.vml.Shape",gs.Shape,{setFill:function(fill){if(!fill){this.fillStyle=null;this.rawNode.filled="f";return this;}var i,f,fo,a,s;if(typeof fill=="object"&&"type" in fill){switch(fill.type){case "linear":var _812=this._getRealMatrix(),bbox=this.getBoundingBox(),_813=this._getRealBBox?this._getRealBBox():this.getTransformedBoundingBox();s=[];if(this.fillStyle!==fill){this.fillStyle=g.makeParameters(g.defaultLinearGradient,fill);}f=g.gradient.project(_812,this.fillStyle,{x:bbox.x,y:bbox.y},{x:bbox.x+bbox.width,y:bbox.y+bbox.height},_813[0],_813[2]);a=f.colors;if(a[0].offset.toFixed(5)!="0.00000"){s.push("0 "+g.normalizeColor(a[0].color).toHex());}for(i=0;i<a.length;++i){s.push(a[i].offset.toFixed(5)+" "+g.normalizeColor(a[i].color).toHex());}i=a.length-1;if(a[i].offset.toFixed(5)!="1.00000"){s.push("1 "+g.normalizeColor(a[i].color).toHex());}fo=this.rawNode.fill;fo.colors.value=s.join(";");fo.method="sigma";fo.type="gradient";fo.angle=(270-m._radToDeg(f.angle))%360;fo.on=true;break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);this.fillStyle=f;var l=parseFloat(this.rawNode.style.left),t=parseFloat(this.rawNode.style.top),w=parseFloat(this.rawNode.style.width),h=parseFloat(this.rawNode.style.height),c=isNaN(w)?1:2*f.r/w;a=[];if(f.colors[0].offset>0){a.push({offset:1,color:g.normalizeColor(f.colors[0].color)});}arr.forEach(f.colors,function(v,i){a.push({offset:1-v.offset*c,color:g.normalizeColor(v.color)});});i=a.length-1;while(i>=0&&a[i].offset<0){--i;}if(i<a.length-1){var q=a[i],p=a[i+1];p.color=_80b.blendColors(q.color,p.color,q.offset/(q.offset-p.offset));p.offset=0;while(a.length-i>2){a.pop();}}i=a.length-1,s=[];if(a[i].offset>0){s.push("0 "+a[i].color.toHex());}for(;i>=0;--i){s.push(a[i].offset.toFixed(5)+" "+a[i].color.toHex());}fo=this.rawNode.fill;fo.colors.value=s.join(";");fo.method="sigma";fo.type="gradientradial";if(isNaN(w)||isNaN(h)||isNaN(l)||isNaN(t)){fo.focusposition="0.5 0.5";}else{fo.focusposition=((f.cx-l)/w).toFixed(5)+" "+((f.cy-t)/h).toFixed(5);}fo.focussize="0 0";fo.on=true;break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);this.fillStyle=f;fo=this.rawNode.fill;fo.type="tile";fo.src=f.src;if(f.width&&f.height){fo.size.x=g.px2pt(f.width);fo.size.y=g.px2pt(f.height);}fo.alignShape="f";fo.position.x=0;fo.position.y=0;fo.origin.x=f.width?f.x/f.width:0;fo.origin.y=f.height?f.y/f.height:0;fo.on=true;break;}this.rawNode.fill.opacity=1;return this;}this.fillStyle=g.normalizeColor(fill);fo=this.rawNode.fill;if(!fo){fo=this.rawNode.ownerDocument.createElement("v:fill");}fo.method="any";fo.type="solid";fo.opacity=this.fillStyle.a;var _814=this.rawNode.filters["DXImageTransform.Microsoft.Alpha"];if(_814){_814.opacity=Math.round(this.fillStyle.a*100);}this.rawNode.fillcolor=this.fillStyle.toHex();this.rawNode.filled=true;return this;},setStroke:function(_815){if(!_815){this.strokeStyle=null;this.rawNode.stroked="f";return this;}if(typeof _815=="string"||lang.isArray(_815)||_815 instanceof _80b){_815={color:_815};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_815);s.color=g.normalizeColor(s.color);var rn=this.rawNode;rn.stroked=true;rn.strokecolor=s.color.toCss();rn.strokeweight=s.width+"px";if(rn.stroke){rn.stroke.opacity=s.color.a;rn.stroke.endcap=this._translate(this._capMap,s.cap);if(typeof s.join=="number"){rn.stroke.joinstyle="miter";rn.stroke.miterlimit=s.join;}else{rn.stroke.joinstyle=s.join;}rn.stroke.dashstyle=s.style=="none"?"Solid":s.style;}return this;},_capMap:{butt:"flat"},_capMapReversed:{flat:"butt"},_translate:function(dict,_816){return (_816 in dict)?dict[_816]:_816;},_applyTransform:function(){var _817=this._getRealMatrix();if(_817){var skew=this.rawNode.skew;if(typeof skew=="undefined"){for(var i=0;i<this.rawNode.childNodes.length;++i){if(this.rawNode.childNodes[i].tagName=="skew"){skew=this.rawNode.childNodes[i];break;}}}if(skew){skew.on="f";var mt=_817.xx.toFixed(8)+" "+_817.xy.toFixed(8)+" "+_817.yx.toFixed(8)+" "+_817.yy.toFixed(8)+" 0 0",_818=Math.floor(_817.dx).toFixed()+"px "+Math.floor(_817.dy).toFixed()+"px",s=this.rawNode.style,l=parseFloat(s.left),t=parseFloat(s.top),w=parseFloat(s.width),h=parseFloat(s.height);if(isNaN(l)){l=0;}if(isNaN(t)){t=0;}if(isNaN(w)||!w){w=1;}if(isNaN(h)||!h){h=1;}var _819=(-l/w-0.5).toFixed(8)+" "+(-t/h-0.5).toFixed(8);skew.matrix=mt;skew.origin=_819;skew.offset=_818;skew.on=true;}}if(this.fillStyle&&this.fillStyle.type=="linear"){this.setFill(this.fillStyle);}return this;},_setDimensions:function(_81a,_81b){return this;},setRawNode:function(_81c){_81c.stroked="f";_81c.filled="f";this.rawNode=_81c;this.rawNode.__gfxObject__=this.getUID();},_moveToFront:function(){this.rawNode.parentNode.appendChild(this.rawNode);return this;},_moveToBack:function(){var r=this.rawNode,p=r.parentNode,n=p.firstChild;p.insertBefore(r,n);if(n.tagName=="rect"){n.swapNode(r);}return this;},_getRealMatrix:function(){return this.parentMatrix?new m.Matrix2D([this.parentMatrix,this.matrix]):this.matrix;}});_80a("dojox.gfx.vml.Group",vml.Shape,{constructor:function(){gs.Container._init.call(this);},_applyTransform:function(){var _81d=this._getRealMatrix();for(var i=0;i<this.children.length;++i){this.children[i]._updateParentMatrix(_81d);}return this;},_setDimensions:function(_81e,_81f){var r=this.rawNode,rs=r.style,bs=this.bgNode.style;rs.width=_81e;rs.height=_81f;r.coordsize=_81e+" "+_81f;bs.width=_81e;bs.height=_81f;for(var i=0;i<this.children.length;++i){this.children[i]._setDimensions(_81e,_81f);}return this;}});vml.Group.nodeType="group";_80a("dojox.gfx.vml.Rect",[vml.Shape,gs.Rect],{setShape:function(_820){var _821=this.shape=g.makeParameters(this.shape,_820);this.bbox=null;var r=Math.min(1,(_821.r/Math.min(parseFloat(_821.width),parseFloat(_821.height)))).toFixed(8);var _822=this.rawNode.parentNode,_823=null;if(_822){if(_822.lastChild!==this.rawNode){for(var i=0;i<_822.childNodes.length;++i){if(_822.childNodes[i]===this.rawNode){_823=_822.childNodes[i+1];break;}}}_822.removeChild(this.rawNode);}if(has("ie")>7){var node=this.rawNode.ownerDocument.createElement("v:roundrect");node.arcsize=r;node.style.display="inline-block";this.rawNode=node;this.rawNode.__gfxObject__=this.getUID();}else{this.rawNode.arcsize=r;}if(_822){if(_823){_822.insertBefore(this.rawNode,_823);}else{_822.appendChild(this.rawNode);}}var _824=this.rawNode.style;_824.left=_821.x.toFixed();_824.top=_821.y.toFixed();_824.width=(typeof _821.width=="string"&&_821.width.indexOf("%")>=0)?_821.width:Math.max(_821.width.toFixed(),0);_824.height=(typeof _821.height=="string"&&_821.height.indexOf("%")>=0)?_821.height:Math.max(_821.height.toFixed(),0);return this.setTransform(this.matrix).setFill(this.fillStyle).setStroke(this.strokeStyle);}});vml.Rect.nodeType="roundrect";_80a("dojox.gfx.vml.Ellipse",[vml.Shape,gs.Ellipse],{setShape:function(_825){var _826=this.shape=g.makeParameters(this.shape,_825);this.bbox=null;var _827=this.rawNode.style;_827.left=(_826.cx-_826.rx).toFixed();_827.top=(_826.cy-_826.ry).toFixed();_827.width=(_826.rx*2).toFixed();_827.height=(_826.ry*2).toFixed();return this.setTransform(this.matrix);}});vml.Ellipse.nodeType="oval";_80a("dojox.gfx.vml.Circle",[vml.Shape,gs.Circle],{setShape:function(_828){var _829=this.shape=g.makeParameters(this.shape,_828);this.bbox=null;var _82a=this.rawNode.style;_82a.left=(_829.cx-_829.r).toFixed();_82a.top=(_829.cy-_829.r).toFixed();_82a.width=(_829.r*2).toFixed();_82a.height=(_829.r*2).toFixed();return this;}});vml.Circle.nodeType="oval";_80a("dojox.gfx.vml.Line",[vml.Shape,gs.Line],{constructor:function(_82b){if(_82b){_82b.setAttribute("dojoGfxType","line");}},setShape:function(_82c){var _82d=this.shape=g.makeParameters(this.shape,_82c);this.bbox=null;this.rawNode.path.v="m"+_82d.x1.toFixed()+" "+_82d.y1.toFixed()+"l"+_82d.x2.toFixed()+" "+_82d.y2.toFixed()+"e";return this.setTransform(this.matrix);}});vml.Line.nodeType="shape";_80a("dojox.gfx.vml.Polyline",[vml.Shape,gs.Polyline],{constructor:function(_82e){if(_82e){_82e.setAttribute("dojoGfxType","polyline");}},setShape:function(_82f,_830){if(_82f&&_82f instanceof Array){this.shape=g.makeParameters(this.shape,{points:_82f});if(_830&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.shape=g.makeParameters(this.shape,_82f);}this.bbox=null;this._normalizePoints();var attr=[],p=this.shape.points;if(p.length>0){attr.push("m");attr.push(p[0].x.toFixed(),p[0].y.toFixed());if(p.length>1){attr.push("l");for(var i=1;i<p.length;++i){attr.push(p[i].x.toFixed(),p[i].y.toFixed());}}}attr.push("e");this.rawNode.path.v=attr.join(" ");return this.setTransform(this.matrix);}});vml.Polyline.nodeType="shape";_80a("dojox.gfx.vml.Image",[vml.Shape,gs.Image],{setShape:function(_831){var _832=this.shape=g.makeParameters(this.shape,_831);this.bbox=null;this.rawNode.firstChild.src=_832.src;return this.setTransform(this.matrix);},_applyTransform:function(){var _833=this._getRealMatrix(),_834=this.rawNode,s=_834.style,_835=this.shape;if(_833){_833=m.multiply(_833,{dx:_835.x,dy:_835.y});}else{_833=m.normalize({dx:_835.x,dy:_835.y});}if(_833.xy==0&&_833.yx==0&&_833.xx>0&&_833.yy>0){s.filter="";s.width=Math.floor(_833.xx*_835.width);s.height=Math.floor(_833.yy*_835.height);s.left=Math.floor(_833.dx);s.top=Math.floor(_833.dy);}else{var ps=_834.parentNode.style;s.left="0px";s.top="0px";s.width=ps.width;s.height=ps.height;_833=m.multiply(_833,{xx:_835.width/parseInt(s.width),yy:_835.height/parseInt(s.height)});var f=_834.filters["DXImageTransform.Microsoft.Matrix"];if(f){f.M11=_833.xx;f.M12=_833.xy;f.M21=_833.yx;f.M22=_833.yy;f.Dx=_833.dx;f.Dy=_833.dy;}else{s.filter="progid:DXImageTransform.Microsoft.Matrix(M11="+_833.xx+", M12="+_833.xy+", M21="+_833.yx+", M22="+_833.yy+", Dx="+_833.dx+", Dy="+_833.dy+")";}}return this;},_setDimensions:function(_836,_837){var r=this.rawNode,f=r.filters["DXImageTransform.Microsoft.Matrix"];if(f){var s=r.style;s.width=_836;s.height=_837;return this._applyTransform();}return this;}});vml.Image.nodeType="rect";_80a("dojox.gfx.vml.Text",[vml.Shape,gs.Text],{constructor:function(_838){if(_838){_838.setAttribute("dojoGfxType","text");}this.fontStyle=null;},_alignment:{start:"left",middle:"center",end:"right"},setShape:function(_839){this.shape=g.makeParameters(this.shape,_839);this.bbox=null;var r=this.rawNode,s=this.shape,x=s.x,y=s.y.toFixed(),path;switch(s.align){case "middle":x-=5;break;case "end":x-=10;break;}path="m"+x.toFixed()+","+y+"l"+(x+10).toFixed()+","+y+"e";var p=null,t=null,c=r.childNodes;for(var i=0;i<c.length;++i){var tag=c[i].tagName;if(tag=="path"){p=c[i];if(t){break;}}else{if(tag=="textpath"){t=c[i];if(p){break;}}}}if(!p){p=r.ownerDocument.createElement("v:path");r.appendChild(p);}if(!t){t=r.ownerDocument.createElement("v:textpath");r.appendChild(t);}p.v=path;p.textPathOk=true;t.on=true;var a=vml.text_alignment[s.align];t.style["v-text-align"]=a?a:"left";t.style["text-decoration"]=s.decoration;t.style["v-rotate-letters"]=s.rotated;t.style["v-text-kern"]=s.kerning;t.string=s.text;return this.setTransform(this.matrix);},_setFont:function(){var f=this.fontStyle,c=this.rawNode.childNodes;for(var i=0;i<c.length;++i){if(c[i].tagName=="textpath"){c[i].style.font=g.makeFontString(f);break;}}this.setTransform(this.matrix);},_getRealMatrix:function(){var _83a=this.inherited(arguments);if(_83a){_83a=m.multiply(_83a,{dy:-g.normalizedLength(this.fontStyle?this.fontStyle.size:"10pt")*0.35});}return _83a;},getTextWidth:function(){var _83b=this.rawNode,_83c=_83b.style.display;_83b.style.display="inline";var _83d=g.pt2px(parseFloat(_83b.currentStyle.width));_83b.style.display=_83c;return _83d;}});vml.Text.nodeType="shape";_80a("dojox.gfx.vml.Path",[vml.Shape,_80e.Path],{constructor:function(_83e){if(_83e&&!_83e.getAttribute("dojoGfxType")){_83e.setAttribute("dojoGfxType","path");}this.vmlPath="";this.lastControl={};},_updateWithSegment:function(_83f){var last=lang.clone(this.last);this.inherited(arguments);if(arguments.length>1){return;}var path=this[this.renderers[_83f.action]](_83f,last);if(typeof this.vmlPath=="string"){this.vmlPath+=path.join("");this.rawNode.path.v=this.vmlPath+" r0,0 e";}else{Array.prototype.push.apply(this.vmlPath,path);}},setShape:function(_840){this.vmlPath=[];this.lastControl.type="";this.inherited(arguments);this.vmlPath=this.vmlPath.join("");this.rawNode.path.v=this.vmlPath+" r0,0 e";return this;},_pathVmlToSvgMap:{m:"M",l:"L",t:"m",r:"l",c:"C",v:"c",qb:"Q",x:"z",e:""},renderers:{M:"_moveToA",m:"_moveToR",L:"_lineToA",l:"_lineToR",H:"_hLineToA",h:"_hLineToR",V:"_vLineToA",v:"_vLineToR",C:"_curveToA",c:"_curveToR",S:"_smoothCurveToA",s:"_smoothCurveToR",Q:"_qCurveToA",q:"_qCurveToR",T:"_qSmoothCurveToA",t:"_qSmoothCurveToR",A:"_arcTo",a:"_arcTo",Z:"_closePath",z:"_closePath"},_addArgs:function(path,_841,from,upto){var n=_841 instanceof Array?_841:_841.args;for(var i=from;i<upto;++i){path.push(" ",n[i].toFixed());}},_adjustRelCrd:function(last,_842,step){var n=_842 instanceof Array?_842:_842.args,l=n.length,_843=new Array(l),i=0,x=last.x,y=last.y;if(typeof x!="number"){_843[0]=x=n[0];_843[1]=y=n[1];i=2;}if(typeof step=="number"&&step!=2){var j=step;while(j<=l){for(;i<j;i+=2){_843[i]=x+n[i];_843[i+1]=y+n[i+1];}x=_843[j-2];y=_843[j-1];j+=step;}}else{for(;i<l;i+=2){_843[i]=(x+=n[i]);_843[i+1]=(y+=n[i+1]);}}return _843;},_adjustRelPos:function(last,_844){var n=_844 instanceof Array?_844:_844.args,l=n.length,_845=new Array(l);for(var i=0;i<l;++i){_845[i]=(last+=n[i]);}return _845;},_moveToA:function(_846){var p=[" m"],n=_846 instanceof Array?_846:_846.args,l=n.length;this._addArgs(p,n,0,2);if(l>2){p.push(" l");this._addArgs(p,n,2,l);}this.lastControl.type="";return p;},_moveToR:function(_847,last){return this._moveToA(this._adjustRelCrd(last,_847));},_lineToA:function(_848){var p=[" l"],n=_848 instanceof Array?_848:_848.args;this._addArgs(p,n,0,n.length);this.lastControl.type="";return p;},_lineToR:function(_849,last){return this._lineToA(this._adjustRelCrd(last,_849));},_hLineToA:function(_84a,last){var p=[" l"],y=" "+last.y.toFixed(),n=_84a instanceof Array?_84a:_84a.args,l=n.length;for(var i=0;i<l;++i){p.push(" ",n[i].toFixed(),y);}this.lastControl.type="";return p;},_hLineToR:function(_84b,last){return this._hLineToA(this._adjustRelPos(last.x,_84b),last);},_vLineToA:function(_84c,last){var p=[" l"],x=" "+last.x.toFixed(),n=_84c instanceof Array?_84c:_84c.args,l=n.length;for(var i=0;i<l;++i){p.push(x," ",n[i].toFixed());}this.lastControl.type="";return p;},_vLineToR:function(_84d,last){return this._vLineToA(this._adjustRelPos(last.y,_84d),last);},_curveToA:function(_84e){var p=[],n=_84e instanceof Array?_84e:_84e.args,l=n.length,lc=this.lastControl;for(var i=0;i<l;i+=6){p.push(" c");this._addArgs(p,n,i,i+6);}lc.x=n[l-4];lc.y=n[l-3];lc.type="C";return p;},_curveToR:function(_84f,last){return this._curveToA(this._adjustRelCrd(last,_84f,6));},_smoothCurveToA:function(_850,last){var p=[],n=_850 instanceof Array?_850:_850.args,l=n.length,lc=this.lastControl,i=0;if(lc.type!="C"){p.push(" c");this._addArgs(p,[last.x,last.y],0,2);this._addArgs(p,n,0,4);lc.x=n[0];lc.y=n[1];lc.type="C";i=4;}for(;i<l;i+=4){p.push(" c");this._addArgs(p,[2*last.x-lc.x,2*last.y-lc.y],0,2);this._addArgs(p,n,i,i+4);lc.x=n[i];lc.y=n[i+1];}return p;},_smoothCurveToR:function(_851,last){return this._smoothCurveToA(this._adjustRelCrd(last,_851,4),last);},_qCurveToA:function(_852){var p=[],n=_852 instanceof Array?_852:_852.args,l=n.length,lc=this.lastControl;for(var i=0;i<l;i+=4){p.push(" qb");this._addArgs(p,n,i,i+4);}lc.x=n[l-4];lc.y=n[l-3];lc.type="Q";return p;},_qCurveToR:function(_853,last){return this._qCurveToA(this._adjustRelCrd(last,_853,4));},_qSmoothCurveToA:function(_854,last){var p=[],n=_854 instanceof Array?_854:_854.args,l=n.length,lc=this.lastControl,i=0;if(lc.type!="Q"){p.push(" qb");this._addArgs(p,[lc.x=last.x,lc.y=last.y],0,2);lc.type="Q";this._addArgs(p,n,0,2);i=2;}for(;i<l;i+=2){p.push(" qb");this._addArgs(p,[lc.x=2*last.x-lc.x,lc.y=2*last.y-lc.y],0,2);this._addArgs(p,n,i,i+2);}return p;},_qSmoothCurveToR:function(_855,last){return this._qSmoothCurveToA(this._adjustRelCrd(last,_855,2),last);},_arcTo:function(_856,last){var p=[],n=_856.args,l=n.length,_857=_856.action=="a";for(var i=0;i<l;i+=7){var x1=n[i+5],y1=n[i+6];if(_857){x1+=last.x;y1+=last.y;}var _858=_80f.arcAsBezier(last,n[i],n[i+1],n[i+2],n[i+3]?1:0,n[i+4]?1:0,x1,y1);for(var j=0;j<_858.length;++j){p.push(" c");var t=_858[j];this._addArgs(p,t,0,t.length);this._updateBBox(t[0],t[1]);this._updateBBox(t[2],t[3]);this._updateBBox(t[4],t[5]);}last.x=x1;last.y=y1;}this.lastControl.type="";return p;},_closePath:function(){this.lastControl.type="";return ["x"];}});vml.Path.nodeType="shape";_80a("dojox.gfx.vml.TextPath",[vml.Path,_80e.TextPath],{constructor:function(_859){if(_859){_859.setAttribute("dojoGfxType","textpath");}this.fontStyle=null;if(!("text" in this)){this.text=lang.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=lang.clone(g.defaultFont);}},setText:function(_85a){this.text=g.makeParameters(this.text,typeof _85a=="string"?{text:_85a}:_85a);this._setText();return this;},setFont:function(_85b){this.fontStyle=typeof _85b=="string"?g.splitFontString(_85b):g.makeParameters(g.defaultFont,_85b);this._setFont();return this;},_setText:function(){this.bbox=null;var r=this.rawNode,s=this.text,p=null,t=null,c=r.childNodes;for(var i=0;i<c.length;++i){var tag=c[i].tagName;if(tag=="path"){p=c[i];if(t){break;}}else{if(tag=="textpath"){t=c[i];if(p){break;}}}}if(!p){p=this.rawNode.ownerDocument.createElement("v:path");r.appendChild(p);}if(!t){t=this.rawNode.ownerDocument.createElement("v:textpath");r.appendChild(t);}p.textPathOk=true;t.on=true;var a=vml.text_alignment[s.align];t.style["v-text-align"]=a?a:"left";t.style["text-decoration"]=s.decoration;t.style["v-rotate-letters"]=s.rotated;t.style["v-text-kern"]=s.kerning;t.string=s.text;},_setFont:function(){var f=this.fontStyle,c=this.rawNode.childNodes;for(var i=0;i<c.length;++i){if(c[i].tagName=="textpath"){c[i].style.font=g.makeFontString(f);break;}}}});vml.TextPath.nodeType="shape";_80a("dojox.gfx.vml.Surface",gs.Surface,{constructor:function(){gs.Container._init.call(this);},setDimensions:function(_85c,_85d){this.width=g.normalizedLength(_85c);this.height=g.normalizedLength(_85d);if(!this.rawNode){return this;}var cs=this.clipNode.style,r=this.rawNode,rs=r.style,bs=this.bgNode.style,ps=this._parent.style,i;ps.width=_85c;ps.height=_85d;cs.width=_85c;cs.height=_85d;cs.clip="rect(0px "+_85c+"px "+_85d+"px 0px)";rs.width=_85c;rs.height=_85d;r.coordsize=_85c+" "+_85d;bs.width=_85c;bs.height=_85d;for(i=0;i<this.children.length;++i){this.children[i]._setDimensions(_85c,_85d);}return this;},getDimensions:function(){var t=this.rawNode?{width:g.normalizedLength(this.rawNode.style.width),height:g.normalizedLength(this.rawNode.style.height)}:null;if(t.width<=0){t.width=this.width;}if(t.height<=0){t.height=this.height;}return t;}});vml.createSurface=function(_85e,_85f,_860){if(!_85f&&!_860){var pos=_80d.position(_85e);_85f=_85f||pos.w;_860=_860||pos.h;}if(typeof _85f=="number"){_85f=_85f+"px";}if(typeof _860=="number"){_860=_860+"px";}var s=new vml.Surface(),p=dom.byId(_85e),c=s.clipNode=p.ownerDocument.createElement("div"),r=s.rawNode=p.ownerDocument.createElement("v:group"),cs=c.style,rs=r.style;if(has("ie")>7){rs.display="inline-block";}s._parent=p;s._nodes.push(c);p.style.width=_85f;p.style.height=_860;cs.position="absolute";cs.width=_85f;cs.height=_860;cs.clip="rect(0px "+_85f+" "+_860+" 0px)";rs.position="absolute";rs.width=_85f;rs.height=_860;r.coordsize=(_85f==="100%"?_85f:parseFloat(_85f))+" "+(_860==="100%"?_860:parseFloat(_860));r.coordorigin="0 0";var b=s.bgNode=r.ownerDocument.createElement("v:rect"),bs=b.style;bs.left=bs.top=0;bs.width=rs.width;bs.height=rs.height;b.filled=b.stroked="f";r.appendChild(b);c.appendChild(r);p.appendChild(c);s.width=g.normalizedLength(_85f);s.height=g.normalizedLength(_860);return s;};function _861(_862,f,o){o=o||win.global;f.call(o,_862);if(_862 instanceof g.Surface||_862 instanceof g.Group){arr.forEach(_862.children,function(_863){_861(_863,f,o);});}};var _864=function(_865){if(this!=_865.getParent()){var _866=_865.getParent();if(_866){_866.remove(_865);}this.rawNode.appendChild(_865.rawNode);C.add.apply(this,arguments);_861(this,function(s){if(typeof (s.getFont)=="function"){s.setShape(s.getShape());s.setFont(s.getFont());}if(typeof (s.setFill)=="function"){s.setFill(s.getFill());s.setStroke(s.getStroke());}});}return this;};var _867=function(_868){if(this!=_868.getParent()){this.rawNode.appendChild(_868.rawNode);if(!_868.getParent()){_868.setFill(_868.getFill());_868.setStroke(_868.getStroke());}C.add.apply(this,arguments);}return this;};var C=gs.Container,_869={add:_80c.fixVmlAdd===true?_864:_867,remove:function(_86a,_86b){if(this==_86a.getParent()){if(this.rawNode==_86a.rawNode.parentNode){this.rawNode.removeChild(_86a.rawNode);}C.remove.apply(this,arguments);}return this;},clear:function(){var r=this.rawNode;while(r.firstChild!=r.lastChild){if(r.firstChild!=this.bgNode){r.removeChild(r.firstChild);}if(r.lastChild!=this.bgNode){r.removeChild(r.lastChild);}}return C.clear.apply(this,arguments);},_moveChildToFront:C._moveChildToFront,_moveChildToBack:C._moveChildToBack};var _86c={createGroup:function(){var node=this.createObject(vml.Group,null);var r=node.rawNode.ownerDocument.createElement("v:rect");r.style.left=r.style.top=0;r.style.width=node.rawNode.style.width;r.style.height=node.rawNode.style.height;r.filled=r.stroked="f";node.rawNode.appendChild(r);node.bgNode=r;return node;},createImage:function(_86d){if(!this.rawNode){return null;}var _86e=new vml.Image(),doc=this.rawNode.ownerDocument,node=doc.createElement("v:rect");node.stroked="f";node.style.width=this.rawNode.style.width;node.style.height=this.rawNode.style.height;var img=doc.createElement("v:imagedata");node.appendChild(img);_86e.setRawNode(node);this.rawNode.appendChild(node);_86e.setShape(_86d);this.add(_86e);return _86e;},createRect:function(rect){if(!this.rawNode){return null;}var _86f=new vml.Rect,node=this.rawNode.ownerDocument.createElement("v:roundrect");if(has("ie")>7){node.style.display="inline-block";}_86f.setRawNode(node);this.rawNode.appendChild(node);_86f.setShape(rect);this.add(_86f);return _86f;},createObject:function(_870,_871){if(!this.rawNode){return null;}var _872=new _870(),node=this.rawNode.ownerDocument.createElement("v:"+_870.nodeType);_872.setRawNode(node);this.rawNode.appendChild(node);switch(_870){case vml.Group:case vml.Line:case vml.Polyline:case vml.Image:case vml.Text:case vml.Path:case vml.TextPath:this._overrideSize(node);}_872.setShape(_871);this.add(_872);return _872;},_overrideSize:function(node){var s=this.rawNode.style,w=s.width,h=s.height;node.style.width=w;node.style.height=h;node.coordsize=parseInt(w)+" "+parseInt(h);}};lang.extend(vml.Group,_869);lang.extend(vml.Group,gs.Creator);lang.extend(vml.Group,_86c);lang.extend(vml.Surface,_869);lang.extend(vml.Surface,gs.Creator);lang.extend(vml.Surface,_86c);vml.fixTarget=function(_873,_874){if(!_873.gfxTarget){_873.gfxTarget=gs.byId(_873.target.__gfxObject__);}return true;};return vml;});},"dojo/touch":function(){define(["./_base/kernel","./on","./has","./mouse"],function(dojo,on,has,_875){function _876(type){return function(node,_877){return on(node,type,_877);};};var _878=has("touch");dojo.touch={press:_876(_878?"touchstart":"mousedown"),move:_876(_878?"touchmove":"mousemove"),release:_876(_878?"touchend":"mouseup"),cancel:_878?_876("touchcancel"):_875.leave};return dojo.touch;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo,text){return dojo.cache;});},"dojox/gfx/gradutils":function(){define("dojox/gfx/gradutils",["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_879){var _87a=g.gradutils={};function _87b(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _879.blendColors(new _879(prev.color),new _879(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_87a.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _87c=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_87d=m.rotate(-_87c),_87e=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_87e,pt),pf1=m.multiplyPoint(_87e,fill.x1,fill.y1),pf2=m.multiplyPoint(_87e,fill.x2,fill.y2),_87f=m.multiplyPoint(_87d,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_87d,p.x-pf1.x,p.y-pf1.y).x/_87f;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _87b(o,fill.colors);}return new _879(fill||[0,0,0,0]);};_87a.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _87a;});},"dojox/charting/themes/common":function(){define("dojox/charting/themes/common",["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojo/_base/xhr":function(){define(["./kernel","./sniff","require","../io-query","../dom","../dom-form","./Deferred","./json","./lang","./array","../on"],function(dojo,has,_880,ioq,dom,_881,_882,json,lang,_883,on){has.add("native-xhr",function(){return typeof XMLHttpRequest!=="undefined";});if(1){dojo._xhrObj=_880.getXhr;}else{if(has("native-xhr")){dojo._xhrObj=function(){try{return new XMLHttpRequest();}catch(e){throw new Error("XMLHTTP not available: "+e);}};}else{for(var _884=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"],_885,i=0;i<3;){try{_885=_884[i++];if(new ActiveXObject(_885)){break;}}catch(e){}}dojo._xhrObj=function(){return new ActiveXObject(_885);};}}var cfg=dojo.config;dojo.objectToQuery=ioq.objectToQuery;dojo.queryToObject=ioq.queryToObject;dojo.fieldToObject=_881.fieldToObject;dojo.formToObject=_881.toObject;dojo.formToQuery=_881.toQuery;dojo.formToJson=_881.toJson;dojo._blockAsync=false;var _886=dojo._contentHandlers=dojo.contentHandlers={"text":function(xhr){return xhr.responseText;},"json":function(xhr){return json.fromJson(xhr.responseText||null);},"json-comment-filtered":function(xhr){if(!dojo.config.useCommentedJson){console.warn("Consider using the standard mimetype:application/json."+" json-commenting can introduce security issues. To"+" decrease the chances of hijacking, use the standard the 'json' handler and"+" prefix your json with: {}&&\n"+"Use djConfig.useCommentedJson=true to turn off this message.");}var _887=xhr.responseText;var _888=_887.indexOf("/*");var _889=_887.lastIndexOf("*/");if(_888==-1||_889==-1){throw new Error("JSON was not comment filtered");}return json.fromJson(_887.substring(_888+2,_889));},"javascript":function(xhr){return dojo.eval(xhr.responseText);},"xml":function(xhr){var _88a=xhr.responseXML;if(has("ie")){if((!_88a||!_88a.documentElement)){var ms=function(n){return "MSXML"+n+".DOMDocument";};var dp=["Microsoft.XMLDOM",ms(6),ms(4),ms(3),ms(2)];_883.some(dp,function(p){try{var dom=new ActiveXObject(p);dom.async=false;dom.loadXML(xhr.responseText);_88a=dom;}catch(e){return false;}return true;});}}return _88a;},"json-comment-optional":function(xhr){if(xhr.responseText&&/^[^{\[]*\/\*/.test(xhr.responseText)){return _886["json-comment-filtered"](xhr);}else{return _886["json"](xhr);}}};dojo._ioSetArgs=function(args,_88b,_88c,_88d){var _88e={args:args,url:args.url};var _88f=null;if(args.form){var form=dom.byId(args.form);var _890=form.getAttributeNode("action");_88e.url=_88e.url||(_890?_890.value:null);_88f=_881.toObject(form);}var _891=[{}];if(_88f){_891.push(_88f);}if(args.content){_891.push(args.content);}if(args.preventCache){_891.push({"dojo.preventCache":new Date().valueOf()});}_88e.query=ioq.objectToQuery(lang.mixin.apply(null,_891));_88e.handleAs=args.handleAs||"text";var d=new _882(_88b);d.addCallbacks(_88c,function(_892){return _88d(_892,d);});var ld=args.load;if(ld&&lang.isFunction(ld)){d.addCallback(function(_893){return ld.call(args,_893,_88e);});}var err=args.error;if(err&&lang.isFunction(err)){d.addErrback(function(_894){return err.call(args,_894,_88e);});}var _895=args.handle;if(_895&&lang.isFunction(_895)){d.addBoth(function(_896){return _895.call(args,_896,_88e);});}if(cfg.ioPublish&&dojo.publish&&_88e.args.ioPublish!==false){d.addCallbacks(function(res){dojo.publish("/dojo/io/load",[d,res]);return res;},function(res){dojo.publish("/dojo/io/error",[d,res]);return res;});d.addBoth(function(res){dojo.publish("/dojo/io/done",[d,res]);return res;});}d.ioArgs=_88e;return d;};var _897=function(dfd){dfd.canceled=true;var xhr=dfd.ioArgs.xhr;var _898=typeof xhr.abort;if(_898=="function"||_898=="object"||_898=="unknown"){xhr.abort();}var err=dfd.ioArgs.error;if(!err){err=new Error("xhr cancelled");err.dojoType="cancel";}return err;};var _899=function(dfd){var ret=_886[dfd.ioArgs.handleAs](dfd.ioArgs.xhr);return ret===undefined?null:ret;};var _89a=function(_89b,dfd){if(!dfd.ioArgs.args.failOk){console.error(_89b);}return _89b;};var _89c=null;var _89d=[];var _89e=0;var _89f=function(dfd){if(_89e<=0){_89e=0;if(cfg.ioPublish&&dojo.publish&&(!dfd||dfd&&dfd.ioArgs.args.ioPublish!==false)){dojo.publish("/dojo/io/stop");}}};var _8a0=function(){var now=(new Date()).getTime();if(!dojo._blockAsync){for(var i=0,tif;i<_89d.length&&(tif=_89d[i]);i++){var dfd=tif.dfd;var func=function(){if(!dfd||dfd.canceled||!tif.validCheck(dfd)){_89d.splice(i--,1);_89e-=1;}else{if(tif.ioCheck(dfd)){_89d.splice(i--,1);tif.resHandle(dfd);_89e-=1;}else{if(dfd.startTime){if(dfd.startTime+(dfd.ioArgs.args.timeout||0)<now){_89d.splice(i--,1);var err=new Error("timeout exceeded");err.dojoType="timeout";dfd.errback(err);dfd.cancel();_89e-=1;}}}}};if(dojo.config.debugAtAllCosts){func.call(this);}else{func.call(this);}}}_89f(dfd);if(!_89d.length){clearInterval(_89c);_89c=null;}};dojo._ioCancelAll=function(){try{_883.forEach(_89d,function(i){try{i.dfd.cancel();}catch(e){}});}catch(e){}};if(has("ie")){on(window,"unload",dojo._ioCancelAll);}dojo._ioNotifyStart=function(dfd){if(cfg.ioPublish&&dojo.publish&&dfd.ioArgs.args.ioPublish!==false){if(!_89e){dojo.publish("/dojo/io/start");}_89e+=1;dojo.publish("/dojo/io/send",[dfd]);}};dojo._ioWatch=function(dfd,_8a1,_8a2,_8a3){var args=dfd.ioArgs.args;if(args.timeout){dfd.startTime=(new Date()).getTime();}_89d.push({dfd:dfd,validCheck:_8a1,ioCheck:_8a2,resHandle:_8a3});if(!_89c){_89c=setInterval(_8a0,50);}if(args.sync){_8a0();}};var _8a4="application/x-www-form-urlencoded";var _8a5=function(dfd){return dfd.ioArgs.xhr.readyState;};var _8a6=function(dfd){return 4==dfd.ioArgs.xhr.readyState;};var _8a7=function(dfd){var xhr=dfd.ioArgs.xhr;if(dojo._isDocumentOk(xhr)){dfd.callback(dfd);}else{var err=new Error("Unable to load "+dfd.ioArgs.url+" status:"+xhr.status);err.status=xhr.status;err.responseText=xhr.responseText;err.xhr=xhr;dfd.errback(err);}};dojo._ioAddQueryToUrl=function(_8a8){if(_8a8.query.length){_8a8.url+=(_8a8.url.indexOf("?")==-1?"?":"&")+_8a8.query;_8a8.query=null;}};dojo.xhr=function(_8a9,args,_8aa){var dfd=dojo._ioSetArgs(args,_897,_899,_89a);var _8ab=dfd.ioArgs;var xhr=_8ab.xhr=dojo._xhrObj(_8ab.args);if(!xhr){dfd.cancel();return dfd;}if("postData" in args){_8ab.query=args.postData;}else{if("putData" in args){_8ab.query=args.putData;}else{if("rawBody" in args){_8ab.query=args.rawBody;}else{if((arguments.length>2&&!_8aa)||"POST|PUT".indexOf(_8a9.toUpperCase())==-1){dojo._ioAddQueryToUrl(_8ab);}}}}xhr.open(_8a9,_8ab.url,args.sync!==true,args.user||undefined,args.password||undefined);if(args.headers){for(var hdr in args.headers){if(hdr.toLowerCase()==="content-type"&&!args.contentType){args.contentType=args.headers[hdr];}else{if(args.headers[hdr]){xhr.setRequestHeader(hdr,args.headers[hdr]);}}}}if(args.contentType!==false){xhr.setRequestHeader("Content-Type",args.contentType||_8a4);}if(!args.headers||!("X-Requested-With" in args.headers)){xhr.setRequestHeader("X-Requested-With","XMLHttpRequest");}dojo._ioNotifyStart(dfd);if(dojo.config.debugAtAllCosts){xhr.send(_8ab.query);}else{try{xhr.send(_8ab.query);}catch(e){_8ab.error=e;dfd.cancel();}}dojo._ioWatch(dfd,_8a5,_8a6,_8a7);xhr=null;return dfd;};dojo.xhrGet=function(args){return dojo.xhr("GET",args);};dojo.rawXhrPost=dojo.xhrPost=function(args){return dojo.xhr("POST",args,true);};dojo.rawXhrPut=dojo.xhrPut=function(args){return dojo.xhr("PUT",args,true);};dojo.xhrDelete=function(args){return dojo.xhr("DELETE",args);};dojo._isDocumentOk=function(http){var stat=http.status||0;stat=(stat>=200&&stat<300)||stat==304||stat==1223||!stat;return stat;};dojo._getText=function(url){var _8ac;dojo.xhrGet({url:url,sync:true,load:function(text){_8ac=text;}});return _8ac;};lang.mixin(dojo.xhr,{_xhrObj:dojo._xhrObj,fieldToObject:_881.fieldToObject,formToObject:_881.toObject,objectToQuery:ioq.objectToQuery,formToQuery:_881.toQuery,formToJson:_881.toJson,queryToObject:ioq.queryToObject,contentHandlers:_886,_ioSetArgs:dojo._ioSetArgs,_ioCancelAll:dojo._ioCancelAll,_ioNotifyStart:dojo._ioNotifyStart,_ioWatch:dojo._ioWatch,_ioAddQueryToUrl:dojo._ioAddQueryToUrl,_isDocumentOk:dojo._isDocumentOk,_getText:dojo._getText,get:dojo.xhrGet,post:dojo.xhrPost,put:dojo.xhrPut,del:dojo.xhrDelete});return dojo.xhr;});},"dijit/DialogUnderlay":function(){define("dijit/DialogUnderlay",["dojo/_base/declare","dojo/dom-attr","dojo/_base/window","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe"],function(_8ad,_8ae,win,_8af,_8b0,_8b1,_8b2){return _8ad("dijit.DialogUnderlay",[_8b0,_8b1],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_setDialogIdAttr:function(id){_8ae.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_8b3){this.node.className="dijitDialogUnderlay "+_8b3;this._set("class",_8b3);},postCreate:function(){win.body().appendChild(this.domNode);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _8b4=_8af.getBox();os.top=_8b4.t+"px";os.left=_8b4.l+"px";is.width=_8b4.w+"px";is.height=_8b4.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.layout();this.bgIframe=new _8b2(this.domNode);},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";}});});},"dojo/cldr/nls/gregorian":function(){define({root:{"months-format-narrow":["1","2","3","4","5","6","7","8","9","10","11","12"],"quarters-standAlone-narrow":["1","2","3","4"],"field-weekday":"Day of the Week","dateFormatItem-yQQQ":"y QQQ","dateFormatItem-yMEd":"EEE, y-M-d","dateFormatItem-MMMEd":"E MMM d","eraNarrow":["BCE","CE"],"dateTimeFormats-appendItem-Day-Of-Week":"{0} {1}","dateFormat-long":"y MMMM d","months-format-wide":["1","2","3","4","5","6","7","8","9","10","11","12"],"dateTimeFormat-medium":"{1} {0}","dateFormatItem-EEEd":"d EEE","dayPeriods-format-wide-pm":"PM","dateFormat-full":"EEEE, y MMMM dd","dateFormatItem-Md":"M-d","dayPeriods-format-abbr-am":"AM","dateTimeFormats-appendItem-Second":"{0} ({2}: {1})","field-era":"Era","dateFormatItem-yM":"y-M","months-standAlone-wide":["1","2","3","4","5","6","7","8","9","10","11","12"],"timeFormat-short":"HH:mm","quarters-format-wide":["Q1","Q2","Q3","Q4"],"timeFormat-long":"HH:mm:ss z","field-year":"Year","dateFormatItem-yMMM":"y MMM","dateFormatItem-yQ":"y Q","dateTimeFormats-appendItem-Era":"{0} {1}","field-hour":"Hour","months-format-abbr":["1","2","3","4","5","6","7","8","9","10","11","12"],"timeFormat-full":"HH:mm:ss zzzz","dateTimeFormats-appendItem-Week":"{0} ({2}: {1})","field-day-relative+0":"Today","field-day-relative+1":"Tomorrow","dateFormatItem-H":"HH","months-standAlone-abbr":["1","2","3","4","5","6","7","8","9","10","11","12"],"quarters-format-abbr":["Q1","Q2","Q3","Q4"],"quarters-standAlone-wide":["Q1","Q2","Q3","Q4"],"dateFormatItem-M":"L","days-standAlone-wide":["1","2","3","4","5","6","7"],"timeFormat-medium":"HH:mm:ss","dateFormatItem-Hm":"HH:mm","quarters-standAlone-abbr":["Q1","Q2","Q3","Q4"],"eraAbbr":["BCE","CE"],"field-minute":"Minute","field-dayperiod":"Dayperiod","days-standAlone-abbr":["1","2","3","4","5","6","7"],"dateFormatItem-d":"d","dateFormatItem-ms":"mm:ss","quarters-format-narrow":["1","2","3","4"],"field-day-relative+-1":"Yesterday","dateFormatItem-h":"h a","dateTimeFormat-long":"{1} {0}","dayPeriods-format-narrow-am":"AM","dateFormatItem-MMMd":"MMM d","dateFormatItem-MEd":"E, M-d","dateTimeFormat-full":"{1} {0}","field-day":"Day","days-format-wide":["1","2","3","4","5","6","7"],"field-zone":"Zone","dateTimeFormats-appendItem-Day":"{0} ({2}: {1})","dateFormatItem-y":"y","months-standAlone-narrow":["1","2","3","4","5","6","7","8","9","10","11","12"],"dateFormatItem-hm":"h:mm a","dateTimeFormats-appendItem-Year":"{0} {1}","dateTimeFormats-appendItem-Hour":"{0} ({2}: {1})","dayPeriods-format-abbr-pm":"PM","days-format-abbr":["1","2","3","4","5","6","7"],"eraNames":["BCE","CE"],"days-format-narrow":["1","2","3","4","5","6","7"],"days-standAlone-narrow":["1","2","3","4","5","6","7"],"dateFormatItem-MMM":"LLL","field-month":"Month","dateTimeFormats-appendItem-Quarter":"{0} ({2}: {1})","dayPeriods-format-wide-am":"AM","dateTimeFormats-appendItem-Month":"{0} ({2}: {1})","dateTimeFormats-appendItem-Minute":"{0} ({2}: {1})","dateFormat-short":"yyyy-MM-dd","field-second":"Second","dateFormatItem-yMMMEd":"EEE, y MMM d","dateTimeFormats-appendItem-Timezone":"{0} {1}","field-week":"Week","dateFormat-medium":"y MMM d","dayPeriods-format-narrow-pm":"PM","dateTimeFormat-short":"{1} {0}","dateFormatItem-Hms":"HH:mm:ss","dateFormatItem-hms":"h:mm:ss a"},"ar":true,"ca":true,"cs":true,"da":true,"de":true,"el":true,"en":true,"en-au":true,"en-ca":true,"en-gb":true,"es":true,"fi":true,"fr":true,"fr-ch":true,"he":true,"hu":true,"it":true,"ja":true,"ko":true,"nb":true,"nl":true,"pl":true,"pt":true,"pt-pt":true,"ro":true,"ru":true,"sk":true,"sl":true,"sv":true,"th":true,"tr":true,"zh":true,"zh-hant":true,"zh-hk":true,"zh-tw":true});},"dijit/form/_ToggleButtonMixin":function(){define("dijit/form/_ToggleButtonMixin",["dojo/_base/declare","dojo/dom-attr"],function(_8b5,_8b6){return _8b5("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _8b7=this.checked;this._set("checked",!_8b7);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_8b7);return ret;},_setCheckedAttr:function(_8b8,_8b9){this._set("checked",_8b8);_8b6.set(this.focusNode||this.domNode,"checked",_8b8);(this.focusNode||this.domNode).setAttribute(this._aria_attr,_8b8?"true":"false");this._handleOnChange(_8b8,_8b9);},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/form/VerticalSlider":function(){require({cache:{"url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n"}});define("dijit/form/VerticalSlider",["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_8ba,_8bb,_8bc){return _8ba("dijit.form.VerticalSlider",_8bb,{templateString:_8bc,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){return this._descending;}});});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_8bd){return function(_8be,_8bf){switch(typeof _8be){default:throw new Error("Can not query with a "+typeof _8be);case "object":case "undefined":var _8c0=_8be;_8be=function(_8c1){for(var key in _8c0){var _8c2=_8c0[key];if(_8c2&&_8c2.test){if(!_8c2.test(_8c1[key])){return false;}}else{if(_8c2!=_8c1[key]){return false;}}}return true;};break;case "string":if(!this[_8be]){throw new Error("No filter function "+_8be+" was found in store");}_8be=this[_8be];case "function":}function _8c3(_8c4){var _8c5=_8bd.filter(_8c4,_8be);if(_8bf&&_8bf.sort){_8c5.sort(function(a,b){for(var sort,i=0;sort=_8bf.sort[i];i++){var _8c6=a[sort.attribute];var _8c7=b[sort.attribute];if(_8c6!=_8c7){return !!sort.descending==_8c6>_8c7?-1:1;}}return 0;});}if(_8bf&&(_8bf.start||_8bf.count)){var _8c8=_8c5.length;_8c5=_8c5.slice(_8bf.start||0,(_8bf.start||0)+(_8bf.count||Infinity));_8c5.total=_8c8;}return _8c5;};_8c3.matches=_8be;return _8c3;};});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(lang,_8c9,_8ca,_8cb,_8cc,_8cd,_8ce,_8cf,has,_8d0,win){var _8d1=_8ce("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _8d2=this.declaredClass,_8d3=this;return _8cb.substitute(tmpl,this,function(_8d4,key){if(key.charAt(0)=="!"){_8d4=lang.getObject(key.substr(1),false,_8d3);}if(typeof _8d4=="undefined"){throw new Error(_8d2+" template:"+key);}if(_8d4==null){return "";}return key.charAt(0)=="!"?_8d4:_8d4.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_8cc(this.templatePath,{sanitize:true});}var _8d5=_8d1.getCachedTemplate(this.templateString,this._skipNodeCache);var node;if(lang.isString(_8d5)){node=_8cf.toDom(this._stringRepl(_8d5));if(node.nodeType!=1){throw new Error("Invalid template: "+_8d5);}}else{node=_8d5.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_8d6){var dest=this.containerNode;if(_8d6&&dest){while(_8d6.hasChildNodes()){dest.appendChild(_8d6.firstChild);}}},_attachTemplateNodes:function(_8d7,_8d8){var _8d9=lang.isArray(_8d7)?_8d7:(_8d7.all||_8d7.getElementsByTagName("*"));var x=lang.isArray(_8d7)?0:-1;for(;x<_8d9.length;x++){var _8da=(x==-1)?_8d7:_8d9[x];if(this.widgetsInTemplate&&(_8d8(_8da,"dojoType")||_8d8(_8da,"data-dojo-type"))){continue;}var _8db=_8d8(_8da,"dojoAttachPoint")||_8d8(_8da,"data-dojo-attach-point");if(_8db){var _8dc,_8dd=_8db.split(/\s*,\s*/);while((_8dc=_8dd.shift())){if(lang.isArray(this[_8dc])){this[_8dc].push(_8da);}else{this[_8dc]=_8da;}this._attachPoints.push(_8dc);}}var _8de=_8d8(_8da,"dojoAttachEvent")||_8d8(_8da,"data-dojo-attach-event");if(_8de){var _8df,_8e0=_8de.split(/\s*,\s*/);var trim=lang.trim;while((_8df=_8e0.shift())){if(_8df){var _8e1=null;if(_8df.indexOf(":")!=-1){var _8e2=_8df.split(":");_8df=trim(_8e2[0]);_8e1=trim(_8e2[1]);}else{_8df=trim(_8df);}if(!_8e1){_8e1=_8df;}this._attachEvents.push(this.connect(_8da,_8c9[_8df]||_8df,_8e1));}}}}},destroyRendering:function(){_8cd.forEach(this._attachPoints,function(_8e3){delete this[_8e3];},this);this._attachPoints=[];_8cd.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_8d1._templateCache={};_8d1.getCachedTemplate=function(_8e4,_8e5){var _8e6=_8d1._templateCache;var key=_8e4;var _8e7=_8e6[key];if(_8e7){try{if(!_8e7.ownerDocument||_8e7.ownerDocument==win.doc){return _8e7;}}catch(e){}_8cf.destroy(_8e7);}_8e4=_8cb.trim(_8e4);if(_8e5||_8e4.match(/\$\{([^\}]+)\}/g)){return (_8e6[key]=_8e4);}else{var node=_8cf.toDom(_8e4);if(node.nodeType!=1){throw new Error("Invalid template: "+_8e4);}return (_8e6[key]=node);}};if(has("ie")){_8d0.addOnWindowUnload(function(){var _8e8=_8d1._templateCache;for(var key in _8e8){var _8e9=_8e8[key];if(typeof _8e9=="object"){_8cf.destroy(_8e9);}delete _8e8[key];}});}lang.extend(_8ca,{dojoAttachEvent:"",dojoAttachPoint:""});return _8d1;});},"dojox/charting/plot2d/MarkersOnly":function(){define("dojox/charting/plot2d/MarkersOnly",["dojo/_base/declare","./Default"],function(_8ea,_8eb){return _8ea("dojox.charting.plot2d.MarkersOnly",_8eb,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define("dojox/charting/plot2d/Areas",["dojo/_base/declare","./Default"],function(_8ec,_8ed){return _8ec("dojox.charting.plot2d.Areas",_8ed,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojo/dnd/AutoSource":function(){define(["./Source"],function(_8ee){return dojo.declare("dojo.dnd.AutoSource",_8ee,{constructor:function(node,_8ef){this.autoSync=true;}});});},"url:dijit/templates/Tree.html":"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\"\n\tdata-dojo-attach-event=\"onkeypress:_onKeyPress\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\"\n\t\t/></td></tr></tbody\n></table>\n","dijit/form/HorizontalSlider":function(){require({cache:{"url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n"}});define("dijit/form/HorizontalSlider",["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/event","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/_base/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","../registry","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_8f0,_8f1,move,_8f2,fx,_8f3,_8f4,keys,lang,has,_8f5,_8f6,_8f7,_8f8,_8f9,_8fa,_8fb,_8fc,_8fd,_8fe){var _8ff=_8f1("dijit.form._SliderMover",_8f6,{onMouseMove:function(e){var _900=this.widget;var _901=_900._abspos;if(!_901){_901=_900._abspos=_8f3.position(_900.sliderBarContainer,true);_900._setPixelValue_=lang.hitch(_900,"_setPixelValue");_900._isReversed_=_900._isReversed();}var _902=e[_900._mousePixelCoord]-_901[_900._startingPixelCoord];_900._setPixelValue_(_900._isReversed_?(_901[_900._pixelCount]-_902):_902,_901[_900._pixelCount],false);},destroy:function(e){_8f6.prototype.destroy.apply(this,arguments);var _903=this.widget;_903._abspos=null;_903._setValueAttr(_903.value,true);}});var _904=_8f1("dijit.form.HorizontalSlider",[_8fc,_8fd],{templateString:_8fe,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_8f8.defaultDuration,_setIdAttr:"",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyPress:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.charOrCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}_8f2.stop(e);},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){_8f9.focus(this.sliderHandle);}_8f2.stop(e);},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}_8f9.focus(this.sliderHandle);_8f2.stop(e);var _905=_8f3.position(this.sliderBarContainer,true);var _906=e[this._mousePixelCoord]-_905[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_905[this._pixelCount]-_906):_906,_905[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_907,_908,_909){if(this.disabled||this.readOnly){return;}var _90a=this.discreteValues;if(_90a<=1||_90a==Infinity){_90a=_908;}_90a--;var _90b=_908/_90a;var _90c=Math.round(_907/_90b);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_90c/_90a+this.minimum,this.maximum),this.minimum),_909);},_setValueAttr:function(_90d,_90e){this._set("value",_90d);this.valueNode.value=_90d;this.focusNode.setAttribute("aria-valuenow",_90d);this.inherited(arguments);var _90f=(_90d-this.minimum)/(this.maximum-this.minimum);var _910=(this._descending===false)?this.remainingBar:this.progressBar;var _911=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_90e&&this.slideDuration>0&&_910.style[this._progressPixelSize]){var _912=this;var _913={};var _914=parseFloat(_910.style[this._progressPixelSize]);var _915=this.slideDuration*(_90f-_914/100);if(_915==0){return;}if(_915<0){_915=0-_915;}_913[this._progressPixelSize]={start:_914,end:_90f*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_910,duration:_915,onAnimate:function(v){_911.style[_912._progressPixelSize]=(100-parseFloat(v[_912._progressPixelSize]))+"%";},onEnd:function(){delete _912._inProgressAnim;},properties:_913});this._inProgressAnim.play();}else{_910.style[this._progressPixelSize]=(_90f*100)+"%";_911.style[this._progressPixelSize]=((1-_90f)*100)+"%";}},_bumpValue:function(_916,_917){if(this.disabled||this.readOnly){return;}var s=_8f4.getComputedStyle(this.sliderBarContainer);var c=_8f3.getContentBox(this.sliderBarContainer,s);var _918=this.discreteValues;if(_918<=1||_918==Infinity){_918=c[this._pixelCount];}_918--;var _919=(this.value-this.minimum)*_918/(this.maximum-this.minimum)+_916;if(_919<0){_919=0;}if(_919>_918){_919=_918;}_919=_919*(this.maximum-this.minimum)/_918+this.minimum;this._setValueAttr(_919,_917);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.charOrCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.charOrCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){_8f2.stop(evt);var _91a=!has("mozilla");var _91b=evt[(_91a?"wheelDelta":"detail")]*(_91a?1:-1);this._bumpValue(_91b<0?-1:1,true);},startup:function(){if(this._started){return;}_8f0.forEach(this.getChildren(),function(_91c){if(this[_91c.container]!=this.containerNode){this[_91c.container].appendChild(_91c.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(_91d,_91e,e){if(_91d==-1){this._setValueAttr(this.value,true);}else{this[(_91e==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var _91f=_8f7("label[for=\""+this.id+"\"]");if(_91f.length){_91f[0].id=(this.id+"_label");this.focusNode.setAttribute("aria-labelledby",_91f[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this._connects.push(_8fa.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500));this._connects.push(_8fa.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.connect(this.domNode,!has("mozilla")?"onmousewheel":"DOMMouseScroll","_mouseWheeled");var _920=_8f1(_8ff,{widget:this});this._movable=new _8f5(this.sliderHandle,{mover:_920});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this._supportingWidgets=_8f8.findWidgets(this.domNode);this.inherited(arguments);}});_904._Mover=_8ff;return _904;});},"dojo/dnd/Manager":function(){define(["../main","../Evented","./common","./autoscroll","./Avatar"],function(dojo,_921){var _922=dojo.declare("dojo.dnd.Manager",[_921],{constructor:function(){this.avatar=null;this.source=null;this.nodes=[];this.copy=true;this.target=null;this.canDropFlag=false;this.events=[];},OFFSET_X:16,OFFSET_Y:16,overSource:function(_923){if(this.avatar){this.target=(_923&&_923.targetState!="Disabled")?_923:null;this.canDropFlag=Boolean(this.target);this.avatar.update();}dojo.publish("/dnd/source/over",[_923]);},outSource:function(_924){if(this.avatar){if(this.target==_924){this.target=null;this.canDropFlag=false;this.avatar.update();dojo.publish("/dnd/source/over",[null]);}}else{dojo.publish("/dnd/source/over",[null]);}},startDrag:function(_925,_926,copy){this.source=_925;this.nodes=_926;this.copy=Boolean(copy);this.avatar=this.makeAvatar();dojo.body().appendChild(this.avatar.node);dojo.publish("/dnd/start",[_925,_926,this.copy]);this.events=[dojo.connect(dojo.doc,"onmousemove",this,"onMouseMove"),dojo.connect(dojo.doc,"onmouseup",this,"onMouseUp"),dojo.connect(dojo.doc,"onkeydown",this,"onKeyDown"),dojo.connect(dojo.doc,"onkeyup",this,"onKeyUp"),dojo.connect(dojo.doc,"ondragstart",dojo.stopEvent),dojo.connect(dojo.body(),"onselectstart",dojo.stopEvent)];var c="dojoDnd"+(copy?"Copy":"Move");dojo.addClass(dojo.body(),c);},canDrop:function(flag){var _927=Boolean(this.target&&flag);if(this.canDropFlag!=_927){this.canDropFlag=_927;this.avatar.update();}},stopDrag:function(){dojo.removeClass(dojo.body(),["dojoDndCopy","dojoDndMove"]);dojo.forEach(this.events,dojo.disconnect);this.events=[];this.avatar.destroy();this.avatar=null;this.source=this.target=null;this.nodes=[];},makeAvatar:function(){return new dojo.dnd.Avatar(this);},updateAvatar:function(){this.avatar.update();},onMouseMove:function(e){var a=this.avatar;if(a){dojo.dnd.autoScrollNodes(e);var s=a.node.style;s.left=(e.pageX+this.OFFSET_X)+"px";s.top=(e.pageY+this.OFFSET_Y)+"px";var copy=Boolean(this.source.copyState(dojo.isCopyKey(e)));if(this.copy!=copy){this._setCopyStatus(copy);}}},onMouseUp:function(e){if(this.avatar){if(this.target&&this.canDropFlag){var copy=Boolean(this.source.copyState(dojo.isCopyKey(e))),_928=[this.source,this.nodes,copy,this.target,e];dojo.publish("/dnd/drop/before",_928);dojo.publish("/dnd/drop",_928);}else{dojo.publish("/dnd/cancel");}this.stopDrag();}},onKeyDown:function(e){if(this.avatar){switch(e.keyCode){case dojo.keys.CTRL:var copy=Boolean(this.source.copyState(true));if(this.copy!=copy){this._setCopyStatus(copy);}break;case dojo.keys.ESCAPE:dojo.publish("/dnd/cancel");this.stopDrag();break;}}},onKeyUp:function(e){if(this.avatar&&e.keyCode==dojo.keys.CTRL){var copy=Boolean(this.source.copyState(false));if(this.copy!=copy){this._setCopyStatus(copy);}}},_setCopyStatus:function(copy){this.copy=copy;this.source._markDndStatus(this.copy);this.updateAvatar();dojo.replaceClass(dojo.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));}});dojo.dnd._manager=null;_922.manager=dojo.dnd.manager=function(){if(!dojo.dnd._manager){dojo.dnd._manager=new dojo.dnd.Manager();}return dojo.dnd._manager;};return _922;});},"dojox/charting/scaler/linear":function(){define("dojox/charting/scaler/linear",["dojo/_base/lang","./common"],function(lang,_929){var _92a=lang.getObject("dojox.charting.scaler.linear",true);var _92b=3,_92c=_929.findString,_92d=_929.getNumericLabel;var _92e=function(min,max,_92f,_930,_931,_932,span){_92f=lang.delegate(_92f);if(!_930){if(_92f.fixUpper=="major"){_92f.fixUpper="minor";}if(_92f.fixLower=="major"){_92f.fixLower="minor";}}if(!_931){if(_92f.fixUpper=="minor"){_92f.fixUpper="micro";}if(_92f.fixLower=="minor"){_92f.fixLower="micro";}}if(!_932){if(_92f.fixUpper=="micro"){_92f.fixUpper="none";}if(_92f.fixLower=="micro"){_92f.fixLower="none";}}var _933=_92c(_92f.fixLower,["major"])?Math.floor(_92f.min/_930)*_930:_92c(_92f.fixLower,["minor"])?Math.floor(_92f.min/_931)*_931:_92c(_92f.fixLower,["micro"])?Math.floor(_92f.min/_932)*_932:_92f.min,_934=_92c(_92f.fixUpper,["major"])?Math.ceil(_92f.max/_930)*_930:_92c(_92f.fixUpper,["minor"])?Math.ceil(_92f.max/_931)*_931:_92c(_92f.fixUpper,["micro"])?Math.ceil(_92f.max/_932)*_932:_92f.max;if(_92f.useMin){min=_933;}if(_92f.useMax){max=_934;}var _935=(!_930||_92f.useMin&&_92c(_92f.fixLower,["major"]))?min:Math.ceil(min/_930)*_930,_936=(!_931||_92f.useMin&&_92c(_92f.fixLower,["major","minor"]))?min:Math.ceil(min/_931)*_931,_937=(!_932||_92f.useMin&&_92c(_92f.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_932)*_932,_938=!_930?0:(_92f.useMax&&_92c(_92f.fixUpper,["major"])?Math.round((max-_935)/_930):Math.floor((max-_935)/_930))+1,_939=!_931?0:(_92f.useMax&&_92c(_92f.fixUpper,["major","minor"])?Math.round((max-_936)/_931):Math.floor((max-_936)/_931))+1,_93a=!_932?0:(_92f.useMax&&_92c(_92f.fixUpper,["major","minor","micro"])?Math.round((max-_937)/_932):Math.floor((max-_937)/_932))+1,_93b=_931?Math.round(_930/_931):0,_93c=_932?Math.round(_931/_932):0,_93d=_930?Math.floor(Math.log(_930)/Math.LN10):0,_93e=_931?Math.floor(Math.log(_931)/Math.LN10):0,_93f=span/(max-min);if(!isFinite(_93f)){_93f=1;}return {bounds:{lower:_933,upper:_934,from:min,to:max,scale:_93f,span:span},major:{tick:_930,start:_935,count:_938,prec:_93d},minor:{tick:_931,start:_936,count:_939,prec:_93e},micro:{tick:_932,start:_937,count:_93a,prec:0},minorPerMajor:_93b,microPerMinor:_93c,scaler:_92a};};return lang.mixin(_92a,{buildScaler:function(min,max,span,_940){var h={fixUpper:"none",fixLower:"none",natural:false};if(_940){if("fixUpper" in _940){h.fixUpper=String(_940.fixUpper);}if("fixLower" in _940){h.fixLower=String(_940.fixLower);}if("natural" in _940){h.natural=Boolean(_940.natural);}}if("min" in _940){min=_940.min;}if("max" in _940){max=_940.max;}if(_940.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _940){min=_940.from;h.useMin=false;}if("to" in _940){max=_940.to;h.useMax=false;}if(max<=min){return _92e(min,max,h,0,0,0,span);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_941=_940&&("majorTickStep" in _940)?_940.majorTickStep:Math.pow(10,mag),_942=0,_943=0,_944;if(_940&&("minorTickStep" in _940)){_942=_940.minorTickStep;}else{do{_942=_941/10;if(!h.natural||_942>0.9){_944=_92e(min,max,h,_941,_942,0,span);if(_944.bounds.scale*_944.minor.tick>_92b){break;}}_942=_941/5;if(!h.natural||_942>0.9){_944=_92e(min,max,h,_941,_942,0,span);if(_944.bounds.scale*_944.minor.tick>_92b){break;}}_942=_941/2;if(!h.natural||_942>0.9){_944=_92e(min,max,h,_941,_942,0,span);if(_944.bounds.scale*_944.minor.tick>_92b){break;}}return _92e(min,max,h,_941,0,0,span);}while(false);}if(_940&&("microTickStep" in _940)){_943=_940.microTickStep;_944=_92e(min,max,h,_941,_942,_943,span);}else{do{_943=_942/10;if(!h.natural||_943>0.9){_944=_92e(min,max,h,_941,_942,_943,span);if(_944.bounds.scale*_944.micro.tick>_92b){break;}}_943=_942/5;if(!h.natural||_943>0.9){_944=_92e(min,max,h,_941,_942,_943,span);if(_944.bounds.scale*_944.micro.tick>_92b){break;}}_943=_942/2;if(!h.natural||_943>0.9){_944=_92e(min,max,h,_941,_942,_943,span);if(_944.bounds.scale*_944.micro.tick>_92b){break;}}_943=0;}while(false);}return _943?_944:_92e(min,max,h,_941,_942,0,span);},buildTicks:function(_945,_946){var step,next,tick,_947=_945.major.start,_948=_945.minor.start,_949=_945.micro.start;if(_946.microTicks&&_945.micro.tick){step=_945.micro.tick,next=_949;}else{if(_946.minorTicks&&_945.minor.tick){step=_945.minor.tick,next=_948;}else{if(_945.major.tick){step=_945.major.tick,next=_947;}else{return null;}}}var _94a=1/_945.bounds.scale;if(_945.bounds.to<=_945.bounds.from||isNaN(_94a)||!isFinite(_94a)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _94b=[],_94c=[],_94d=[];while(next<=_945.bounds.to+_94a){if(Math.abs(_947-next)<step/2){tick={value:_947};if(_946.majorLabels){tick.label=_92d(_947,_945.major.prec,_946);}_94b.push(tick);_947+=_945.major.tick;_948+=_945.minor.tick;_949+=_945.micro.tick;}else{if(Math.abs(_948-next)<step/2){if(_946.minorTicks){tick={value:_948};if(_946.minorLabels&&(_945.minMinorStep<=_945.minor.tick*_945.bounds.scale)){tick.label=_92d(_948,_945.minor.prec,_946);}_94c.push(tick);}_948+=_945.minor.tick;_949+=_945.micro.tick;}else{if(_946.microTicks){_94d.push({value:_949});}_949+=_945.micro.tick;}}next+=step;}return {major:_94b,minor:_94c,micro:_94d};},getTransformerFromModel:function(_94e){var _94f=_94e.bounds.from,_950=_94e.bounds.scale;return function(x){return (x-_94f)*_950;};},getTransformerFromPlot:function(_951){var _952=_951.bounds.from,_953=_951.bounds.scale;return function(x){return x/_953+_952;};}});});},"dojox/grid/DataSelection":function(){define("dojox/grid/DataSelection",["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_954,_955,_956){return _954("dojox.grid.DataSelection",_956,{constructor:function(grid){if(grid.keepSelection){this.preserver=new _955(this);}},destroy:function(){if(this.preserver){this.preserver.destroy();}},getFirstSelected:function(){var idx=_956.prototype.getFirstSelected.call(this);if(idx==-1){return null;}return this.grid.getItem(idx);},getNextSelected:function(_957){var _958=this.grid.getItemIndex(_957);var idx=_956.prototype.getNextSelected.call(this,_958);if(idx==-1){return null;}return this.grid.getItem(idx);},getSelected:function(){var _959=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_959.push(this.grid.getItem(i));}}return _959;},addToSelection:function(_95a){if(this.mode=="none"){return;}var idx=null;if(typeof _95a=="number"||typeof _95a=="string"){idx=_95a;}else{idx=this.grid.getItemIndex(_95a);}_956.prototype.addToSelection.call(this,idx);},deselect:function(_95b){if(this.mode=="none"){return;}var idx=null;if(typeof _95b=="number"||typeof _95b=="string"){idx=_95b;}else{idx=this.grid.getItemIndex(_95b);}_956.prototype.deselect.call(this,idx);},deselectAll:function(_95c){var idx=null;if(_95c||typeof _95c=="number"){if(typeof _95c=="number"||typeof _95c=="string"){idx=_95c;}else{idx=this.grid.getItemIndex(_95c);}_956.prototype.deselectAll.call(this,idx);}else{this.inherited(arguments);}}});});},"dijit/form/_TextBoxMixin":function(){define("dijit/form/_TextBoxMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/_base/event","dojo/keys","dojo/_base/lang",".."],function(_95d,_95e,dom,_95f,keys,lang,_960){var _961=_95e("dijit.form._TextBoxMixin",null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_962,_963,_964){var _965;if(_962!==undefined){_965=this.filter(_962);if(typeof _964!="string"){if(_965!==null&&((typeof _965!="number")||!isNaN(_965))){_964=this.filter(this.format(_965,this.constraints));}else{_964="";}}}if(_964!=null&&_964!=undefined&&((typeof _964)!="number"||!isNaN(_964))&&this.textbox.value!=_964){this.textbox.value=_964;this._set("displayedValue",this.get("displayedValue"));}if(this.textDir=="auto"){this.applyTextDir(this.focusNode,_964);}this.inherited(arguments,[_965,_963]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_966){if(_966===null||_966===undefined){_966="";}else{if(typeof _966!="string"){_966=String(_966);}}this.textbox.value=_966;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));if(this.textDir=="auto"){this.applyTextDir(this.focusNode,_966);}},format:function(_967){return ((_967==null||_967==undefined)?"":(_967.toString?_967.toString():_967));},parse:function(_968){return _968;},_refreshState:function(){},onInput:function(){},__skipInputEvent:false,_onInput:function(){if(this.textDir=="auto"){this.applyTextDir(this.focusNode,this.focusNode.value);}this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);var _969=function(e){var _96a=e.charOrCode||e.keyCode||229;if(e.type=="keydown"){switch(_96a){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:return;default:if(_96a>=65&&_96a<=90){return;}}}if(e.type=="keypress"&&typeof _96a!="string"){return;}if(e.type=="input"){if(this.__skipInputEvent){this.__skipInputEvent=false;return;}}else{this.__skipInputEvent=true;}var faux=lang.mixin({},e,{charOrCode:_96a,wasConsumed:false,preventDefault:function(){faux.wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});if(this.onInput(faux)===false){_95f.stop(faux);}if(faux.wasConsumed){return;}setTimeout(lang.hitch(this,"_onInput",faux),0);};_95d.forEach(["onkeydown","onkeypress","onpaste","oncut","oninput"],function(_96b){this.connect(this.textbox,_96b,_969);},this);},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);if(this._selectOnClickHandle){this.disconnect(this._selectOnClickHandle);}},_isTextSelected:function(){return this.textbox.selectionStart==this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=this.connect(this.domNode,"onmouseup",function(){this.disconnect(this._selectOnClickHandle);if(this._isTextSelected()){_961.selectInputText(this.textbox);}});}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);},_setTextDirAttr:function(_96c){if(!this._created||this.textDir!=_96c){this._set("textDir",_96c);this.applyTextDir(this.focusNode,this.focusNode.value);}}});_961._setSelectionRange=_960._setSelectionRange=function(_96d,_96e,stop){if(_96d.setSelectionRange){_96d.setSelectionRange(_96e,stop);}};_961.selectInputText=_960.selectInputText=function(_96f,_970,stop){_96f=dom.byId(_96f);if(isNaN(_970)){_970=0;}if(isNaN(stop)){stop=_96f.value?_96f.value.length:0;}try{_96f.focus();_961._setSelectionRange(_96f,_970,stop);}catch(e){}};return _961;});},"dojox/charting/plot2d/Bubble":function(){define("dojox/charting/plot2d/Bubble",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_971,arr,Base,dc,df,dfr,du,fx){var _972=dfr.lambda("item.purgeGroup()");return _971("dojox.charting.plot2d.Bubble",Base,{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_973,_974){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_974);du.updateWithPattern(this.opt,_974,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_975){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_975);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_972);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_976=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _977=t.next("circle",[this.opt,run]),s=run.group,_978=arr.map(run.data,function(v,i){return v?{x:ht(v.x)+_975.l,y:dim.height-_975.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _979=null,_97a=null,_97b=null;if(_977.series.shadow){_97b=arr.map(_978,function(item){if(item!==null){var _97c=t.addMixin(_977,"circle",item,true),_97d=_97c.series.shadow;var _97e=s.createCircle({cx:item.x+_97d.dx,cy:item.y+_97d.dy,r:item.radius}).setStroke(_97d).setFill(_97d.color);if(this.animate){this._animateBubble(_97e,dim.height-_975.b,item.radius);}return _97e;}return null;},this);if(_97b.length){run.dyn.shadow=_97b[_97b.length-1].getStroke();}}if(_977.series.outline){_97a=arr.map(_978,function(item){if(item!==null){var _97f=t.addMixin(_977,"circle",item,true),_980=dc.makeStroke(_97f.series.outline);_980.width=2*_980.width+_977.series.stroke.width;var _981=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_980);if(this.animate){this._animateBubble(_981,dim.height-_975.b,item.radius);}return _981;}return null;},this);if(_97a.length){run.dyn.outline=_97a[_97a.length-1].getStroke();}}_979=arr.map(_978,function(item){if(item!==null){var _982=t.addMixin(_977,"circle",item,true),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _983=this._plotFill(_982.series.fill,dim,_975);_983=this._shapeFill(_983,rect);var _984=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_983).setStroke(_982.series.stroke);if(this.animate){this._animateBubble(_984,dim.height-_975.b,item.radius);}return _984;}return null;},this);if(_979.length){run.dyn.fill=_979[_979.length-1].getFill();run.dyn.stroke=_979[_979.length-1].getStroke();}if(_976){var _985=new Array(_979.length);arr.forEach(_979,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_97a&&_97a[i]||null,shadow:_97b&&_97b[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_978[i].x,cy:_978[i].y,cr:_978[i].radius};this._connectEvents(o);_985[i]=o;}},this);this._eventSeries[run.name]=_985;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateBubble:function(_986,_987,size){fx.animateTransform(lang.delegate({shape:_986,duration:1200,transform:[{name:"translate",start:[0,_987],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/sniff","./_base/manager","."],function(_988,_989,_98a,dom,_98b,_98c,has,_98d,_98e){var _98f=(_98e._isElementShown=function(elem){var s=_98c.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_98b.get(elem,"type")!="hidden");});_98e.hasDefaultTabStop=function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _98b.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _990=elem.contentDocument;if("designMode" in _990&&_990.designMode=="on"){return true;}body=_990.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}};var _991=(_98e.isTabNavigable=function(elem){if(_98b.get(elem,"disabled")){return false;}else{if(_98b.has(elem,"tabIndex")){return _98b.get(elem,"tabIndex")>=0;}else{return _98e.hasDefaultTabStop(elem);}}});_98e._getTabNavigable=function(root){var _992,last,_993,_994,_995,_996,_997={};function _998(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _999=function(_99a){for(var _99b=_99a.firstChild;_99b;_99b=_99b.nextSibling){if(_99b.nodeType!=1||(has("ie")&&_99b.scopeName!=="HTML")||!_98f(_99b)){continue;}if(_991(_99b)){var _99c=_98b.get(_99b,"tabIndex");if(!_98b.has(_99b,"tabIndex")||_99c==0){if(!_992){_992=_99b;}last=_99b;}else{if(_99c>0){if(!_993||_99c<_994){_994=_99c;_993=_99b;}if(!_995||_99c>=_996){_996=_99c;_995=_99b;}}}var rn=_998(_99b);if(_98b.get(_99b,"checked")&&rn){_997[rn]=_99b;}}if(_99b.nodeName.toUpperCase()!="SELECT"){_999(_99b);}}};if(_98f(root)){_999(root);}function rs(node){return _997[_998(node)]||node;};return {first:rs(_992),last:rs(last),lowest:rs(_993),highest:rs(_995)};};_98e.getFirstInTabbingOrder=function(root){var _99d=_98e._getTabNavigable(dom.byId(root));return _99d.lowest?_99d.lowest:_99d.first;};_98e.getLastInTabbingOrder=function(root){var _99e=_98e._getTabNavigable(dom.byId(root));return _99e.last?_99e.last:_99e.highest;};return {hasDefaultTabStop:_98e.hasDefaultTabStop,isTabNavigable:_98e.isTabNavigable,_getTabNavigable:_98e._getTabNavigable,getFirstInTabbingOrder:_98e.getFirstInTabbingOrder,getLastInTabbingOrder:_98e.getLastInTabbingOrder};});},"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"></span>\n\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t</span>\n\t</div>\n\t\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","dijit/form/TextBox":function(){require({cache:{"url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n"}});define("dijit/form/TextBox",["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html",".."],function(_99f,_9a0,_9a1,_9a2,lang,has,win,_9a3,_9a4,_9a5,_9a6){var _9a7=_99f([_9a3,_9a4],{templateString:_9a5,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var type=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((type=="hidden"||type=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},_onInput:function(e){this.inherited(arguments);if(this.intermediateChanges){var _9a8=this;setTimeout(function(){_9a8._handleOnChange(_9a8.get("value"),false);},0);}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_9a0.create("span",{className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");}this._phspan.innerHTML="";this._phspan.appendChild(document.createTextNode(v));this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_9a9,_9aa,_9ab){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_9a2.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use set('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_9ac){_9a2.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_9ac);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")){_9a7=_99f(_9a7,{declaredClass:"dijit.form.TextBox",_isTextSelected:function(){var _9ad=win.doc.selection.createRange();var _9ae=_9ad.parentElement();return _9ae==this.textbox&&_9ad.text.length==0;},postCreate:function(){this.inherited(arguments);setTimeout(lang.hitch(this,function(){try{var s=_9a1.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _9af=this.domNode.getElementsByTagName("INPUT");if(_9af){for(var i=0;i<_9af.length;i++){_9af[i].style.fontFamily=ff;}}}}}catch(e){}}),0);}});_9a6._setSelectionRange=_9a4._setSelectionRange=function(_9b0,_9b1,stop){if(_9b0.createTextRange){var r=_9b0.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_9b1);r.moveEnd("character",stop-_9b1);r.select();}};}else{if(has("mozilla")){_9a7=_99f(_9a7,{declaredClass:"dijit.form.TextBox",_onBlur:function(e){this.inherited(arguments);if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}});}else{_9a7.prototype.declaredClass="dijit.form.TextBox";}}lang.setObject("dijit.form.TextBox",_9a7);return _9a7;});},"dijit/form/_DateTimeTextBox":function(){require({cache:{"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n"}});define("dijit/form/_DateTimeTextBox",["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_9b2,_9b3,_9b4,lang,_9b5,_9b6,_9b7){new Date("X");var _9b8=_9b4("dijit.form._DateTimeTextBox",[_9b5,_9b6],{templateString:_9b7,hasDownArrow:true,openOnClick:true,regExpGen:_9b2.regexp,datePackage:date,postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _9b9=this._isInvalidDate(val1);var _9ba=this._isInvalidDate(val2);return _9b9?(_9ba?0:-1):(_9ba?1:date.compare(val1,val2,this._selector));},forceWidth:true,format:function(_9bb,_9bc){if(!_9bb){return "";}return this.dateLocaleModule.format(_9bb,_9bc);},"parse":function(_9bd,_9be){return this.dateLocaleModule.parse(_9bd,_9be)||(this._isEmpty(_9bd)?null:undefined);},serialize:function(val,_9bf){if(val.toGregorian){val=val.toGregorian();}return _9b3.toISOString(val,_9bf);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(args){this.datePackage=args.datePackage||this.datePackage;this.dateFuncObj=typeof this.datePackage=="string"?lang.getObject(this.datePackage,false):this.datePackage;this.dateClassObj=this.dateFuncObj.Date||Date;this.dateLocaleModule=lang.getObject("locale",false,this.dateFuncObj);this.regExpGen=this.dateLocaleModule.regexp;this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(this.openOnClick||!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_9c0){_9c0.selector=this._selector;_9c0.fullYear=true;var _9c1=_9b3.fromISOString;if(typeof _9c0.min=="string"){_9c0.min=_9c1(_9c0.min);}if(typeof _9c0.max=="string"){_9c0.max=_9c1(_9c0.max);}this.inherited(arguments);},_isInvalidDate:function(_9c2){return !_9c2||isNaN(_9c2)||typeof _9c2!="object"||_9c2.toString()==this._invalidDate;},_setValueAttr:function(_9c3,_9c4,_9c5){if(_9c3!==undefined){if(typeof _9c3=="string"){_9c3=_9b3.fromISOString(_9c3);}if(this._isInvalidDate(_9c3)){_9c3=null;}if(_9c3 instanceof Date&&!(this.dateClassObj instanceof Date)){_9c3=new this.dateClassObj(_9c3);}}this.inherited(arguments);if(this.dropDown){this.dropDown.set("value",_9c3,false);}},_set:function(attr,_9c6){if(attr=="value"&&this.value instanceof Date&&this.compare(_9c6,this.value)==0){return;}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this.dropDownDefaultValue=val;},openDropDown:function(_9c7){if(this.dropDown){this.dropDown.destroy();}var _9c8=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9c9=this,_9ca=this.get("value");this.dropDown=new _9c8({onChange:function(_9cb){_9b8.superclass._setValueAttr.call(_9c9,_9cb,true);},id:this.id+"_popup",dir:_9c9.dir,lang:_9c9.lang,value:_9ca,currentFocus:!this._isInvalidDate(_9ca)?_9ca:this.dropDownDefaultValue,constraints:_9c9.constraints,filterString:_9c9.filterString,datePackage:_9c9.datePackage,isDisabledDate:function(date){return !_9c9.rangeCheck(date,_9c9.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_9cc,_9cd){this._setValueAttr(this.parse(_9cc,this.constraints),_9cd,_9cc);}});return _9b8;});},"dijit/layout/StackContainer":function(){define("dijit/layout/StackContainer",["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/ready","dojo/topic","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_9ce,_9cf,_9d0,_9d1,_9d2,lang,_9d3,_9d4,_9d5,_9d6,_9d7){if(!_9d2.isAsync){_9d3(0,function(){var _9d8=["dijit/layout/StackController"];require(_9d8);});}lang.extend(_9d6,{selected:false,closable:false,iconClass:"dijitNoIcon",showTitle:true});return _9d0("dijit.layout.StackContainer",_9d7,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_9d1.add(this.domNode,"dijitLayoutContainer");this.containerNode.setAttribute("role","tabpanel");},postCreate:function(){this.inherited(arguments);this.connect(this.domNode,"onkeypress",this._onKeyPress);},startup:function(){if(this._started){return;}var _9d9=this.getChildren();_9ce.forEach(_9d9,this._setupChild,this);if(this.persist){this.selectedChildWidget=_9d5.byId(_9cf(this.id+"_selectedChild"));}else{_9ce.some(_9d9,function(_9da){if(_9da.selected){this.selectedChildWidget=_9da;}return _9da.selected;},this);}var _9db=this.selectedChildWidget;if(!_9db&&_9d9[0]){_9db=this.selectedChildWidget=_9d9[0];_9db.selected=true;}_9d4.publish(this.id+"-startup",{children:_9d9,selected:_9db});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _9dc=this.selectedChildWidget;if(_9dc){this._showChild(_9dc);}}this.inherited(arguments);},_setupChild:function(_9dd){this.inherited(arguments);_9d1.replace(_9dd.domNode,"dijitHidden","dijitVisible");_9dd.domNode.title="";},addChild:function(_9de,_9df){this.inherited(arguments);if(this._started){_9d4.publish(this.id+"-addChild",_9de,_9df);this.layout();if(!this.selectedChildWidget){this.selectChild(_9de);}}},removeChild:function(page){this.inherited(arguments);if(this._started){_9d4.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _9e0=this.getChildren();if(_9e0.length){this.selectChild(_9e0[0]);}}}if(this._started){this.layout();}},selectChild:function(page,_9e1){page=_9d5.byId(page);if(this.selectedChildWidget!=page){var d=this._transition(page,this.selectedChildWidget,_9e1);this._set("selectedChildWidget",page);_9d4.publish(this.id+"-selectChild",page);if(this.persist){_9cf(this.id+"_selectedChild",this.selectedChildWidget.id);}}return d;},_transition:function(_9e2,_9e3){if(_9e3){this._hideChild(_9e3);}var d=this._showChild(_9e2);if(_9e2.resize){if(this.doLayout){_9e2.resize(this._containerContentBox||this._contentBox);}else{_9e2.resize();}}return d;},_adjacent:function(_9e4){var _9e5=this.getChildren();var _9e6=_9ce.indexOf(_9e5,this.selectedChildWidget);_9e6+=_9e4?1:_9e5.length-1;return _9e5[_9e6%_9e5.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyPress:function(e){_9d4.publish(this.id+"-containerKeyPress",{e:e,page:this});},layout:function(){var _9e7=this.selectedChildWidget;if(_9e7&&_9e7.resize){if(this.doLayout){_9e7.resize(this._containerContentBox||this._contentBox);}else{_9e7.resize();}}},_showChild:function(page){var _9e8=this.getChildren();page.isFirstChild=(page==_9e8[0]);page.isLastChild=(page==_9e8[_9e8.length-1]);page._set("selected",true);_9d1.replace(page.domNode,"dijitVisible","dijitHidden");return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);_9d1.replace(page.domNode,"dijitHidden","dijitVisible");page.onHide&&page.onHide();},closeChild:function(page){var _9e9=page.onClose(this,page);if(_9e9){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_9ea){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_9ce.forEach(this.getChildren(),function(_9eb){if(!_9ea){this.removeChild(_9eb);}_9eb.destroyRecursive(_9ea);},this);this._descendantsBeingDestroyed=false;}});});},"dijit/form/_RadioButtonMixin":function(){define("dijit/form/_RadioButtonMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/_base/lang","dojo/query","dojo/_base/window","../registry"],function(_9ec,_9ed,_9ee,_9ef,lang,_9f0,win,_9f1){return _9ed("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_9f0("input[type=radio]",this.focusNode.form||win.doc).forEach(lang.hitch(this,function(_9f2){if(_9f2.name==this.name&&_9f2.form==this.focusNode.form){var _9f3=_9f1.getEnclosingWidget(_9f2);if(_9f3){ary.push(_9f3);}}}));return ary;},_setCheckedAttr:function(_9f4){this.inherited(arguments);if(!this._created){return;}if(_9f4){_9ec.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_9f5){if(_9f5!=this&&_9f5.checked){_9f5.set("checked",false);}}));}},_onClick:function(e){if(this.checked||this.disabled){_9ef.stop(e);return false;}if(this.readOnly){_9ef.stop(e);_9ec.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_9f6){_9ee.set(this.focusNode||this.domNode,"checked",_9f6.checked);}));return false;}return this.inherited(arguments);}});});},"dojo/_base/window":function(){define(["./kernel","../has","./sniff"],function(dojo,has){dojo.doc=this["document"]||null;dojo.body=function(){return dojo.doc.body||dojo.doc.getElementsByTagName("body")[0];};dojo.setContext=function(_9f7,_9f8){dojo.global=ret.global=_9f7;dojo.doc=ret.doc=_9f8;};dojo.withGlobal=function(_9f9,_9fa,_9fb,_9fc){var _9fd=dojo.global;try{dojo.global=ret.global=_9f9;return dojo.withDoc.call(null,_9f9.document,_9fa,_9fb,_9fc);}finally{dojo.global=ret.global=_9fd;}};dojo.withDoc=function(_9fe,_9ff,_a00,_a01){var _a02=dojo.doc,oldQ=dojo.isQuirks,_a03=dojo.isIE,isIE,mode,pwin;try{dojo.doc=ret.doc=_9fe;dojo.isQuirks=has.add("quirks",dojo.doc.compatMode=="BackCompat",true,true);if(has("ie")){if((pwin=_9fe.parentWindow)&&pwin.navigator){isIE=parseFloat(pwin.navigator.appVersion.split("MSIE ")[1])||undefined;mode=_9fe.documentMode;if(mode&&mode!=5&&Math.floor(isIE)!=mode){isIE=mode;}dojo.isIE=has.add("ie",isIE,true,true);}}if(_a00&&typeof _9ff=="string"){_9ff=_a00[_9ff];}return _9ff.apply(_a00,_a01||[]);}finally{dojo.doc=ret.doc=_a02;dojo.isQuirks=has.add("quirks",oldQ,true,true);dojo.isIE=has.add("ie",_a03,true,true);}};var ret={global:dojo.global,doc:dojo.doc,body:dojo.body,setContext:dojo.setContext,withGlobal:dojo.withGlobal,withDoc:dojo.withDoc};return ret;});},"dojo/_base/json":function(){define(["./kernel","../json"],function(dojo,json){dojo.fromJson=function(js){return eval("("+js+")");};dojo._escapeString=json.stringify;dojo.toJsonIndentStr="\t";dojo.toJson=function(it,_a04){return json.stringify(it,function(key,_a05){if(_a05){var tf=_a05.__json__||_a05.json;if(typeof tf=="function"){return tf.call(_a05);}}return _a05;},_a04&&dojo.toJsonIndentStr);};return dojo;});},"dojox/validate/web":function(){define("dojox/validate/web",["./_base","./regexp"],function(_a06,_a07){_a06.isIpAddress=function(_a08,_a09){var re=new RegExp("^"+_a07.ipAddress(_a09)+"$","i");return re.test(_a08);};_a06.isUrl=function(_a0a,_a0b){var re=new RegExp("^"+_a07.url(_a0b)+"$","i");return re.test(_a0a);};_a06.isEmailAddress=function(_a0c,_a0d){var re=new RegExp("^"+_a07.emailAddress(_a0d)+"$","i");return re.test(_a0c);};_a06.isEmailAddressList=function(_a0e,_a0f){var re=new RegExp("^"+_a07.emailAddressList(_a0f)+"$","i");return re.test(_a0e);};_a06.getEmailAddressList=function(_a10,_a11){if(!_a11){_a11={};}if(!_a11.listSeparator){_a11.listSeparator="\\s;,";}if(_a06.isEmailAddressList(_a10,_a11)){return _a10.split(new RegExp("\\s*["+_a11.listSeparator+"]\\s*"));}return [];};return _a06;});},"url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><img data-dojo-attach-point=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\n/></div>\n","dojo/cldr/nls/number":function(){define({root:{"scientificFormat":"#E0","currencySpacing-afterCurrency-currencyMatch":"[:letter:]","infinity":"∞","list":";","percentSign":"%","minusSign":"-","currencySpacing-beforeCurrency-surroundingMatch":"[:digit:]","decimalFormat-short":"000T","currencySpacing-afterCurrency-insertBetween":" ","nan":"NaN","nativeZeroDigit":"0","plusSign":"+","currencySpacing-afterCurrency-surroundingMatch":"[:digit:]","currencySpacing-beforeCurrency-currencyMatch":"[:letter:]","currencyFormat":"¤ #,##0.00","perMille":"‰","group":",","percentFormat":"#,##0%","decimalFormat":"#,##0.###","decimal":".","patternDigit":"#","currencySpacing-beforeCurrency-insertBetween":" ","exponential":"E"},"ar":true,"ca":true,"cs":true,"da":true,"de":true,"el":true,"en":true,"en-au":true,"en-gb":true,"es":true,"fi":true,"fr":true,"fr-ch":true,"he":true,"hu":true,"it":true,"ja":true,"ko":true,"nb":true,"nl":true,"pl":true,"pt":true,"pt-pt":true,"ro":true,"ru":true,"sk":true,"sl":true,"sv":true,"th":true,"tr":true,"zh":true,"zh-hant":true,"zh-hk":true});},"dijit/form/_FormWidgetMixin":function(){define("dijit/form/_FormWidgetMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/_base/sniff","dojo/_base/window","dojo/window","../a11y"],function(_a12,_a13,_a14,_a15,lang,_a16,has,win,_a17,a11y){return _a13("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",postCreate:function(){this.inherited(arguments);this.connect(this.domNode,"onmousedown","_onMouseDown");},_setDisabledAttr:function(_a18){this._set("disabled",_a18);_a14.set(this.focusNode,"disabled",_a18);if(this.valueNode){_a14.set(this.valueNode,"disabled",_a18);}this.focusNode.setAttribute("aria-disabled",_a18);if(_a18){this._set("hovering",false);this._set("active",false);var _a19="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_a12.forEach(lang.isArray(_a19)?_a19:[_a19],function(_a1a){var node=this[_a1a];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(e){if(this.scrollOnFocus){_a17.scrollIntoView(this.domNode);}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_a15.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_a1b,_a1c){if(this._lastValueReported==undefined&&(_a1c===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_a1b;}this._pendingOnChange=this._pendingOnChange||(typeof _a1b!=typeof this._lastValueReported)||(this.compare(_a1b,this._lastValueReported)!=0);if((this.intermediateChanges||_a1c||_a1c===undefined)&&this._pendingOnChange){this._lastValueReported=_a1b;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){clearTimeout(this._onChangeHandle);}this._onChangeHandle=setTimeout(lang.hitch(this,function(){this._onChangeHandle=null;this.onChange(_a1b);}),0);}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){clearTimeout(this._onChangeHandle);this.onChange(this._lastValueReported);}this.inherited(arguments);},_onMouseDown:function(e){if((!this.focused||!has("ie"))&&!e.ctrlKey&&_a16.isLeft(e)&&this.isFocusable()){var _a1d=this.connect(win.body(),"onmouseup",function(){if(this.isFocusable()){this.focus();}this.disconnect(_a1d);});}}});});},"dojo/json":function(){define(["./has"],function(has){"use strict";var _a1e=typeof JSON!="undefined";has.add("json-parse",_a1e);has.add("json-stringify",_a1e&&JSON.stringify({a:0},function(k,v){return v||1;})=="{\"a\":1}");if(has("json-stringify")){return JSON;}else{var _a1f=function(str){return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");};return {parse:has("json-parse")?JSON.parse:function(str,_a20){if(_a20&&!/^([\s\[\{]*(?:"(?:\\.|[^"])+"|-?\d[\d\.]*(?:[Ee][+-]?\d+)?|null|true|false|)[\s\]\}]*(?:,|:|$))+$/.test(str)){throw new SyntaxError("Invalid characters in JSON");}return eval("("+str+")");},stringify:function(_a21,_a22,_a23){var _a24;if(typeof _a22=="string"){_a23=_a22;_a22=null;}function _a25(it,_a26,key){if(_a22){it=_a22(key,it);}var val,_a27=typeof it;if(_a27=="number"){return isFinite(it)?it+"":"null";}if(_a27=="boolean"){return it+"";}if(it===null){return "null";}if(typeof it=="string"){return _a1f(it);}if(_a27=="function"||_a27=="undefined"){return _a24;}if(typeof it.toJSON=="function"){return _a25(it.toJSON(key),_a26,key);}if(it instanceof Date){return "\"{FullYear}-{Month+}-{Date}T{Hours}:{Minutes}:{Seconds}Z\"".replace(/\{(\w+)(\+)?\}/g,function(t,prop,plus){var num=it["getUTC"+prop]()+(plus?1:0);return num<10?"0"+num:num;});}if(it.valueOf()!==it){return _a25(it.valueOf(),_a26,key);}var _a28=_a23?(_a26+_a23):"";var sep=_a23?" ":"";var _a29=_a23?"\n":"";if(it instanceof Array){var itl=it.length,res=[];for(key=0;key<itl;key++){var obj=it[key];val=_a25(obj,_a28,key);if(typeof val!="string"){val="null";}res.push(_a29+_a28+val);}return "["+res.join(",")+_a29+_a26+"]";}var _a2a=[];for(key in it){var _a2b;if(typeof key=="number"){_a2b="\""+key+"\"";}else{if(typeof key=="string"){_a2b=_a1f(key);}else{continue;}}val=_a25(it[key],_a28,key);if(typeof val!="string"){continue;}_a2a.push(_a29+_a28+_a2b+":"+sep+val);}return "{"+_a2a.join(",")+_a29+_a26+"}";};return _a25(_a21,"","");}};}});},"dijit/_base/place":function(){define("dijit/_base/place",["dojo/_base/array","dojo/_base/lang","dojo/window","../place",".."],function(_a2c,lang,_a2d,_a2e,_a2f){_a2f.getViewport=function(){return _a2d.getBox();};_a2f.placeOnScreen=_a2e.at;_a2f.placeOnScreenAroundElement=function(node,_a30,_a31,_a32){var _a33;if(lang.isArray(_a31)){_a33=_a31;}else{_a33=[];for(var key in _a31){_a33.push({aroundCorner:key,corner:_a31[key]});}}return _a2e.around(node,_a30,_a33,true,_a32);};_a2f.placeOnScreenAroundNode=_a2f.placeOnScreenAroundElement;_a2f.placeOnScreenAroundRectangle=_a2f.placeOnScreenAroundElement;_a2f.getPopupAroundAlignment=function(_a34,_a35){var _a36={};_a2c.forEach(_a34,function(pos){var ltr=_a35;switch(pos){case "after":_a36[_a35?"BR":"BL"]=_a35?"BL":"BR";break;case "before":_a36[_a35?"BL":"BR"]=_a35?"BR":"BL";break;case "below-alt":ltr=!ltr;case "below":_a36[ltr?"BL":"BR"]=ltr?"TL":"TR";_a36[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above-alt":ltr=!ltr;case "above":default:_a36[ltr?"TL":"TR"]=ltr?"BL":"BR";_a36[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});return _a36;};return _a2f;});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","dojox/main":function(){define("dojox/main",["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojo/dnd/Selector":function(){define(["../main","./common","./Container"],function(dojo){dojo.declare("dojo.dnd.Selector",dojo.dnd.Container,{constructor:function(node,_a37){if(!_a37){_a37={};}this.singular=_a37.singular;this.autoSync=_a37.autoSync;this.selection={};this.anchor=null;this.simpleSelection=false;this.events.push(dojo.connect(this.node,"onmousedown",this,"onMouseDown"),dojo.connect(this.node,"onmouseup",this,"onMouseUp"));},singular:false,getSelectedNodes:function(){var t=new dojo.NodeList();var e=dojo.dnd._empty;for(var i in this.selection){if(i in e){continue;}t.push(dojo.byId(i));}return t;},selectNone:function(){return this._removeSelection()._removeAnchor();},selectAll:function(){this.forInItems(function(data,id){this._addItemClass(dojo.byId(id),"Selected");this.selection[id]=1;},this);return this._removeAnchor();},deleteSelectedNodes:function(){var e=dojo.dnd._empty;for(var i in this.selection){if(i in e){continue;}var n=dojo.byId(i);this.delItem(i);dojo.destroy(n);}this.anchor=null;this.selection={};return this;},forInSelectedItems:function(f,o){o=o||dojo.global;var s=this.selection,e=dojo.dnd._empty;for(var i in s){if(i in e){continue;}f.call(o,this.getItem(i),i,this);}},sync:function(){dojo.dnd.Selector.superclass.sync.call(this);if(this.anchor){if(!this.getItem(this.anchor.id)){this.anchor=null;}}var t=[],e=dojo.dnd._empty;for(var i in this.selection){if(i in e){continue;}if(!this.getItem(i)){t.push(i);}}dojo.forEach(t,function(i){delete this.selection[i];},this);return this;},insertNodes:function(_a38,data,_a39,_a3a){var _a3b=this._normalizedCreator;this._normalizedCreator=function(item,hint){var t=_a3b.call(this,item,hint);if(_a38){if(!this.anchor){this.anchor=t.node;this._removeItemClass(t.node,"Selected");this._addItemClass(this.anchor,"Anchor");}else{if(this.anchor!=t.node){this._removeItemClass(t.node,"Anchor");this._addItemClass(t.node,"Selected");}}this.selection[t.node.id]=1;}else{this._removeItemClass(t.node,"Selected");this._removeItemClass(t.node,"Anchor");}return t;};dojo.dnd.Selector.superclass.insertNodes.call(this,data,_a39,_a3a);this._normalizedCreator=_a3b;return this;},destroy:function(){dojo.dnd.Selector.superclass.destroy.call(this);this.selection=this.anchor=null;},onMouseDown:function(e){if(this.autoSync){this.sync();}if(!this.current){return;}if(!this.singular&&!dojo.isCopyKey(e)&&!e.shiftKey&&(this.current.id in this.selection)){this.simpleSelection=true;if(e.button===dojo.mouseButtons.LEFT){dojo.stopEvent(e);}return;}if(!this.singular&&e.shiftKey){if(!dojo.isCopyKey(e)){this._removeSelection();}var c=this.getAllNodes();if(c.length){if(!this.anchor){this.anchor=c[0];this._addItemClass(this.anchor,"Anchor");}this.selection[this.anchor.id]=1;if(this.anchor!=this.current){var i=0;for(;i<c.length;++i){var node=c[i];if(node==this.anchor||node==this.current){break;}}for(++i;i<c.length;++i){var node=c[i];if(node==this.anchor||node==this.current){break;}this._addItemClass(node,"Selected");this.selection[node.id]=1;}this._addItemClass(this.current,"Selected");this.selection[this.current.id]=1;}}}else{if(this.singular){if(this.anchor==this.current){if(dojo.isCopyKey(e)){this.selectNone();}}else{this.selectNone();this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}}else{if(dojo.isCopyKey(e)){if(this.anchor==this.current){delete this.selection[this.anchor.id];this._removeAnchor();}else{if(this.current.id in this.selection){this._removeItemClass(this.current,"Selected");delete this.selection[this.current.id];}else{if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this._addItemClass(this.anchor,"Selected");}this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}else{if(!(this.current.id in this.selection)){this.selectNone();this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}}dojo.stopEvent(e);},onMouseUp:function(e){if(!this.simpleSelection){return;}this.simpleSelection=false;this.selectNone();if(this.current){this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}},onMouseMove:function(e){this.simpleSelection=false;},onOverEvent:function(){this.onmousemoveEvent=dojo.connect(this.node,"onmousemove",this,"onMouseMove");},onOutEvent:function(){dojo.disconnect(this.onmousemoveEvent);delete this.onmousemoveEvent;},_removeSelection:function(){var e=dojo.dnd._empty;for(var i in this.selection){if(i in e){continue;}var node=dojo.byId(i);if(node){this._removeItemClass(node,"Selected");}}this.selection={};return this;},_removeAnchor:function(){if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this.anchor=null;}return this;}});return dojo.dnd.Selector;});},"url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"onclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","dojox/charting/Chart2D":function(){define("dojox/charting/Chart2D",["dojo/_base/kernel","dojox","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(dojo,_a3c,_a3d){dojo.deprecated("dojox.charting.Chart2D","Use dojo.charting.Chart instead and require all other components explicitly","2.0");return _a3c.charting.Chart2D=_a3d;});},"url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode\" data-dojo-attach-event='onclick:onClick'>\n    <div role=\"presentation\" class='dijitTabInnerDiv' data-dojo-attach-point='innerDiv'>\n        <div role=\"presentation\" class='dijitTabContent' data-dojo-attach-point='tabContent'>\n        \t<div role=\"presentation\" data-dojo-attach-point='focusNode'>\n\t\t        <img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitTabButtonIcon\" data-dojo-attach-point='iconNode' />\n\t\t        <span data-dojo-attach-point='containerNode' class='tabLabel'></span>\n\t\t        <span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t        \t\tdata-dojo-attach-event='onclick: onClickCloseButton' role=\"presentation\">\n\t\t            <span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t        ></span>\n\t\t\t</div>\n        </div>\n    </div>\n</div>\n","dojox/grid/_Scroller":function(){define("dojox/grid/_Scroller",["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_a3e,_a3f,lang,util,html){var _a40=function(_a41){var i=0,n,p=_a41.parentNode;while((n=p.childNodes[i++])){if(n==_a41){return i-1;}}return -1;};var _a42=function(_a43){if(!_a43){return;}dojo.forEach(_a3e.toArray(),function(w){if(w.domNode&&html.isDescendant(w.domNode,_a43,true)){w.destroy();}});};var _a44=function(_a45){var node=html.byId(_a45);return (node&&node.tagName?node.tagName.toLowerCase():"");};var _a46=function(_a47,_a48){var _a49=[];var i=0,n;while((n=_a47.childNodes[i])){i++;if(_a44(n)==_a48){_a49.push(n);}}return _a49;};var _a4a=function(_a4b){return _a46(_a4b,"div");};return _a3f("dojox.grid._Scroller",null,{constructor:function(_a4c){this.setContentNodes(_a4c);this.pageHeights=[];this.pageNodes=[];this.stack=[];},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_a4d,_a4e,_a4f){switch(arguments.length){case 3:this.rowsPerPage=_a4f;case 2:this.keepRows=_a4e;case 1:this.rowCount=_a4d;default:break;}this.defaultPageHeight=this.defaultRowHeight*this.rowsPerPage;this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);this.setKeepInfo(this.keepRows);this.invalidate();if(this.scrollboxNode){this.scrollboxNode.scrollTop=0;this.scroll(0);this.scrollboxNode.onscroll=lang.hitch(this,"onscroll");}},_getPageCount:function(_a50,_a51){return _a50?(Math.ceil(_a50/_a51)||1):0;},destroy:function(){this.invalidateNodes();delete this.contentNodes;delete this.contentNode;delete this.scrollboxNode;},setKeepInfo:function(_a52){this.keepRows=_a52;this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);},setContentNodes:function(_a53){this.contentNodes=_a53;this.colCount=(this.contentNodes?this.contentNodes.length:0);this.pageNodes=[];for(var i=0;i<this.colCount;i++){this.pageNodes[i]=[];}},getDefaultNodes:function(){return this.pageNodes[0]||[];},invalidate:function(){this._invalidating=true;this.invalidateNodes();this.pageHeights=[];this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);this.resize();this._invalidating=false;},updateRowCount:function(_a54){this.invalidateNodes();this.rowCount=_a54;var _a55=this.pageCount;if(_a55===0){this.height=1;}this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);if(this.pageCount<_a55){for(var i=_a55-1;i>=this.pageCount;i--){this.height-=this.getPageHeight(i);delete this.pageHeights[i];}}else{if(this.pageCount>_a55){this.height+=this.defaultPageHeight*(this.pageCount-_a55-1)+this.calcLastPageHeight();}}this.resize();},pageExists:function(_a56){return Boolean(this.getDefaultPageNode(_a56));},measurePage:function(_a57){if(this.grid.rowHeight){var _a58=this.grid.rowHeight+1;return ((_a57+1)*this.rowsPerPage>this.rowCount?this.rowCount-_a57*this.rowsPerPage:this.rowsPerPage)*_a58;}var n=this.getDefaultPageNode(_a57);return (n&&n.innerHTML)?n.offsetHeight:undefined;},positionPage:function(_a59,_a5a){for(var i=0;i<this.colCount;i++){this.pageNodes[i][_a59].style.top=_a5a+"px";}},repositionPages:function(_a5b){var _a5c=this.getDefaultNodes();var last=0;for(var i=0;i<this.stack.length;i++){last=Math.max(this.stack[i],last);}var n=_a5c[_a5b];var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_a5b):0);for(var p=_a5b+1;p<=last;p++){n=_a5c[p];if(n){if(this.getPageNodePosition(n)==y){return;}this.positionPage(p,y);}y+=this.getPageHeight(p);}},installPage:function(_a5d){for(var i=0;i<this.colCount;i++){this.contentNodes[i].appendChild(this.pageNodes[i][_a5d]);}},preparePage:function(_a5e,_a5f){var p=(_a5f?this.popPage():null);for(var i=0;i<this.colCount;i++){var _a60=this.pageNodes[i];var _a61=(p===null?this.createPageNode():this.invalidatePageNode(p,_a60));_a61.pageIndex=_a5e;_a60[_a5e]=_a61;}},renderPage:function(_a62){var _a63=[];var i,j;for(i=0;i<this.colCount;i++){_a63[i]=this.pageNodes[i][_a62];}for(i=0,j=_a62*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){this.renderRow(j,_a63);}},removePage:function(_a64){for(var i=0,j=_a64*this.rowsPerPage;i<this.rowsPerPage;i++,j++){this.removeRow(j);}},destroyPage:function(_a65){for(var i=0;i<this.colCount;i++){var n=this.invalidatePageNode(_a65,this.pageNodes[i]);if(n){html.destroy(n);}}},pacify:function(_a66){},pacifying:false,pacifyTicks:200,setPacifying:function(_a67){if(this.pacifying!=_a67){this.pacifying=_a67;this.pacify(this.pacifying);}},startPacify:function(){this.startPacifyTicks=new Date().getTime();},doPacify:function(){var _a68=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;this.setPacifying(true);this.startPacify();return _a68;},endPacify:function(){this.setPacifying(false);},resize:function(){if(this.scrollboxNode){this.windowHeight=this.scrollboxNode.clientHeight;}for(var i=0;i<this.colCount;i++){util.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));}var _a69=(!this._invalidating);if(!_a69){var ah=this.grid.get("autoHeight");if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){_a69=true;}}if(_a69){this.needPage(this.page,this.pageTop);}var _a6a=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);var _a6b=this.getPageHeight(this.page);this.averageRowHeight=(_a6b>0&&_a6a>0)?(_a6b/_a6a):0;},calcLastPageHeight:function(){if(!this.pageCount){return 0;}var _a6c=this.pageCount-1;var _a6d=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;this.pageHeights[_a6c]=_a6d;return _a6d;},updateContentHeight:function(inDh){this.height+=inDh;this.resize();},updatePageHeight:function(_a6e,_a6f,_a70){if(this.pageExists(_a6e)){var oh=this.getPageHeight(_a6e);var h=(this.measurePage(_a6e));if(h===undefined){h=oh;}this.pageHeights[_a6e]=h;if(oh!=h){this.updateContentHeight(h-oh);var ah=this.grid.get("autoHeight");if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_a6f)){if(!_a70){this.grid.sizeChange();}else{var ns=this.grid.viewsNode.style;ns.height=parseInt(ns.height)+h-oh+"px";this.repositionPages(_a6e);}}else{this.repositionPages(_a6e);}}return h;}return 0;},rowHeightChanged:function(_a71,_a72){this.updatePageHeight(Math.floor(_a71/this.rowsPerPage),false,_a72);},invalidateNodes:function(){while(this.stack.length){this.destroyPage(this.popPage());}},createPageNode:function(){var p=document.createElement("div");html.attr(p,"role","presentation");p.style.position="absolute";p.style[this.grid.isLeftToRight()?"left":"right"]="0";return p;},getPageHeight:function(_a73){var ph=this.pageHeights[_a73];return (ph!==undefined?ph:this.defaultPageHeight);},pushPage:function(_a74){return this.stack.push(_a74);},popPage:function(){return this.stack.shift();},findPage:function(_a75){var i=0,h=0;for(var ph=0;i<this.pageCount;i++,h+=ph){ph=this.getPageHeight(i);if(h+ph>=_a75){break;}}this.page=i;this.pageTop=h;},buildPage:function(_a76,_a77,_a78){this.preparePage(_a76,_a77);this.positionPage(_a76,_a78);this.installPage(_a76);this.renderPage(_a76);this.pushPage(_a76);},needPage:function(_a79,_a7a){var h=this.getPageHeight(_a79),oh=h;if(!this.pageExists(_a79)){this.buildPage(_a79,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),_a7a);h=this.updatePageHeight(_a79,true);}else{this.positionPage(_a79,_a7a);}return h;},onscroll:function(){this.scroll(this.scrollboxNode.scrollTop);},scroll:function(_a7b){this.grid.scrollTop=_a7b;if(this.colCount){this.startPacify();this.findPage(_a7b);var h=this.height;var b=this.getScrollBottom(_a7b);for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){y+=this.needPage(p,y);}this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,_a7b);this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);if(h!=this.height){this.repositionPages(p-1);}this.endPacify();}},getScrollBottom:function(_a7c){return (this.windowHeight>=0?_a7c+this.windowHeight:-1);},processNodeEvent:function(e,_a7d){var t=e.target;while(t&&(t!=_a7d)&&t.parentNode&&(t.parentNode.parentNode!=_a7d)){t=t.parentNode;}if(!t||!t.parentNode||(t.parentNode.parentNode!=_a7d)){return false;}var page=t.parentNode;e.topRowIndex=page.pageIndex*this.rowsPerPage;e.rowIndex=e.topRowIndex+_a40(t);e.rowTarget=t;return true;},processEvent:function(e){return this.processNodeEvent(e,this.contentNode);},renderRow:function(_a7e,_a7f){},removeRow:function(_a80){},getDefaultPageNode:function(_a81){return this.getDefaultNodes()[_a81];},positionPageNode:function(_a82,_a83){},getPageNodePosition:function(_a84){return _a84.offsetTop;},invalidatePageNode:function(_a85,_a86){var p=_a86[_a85];if(p){delete _a86[_a85];this.removePage(_a85,p);_a42(p);p.innerHTML="";}return p;},getPageRow:function(_a87){return _a87*this.rowsPerPage;},getLastPageRow:function(_a88){return Math.min(this.rowCount,this.getPageRow(_a88+1))-1;},getFirstVisibleRow:function(_a89,_a8a,_a8b){if(!this.pageExists(_a89)){return 0;}var row=this.getPageRow(_a89);var _a8c=this.getDefaultNodes();var rows=_a4a(_a8c[_a89]);for(var i=0,l=rows.length;i<l&&_a8a<_a8b;i++,row++){_a8a+=rows[i].offsetHeight;}return (row?row-1:row);},getLastVisibleRow:function(_a8d,_a8e,_a8f){if(!this.pageExists(_a8d)){return 0;}var _a90=this.getDefaultNodes();var row=this.getLastPageRow(_a8d);var rows=_a4a(_a90[_a8d]);for(var i=rows.length-1;i>=0&&_a8e>_a8f;i--,row--){_a8e-=rows[i].offsetHeight;}return row+1;},findTopRow:function(_a91){var _a92=this.getDefaultNodes();var rows=_a4a(_a92[this.page]);for(var i=0,l=rows.length,t=this.pageTop,h;i<l;i++){h=rows[i].offsetHeight;t+=h;if(t>=_a91){this.offset=h-(t-_a91);return i+this.page*this.rowsPerPage;}}return -1;},findScrollTop:function(_a93){var _a94=Math.floor(_a93/this.rowsPerPage);var t=0;var i,l;for(i=0;i<_a94;i++){t+=this.getPageHeight(i);}this.pageTop=t;this.page=_a94;this.needPage(_a94,this.pageTop);var _a95=this.getDefaultNodes();var rows=_a4a(_a95[_a94]);var r=_a93-this.rowsPerPage*_a94;for(i=0,l=rows.length;i<l&&i<r;i++){t+=rows[i].offsetHeight;}return t;},dummy:0});});},"url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\" data-dojo-attach-event=\"onmouseenter:_onMouseEnter, onmouseleave:_onMouseLeave, onclick:_onClick, ondblclick:_onDblClick\"\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t/><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\" data-dojo-attach-event=\"onfocus:_onLabelFocus\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dojo/_base/Color":function(){define(["./kernel","./lang","./array","./config"],function(dojo,lang,_a96,_a97){var _a98=dojo.Color=function(_a99){if(_a99){this.setColor(_a99);}};_a98.named={"black":[0,0,0],"silver":[192,192,192],"gray":[128,128,128],"white":[255,255,255],"maroon":[128,0,0],"red":[255,0,0],"purple":[128,0,128],"fuchsia":[255,0,255],"green":[0,128,0],"lime":[0,255,0],"olive":[128,128,0],"yellow":[255,255,0],"navy":[0,0,128],"blue":[0,0,255],"teal":[0,128,128],"aqua":[0,255,255],"transparent":_a97.transparentColor||[0,0,0,0]};lang.extend(_a98,{r:255,g:255,b:255,a:1,_set:function(r,g,b,a){var t=this;t.r=r;t.g=g;t.b=b;t.a=a;},setColor:function(_a9a){if(lang.isString(_a9a)){_a98.fromString(_a9a,this);}else{if(lang.isArray(_a9a)){_a98.fromArray(_a9a,this);}else{this._set(_a9a.r,_a9a.g,_a9a.b,_a9a.a);if(!(_a9a instanceof _a98)){this.sanitize();}}}return this;},sanitize:function(){return this;},toRgb:function(){var t=this;return [t.r,t.g,t.b];},toRgba:function(){var t=this;return [t.r,t.g,t.b,t.a];},toHex:function(){var arr=_a96.map(["r","g","b"],function(x){var s=this[x].toString(16);return s.length<2?"0"+s:s;},this);return "#"+arr.join("");},toCss:function(_a9b){var t=this,rgb=t.r+", "+t.g+", "+t.b;return (_a9b?"rgba("+rgb+", "+t.a:"rgb("+rgb)+")";},toString:function(){return this.toCss(true);}});_a98.blendColors=dojo.blendColors=function(_a9c,end,_a9d,obj){var t=obj||new _a98();_a96.forEach(["r","g","b","a"],function(x){t[x]=_a9c[x]+(end[x]-_a9c[x])*_a9d;if(x!="a"){t[x]=Math.round(t[x]);}});return t.sanitize();};_a98.fromRgb=dojo.colorFromRgb=function(_a9e,obj){var m=_a9e.toLowerCase().match(/^rgba?\(([\s\.,0-9]+)\)/);return m&&_a98.fromArray(m[1].split(/\s*,\s*/),obj);};_a98.fromHex=dojo.colorFromHex=function(_a9f,obj){var t=obj||new _a98(),bits=(_a9f.length==4)?4:8,mask=(1<<bits)-1;_a9f=Number("0x"+_a9f.substr(1));if(isNaN(_a9f)){return null;}_a96.forEach(["b","g","r"],function(x){var c=_a9f&mask;_a9f>>=bits;t[x]=bits==4?17*c:c;});t.a=1;return t;};_a98.fromArray=dojo.colorFromArray=function(a,obj){var t=obj||new _a98();t._set(Number(a[0]),Number(a[1]),Number(a[2]),Number(a[3]));if(isNaN(t.a)){t.a=1;}return t.sanitize();};_a98.fromString=dojo.colorFromString=function(str,obj){var a=_a98.named[str];return a&&_a98.fromArray(a,obj)||_a98.fromRgb(str,obj)||_a98.fromHex(str,obj);};return _a98;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_aa0,dojo,_aa1,_aa2,_aa3,dom,_aa4,geom,_aa5,_aa6){if(!dojo.isAsync){_aa5(0,function(){var _aa7=["./fx/Toggler"];_aa6(_aa7);});}var _aa8=dojo.fx={};var _aa9={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _aaa=function(_aab){this._index=-1;this._animations=_aab||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_aa1.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_aaa.prototype=new _aa0();lang.extend(_aaa,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){_aa2.disconnect(this._onAnimateCtx);_aa2.disconnect(this._onEndCtx);this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_aa2.connect(this._current,"onAnimate",this,"_onAnimate");this._onEndCtx=_aa2.connect(this._current,"onEnd",this,"_onEnd");this._current.play(0,true);}},play:function(_aac,_aad){if(!this._current){this._current=this._animations[this._index=0];}if(!_aad&&this._current.status()=="playing"){return this;}var _aae=_aa2.connect(this._current,"beforeBegin",this,function(){this._fire("beforeBegin");}),_aaf=_aa2.connect(this._current,"onBegin",this,function(arg){this._fire("onBegin",arguments);}),_ab0=_aa2.connect(this._current,"onPlay",this,function(arg){this._fire("onPlay",arguments);_aa2.disconnect(_aae);_aa2.disconnect(_aaf);_aa2.disconnect(_ab0);});if(this._onAnimateCtx){_aa2.disconnect(this._onAnimateCtx);}this._onAnimateCtx=_aa2.connect(this._current,"onAnimate",this,"_onAnimate");if(this._onEndCtx){_aa2.disconnect(this._onEndCtx);}this._onEndCtx=_aa2.connect(this._current,"onEnd",this,"_onEnd");this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_aa2.connect(this._current,"onPause",this,function(arg){this._fire("onPause",arguments);_aa2.disconnect(e);});this._current.pause();}return this;},gotoPercent:function(_ab1,_ab2){this.pause();var _ab3=this.duration*_ab1;this._current=null;_aa1.some(this._animations,function(a){if(a.duration<=_ab3){this._current=a;return true;}_ab3-=a.duration;return false;});if(this._current){this._current.gotoPercent(_ab3/this._current.duration,_ab2);}return this;},stop:function(_ab4){if(this._current){if(_ab4){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_aa2.connect(this._current,"onStop",this,function(arg){this._fire("onStop",arguments);_aa2.disconnect(e);});this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){_aa2.disconnect(this._onAnimateCtx);}if(this._onEndCtx){_aa2.disconnect(this._onEndCtx);}}});lang.extend(_aaa,_aa9);_aa8.chain=function(_ab5){return new _aaa(_ab5);};var _ab6=function(_ab7){this._animations=_ab7||[];this._connects=[];this._finished=0;this.duration=0;_aa1.forEach(_ab7,function(a){var _ab8=a.duration;if(a.delay){_ab8+=a.delay;}if(this.duration<_ab8){this.duration=_ab8;}this._connects.push(_aa2.connect(a,"onEnd",this,"_onEnd"));},this);this._pseudoAnimation=new _aa3.Animation({curve:[0,1],duration:this.duration});var self=this;_aa1.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_aa2.connect(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);}));});};lang.extend(_ab6,{_doAction:function(_ab9,args){_aa1.forEach(this._animations,function(a){a[_ab9].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_aba,args){var t=this._pseudoAnimation;t[_aba].apply(t,args);},play:function(_abb,_abc){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_abd,_abe){var ms=this.duration*_abd;_aa1.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_abe);});this._call("gotoPercent",arguments);return this;},stop:function(_abf){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_aa1.forEach(this._connects,_aa2.disconnect);}});lang.extend(_ab6,_aa9);_aa8.combine=function(_ac0){return new _ab6(_ac0);};_aa8.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_aa3.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _ac1=_aa4.get(node,"height");return Math.max(_ac1,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_aa2.connect(anim,"onStop",fini);_aa2.connect(anim,"onEnd",fini);return anim;};_aa8.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_aa3.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_aa2.connect(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";});var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_aa2.connect(anim,"onStop",fini);_aa2.connect(anim,"onEnd",fini);return anim;};_aa8.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_aa4.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_aa3.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_aa2.connect(anim,"beforeBegin",anim,init);return anim;};return _aa8;});},"dijit/_base/sniff":function(){define("dijit/_base/sniff",["dojo/uacss"],function(){});},"dojox/gfx":function(){define("dojox/gfx",["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_ac2,_ac3){_ac2.switchTo(_ac3);return _ac2;});},"dojox/charting/Theme":function(){define("dojox/charting/Theme",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/color/_base","dojox/color/Palette","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_ac4,_ac5,_ac6,_ac7,dlu,dgg){var _ac8=_ac4("dojox.charting.Theme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_ac9){_ac9=_ac9||{};var def=_ac8.defaultTheme;arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_ac9[name]);},this);if(_ac9.seriesThemes&&_ac9.seriesThemes.length){this.colors=null;this.seriesThemes=_ac9.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_ac9.colors||_ac8.defaultColors).slice(0);}this.markerThemes=null;if(_ac9.markerThemes&&_ac9.markerThemes.length){this.markerThemes=_ac9.markerThemes.slice(0);}this.markers=_ac9.markers?lang.clone(_ac9.markers):lang.delegate(_ac8.defaultMarkers);this.noGradConv=_ac9.noGradConv;this.noRadialConv=_ac9.noRadialConv;if(_ac9.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _aca=new _ac8({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_aca[name]=this[name];}},this);return _aca;},clear:function(){this._current=0;},next:function(_acb,_acc,_acd){var _ace=dlu.merge,_acf,_ad0;if(this.colors){_acf=lang.delegate(this.series);_ad0=lang.delegate(this.marker);var _ad1=new _ac5(this.colors[this._current%this.colors.length]),old;if(_acf.stroke&&_acf.stroke.color){_acf.stroke=lang.delegate(_acf.stroke);old=new _ac5(_acf.stroke.color);_acf.stroke.color=new _ac5(_ad1);_acf.stroke.color.a=old.a;}else{_acf.stroke={color:_ad1};}if(_ad0.stroke&&_ad0.stroke.color){_ad0.stroke=lang.delegate(_ad0.stroke);old=new _ac5(_ad0.stroke.color);_ad0.stroke.color=new _ac5(_ad1);_ad0.stroke.color.a=old.a;}else{_ad0.stroke={color:_ad1};}if(!_acf.fill||_acf.fill.type){_acf.fill=_ad1;}else{old=new _ac5(_acf.fill);_acf.fill=new _ac5(_ad1);_acf.fill.a=old.a;}if(!_ad0.fill||_ad0.fill.type){_ad0.fill=_ad1;}else{old=new _ac5(_ad0.fill);_ad0.fill=new _ac5(_ad1);_ad0.fill.a=old.a;}}else{_acf=this.seriesThemes?_ace(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_ad0=this.markerThemes?_ace(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_acf;}var _ad2=_ad0&&_ad0.symbol||this._markers[this._current%this._markers.length];var _ad3={series:_acf,marker:_ad0,symbol:_ad2};++this._current;if(_acc){_ad3=this.addMixin(_ad3,_acb,_acc);}if(_acd){_ad3=this.post(_ad3,_acb);}return _ad3;},skip:function(){++this._current;},addMixin:function(_ad4,_ad5,_ad6,_ad7){if(lang.isArray(_ad6)){arr.forEach(_ad6,function(m){_ad4=this.addMixin(_ad4,_ad5,m);},this);}else{var t={};if("color" in _ad6){if(_ad5=="line"||_ad5=="area"){lang.setObject("series.stroke.color",_ad6.color,t);lang.setObject("marker.stroke.color",_ad6.color,t);}else{lang.setObject("series.fill",_ad6.color,t);}}arr.forEach(["stroke","outline","shadow","fill","font","fontColor","labelWiring"],function(name){var _ad8="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_ad8 in _ad6;if(name in _ad6){lang.setObject("series."+name,_ad6[name],t);if(!b){lang.setObject("marker."+name,_ad6[name],t);}}if(b){lang.setObject("marker."+name,_ad6[_ad8],t);}});if("marker" in _ad6){t.symbol=_ad6.marker;}_ad4=dlu.merge(_ad4,t);}if(_ad7){_ad4=this.post(_ad4,_ad5);}return _ad4;},post:function(_ad9,_ada){var fill=_ad9.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_ada=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_ada=="slice"||_ada=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_ad9,{series:{fill:t}});}}return _ad9;},getTick:function(name,_adb){var tick=this.axis.tick,_adc=name+"Tick",_add=dlu.merge;if(tick){if(this.axis[_adc]){tick=_add(tick,this.axis[_adc]);}}else{tick=this.axis[_adc];}if(_adb){if(tick){if(_adb[_adc]){tick=_add(tick,_adb[_adc]);}}else{tick=_adb[_adc];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_ade){this.markers[name]=_ade;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_ac8,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",titleGap:15,titleFont:"normal normal normal 11pt Tahoma",titleFontColor:"#333",titleOrientation:"axis"},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}},defineColors:function(_adf){_adf=_adf||{};var l,c=[],n=_adf.num||5;if(_adf.colors){l=_adf.colors.length;for(var i=0;i<n;i++){c.push(_adf.colors[i%l]);}return c;}if(_adf.hue){var s=_adf.saturation||100,st=_adf.low||30,end=_adf.high||90;l=(end+st)/2;return _ac6.Palette.generate(_ac6.fromHsv(_adf.hue,s,l),"monochromatic").colors;}if(_adf.generator){return _ac6.Palette.generate(_adf.base,_adf.generator).colors;}return c;},generateGradient:function(_ae0,_ae1,_ae2){var fill=lang.delegate(_ae0);fill.colors=[{offset:0,color:_ae1},{offset:1,color:_ae2}];return fill;},generateHslColor:function(_ae3,_ae4){_ae3=new _ac5(_ae3);var hsl=_ae3.toHsl(),_ae5=_ac6.fromHsl(hsl.h,hsl.s,_ae4);_ae5.a=_ae3.a;return _ae5;},generateHslGradient:function(_ae6,_ae7,_ae8,_ae9){_ae6=new _ac5(_ae6);var hsl=_ae6.toHsl(),_aea=_ac6.fromHsl(hsl.h,hsl.s,_ae8),_aeb=_ac6.fromHsl(hsl.h,hsl.s,_ae9);_aea.a=_aeb.a=_ae6.a;return _ac8.generateGradient(_ae7,_aea,_aeb);}});return _ac8;});},"dojo/data/util/sorter":function(){define(["dojo/_base/lang"],function(lang){var _aec=lang.getObject("dojo.data.util.sorter",true);_aec.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_aec.createSortFunction=function(_aed,_aee){var _aef=[];function _af0(attr,dir,comp,s){return function(_af1,_af2){var a=s.getValue(_af1,attr);var b=s.getValue(_af2,attr);return dir*comp(a,b);};};var _af3;var map=_aee.comparatorMap;var bc=_aec.basicComparator;for(var i=0;i<_aed.length;i++){_af3=_aed[i];var attr=_af3.attribute;if(attr){var dir=(_af3.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_aef.push(_af0(attr,dir,comp,_aee));}}return function(rowA,rowB){var i=0;while(i<_aef.length){var ret=_aef[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _aec;});},"dojo/dom":function(){define(["./_base/sniff","./_base/lang","./_base/window"],function(has,lang,win){try{document.execCommand("BackgroundImageCache",false,true);}catch(e){}var dom={};if(has("ie")){dom.byId=function(id,doc){if(typeof id!="string"){return id;}var _af4=doc||win.doc,te=id&&_af4.getElementById(id);if(te&&(te.attributes.id.value==id||te.id==id)){return te;}else{var eles=_af4.all[id];if(!eles||eles.nodeName){eles=[eles];}var i=0;while((te=eles[i++])){if((te.attributes&&te.attributes.id&&te.attributes.id.value==id)||te.id==id){return te;}}}};}else{dom.byId=function(id,doc){return ((typeof id=="string")?(doc||win.doc).getElementById(id):id)||null;};}dom.isDescendant=function(node,_af5){try{node=dom.byId(node);_af5=dom.byId(_af5);while(node){if(node==_af5){return true;}node=node.parentNode;}}catch(e){}return false;};dom.setSelectable=function(node,_af6){node=dom.byId(node);if(has("mozilla")){node.style.MozUserSelect=_af6?"":"none";}else{if(has("khtml")||has("webkit")){node.style.KhtmlUserSelect=_af6?"auto":"none";}else{if(has("ie")){var v=(node.unselectable=_af6?"":"on"),cs=node.getElementsByTagName("*"),i=0,l=cs.length;for(;i<l;++i){cs.item(i).unselectable=v;}}}}};return dom;});},"dojo/window":function(){define(["./_base/kernel","./_base/lang","./_base/sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(dojo,lang,has,_af7,dom,geom,_af8){lang.getObject("window",true,dojo);dojo.window.getBox=function(){var _af9=(_af7.doc.compatMode=="BackCompat")?_af7.body():_af7.doc.documentElement;var _afa=geom.docScroll();var _afb=_af7.doc.parentWindow||_af7.doc.defaultView;return {l:_afa.x,t:_afa.y,w:_afb.innerWidth||_af9.clientWidth,h:_afb.innerHeight||_af9.clientHeight};};dojo.window.get=function(doc){if(has("ie")&&window!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;};dojo.window.scrollIntoView=function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_af7.doc,body=doc.body||_af7.body(),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){node.scrollIntoView(false);return;}var _afc=doc.compatMode=="BackCompat",_afd=(isIE>=9&&node.ownerDocument.parentWindow.frameElement)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_afc?body:html),_afe=isWK?body:_afd,_aff=_afd.clientWidth,_b00=_afd.clientHeight,rtl=!geom.isBodyLtr(),_b01=pos||geom.position(node),el=node.parentNode,_b02=function(el){return ((isIE<=6||(isIE&&_afc))?false:(_af8.get(el,"position").toLowerCase()=="fixed"));};if(_b02(node)){return;}while(el){if(el==body){el=_afe;}var _b03=geom.position(el),_b04=_b02(el);if(el==_afe){_b03.w=_aff;_b03.h=_b00;if(_afe==html&&isIE&&rtl){_b03.x+=_afe.offsetWidth-_b03.w;}if(_b03.x<0||!isIE){_b03.x=0;}if(_b03.y<0||!isIE){_b03.y=0;}}else{var pb=geom.getPadBorderExtents(el);_b03.w-=pb.w;_b03.h-=pb.h;_b03.x+=pb.l;_b03.y+=pb.t;var _b05=el.clientWidth,_b06=_b03.w-_b05;if(_b05>0&&_b06>0){_b03.w=_b05;_b03.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_b06:0;}_b05=el.clientHeight;_b06=_b03.h-_b05;if(_b05>0&&_b06>0){_b03.h=_b05;}}if(_b04){if(_b03.y<0){_b03.h+=_b03.y;_b03.y=0;}if(_b03.x<0){_b03.w+=_b03.x;_b03.x=0;}if(_b03.y+_b03.h>_b00){_b03.h=_b00-_b03.y;}if(_b03.x+_b03.w>_aff){_b03.w=_aff-_b03.x;}}var l=_b01.x-_b03.x,t=_b01.y-Math.max(_b03.y,0),r=l+_b01.w-_b03.w,bot=t+_b01.h-_b03.h;if(r*l>0){var s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_afc)||isIE>=9)){s=-s;}_b01.x+=el.scrollLeft;el.scrollLeft+=s;_b01.x-=el.scrollLeft;}if(bot*t>0){_b01.y+=el.scrollTop;el.scrollTop+=Math[t<0?"max":"min"](t,bot);_b01.y-=el.scrollTop;}el=(el!=_afe)&&!_b04&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}};return dojo.window;});},"dijit/_base/popup":function(){define("dijit/_base/popup",["dojo/dom-class","../popup","../BackgroundIframe"],function(_b07,_b08){var _b09=_b08._createWrapper;_b08._createWrapper=function(_b0a){if(!_b0a.declaredClass){_b0a={_popupWrapper:(_b0a.parentNode&&_b07.contains(_b0a.parentNode,"dijitPopup"))?_b0a.parentNode:null,domNode:_b0a,destroy:function(){}};}return _b09.call(this,_b0a);};var _b0b=_b08.open;_b08.open=function(args){if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){var ary=[];for(var key in args.orient){ary.push({aroundCorner:key,corner:args.orient[key]});}args.orient=ary;}return _b0b.call(this,args);};return _b08;});},"dojo/_base/lang":function(){define(["./kernel","../has","./sniff"],function(dojo,has){has.add("bug-for-in-skips-shadowed",function(){for(var i in {toString:1}){return 0;}return 1;});var _b0c=has("bug-for-in-skips-shadowed")?"hasOwnProperty.valueOf.isPrototypeOf.propertyIsEnumerable.toLocaleString.toString.constructor".split("."):[],_b0d=_b0c.length,_b0e=function(dest,_b0f,_b10){var name,s,i,_b11={};for(name in _b0f){s=_b0f[name];if(!(name in dest)||(dest[name]!==s&&(!(name in _b11)||_b11[name]!==s))){dest[name]=_b10?_b10(s):s;}}if(has("bug-for-in-skips-shadowed")){if(_b0f){for(i=0;i<_b0d;++i){name=_b0c[i];s=_b0f[name];if(!(name in dest)||(dest[name]!==s&&(!(name in _b11)||_b11[name]!==s))){dest[name]=_b10?_b10(s):s;}}}}return dest;},_b12=function(dest,_b13){if(!dest){dest={};}for(var i=1,l=arguments.length;i<l;i++){lang._mixin(dest,arguments[i]);}return dest;},_b14=function(_b15,_b16,_b17){var p,i=0,_b18=dojo.global;if(!_b17){if(!_b15.length){return _b18;}else{p=_b15[i++];try{_b17=dojo.scopeMap[p]&&dojo.scopeMap[p][1];}catch(e){}_b17=_b17||(p in _b18?_b18[p]:(_b16?_b18[p]={}:undefined));}}while(_b17&&(p=_b15[i++])){_b17=(p in _b17?_b17[p]:(_b16?_b17[p]={}:undefined));}return _b17;},_b19=function(name,_b1a,_b1b){var _b1c=name.split("."),p=_b1c.pop(),obj=_b14(_b1c,true,_b1b);return obj&&p?(obj[p]=_b1a):undefined;},_b1d=function(name,_b1e,_b1f){return _b14(name.split("."),_b1e,_b1f);},_b20=function(name,obj){return lang.getObject(name,false,obj)!==undefined;},opts=Object.prototype.toString,_b21=function(it){return (typeof it=="string"||it instanceof String);},_b22=function(it){return it&&(it instanceof Array||typeof it=="array");},_b23=function(it){return opts.call(it)==="[object Function]";},_b24=function(it){return it!==undefined&&(it===null||typeof it=="object"||lang.isArray(it)||lang.isFunction(it));},_b25=function(it){return it&&it!==undefined&&!lang.isString(it)&&!lang.isFunction(it)&&!(it.tagName&&it.tagName.toLowerCase()=="form")&&(lang.isArray(it)||isFinite(it.length));},_b26=function(it){return it&&!lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));},_b27=function(_b28,_b29){for(var i=1,l=arguments.length;i<l;i++){lang._mixin(_b28.prototype,arguments[i]);}return _b28;},_b2a=function(_b2b,_b2c){var pre=_b2d(arguments,2);var _b2e=lang.isString(_b2c);return function(){var args=_b2d(arguments);var f=_b2e?(_b2b||dojo.global)[_b2c]:_b2c;return f&&f.apply(_b2b||this,pre.concat(args));};},_b2f=function(_b30,_b31){if(arguments.length>2){return lang._hitchArgs.apply(dojo,arguments);}if(!_b31){_b31=_b30;_b30=null;}if(lang.isString(_b31)){_b30=_b30||dojo.global;if(!_b30[_b31]){throw (["dojo.hitch: scope[\"",_b31,"\"] is null (scope=\"",_b30,"\")"].join(""));}return function(){return _b30[_b31].apply(_b30,arguments||[]);};}return !_b30?_b31:function(){return _b31.apply(_b30,arguments||[]);};},_b32=(function(){function TMP(){};return function(obj,_b33){TMP.prototype=obj;var tmp=new TMP();TMP.prototype=null;if(_b33){lang._mixin(tmp,_b33);}return tmp;};})(),_b34=function(obj,_b35,_b36){return (_b36||[]).concat(Array.prototype.slice.call(obj,_b35||0));},_b2d=has("ie")?(function(){function slow(obj,_b37,_b38){var arr=_b38||[];for(var x=_b37||0;x<obj.length;x++){arr.push(obj[x]);}return arr;};return function(obj){return ((obj.item)?slow:_b34).apply(this,arguments);};})():_b34,_b39=function(_b3a){var arr=[null];return lang.hitch.apply(dojo,arr.concat(lang._toArray(arguments)));},_b3b=function(src){if(!src||typeof src!="object"||lang.isFunction(src)){return src;}if(src.nodeType&&"cloneNode" in src){return src.cloneNode(true);}if(src instanceof Date){return new Date(src.getTime());}if(src instanceof RegExp){return new RegExp(src);}var r,i,l;if(lang.isArray(src)){r=[];for(i=0,l=src.length;i<l;++i){if(i in src){r.push(_b3b(src[i]));}}}else{r=src.constructor?new src.constructor():{};}return lang._mixin(r,src,_b3b);},trim=String.prototype.trim?function(str){return str.trim();}:function(str){return str.replace(/^\s\s*/,"").replace(/\s\s*$/,"");},_b3c=/\{([^\}]+)\}/g,_b3d=function(tmpl,map,_b3e){return tmpl.replace(_b3e||_b3c,lang.isFunction(map)?map:function(_b3f,k){return _b1d(k,false,map);});},lang={_extraNames:_b0c,_mixin:_b0e,mixin:_b12,setObject:_b19,getObject:_b1d,exists:_b20,isString:_b21,isArray:_b22,isFunction:_b23,isObject:_b24,isArrayLike:_b25,isAlien:_b26,extend:_b27,_hitchArgs:_b2a,hitch:_b2f,delegate:_b32,_toArray:_b2d,partial:_b39,clone:_b3b,trim:trim,replace:_b3d};1&&_b12(dojo,lang);return lang;});},"dojo/DeferredList":function(){define(["./_base/kernel","./_base/Deferred","./_base/array"],function(dojo,_b40,_b41){dojo.DeferredList=function(list,_b42,_b43,_b44,_b45){var _b46=[];_b40.call(this);var self=this;if(list.length===0&&!_b42){this.resolve([0,[]]);}var _b47=0;_b41.forEach(list,function(item,i){item.then(function(_b48){if(_b42){self.resolve([i,_b48]);}else{_b49(true,_b48);}},function(_b4a){if(_b43){self.reject(_b4a);}else{_b49(false,_b4a);}if(_b44){return null;}throw _b4a;});function _b49(_b4b,_b4c){_b46[i]=[_b4b,_b4c];_b47++;if(_b47===list.length){self.resolve(_b46);}};});};dojo.DeferredList.prototype=new _b40();dojo.DeferredList.prototype.gatherResults=function(_b4d){var d=new dojo.DeferredList(_b4d,false,true,false);d.addCallback(function(_b4e){var ret=[];_b41.forEach(_b4e,function(_b4f){ret.push(_b4f[1]);});return ret;});return d;};return dojo.DeferredList;});},"dojox/charting/plot2d/StackedLines":function(){define("dojox/charting/plot2d/StackedLines",["dojo/_base/declare","./Stacked"],function(_b50,_b51){return _b50("dojox.charting.plot2d.StackedLines",_b51,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/axis2d/Default":function(){define("dojox/charting/axis2d/Default",["dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/dom-geometry","./Invisible","../scaler/common","../scaler/linear","./common","dojox/gfx","dojox/lang/utils"],function(lang,arr,has,_b52,_b53,html,_b54,_b55,_b56,lin,_b57,g,du){var _b58=4,_b59=45;return _b52("dojox.charting.axis2d.Default",_b55,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_b5a,_b5b){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_b5b);du.updateWithPattern(this.opt,_b5b,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}},getOffsets:function(){var s=this.scaler,_b5c={l:0,r:0,t:0,b:0};if(!s){return _b5c;}var o=this.opt,_b5d=0,a,b,c,d,gl=_b56.getNumericLabel,_b5e=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,_b5f=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_b60=o.titleFont||(ta.tick&&ta.tick.titleFont),_b61=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_b62=this.chart.theme.getTick("major",o),_b63=this.chart.theme.getTick("minor",o),size=_b5f?g.normalizedLength(g.splitFontString(_b5f).size):0,_b64=_b60?g.normalizedLength(g.splitFontString(_b60).size):0,_b65=o.rotation%360,_b66=o.leftBottom,cosr=Math.abs(Math.cos(_b65*Math.PI/180)),sinr=Math.abs(Math.sin(_b65*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(_b65<0){_b65+=360;}if(size){if(this.labels){_b5d=this._groupLabelWidth(this.labels,_b5f,o.maxLabelCharCount);}else{_b5d=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_b5f,o.maxLabelCharCount);}_b5d=o.maxLabelSize?Math.min(o.maxLabelSize,_b5d):_b5d;if(this.vertical){var side=_b66?"l":"r";switch(_b65){case 0:case 180:_b5c[side]=_b5d;_b5c.t=_b5c.b=size/2;break;case 90:case 270:_b5c[side]=size;_b5c.t=_b5c.b=_b5d/2;break;default:if(_b65<=_b59||(180<_b65&&_b65<=(180+_b59))){_b5c[side]=size*sinr/2+_b5d*cosr;_b5c[_b66?"t":"b"]=size*cosr/2+_b5d*sinr;_b5c[_b66?"b":"t"]=size*cosr/2;}else{if(_b65>(360-_b59)||(180>_b65&&_b65>(180-_b59))){_b5c[side]=size*sinr/2+_b5d*cosr;_b5c[_b66?"b":"t"]=size*cosr/2+_b5d*sinr;_b5c[_b66?"t":"b"]=size*cosr/2;}else{if(_b65<90||(180<_b65&&_b65<270)){_b5c[side]=size*sinr+_b5d*cosr;_b5c[_b66?"t":"b"]=size*cosr+_b5d*sinr;}else{_b5c[side]=size*sinr+_b5d*cosr;_b5c[_b66?"b":"t"]=size*cosr+_b5d*sinr;}}}break;}_b5c[side]+=_b58+Math.max(_b62.length,_b63.length)+(o.title?(_b64+_b61):0);}else{var side=_b66?"b":"t";switch(_b65){case 0:case 180:_b5c[side]=size;_b5c.l=_b5c.r=_b5d/2;break;case 90:case 270:_b5c[side]=_b5d;_b5c.l=_b5c.r=size/2;break;default:if((90-_b59)<=_b65&&_b65<=90||(270-_b59)<=_b65&&_b65<=270){_b5c[side]=size*sinr/2+_b5d*cosr;_b5c[_b66?"r":"l"]=size*cosr/2+_b5d*sinr;_b5c[_b66?"l":"r"]=size*cosr/2;}else{if(90<=_b65&&_b65<=(90+_b59)||270<=_b65&&_b65<=(270+_b59)){_b5c[side]=size*sinr/2+_b5d*cosr;_b5c[_b66?"l":"r"]=size*cosr/2+_b5d*sinr;_b5c[_b66?"r":"l"]=size*cosr/2;}else{if(_b65<_b59||(180<_b65&&_b65<(180-_b59))){_b5c[side]=size*sinr+_b5d*cosr;_b5c[_b66?"r":"l"]=size*cosr+_b5d*sinr;}else{_b5c[side]=size*sinr+_b5d*cosr;_b5c[_b66?"l":"r"]=size*cosr+_b5d*sinr;}}}break;}_b5c[side]+=_b58+Math.max(_b62.length,_b63.length)+(o.title?(_b64+_b61):0);}}if(_b5d){this._cachedLabelWidth=_b5d;}return _b5c;},cleanGroup:function(_b67){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_b68,_b69,x,y,_b6a,_b6b,font,_b6c,_b6d){if(!this.opt.enableCache||_b68=="html"){return _b57.createText[_b68](this.chart,_b69,x,y,_b6a,_b6b,font,_b6c,_b6d);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_b6b,align:_b6a});_b69.add(text);}else{text=_b57.createText[_b68](this.chart,_b69,x,y,_b6a,_b6b,font,_b6c,_b6d);}this._textUsePool.push(text);return text;},createLine:function(_b6e,_b6f){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_b6f);_b6e.add(line);}else{line=_b6e.createLine(_b6f);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_b70){if(!this.dirty){return this;}var o=this.opt,ta=this.chart.theme.axis,_b71=o.leftBottom,_b72=o.rotation%360,_b73,stop,_b74,_b75=0,_b76,_b77,_b78,_b79,_b7a,_b7b,_b7c=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_b7d=o.titleFont||(ta.tick&&ta.tick.titleFont),_b7e=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_b7f=o.titleFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_b80=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_b81=o.titleOrientation||(ta.tick&&ta.tick.titleOrientation)||"axis",_b82=this.chart.theme.getTick("major",o),_b83=this.chart.theme.getTick("minor",o),_b84=this.chart.theme.getTick("micro",o),_b85=Math.max(_b82.length,_b83.length,_b84.length),_b86="stroke" in o?o.stroke:ta.stroke,size=_b7c?g.normalizedLength(g.splitFontString(_b7c).size):0,cosr=Math.abs(Math.cos(_b72*Math.PI/180)),sinr=Math.abs(Math.sin(_b72*Math.PI/180)),_b87=_b7d?g.normalizedLength(g.splitFontString(_b7d).size):0;if(_b72<0){_b72+=360;}if(this.vertical){_b73={y:dim.height-_b70.b};stop={y:_b70.t};_b74={y:(dim.height-_b70.b+_b70.t)/2};_b76=size*sinr+(this._cachedLabelWidth||0)*cosr+_b58+Math.max(_b82.length,_b83.length)+_b87+_b80;_b77={x:0,y:-1};_b7a={x:0,y:0};_b78={x:1,y:0};_b79={x:_b58,y:0};switch(_b72){case 0:_b7b="end";_b7a.y=size*0.4;break;case 90:_b7b="middle";_b7a.x=-size;break;case 180:_b7b="start";_b7a.y=-size*0.4;break;case 270:_b7b="middle";break;default:if(_b72<_b59){_b7b="end";_b7a.y=size*0.4;}else{if(_b72<90){_b7b="end";_b7a.y=size*0.4;}else{if(_b72<(180-_b59)){_b7b="start";}else{if(_b72<(180+_b59)){_b7b="start";_b7a.y=-size*0.4;}else{if(_b72<270){_b7b="start";_b7a.x=_b71?0:size*0.4;}else{if(_b72<(360-_b59)){_b7b="end";_b7a.x=_b71?0:size*0.4;}else{_b7b="end";_b7a.y=size*0.4;}}}}}}}if(_b71){_b73.x=stop.x=_b70.l;_b75=(_b81&&_b81=="away")?90:270;_b74.x=_b70.l-_b76+(_b75==270?_b87:0);_b78.x=-1;_b79.x=-_b79.x;}else{_b73.x=stop.x=dim.width-_b70.r;_b75=(_b81&&_b81=="axis")?90:270;_b74.x=dim.width-_b70.r+_b76-(_b75==270?0:_b87);switch(_b7b){case "start":_b7b="end";break;case "end":_b7b="start";break;case "middle":_b7a.x+=size;break;}}}else{_b73={x:_b70.l};stop={x:dim.width-_b70.r};_b74={x:(dim.width-_b70.r+_b70.l)/2};_b76=size*cosr+(this._cachedLabelWidth||0)*sinr+_b58+Math.max(_b82.length,_b83.length)+_b87+_b80;_b77={x:1,y:0};_b7a={x:0,y:0};_b78={x:0,y:1};_b79={x:0,y:_b58};switch(_b72){case 0:_b7b="middle";_b7a.y=size;break;case 90:_b7b="start";_b7a.x=-size*0.4;break;case 180:_b7b="middle";break;case 270:_b7b="end";_b7a.x=size*0.4;break;default:if(_b72<(90-_b59)){_b7b="start";_b7a.y=_b71?size:0;}else{if(_b72<(90+_b59)){_b7b="start";_b7a.x=-size*0.4;}else{if(_b72<180){_b7b="start";_b7a.y=_b71?0:-size;}else{if(_b72<(270-_b59)){_b7b="end";_b7a.y=_b71?0:-size;}else{if(_b72<(270+_b59)){_b7b="end";_b7a.y=_b71?size*0.4:0;}else{_b7b="end";_b7a.y=_b71?size:0;}}}}}}if(_b71){_b73.y=stop.y=dim.height-_b70.b;_b75=(_b81&&_b81=="axis")?180:0;_b74.y=dim.height-_b70.b+_b76-(_b75?_b87:0);}else{_b73.y=stop.y=_b70.t;_b75=(_b81&&_b81=="away")?180:0;_b74.y=_b70.t-_b76+(_b75?0:_b87);_b78.y=-1;_b79.y=-_b79.y;switch(_b7b){case "start":_b7b="end";break;case "end":_b7b="start";break;case "middle":_b7a.y-=size;break;}}}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_b88,f=lin.getTransformerFromModel(this.scaler),_b89=(!o.title||!_b75)&&!_b72&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_b78.x*_b82.length,dy=_b78.y*_b82.length;s.createLine({x1:_b73.x,y1:_b73.y,x2:stop.x,y2:stop.y}).setStroke(_b86);if(o.title){var _b8a=_b57.createText[_b89](this.chart,s,_b74.x,_b74.y,"middle",o.title,_b7d,_b7f);if(_b89=="html"){this.htmlElements.push(_b8a);}else{_b8a.setTransform(g.matrix.rotategAt(_b75,_b74.x,_b74.y));}}if(t==null){this.dirty=false;return this;}arr.forEach(t.major,function(tick){var _b8b=f(tick.value),elem,x=_b73.x+_b77.x*_b8b,y=_b73.y+_b77.y*_b8b;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_b82);if(tick.label){var _b8c=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_b7c,o.maxLabelCharCount):{text:tick.label,truncated:false};_b8c=o.maxLabelSize?this.getTextWithLimitLength(_b8c.text,_b7c,o.maxLabelSize,_b8c.truncated):_b8c;elem=this.createText(_b89,s,x+dx+_b79.x+(_b72?0:_b7a.x),y+dy+_b79.y+(_b72?0:_b7a.y),_b7b,_b8c.text,_b7c,_b7e);if(this.chart.truncateBidi&&_b8c.truncated){this.chart.truncateBidi(elem,tick.label,_b89);}_b8c.truncated&&this.labelTooltip(elem,this.chart,tick.label,_b8c.text,_b7c,_b89);if(_b89=="html"){this.htmlElements.push(elem);}else{if(_b72){elem.setTransform([{dx:_b7a.x,dy:_b7a.y},g.matrix.rotategAt(_b72,x+dx+_b79.x,y+dy+_b79.y)]);}}}},this);dx=_b78.x*_b83.length;dy=_b78.y*_b83.length;_b88=c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _b8d=f(tick.value),elem,x=_b73.x+_b77.x*_b8d,y=_b73.y+_b77.y*_b8d;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_b83);if(_b88&&tick.label){var _b8e=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_b7c,o.maxLabelCharCount):{text:tick.label,truncated:false};_b8e=o.maxLabelSize?this.getTextWithLimitLength(_b8e.text,_b7c,o.maxLabelSize,_b8e.truncated):_b8e;elem=this.createText(_b89,s,x+dx+_b79.x+(_b72?0:_b7a.x),y+dy+_b79.y+(_b72?0:_b7a.y),_b7b,_b8e.text,_b7c,_b7e);if(this.chart.getTextDir&&_b8e.truncated){this.chart.truncateBidi(elem,tick.label,_b89);}_b8e.truncated&&this.labelTooltip(elem,this.chart,tick.label,_b8e.text,_b7c,_b89);if(_b89=="html"){this.htmlElements.push(elem);}else{if(_b72){elem.setTransform([{dx:_b7a.x,dy:_b7a.y},g.matrix.rotategAt(_b72,x+dx+_b79.x,y+dy+_b79.y)]);}}}},this);dx=_b78.x*_b84.length;dy=_b78.y*_b84.length;arr.forEach(t.micro,function(tick){var _b8f=f(tick.value),elem,x=_b73.x+_b77.x*_b8f,y=_b73.y+_b77.y*_b8f;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_b84);},this);}catch(e){}this.dirty=false;return this;},labelTooltip:function(elem,_b90,_b91,_b92,font,_b93){var _b94=["dijit/Tooltip"];var _b95={type:"rect"},_b96=["above","below"],_b97=g._base._getTextBox(_b92,{font:font}).w||0,_b98=font?g.normalizedLength(g.splitFontString(font).size):0;if(_b93=="html"){lang.mixin(_b95,html.coords(elem.firstChild,true));_b95.width=Math.ceil(_b97);_b95.height=Math.ceil(_b98);this._events.push({shape:dojo,handle:_b53.connect(elem.firstChild,"onmouseover",this,function(e){require(_b94,function(_b99){_b99.show(_b91,_b95,_b96);});})});this._events.push({shape:dojo,handle:_b53.connect(elem.firstChild,"onmouseout",this,function(e){require(_b94,function(_b9a){_b9a.hide(_b95);});})});}else{var shp=elem.getShape(),lt=html.coords(_b90.node,true);_b95=lang.mixin(_b95,{x:shp.x-_b97/2,y:shp.y});_b95.x+=lt.x;_b95.y+=lt.y;_b95.x=Math.round(_b95.x);_b95.y=Math.round(_b95.y);_b95.width=Math.ceil(_b97);_b95.height=Math.ceil(_b98);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_b94,function(_b9b){_b9b.show(_b91,_b95,_b96);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_b94,function(_b9c){_b9c.hide(_b95);});})});}}});});},"dojox/charting/Chart":function(){define("dojox/charting/Chart",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/_base/sniff","./Element","./Theme","./Series","./axis2d/common","dojox/gfx","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(lang,arr,_b9d,html,dom,_b9e,_b9f,_ba0,has,_ba1,_ba2,_ba3,_ba4,g,func,_ba5,_ba6){var dc=dojox.charting,_ba7=func.lambda("item.clear()"),_ba8=func.lambda("item.purgeGroup()"),_ba9=func.lambda("item.destroy()"),_baa=func.lambda("item.dirty = false"),_bab=func.lambda("item.dirty = true"),_bac=func.lambda("item.name");_b9d("dojox.charting.Chart",null,{constructor:function(node,_bad){if(!_bad){_bad={};}this.margins=_bad.margins?_bad.margins:{l:10,t:10,r:10,b:10};this.stroke=_bad.stroke;this.fill=_bad.fill;this.delayInMs=_bad.delayInMs||200;this.title=_bad.title;this.titleGap=_bad.titleGap;this.titlePos=_bad.titlePos;this.titleFont=_bad.titleFont;this.titleFontColor=_bad.titleFontColor;this.chartTitle=null;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dom.byId(node);var box=_b9e.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);},destroy:function(){arr.forEach(this.series,_ba9);arr.forEach(this.stack,_ba9);func.forIn(this.axes,_ba9);if(this.chartTitle&&this.chartTitle.tagName){_b9f.destroy(this.chartTitle);}this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=html.coords(this.node,true);}return this.coords;},setTheme:function(_bae){this.theme=_bae.clone();this.dirty=true;return this;},addAxis:function(name,_baf){var axis,_bb0=_baf&&_baf.type||"Default";if(typeof _bb0=="string"){if(!dc.axis2d||!dc.axis2d[_bb0]){throw Error("Can't find axis: "+_bb0+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_bb0](this,_baf);}else{axis=new _bb0(this,_baf);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_bb1){var plot,_bb2=_bb1&&_bb1.type||"Default";if(typeof _bb2=="string"){if(!dc.plot2d||!dc.plot2d[_bb2]){throw Error("Can't find plot: "+_bb2+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_bb2](this,_bb1);}else{plot=new _bb2(this,_bb1);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _bb3=this.plots[name];delete this.plots[name];this.stack[_bb3].destroy();this.stack.splice(_bb3,1);func.forIn(this.plots,function(idx,name,_bb4){if(idx>_bb3){_bb4[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_bb5){this.runs[run.plot]=_bb5;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_bac);},setPlotOrder:function(_bb6){var _bb7={},_bb8=func.filter(_bb6,function(name){if(!(name in this.plots)||(name in _bb7)){return false;}_bb7[name]=1;return true;},this);if(_bb8.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _bb7)){_bb8.push(name);}});}var _bb9=func.map(_bb8,function(name){return this.stack[this.plots[name]];},this);func.forEach(_bb9,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_bb9;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _bba=this.plots[name];if(_bba){var _bbb=this.getPlotOrder();_bbb.splice(_bba,1);_bbb.unshift(name);return this.setPlotOrder(_bbb);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _bbc=this.plots[name];if(_bbc<this.stack.length-1){var _bbd=this.getPlotOrder();_bbd.splice(_bbc,1);_bbd.push(name);return this.setPlotOrder(_bbd);}}return this;},addSeries:function(name,data,_bbe){var run=new _ba3(this,data,_bbe);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _bbf=this.runs[name];delete this.runs[name];this.series[_bbf].destroy();this.series.splice(_bbf,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_bbf){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},getSeriesOrder:function(_bc0){return func.map(func.filter(this.series,function(run){return run.plot==_bc0;}),_bac);},setSeriesOrder:function(_bc1){var _bc2,_bc3={},_bc4=func.filter(_bc1,function(name){if(!(name in this.runs)||(name in _bc3)){return false;}var run=this.series[this.runs[name]];if(_bc2){if(run.plot!=_bc2){return false;}}else{_bc2=run.plot;}_bc3[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _bc3)&&run.plot==_bc2){_bc4.push(name);}});var _bc5=func.map(_bc4,function(name){return this.series[this.runs[name]];},this);this.series=_bc5.concat(func.filter(this.series,function(run){return run.plot!=_bc2;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _bc6=this.runs[name],_bc7=this.getSeriesOrder(this.series[_bc6].plot);if(name!=_bc7[0]){_bc7.splice(_bc6,1);_bc7.unshift(name);return this.setSeriesOrder(_bc7);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _bc8=this.runs[name],_bc9=this.getSeriesOrder(this.series[_bc8].plot);if(name!=_bc9[_bc9.length-1]){_bc9.splice(_bc8,1);_bc9.push(name);return this.setSeriesOrder(_bc9);}}return this;},resize:function(_bca,_bcb){var box;switch(arguments.length){case 1:box=lang.mixin({},_bca);_b9e.setMarginBox(this.node,box);break;case 2:box={w:_bca,h:_bcb};_b9e.setMarginBox(this.node,box);break;}box=_b9e.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_bcc,_bcd,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_bcc,_bcd);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _bce,_bcf,_bd0=axis.getScaler().bounds,s=_bd0.span/(_bd0.upper-_bd0.lower);if(axis.vertical){_bce=sy;_bcf=dy/s/_bce;}else{_bce=sx;_bcf=dx/s/_bce;}axis.setWindow(_bce,_bcf);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_bd1){var axis=this.axes[name];if(axis){var _bd2,_bd3,_bd4=axis.getScaler().bounds;var _bd5=Math.min(_bd1[0],_bd1[1]);var _bd6=Math.max(_bd1[0],_bd1[1]);_bd5=_bd1[0]<_bd4.lower?_bd4.lower:_bd5;_bd6=_bd1[1]>_bd4.upper?_bd4.upper:_bd6;_bd2=(_bd4.upper-_bd4.lower)/(_bd6-_bd5);_bd3=_bd5-_bd4.lower;this.setAxisWindow(name,_bd2,_bd3);this.render();}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _bd7=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_bd8(_bd7,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_ba7);if(!this.theme){this.setTheme(new _ba2(dojox.charting._def));}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_ba7);_bd8(this.stack,dim);var _bd9=this.offsets={l:0,r:0,t:0,b:0};func.forIn(this.axes,function(axis){func.forIn(axis.getOffsets(),function(o,i){_bd9[i]+=o;});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _bda=g.normalizedLength(g.splitFontString(this.titleFont).size);_bd9[this.titlePos=="top"?"t":"b"]+=(_bda+this.titleGap);}func.forIn(this.margins,function(o,i){_bd9[i]+=o;});this.plotArea={width:dim.width-_bd9.l-_bd9.r,height:dim.height-_bd9.t-_bd9.b};func.forIn(this.axes,_ba7);_bd8(this.stack,this.plotArea);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _bdb=this.offsets,dim=this.dim,rect;arr.forEach(this.series,_ba8);func.forIn(this.axes,_ba8);arr.forEach(this.stack,_ba8);if(this.chartTitle&&this.chartTitle.tagName){_b9f.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_bdc=t.plotarea&&t.plotarea.stroke,w=Math.max(0,dim.width-_bdb.l-_bdb.r),h=Math.max(0,dim.height-_bdb.t-_bdb.b),rect={x:_bdb.l-1,y:_bdb.t-1,width:w+2,height:h+2};if(fill){fill=_ba1.prototype._shapeFill(_ba1.prototype._plotFill(fill,dim,_bdb),rect);this.surface.createRect(rect).setFill(fill);}if(_bdc){this.surface.createRect({x:_bdb.l,y:_bdb.t,width:w+1,height:h+1}).setStroke(_bdc);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_bdb),0;},0);fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);_bdc=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new _ba0(html.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _ba0(html.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){fill=_ba1.prototype._plotFill(fill,dim,_bdb);if(_bdb.l){rect={width:_bdb.l,height:dim.height+1};this.surface.createRect(rect).setFill(_ba1.prototype._shapeFill(fill,rect));}if(_bdb.r){rect={x:dim.width-_bdb.r,width:_bdb.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_ba1.prototype._shapeFill(fill,rect));}if(_bdb.t){rect={width:dim.width+1,height:_bdb.t};this.surface.createRect(rect).setFill(_ba1.prototype._shapeFill(fill,rect));}if(_bdb.b){rect={y:dim.height-_bdb.b,width:dim.width+1,height:_bdb.b+2};this.surface.createRect(rect).setFill(_ba1.prototype._shapeFill(fill,rect));}}if(_bdc){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_bdc);}if(this.title){var _bdd=(g.renderer=="canvas"),_bde=_bdd||!has("ie")&&!has("opera")?"html":"gfx",_bdf=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_ba4.createText[_bde](this,this.surface,dim.width/2,this.titlePos=="top"?_bdf+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_bdb);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_be0,_be1){return name in this.plots?this.stack[this.plots[name]].connect(_be0,_be1):null;},fireEvent:function(_be2,_be3,_be4){if(_be2 in this.runs){var _be5=this.series[this.runs[_be2]].plot;if(_be5 in this.plots){var plot=this.stack[this.plots[_be5]];if(plot){plot.fireEvent(_be2,_be3,_be4);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_baa);arr.forEach(this.stack,_baa);arr.forEach(this.series,_baa);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_bab);arr.forEach(this.stack,_bab);arr.forEach(this.series,_bab);this.dirty=true;},_invalidateDependentPlots:function(_be6,_be7){if(_be6 in this.plots){var plot=this.stack[this.plots[_be6]],axis,_be8=_be7?"vAxis":"hAxis";if(plot[_be8]){axis=this.axes[plot[_be8]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_be8]&&p[_be8]==plot[_be8]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function _be9(_bea){return {min:_bea.hmin,max:_bea.hmax};};function _beb(_bec){return {min:_bec.vmin,max:_bec.vmax};};function _bed(_bee,h){_bee.hmin=h.min;_bee.hmax=h.max;};function _bef(_bf0,v){_bf0.vmin=v.min;_bf0.vmax=v.max;};function _bf1(_bf2,_bf3){if(_bf2&&_bf3){_bf2.min=Math.min(_bf2.min,_bf3.min);_bf2.max=Math.max(_bf2.max,_bf3.max);}return _bf2||_bf3;};function _bd8(_bf4,_bf5){var _bf6={},axes={};arr.forEach(_bf4,function(plot){var _bf7=_bf6[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_bf1(axes[plot.hAxis],_be9(_bf7));}if(plot.vAxis){axes[plot.vAxis]=_bf1(axes[plot.vAxis],_beb(_bf7));}});arr.forEach(_bf4,function(plot){var _bf8=_bf6[plot.name];if(plot.hAxis){_bed(_bf8,axes[plot.hAxis]);}if(plot.vAxis){_bef(_bf8,axes[plot.vAxis]);}plot.initializeScalers(_bf5,_bf8);});};return dojox.charting.Chart;});},"dojox/charting/themes/PlotKit/blue":function(){define("dojox/charting/themes/PlotKit/blue",["./base","../../Theme"],function(pk,_bf9){pk.blue=pk.base.clone();pk.blue.chart.fill=pk.blue.plotarea.fill="#e7eef6";pk.blue.colors=_bf9.defineColors({hue:217,saturation:60,low:40,high:88});return pk.blue;});},"dijit/registry":function(){define("dijit/registry",["dojo/_base/array","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window","."],function(_bfa,has,_bfb,win,_bfc){var _bfd={},hash={};var _bfe={length:0,add:function(_bff){if(hash[_bff.id]){throw new Error("Tried to register widget with id=="+_bff.id+" but that id is already registered");}hash[_bff.id]=_bff;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_c00){var id;do{id=_c00+"_"+(_c00 in _bfd?++_bfd[_c00]:_bfd[_c00]=0);}while(hash[id]);return _bfc._scopeName=="dijit"?id:_bfc._scopeName+"_"+id;},findWidgets:function(root){var _c01=[];function _c02(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _c03=node.getAttribute("widgetId");if(_c03){var _c04=hash[_c03];if(_c04){_c01.push(_c04);}}else{_c02(node);}}}};_c02(root);return _c01;},_destroyAll:function(){_bfc._curFocus=null;_bfc._prevFocus=null;_bfc._activeStack=[];_bfa.forEach(_bfe.findWidgets(win.body()),function(_c05){if(!_c05._destroyed){if(_c05.destroyRecursive){_c05.destroyRecursive();}else{if(_c05.destroy){_c05.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.getAttribute&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};if(has("ie")){_bfb.addOnWindowUnload(function(){_bfe._destroyAll();});}_bfc.registry=_bfe;return _bfe;});},"url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='onclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeypress:_onTitleKeyPress'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon\" data-dojo-attach-point='iconNode' style=\"vertical-align: middle\" role=\"presentation\"/>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","dijit/_base/focus":function(){define("dijit/_base/focus",["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/topic","dojo/_base/window","../focus",".."],function(_c06,dom,lang,_c07,win,_c08,_c09){lang.mixin(_c09,{_curFocus:null,_prevFocus:null,isCollapsed:function(){return _c09.getBookmark().isCollapsed;},getBookmark:function(){var bm,rg,tg,sel=win.doc.selection,cf=_c08.curNode;if(win.global.getSelection){sel=win.global.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return {isCollapsed:(sel.end<=sel.start),mark:sel};}}bm={isCollapsed:true};if(sel.rangeCount){bm.mark=sel.getRangeAt(0).cloneRange();}}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else{if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return {isCollapsed:true,mark:null};}else{rg=sel.createRange();return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}if(sel.type.toUpperCase()=="CONTROL"){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}}return bm;},moveToBookmark:function(_c0a){var _c0b=win.doc,mark=_c0a.mark;if(mark){if(win.global.getSelection){var sel=win.global.getSelection();if(sel&&sel.removeAllRanges){if(mark.pRange){var n=mark.node;n.selectionStart=mark.start;n.selectionEnd=mark.end;}else{sel.removeAllRanges();sel.addRange(mark);}}else{console.warn("No idea how to restore selection for this browser!");}}else{if(_c0b.selection&&mark){var rg;if(mark.pRange){rg=mark.range;}else{if(lang.isArray(mark)){rg=_c0b.body.createControlRange();_c06.forEach(mark,function(n){rg.addElement(n);});}else{rg=_c0b.body.createTextRange();rg.moveToBookmark(mark);}}rg.select();}}}},getFocus:function(menu,_c0c){var node=!_c08.curNode||(menu&&dom.isDescendant(_c08.curNode,menu.domNode))?_c09._prevFocus:_c08.curNode;return {node:node,bookmark:node&&(node==_c08.curNode)&&win.withGlobal(_c0c||win.global,_c09.getBookmark),openedForWindow:_c0c};},_activeStack:[],registerIframe:function(_c0d){return _c08.registerIframe(_c0d);},unregisterIframe:function(_c0e){_c0e&&_c0e.remove();},registerWin:function(_c0f,_c10){return _c08.registerWin(_c0f,_c10);},unregisterWin:function(_c11){_c11&&_c11.remove();}});_c08.focus=function(_c12){if(!_c12){return;}var node="node" in _c12?_c12.node:_c12,_c13=_c12.bookmark,_c14=_c12.openedForWindow,_c15=_c13?_c13.isCollapsed:false;if(node){var _c16=(node.tagName.toLowerCase()=="iframe")?node.contentWindow:node;if(_c16&&_c16.focus){try{_c16.focus();}catch(e){}}_c08._onFocusNode(node);}if(_c13&&win.withGlobal(_c14||win.global,_c09.isCollapsed)&&!_c15){if(_c14){_c14.focus();}try{win.withGlobal(_c14||win.global,_c09.moveToBookmark,null,[_c13]);}catch(e2){}}};_c08.watch("curNode",function(name,_c17,_c18){_c09._curFocus=_c18;_c09._prevFocus=_c17;if(_c18){_c07.publish("focusNode",_c18);}});_c08.watch("activeStack",function(name,_c19,_c1a){_c09._activeStack=_c1a;});_c08.on("widget-blur",function(_c1b,by){_c07.publish("widgetBlur",_c1b,by);});_c08.on("widget-focus",function(_c1c,by){_c07.publish("widgetFocus",_c1c,by);});return _c09;});},"dijit/form/_FormMixin":function(){define("dijit/form/_FormMixin",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/window"],function(_c1d,_c1e,_c1f,lang,_c20){return _c1e("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_c21){var res=[];_c1d.forEach(_c21||this.getChildren(),function(_c22){if("value" in _c22){res.push(_c22);}else{res=res.concat(this._getDescendantFormWidgets(_c22.getChildren()));}},this);return res;},reset:function(){_c1d.forEach(this._getDescendantFormWidgets(),function(_c23){if(_c23.reset){_c23.reset();}});},validate:function(){var _c24=false;return _c1d.every(_c1d.map(this._getDescendantFormWidgets(),function(_c25){_c25._hasBeenBlurred=true;var _c26=_c25.disabled||!_c25.validate||_c25.validate();if(!_c26&&!_c24){_c20.scrollIntoView(_c25.containerNode||_c25.domNode);_c25.focus();_c24=true;}return _c26;}),function(item){return item;});},setValues:function(val){_c1f.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_c1d.forEach(this._getDescendantFormWidgets(),function(_c27){if(!_c27.name){return;}var _c28=map[_c27.name]||(map[_c27.name]=[]);_c28.push(_c27);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _c29=map[name],_c2a=lang.getObject(name,false,obj);if(_c2a===undefined){continue;}if(!lang.isArray(_c2a)){_c2a=[_c2a];}if(typeof _c29[0].checked=="boolean"){_c1d.forEach(_c29,function(w){w.set("value",_c1d.indexOf(_c2a,w.value)!=-1);});}else{if(_c29[0].multiple){_c29[0].set("value",_c2a);}else{_c1d.forEach(_c29,function(w,i){w.set("value",_c2a[i]);});}}}},getValues:function(){_c1f.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_c1d.forEach(this._getDescendantFormWidgets(),function(_c2b){var name=_c2b.name;if(!name||_c2b.disabled){return;}var _c2c=_c2b.get("value");if(typeof _c2b.checked=="boolean"){if(/Radio/.test(_c2b.declaredClass)){if(_c2c!==false){lang.setObject(name,_c2c,obj);}else{_c2c=lang.getObject(name,false,obj);if(_c2c===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_c2c!==false){ary.push(_c2c);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_c2c);}else{lang.setObject(name,[prev,_c2c],obj);}}else{lang.setObject(name,_c2c,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _c2d=_c1d.map(this._descendants,function(w){return w.get("state")||"";});return _c1d.indexOf(_c2d,"Error")>=0?"Error":_c1d.indexOf(_c2d,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){_c1d.forEach(this._childConnections||[],lang.hitch(this,"disconnect"));_c1d.forEach(this._childWatches||[],function(w){w.unwatch();});},connectChildren:function(_c2e){var _c2f=this;this.disconnectChildren();this._descendants=this._getDescendantFormWidgets();var set=_c2e?function(name,val){_c2f[name]=val;}:lang.hitch(this,"_set");set("value",this.get("value"));set("state",this._getState());var _c30=(this._childConnections=[]),_c31=(this._childWatches=[]);_c1d.forEach(_c1d.filter(this._descendants,function(item){return item.validate;}),function(_c32){_c1d.forEach(["state","disabled"],function(attr){_c31.push(_c32.watch(attr,function(){_c2f.set("state",_c2f._getState());}));});});var _c33=function(){if(_c2f._onChangeDelayTimer){clearTimeout(_c2f._onChangeDelayTimer);}_c2f._onChangeDelayTimer=setTimeout(function(){delete _c2f._onChangeDelayTimer;_c2f._set("value",_c2f.get("value"));},10);};_c1d.forEach(_c1d.filter(this._descendants,function(item){return item.onChange;}),function(_c34){_c30.push(_c2f.connect(_c34,"onChange",_c33));_c31.push(_c34.watch("disabled",_c33));});},startup:function(){this.inherited(arguments);this.connectChildren(true);this.watch("state",function(attr,_c35,_c36){this.onValidStateChange(_c36=="");});},destroy:function(){this.disconnectChildren();this.inherited(arguments);}});});},"dojox/charting/themes/MiamiNice":function(){define("dojox/charting/themes/MiamiNice",["../Theme","./common"],function(_c37,_c38){_c38.MiamiNice=new _c37({colors:["#7f9599","#45b8cc","#8ecfb0","#f8acac","#cc4482"]});return _c38.MiamiNice;});},"dijit/BackgroundIframe":function(){define("dijit/BackgroundIframe",["require",".","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window"],function(_c39,_c3a,_c3b,_c3c,_c3d,lang,on,has,win){var _c3e=new function(){var _c3f=[];this.pop=function(){var _c40;if(_c3f.length){_c40=_c3f.pop();_c40.style.display="";}else{if(has("ie")<9){var burl=_c3b["dojoBlankHtmlUrl"]||_c39.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_c40=win.doc.createElement(html);}else{_c40=_c3c.create("iframe");_c40.src="javascript:\"\"";_c40.className="dijitBackgroundIframe";_c40.setAttribute("role","presentation");_c3d.set(_c40,"opacity",0.1);}_c40.tabIndex=-1;}return _c40;};this.push=function(_c41){_c41.style.display="none";_c3f.push(_c41);};}();_c3a.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("ie")||has("mozilla")){var _c42=(this.iframe=_c3e.pop());node.appendChild(_c42);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,function(){this.resize(node);}));}else{_c3d.set(_c42,{width:"100%",height:"100%"});}}};lang.extend(_c3a.BackgroundIframe,{resize:function(node){if(this.iframe){_c3d.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_c3e.push(this.iframe);delete this.iframe;}}});return _c3a.BackgroundIframe;});},"dijit/layout/TabController":function(){require({cache:{"url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode\" data-dojo-attach-event='onclick:onClick'>\n    <div role=\"presentation\" class='dijitTabInnerDiv' data-dojo-attach-point='innerDiv'>\n        <div role=\"presentation\" class='dijitTabContent' data-dojo-attach-point='tabContent'>\n        \t<div role=\"presentation\" data-dojo-attach-point='focusNode'>\n\t\t        <img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitTabButtonIcon\" data-dojo-attach-point='iconNode' />\n\t\t        <span data-dojo-attach-point='containerNode' class='tabLabel'></span>\n\t\t        <span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t        \t\tdata-dojo-attach-event='onclick: onClickCloseButton' role=\"presentation\">\n\t\t            <span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t        ></span>\n\t\t\t</div>\n        </div>\n    </div>\n</div>\n"}});define("dijit/layout/TabController",["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/i18n","dojo/_base/lang","./StackController","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_c43,dom,_c44,_c45,i18n,lang,_c46,Menu,_c47,_c48){var _c49=_c43("dijit.layout._TabButton",_c46.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_c48,scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;setTimeout(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_c45.toggle(this.innerDiv,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _c4a=i18n.getLocalization("dijit","common");if(this.closeNode){_c44.set(this.closeNode,"title",_c4a.itemClose);}this._closeMenu=new Menu({id:this.id+"_Menu",dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode]});this._closeMenu.addChild(new _c47({label:_c4a.itemClose,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:lang.hitch(this,"onClickCloseButton")}));}else{if(this._closeMenu){this._closeMenu.destroyRecursive();delete this._closeMenu;}}},_setLabelAttr:function(_c4b){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}},destroy:function(){if(this._closeMenu){this._closeMenu.destroyRecursive();delete this._closeMenu;}this.inherited(arguments);}});var _c4c=_c43("dijit.layout.TabController",_c46,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'></div>",tabPosition:"top",buttonWidget:_c49,_rectifyRtlTabList:function(){if(0>=this.tabPosition.indexOf("-h")){return;}if(!this.pane2button){return;}var _c4d=0;for(var pane in this.pane2button){var ow=this.pane2button[pane].innerDiv.scrollWidth;_c4d=Math.max(_c4d,ow);}for(pane in this.pane2button){this.pane2button[pane].innerDiv.style.width=_c4d+"px";}}});_c4c.TabButton=_c49;return _c4c;});},"dijit/_MenuBase":function(){define("dijit/_MenuBase",["./popup","dojo/window","./_Widget","./_KeyNavContainer","./_TemplatedMixin","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/_base/array"],function(pm,_c4e,_c4f,_c50,_c51,_c52,dom,_c53,_c54,lang,_c55){return _c52("dijit._MenuBase",[_c4f,_c51,_c50],{parentMenu:null,popupDelay:500,onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.focusedChild._onClick(evt);}else{var _c56=this._getTopMenu();if(_c56&&_c56._isMenuBar){_c56.focusNext();}}},_onPopupHover:function(){if(this.currentPopup&&this.currentPopup._pendingClose_timer){var _c57=this.currentPopup.parentMenu;if(_c57.focusedChild){_c57.focusedChild._setSelected(false);}_c57.focusedChild=this.currentPopup.from_item;_c57.focusedChild._setSelected(true);this._stopPendingCloseTimer(this.currentPopup);}},onItemHover:function(item){if(this.isActive){this.focusChild(item);if(this.focusedChild.popup&&!this.focusedChild.disabled&&!this.hover_timer){this.hover_timer=setTimeout(lang.hitch(this,"_openPopup"),this.popupDelay);}}if(this.focusedChild){this.focusChild(item);}this._hoveredChild=item;},_onChildBlur:function(item){this._stopPopupTimer();item._setSelected(false);var _c58=item.popup;if(_c58){this._stopPendingCloseTimer(_c58);_c58._pendingClose_timer=setTimeout(function(){_c58._pendingClose_timer=null;if(_c58.parentMenu){_c58.parentMenu.currentPopup=null;}pm.close(_c58);},this.popupDelay);}},onItemUnhover:function(item){if(this.isActive){this._stopPopupTimer();}if(this._hoveredChild==item){this._hoveredChild=null;}},_stopPopupTimer:function(){if(this.hover_timer){clearTimeout(this.hover_timer);this.hover_timer=null;}},_stopPendingCloseTimer:function(_c59){if(_c59._pendingClose_timer){clearTimeout(_c59._pendingClose_timer);_c59._pendingClose_timer=null;}},_stopFocusTimer:function(){if(this._focus_timer){clearTimeout(this._focus_timer);this._focus_timer=null;}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(typeof this.isShowingNow=="undefined"){this._markActive();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this._openPopup();}else{this.onExecute();item.onClick(evt);}},_openPopup:function(){this._stopPopupTimer();var _c5a=this.focusedChild;if(!_c5a){return;}var _c5b=_c5a.popup;if(_c5b.isShowingNow){return;}if(this.currentPopup){this._stopPendingCloseTimer(this.currentPopup);pm.close(this.currentPopup);}_c5b.parentMenu=this;_c5b.from_item=_c5a;var self=this;pm.open({parent:this,popup:_c5b,around:_c5a.domNode,orient:this._orient||["after","before"],onCancel:function(){self.focusChild(_c5a);self._cleanUp();_c5a._setSelected(true);self.focusedChild=_c5a;},onExecute:lang.hitch(this,"_cleanUp")});this.currentPopup=_c5b;_c5b.connect(_c5b.domNode,"onmouseenter",lang.hitch(self,"_onPopupHover"));if(_c5b.focus){_c5b._focus_timer=setTimeout(lang.hitch(_c5b,function(){this._focus_timer=null;this.focus();}),0);}},_markActive:function(){this.isActive=true;_c54.replace(this.domNode,"dijitMenuActive","dijitMenuPassive");},onOpen:function(){this.isShowingNow=true;this._markActive();},_markInactive:function(){this.isActive=false;_c54.replace(this.domNode,"dijitMenuPassive","dijitMenuActive");},onClose:function(){this._stopFocusTimer();this._markInactive();this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopup){if(_c55.indexOf(this._focusManager.activeStack,this.id)>=0){_c53.set(this.focusedChild.focusNode,"tabIndex",this.tabIndex);this.focusedChild.focusNode.focus();}pm.close(this.currentPopup);this.currentPopup=null;}if(this.focusedChild){this.focusedChild._setSelected(false);this.focusedChild._onUnhover();this.focusedChild=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this._hoveredChild._onUnhover();}},_onBlur:function(){this._cleanUp();this.inherited(arguments);},_cleanUp:function(){this._closeChild();if(typeof this.isShowingNow=="undefined"){this._markInactive();}}});});},"dijit/_editor/_Plugin":function(){define("dijit/_editor/_Plugin",["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../form/Button"],function(_c5c,_c5d,lang,_c5e){var _c5f=_c5d("dijit._editor._Plugin",null,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._connects=[];this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_c5e,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var _c60=this.getLabel(this.command),_c61=this.editor,_c62=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var _c63=lang.mixin({label:_c60,dir:_c61.dir,lang:_c61.lang,showLabel:false,iconClass:_c62,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});this.button=new this.buttonClass(_c63);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){var h;while(h=this._connects.pop()){h.remove();}if(this.dropDown){this.dropDown.destroyRecursive();}},connect:function(o,f,tf){this._connects.push(_c5c.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_c64,_c65;if(!e||!e.isLoaded||!c.length){return;}var _c66=this.get("disabled");if(this.button){try{_c65=!_c66&&e.queryCommandEnabled(c);if(this.enabled!==_c65){this.enabled=_c65;this.button.set("disabled",!_c65);}if(typeof this.button.checked=="boolean"){_c64=e.queryCommandState(c);if(this.checked!==_c64){this.checked=_c64;this.button.set("checked",e.queryCommandState(c));}}}catch(e){}}},setEditor:function(_c67){this.editor=_c67;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.connect(this.button,"onClick",lang.hitch(this.editor,"execCommand",this.command,this.commandArg));}else{this.button.domNode.style.display="none";}}this.connect(this.editor,"onNormalizedDisplayChanged","updateState");},setToolbar:function(_c68){if(this.button){_c68.addChild(this.button);}},set:function(name,_c69){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _c6a=this._getAttrNames(name);if(this[_c6a.s]){var _c6b=this[_c6a.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,_c69);}return _c6b||this;},get:function(name){var _c6c=this._getAttrNames(name);return this[_c6c.g]?this[_c6c.g]():this[name];},_setDisabledAttr:function(_c6d){this.disabled=_c6d;this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,_c6e){this[name]=_c6e;}});_c5f.registry={};return _c5f;});},"dijit/layout/ScrollingTabController":function(){require({cache:{"url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_menuBtn\"\n\t\t\tdata-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t\tdata-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_leftBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_rightBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'\n\t\t\t\tdata-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"onclick:_onClick\">\n\t<div role=\"presentation\" class=\"dijitTabInnerDiv\" data-dojo-attach-point=\"innerDiv,focusNode\">\n\t\t<div role=\"presentation\" class=\"dijitTabContent dijitButtonContents\" data-dojo-attach-point=\"tabContent\">\n\t\t\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n\t\t</div>\n\t</div>\n</div>"}});define("dijit/layout/ScrollingTabController",["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/query","dojo/_base/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom"],function(_c6f,_c70,_c71,_c72,_c73,fx,lang,_c74,has,_c75,_c76,_c77,_c78,_c79,_c7a,Menu,_c7b,_c7c,_c7d){var _c7e=_c70("dijit.layout.ScrollingTabController",[_c78,_c7a],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_c76,useMenu:true,useSlider:true,tabStripClass:"",widgetsInTemplate:true,_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_c71.add(n,"tabStrip-disabled");}_c71.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_c73.set(this.domNode,"visibility","");this._postStartup=true;},onAddChild:function(page,_c7f){this.inherited(arguments);_c6f.forEach(["label","iconClass"],function(attr){this.pane2watches[page.id].push(this.pane2button[page.id].watch(attr,lang.hitch(this,function(){if(this._postStartup&&this._dim){this.resize(this._dim);}})));},this);_c73.set(this.containerNode,"width",(_c73.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(page,_c80){var _c81=this.pane2button[page.id];if(this._selectedTab===_c81.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_c74("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_c72.getMarginSize(btn).w;return true;}else{_c73.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _c82=this.getChildren();if(_c82.length){var _c83=_c82[this.isLeftToRight()?0:_c82.length-1].domNode,_c84=_c82[this.isLeftToRight()?_c82.length-1:0].domNode;return _c84.offsetLeft+_c73.get(_c84,"width")-_c83.offsetLeft;}else{return 0;}},_enableBtn:function(_c85){var _c86=this._getTabsWidth();_c85=_c85||_c73.get(this.scrollNode,"width");return _c86>0&&_c85<_c86;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_c79.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_c72.setContentSize(this.domNode,cb);var _c87=this._enableBtn(this._contentBox.w);this._buttons.style("display",_c87?"":"none");this._leftBtn.layoutAlign="left";this._rightBtn.layoutAlign="right";this._menuBtn.layoutAlign=this.isLeftToRight()?"right":"left";_c79.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,layoutAlign:"client"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_c73.get(this.containerNode,"width")-_c73.get(this.scrollNode,"width")+(has("ie")==8?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){return val;}else{var _c88=_c73.get(this.containerNode,"width")-_c73.get(this.scrollNode,"width");return (has("ie")==8?-1:1)*(val-_c88);}},onSelectChild:function(page){var tab=this.pane2button[page.id];if(!tab||!page){return;}var node=tab.domNode;if(node!=this._selectedTab){this._selectedTab=node;if(this._postResize){var sl=this._getScroll();if(sl>node.offsetLeft||sl+_c73.get(this.scrollNode,"width")<node.offsetLeft+_c73.get(node,"width")){this.createSmoothScroll().play();}}}this.inherited(arguments);},_getScrollBounds:function(){var _c89=this.getChildren(),_c8a=_c73.get(this.scrollNode,"width"),_c8b=_c73.get(this.containerNode,"width"),_c8c=_c8b-_c8a,_c8d=this._getTabsWidth();if(_c89.length&&_c8d>_c8a){return {min:this.isLeftToRight()?0:_c89[_c89.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_c89[_c89.length-1].domNode.offsetLeft+_c73.get(_c89[_c89.length-1].domNode,"width"))-_c8a:_c8c};}else{var _c8e=this.isLeftToRight()?0:_c8c;return {min:_c8e,max:_c8e};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_c8f=_c73.get(this.scrollNode,"width"),_c90=this._getScrollBounds();var pos=(n.offsetLeft+_c73.get(n,"width")/2)-_c8f/2;pos=Math.min(Math.max(pos,_c90.min),_c90.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _c91=this._getScrollBounds();x=Math.min(Math.max(x,_c91.min),_c91.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var self=this,w=this.scrollNode,anim=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var oldS=w.scrollLeft,newS=self._convertToScrollLeft(x);anim.curve=new fx._Line(oldS,newS);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=anim;this._setButtonClass(x);return anim;},_getBtnNode:function(e){var n=e.target;while(n&&!_c71.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_c92,node){if(node&&_c71.contains(node,"dijitTabDisabled")){return;}var _c93=_c73.get(this.scrollNode,"width");var d=(_c93*0.75)*_c92;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_c94){var _c95=this._getScrollBounds();this._leftBtn.set("disabled",_c94<=_c95.min);this._rightBtn.set("disabled",_c94>=_c95.max);}});var _c96=_c70("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_c77,tabIndex:"",isFocusable:function(){return false;}});_c70("dijit.layout._ScrollingTabControllerButton",[_c7c,_c96]);_c70("dijit.layout._ScrollingTabControllerMenuButton",[_c7c,_c7d,_c96],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_c97){this.dropDown=new Menu({id:this.containerId+"_menu",dir:this.dir,lang:this.lang,textDir:this.textDir});var _c98=_c75.byId(this.containerId);_c6f.forEach(_c98.getChildren(),function(page){var _c99=new _c7b({id:page.id+"_stcMi",label:page.title,iconClass:page.iconClass,dir:page.dir,lang:page.lang,textDir:page.textDir,onClick:function(){_c98.selectChild(page);}});this.dropDown.addChild(_c99);},this);_c97();},closeDropDown:function(_c9a){this.inherited(arguments);if(this.dropDown){this.dropDown.destroyRecursive();delete this.dropDown;}}});return _c7e;});},"dijit/form/_ListMouseMixin":function(){define("dijit/form/_ListMouseMixin",["dojo/_base/declare","dojo/_base/event","dojo/touch","./_ListBase"],function(_c9b,_c9c,_c9d,_c9e){return _c9b("dijit.form._ListMouseMixin",_c9e,{postCreate:function(){this.inherited(arguments);this.connect(this.domNode,_c9d.press,"_onMouseDown");this.connect(this.domNode,_c9d.release,"_onMouseUp");this.connect(this.domNode,"onmouseover","_onMouseOver");this.connect(this.domNode,"onmouseout","_onMouseOut");},_onMouseDown:function(evt){_c9c.stop(evt);if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(this._getTarget(evt));},_onMouseUp:function(evt){_c9c.stop(evt);this._isDragging=false;var _c9f=this._getSelectedAttr();var _ca0=this._getTarget(evt);var _ca1=this._hoveredNode;if(_c9f&&_ca0==_c9f){this.onClick(_c9f);}else{if(_ca1&&_ca0==_ca1){this._setSelectedAttr(_ca1);this.onClick(_ca1);}}},_onMouseOut:function(){if(this._hoveredNode){this.onUnhover(this._hoveredNode);if(this._getSelectedAttr()==this._hoveredNode){this.onSelect(this._hoveredNode);}this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}var node=this._getTarget(evt);if(!node){return;}if(this._hoveredNode!=node){if(this._hoveredNode){this._onMouseOut({target:this._hoveredNode});}if(node&&node.parentNode==this.containerNode){if(this._isDragging){this._setSelectedAttr(node);}else{this._hoveredNode=node;this.onHover(node);}}}}});});},"dojox/validate/_base":function(){define("dojox/validate/_base",["dojo/_base/lang","dojo/regexp","dojo/number","./regexp"],function(lang,_ca2,_ca3,_ca4){var _ca5=lang.getObject("dojox.validate",true);_ca5.isText=function(_ca6,_ca7){_ca7=(typeof _ca7=="object")?_ca7:{};if(/^\s*$/.test(_ca6)){return false;}if(typeof _ca7.length=="number"&&_ca7.length!=_ca6.length){return false;}if(typeof _ca7.minlength=="number"&&_ca7.minlength>_ca6.length){return false;}if(typeof _ca7.maxlength=="number"&&_ca7.maxlength<_ca6.length){return false;}return true;};_ca5._isInRangeCache={};_ca5.isInRange=function(_ca8,_ca9){_ca8=_ca3.parse(_ca8,_ca9);if(isNaN(_ca8)){return false;}_ca9=(typeof _ca9=="object")?_ca9:{};var max=(typeof _ca9.max=="number")?_ca9.max:Infinity,min=(typeof _ca9.min=="number")?_ca9.min:-Infinity,dec=(typeof _ca9.decimal=="string")?_ca9.decimal:".",_caa=_ca5._isInRangeCache,_cab=_ca8+"max"+max+"min"+min+"dec"+dec;if(typeof _caa[_cab]!="undefined"){return _caa[_cab];}_caa[_cab]=!(_ca8<min||_ca8>max);return _caa[_cab];};_ca5.isNumberFormat=function(_cac,_cad){var re=new RegExp("^"+_ca4.numberFormat(_cad)+"$","i");return re.test(_cac);};_ca5.isValidLuhn=function(_cae){var sum=0,_caf,_cb0;if(!lang.isString(_cae)){_cae=String(_cae);}_cae=_cae.replace(/[- ]/g,"");_caf=_cae.length%2;for(var i=0;i<_cae.length;i++){_cb0=parseInt(_cae.charAt(i));if(i%2==_caf){_cb0*=2;}if(_cb0>9){_cb0-=9;}sum+=_cb0;}return !(sum%10);};return _ca5;});},"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dojo/io-query":function(){define(["./_base/lang"],function(lang){var _cb1={};function _cb2(map){var enc=encodeURIComponent,_cb3=[];for(var name in map){var _cb4=map[name];if(_cb4!=_cb1[name]){var _cb5=enc(name)+"=";if(lang.isArray(_cb4)){for(var i=0,l=_cb4.length;i<l;++i){_cb3.push(_cb5+enc(_cb4[i]));}}else{_cb3.push(_cb5+enc(_cb4));}}}return _cb3.join("&");};function _cb6(str){var dec=decodeURIComponent,qp=str.split("&"),ret={},name,val;for(var i=0,l=qp.length,item;i<l;++i){item=qp[i];if(item.length){var s=item.indexOf("=");if(s<0){name=dec(item);val="";}else{name=dec(item.slice(0,s));val=dec(item.slice(s+1));}if(typeof ret[name]=="string"){ret[name]=[ret[name]];}if(lang.isArray(ret[name])){ret[name].push(val);}else{ret[name]=val;}}}return ret;};return {objectToQuery:_cb2,queryToObject:_cb6};});},"dojox/charting/plot2d/Bars":function(){define("dojox/charting/plot2d/Bars",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(dojo,lang,arr,_cb7,Base,dc,fx,du,df,dfr){var _cb8=dfr.lambda("item.purgeGroup()");return _cb7("dojox.charting.plot2d.Bars",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_cb9,_cba){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_cba);du.updateWithPattern(this.opt,_cba,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _cbb=dc.collectSimpleStats(this.series),t;_cbb.hmin-=0.5;_cbb.hmax+=0.5;t=_cbb.hmin,_cbb.hmin=_cbb.vmin,_cbb.vmin=t;t=_cbb.hmax,_cbb.hmax=_cbb.vmax,_cbb.vmax=t;return _cbb;},createRect:function(run,_cbc,_cbd){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_cbd);_cbc.add(rect);}else{rect=_cbc.createRect(_cbd);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_cbe){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_cbe);}this.dirty=this.isDirty();this.resetEvents();if(this.dirty){arr.forEach(this.series,_cb8);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_cbf,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_cc0=Math.max(0,this._hScaler.bounds.lower),_cc1=ht(_cc0),_cc2=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_cbf=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _cc3=t.next("bar",[this.opt,run]),s=run.group,_cc4=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _cc5=run.data[j];if(_cc5!==null){var v=typeof _cc5=="number"?_cc5:_cc5.y,hv=ht(v),_cc6=hv-_cc1,w=Math.abs(_cc6),_cc7=typeof _cc5!="number"?t.addMixin(_cc3,"bar",_cc5,true):t.post(_cc3,"bar");if(w>=0&&_cbf>=1){var rect={x:_cbe.l+(v<_cc0?hv:_cc1),y:dim.height-_cbe.b-vt(j+1.5)+gap,width:w,height:_cbf};var _cc8=this._plotFill(_cc7.series.fill,dim,_cbe);_cc8=this._shapeFill(_cc8,rect);var _cc9=this.createRect(run,s,rect).setFill(_cc8).setStroke(_cc7.series.stroke);run.dyn.fill=_cc9.getFill();run.dyn.stroke=_cc9.getStroke();if(_cc2){var o={element:"bar",index:j,run:run,shape:_cc9,x:v,y:j+1.5};this._connectEvents(o);_cc4[j]=o;}if(this.animate){this._animateBar(_cc9,_cbe.l+_cc1,-w);}}}}this._eventSeries[run.name]=_cc4;run.dirty=false;}this.dirty=false;return this;},_animateBar:function(_cca,_ccb,_ccc){fx.animateTransform(lang.delegate({shape:_cca,duration:1200,transform:[{name:"translate",start:[_ccb-(_ccb/_ccc),0],end:[0,0]},{name:"scale",start:[1/_ccc,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/tree/_dndSelector":function(){define("dijit/tree/_dndSelector",["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","dojo/_base/window","./_dndContainer"],function(_ccd,_cce,_ccf,lang,_cd0,on,_cd1,win,_cd2){return _ccf("dijit.tree._dndSelector",_cd2,{constructor:function(){this.selection={};this.anchor=null;this.tree.domNode.setAttribute("aria-multiselect",!this.singular);this.events.push(on(this.tree.domNode,_cd1.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_cd1.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_cd1.move,lang.hitch(this,"onMouseMove")));},singular:false,getSelectedTreeNodes:function(){var _cd3=[],sel=this.selection;for(var i in sel){_cd3.push(sel[i]);}return _cd3;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_cd4){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_cd4){this.anchor=node;}return node;},removeTreeNode:function(node){this.setSelection(this._setDifference(this.getSelectedTreeNodes(),[node]));return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_cd5){var _cd6=this.getSelectedTreeNodes();_ccd.forEach(this._setDifference(_cd6,_cd5),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_ccd.forEach(this._setDifference(_cd5,_cd6),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_ccd.forEach(ys,function(y){y.__exclude__=true;});var ret=_ccd.filter(xs,function(x){return !x.__exclude__;});_ccd.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _cd7=this.getSelectedTreeNodes();var _cd8=[],_cd9=[];_ccd.forEach(_cd7,function(node){_cd9.push(node);_cd8.push(node.getTreePath());});var _cda=_ccd.map(_cd9,function(node){return node.item;});this.tree._set("paths",_cd8);this.tree._set("path",_cd8[0]||[]);this.tree._set("selectedNodes",_cd9);this.tree._set("selectedNode",_cd9[0]||null);this.tree._set("selectedItems",_cda);this.tree._set("selectedItem",_cda[0]||null);},onMouseDown:function(e){if(!this.current||this.tree.isExpandoNode(e.target,this.current)){return;}if(!_cd0.isLeft(e)){return;}e.preventDefault();var _cdb=this.current,copy=_cce.isCopyKey(e),id=_cdb.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_cdb,copy,e.shiftKey);},onMouseUp:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(this.current,_cce.isCopyKey(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_cdc,_cdd){if(this.singular){if(this.anchor==node&&_cdc){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_cdd&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_cde,end,_cdf=this.anchor;if(cr<0){_cde=_cdf;end=node;}else{_cde=node;end=_cdf;}var _ce0=[];while(_cde!=end){_ce0.push(_cde);_cde=this.tree._getNextNode(_cde);}_ce0.push(end);this.setSelection(_ce0);}else{if(this.selection[node.id]&&_cdc){this.removeTreeNode(node);}else{if(_cdc){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _ce1=this.selection[key];return {data:_ce1,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||win.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dojo/cldr/monetary":function(){define(["../main"],function(dojo){dojo.getObject("cldr.monetary",true,dojo);dojo.cldr.monetary.getData=function(code){var _ce2={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _ce3={CHF:5};var _ce4=_ce2[code],_ce5=_ce3[code];if(typeof _ce4=="undefined"){_ce4=2;}if(typeof _ce5=="undefined"){_ce5=0;}return {places:_ce4,round:_ce5};};return dojo.cldr.monetary;});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(on,_ce6,keys,_ce7,has,_ce8,win){var _ce9=null;if(has("ie")){(function(){var _cea=function(evt){_ce9=evt.srcElement;};win.doc.attachEvent("onkeydown",_cea);_ce8.addOnWindowUnload(function(){win.doc.detachEvent("onkeydown",_cea);});})();}else{win.doc.addEventListener("keydown",function(evt){_ce9=evt.target;},true);}var _ceb=function(node,_cec){if(/input|button/i.test(node.nodeName)){return on(node,"click",_cec);}else{function _ced(e){return (e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;};var _cee=[on(node,"keypress",function(e){if(_ced(e)){_ce9=e.target;e.preventDefault();}}),on(node,"keyup",function(e){if(_ced(e)&&e.target==_ce9){_ce9=null;_cec.call(this,e);}}),on(node,"click",function(e){_cec.call(this,e);})];return {remove:function(){_ce6.forEach(_cee,function(h){h.remove();});}};}};return _ce7("dijit._OnDijitClickMixin",null,{connect:function(obj,_cef,_cf0){return this.inherited(arguments,[obj,_cef=="ondijitclick"?_ceb:_cef,_cf0]);}});});},"dijit/form/VerticalRuleLabels":function(){define("dijit/form/VerticalRuleLabels",["dojo/_base/declare","./HorizontalRuleLabels"],function(_cf1,_cf2){return _cf1("dijit.form.VerticalRuleLabels",_cf2,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){return 100-pos;},_isHorizontal:false});});},"dojox/charting/plot2d/Candlesticks":function(){define("dojox/charting/plot2d/Candlesticks",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_cf3,arr,Base,dc,df,dfr,du,fx){var _cf4=dfr.lambda("item.purgeGroup()");return _cf3("dojox.charting.plot2d.Candlesticks",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_cf5,_cf6){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_cf6);du.updateWithPattern(this.opt,_cf6,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_cf7){var _cf8=lang.delegate(dc.defaultStats);for(var i=0;i<_cf7.length;i++){var run=_cf7[i];if(!run.data.length){continue;}var _cf9=_cf8.vmin,_cfa=_cf8.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_cf8.hmin=Math.min(_cf8.hmin,x);_cf8.hmax=Math.max(_cf8.hmax,x);_cf8.vmin=Math.min(_cf8.vmin,val.open,val.close,val.high,val.low);_cf8.vmax=Math.max(_cf8.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_cf8.vmin=Math.min(_cf9,run.ymin);}if("ymax" in run){_cf8.vmax=Math.max(_cfa,run.ymax);}}return _cf8;},getSeriesStats:function(){var _cfb=this.collectStats(this.series);_cfb.hmin-=0.5;_cfb.hmax+=0.5;return _cfb;},render:function(dim,_cfc){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_cfc);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_cf4);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_cfd,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_cfe=Math.max(0,this._vScaler.bounds.lower),_cff=vt(_cfe),_d00=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_cfd=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _d01=t.next("candlestick",[this.opt,run]),s=run.group,_d02=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _d03=t.addMixin(_d01,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_cfc.l+gap,y=dim.height-_cfc.b,open=vt(v.open),_d04=vt(v.close),high=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>high){var tmp=high;high=low;low=tmp;}if(_cfd>=1){var _d05=open>_d04;var line={x1:_cfd/2,x2:_cfd/2,y1:y-high,y2:y-low},rect={x:0,y:y-Math.max(open,_d04),width:_cfd,height:Math.max(_d05?open-_d04:_d04-open,1)};var _d06=s.createGroup();_d06.setTransform({dx:x,dy:0});var _d07=_d06.createGroup();_d07.createLine(line).setStroke(_d03.series.stroke);_d07.createRect(rect).setStroke(_d03.series.stroke).setFill(_d05?_d03.series.fill:"white");if("mid" in v){_d07.createLine({x1:(_d03.series.stroke.width||1),x2:_cfd-(_d03.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_d05?"white":_d03.series.stroke);}run.dyn.fill=_d03.series.fill;run.dyn.stroke=_d03.series.stroke;if(_d00){var o={element:"candlestick",index:j,run:run,shape:_d07,x:x,y:y-Math.max(open,_d04),cx:_cfd/2,cy:(y-Math.max(open,_d04))+(Math.max(_d05?open-_d04:_d04-open,1)/2),width:_cfd,height:Math.max(_d05?open-_d04:_d04-open,1),data:v};this._connectEvents(o);_d02[j]=o;}}if(this.animate){this._animateCandlesticks(_d06,y-low,high-low);}}}this._eventSeries[run.name]=_d02;run.dirty=false;}this.dirty=false;return this;},_animateCandlesticks:function(_d08,_d09,_d0a){fx.animateTransform(lang.delegate({shape:_d08,duration:1200,transform:[{name:"translate",start:[0,_d09-(_d09/_d0a)],end:[0,0]},{name:"scale",start:[1,1/_d0a],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/OHLC":function(){define("dojox/charting/plot2d/OHLC",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_d0b,Base,dc,df,dfr,du,fx){var _d0c=dfr.lambda("item.purgeGroup()");return _d0b("dojox.charting.plot2d.OHLC",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_d0d,_d0e){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_d0e);du.updateWithPattern(this.opt,_d0e,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_d0f){var _d10=lang.delegate(dc.defaultStats);for(var i=0;i<_d0f.length;i++){var run=_d0f[i];if(!run.data.length){continue;}var _d11=_d10.vmin,_d12=_d10.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_d10.hmin=Math.min(_d10.hmin,x);_d10.hmax=Math.max(_d10.hmax,x);_d10.vmin=Math.min(_d10.vmin,val.open,val.close,val.high,val.low);_d10.vmax=Math.max(_d10.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_d10.vmin=Math.min(_d11,run.ymin);}if("ymax" in run){_d10.vmax=Math.max(_d12,run.ymax);}}return _d10;},getSeriesStats:function(){var _d13=this.collectStats(this.series);_d13.hmin-=0.5;_d13.hmax+=0.5;return _d13;},render:function(dim,_d14){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_d14);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_d0c);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_d15,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_d16=Math.max(0,this._vScaler.bounds.lower),_d17=vt(_d16),_d18=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_d15=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _d19=t.next("candlestick",[this.opt,run]),s=run.group,_d1a=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _d1b=t.addMixin(_d19,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_d14.l+gap,y=dim.height-_d14.b,open=vt(v.open),_d1c=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_d15>=1){var hl={x1:_d15/2,x2:_d15/2,y1:y-high,y2:y-low},op={x1:0,x2:((_d15/2)+((_d1b.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_d15/2)-((_d1b.series.stroke.width||1)/2)),x2:_d15,y1:y-_d1c,y2:y-_d1c};var _d1d=s.createGroup();_d1d.setTransform({dx:x,dy:0});var _d1e=_d1d.createGroup();_d1e.createLine(hl).setStroke(_d1b.series.stroke);_d1e.createLine(op).setStroke(_d1b.series.stroke);_d1e.createLine(cl).setStroke(_d1b.series.stroke);run.dyn.stroke=_d1b.series.stroke;if(_d18){var o={element:"candlestick",index:j,run:run,shape:_d1e,x:x,y:y-Math.max(open,_d1c),cx:_d15/2,cy:(y-Math.max(open,_d1c))+(Math.max(open>_d1c?open-_d1c:_d1c-open,1)/2),width:_d15,height:Math.max(open>_d1c?open-_d1c:_d1c-open,1),data:v};this._connectEvents(o);_d1a[j]=o;}}if(this.animate){this._animateOHLC(_d1d,y-low,high-low);}}}this._eventSeries[run.name]=_d1a;run.dirty=false;}this.dirty=false;return this;},_animateOHLC:function(_d1f,_d20,_d21){fx.animateTransform(lang.delegate({shape:_d1f,duration:1200,transform:[{name:"translate",start:[0,_d20-(_d20/_d21)],end:[0,0]},{name:"scale",start:[1,1/_d21],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","dijit/layout/StackController":function(){define("dijit/layout/StackController",["dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/_base/sniff","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/i18n!../nls/common"],function(_d22,_d23,_d24,keys,lang,has,_d25,_d26,_d27,_d28,_d29,_d2a){var _d2b=_d23("dijit.layout._StackButton",_d2a,{tabIndex:"-1",closeButton:false,_setCheckedAttr:function(_d2c,_d2d){this.inherited(arguments);this.focusNode.removeAttribute("aria-pressed");},buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");},onClick:function(){_d25.focus(this.focusNode);},onClickCloseButton:function(evt){evt.stopPropagation();}});var _d2e=_d23("dijit.layout.StackController",[_d27,_d28,_d29],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeypress'></span>",containerId:"",buttonWidget:_d2b,constructor:function(){this.pane2button={};this.pane2connects={};this.pane2watches={};},postCreate:function(){this.inherited(arguments);this.subscribe(this.containerId+"-startup","onStartup");this.subscribe(this.containerId+"-addChild","onAddChild");this.subscribe(this.containerId+"-removeChild","onRemoveChild");this.subscribe(this.containerId+"-selectChild","onSelectChild");this.subscribe(this.containerId+"-containerKeyPress","onContainerKeyPress");},onStartup:function(info){_d22.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}},destroy:function(){for(var pane in this.pane2button){this.onRemoveChild(_d26.byId(pane));}this.inherited(arguments);},onAddChild:function(page,_d2f){var cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _d30=new cls({id:this.id+"_"+page.id,label:page.title,dir:page.dir,lang:page.lang,textDir:page.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip});_d30.focusNode.setAttribute("aria-selected","false");var _d31=["title","showTitle","iconClass","closable","tooltip"],_d32=["label","showLabel","iconClass","closeButton","title"];this.pane2watches[page.id]=_d22.map(_d31,function(_d33,idx){return page.watch(_d33,function(name,_d34,_d35){_d30.set(_d32[idx],_d35);});});this.pane2connects[page.id]=[this.connect(_d30,"onClick",lang.hitch(this,"onButtonClick",page)),this.connect(_d30,"onClickCloseButton",lang.hitch(this,"onCloseButtonClick",page))];this.addChild(_d30,_d2f);this.pane2button[page.id]=_d30;page.controlButton=_d30;if(!this._currentChild){_d30.focusNode.setAttribute("tabIndex","0");_d30.focusNode.setAttribute("aria-selected","true");this._currentChild=page;}if(!this.isLeftToRight()&&has("ie")&&this._rectifyRtlTabList){this._rectifyRtlTabList();}},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}_d22.forEach(this.pane2connects[page.id],lang.hitch(this,"disconnect"));delete this.pane2connects[page.id];_d22.forEach(this.pane2watches[page.id],function(w){w.unwatch();});delete this.pane2watches[page.id];var _d36=this.pane2button[page.id];if(_d36){this.removeChild(_d36);delete this.pane2button[page.id];_d36.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _d37=this.pane2button[this._currentChild.id];_d37.set("checked",false);_d37.focusNode.setAttribute("aria-selected","false");_d37.focusNode.setAttribute("tabIndex","-1");}var _d38=this.pane2button[page.id];_d38.set("checked",true);_d38.focusNode.setAttribute("aria-selected","true");this._currentChild=page;_d38.focusNode.setAttribute("tabIndex","0");var _d39=_d26.byId(this.containerId);_d39.containerNode.setAttribute("aria-labelledby",_d38.id);},onButtonClick:function(page){if(this._currentChild.id===page.id){var _d3a=this.pane2button[page.id];_d3a.set("checked",true);}var _d3b=_d26.byId(this.containerId);_d3b.selectChild(page);},onCloseButtonClick:function(page){var _d3c=_d26.byId(this.containerId);_d3c.closeChild(page);if(this._currentChild){var b=this.pane2button[this._currentChild.id];if(b){_d25.focus(b.focusNode||b.domNode);}}},adjacent:function(_d3d){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_d3d=!_d3d;}var _d3e=this.getChildren();var _d3f=_d22.indexOf(_d3e,this.pane2button[this._currentChild.id]);var _d40=_d3d?1:_d3e.length-1;return _d3e[(_d3f+_d40)%_d3e.length];},onkeypress:function(e){if(this.disabled||e.altKey){return;}var _d41=null;if(e.ctrlKey||!e._djpage){switch(e.charOrCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_d41=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_d41=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_d41=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_d41=true;}break;case keys.HOME:case keys.END:var _d42=this.getChildren();if(_d42&&_d42.length){_d42[e.charOrCode==keys.HOME?0:_d42.length-1].onClick();}_d24.stop(e);break;case keys.DELETE:if(this._currentChild.closable){this.onCloseButtonClick(this._currentChild);}_d24.stop(e);break;default:if(e.ctrlKey){if(e.charOrCode===keys.TAB){this.adjacent(!e.shiftKey).onClick();_d24.stop(e);}else{if(e.charOrCode=="w"){if(this._currentChild.closable){this.onCloseButtonClick(this._currentChild);}_d24.stop(e);}}}}if(_d41!==null){this.adjacent(_d41).onClick();_d24.stop(e);}}},onContainerKeyPress:function(info){info.e._djpage=info.page;this.onkeypress(info.e);}});_d2e.StackButton=_d2b;return _d2e;});},"dijit/form/DateTextBox":function(){define("dijit/form/DateTextBox",["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_d43,_d44,_d45){return _d43("dijit.form.DateTextBox",_d45,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_d44,_selector:"date",value:new Date("")});});},"dojox/color/_base":function(){define("dojox/color/_base",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(dojo,_d46,lang,_d47,_d48){var cx=lang.getObject("dojox.color",true);cx.Color=_d47;cx.blend=_d47.blendColors;cx.fromRgb=_d47.fromRgb;cx.fromHex=_d47.fromHex;cx.fromArray=_d47.fromArray;cx.fromString=_d47.fromString;cx.greyscale=_d48.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_d49,_d4a){if(lang.isArray(cyan)){_d49=cyan[1],_d4a=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_d49=cyan.m,_d4a=cyan.y,cyan=cyan.c;}}cyan/=100,_d49/=100,_d4a/=100;var r=1-cyan,g=1-_d49,b=1-_d4a;return new _d47({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_d4b,_d4c,_d4d){if(lang.isArray(cyan)){_d4b=cyan[1],_d4c=cyan[2],_d4d=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_d4b=cyan.m,_d4c=cyan.y,_d4d=cyan.b,cyan=cyan.c;}}cyan/=100,_d4b/=100,_d4c/=100,_d4d/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_d4d)+_d4d);g=1-Math.min(1,_d4b*(1-_d4d)+_d4d);b=1-Math.min(1,_d4c*(1-_d4d)+_d4d);return new _d47({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_d4e,_d4f){if(lang.isArray(hue)){_d4e=hue[1],_d4f=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_d4e=hue.s,_d4f=hue.l,hue=hue.h;}}_d4e/=100;_d4f/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_d4e*Math.min(r,1)+(1-_d4e);g=2*_d4e*Math.min(g,1)+(1-_d4e);b=2*_d4e*Math.min(b,1)+(1-_d4e);if(_d4f<0.5){r*=_d4f,g*=_d4f,b*=_d4f;}else{r=(1-_d4f)*r+2*_d4f-1;g=(1-_d4f)*g+2*_d4f-1;b=(1-_d4f)*b+2*_d4f-1;}return new _d47({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_d50,_d51){if(lang.isArray(hue)){_d50=hue[1],_d51=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_d50=hue.s,_d51=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_d50/=100;_d51/=100;var r,g,b;if(_d50==0){r=_d51,b=_d51,g=_d51;}else{var _d52=hue/60,i=Math.floor(_d52),f=_d52-i;var p=_d51*(1-_d50);var q=_d51*(1-(_d50*f));var t=_d51*(1-(_d50*(1-f)));switch(i){case 0:r=_d51,g=t,b=p;break;case 1:r=q,g=_d51,b=p;break;case 2:r=p,g=_d51,b=t;break;case 3:r=p,g=q,b=_d51;break;case 4:r=t,g=p,b=_d51;break;case 5:r=_d51,g=p,b=q;break;}}return new _d47({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_d47,{toCmy:function(){var cyan=1-(this.r/255),_d53=1-(this.g/255),_d54=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_d53*100),y:Math.round(_d54*100)};},toCmyk:function(){var cyan,_d55,_d56,_d57;var r=this.r/255,g=this.g/255,b=this.b/255;_d57=Math.min(1-r,1-g,1-b);cyan=(1-r-_d57)/(1-_d57);_d55=(1-g-_d57)/(1-_d57);_d56=(1-b-_d57)/(1-_d57);return {c:Math.round(cyan*100),m:Math.round(_d55*100),y:Math.round(_d56*100),b:Math.round(_d57*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _d58=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_d58/((l<0.5)?(2*l):(2-2*l));}if(_d58>0){if(max==r&&max!=g){h+=(g-b)/_d58;}if(max==g&&max!=b){h+=(2+(b-r)/_d58);}if(max==b&&max!=r){h+=(4+(r-g)/_d58);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _d59=max-min;var h=null,s=(max==0)?0:(_d59/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_d59;}else{if(g==max){h=120+60*(b-r)/_d59;}else{h=240+60*(r-g)/_d59;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/themes/PlotKit/orange":function(){define("dojox/charting/themes/PlotKit/orange",["./base","../../Theme"],function(pk,_d5a){pk.orange=pk.base.clone();pk.orange.chart.fill=pk.orange.plotarea.fill="#f5eee6";pk.orange.colors=_d5a.defineColors({hue:31,saturation:60,low:40,high:88});return pk.orange;});},"dojox/charting/plot2d/Base":function(){define("dojox/charting/plot2d/Base",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","../Element","./_PlotEvents","dojo/_base/array","../scaler/primitive","./common","dojox/gfx/fx"],function(lang,_d5b,hub,_d5c,_d5d,arr,_d5e,_d5f,fx){return _d5b("dojox.charting.plot2d.Base",[_d5c,_d5d],{constructor:function(_d60,_d61){this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_d62){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_d63){var r={};r.x=th(_d63[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_d63[av.name]);return r;};return _d62?t(_d62):t;},toData:function(_d64){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_d65){var r={};r[ah.name]=th(_d65.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_d65.y-o.b);return r;};return _d64?t(_d64):t;},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _d5f.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},performZoom:function(dim,_d66){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_d67=dim.height-_d66.b,_d68=this._hScaler.bounds,_d69=(_d68.from-_d68.lower)*_d68.scale,_d6a=this._vScaler.bounds,_d6b=(_d6a.from-_d6a.lower)*_d6a.scale,_d6c=vs/this.lastWindow.vscale,_d6d=hs/this.lastWindow.hscale,_d6e=(this.lastWindow.xoffset-_d69)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_d6f=(_d6b-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_d70=this.group,anim=fx.animateTransform(lang.delegate({shape:_d70,duration:1200,transform:[{name:"translate",start:[0,0],end:[_d66.l*(1-_d6d),_d67*(1-_d6c)]},{name:"scale",start:[1,1],end:[_d6d,_d6c]},{name:"original"},{name:"translate",start:[0,0],end:[_d6e,_d6f]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_d69,yoffset:_d6b});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},render:function(dim,_d71){return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_d72){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_d72.hmin,_d72.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_d5e.buildScaler(_d72.hmin,_d72.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_d72.vmin,_d72.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_d5e.buildScaler(_d72.vmin,_d72.vmax,dim.height);}return this;}});});},"dojo/dom-geometry":function(){define(["./_base/sniff","./_base/window","./dom","./dom-style"],function(has,win,dom,_d73){var geom={};geom.boxModel="content-box";if(has("ie")){geom.boxModel=document.compatMode=="BackCompat"?"border-box":"content-box";}geom.getPadExtents=function getPadExtents(node,_d74){node=dom.byId(node);var s=_d74||_d73.getComputedStyle(node),px=_d73.toPixelValue,l=px(node,s.paddingLeft),t=px(node,s.paddingTop),r=px(node,s.paddingRight),b=px(node,s.paddingBottom);return {l:l,t:t,r:r,b:b,w:l+r,h:t+b};};var none="none";geom.getBorderExtents=function getBorderExtents(node,_d75){node=dom.byId(node);var px=_d73.toPixelValue,s=_d75||_d73.getComputedStyle(node),l=s.borderLeftStyle!=none?px(node,s.borderLeftWidth):0,t=s.borderTopStyle!=none?px(node,s.borderTopWidth):0,r=s.borderRightStyle!=none?px(node,s.borderRightWidth):0,b=s.borderBottomStyle!=none?px(node,s.borderBottomWidth):0;return {l:l,t:t,r:r,b:b,w:l+r,h:t+b};};geom.getPadBorderExtents=function getPadBorderExtents(node,_d76){node=dom.byId(node);var s=_d76||_d73.getComputedStyle(node),p=geom.getPadExtents(node,s),b=geom.getBorderExtents(node,s);return {l:p.l+b.l,t:p.t+b.t,r:p.r+b.r,b:p.b+b.b,w:p.w+b.w,h:p.h+b.h};};geom.getMarginExtents=function getMarginExtents(node,_d77){node=dom.byId(node);var s=_d77||_d73.getComputedStyle(node),px=_d73.toPixelValue,l=px(node,s.marginLeft),t=px(node,s.marginTop),r=px(node,s.marginRight),b=px(node,s.marginBottom);if(has("webkit")&&(s.position!="absolute")){r=l;}return {l:l,t:t,r:r,b:b,w:l+r,h:t+b};};geom.getMarginBox=function getMarginBox(node,_d78){node=dom.byId(node);var s=_d78||_d73.getComputedStyle(node),me=geom.getMarginExtents(node,s),l=node.offsetLeft-me.l,t=node.offsetTop-me.t,p=node.parentNode,px=_d73.toPixelValue,pcs;if(has("mozilla")){var sl=parseFloat(s.left),st=parseFloat(s.top);if(!isNaN(sl)&&!isNaN(st)){l=sl,t=st;}else{if(p&&p.style){pcs=_d73.getComputedStyle(p);if(pcs.overflow!="visible"){l+=pcs.borderLeftStyle!=none?px(node,pcs.borderLeftWidth):0;t+=pcs.borderTopStyle!=none?px(node,pcs.borderTopWidth):0;}}}}else{if(has("opera")||(has("ie")==8&&!has("quirks"))){if(p){pcs=_d73.getComputedStyle(p);l-=pcs.borderLeftStyle!=none?px(node,pcs.borderLeftWidth):0;t-=pcs.borderTopStyle!=none?px(node,pcs.borderTopWidth):0;}}}return {l:l,t:t,w:node.offsetWidth+me.w,h:node.offsetHeight+me.h};};geom.getContentBox=function getContentBox(node,_d79){node=dom.byId(node);var s=_d79||_d73.getComputedStyle(node),w=node.clientWidth,h,pe=geom.getPadExtents(node,s),be=geom.getBorderExtents(node,s);if(!w){w=node.offsetWidth;h=node.offsetHeight;}else{h=node.clientHeight;be.w=be.h=0;}if(has("opera")){pe.l+=be.l;pe.t+=be.t;}return {l:pe.l,t:pe.t,w:w-pe.w-be.w,h:h-pe.h-be.h};};function _d7a(node,l,t,w,h,u){u=u||"px";var s=node.style;if(!isNaN(l)){s.left=l+u;}if(!isNaN(t)){s.top=t+u;}if(w>=0){s.width=w+u;}if(h>=0){s.height=h+u;}};function _d7b(node){return node.tagName.toLowerCase()=="button"||node.tagName.toLowerCase()=="input"&&(node.getAttribute("type")||"").toLowerCase()=="button";};function _d7c(node){return geom.boxModel=="border-box"||node.tagName.toLowerCase()=="table"||_d7b(node);};geom.setContentSize=function setContentSize(node,box,_d7d){node=dom.byId(node);var w=box.w,h=box.h;if(_d7c(node)){var pb=geom.getPadBorderExtents(node,_d7d);if(w>=0){w+=pb.w;}if(h>=0){h+=pb.h;}}_d7a(node,NaN,NaN,w,h);};var _d7e={l:0,t:0,w:0,h:0};geom.setMarginBox=function setMarginBox(node,box,_d7f){node=dom.byId(node);var s=_d7f||_d73.getComputedStyle(node),w=box.w,h=box.h,pb=_d7c(node)?_d7e:geom.getPadBorderExtents(node,s),mb=geom.getMarginExtents(node,s);if(has("webkit")){if(_d7b(node)){var ns=node.style;if(w>=0&&!ns.width){ns.width="4px";}if(h>=0&&!ns.height){ns.height="4px";}}}if(w>=0){w=Math.max(w-pb.w-mb.w,0);}if(h>=0){h=Math.max(h-pb.h-mb.h,0);}_d7a(node,box.l,box.t,w,h);};geom.isBodyLtr=function isBodyLtr(){return (win.body().dir||win.doc.documentElement.dir||"ltr").toLowerCase()=="ltr";};geom.docScroll=function docScroll(){var node=win.doc.parentWindow||win.doc.defaultView;return "pageXOffset" in node?{x:node.pageXOffset,y:node.pageYOffset}:(node=has("quirks")?win.body():win.doc.documentElement,{x:geom.fixIeBiDiScrollLeft(node.scrollLeft||0),y:node.scrollTop||0});};geom.getIeDocumentElementOffset=function getIeDocumentElementOffset(){var de=win.doc.documentElement;if(has("ie")<8){var r=de.getBoundingClientRect(),l=r.left,t=r.top;if(has("ie")<7){l+=de.clientLeft;t+=de.clientTop;}return {x:l<0?0:l,y:t<0?0:t};}else{return {x:0,y:0};}};geom.fixIeBiDiScrollLeft=function fixIeBiDiScrollLeft(_d80){var ie=has("ie");if(ie&&!geom.isBodyLtr()){var qk=has("quirks"),de=qk?win.body():win.doc.documentElement;if(ie==6&&!qk&&win.global.frameElement&&de.scrollHeight>de.clientHeight){_d80+=de.clientLeft;}return (ie<8||qk)?(_d80+de.clientWidth-de.scrollWidth):-_d80;}return _d80;};geom.position=function(node,_d81){node=dom.byId(node);var db=win.body(),dh=db.parentNode,ret=node.getBoundingClientRect();ret={x:ret.left,y:ret.top,w:ret.right-ret.left,h:ret.bottom-ret.top};if(has("ie")){var _d82=geom.getIeDocumentElementOffset();ret.x-=_d82.x+(has("quirks")?db.clientLeft+db.offsetLeft:0);ret.y-=_d82.y+(has("quirks")?db.clientTop+db.offsetTop:0);}else{if(has("ff")==3){var cs=_d73.getComputedStyle(dh),px=_d73.toPixelValue;ret.x-=px(dh,cs.marginLeft)+px(dh,cs.borderLeftWidth);ret.y-=px(dh,cs.marginTop)+px(dh,cs.borderTopWidth);}}if(_d81){var _d83=geom.docScroll();ret.x+=_d83.x;ret.y+=_d83.y;}return ret;};geom.getMarginSize=function getMarginSize(node,_d84){node=dom.byId(node);var me=geom.getMarginExtents(node,_d84||_d73.getComputedStyle(node));var size=node.getBoundingClientRect();return {w:(size.right-size.left)+me.w,h:(size.bottom-size.top)+me.h};};geom.normalizeEvent=function(_d85){if(!("layerX" in _d85)){_d85.layerX=_d85.offsetX;_d85.layerY=_d85.offsetY;}if(!has("dom-addeventlistener")){var se=_d85.target;var doc=(se&&se.ownerDocument)||document;var _d86=has("quirks")?doc.body:doc.documentElement;var _d87=geom.getIeDocumentElementOffset();_d85.pageX=_d85.clientX+geom.fixIeBiDiScrollLeft(_d86.scrollLeft||0)-_d87.x;_d85.pageY=_d85.clientY+(_d86.scrollTop||0)-_d87.y;}};return geom;});},"dijit/form/_FormValueMixin":function(){define("dijit/form/_FormValueMixin",["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/sniff","./_FormWidgetMixin"],function(_d88,_d89,keys,has,_d8a){return _d88("dijit.form._FormValueMixin",_d8a,{readOnly:false,_setReadOnlyAttr:function(_d8b){_d89.set(this.focusNode,"readOnly",_d8b);this.focusNode.setAttribute("aria-readonly",_d8b);this._set("readOnly",_d8b);},postCreate:function(){this.inherited(arguments);if(has("ie")){this.connect(this.focusNode||this.domNode,"onkeydown",this._onKeyDown);}if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.value;}},_setValueAttr:function(_d8c,_d8d){this._handleOnChange(_d8c,_d8d);},_handleOnChange:function(_d8e,_d8f){this._set("value",_d8e);this.inherited(arguments);},undo:function(){this._setValueAttr(this._lastValueReported,false);},reset:function(){this._hasBeenBlurred=false;this._setValueAttr(this._resetValue,true);},_onKeyDown:function(e){if(e.keyCode==keys.ESCAPE&&!(e.ctrlKey||e.altKey||e.metaKey)){var te;if(has("ie")<9||(has("ie")&&has("quirks"))){e.preventDefault();te=document.createEventObject();te.keyCode=keys.ESCAPE;te.shiftKey=e.shiftKey;e.srcElement.fireEvent("onkeypress",te);}}}});});},"dojox/lang/functional/fold":function(){define("dojox/lang/functional/fold",["dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(lang,arr,win,df){var _d90={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _d90)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _d91=true;for(i in a){if(!(i in _d90)){if(_d91){z=a[i];_d91=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||win.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojo/date/stamp":function(){define(["../_base/kernel","../_base/lang","../_base/array"],function(dojo,lang,_d92){lang.getObject("date.stamp",true,dojo);dojo.date.stamp.fromISOString=function(_d93,_d94){if(!dojo.date.stamp._isoRegExp){dojo.date.stamp._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _d95=dojo.date.stamp._isoRegExp.exec(_d93),_d96=null;if(_d95){_d95.shift();if(_d95[1]){_d95[1]--;}if(_d95[6]){_d95[6]*=1000;}if(_d94){_d94=new Date(_d94);_d92.forEach(_d92.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _d94["get"+prop]();}),function(_d97,_d98){_d95[_d98]=_d95[_d98]||_d97;});}_d96=new Date(_d95[0]||1970,_d95[1]||0,_d95[2]||1,_d95[3]||0,_d95[4]||0,_d95[5]||0,_d95[6]||0);if(_d95[0]<100){_d96.setFullYear(_d95[0]||1970);}var _d99=0,_d9a=_d95[7]&&_d95[7].charAt(0);if(_d9a!="Z"){_d99=((_d95[8]||0)*60)+(Number(_d95[9])||0);if(_d9a!="-"){_d99*=-1;}}if(_d9a){_d99-=_d96.getTimezoneOffset();}if(_d99){_d96.setTime(_d96.getTime()+_d99*60000);}}return _d96;};dojo.date.stamp.toISOString=function(_d9b,_d9c){var _d9d=function(n){return (n<10)?"0"+n:n;};_d9c=_d9c||{};var _d9e=[],_d9f=_d9c.zulu?"getUTC":"get",date="";if(_d9c.selector!="time"){var year=_d9b[_d9f+"FullYear"]();date=["0000".substr((year+"").length)+year,_d9d(_d9b[_d9f+"Month"]()+1),_d9d(_d9b[_d9f+"Date"]())].join("-");}_d9e.push(date);if(_d9c.selector!="date"){var time=[_d9d(_d9b[_d9f+"Hours"]()),_d9d(_d9b[_d9f+"Minutes"]()),_d9d(_d9b[_d9f+"Seconds"]())].join(":");var _da0=_d9b[_d9f+"Milliseconds"]();if(_d9c.milliseconds){time+="."+(_da0<100?"0":"")+_d9d(_da0);}if(_d9c.zulu){time+="Z";}else{if(_d9c.selector!="time"){var _da1=_d9b.getTimezoneOffset();var _da2=Math.abs(_da1);time+=(_da1>0?"-":"+")+_d9d(Math.floor(_da2/60))+":"+_d9d(_da2%60);}}_d9e.push(time);}return _d9e.join("T");};return dojo.date.stamp;});},"dijit/layout/AccordionPane":function(){define("dijit/layout/AccordionPane",["dojo/_base/declare","dojo/_base/kernel","./ContentPane"],function(_da3,_da4,_da5){return _da3("dijit.layout.AccordionPane",_da5,{constructor:function(){_da4.deprecated("dijit.layout.AccordionPane deprecated, use ContentPane instead","","2.0");},onSelected:function(){}});});},"dijit/form/_AutoCompleterMixin":function(){define("dijit/form/_AutoCompleterMixin",["dojo/_base/connect","dojo/data/util/filter","dojo/_base/declare","dojo/_base/Deferred","dojo/dom-attr","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/_base/sniff","dojo/string","dojo/_base/window","./DataList","../registry","./_TextBoxMixin"],function(_da6,_da7,_da8,_da9,_daa,_dab,keys,lang,_dac,_dad,has,_dae,win,_daf,_db0,_db1){return _da8("dijit.form._AutoCompleterMixin",null,{item:null,pageSize:Infinity,store:null,fetchProperties:{},query:{},autoComplete:true,highlightMatch:"first",searchDelay:100,searchAttr:"name",labelAttr:"",labelType:"text",queryExpr:"${0}*",ignoreCase:true,maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_db2){var pos=0;if(typeof (_db2.selectionStart)=="number"){pos=_db2.selectionStart;}else{if(has("ie")){var tr=win.doc.selection.createRange().duplicate();var ntr=_db2.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_db3,_db4){_db4=parseInt(_db4);_db1.selectInputText(_db3,_db4,_db4);},_setDisabledAttr:function(_db5){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_db5);},_abortQuery:function(){if(this.searchTimer){clearTimeout(this.searchTimer);this.searchTimer=null;}if(this._fetchHandle){if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_onInput:function(evt){this.inherited(arguments);if(evt.charOrCode==229){this._onKey(evt);}},_onKey:function(evt){var key=evt.charOrCode;if(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT){return;}var _db6=false;var pw=this.dropDown;var _db7=null;this._prev_key_backspace=false;this._abortQuery();this.inherited(arguments);if(this._opened){_db7=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_db7);}_dab.stop(evt);break;case keys.ENTER:if(_db7){if(_db7==pw.nextButton){this._nextSearch(1);_dab.stop(evt);break;}else{if(_db7==pw.previousButton){this._nextSearch(-1);_dab.stop(evt);break;}}}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}if(this._opened||this._fetchHandle){_dab.stop(evt);}case keys.TAB:var _db8=this.get("displayedValue");if(pw&&(_db8==pw._messages["previousMessage"]||_db8==pw._messages["nextMessage"])){break;}if(_db7){this._selectOption(_db7);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;case " ":if(_db7){_dab.stop(evt);this._selectOption(_db7);this.closeDropDown();}else{_db6=true;}break;case keys.DELETE:case keys.BACKSPACE:this._prev_key_backspace=true;_db6=true;break;default:_db6=typeof key=="string"||key==229;}if(_db6){this.item=undefined;this.searchTimer=setTimeout(lang.hitch(this,"_startSearchFromInput"),1);}},_autoCompleteText:function(text){var fn=this.focusNode;_db1.selectInputText(fn,fn.value.length);var _db9=this.ignoreCase?"toLowerCase":"substr";if(text[_db9](0).indexOf(this.focusNode.value[_db9](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_db1.selectInputText(fn,cpos);}}else{fn.value=text;_db1.selectInputText(fn);}},_openResultList:function(_dba,_dbb,_dbc){this._fetchHandle=null;if(this.disabled||this.readOnly||(_dbb[this.searchAttr]!==this._lastQuery)){return;}var _dbd=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_dba.length&&_dbc.start==0){this.closeDropDown();return;}var _dbe=this.dropDown.createOptions(_dba,_dbc,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if(_dbc.direction){if(1==_dbc.direction){this.dropDown.highlightFirstOption();}else{if(-1==_dbc.direction){this.dropDown.highlightLastOption();}}if(_dbd){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_dbb[this.searchAttr].toString())){this._announceOption(_dbe[1]);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");this.focusNode.removeAttribute("aria-activedescendant");}},_setBlurValue:function(){var _dbf=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_dbf==pw._messages["previousMessage"]||_dbf==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_dbf);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}},_setItemAttr:function(item,_dc0,_dc1){var _dc2="";if(item){if(!_dc1){_dc1=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_dc2=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_dc1;}this.set("value",_dc2,_dc0,_dc1,item);},_announceOption:function(node){if(!node){return;}var _dc3;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_dc3=node.innerHTML;this.item=undefined;this.value="";}else{_dc3=(this.store._oldAPI?this.store.getValue(node.item,this.searchAttr):node.item[this.searchAttr]).toString();this.set("item",node.item,false,_dc3);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_daa.get(node,"id"));this._autoCompleteText(_dc3);},_selectOption:function(_dc4){this.closeDropDown();if(_dc4){this._announceOption(_dc4);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g,"\\$1"));},_getQueryString:function(text){return _dae.substitute(this.queryExpr,[text]);},_startSearch:function(key){if(!this.dropDown){var _dc5=this.id+"_popup",_dc6=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _dc6({onChange:lang.hitch(this,this._selectOption),id:_dc5,dir:this.dir,textDir:this.textDir});this.focusNode.removeAttribute("aria-activedescendant");this.textbox.setAttribute("aria-owns",_dc5);}this._lastInput=key;var _dc7=lang.clone(this.query);var _dc8={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}};lang.mixin(_dc8,this.fetchProperties);var qs=this._getQueryString(key),q;if(this.store._oldAPI){q=qs;}else{q=_da7.patternToRegExp(qs,this.ignoreCase);q.toString=function(){return qs;};}this._lastQuery=_dc7[this.searchAttr]=q;var _dc9=this,_dca=function(){var _dcb=_dc9._fetchHandle=_dc9.store.query(_dc7,_dc8);_da9.when(_dcb,function(res){_dc9._fetchHandle=null;res.total=_dcb.total;_dc9._openResultList(res,_dc7,_dc8);},function(err){_dc9._fetchHandle=null;if(!_dc9._cancelingQuery){console.error(_dc9.declaredClass+" "+err.toString());_dc9.closeDropDown();}});};this.searchTimer=setTimeout(lang.hitch(this,function(_dcc,_dcd){this.searchTimer=null;_dca();this._nextSearch=this.dropDown.onPage=function(_dce){_dc8.start+=_dc8.count*_dce;_dc8.direction=_dce;_dca();_dcd.focus();};},_dc7,this),this.searchDelay);},_getValueField:function(){return this.searchAttr;},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var _dcf=this.srcNodeRef;var list=this.list;if(list){this.store=_db0.byId(list);}else{this.store=new _daf({},_dcf);}if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _dd0=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_dd0):item[_dd0];}}}this.inherited(arguments);},postCreate:function(){var _dd1=_dac("label[for=\""+this.id+"\"]");if(_dd1.length){_dd1[0].id=(this.id+"_label");this.domNode.setAttribute("aria-labelledby",_dd1[0].id);}this.inherited(arguments);},_getMenuLabelFromItem:function(item){var _dd2=this.labelFunc(item,this.store),_dd3=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_dd2=this.doHighlight(_dd2,this._escapeHtml(this._lastInput));_dd3="html";}return {html:_dd3=="html",label:_dd2};},doHighlight:function(_dd4,find){var _dd5=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_dad.escapeString(find);return this._escapeHtml(_dd4).replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_dd5),"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_dd6){return (_dd6._oldAPI?_dd6.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_dd7,_dd8,_dd9,item){this._set("item",item||null);if(!_dd7){_dd7="";}this.inherited(arguments);},_setTextDirAttr:function(_dda){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_dda);}}});});},"dijit/TitlePane":function(){require({cache:{"url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"onclick:_onTitleClick, onkeypress:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"arrowNode\" class=\"dijitArrowNode\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n"}});define("dijit/TitlePane",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/event","dojo/fx","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager"],function(_ddb,_ddc,dom,_ddd,_dde,_ddf,_de0,_de1,_de2,keys,_de3,_de4,_de5,_de6,_de7){return _ddc("dijit.TitlePane",[_de5,_de4,_de3],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_de7.defaultDuration,baseClass:"dijitTitlePane",templateString:_de6,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.titleNode,false);},postCreate:function(){this.inherited(arguments);if(this.toggleable){this._trackMouseState(this.titleBarNode,"dijitTitlePaneTitle");}var _de8=this.hideNode,_de9=this.wipeNode;this._wipeIn=_de1.wipeIn({node:_de9,duration:this.duration,beforeBegin:function(){_de8.style.display="";}});this._wipeOut=_de1.wipeOut({node:_de9,duration:this.duration,onEnd:function(){_de8.style.display="none";}});},_setOpenAttr:function(open,_dea){_ddb.forEach([this._wipeIn,this._wipeOut],function(_deb){if(_deb&&_deb.status()=="playing"){_deb.stop();}});if(_dea){var anim=this[open?"_wipeIn":"_wipeOut"];anim.play();}else{this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";}if(this._started){if(open){this._onShow();}else{this.onHide();}}this.arrowNodeInner.innerHTML=open?"-":"+";this.containerNode.setAttribute("aria-hidden",open?"false":"true");this.focusNode.setAttribute("aria-pressed",open?"true":"false");this._set("open",open);this._setCss();},_setToggleableAttr:function(_dec){this.focusNode.setAttribute("role",_dec?"button":"heading");if(_dec){this.focusNode.setAttribute("aria-controls",this.id+"_pane");_ddd.set(this.focusNode,"tabIndex",this.tabIndex);}else{_ddd.remove(this.focusNode,"tabIndex");}this._set("toggleable",_dec);this._setCss();},_setContentAttr:function(_ded){if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){this.inherited(arguments);}else{if(this._wipeIn&&this._wipeIn.status()=="playing"){this._wipeIn.stop();}_ddf.setMarginBox(this.wipeNode,{h:_ddf.getMarginBox(this.wipeNode).h});this.inherited(arguments);if(this._wipeIn){this._wipeIn.play();}else{this.hideNode.style.display="";}}},toggle:function(){this._setOpenAttr(!this.open,true);},_setCss:function(){var node=this.titleBarNode||this.focusNode;var _dee=this._titleBarClass;this._titleBarClass="dijit"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");_dde.replace(node,this._titleBarClass,_dee||"");this.arrowNodeInner.innerHTML=this.open?"-":"+";},_onTitleKey:function(e){if(e.charOrCode==keys.ENTER||e.charOrCode==" "){if(this.toggleable){this.toggle();}_de0.stop(e);}else{if(e.charOrCode==keys.DOWN_ARROW&&this.open){this.containerNode.focus();e.preventDefault();}}},_onTitleClick:function(){if(this.toggleable){this.toggle();}},setTitle:function(_def){_de2.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");this.set("title",_def);}});});},"dojo/dnd/Container":function(){define(["../main","../Evented","./common","../parser"],function(dojo,_df0){dojo.declare("dojo.dnd.Container",_df0,{skipForm:false,constructor:function(node,_df1){this.node=dojo.byId(node);if(!_df1){_df1={};}this.creator=_df1.creator||null;this.skipForm=_df1.skipForm;this.parent=_df1.dropParent&&dojo.byId(_df1.dropParent);this.map={};this.current=null;this.containerState="";dojo.addClass(this.node,"dojoDndContainer");if(!(_df1&&_df1._skipStartup)){this.startup();}this.events=[dojo.connect(this.node,"onmouseover",this,"onMouseOver"),dojo.connect(this.node,"onmouseout",this,"onMouseOut"),dojo.connect(this.node,"ondragstart",this,"onSelectStart"),dojo.connect(this.node,"onselectstart",this,"onSelectStart")];},creator:function(){},getItem:function(key){return this.map[key];},setItem:function(key,data){this.map[key]=data;},delItem:function(key){delete this.map[key];},forInItems:function(f,o){o=o||dojo.global;var m=this.map,e=dojo.dnd._empty;for(var i in m){if(i in e){continue;}f.call(o,m[i],i,this);}return o;},clearItems:function(){this.map={};},getAllNodes:function(){return dojo.query("> .dojoDndItem",this.parent);},sync:function(){var map={};this.getAllNodes().forEach(function(node){if(node.id){var item=this.getItem(node.id);if(item){map[node.id]=item;return;}}else{node.id=dojo.dnd.getUniqueId();}var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};},this);this.map=map;return this;},insertNodes:function(data,_df2,_df3){if(!this.parent.firstChild){_df3=null;}else{if(_df2){if(!_df3){_df3=this.parent.firstChild;}}else{if(_df3){_df3=_df3.nextSibling;}}}if(_df3){for(var i=0;i<data.length;++i){var t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});this.parent.insertBefore(t.node,_df3);}}else{for(var i=0;i<data.length;++i){var t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});this.parent.appendChild(t.node);}}return this;},destroy:function(){dojo.forEach(this.events,dojo.disconnect);this.clearItems();this.node=this.parent=this.current=null;},markupFactory:function(_df4,node,ctor){_df4._skipStartup=true;return new ctor(node,_df4);},startup:function(){if(!this.parent){this.parent=this.node;if(this.parent.tagName.toLowerCase()=="table"){var c=this.parent.getElementsByTagName("tbody");if(c&&c.length){this.parent=c[0];}}}this.defaultCreator=dojo.dnd._defaultCreator(this.parent);this.sync();},onMouseOver:function(e){var n=e.relatedTarget;while(n){if(n==this.node){break;}try{n=n.parentNode;}catch(x){n=null;}}if(!n){this._changeState("Container","Over");this.onOverEvent();}n=this._getChildByEvent(e);if(this.current==n){return;}if(this.current){this._removeItemClass(this.current,"Over");}if(n){this._addItemClass(n,"Over");}this.current=n;},onMouseOut:function(e){for(var n=e.relatedTarget;n;){if(n==this.node){return;}try{n=n.parentNode;}catch(x){n=null;}}if(this.current){this._removeItemClass(this.current,"Over");this.current=null;}this._changeState("Container","");this.onOutEvent();},onSelectStart:function(e){if(!this.skipForm||!dojo.dnd.isFormElement(e)){dojo.stopEvent(e);}},onOverEvent:function(){},onOutEvent:function(){},_changeState:function(type,_df5){var _df6="dojoDnd"+type;var _df7=type.toLowerCase()+"State";dojo.replaceClass(this.node,_df6+_df5,_df6+this[_df7]);this[_df7]=_df5;},_addItemClass:function(node,type){dojo.addClass(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){dojo.removeClass(node,"dojoDndItem"+type);},_getChildByEvent:function(e){var node=e.target;if(node){for(var _df8=node.parentNode;_df8;node=_df8,_df8=node.parentNode){if(_df8==this.parent&&dojo.hasClass(node,"dojoDndItem")){return node;}}}return null;},_normalizedCreator:function(item,hint){var t=(this.creator||this.defaultCreator).call(this,item,hint);if(!dojo.isArray(t.type)){t.type=["text"];}if(!t.node.id){t.node.id=dojo.dnd.getUniqueId();}dojo.addClass(t.node,"dojoDndItem");return t;}});dojo.dnd._createNode=function(tag){if(!tag){return dojo.dnd._createSpan;}return function(text){return dojo.create(tag,{innerHTML:text});};};dojo.dnd._createTrTd=function(text){var tr=dojo.create("tr");dojo.create("td",{innerHTML:text},tr);return tr;};dojo.dnd._createSpan=function(text){return dojo.create("span",{innerHTML:text});};dojo.dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};dojo.dnd._defaultCreator=function(node){var tag=node.tagName.toLowerCase();var c=tag=="tbody"||tag=="thead"?dojo.dnd._createTrTd:dojo.dnd._createNode(dojo.dnd._defaultCreatorNodes[tag]);return function(item,hint){var _df9=item&&dojo.isObject(item),data,type,n;if(_df9&&item.tagName&&item.nodeType&&item.getAttribute){data=item.getAttribute("dndData")||item.innerHTML;type=item.getAttribute("dndType");type=type?type.split(/\s*,\s*/):["text"];n=item;}else{data=(_df9&&item.data)?item.data:item;type=(_df9&&item.type)?item.type:["text"];n=(hint=="avatar"?dojo.dnd._createSpan:c)(String(data));}if(!n.id){n.id=dojo.dnd.getUniqueId();}return {node:n,data:data,type:type};};};return dojo.dnd.Container;});},"dijit/form/CurrencyTextBox":function(){define("dijit/form/CurrencyTextBox",["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_dfa,_dfb,lang,_dfc){return _dfb("dijit.form.CurrencyTextBox",_dfc,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",regExpGen:function(_dfd){return "("+(this.focused?this.inherited(arguments,[lang.mixin({},_dfd,this.editOptions)])+"|":"")+_dfa.regexp(_dfd)+")";},_formatter:_dfa.format,_parser:_dfa.parse,parse:function(_dfe,_dff){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(_dfe)){v=lang.hitch(lang.mixin({},this,{_parser:_dfc.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_e00){if(!_e00.currency&&this.currency){_e00.currency=this.currency;}this.inherited(arguments,[_dfa._mixInDefaults(lang.mixin(_e00,{exponent:false}))]);}});});},"dijit/place":function(){define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","."],function(_e01,_e02,_e03,_e04,win,_e05,_e06){function _e07(node,_e08,_e09,_e0a){var view=_e05.getBox();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body().appendChild(node);}var best=null;_e01.some(_e08,function(_e0b){var _e0c=_e0b.corner;var pos=_e0b.pos;var _e0d=0;var _e0e={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_e0c.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_e0c.charAt(0)]};if(_e09){var res=_e09(node,_e0b.aroundCorner,_e0c,_e0e,_e0a);_e0d=typeof res=="undefined"?0:res;}var _e0f=node.style;var _e10=_e0f.display;var _e11=_e0f.visibility;if(_e0f.display=="none"){_e0f.visibility="hidden";_e0f.display="";}var mb=_e02.getMarginBox(node);_e0f.display=_e10;_e0f.visibility=_e11;var _e12={"L":pos.x,"R":pos.x-mb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(mb.w>>1))-mb.w)}[_e0c.charAt(1)],_e13={"T":pos.y,"B":pos.y-mb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(mb.h>>1))-mb.h)}[_e0c.charAt(0)],_e14=Math.max(view.l,_e12),_e15=Math.max(view.t,_e13),endX=Math.min(view.l+view.w,_e12+mb.w),endY=Math.min(view.t+view.h,_e13+mb.h),_e16=endX-_e14,_e17=endY-_e15;_e0d+=(mb.w-_e16)+(mb.h-_e17);if(best==null||_e0d<best.overflow){best={corner:_e0c,aroundCorner:_e0b.aroundCorner,x:_e14,y:_e15,w:_e16,h:_e17,overflow:_e0d,spaceAvailable:_e0e};}return !_e0d;});if(best.overflow&&_e09){_e09(node,best.aroundCorner,best.corner,best.spaceAvailable,_e0a);}var l=_e02.isBodyLtr(),s=node.style;s.top=best.y+"px";s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";s[l?"right":"left"]="auto";return best;};return (_e06.place={at:function(node,pos,_e18,_e19){var _e1a=_e01.map(_e18,function(_e1b){var c={corner:_e1b,pos:{x:pos.x,y:pos.y}};if(_e19){c.pos.x+=_e1b.charAt(1)=="L"?_e19.x:-_e19.x;c.pos.y+=_e1b.charAt(0)=="T"?_e19.y:-_e19.y;}return c;});return _e07(node,_e1a);},around:function(node,_e1c,_e1d,_e1e,_e1f){var _e20=(typeof _e1c=="string"||"offsetWidth" in _e1c)?_e02.position(_e1c,true):_e1c;if(_e1c.parentNode){var _e21=_e1c.parentNode;while(_e21&&_e21.nodeType==1&&_e21.nodeName!="BODY"){var _e22=_e02.position(_e21,true);var _e23=_e03.getComputedStyle(_e21).overflow;if(_e23=="hidden"||_e23=="auto"||_e23=="scroll"){var _e24=Math.min(_e20.y+_e20.h,_e22.y+_e22.h);var _e25=Math.min(_e20.x+_e20.w,_e22.x+_e22.w);_e20.x=Math.max(_e20.x,_e22.x);_e20.y=Math.max(_e20.y,_e22.y);_e20.h=_e24-_e20.y;_e20.w=_e25-_e20.x;}_e21=_e21.parentNode;}}var x=_e20.x,y=_e20.y,_e26="w" in _e20?_e20.w:(_e20.w=_e20.width),_e27="h" in _e20?_e20.h:(_e04.deprecated("place.around: dijit.place.__Rectangle: { x:"+x+", y:"+y+", height:"+_e20.height+", width:"+_e26+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_e20.height+", w:"+_e26+" }","","2.0"),_e20.h=_e20.height);var _e28=[];function push(_e29,_e2a){_e28.push({aroundCorner:_e29,corner:_e2a,pos:{x:{"L":x,"R":x+_e26,"M":x+(_e26>>1)}[_e29.charAt(1)],y:{"T":y,"B":y+_e27,"M":y+(_e27>>1)}[_e29.charAt(0)]}});};_e01.forEach(_e1d,function(pos){var ltr=_e1e;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after":ltr=!ltr;case "before":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _e2b=_e07(node,_e28,_e1f,{w:_e26,h:_e27});_e2b.aroundNodePos=_e20;return _e2b;}});});},"dijit/form/ComboBox":function(){define("dijit/form/ComboBox",["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_e2c,_e2d,_e2e){return _e2c("dijit.form.ComboBox",[_e2d,_e2e],{});});},"dijit/layout/_LayoutWidget":function(){define("dijit/layout/_LayoutWidget",["dojo/_base/lang","../_Widget","../_Container","../_Contained","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/sniff","dojo/_base/window"],function(lang,_e2f,_e30,_e31,_e32,_e33,_e34,_e35,has,win){return _e32("dijit.layout._LayoutWidget",[_e2f,_e30,_e31],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,buildRendering:function(){this.inherited(arguments);_e33.add(this.domNode,"dijitContainer");},startup:function(){if(this._started){return;}this.inherited(arguments);var _e36=this.getParent&&this.getParent();if(!(_e36&&_e36.isLayoutContainer)){this.resize();this.connect(win.global,"onresize",function(){this.resize();});}},resize:function(_e37,_e38){var node=this.domNode;if(_e37){_e34.setMarginBox(node,_e37);}var mb=_e38||{};lang.mixin(mb,_e37||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_e34.getMarginBox(node),mb);}var cs=_e35.getComputedStyle(node);var me=_e34.getMarginExtents(node,cs);var be=_e34.getBorderExtents(node,cs);var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});var pe=_e34.getPadExtents(node,cs);this._contentBox={l:_e35.toPixelValue(node,cs.paddingLeft),t:_e35.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};this.layout();},layout:function(){},_setupChild:function(_e39){var cls=this.baseClass+"-child "+(_e39.baseClass?this.baseClass+"-"+_e39.baseClass:"");_e33.add(_e39.domNode,cls);},addChild:function(_e3a,_e3b){this.inherited(arguments);if(this._started){this._setupChild(_e3a);}},removeChild:function(_e3c){var cls=this.baseClass+"-child"+(_e3c.baseClass?" "+this.baseClass+"-"+_e3c.baseClass:"");_e33.remove(_e3c.domNode,cls);this.inherited(arguments);}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_e3d,_e3e){var _e3f=lang.getObject("dojo.colors",true);var _e40=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_e3d.fromRgb=function(_e41,obj){var m=_e41.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_e3e.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _e3d.fromArray(a,obj);}return _e3d.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_e40(m1,m2,H+1/3)*256,_e40(m1,m2,H)*256,_e40(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _e3d.fromArray(a,obj);}}return null;};var _e42=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_e3d.prototype.sanitize=function(){var t=this;t.r=Math.round(_e42(t.r,0,255));t.g=Math.round(_e42(t.g,0,255));t.b=Math.round(_e42(t.b,0,255));t.a=_e42(t.a,0,1);return this;};_e3f.makeGrey=_e3d.makeGrey=function(g,a){return _e3d.fromArray([g,g,g,a]);};lang.mixin(_e3d.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _e3d;});},"dojox/grid/cells/_base":function(){define("dojox/grid/cells/_base",["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_e43,lang,_e44,_e45,_e46,has,dom,_e47,_e48,_e49,util){var _e4a=_e43("dojox.grid._DeferredTextWidget",_e49,{deferred:null,_destroyOnRemove:true,postCreate:function(){if(this.deferred){this.deferred.addBoth(lang.hitch(this,function(text){if(this.domNode){this.domNode.innerHTML=text;}}));}}});var _e4b=function(_e4c){try{util.fire(_e4c,"focus");util.fire(_e4c,"select");}catch(e){}};var _e4d=function(){setTimeout(lang.hitch.apply(dojo,arguments),0);};var _e4e=_e43("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_e4f){this._props=_e4f||{};lang.mixin(this,_e4f);if(this.draggable===undefined){this.draggable=true;}},_defaultFormat:function(_e50,_e51){var s=this.grid.formatterScope||this;var f=this.formatter;if(f&&s&&typeof f=="string"){f=this.formatter=s[f];}var v=(_e50!=this.defaultValue&&f)?f.apply(s,_e51):_e50;if(typeof v=="undefined"){return this.defaultValue;}if(v&&v.addBoth){v=new _e4a({deferred:v},_e48.create("span",{innerHTML:this.defaultValue}));}if(v&&v.declaredClass&&v.startup){return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";}return v;},format:function(_e52,_e53){var f,i=this.grid.edit.info,d=this.get?this.get(_e52,_e53):(this.value||this.defaultValue);d=(d&&d.replace&&this.grid.escapeHTMLInData)?d.replace(/&/g,"&amp;").replace(/</g,"&lt;"):d;if(this.editable&&(this.alwaysEditing||(i.rowIndex==_e52&&i.cell==this))){return this.formatEditing(d,_e52);}else{return this._defaultFormat(d,[d,_e52,this]);}},formatEditing:function(_e54,_e55){},getNode:function(_e56){return this.view.getCellNode(_e56,this.index);},getHeaderNode:function(){return this.view.getHeaderCellNode(this.index);},getEditNode:function(_e57){return (this.getNode(_e57)||0).firstChild||0;},canResize:function(){var uw=this.unitWidth;return uw&&(uw!=="auto");},isFlex:function(){var uw=this.unitWidth;return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");},applyEdit:function(_e58,_e59){this.grid.edit.applyCellEdit(_e58,this,_e59);},cancelEdit:function(_e5a){this.grid.doCancelEdit(_e5a);},_onEditBlur:function(_e5b){if(this.grid.edit.isEditCell(_e5b,this.index)){this.grid.edit.apply();}},registerOnBlur:function(_e5c,_e5d){if(this.commitOnBlur){_e45.connect(_e5c,"onblur",function(e){setTimeout(lang.hitch(this,"_onEditBlur",_e5d),250);});}},needFormatNode:function(_e5e,_e5f){this._formatPending=true;_e4d(this,"_formatNode",_e5e,_e5f);},cancelFormatNode:function(){this._formatPending=false;},_formatNode:function(_e60,_e61){if(this._formatPending){this._formatPending=false;if(!has("ie")){dom.setSelectable(this.grid.domNode,true);}this.formatNode(this.getEditNode(_e61),_e60,_e61);}},formatNode:function(_e62,_e63,_e64){if(has("ie")){_e4d(this,"focus",_e64,_e62);}else{this.focus(_e64,_e62);}},dispatchEvent:function(m,e){if(m in this){return this[m](e);}},getValue:function(_e65){return this.getEditNode(_e65)[this._valueProp];},setValue:function(_e66,_e67){var n=this.getEditNode(_e66);if(n){n[this._valueProp]=_e67;}},focus:function(_e68,_e69){_e4b(_e69||this.getEditNode(_e68));},save:function(_e6a){this.value=this.value||this.getValue(_e6a);},restore:function(_e6b){this.setValue(_e6b,this.value);},_finish:function(_e6c){dom.setSelectable(this.grid.domNode,false);this.cancelFormatNode();},apply:function(_e6d){this.applyEdit(this.getValue(_e6d),_e6d);this._finish(_e6d);},cancel:function(_e6e){this.cancelEdit(_e6e);this._finish(_e6e);}});_e4e.markupFactory=function(node,_e6f){var _e70=lang.trim(_e47.get(node,"formatter")||"");if(_e70){_e6f.formatter=lang.getObject(_e70)||_e70;}var get=lang.trim(_e47.get(node,"get")||"");if(get){_e6f.get=lang.getObject(get);}var _e71=function(attr,cell,_e72){var _e73=lang.trim(_e47.get(node,attr)||"");if(_e73){cell[_e72||attr]=!(_e73.toLowerCase()=="false");}};_e71("sortDesc",_e6f);_e71("editable",_e6f);_e71("alwaysEditing",_e6f);_e71("noresize",_e6f);_e71("draggable",_e6f);var _e74=lang.trim(_e47.get(node,"loadingText")||_e47.get(node,"defaultValue")||"");if(_e74){_e6f.defaultValue=_e74;}var _e75=function(attr,cell,_e76){var _e77=lang.trim(_e47.get(node,attr)||"")||undefined;if(_e77){cell[_e76||attr]=_e77;}};_e75("styles",_e6f);_e75("headerStyles",_e6f);_e75("cellStyles",_e6f);_e75("classes",_e6f);_e75("headerClasses",_e6f);_e75("cellClasses",_e6f);};var Cell=_e43("dojox.grid.cells.Cell",_e4e,{constructor:function(){this.keyFilter=this.keyFilter;},keyFilter:null,formatEditing:function(_e78,_e79){this.needFormatNode(_e78,_e79);return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_e78+"\">";},formatNode:function(_e7a,_e7b,_e7c){this.inherited(arguments);this.registerOnBlur(_e7a,_e7c);},doKey:function(e){if(this.keyFilter){var key=String.fromCharCode(e.charCode);if(key.search(this.keyFilter)==-1){_e44.stop(e);}}},_finish:function(_e7d){this.inherited(arguments);var n=this.getEditNode(_e7d);try{util.fire(n,"blur");}catch(e){}}});Cell.markupFactory=function(node,_e7e){_e4e.markupFactory(node,_e7e);var _e7f=lang.trim(_e47.get(node,"keyFilter")||"");if(_e7f){_e7e.keyFilter=new RegExp(_e7f);}};var _e80=_e43("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){this.editable=false;},get:function(_e81){return _e81+1;}});_e80.markupFactory=function(node,_e82){Cell.markupFactory(node,_e82);};var _e83=_e43("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_e84){this.values=this.values||this.options;},formatEditing:function(_e85,_e86){this.needFormatNode(_e85,_e86);var h=["<select class=\"dojoxGridSelect\">"];for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;h.push("<option",(_e85==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");}h.push("</select>");return h.join("");},_defaultFormat:function(_e87,_e88){var v=this.inherited(arguments);if(!this.formatter&&this.values&&this.options){var i=_e46.indexOf(this.values,v);if(i>=0){v=this.options[i];}}return v;},getValue:function(_e89){var n=this.getEditNode(_e89);if(n){var i=n.selectedIndex,o=n.options[i];return this.returnIndex>-1?i:o.value||o.innerHTML;}}});_e83.markupFactory=function(node,cell){Cell.markupFactory(node,cell);var _e8a=lang.trim(_e47.get(node,"options")||"");if(_e8a){var o=_e8a.split(",");if(o[0]!=_e8a){cell.options=o;}}var _e8b=lang.trim(_e47.get(node,"values")||"");if(_e8b){var v=_e8b.split(",");if(v[0]!=_e8b){cell.values=v;}}};var _e8c=_e43("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_e8d,_e8e){this.formatNode(this.getEditNode(_e8e),_e8d,_e8e);},applyStaticValue:function(_e8f){var e=this.grid.edit;e.applyCellEdit(this.getValue(_e8f),this,_e8f);e.start(this,_e8f,true);}});_e8c.markupFactory=function(node,cell){Cell.markupFactory(node,cell);};var Bool=_e43("dojox.grid.cells.Bool",_e8c,{_valueProp:"checked",formatEditing:function(_e90,_e91){return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_e90?" checked=\"checked\"":"")+" style=\"width: auto\" />";},doclick:function(e){if(e.target.tagName=="INPUT"){this.applyStaticValue(e.rowIndex);}}});Bool.markupFactory=function(node,cell){_e8c.markupFactory(node,cell);};return _e4e;});},"dojo/cldr/supplemental":function(){define(["../_base/kernel","../_base/lang","../i18n"],function(dojo,lang){lang.getObject("cldr.supplemental",true,dojo);dojo.cldr.supplemental.getFirstDayOfWeek=function(_e92){var _e93={mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,er:6,et:6,iq:6,ir:6,jo:6,ke:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,so:6,sy:6,tn:6,ye:6,ar:0,as:0,az:0,bw:0,ca:0,cn:0,fo:0,ge:0,gl:0,gu:0,hk:0,il:0,"in":0,jm:0,jp:0,kg:0,kr:0,la:0,mh:0,mn:0,mo:0,mp:0,mt:0,nz:0,ph:0,pk:0,sg:0,th:0,tt:0,tw:0,um:0,us:0,uz:0,vi:0,zw:0};var _e94=dojo.cldr.supplemental._region(_e92);var dow=_e93[_e94];return (dow===undefined)?1:dow;};dojo.cldr.supplemental._region=function(_e95){_e95=dojo.i18n.normalizeLocale(_e95);var tags=_e95.split("-");var _e96=tags[1];if(!_e96){_e96={de:"de",en:"us",es:"es",fi:"fi",fr:"fr",he:"il",hu:"hu",it:"it",ja:"jp",ko:"kr",nl:"nl",pt:"br",sv:"se",zh:"cn"}[tags[0]];}else{if(_e96.length==4){_e96=tags[2];}}return _e96;};dojo.cldr.supplemental.getWeekend=function(_e97){var _e98={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5};var _e99={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6};var _e9a=dojo.cldr.supplemental._region(_e97);var _e9b=_e98[_e9a];var end=_e99[_e9a];if(_e9b===undefined){_e9b=6;}if(end===undefined){end=0;}return {start:_e9b,end:end};};return dojo.cldr.supplemental;});},"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\"\n/></span>\n","dijit/_editor/nls/commands":function(){define({root:({"bold":"Bold","copy":"Copy","cut":"Cut","delete":"Delete","indent":"Indent","insertHorizontalRule":"Horizontal Rule","insertOrderedList":"Numbered List","insertUnorderedList":"Bullet List","italic":"Italic","justifyCenter":"Align Center","justifyFull":"Justify","justifyLeft":"Align Left","justifyRight":"Align Right","outdent":"Outdent","paste":"Paste","redo":"Redo","removeFormat":"Remove Format","selectAll":"Select All","strikethrough":"Strikethrough","subscript":"Subscript","superscript":"Superscript","underline":"Underline","undo":"Undo","unlink":"Remove Link","createLink":"Create Link","toggleDir":"Toggle Direction","insertImage":"Insert Image","insertTable":"Insert/Edit Table","toggleTableBorder":"Toggle Table Border","deleteTable":"Delete Table","tableProp":"Table Property","htmlToggle":"HTML Source","foreColor":"Foreground Color","hiliteColor":"Background Color","plainFormatBlock":"Paragraph Style","formatBlock":"Paragraph Style","fontSize":"Font Size","fontName":"Font Name","tabIndent":"Tab Indent","fullScreen":"Toggle Full Screen","viewSource":"View HTML Source","print":"Print","newPage":"New Page","systemShortcut":"The \"${0}\" action is only available in your browser using a keyboard shortcut. Use ${1}.","ctrlKey":"ctrl+${0}","appleKey":"⌘${0}"}),"zh":true,"zh-tw":true,"tr":true,"th":true,"sv":true,"sl":true,"sk":true,"ru":true,"ro":true,"pt":true,"pt-pt":true,"pl":true,"nl":true,"nb":true,"ko":true,"kk":true,"ja":true,"it":true,"hu":true,"he":true,"fr":true,"fi":true,"es":true,"el":true,"de":true,"da":true,"cs":true,"ca":true,"ar":true});},"dojo/number":function(){define(["./_base/kernel","./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(dojo,lang,i18n,_e9c,_e9d,_e9e){lang.getObject("number",true,dojo);dojo.number.format=function(_e9f,_ea0){_ea0=lang.mixin({},_ea0||{});var _ea1=i18n.normalizeLocale(_ea0.locale),_ea2=i18n.getLocalization("dojo.cldr","number",_ea1);_ea0.customs=_ea2;var _ea3=_ea0.pattern||_ea2[(_ea0.type||"decimal")+"Format"];if(isNaN(_e9f)||Math.abs(_e9f)==Infinity){return null;}return dojo.number._applyPattern(_e9f,_ea3,_ea0);};dojo.number._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;dojo.number._applyPattern=function(_ea4,_ea5,_ea6){_ea6=_ea6||{};var _ea7=_ea6.customs.group,_ea8=_ea6.customs.decimal,_ea9=_ea5.split(";"),_eaa=_ea9[0];_ea5=_ea9[(_ea4<0)?1:0]||("-"+_eaa);if(_ea5.indexOf("%")!=-1){_ea4*=100;}else{if(_ea5.indexOf("‰")!=-1){_ea4*=1000;}else{if(_ea5.indexOf("¤")!=-1){_ea7=_ea6.customs.currencyGroup||_ea7;_ea8=_ea6.customs.currencyDecimal||_ea8;_ea5=_ea5.replace(/\u00a4{1,3}/,function(_eab){var prop=["symbol","currency","displayName"][_eab.length-1];return _ea6[prop]||_ea6.currency||"";});}else{if(_ea5.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _eac=dojo.number._numberPatternRE;var _ead=_eaa.match(_eac);if(!_ead){throw new Error("unable to find a number expression in pattern: "+_ea5);}if(_ea6.fractional===false){_ea6.places=0;}return _ea5.replace(_eac,dojo.number._formatAbsolute(_ea4,_ead[0],{decimal:_ea8,group:_ea7,places:_ea6.places,round:_ea6.round}));};dojo.number.round=function(_eae,_eaf,_eb0){var _eb1=10/(_eb0||10);return (_eb1*+_eae).toFixed(_eaf)/_eb1;};if((0.9).toFixed()==0){var _eb2=dojo.number.round;dojo.number.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d||a*Math.pow(10,p+1)<5){d=0;}return _eb2(v,p,m)+(v>0?d:-d);};}dojo.number._formatAbsolute=function(_eb3,_eb4,_eb5){_eb5=_eb5||{};if(_eb5.places===true){_eb5.places=0;}if(_eb5.places===Infinity){_eb5.places=6;}var _eb6=_eb4.split("."),_eb7=typeof _eb5.places=="string"&&_eb5.places.indexOf(","),_eb8=_eb5.places;if(_eb7){_eb8=_eb5.places.substring(_eb7+1);}else{if(!(_eb8>=0)){_eb8=(_eb6[1]||[]).length;}}if(!(_eb5.round<0)){_eb3=dojo.number.round(_eb3,_eb8,_eb5.round);}var _eb9=String(Math.abs(_eb3)).split("."),_eba=_eb9[1]||"";if(_eb6[1]||_eb5.places){if(_eb7){_eb5.places=_eb5.places.substring(0,_eb7);}var pad=_eb5.places!==undefined?_eb5.places:(_eb6[1]&&_eb6[1].lastIndexOf("0")+1);if(pad>_eba.length){_eb9[1]=_e9d.pad(_eba,pad,"0",true);}if(_eb8<_eba.length){_eb9[1]=_eba.substr(0,_eb8);}}else{if(_eb9[1]){_eb9.pop();}}var _ebb=_eb6[0].replace(",","");pad=_ebb.indexOf("0");if(pad!=-1){pad=_ebb.length-pad;if(pad>_eb9[0].length){_eb9[0]=_e9d.pad(_eb9[0],pad);}if(_ebb.indexOf("#")==-1){_eb9[0]=_eb9[0].substr(_eb9[0].length-pad);}}var _ebc=_eb6[0].lastIndexOf(","),_ebd,_ebe;if(_ebc!=-1){_ebd=_eb6[0].length-_ebc-1;var _ebf=_eb6[0].substr(0,_ebc);_ebc=_ebf.lastIndexOf(",");if(_ebc!=-1){_ebe=_ebf.length-_ebc-1;}}var _ec0=[];for(var _ec1=_eb9[0];_ec1;){var off=_ec1.length-_ebd;_ec0.push((off>0)?_ec1.substr(off):_ec1);_ec1=(off>0)?_ec1.slice(0,off):"";if(_ebe){_ebd=_ebe;delete _ebe;}}_eb9[0]=_ec0.reverse().join(_eb5.group||",");return _eb9.join(_eb5.decimal||".");};dojo.number.regexp=function(_ec2){return dojo.number._parseInfo(_ec2).regexp;};dojo.number._parseInfo=function(_ec3){_ec3=_ec3||{};var _ec4=i18n.normalizeLocale(_ec3.locale),_ec5=i18n.getLocalization("dojo.cldr","number",_ec4),_ec6=_ec3.pattern||_ec5[(_ec3.type||"decimal")+"Format"],_ec7=_ec5.group,_ec8=_ec5.decimal,_ec9=1;if(_ec6.indexOf("%")!=-1){_ec9/=100;}else{if(_ec6.indexOf("‰")!=-1){_ec9/=1000;}else{var _eca=_ec6.indexOf("¤")!=-1;if(_eca){_ec7=_ec5.currencyGroup||_ec7;_ec8=_ec5.currencyDecimal||_ec8;}}}var _ecb=_ec6.split(";");if(_ecb.length==1){_ecb.push("-"+_ecb[0]);}var re=_e9e.buildGroupRE(_ecb,function(_ecc){_ecc="(?:"+_e9e.escapeString(_ecc,".")+")";return _ecc.replace(dojo.number._numberPatternRE,function(_ecd){var _ece={signed:false,separator:_ec3.strict?_ec7:[_ec7,""],fractional:_ec3.fractional,decimal:_ec8,exponent:false},_ecf=_ecd.split("."),_ed0=_ec3.places;if(_ecf.length==1&&_ec9!=1){_ecf[1]="###";}if(_ecf.length==1||_ed0===0){_ece.fractional=false;}else{if(_ed0===undefined){_ed0=_ec3.pattern?_ecf[1].lastIndexOf("0")+1:Infinity;}if(_ed0&&_ec3.fractional==undefined){_ece.fractional=true;}if(!_ec3.places&&(_ed0<_ecf[1].length)){_ed0+=","+_ecf[1].length;}_ece.places=_ed0;}var _ed1=_ecf[0].split(",");if(_ed1.length>1){_ece.groupSize=_ed1.pop().length;if(_ed1.length>1){_ece.groupSize2=_ed1.pop().length;}}return "("+dojo.number._realNumberRegexp(_ece)+")";});},true);if(_eca){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_ed2,_ed3,_ed4,_ed5){var prop=["symbol","currency","displayName"][_ed4.length-1],_ed6=_e9e.escapeString(_ec3[prop]||_ec3.currency||"");_ed3=_ed3?"[\\s\\xa0]":"";_ed5=_ed5?"[\\s\\xa0]":"";if(!_ec3.strict){if(_ed3){_ed3+="*";}if(_ed5){_ed5+="*";}return "(?:"+_ed3+_ed6+_ed5+")?";}return _ed3+_ed6+_ed5;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_ec7,decimal:_ec8,factor:_ec9};};dojo.number.parse=function(_ed7,_ed8){var info=dojo.number._parseInfo(_ed8),_ed9=(new RegExp("^"+info.regexp+"$")).exec(_ed7);if(!_ed9){return NaN;}var _eda=_ed9[1];if(!_ed9[1]){if(!_ed9[2]){return NaN;}_eda=_ed9[2];info.factor*=-1;}_eda=_eda.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _eda*info.factor;};dojo.number._realNumberRegexp=function(_edb){_edb=_edb||{};if(!("places" in _edb)){_edb.places=Infinity;}if(typeof _edb.decimal!="string"){_edb.decimal=".";}if(!("fractional" in _edb)||/^0/.test(_edb.places)){_edb.fractional=[true,false];}if(!("exponent" in _edb)){_edb.exponent=[true,false];}if(!("eSigned" in _edb)){_edb.eSigned=[true,false];}var _edc=dojo.number._integerRegexp(_edb),_edd=_e9e.buildGroupRE(_edb.fractional,function(q){var re="";if(q&&(_edb.places!==0)){re="\\"+_edb.decimal;if(_edb.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_edb.places+"}";}}return re;},true);var _ede=_e9e.buildGroupRE(_edb.exponent,function(q){if(q){return "([eE]"+dojo.number._integerRegexp({signed:_edb.eSigned})+")";}return "";});var _edf=_edc+_edd;if(_edd){_edf="(?:(?:"+_edf+")|(?:"+_edd+"))";}return _edf+_ede;};dojo.number._integerRegexp=function(_ee0){_ee0=_ee0||{};if(!("signed" in _ee0)){_ee0.signed=[true,false];}if(!("separator" in _ee0)){_ee0.separator="";}else{if(!("groupSize" in _ee0)){_ee0.groupSize=3;}}var _ee1=_e9e.buildGroupRE(_ee0.signed,function(q){return q?"[-+]":"";},true);var _ee2=_e9e.buildGroupRE(_ee0.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_e9e.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_ee0.groupSize,grp2=_ee0.groupSize2;if(grp2){var _ee3="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_ee3+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_ee3;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _ee1+_ee2;};return dojo.number;});},"dijit/layout/_ContentPaneResizeMixin":function(){define("dijit/layout/_ContentPaneResizeMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/lang","dojo/query","dojo/_base/sniff","dojo/_base/window","../registry","./utils","../_Contained"],function(_ee4,_ee5,_ee6,_ee7,_ee8,lang,_ee9,has,win,_eea,_eeb,_eec){return _ee5("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _eed=this.getParent();this._childOfLayoutWidget=_eed&&_eed.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.connect(has("ie")?this.domNode:win.global,"onresize",function(){this._needLayout=!this._childOfLayoutWidget;this.resize();});}},_checkIfSingleChild:function(){var _eee=_ee9("> *",this.containerNode).filter(function(node){return node.tagName!=="SCRIPT";}),_eef=_eee.filter(function(node){return _ee6.has(node,"data-dojo-type")||_ee6.has(node,"dojoType")||_ee6.has(node,"widgetId");}),_ef0=_ee4.filter(_eef.map(_eea.byNode),function(_ef1){return _ef1&&_ef1.domNode&&_ef1.resize;});if(_eee.length==_eef.length&&_ef0.length==1){this._singleChild=_ef0[0];}else{delete this._singleChild;}_ee7.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_ef2,_ef3){if(!this._wasShown&&this.open!==false){this._onShow();}this._resizeCalled=true;this._scheduleLayout(_ef2,_ef3);},_scheduleLayout:function(_ef4,_ef5){if(this._isShown()){this._layout(_ef4,_ef5);}else{this._needLayout=true;this._changeSize=_ef4;this._resultSize=_ef5;}},_layout:function(_ef6,_ef7){if(_ef6){_ee8.setMarginBox(this.domNode,_ef6);}var cn=this.containerNode;if(cn===this.domNode){var mb=_ef7||{};lang.mixin(mb,_ef6||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_ee8.getMarginBox(cn),mb);}this._contentBox=_eeb.marginBox2contentBox(cn,mb);}else{this._contentBox=_ee8.getContentBox(cn);}this._layoutChildren();delete this._needLayout;},_layoutChildren:function(){if(this.doLayout){this._checkIfSingleChild();}if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_ee8.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{_ee4.forEach(this.getChildren(),function(_ef8){if(_ef8.resize){_ef8.resize();}});}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_ef9=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_ee7.contains(node,"dijitHidden")&&_ef9&&_ef9.style&&(_ef9.style.display!="none");}}},_onShow:function(){if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);this._wasShown=true;}});});},"dojox/charting/plot2d/Spider":function(){define("dojox/charting/plot2d/Spider",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/_base/sniff","../Element","./_PlotEvents","dojo/_base/Color","dojox/color/_base","./common","../axis2d/common","../scaler/primitive","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_efa,hub,html,arr,_efb,_efc,_efd,has,_efe,_eff,_f00,_f01,dc,da,_f02,g,m,_f03,df,du,_f04){var _f05=0.2;var _f06=_efa("dojox.charting.plot2d.Spider",[_efe,_eff],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_f04.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_f07,_f08){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_f08);du.updateWithPattern(this.opt,_f08,this.optionalParams);this.series=[];this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.dirty=true;this.dyn=[];this.series=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){return this;},addSeries:function(run){var _f09=false;this.series.push(run);for(var key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(var key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_f0a){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_f0a.hmin,_f0a.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_f02.buildScaler(_f0a.hmin,_f0a.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_f0a.vmin,_f0a.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_f02.buildScaler(_f0a.vmin,_f0a.vmax,dim.height);}return this;},render:function(dim,_f0b){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_f0b.l-_f0b.r)/2,ry=(dim.height-_f0b.t-_f0b.b)/2,r=Math.min(rx,ry),_f0c=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_f0d=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_f0e=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_f0f=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_f10=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_f11=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_f12=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_f13=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_f14=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_f15=g.normalizedLength(g.splitFontString(_f0d).size),_f16=m._degToRad(o.startAngle),_f17=_f16,step,_f18,_f19,_f1a,_f1b,_f1c,_f1d,_f1e,_f1f,_f20,_f21,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_f22=o.labelOffset<-10?o.labelOffset:-10,_f23=0.2;if(o.labels){_f1a=arr.map(this.series,function(s){return s.name;},this);_f1b=df.foldl1(df.map(_f1a,function(_f24,i){var font=t.series.font;return g._base._getTextBox(_f24,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_f1b,ry-_f15)+_f22;_f1c=r-_f22;}if("radius" in o){r=o.radius;_f1c=r-_f22;}r/=(1+_f23);var _f25={cx:_f0b.l+rx,cy:_f0b.t+ry,r:r};for(var i=this.series.length-1;i>=0;i--){var _f26=this.series[i];if(!this.dirty&&!_f26.dirty){t.skip();continue;}_f26.cleanGroup();var run=_f26.data;if(run!==null){var len=this._getObjectLength(run);if(!_f1d||_f1d.length<=0){_f1d=[],_f1e=[],_f21=[];this._buildPoints(_f1d,len,_f25,r,_f17,true);this._buildPoints(_f1e,len,_f25,r*ro,_f17,true);this._buildPoints(_f21,len,_f25,_f1c,_f17);if(dv>2){_f1f=[],_f20=[];for(var j=0;j<dv-2;j++){_f1f[j]=[];this._buildPoints(_f1f[j],len,_f25,r*(ro+(1-ro)*(j+1)/(dv-1)),_f17,true);_f20[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _f27=s.createGroup(),_f28={color:_f10,width:_f12},_f29={color:_f11,width:_f13};for(var j=_f1d.length-1;j>=0;--j){var _f2a=_f1d[j],st={x:_f2a.x+(_f2a.x-_f25.cx)*_f23,y:_f2a.y+(_f2a.y-_f25.cy)*_f23},nd={x:_f2a.x+(_f2a.x-_f25.cx)*_f23/2,y:_f2a.y+(_f2a.y-_f25.cy)*_f23/2};_f27.createLine({x1:_f25.cx,y1:_f25.cy,x2:st.x,y2:st.y}).setStroke(_f28);this._drawArrow(_f27,st,nd,_f28);}var _f2b=s.createGroup();for(var j=_f21.length-1;j>=0;--j){var _f2a=_f21[j],_f2c=g._base._getTextBox(this.labelKey[j],{font:_f0d}).w||0,_f2d=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx",elem=da.createText[_f2d](this.chart,_f2b,(!_efb.isBodyLtr()&&_f2d=="html")?(_f2a.x+_f2c-dim.width):_f2a.x,_f2a.y,"middle",this.labelKey[j],_f0d,_f0f);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _f2e=s.createGroup();if(spt=="polygon"){_f2e.createPolyline(_f1d).setStroke(_f29);_f2e.createPolyline(_f1e).setStroke(_f29);if(_f1f.length>0){for(var j=_f1f.length-1;j>=0;--j){_f2e.createPolyline(_f1f[j]).setStroke(_f29);}}}else{var _f2f=this._getObjectLength(this.datas);_f2e.createCircle({cx:_f25.cx,cy:_f25.cy,r:r}).setStroke(_f29);_f2e.createCircle({cx:_f25.cx,cy:_f25.cy,r:r*ro}).setStroke(_f29);if(_f20.length>0){for(var j=_f20.length-1;j>=0;--j){_f2e.createCircle({cx:_f25.cx,cy:_f25.cy,r:_f20[j]}).setStroke(_f29);}}}var _f30=s.createGroup(),len=this._getObjectLength(this.datas),k=0;for(var key in this.datas){var data=this.datas[key],min=data.min,max=data.max,_f31=max-min,end=_f17+2*Math.PI*k/len;for(var i=0;i<dv;i++){var text=min+_f31*i/(dv-1),_f2a=this._getCoordinate(_f25,r*(ro+(1-ro)*i/(dv-1)),end);text=this._getLabel(text);var _f2c=g._base._getTextBox(text,{font:_f0c}).w||0,_f2d=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_f2d](this.chart,_f30,(!_efb.isBodyLtr()&&_f2d=="html")?(_f2a.x+_f2c-dim.width):_f2a.x,_f2a.y,"start",text,_f0c,_f0e));}}k++;}this.chart.seriesShapes={};var _f32=[];for(var i=this.series.length-1;i>=0;i--){var _f26=this.series[i],run=_f26.data;if(run!==null){var _f33=[],k=0,_f34=[];for(var key in run){var data=this.datas[key],min=data.min,max=data.max,_f31=max-min,_f35=run[key],end=_f17+2*Math.PI*k/len,_f2a=this._getCoordinate(_f25,r*(ro+(1-ro)*(_f35-min)/_f31),end);_f33.push(_f2a);_f34.push({sname:_f26.name,key:key,data:_f35});k++;}_f33[_f33.length]=_f33[0];_f34[_f34.length]=_f34[0];var _f36=this._getBoundary(_f33),_f37=t.next("spider",[o,_f26]),ts=_f26.group,f=g.normalizeColor(_f37.series.fill),sk={color:_f37.series.fill,width:_f14};f.a=o.seriesFillAlpha;_f26.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_f26.name];var cs=this._createSeriesEntry(ts,(osps||_f1e),_f33,f,sk,r,ro,ms,at);this.chart.seriesShapes[_f26.name]=cs;this.oldSeriePoints[_f26.name]=_f33;var po={element:"spider_poly",index:i,id:"spider_poly_"+_f26.name,run:_f26,plot:this,shape:cs.poly,parent:ts,brect:_f36,cx:_f25.cx,cy:_f25.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_f26.name,run:_f26,plot:this,shape:_f26.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var _f38=c.getShape(),co={element:"spider_circle",index:i,id:"spider_circle_"+_f26.name+i,run:_f26,plot:this,shape:c,parent:ts,tdata:_f34[i],cx:_f33[i].x,cy:_f33[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _f39=ts.createPolyline(osps).setFill(f).setStroke(sk),_f3a=[];for(var j=0;j<osps.length;j++){var _f3b=osps[j],cr=ms;var _f3c=ts.createCircle({cx:_f3b.x,cy:_f3b.y,r:cr}).setFill(f).setStroke(sk);_f3a.push(_f3c);}var _f3d=arr.map(sps,function(np,j){var sp=osps[j],anim=new _efc.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_f39,sc=_f3a[j];hub.connect(anim,"onAnimate",function(y){var _f3e=spl.getShape();_f3e.points[j].y=y;spl.setShape(_f3e);var _f3f=sc.getShape();_f3f.cy=y;sc.setShape(_f3f);});return anim;});var _f40=arr.map(sps,function(np,j){var sp=osps[j],anim=new _efc.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_f39,sc=_f3a[j];hub.connect(anim,"onAnimate",function(x){var _f41=spl.getShape();_f41.points[j].x=x;spl.setShape(_f41);var _f42=sc.getShape();_f42.cx=x;sc.setShape(_f42);});return anim;});var _f43=_efd.combine(_f3d.concat(_f40));_f43.play();return {group:ts,poly:_f39,circles:_f3a};},plotEvent:function(o){var _f44=o.id?o.id:"default",a;if(_f44 in this.animations){a=this.animations[_f44];a.anim&&a.anim.stop(true);}else{a=this.animations[_f44]={};}if(o.element=="spider_poly"){if(!a.color){var _f45=o.shape.getFill();if(!_f45||!(_f45 instanceof _f00)){return;}a.color={start:_f45,end:_f46(_f45)};}var _f47=a.color.start,end=a.color.end;if(o.type=="onmouseout"){var t=_f47;_f47=end;end=t;}a.anim=_f03.animateFill({shape:o.shape,duration:800,easing:_f04.backOut,color:{start:_f47,end:end}});a.anim.play();}else{if(o.element=="spider_circle"){var init,_f48,_f49=1.5;if(o.type=="onmouseover"){init=m.identity;_f48=_f49;var _f4a={type:"rect"};_f4a.x=o.cx;_f4a.y=o.cy;_f4a.width=_f4a.height=1;var lt=html.coords(this.chart.node,true);_f4a.x+=lt.x;_f4a.y+=lt.y;_f4a.x=Math.round(_f4a.x);_f4a.y=Math.round(_f4a.y);_f4a.width=Math.ceil(_f4a.width);_f4a.height=Math.ceil(_f4a.height);this.aroundRect=_f4a;var _f4b=["after","before"];dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_f4c){_f4c.show(o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data,this.aroundRect,_f4b);}));}else{init=m.scaleAt(_f49,o.cx,o.cy);_f48=1/_f49;dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_f4d){this.aroundRect&&_f4d.hide(this.aroundRect);}));}var cs=o.shape.getShape(),init=m.scaleAt(_f49,cs.cx,cs.cy),_f4e={shape:o.shape,duration:200,easing:_f04.backOut,transform:[{name:"scaleAt",start:[1,cs.cx,cs.cy],end:[_f48,cs.cx,cs.cy]},init]};a.anim=_f03.animateTransform(_f4e);a.anim.play();}else{if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}}}},_getBoundary:function(_f4f){var xmax=_f4f[0].x,xmin=_f4f[0].x,ymax=_f4f[0].y,ymin=_f4f[0].y;for(var i=0;i<_f4f.length;i++){var _f50=_f4f[i];xmax=Math.max(_f50.x,xmax);ymax=Math.max(_f50.y,ymax);xmin=Math.min(_f50.x,xmin);ymin=Math.min(_f50.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_f51,end,_f52){var len=Math.sqrt(Math.pow(end.x-_f51.x,2)+Math.pow(end.y-_f51.y,2)),sin=(end.y-_f51.y)/len,cos=(end.x-_f51.x)/len,_f53={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_f54={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_f51,_f53,_f54]).setFill(_f52.color).setStroke(_f52);},_buildPoints:function(_f55,_f56,_f57,_f58,_f59,_f5a){for(var i=0;i<_f56;i++){var end=_f59+2*Math.PI*i/_f56;_f55.push(this._getCoordinate(_f57,_f58,end));}if(_f5a){_f55.push(this._getCoordinate(_f57,_f58,_f59+2*Math.PI));}},_getCoordinate:function(_f5b,_f5c,_f5d){return {x:_f5b.cx+_f5c*Math.cos(_f5d),y:_f5b.cy+_f5c*Math.sin(_f5d)};},_getObjectLength:function(obj){var _f5e=0;if(lang.isObject(obj)){for(var key in obj){_f5e++;}}return _f5e;},_getLabel:function(_f5f){return dc.getLabel(_f5f,this.opt.fixed,this.opt.precision);}});function _f46(_f60){var a=new _f01.Color(_f60),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=100;if(x.l<50){x.l=75;}else{if(x.l>75){x.l=50;}else{x.l=x.l-50>75-x.l?50:75;}}}var _f60=_f01.fromHsl(x);_f60.a=0.7;return _f60;};return _f06;});},"dijit/form/_ButtonMixin":function(){define("dijit/form/_ButtonMixin",["dojo/_base/declare","dojo/dom","dojo/_base/event","../registry"],function(_f61,dom,_f62,_f63){return _f61("dijit.form._ButtonMixin",null,{label:"",type:"button",_onClick:function(e){if(this.disabled){_f62.stop(e);return false;}var _f64=this.onClick(e)===false;if(!_f64&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _f65=_f63.byNode(node);if(_f65&&typeof _f65._onSubmit=="function"){_f65._onSubmit(e);_f64=true;break;}}}if(_f64){e.preventDefault();}return !_f64;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_f66){this._set("label",_f66);(this.containerNode||this.focusNode).innerHTML=_f66;}});});},"url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","url:dijit/templates/TimePicker.html":"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n","dojox/gfx/path":function(){define("dojox/gfx/path",["./_base","dojo/_base/lang","dojo/_base/declare","./matrix","./shape"],function(g,lang,_f67,_f68,_f69){var path=g.path={};var Path=_f67("dojox.gfx.path.Path",_f69.Shape,{constructor:function(_f6a){this.shape=lang.clone(g.defaultPath);this.segments=[];this.tbbox=null;this.absolute=true;this.last={};this.rawNode=_f6a;this.segmented=false;},setAbsoluteMode:function(mode){this._confirmSegmented();this.absolute=typeof mode=="string"?(mode=="absolute"):mode;return this;},getAbsoluteMode:function(){this._confirmSegmented();return this.absolute;},getBoundingBox:function(){this._confirmSegmented();return (this.bbox&&("l" in this.bbox))?{x:this.bbox.l,y:this.bbox.t,width:this.bbox.r-this.bbox.l,height:this.bbox.b-this.bbox.t}:null;},_getRealBBox:function(){this._confirmSegmented();if(this.tbbox){return this.tbbox;}var bbox=this.bbox,_f68=this._getRealMatrix();this.bbox=null;for(var i=0,len=this.segments.length;i<len;++i){this._updateWithSegment(this.segments[i],_f68);}var t=this.bbox;this.bbox=bbox;this.tbbox=t?[{x:t.l,y:t.t},{x:t.r,y:t.t},{x:t.r,y:t.b},{x:t.l,y:t.b}]:null;return this.tbbox;},getLastPosition:function(){this._confirmSegmented();return "x" in this.last?this.last:null;},_applyTransform:function(){this.tbbox=null;return this.inherited(arguments);},_updateBBox:function(x,y,m){if(m){var t=_f68.multiplyPoint(m,x,y);x=t.x;y=t.y;}if(this.bbox&&("l" in this.bbox)){if(this.bbox.l>x){this.bbox.l=x;}if(this.bbox.r<x){this.bbox.r=x;}if(this.bbox.t>y){this.bbox.t=y;}if(this.bbox.b<y){this.bbox.b=y;}}else{this.bbox={l:x,b:y,r:x,t:y};}},_updateWithSegment:function(_f6b,_f6c){var n=_f6b.args,l=n.length,i;switch(_f6b.action){case "M":case "L":case "C":case "S":case "Q":case "T":for(i=0;i<l;i+=2){this._updateBBox(n[i],n[i+1],_f6c);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "H":for(i=0;i<l;++i){this._updateBBox(n[i],this.last.y,_f6c);}this.last.x=n[l-1];this.absolute=true;break;case "V":for(i=0;i<l;++i){this._updateBBox(this.last.x,n[i],_f6c);}this.last.y=n[l-1];this.absolute=true;break;case "m":var _f6d=0;if(!("x" in this.last)){this._updateBBox(this.last.x=n[0],this.last.y=n[1],_f6c);_f6d=2;}for(i=_f6d;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_f6c);}this.absolute=false;break;case "l":case "t":for(i=0;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_f6c);}this.absolute=false;break;case "h":for(i=0;i<l;++i){this._updateBBox(this.last.x+=n[i],this.last.y,_f6c);}this.absolute=false;break;case "v":for(i=0;i<l;++i){this._updateBBox(this.last.x,this.last.y+=n[i],_f6c);}this.absolute=false;break;case "c":for(i=0;i<l;i+=6){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_f6c);this._updateBBox(this.last.x+n[i+2],this.last.y+n[i+3],_f6c);this._updateBBox(this.last.x+=n[i+4],this.last.y+=n[i+5],_f6c);}this.absolute=false;break;case "s":case "q":for(i=0;i<l;i+=4){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_f6c);this._updateBBox(this.last.x+=n[i+2],this.last.y+=n[i+3],_f6c);}this.absolute=false;break;case "A":for(i=0;i<l;i+=7){this._updateBBox(n[i+5],n[i+6],_f6c);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "a":for(i=0;i<l;i+=7){this._updateBBox(this.last.x+=n[i+5],this.last.y+=n[i+6],_f6c);}this.absolute=false;break;}var path=[_f6b.action];for(i=0;i<l;++i){path.push(g.formatNumber(n[i],true));}if(typeof this.shape.path=="string"){this.shape.path+=path.join("");}else{Array.prototype.push.apply(this.shape.path,path);}},_validSegments:{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7,z:0},_pushSegment:function(_f6e,args){this.tbbox=null;var _f6f=this._validSegments[_f6e.toLowerCase()],_f70;if(typeof _f6f=="number"){if(_f6f){if(args.length>=_f6f){_f70={action:_f6e,args:args.slice(0,args.length-args.length%_f6f)};this.segments.push(_f70);this._updateWithSegment(_f70);}}else{_f70={action:_f6e,args:[]};this.segments.push(_f70);this._updateWithSegment(_f70);}}},_collectArgs:function(_f71,args){for(var i=0;i<args.length;++i){var t=args[i];if(typeof t=="boolean"){_f71.push(t?1:0);}else{if(typeof t=="number"){_f71.push(t);}else{if(t instanceof Array){this._collectArgs(_f71,t);}else{if("x" in t&&"y" in t){_f71.push(t.x,t.y);}}}}}},moveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"M":"m",args);return this;},lineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"L":"l",args);return this;},hLineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"H":"h",args);return this;},vLineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"V":"v",args);return this;},curveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"C":"c",args);return this;},smoothCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"S":"s",args);return this;},qCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"Q":"q",args);return this;},qSmoothCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"T":"t",args);return this;},arcTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"A":"a",args);return this;},closePath:function(){this._confirmSegmented();this._pushSegment("Z",[]);return this;},_confirmSegmented:function(){if(!this.segmented){var path=this.shape.path;this.shape.path=[];this._setPath(path);this.shape.path=this.shape.path.join("");this.segmented=true;}},_setPath:function(path){var p=lang.isArray(path)?path:path.match(g.pathSvgRegExp);this.segments=[];this.absolute=true;this.bbox={};this.last={};if(!p){return;}var _f72="",args=[],l=p.length;for(var i=0;i<l;++i){var t=p[i],x=parseFloat(t);if(isNaN(x)){if(_f72){this._pushSegment(_f72,args);}args=[];_f72=t;}else{args.push(x);}}this._pushSegment(_f72,args);},setShape:function(_f73){this.inherited(arguments,[typeof _f73=="string"?{path:_f73}:_f73]);this.segmented=false;this.segments=[];if(!g.lazyPathSegmentation){this._confirmSegmented();}return this;},_2PI:Math.PI*2});var _f74=_f67("dojox.gfx.path.TextPath",Path,{constructor:function(_f75){if(!("text" in this)){this.text=lang.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=lang.clone(g.defaultFont);}},getText:function(){return this.text;},setText:function(_f76){this.text=g.makeParameters(this.text,typeof _f76=="string"?{text:_f76}:_f76);this._setText();return this;},getFont:function(){return this.fontStyle;},setFont:function(_f77){this.fontStyle=typeof _f77=="string"?g.splitFontString(_f77):g.makeParameters(g.defaultFont,_f77);this._setFont();return this;}});return {Path:Path,TextPath:_f74};});},"dijit/tree/TreeStoreModel":function(){define("dijit/tree/TreeStoreModel",["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/json","dojo/_base/lang"],function(_f78,_f79,_f7a,json,lang){return _f7a("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(args){lang.mixin(this,args);this.connects=[];var _f7b=this.store;if(!_f7b.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.Tree: store must support dojo.data.Identity");}if(_f7b.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_f79.after(_f7b,"onNew",lang.hitch(this,"onNewItem"),true),_f79.after(_f7b,"onDelete",lang.hitch(this,"onDeleteItem"),true),_f79.after(_f7b,"onSet",lang.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_f7c,_f7d){if(this.root){_f7c(this.root);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_f7e){if(_f7e.length!=1){throw new Error(this.declaredClass+": query "+json.stringify(this.query)+" returned "+_f7e.length+" items, but must return exactly one item");}this.root=_f7e[0];_f7c(this.root);}),onError:_f7d});}},mayHaveChildren:function(item){return _f78.some(this.childrenAttrs,function(attr){return this.store.hasAttribute(item,attr);},this);},getChildren:function(_f7f,_f80,_f81){var _f82=this.store;if(!_f82.isItemLoaded(_f7f)){var _f83=lang.hitch(this,arguments.callee);_f82.loadItem({item:_f7f,onItem:function(_f84){_f83(_f84,_f80,_f81);},onError:_f81});return;}var _f85=[];for(var i=0;i<this.childrenAttrs.length;i++){var vals=_f82.getValues(_f7f,this.childrenAttrs[i]);_f85=_f85.concat(vals);}var _f86=0;if(!this.deferItemLoadingUntilExpand){_f78.forEach(_f85,function(item){if(!_f82.isItemLoaded(item)){_f86++;}});}if(_f86==0){_f80(_f85);}else{_f78.forEach(_f85,function(item,idx){if(!_f82.isItemLoaded(item)){_f82.loadItem({item:item,onItem:function(item){_f85[idx]=item;if(--_f86==0){_f80(_f85);}},onError:_f81});}});}},isItem:function(_f87){return this.store.isItem(_f87);},fetchItemByIdentity:function(_f88){this.store.fetchItemByIdentity(_f88);},getIdentity:function(item){return this.store.getIdentity(item);},getLabel:function(item){if(this.labelAttr){return this.store.getValue(item,this.labelAttr);}else{return this.store.getLabel(item);}},newItem:function(args,_f89,_f8a){var _f8b={parent:_f89,attribute:this.childrenAttrs[0]},_f8c;if(this.newItemIdAttr&&args[this.newItemIdAttr]){this.fetchItemByIdentity({identity:args[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_f89,true,_f8a);}else{_f8c=this.store.newItem(args,_f8b);if(_f8c&&(_f8a!=undefined)){this.pasteItem(_f8c,_f89,_f89,false,_f8a);}}}});}else{_f8c=this.store.newItem(args,_f8b);if(_f8c&&(_f8a!=undefined)){this.pasteItem(_f8c,_f89,_f89,false,_f8a);}}},pasteItem:function(_f8d,_f8e,_f8f,_f90,_f91){var _f92=this.store,_f93=this.childrenAttrs[0];if(_f8e){_f78.forEach(this.childrenAttrs,function(attr){if(_f92.containsValue(_f8e,attr,_f8d)){if(!_f90){var _f94=_f78.filter(_f92.getValues(_f8e,attr),function(x){return x!=_f8d;});_f92.setValues(_f8e,attr,_f94);}_f93=attr;}});}if(_f8f){if(typeof _f91=="number"){var _f95=_f92.getValues(_f8f,_f93).slice();_f95.splice(_f91,0,_f8d);_f92.setValues(_f8f,_f93,_f95);}else{_f92.setValues(_f8f,_f93,_f92.getValues(_f8f,_f93).concat(_f8d));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_f96){if(!_f96){return;}this.getChildren(_f96.item,lang.hitch(this,function(_f97){this.onChildrenChange(_f96.item,_f97);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_f98){if(_f78.indexOf(this.childrenAttrs,_f98)!=-1){this.getChildren(item,lang.hitch(this,function(_f99){this.onChildrenChange(item,_f99);}));}else{this.onChange(item);}}});});},"url:dijit/templates/TooltipDialog.html":"<div role=\"presentation\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div class =\"dijitTooltipContents dijitTooltipFocusNode\" data-dojo-attach-point=\"containerNode\" role=\"dialog\"></div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\"></div>\n</div>\n","dojo/dnd/TimedMoveable":function(){define(["../main","./Moveable"],function(dojo){var _f9a=dojo.dnd.Moveable.prototype.onMove;dojo.declare("dojo.dnd.TimedMoveable",dojo.dnd.Moveable,{timeout:40,constructor:function(node,_f9b){if(!_f9b){_f9b={};}if(_f9b.timeout&&typeof _f9b.timeout=="number"&&_f9b.timeout>=0){this.timeout=_f9b.timeout;}},onMoveStop:function(_f9c){if(_f9c._timer){clearTimeout(_f9c._timer);_f9a.call(this,_f9c,_f9c._leftTop);}dojo.dnd.Moveable.prototype.onMoveStop.apply(this,arguments);},onMove:function(_f9d,_f9e){_f9d._leftTop=_f9e;if(!_f9d._timer){var _f9f=this;_f9d._timer=setTimeout(function(){_f9d._timer=null;_f9a.call(_f9f,_f9d,_f9d._leftTop);},this.timeout);}}});return dojo.dnd.TimedMoveable;});},"dojox/gfx/matrix":function(){define("dojox/gfx/matrix",["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _fa0={};m._degToRad=function(_fa1){return _fa0[_fa1]||(_fa0[_fa1]=(Math.PI*_fa1/180));};m._radToDeg=function(_fa2){return _fa2/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _fa3=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_fa3,r=m.normalize(arg[i]);_fa3=new m.Matrix2D();_fa3.xx=l.xx*r.xx+l.xy*r.yx;_fa3.xy=l.xx*r.xy+l.xy*r.yy;_fa3.yx=l.yx*r.xx+l.yy*r.yx;_fa3.yy=l.yx*r.xy+l.yy*r.yy;_fa3.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_fa3.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_fa3);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_fa4){var c=Math.cos(_fa4);var s=Math.sin(_fa4);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_fa5){return m.rotate(m._degToRad(_fa5));},skewX:function(_fa6){return new m.Matrix2D({xy:Math.tan(_fa6)});},skewXg:function(_fa7){return m.skewX(m._degToRad(_fa7));},skewY:function(_fa8){return new m.Matrix2D({yx:Math.tan(_fa8)});},skewYg:function(_fa9){return m.skewY(m._degToRad(_fa9));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_faa){return (_faa instanceof m.Matrix2D)?_faa:new m.Matrix2D(_faa);},clone:function(_fab){var obj=new m.Matrix2D();for(var i in _fab){if(typeof (_fab[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_fab[i]){obj[i]=_fab[i];}}return obj;},invert:function(_fac){var M=m.normalize(_fac),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_fad,x,y){return {x:_fad.xx*x+_fad.xy*y+_fad.dx,y:_fad.yx*x+_fad.yy*y+_fad.dy};},multiplyPoint:function(_fae,a,b){var M=m.normalize(_fae);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_faf){var M=m.normalize(_faf);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_fb0,x,y){return m.multiply(m.translate(x,y),_fb0,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_fb1,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_fb1),a,b);}return m._sandwich(m.rotate(_fb1),a.x,a.y);},rotategAt:function(_fb2,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_fb2),a,b);}return m._sandwich(m.rotateg(_fb2),a.x,a.y);},skewXAt:function(_fb3,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_fb3),a,b);}return m._sandwich(m.skewX(_fb3),a.x,a.y);},skewXgAt:function(_fb4,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_fb4),a,b);}return m._sandwich(m.skewXg(_fb4),a.x,a.y);},skewYAt:function(_fb5,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_fb5),a,b);}return m._sandwich(m.skewY(_fb5),a.x,a.y);},skewYgAt:function(_fb6,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_fb6),a,b);}return m._sandwich(m.skewYg(_fb6),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dijit/form/HorizontalRule":function(){define("dijit/form/HorizontalRule",["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_fb7,_fb8,_fb9){return _fb7("dijit.form.HorizontalRule",[_fb8,_fb9],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;},_isHorizontal:true,buildRendering:function(){this.inherited(arguments);var _fba;if(this.count==1){_fba=this._genHTML(50,0);}else{var i;var _fbb=100/(this.count-1);if(!this._isHorizontal||this.isLeftToRight()){_fba=this._genHTML(0,0);for(i=1;i<this.count-1;i++){_fba+=this._genHTML(_fbb*i,i);}_fba+=this._genHTML(100,this.count-1);}else{_fba=this._genHTML(100,0);for(i=1;i<this.count-1;i++){_fba+=this._genHTML(100-_fbb*i,i);}_fba+=this._genHTML(0,this.count-1);}}this.domNode.innerHTML=_fba;}});});},"url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","dijit/hccss":function(){define("dijit/hccss",["require","dojo/_base/config","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/ready","dojo/_base/sniff","dojo/_base/window"],function(_fbc,_fbd,_fbe,_fbf,_fc0,_fc1,has,win){if(has("ie")||has("mozilla")){_fc1(90,function(){var div=_fbf.create("div",{id:"a11yTestNode",style:{cssText:"border: 1px solid;"+"border-color:red green;"+"position: absolute;"+"height: 5px;"+"top: -999px;"+"background-image: url(\""+(_fbd.blankGif||_fbc.toUrl("dojo/resources/blank.gif"))+"\");"}},win.body());var cs=_fc0.getComputedStyle(div);if(cs){var _fc2=cs.backgroundImage;var _fc3=(cs.borderTopColor==cs.borderRightColor)||(_fc2!=null&&(_fc2=="none"||_fc2=="url(invalid-url:)"));if(_fc3){_fbe.add(win.body(),"dijit_a11y");}if(has("ie")){div.outerHTML="";}else{win.body().removeChild(div);}}});}});},"dijit/form/HorizontalRuleLabels":function(){define("dijit/form/HorizontalRuleLabels",["dojo/_base/declare","dojo/number","dojo/query","./HorizontalRule"],function(_fc4,_fc5,_fc6,_fc7){return _fc4("dijit.form.HorizontalRuleLabels",_fc7,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){return pos;},_genHTML:function(pos,ndx){return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._labelPrefix+this.labels[ndx]+this._suffix;},getLabels:function(){var _fc8=this.labels;if(!_fc8.length){_fc8=_fc6("> li",this.srcNodeRef).map(function(node){return String(node.innerHTML);});}this.srcNodeRef.innerHTML="";if(!_fc8.length&&this.count>1){var _fc9=this.minimum;var inc=(this.maximum-_fc9)/(this.count-1);for(var i=0;i<this.count;i++){_fc8.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_fc5.format(_fc9,this.constraints));_fc9+=inc;}}return _fc8;},postMixInProperties:function(){this.inherited(arguments);this.labels=this.getLabels();this.count=this.labels.length;}});});},"dijit/Editor":function(){define("dijit/Editor",["dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/_base/sniff","dojo/string","dojo/topic","dojo/_base/window","./_base/focus","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText",".","dojo/i18n!./_editor/nls/commands"],function(_fca,_fcb,_fcc,i18n,_fcd,_fce,_fcf,_fd0,_fd1,keys,lang,has,_fd2,_fd3,win,_fd4,_fd5,_fd6,_fd7,_fd8,_fd9,_fda,_fdb,html,_fdc,_fdd,_fde){var _fdf=_fcb("dijit.Editor",_fdd,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_fdb];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _fcc();this.inherited(arguments);},postCreate:function(){this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.inherited(arguments);this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(!this.toolbar){this.toolbar=new _fd6({dir:this.dir,lang:this.lang});this.header.appendChild(this.toolbar.domNode);}_fca.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.callback(true);_fce.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_fce.add(this.iframe,"dijitEditorIFrame");_fcd.set(this.iframe,"allowTransparency",true);if(has("webkit")){_fd0.set(this.domNode,"KhtmlUserSelect","none");}this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){_fca.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_fe0,_fe1){var args=lang.isString(_fe0)?{name:_fe0}:lang.isFunction(_fe0)?{ctor:_fe0}:_fe0;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_fda.registry[args.name]){o.plugin=_fda.registry[args.name](args);}else{_fd3.publish(_fde._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){var pc=args.ctor||lang.getObject(args.name);if(pc){o.plugin=new pc(args);}}if(!o.plugin){console.warn("Cannot find plugin",_fe0);return;}_fe0=o.plugin;}if(arguments.length>1){this._plugins[_fe1]=_fe0;}else{this._plugins.push(_fe0);}_fe0.setEditor(this);if(lang.isFunction(_fe0.setToolbar)){_fe0.setToolbar(this.toolbar);}},resize:function(size){if(size){_fd8.prototype.resize.apply(this,arguments);}},layout:function(){var _fe2=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_fcf.getPadBorderExtents(this.iframe.parentNode).h+_fcf.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_fe2+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _fe3;var b=this.document.body;var _fe4=b.clientWidth;var _fe5=b.clientHeight;var _fe6=b.clientLeft;var _fe7=b.offsetWidth;var _fe8=b.offsetHeight;var _fe9=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_fe4<_fe7&&e.x>_fe4&&e.x<_fe7){_fe3=true;}}else{if(e.x<_fe6&&e.x>_fe9){_fe3=true;}}if(!_fe3){if(_fe5<_fe8&&e.y>_fe5&&e.y<_fe8){_fe3=true;}}if(!_fe3){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){setTimeout(lang.hitch(this,"placeCursorAtEnd"),0);}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){clearTimeout(this._editTimer);}this._editTimer=setTimeout(lang.hitch(this,this.endEditing),this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {code:1011};}}catch(e){if(e.code==1011){var sub=_fd2.substitute,_fea={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_fea[cmd]])]));}r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _feb=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,_fec,_fed,sel;if(mark){if(has("ie")<9){if(lang.isArray(mark)){_feb=[];_fca.forEach(mark,function(n){_feb.push(_fdc.getNode(n,this.editNode));},this);win.withGlobal(this.window,"moveToBookmark",_fde,[{mark:_feb,isCollapsed:col}]);}else{if(mark.startContainer&&mark.endContainer){sel=_fdc.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_fdc.create(this.window);_fec=_fdc.getNode(mark.startContainer,this.editNode);_fed=_fdc.getNode(mark.endContainer,this.editNode);if(_fec&&_fed){r.setStart(_fec,mark.startOffset);r.setEnd(_fed,mark.endOffset);sel.addRange(r);}}}}}else{sel=_fdc.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_fdc.create(this.window);_fec=_fdc.getNode(mark.startContainer,this.editNode);_fed=_fdc.getNode(mark.endContainer,this.editNode);if(_fec&&_fed){r.setStart(_fec,mark.startOffset);r.setEnd(_fed,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_fee){if(this._editTimer){clearTimeout(this._editTimer);}if(this._inEditing){this._endEditing(_fee);this._inEditing=false;}},_getBookmark:function(){var b=win.withGlobal(this.window,_fd4.getBookmark);var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9){var sel=_fdc.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var _fef;if(sel.rangeCount){_fef=sel.getRangeAt(0);}if(_fef){b.mark=_fef.cloneRange();}else{b.mark=win.withGlobal(this.window,_fd4.getBookmark);}}}else{_fca.forEach(b.mark,function(n){tmp.push(_fdc.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_fdc.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_fdc.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.altKey){if(k==90||k==122){_fd1.stop(e);this.undo();return;}else{if(k==89||k==121){_fd1.stop(e);this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");setTimeout(lang.hitch(this,this.endEditing),1);}else{this.beginEditing("paste");setTimeout(lang.hitch(this,this.endEditing),1);}break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(win.withGlobal(this.window,"isCollapsed",_fde)){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(_ff0){var _ff1=lang.hitch(this,function(){if((!this.disabled&&_ff0)||(!this._buttonEnabledPlugins&&_ff0)){_fca.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!_ff0){_fca.forEach(this._plugins,function(p){p.set("disabled",false);});}}});this.setValueDeferred.addCallback(_ff1);this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_fd0.set(this.document.body,"color",_fd0.get(this.iframe,"color"));}}catch(e){}}});function _ff2(args){return new _fda({command:args.name});};function _ff3(args){return new _fda({buttonClass:_fd9,command:args.name});};lang.mixin(_fda.registry,{"undo":_ff2,"redo":_ff2,"cut":_ff2,"copy":_ff2,"paste":_ff2,"insertOrderedList":_ff2,"insertUnorderedList":_ff2,"indent":_ff2,"outdent":_ff2,"justifyCenter":_ff2,"justifyFull":_ff2,"justifyLeft":_ff2,"justifyRight":_ff2,"delete":_ff2,"selectAll":_ff2,"removeFormat":_ff2,"unlink":_ff2,"insertHorizontalRule":_ff2,"bold":_ff3,"italic":_ff3,"underline":_ff3,"strikethrough":_ff3,"subscript":_ff3,"superscript":_ff3,"|":function(){return new _fda({button:new _fd7(),setEditor:function(_ff4){this.editor=_ff4;}});}});return _fdf;});},"dojox/grid/Selection":function(){define("dojox/grid/Selection",["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_ff5,_ff6,lang,_ff7){return _ff5("dojox.grid.Selection",null,{constructor:function(_ff8){this.grid=_ff8;this.selected=[];this.setMode(_ff8.selectionMode);},mode:"extended",selected:null,updating:0,selectedIndex:-1,setMode:function(mode){if(this.selected.length){this.deselectAll();}if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){this.mode="extended";}else{this.mode=mode;}},onCanSelect:function(_ff9){return this.grid.onCanSelect(_ff9);},onCanDeselect:function(_ffa){return this.grid.onCanDeselect(_ffa);},onSelected:function(_ffb){},onDeselected:function(_ffc){},onChanging:function(){},onChanged:function(){},isSelected:function(_ffd){if(this.mode=="none"){return false;}return this.selected[_ffd];},getFirstSelected:function(){if(!this.selected.length||this.mode=="none"){return -1;}for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getNextSelected:function(_ffe){if(this.mode=="none"){return -1;}for(var i=_ffe+1,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getSelected:function(){var _fff=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_fff.push(i);}}return _fff;},getSelectedCount:function(){var c=0;for(var i=0;i<this.selected.length;i++){if(this.selected[i]){c++;}}return c;},_beginUpdate:function(){if(this.updating===0){this.onChanging();}this.updating++;},_endUpdate:function(){this.updating--;if(this.updating===0){this.onChanged();}},select:function(_1000){if(this.mode=="none"){return;}if(this.mode!="multiple"){this.deselectAll(_1000);this.addToSelection(_1000);}else{this.toggleSelect(_1000);}},addToSelection:function(_1001){if(this.mode=="none"){return;}if(lang.isArray(_1001)){_ff6.forEach(_1001,this.addToSelection,this);return;}_1001=Number(_1001);if(this.selected[_1001]){this.selectedIndex=_1001;}else{if(this.onCanSelect(_1001)!==false){this.selectedIndex=_1001;var _1002=this.grid.getRowNode(_1001);if(_1002){_ff7.set(_1002,"aria-selected","true");}this._beginUpdate();this.selected[_1001]=true;this.onSelected(_1001);this._endUpdate();}}},deselect:function(_1003){if(this.mode=="none"){return;}if(lang.isArray(_1003)){_ff6.forEach(_1003,this.deselect,this);return;}_1003=Number(_1003);if(this.selectedIndex==_1003){this.selectedIndex=-1;}if(this.selected[_1003]){if(this.onCanDeselect(_1003)===false){return;}var _1004=this.grid.getRowNode(_1003);if(_1004){_ff7.set(_1004,"aria-selected","false");}this._beginUpdate();delete this.selected[_1003];this.onDeselected(_1003);this._endUpdate();}},setSelected:function(_1005,_1006){this[(_1006?"addToSelection":"deselect")](_1005);},toggleSelect:function(_1007){if(lang.isArray(_1007)){_ff6.forEach(_1007,this.toggleSelect,this);return;}this.setSelected(_1007,!this.selected[_1007]);},_range:function(_1008,inTo,func){var s=(_1008>=0?_1008:inTo),e=inTo;if(s>e){e=s;s=inTo;}for(var i=s;i<=e;i++){func(i);}},selectRange:function(_1009,inTo){this._range(_1009,inTo,lang.hitch(this,"addToSelection"));},deselectRange:function(_100a,inTo){this._range(_100a,inTo,lang.hitch(this,"deselect"));},insert:function(_100b){this.selected.splice(_100b,0,false);if(this.selectedIndex>=_100b){this.selectedIndex++;}},remove:function(_100c){this.selected.splice(_100c,1);if(this.selectedIndex>=_100c){this.selectedIndex--;}},deselectAll:function(_100d){for(var i in this.selected){if((i!=_100d)&&(this.selected[i]===true)){this.deselect(i);}}},clickSelect:function(_100e,_100f,_1010){if(this.mode=="none"){return;}this._beginUpdate();if(this.mode!="extended"){this.select(_100e);}else{var _1011=this.selectedIndex;if(!_100f){this.deselectAll(_100e);}if(_1010){this.selectRange(_1011,_100e);}else{if(_100f){this.toggleSelect(_100e);}else{this.addToSelection(_100e);}}}this._endUpdate();},clickSelectEvent:function(e){this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);},clear:function(){this._beginUpdate();this.deselectAll();this._endUpdate();}});});},"dojo/fx/Toggler":function(){define(["../_base/lang","../_base/declare","../_base/fx","../_base/connect"],function(lang,_1012,_1013,_1014){return _1012("dojo.fx.Toggler",null,{node:null,showFunc:_1013.fadeIn,hideFunc:_1013.fadeOut,showDuration:200,hideDuration:200,constructor:function(args){var _1015=this;lang.mixin(_1015,args);_1015.node=args.node;_1015._showArgs=lang.mixin({},args);_1015._showArgs.node=_1015.node;_1015._showArgs.duration=_1015.showDuration;_1015.showAnim=_1015.showFunc(_1015._showArgs);_1015._hideArgs=lang.mixin({},args);_1015._hideArgs.node=_1015.node;_1015._hideArgs.duration=_1015.hideDuration;_1015.hideAnim=_1015.hideFunc(_1015._hideArgs);_1014.connect(_1015.showAnim,"beforeBegin",lang.hitch(_1015.hideAnim,"stop",true));_1014.connect(_1015.hideAnim,"beforeBegin",lang.hitch(_1015.showAnim,"stop",true));},show:function(delay){return this.showAnim.play(delay||0);},hide:function(delay){return this.hideAnim.play(delay||0);}});});},"dijit/popup":function(){define("dijit/popup",["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window","./place","./BackgroundIframe","."],function(array,_1016,_1017,_1018,dom,_1019,_101a,_101b,_101c,event,keys,lang,on,has,win,place,_101d,dijit){var _101e=_1018(null,{_stack:[],_beginZIndex:1000,_idGen:1,_createWrapper:function(_101f){var _1020=_101f._popupWrapper,node=_101f.domNode;if(!_1020){_1020=_101a.create("div",{"class":"dijitPopup",style:{display:"none"},role:"presentation"},win.body());_1020.appendChild(node);var s=node.style;s.display="";s.visibility="";s.position="";s.top="0px";_101f._popupWrapper=_1020;_1016.after(_101f,"destroy",function(){_101a.destroy(_1020);delete _101f._popupWrapper;});}return _1020;},moveOffScreen:function(_1021){var _1022=this._createWrapper(_1021);_101c.set(_1022,{visibility:"hidden",top:"-9999px",display:""});},hide:function(_1023){var _1024=this._createWrapper(_1023);_101c.set(_1024,"display","none");},getTopPopup:function(){var stack=this._stack;for(var pi=stack.length-1;pi>0&&stack[pi].parent===stack[pi-1].widget;pi--){}return stack[pi];},open:function(args){var stack=this._stack,_1025=args.popup,_1026=args.orient||["below","below-alt","above","above-alt"],ltr=args.parent?args.parent.isLeftToRight():_101b.isBodyLtr(),_1027=args.around,id=(args.around&&args.around.id)?(args.around.id+"_dropdown"):("popup_"+this._idGen++);while(stack.length&&(!args.parent||!dom.isDescendant(args.parent.domNode,stack[stack.length-1].widget.domNode))){this.close(stack[stack.length-1].widget);}var _1028=this._createWrapper(_1025);_1019.set(_1028,{id:id,style:{zIndex:this._beginZIndex+stack.length},"class":"dijitPopup "+(_1025.baseClass||_1025["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:args.parent?args.parent.id:""});if(has("ie")||has("mozilla")){if(!_1025.bgIframe){_1025.bgIframe=new _101d(_1028);}}var best=_1027?place.around(_1028,_1027,_1026,ltr,_1025.orient?lang.hitch(_1025,"orient"):null):place.at(_1028,args,_1026=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],args.padding);_1028.style.display="";_1028.style.visibility="visible";_1025.domNode.style.visibility="visible";var _1029=[];_1029.push(on(_1028,_1017._keypress,lang.hitch(this,function(evt){if(evt.charOrCode==keys.ESCAPE&&args.onCancel){event.stop(evt);args.onCancel();}else{if(evt.charOrCode===keys.TAB){event.stop(evt);var _102a=this.getTopPopup();if(_102a&&_102a.onCancel){_102a.onCancel();}}}})));if(_1025.onCancel&&args.onCancel){_1029.push(_1025.on("cancel",args.onCancel));}_1029.push(_1025.on(_1025.onExecute?"execute":"change",lang.hitch(this,function(){var _102b=this.getTopPopup();if(_102b&&_102b.onExecute){_102b.onExecute();}})));stack.push({widget:_1025,parent:args.parent,onExecute:args.onExecute,onCancel:args.onCancel,onClose:args.onClose,handlers:_1029});if(_1025.onOpen){_1025.onOpen(best);}return best;},close:function(popup){var stack=this._stack;while((popup&&array.some(stack,function(elem){return elem.widget==popup;}))||(!popup&&stack.length)){var top=stack.pop(),_102c=top.widget,_102d=top.onClose;if(_102c.onClose){_102c.onClose();}var h;while(h=top.handlers.pop()){h.remove();}if(_102c&&_102c.domNode){this.hide(_102c);}if(_102d){_102d();}}}});return (dijit.popup=new _101e());});},"dojo/data/ItemFileWriteStore":function(){define(["../_base/lang","../_base/declare","../_base/array","../_base/json","../_base/window","./ItemFileReadStore","../date/stamp"],function(lang,_102e,_102f,_1030,_1031,_1032,_1033){return _102e("dojo.data.ItemFileWriteStore",_1032,{constructor:function(_1034){this._features["dojo.data.api.Write"]=true;this._features["dojo.data.api.Notification"]=true;this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};if(!this._datatypeMap["Date"].serialize){this._datatypeMap["Date"].serialize=function(obj){return _1033.toISOString(obj,{zulu:true});};}if(_1034&&(_1034.referenceIntegrity===false)){this.referenceIntegrity=false;}this._saveInProgress=false;},referenceIntegrity:true,_assert:function(_1035){if(!_1035){throw new Error("assertion failed in ItemFileWriteStore");}},_getIdentifierAttribute:function(){return this.getFeatures()["dojo.data.api.Identity"];},newItem:function(_1036,_1037){this._assert(!this._saveInProgress);if(!this._loadFinished){this._forceLoad();}if(typeof _1036!="object"&&typeof _1036!="undefined"){throw new Error("newItem() was passed something other than an object");}var _1038=null;var _1039=this._getIdentifierAttribute();if(_1039===Number){_1038=this._arrayOfAllItems.length;}else{_1038=_1036[_1039];if(typeof _1038==="undefined"){throw new Error("newItem() was not passed an identity for the new item");}if(lang.isArray(_1038)){throw new Error("newItem() was not passed an single-valued identity");}}if(this._itemsByIdentity){this._assert(typeof this._itemsByIdentity[_1038]==="undefined");}this._assert(typeof this._pending._newItems[_1038]==="undefined");this._assert(typeof this._pending._deletedItems[_1038]==="undefined");var _103a={};_103a[this._storeRefPropName]=this;_103a[this._itemNumPropName]=this._arrayOfAllItems.length;if(this._itemsByIdentity){this._itemsByIdentity[_1038]=_103a;_103a[_1039]=[_1038];}this._arrayOfAllItems.push(_103a);var pInfo=null;if(_1037&&_1037.parent&&_1037.attribute){pInfo={item:_1037.parent,attribute:_1037.attribute,oldValue:undefined};var _103b=this.getValues(_1037.parent,_1037.attribute);if(_103b&&_103b.length>0){var _103c=_103b.slice(0,_103b.length);if(_103b.length===1){pInfo.oldValue=_103b[0];}else{pInfo.oldValue=_103b.slice(0,_103b.length);}_103c.push(_103a);this._setValueOrValues(_1037.parent,_1037.attribute,_103c,false);pInfo.newValue=this.getValues(_1037.parent,_1037.attribute);}else{this._setValueOrValues(_1037.parent,_1037.attribute,_103a,false);pInfo.newValue=_103a;}}else{_103a[this._rootItemPropName]=true;this._arrayOfTopLevelItems.push(_103a);}this._pending._newItems[_1038]=_103a;for(var key in _1036){if(key===this._storeRefPropName||key===this._itemNumPropName){throw new Error("encountered bug in ItemFileWriteStore.newItem");}var value=_1036[key];if(!lang.isArray(value)){value=[value];}_103a[key]=value;if(this.referenceIntegrity){for(var i=0;i<value.length;i++){var val=value[i];if(this.isItem(val)){this._addReferenceToMap(val,_103a,key);}}}}this.onNew(_103a,pInfo);return _103a;},_removeArrayElement:function(array,_103d){var index=_102f.indexOf(array,_103d);if(index!=-1){array.splice(index,1);return true;}return false;},deleteItem:function(item){this._assert(!this._saveInProgress);this._assertIsItem(item);var _103e=item[this._itemNumPropName];var _103f=this.getIdentity(item);if(this.referenceIntegrity){var _1040=this.getAttributes(item);if(item[this._reverseRefMap]){item["backup_"+this._reverseRefMap]=lang.clone(item[this._reverseRefMap]);}_102f.forEach(_1040,function(_1041){_102f.forEach(this.getValues(item,_1041),function(value){if(this.isItem(value)){if(!item["backupRefs_"+this._reverseRefMap]){item["backupRefs_"+this._reverseRefMap]=[];}item["backupRefs_"+this._reverseRefMap].push({id:this.getIdentity(value),attr:_1041});this._removeReferenceFromMap(value,item,_1041);}},this);},this);var _1042=item[this._reverseRefMap];if(_1042){for(var _1043 in _1042){var _1044=null;if(this._itemsByIdentity){_1044=this._itemsByIdentity[_1043];}else{_1044=this._arrayOfAllItems[_1043];}if(_1044){for(var _1045 in _1042[_1043]){var _1046=this.getValues(_1044,_1045)||[];var _1047=_102f.filter(_1046,function(_1048){return !(this.isItem(_1048)&&this.getIdentity(_1048)==_103f);},this);this._removeReferenceFromMap(item,_1044,_1045);if(_1047.length<_1046.length){this._setValueOrValues(_1044,_1045,_1047,true);}}}}}}this._arrayOfAllItems[_103e]=null;item[this._storeRefPropName]=null;if(this._itemsByIdentity){delete this._itemsByIdentity[_103f];}this._pending._deletedItems[_103f]=item;if(item[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,item);}this.onDelete(item);return true;},setValue:function(item,_1049,value){return this._setValueOrValues(item,_1049,value,true);},setValues:function(item,_104a,_104b){return this._setValueOrValues(item,_104a,_104b,true);},unsetAttribute:function(item,_104c){return this._setValueOrValues(item,_104c,[],true);},_setValueOrValues:function(item,_104d,_104e,_104f){this._assert(!this._saveInProgress);this._assertIsItem(item);this._assert(lang.isString(_104d));this._assert(typeof _104e!=="undefined");var _1050=this._getIdentifierAttribute();if(_104d==_1050){throw new Error("ItemFileWriteStore does not have support for changing the value of an item's identifier.");}var _1051=this._getValueOrValues(item,_104d);var _1052=this.getIdentity(item);if(!this._pending._modifiedItems[_1052]){var _1053={};for(var key in item){if((key===this._storeRefPropName)||(key===this._itemNumPropName)||(key===this._rootItemPropName)){_1053[key]=item[key];}else{if(key===this._reverseRefMap){_1053[key]=lang.clone(item[key]);}else{_1053[key]=item[key].slice(0,item[key].length);}}}this._pending._modifiedItems[_1052]=_1053;}var _1054=false;if(lang.isArray(_104e)&&_104e.length===0){_1054=delete item[_104d];_104e=undefined;if(this.referenceIntegrity&&_1051){var _1055=_1051;if(!lang.isArray(_1055)){_1055=[_1055];}for(var i=0;i<_1055.length;i++){var value=_1055[i];if(this.isItem(value)){this._removeReferenceFromMap(value,item,_104d);}}}}else{var _1056;if(lang.isArray(_104e)){_1056=_104e.slice(0,_104e.length);}else{_1056=[_104e];}if(this.referenceIntegrity){if(_1051){var _1055=_1051;if(!lang.isArray(_1055)){_1055=[_1055];}var map={};_102f.forEach(_1055,function(_1057){if(this.isItem(_1057)){var id=this.getIdentity(_1057);map[id.toString()]=true;}},this);_102f.forEach(_1056,function(_1058){if(this.isItem(_1058)){var id=this.getIdentity(_1058);if(map[id.toString()]){delete map[id.toString()];}else{this._addReferenceToMap(_1058,item,_104d);}}},this);for(var rId in map){var _1059;if(this._itemsByIdentity){_1059=this._itemsByIdentity[rId];}else{_1059=this._arrayOfAllItems[rId];}this._removeReferenceFromMap(_1059,item,_104d);}}else{for(var i=0;i<_1056.length;i++){var value=_1056[i];if(this.isItem(value)){this._addReferenceToMap(value,item,_104d);}}}}item[_104d]=_1056;_1054=true;}if(_104f){this.onSet(item,_104d,_1051,_104e);}return _1054;},_addReferenceToMap:function(_105a,_105b,_105c){var _105d=this.getIdentity(_105b);var _105e=_105a[this._reverseRefMap];if(!_105e){_105e=_105a[this._reverseRefMap]={};}var _105f=_105e[_105d];if(!_105f){_105f=_105e[_105d]={};}_105f[_105c]=true;},_removeReferenceFromMap:function(_1060,_1061,_1062){var _1063=this.getIdentity(_1061);var _1064=_1060[this._reverseRefMap];var _1065;if(_1064){for(_1065 in _1064){if(_1065==_1063){delete _1064[_1065][_1062];if(this._isEmpty(_1064[_1065])){delete _1064[_1065];}}}if(this._isEmpty(_1064)){delete _1060[this._reverseRefMap];}}},_dumpReferenceMap:function(){var i;for(i=0;i<this._arrayOfAllItems.length;i++){var item=this._arrayOfAllItems[i];if(item&&item[this._reverseRefMap]){}}},_getValueOrValues:function(item,_1066){var _1067=undefined;if(this.hasAttribute(item,_1066)){var _1068=this.getValues(item,_1066);if(_1068.length==1){_1067=_1068[0];}else{_1067=_1068;}}return _1067;},_flatten:function(value){if(this.isItem(value)){return {_reference:this.getIdentity(value)};}else{if(typeof value==="object"){for(var type in this._datatypeMap){var _1069=this._datatypeMap[type];if(lang.isObject(_1069)&&!lang.isFunction(_1069)){if(value instanceof _1069.type){if(!_1069.serialize){throw new Error("ItemFileWriteStore:  No serializer defined for type mapping: ["+type+"]");}return {_type:type,_value:_1069.serialize(value)};}}else{if(value instanceof _1069){return {_type:type,_value:value.toString()};}}}}return value;}},_getNewFileContentString:function(){var _106a={};var _106b=this._getIdentifierAttribute();if(_106b!==Number){_106a.identifier=_106b;}if(this._labelAttr){_106a.label=this._labelAttr;}_106a.items=[];for(var i=0;i<this._arrayOfAllItems.length;++i){var item=this._arrayOfAllItems[i];if(item!==null){var _106c={};for(var key in item){if(key!==this._storeRefPropName&&key!==this._itemNumPropName&&key!==this._reverseRefMap&&key!==this._rootItemPropName){var _106d=this.getValues(item,key);if(_106d.length==1){_106c[key]=this._flatten(_106d[0]);}else{var _106e=[];for(var j=0;j<_106d.length;++j){_106e.push(this._flatten(_106d[j]));_106c[key]=_106e;}}}}_106a.items.push(_106c);}}var _106f=true;return _1030.toJson(_106a,_106f);},_isEmpty:function(_1070){var empty=true;if(lang.isObject(_1070)){var i;for(i in _1070){empty=false;break;}}else{if(lang.isArray(_1070)){if(_1070.length>0){empty=false;}}}return empty;},save:function(_1071){this._assert(!this._saveInProgress);this._saveInProgress=true;var self=this;var _1072=function(){self._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};self._saveInProgress=false;if(_1071&&_1071.onComplete){var scope=_1071.scope||_1031.global;_1071.onComplete.call(scope);}};var _1073=function(err){self._saveInProgress=false;if(_1071&&_1071.onError){var scope=_1071.scope||_1031.global;_1071.onError.call(scope,err);}};if(this._saveEverything){var _1074=this._getNewFileContentString();this._saveEverything(_1072,_1073,_1074);}if(this._saveCustom){this._saveCustom(_1072,_1073);}if(!this._saveEverything&&!this._saveCustom){_1072();}},revert:function(){this._assert(!this._saveInProgress);var _1075;for(_1075 in this._pending._modifiedItems){var _1076=this._pending._modifiedItems[_1075];var _1077=null;if(this._itemsByIdentity){_1077=this._itemsByIdentity[_1075];}else{_1077=this._arrayOfAllItems[_1075];}_1076[this._storeRefPropName]=this;for(var key in _1077){delete _1077[key];}lang.mixin(_1077,_1076);}var _1078;for(_1075 in this._pending._deletedItems){_1078=this._pending._deletedItems[_1075];_1078[this._storeRefPropName]=this;var index=_1078[this._itemNumPropName];if(_1078["backup_"+this._reverseRefMap]){_1078[this._reverseRefMap]=_1078["backup_"+this._reverseRefMap];delete _1078["backup_"+this._reverseRefMap];}this._arrayOfAllItems[index]=_1078;if(this._itemsByIdentity){this._itemsByIdentity[_1075]=_1078;}if(_1078[this._rootItemPropName]){this._arrayOfTopLevelItems.push(_1078);}}for(_1075 in this._pending._deletedItems){_1078=this._pending._deletedItems[_1075];if(_1078["backupRefs_"+this._reverseRefMap]){_102f.forEach(_1078["backupRefs_"+this._reverseRefMap],function(_1079){var _107a;if(this._itemsByIdentity){_107a=this._itemsByIdentity[_1079.id];}else{_107a=this._arrayOfAllItems[_1079.id];}this._addReferenceToMap(_107a,_1078,_1079.attr);},this);delete _1078["backupRefs_"+this._reverseRefMap];}}for(_1075 in this._pending._newItems){var _107b=this._pending._newItems[_1075];_107b[this._storeRefPropName]=null;this._arrayOfAllItems[_107b[this._itemNumPropName]]=null;if(_107b[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,_107b);}if(this._itemsByIdentity){delete this._itemsByIdentity[_1075];}}this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};return true;},isDirty:function(item){if(item){var _107c=this.getIdentity(item);return new Boolean(this._pending._newItems[_107c]||this._pending._modifiedItems[_107c]||this._pending._deletedItems[_107c]).valueOf();}else{return !this._isEmpty(this._pending._newItems)||!this._isEmpty(this._pending._modifiedItems)||!this._isEmpty(this._pending._deletedItems);}},onSet:function(item,_107d,_107e,_107f){},onNew:function(_1080,_1081){},onDelete:function(_1082){},close:function(_1083){if(this.clearOnClose){if(!this.isDirty()){this.inherited(arguments);}else{throw new Error("dojo.data.ItemFileWriteStore: There are unsaved changes present in the store.  Please save or revert the changes before invoking close.");}}}});});},"dijit/layout/TabContainer":function(){define("dijit/layout/TabContainer",["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_1084,_1085,_1086,_1087){return _1084("dijit.layout.TabContainer",_1085,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_1088){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_1086=lang.getObject(this.controllerWidget);return new _1086({id:this.id+"_tablist",dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_1088);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?"dijit.layout.ScrollingTabController":"dijit.layout.TabController";}}});});},"dijit/_base":function(){define("dijit/_base",[".","./a11y","./WidgetSet","./_base/focus","./_base/manager","./_base/place","./_base/popup","./_base/scroll","./_base/sniff","./_base/typematic","./_base/wai","./_base/window"],function(dijit){return dijit._base;});},"dijit/_editor/plugins/EnterKeyHandling":function(){define("dijit/_editor/plugins/EnterKeyHandling",["dojo/_base/declare","dojo/dom-construct","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range","../selection"],function(_1089,_108a,event,keys,lang,has,win,_108b,_108c,_108d,_108e,_108f){return _1089("dijit._editor.plugins.EnterKeyHandling",_108c,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_1090){if(this.editor===_1090){return;}this.editor=_1090;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_1090.onLoadDeferred.addCallback(lang.hitch(this,function(d){this.connect(_1090.document,"onkeypress",function(e){if(e.charOrCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){event.stop(e);}}});return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,this.handleEnterKey);_1090.addKeyHandler(13,0,0,h);_1090.addKeyHandler(13,0,1,h);this.connect(this.editor,"onKeyPressed","onKeyPressed");}}},onKeyPressed:function(){if(this._checkListLater){if(win.withGlobal(this.editor.window,"isCollapsed",dijit)){var _1091=win.withGlobal(this.editor.window,"getAncestorElement",_1092,["LI"]);if(!_1091){_108d.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var block=win.withGlobal(this.editor.window,"getAncestorElement",_1092,[this.blockNodeForEnter]);if(block){block.innerHTML=this.bogusHtmlContent;if(has("ie")){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_1091.parentNode.parentNode.nodeName=="LI"){_1091=_1091.parentNode.parentNode;}}var fc=_1091.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_1091.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _1093=_108e.create(this.editor.window);_1093.setStart(_1091.firstChild,0);var _1092=_108e.getSelection(this.editor.window,true);_1092.removeAllRanges();_1092.addRange(_1093);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _1094,range,_1095,_1096,_1097,_1098,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _1099=win.withGlobal(this.editor.window,"getParentElement",_108f);var _109a=_108e.getAncestor(_1099,this.blockNodes);if(_109a){if(_109a.tagName=="LI"){return true;}_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);if(!range.collapsed){range.deleteContents();_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);}if(_108e.atBeginningOfContainer(_109a,range.startContainer,range.startOffset)){br=doc.createElement("br");_1095=_108e.create(this.editor.window);_109a.insertBefore(br,_109a.firstChild);_1095.setStartAfter(br);_1094.removeAllRanges();_1094.addRange(_1095);}else{if(_108e.atEndOfContainer(_109a,range.startContainer,range.startOffset)){_1095=_108e.create(this.editor.window);br=doc.createElement("br");_109a.appendChild(br);_109a.appendChild(doc.createTextNode(" "));_1095.setStart(_109a.lastChild,0);_1094.removeAllRanges();_1094.addRange(_1095);}else{rs=range.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;win.withGlobal(this.editor.window,function(){_1096=doc.createTextNode(txt.substring(0,range.startOffset));_1097=doc.createTextNode(txt.substring(range.startOffset));_1098=doc.createElement("br");if(_1097.nodeValue==""&&has("webkit")){_1097=doc.createTextNode(" ");}_108a.place(_1096,rs,"after");_108a.place(_1098,_1096,"after");_108a.place(_1097,_1098,"after");_108a.destroy(rs);_1095=_108e.create();_1095.setStart(_1097,0);_1094.removeAllRanges();_1094.addRange(_1095);});return false;}return true;}}}else{_1094=_108e.getSelection(this.editor.window);if(_1094.rangeCount){range=_1094.getRangeAt(0);if(range&&range.startContainer){if(!range.collapsed){range.deleteContents();_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);}rs=range.startContainer;if(rs&&rs.nodeType==3){win.withGlobal(this.editor.window,lang.hitch(this,function(){var _109b=false;var _109c=range.startOffset;if(rs.length<_109c){ret=this._adjustNodeAndOffset(rs,_109c);rs=ret.node;_109c=ret.offset;}txt=rs.nodeValue;_1096=doc.createTextNode(txt.substring(0,_109c));_1097=doc.createTextNode(txt.substring(_109c));_1098=doc.createElement("br");if(!_1097.length){_1097=doc.createTextNode(" ");_109b=true;}if(_1096.length){_108a.place(_1096,rs,"after");}else{_1096=rs;}_108a.place(_1098,_1096,"after");_108a.place(_1097,_1098,"after");_108a.destroy(rs);_1095=_108e.create();_1095.setStart(_1097,0);_1095.setEnd(_1097,_1097.length);_1094.removeAllRanges();_1094.addRange(_1095);if(_109b&&!has("webkit")){_108f.remove();}else{_108f.collapse(true);}}));}else{var _109d;if(range.startOffset>=0){_109d=rs.childNodes[range.startOffset];}win.withGlobal(this.editor.window,lang.hitch(this,function(){var _109e=doc.createElement("br");var _109f=doc.createTextNode(" ");if(!_109d){rs.appendChild(_109e);rs.appendChild(_109f);}else{_108a.place(_109e,_109d,"before");_108a.place(_109f,_109e,"after");}_1095=_108e.create(win.global);_1095.setStart(_109f,0);_1095.setEnd(_109f,_109f.length);_1094.removeAllRanges();_1094.addRange(_1095);_108f.collapse(true);}));}}}else{_108d.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _10a0=true;_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);if(!range.collapsed){range.deleteContents();_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);}var block=_108e.getBlockAncestor(range.endContainer,null,this.editor.editNode);var _10a1=block.blockNode;if((this._checkListLater=(_10a1&&(_10a1.nodeName=="LI"||_10a1.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_10a1;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_10a1.innerHTML)){_10a1.innerHTML="";if(has("webkit")){_1095=_108e.create(this.editor.window);_1095.setStart(_10a1,0);_1094.removeAllRanges();_1094.addRange(_1095);}this._checkListLater=false;}return true;}if(!block.blockNode||block.blockNode===this.editor.editNode){try{_108d.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}block={blockNode:win.withGlobal(this.editor.window,"getAncestorElement",_108f,[this.blockNodeForEnter]),blockContainer:this.editor.editNode};if(block.blockNode){if(block.blockNode!=this.editor.editNode&&(!(block.blockNode.textContent||block.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(block.blockNode);return false;}}else{block.blockNode=this.editor.editNode;}_1094=_108e.getSelection(this.editor.window);range=_1094.getRangeAt(0);}var _10a2=doc.createElement(this.blockNodeForEnter);_10a2.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(block.blockNode);var _10a3=range.endOffset;var node=range.endContainer;if(node.length<_10a3){var ret=this._adjustNodeAndOffset(node,_10a3);node=ret.node;_10a3=ret.offset;}if(_108e.atEndOfContainer(block.blockNode,node,_10a3)){if(block.blockNode===block.blockContainer){block.blockNode.appendChild(_10a2);}else{_108a.place(_10a2,block.blockNode,"after");}_10a0=false;_1095=_108e.create(this.editor.window);_1095.setStart(_10a2,0);_1094.removeAllRanges();_1094.addRange(_1095);if(this.editor.height){_108b.scrollIntoView(_10a2);}}else{if(_108e.atBeginningOfContainer(block.blockNode,range.startContainer,range.startOffset)){_108a.place(_10a2,block.blockNode,block.blockNode===block.blockContainer?"first":"before");if(_10a2.nextSibling&&this.editor.height){_1095=_108e.create(this.editor.window);_1095.setStart(_10a2.nextSibling,0);_1094.removeAllRanges();_1094.addRange(_1095);_108b.scrollIntoView(_10a2.nextSibling);}_10a0=false;}else{if(block.blockNode===block.blockContainer){block.blockNode.appendChild(_10a2);}else{_108a.place(_10a2,block.blockNode,"after");}_10a0=false;if(block.blockNode.style){if(_10a2.style){if(block.blockNode.style.cssText){_10a2.style.cssText=block.blockNode.style.cssText;}}}rs=range.startContainer;var _10a4;if(rs&&rs.nodeType==3){var _10a5,tNode;_10a3=range.endOffset;if(rs.length<_10a3){ret=this._adjustNodeAndOffset(rs,_10a3);rs=ret.node;_10a3=ret.offset;}txt=rs.nodeValue;_1096=doc.createTextNode(txt.substring(0,_10a3));_1097=doc.createTextNode(txt.substring(_10a3,txt.length));_108a.place(_1096,rs,"before");_108a.place(_1097,rs,"after");_108a.destroy(rs);var _10a6=_1096.parentNode;while(_10a6!==block.blockNode){var tg=_10a6.tagName;var newTg=doc.createElement(tg);if(_10a6.style){if(newTg.style){if(_10a6.style.cssText){newTg.style.cssText=_10a6.style.cssText;}}}if(_10a6.tagName==="FONT"){if(_10a6.color){newTg.color=_10a6.color;}if(_10a6.face){newTg.face=_10a6.face;}if(_10a6.size){newTg.size=_10a6.size;}}_10a5=_1097;while(_10a5){tNode=_10a5.nextSibling;newTg.appendChild(_10a5);_10a5=tNode;}_108a.place(newTg,_10a6,"after");_1096=_10a6;_1097=newTg;_10a6=_10a6.parentNode;}_10a5=_1097;if(_10a5.nodeType==1||(_10a5.nodeType==3&&_10a5.nodeValue)){_10a2.innerHTML="";}_10a4=_10a5;while(_10a5){tNode=_10a5.nextSibling;_10a2.appendChild(_10a5);_10a5=tNode;}}_1095=_108e.create(this.editor.window);var _10a7;var _10a8=_10a4;if(this.blockNodeForEnter!=="BR"){while(_10a8){_10a7=_10a8;tNode=_10a8.firstChild;_10a8=tNode;}if(_10a7&&_10a7.parentNode){_10a2=_10a7.parentNode;_1095.setStart(_10a2,0);_1094.removeAllRanges();_1094.addRange(_1095);if(this.editor.height){_108b.scrollIntoView(_10a2);}if(has("mozilla")){this._pressedEnterInBlock=block.blockNode;}}else{_10a0=true;}}else{_1095.setStart(_10a2,0);_1094.removeAllRanges();_1094.addRange(_1095);if(this.editor.height){_108b.scrollIntoView(_10a2);}if(has("mozilla")){this._pressedEnterInBlock=block.blockNode;}}}}return _10a0;},_adjustNodeAndOffset:function(node,_10a9){while(node.length<_10a9&&node.nextSibling&&node.nextSibling.nodeType==3){_10a9=_10a9-node.length;node=node.nextSibling;}return {"node":node,"offset":_10a9};},removeTrailingBr:function(_10aa){var para=/P|DIV|LI/i.test(_10aa.tagName)?_10aa:_108f.getParentOfType(_10aa,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_108a.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dojox/charting/themes/PlotKit/base":function(){define("dojox/charting/themes/PlotKit/base",["dojo/_base/kernel","dojo/_base/lang","../../Theme","../common"],function(dojo,lang,Theme,_10ab){var pk=lang.getObject("PlotKit",true,_10ab);pk.base=new Theme({chart:{stroke:null,fill:"yellow"},plotarea:{stroke:null,fill:"yellow"},axis:{stroke:{color:"#fff",width:1},line:{color:"#fff",width:0.5},majorTick:{color:"#fff",width:0.5,length:6},minorTick:{color:"#fff",width:0.5,length:3},tick:{font:"normal normal normal 7pt Helvetica,Arial,sans-serif",fontColor:"#999"}},series:{stroke:{width:2.5,color:"#fff"},fill:"#666",font:"normal normal normal 7.5pt Helvetica,Arial,sans-serif",fontColor:"#666"},marker:{stroke:{width:2},fill:"#333",font:"normal normal normal 7pt Helvetica,Arial,sans-serif",fontColor:"#666"},colors:["red","green","blue"]});pk.base.next=function(_10ac,mixin,_10ad){var theme=Theme.prototype.next.apply(this,arguments);if(_10ac=="line"){theme.marker.outline={width:2,color:"#fff"};theme.series.stroke.width=3.5;theme.marker.stroke.width=2;}else{if(_10ac=="candlestick"){theme.series.stroke.width=1;}else{theme.series.stroke.color="#fff";}}return theme;};return pk;});},"dijit/layout/LinkPane":function(){define("dijit/layout/LinkPane",["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_10ae,_10af,_10b0){return _10b0("dijit.layout.LinkPane",[_10ae,_10af],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){if(this.srcNodeRef){this.title+=this.srcNodeRef.innerHTML;}this.inherited(arguments);},_fillContent:function(){}});});},"dijit/form/_FormValueWidget":function(){define("dijit/form/_FormValueWidget",["dojo/_base/declare","dojo/_base/sniff","./_FormWidget","./_FormValueMixin"],function(_10b1,has,_10b2,_10b3){return _10b1("dijit.form._FormValueWidget",[_10b2,_10b3],{_layoutHackIE7:function(){if(has("ie")==7){var _10b4=this.domNode;var _10b5=_10b4.parentNode;var _10b6=_10b4.firstChild||_10b4;var _10b7=_10b6.style.filter;var _10b8=this;while(_10b5&&_10b5.clientHeight==0){(function ping(){var _10b9=_10b8.connect(_10b5,"onscroll",function(){_10b8.disconnect(_10b9);_10b6.style.filter=(new Date()).getMilliseconds();setTimeout(function(){_10b6.style.filter=_10b7;},0);});})();_10b5=_10b5.parentNode;}}}});});},"dojox/color/Palette":function(){define("dojox/color/Palette",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/array","./_base"],function(dojo,dojox,lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function tRGBA(p,param,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(param=="dr")?item.r+val:item.r,g=(param=="dg")?item.g+val:item.g,b=(param=="db")?item.b+val:item.b,a=(param=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,param,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(param=="dc")?o.c+val:o.c,m=(param=="dm")?o.m+val:o.m,y=(param=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function tCMYK(p,param,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(param=="dc")?o.c+val:o.c,m=(param=="dm")?o.m+val:o.m,y=(param=="dy")?o.y+val:o.y,k=(param=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,param,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(param=="dh")?o.h+val:o.h,s=(param=="ds")?o.s+val:o.s,l=(param=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,param,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(param=="dh")?o.h+val:o.h,s=(param=="ds")?o.s+val:o.s,v=(param=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _10ba(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_10bb){var fn=tRGBA;if(_10bb.use){var use=_10bb.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=tCMYK;}else{fn=tCMY;}}}}else{if("dc" in _10bb||"dm" in _10bb||"dy" in _10bb){if("dk" in _10bb){fn=tCMYK;}else{fn=tCMY;}}else{if("dh" in _10bb||"ds" in _10bb){if("dv" in _10bb){fn=tHSV;}else{fn=tHSL;}}}}var _10bc=this;for(var p in _10bb){if(p=="use"){continue;}_10bc=fn(_10bc,p,_10bb[p]);}return _10bc;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_10ba(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_10ba(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_10bd=args.da||30,hsv=base.toHsv();var baseh=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(baseh-_10bd+360)%360,h2=(baseh+_10bd)%360,s1=Math.max(hsv.s-10,0),s2=_10ba(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dijit/tree/_dndContainer":function(){define("dijit/tree/_dndContainer",["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/_base/lang","dojo/mouse","dojo/on"],function(_10be,_10bf,_10c0,event,lang,mouse,on){return _10bf("dijit.tree._dndContainer",null,{constructor:function(tree,_10c1){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_10c1);this.current=null;this.containerState="";_10c0.add(this.node,"dojoDndContainer");this.events=[on(this.node,mouse.enter,lang.hitch(this,"onOverEvent")),on(this.node,mouse.leave,lang.hitch(this,"onOutEvent")),_10be.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_10be.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart",lang.hitch(event,"stop")),on(this.node,"selectstart",lang.hitch(event,"stop"))];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_10c2){this.current=_10c2;},onMouseOut:function(){this.current=null;},_changeState:function(type,_10c3){var _10c4="dojoDnd"+type;var state=type.toLowerCase()+"State";_10c0.replace(this.node,_10c4+_10c3,_10c4+this[state]);this[state]=_10c3;},_addItemClass:function(node,type){_10c0.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_10c0.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dijit/focus":function(){define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","."],function(_10c5,_10c6,dom,_10c7,_10c8,_10c9,lang,on,ready,has,_10ca,_10cb,win,_10cc,a11y,_10cd,dijit){var _10ce=_10c6([_10ca,_10c9],{curNode:null,activeStack:[],constructor:function(){var check=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_10c5.before(_10c8,"empty",check);_10c5.before(_10c8,"destroy",check);},registerIframe:function(_10cf){return this.registerWin(_10cf.contentWindow,_10cf);},registerWin:function(_10d0,_10d1){var _10d2=this;var _10d3=function(evt){_10d2._justMouseDowned=true;setTimeout(function(){_10d2._justMouseDowned=false;},0);if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){return;}_10d2._onTouchNode(_10d1||evt.target||evt.srcElement,"mouse");};var doc=has("ie")?_10d0.document.documentElement:_10d0.document;if(doc){if(has("ie")){_10d0.document.body.attachEvent("onmousedown",_10d3);var _10d4=function(evt){var tag=evt.srcElement.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.srcElement)){_10d2._onFocusNode(_10d1||evt.srcElement);}else{_10d2._onTouchNode(_10d1||evt.srcElement);}};doc.attachEvent("onactivate",_10d4);var _10d5=function(evt){_10d2._onBlurNode(_10d1||evt.srcElement);};doc.attachEvent("ondeactivate",_10d5);return {remove:function(){_10d0.document.detachEvent("onmousedown",_10d3);doc.detachEvent("onactivate",_10d4);doc.detachEvent("ondeactivate",_10d5);doc=null;}};}else{doc.body.addEventListener("mousedown",_10d3,true);doc.body.addEventListener("touchstart",_10d3,true);var _10d6=function(evt){_10d2._onFocusNode(_10d1||evt.target);};doc.addEventListener("focus",_10d6,true);var _10d7=function(evt){_10d2._onBlurNode(_10d1||evt.target);};doc.addEventListener("blur",_10d7,true);return {remove:function(){doc.body.removeEventListener("mousedown",_10d3,true);doc.body.removeEventListener("touchstart",_10d3,true);doc.removeEventListener("focus",_10d6,true);doc.removeEventListener("blur",_10d7,true);doc=null;}};}}},_onBlurNode:function(){this.set("prevNode",this.curNode);this.set("curNode",null);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);this.prevNode=null;}),100);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _10d8=[];try{while(node){var _10d9=_10c7.get(node,"dijitPopupParent");if(_10d9){node=_10cd.byId(_10d9).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_10cc.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_10da=id&&_10cd.byId(id);if(_10da&&!(by=="mouse"&&_10da.get("disabled"))){_10d8.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_10d8,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("curNode",node);},_setStack:function(_10db,by){var _10dc=this.activeStack;this.set("activeStack",_10db);for(var _10dd=0;_10dd<Math.min(_10dc.length,_10db.length);_10dd++){if(_10dc[_10dd]!=_10db[_10dd]){break;}}var _10de;for(var i=_10dc.length-1;i>=_10dd;i--){_10de=_10cd.byId(_10dc[i]);if(_10de){_10de._hasBeenBlurred=true;_10de.set("focused",false);if(_10de._focusManager==this){_10de._onBlur(by);}this.emit("widget-blur",_10de,by);}}for(i=_10dd;i<_10db.length;i++){_10de=_10cd.byId(_10db[i]);if(_10de){_10de.set("focused",true);if(_10de._focusManager==this){_10de._onFocus(by);}this.emit("widget-focus",_10de,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _10df=new _10ce();ready(function(){var _10e0=_10df.registerWin(win.doc.parentWindow||win.doc.defaultView);if(has("ie")){_10cb.addOnWindowUnload(function(){_10e0.remove();_10e0=null;});}});dijit.focus=function(node){_10df.focus(node);};for(var attr in _10df){if(!/^_/.test(attr)){dijit.focus[attr]=typeof _10df[attr]=="function"?lang.hitch(_10df,attr):_10df[attr];}}_10df.watch(function(attr,_10e1,_10e2){dijit.focus[attr]=_10e2;});return _10df;});},"dojox/charting/plot2d/Grid":function(){define("dojox/charting/plot2d/Grid",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","../Element","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_10e3,hub,arr,_10e4,dc,du,fx){return _10e3("dojox.charting.plot2d.Grid",_10e4,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none",animate:null,enableCache:false},optionalParams:{},constructor:function(chart,_10e5){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_10e5);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;this.animate=this.opt.animate;this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];}},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},initializeScalers:function(){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,_10e6){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_10e7=dim.height-_10e6.b,_10e8=this._hAxis.getScaler().bounds,_10e9=(_10e8.from-_10e8.lower)*_10e8.scale,_10ea=this._vAxis.getScaler().bounds,_10eb=(_10ea.from-_10ea.lower)*_10ea.scale,_10ec=vs/this.lastWindow.vscale,_10ed=hs/this.lastWindow.hscale,_10ee=(this.lastWindow.xoffset-_10e9)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_10ef=(_10eb-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),shape=this.group,anim=fx.animateTransform(lang.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,0],end:[_10e6.l*(1-_10ed),_10e7*(1-_10ec)]},{name:"scale",start:[1,1],end:[_10ed,_10ec]},{name:"original"},{name:"translate",start:[0,0],end:[_10ee,_10ef]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_10e9,yoffset:_10eb});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},getRequiredColors:function(){return 0;},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];}},createLine:function(_10f0,_10f1){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_10f1);_10f0.add(line);}else{line=_10f0.createLine(_10f1);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_10f2){if(this.zoom){return this.performZoom(dim,_10f2);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _10f3=this._vAxis.getScaler(),vt=_10f3.scaler.getTransformerFromModel(_10f3),ticks=this._vAxis.getTicks();if(ticks!=null){if(this.opt.hMinorLines){arr.forEach(ticks.minor,function(tick){var y=dim.height-_10f2.b-vt(tick.value);var _10f4=this.createLine(s,{x1:_10f2.l,y1:y,x2:dim.width-_10f2.r,y2:y}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_10f4,"h",_10f2.l,_10f2.r+_10f2.l-dim.width);}},this);}if(this.opt.hMajorLines){arr.forEach(ticks.major,function(tick){var y=dim.height-_10f2.b-vt(tick.value);var _10f5=this.createLine(s,{x1:_10f2.l,y1:y,x2:dim.width-_10f2.r,y2:y}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_10f5,"h",_10f2.l,_10f2.r+_10f2.l-dim.width);}},this);}}}catch(e){}try{var _10f6=this._hAxis.getScaler(),ht=_10f6.scaler.getTransformerFromModel(_10f6),ticks=this._hAxis.getTicks();if(this!=null){if(ticks&&this.opt.vMinorLines){arr.forEach(ticks.minor,function(tick){var x=_10f2.l+ht(tick.value);var _10f7=this.createLine(s,{x1:x,y1:_10f2.t,x2:x,y2:dim.height-_10f2.b}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_10f7,"v",dim.height-_10f2.b,dim.height-_10f2.b-_10f2.t);}},this);}if(ticks&&this.opt.vMajorLines){arr.forEach(ticks.major,function(tick){var x=_10f2.l+ht(tick.value);var _10f8=this.createLine(s,{x1:x,y1:_10f2.t,x2:x,y2:dim.height-_10f2.b}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_10f8,"v",dim.height-_10f2.b,dim.height-_10f2.b-_10f2.t);}},this);}}}catch(e){}this.dirty=false;return this;},_animateGrid:function(shape,type,_10f9,size){var _10fa=type=="h"?[_10f9,0]:[0,_10f9];var _10fb=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:_10fa,end:[0,0]},{name:"scale",start:_10fb,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/_base/declare":function(){define(["./kernel","../has","./lang"],function(dojo,has,lang){var mix=lang.mixin,op=Object.prototype,opts=op.toString,xtor=new Function,_10fc=0,cname="constructor";function err(msg,cls){throw new Error("declare"+(cls?" "+cls:"")+": "+msg);};function c3mro(bases,_10fd){var _10fe=[],roots=[{cls:0,refs:[]}],_10ff={},_1100=1,l=bases.length,i=0,j,lin,base,top,proto,rec,name,refs;for(;i<l;++i){base=bases[i];if(!base){err("mixin #"+i+" is unknown. Did you use dojo.require to pull it in?",_10fd);}else{if(opts.call(base)!="[object Function]"){err("mixin #"+i+" is not a callable constructor.",_10fd);}}lin=base._meta?base._meta.bases:[base];top=0;for(j=lin.length-1;j>=0;--j){proto=lin[j].prototype;if(!proto.hasOwnProperty("declaredClass")){proto.declaredClass="uniqName_"+(_10fc++);}name=proto.declaredClass;if(!_10ff.hasOwnProperty(name)){_10ff[name]={count:0,refs:[],cls:lin[j]};++_1100;}rec=_10ff[name];if(top&&top!==rec){rec.refs.push(top);++top.count;}top=rec;}++top.count;roots[0].refs.push(top);}while(roots.length){top=roots.pop();_10fe.push(top.cls);--_1100;while(refs=top.refs,refs.length==1){top=refs[0];if(!top||--top.count){top=0;break;}_10fe.push(top.cls);--_1100;}if(top){for(i=0,l=refs.length;i<l;++i){top=refs[i];if(!--top.count){roots.push(top);}}}}if(_1100){err("can't build consistent linearization",_10fd);}base=bases[0];_10fe[0]=base?base._meta&&base===_10fe[_10fe.length-base._meta.bases.length]?base._meta.bases.length:1:0;return _10fe;};function _1101(args,a,f){var name,_1102,bases,_1103,meta,base,proto,opf,pos,cache=this._inherited=this._inherited||{};if(typeof args=="string"){name=args;args=a;a=f;}f=0;_1103=args.callee;name=name||_1103.nom;if(!name){err("can't deduce a name to call inherited()",this.declaredClass);}meta=this.constructor._meta;bases=meta.bases;pos=cache.p;if(name!=cname){if(cache.c!==_1103){pos=0;base=bases[0];meta=base._meta;if(meta.hidden[name]!==_1103){_1102=meta.chains;if(_1102&&typeof _1102[name]=="string"){err("calling chained method with inherited: "+name,this.declaredClass);}do{meta=base._meta;proto=base.prototype;if(meta&&(proto[name]===_1103&&proto.hasOwnProperty(name)||meta.hidden[name]===_1103)){break;}}while(base=bases[++pos]);pos=base?pos:-1;}}base=bases[++pos];if(base){proto=base.prototype;if(base._meta&&proto.hasOwnProperty(name)){f=proto[name];}else{opf=op[name];do{proto=base.prototype;f=proto[name];if(f&&(base._meta?proto.hasOwnProperty(name):f!==opf)){break;}}while(base=bases[++pos]);}}f=base&&f||op[name];}else{if(cache.c!==_1103){pos=0;meta=bases[0]._meta;if(meta&&meta.ctor!==_1103){_1102=meta.chains;if(!_1102||_1102.constructor!=="manual"){err("calling chained constructor with inherited",this.declaredClass);}while(base=bases[++pos]){meta=base._meta;if(meta&&meta.ctor===_1103){break;}}pos=base?pos:-1;}}while(base=bases[++pos]){meta=base._meta;f=meta?meta.ctor:base;if(f){break;}}f=base&&f;}cache.c=f;cache.p=pos;if(f){return a===true?f:f.apply(this,a||args);}};function _1104(name,args){if(typeof name=="string"){return this.__inherited(name,args,true);}return this.__inherited(name,true);};function _1105(args,a1,a2){var f=this.getInherited(args,a1);if(f){return f.apply(this,a2||a1||args);}};var _1106=dojo.config.isDebug?_1105:_1101;function _1107(cls){var bases=this.constructor._meta.bases;for(var i=0,l=bases.length;i<l;++i){if(bases[i]===cls){return true;}}return this instanceof cls;};function _1108(_1109,_110a){for(var name in _110a){if(name!=cname&&_110a.hasOwnProperty(name)){_1109[name]=_110a[name];}}if(has("bug-for-in-skips-shadowed")){for(var _110b=lang._extraNames,i=_110b.length;i;){name=_110b[--i];if(name!=cname&&_110a.hasOwnProperty(name)){_1109[name]=_110a[name];}}}};function _110c(_110d,_110e){var name,t;for(name in _110e){t=_110e[name];if((t!==op[name]||!(name in op))&&name!=cname){if(opts.call(t)=="[object Function]"){t.nom=name;}_110d[name]=t;}}if(has("bug-for-in-skips-shadowed")){for(var _110f=lang._extraNames,i=_110f.length;i;){name=_110f[--i];t=_110e[name];if((t!==op[name]||!(name in op))&&name!=cname){if(opts.call(t)=="[object Function]"){t.nom=name;}_110d[name]=t;}}}return _110d;};function _1110(_1111){_1112.safeMixin(this.prototype,_1111);return this;};function _1113(bases,_1114){return function(){var a=arguments,args=a,a0=a[0],f,i,m,l=bases.length,_1115;if(!(this instanceof a.callee)){return _1116(a);}if(_1114&&(a0&&a0.preamble||this.preamble)){_1115=new Array(bases.length);_1115[0]=a;for(i=0;;){a0=a[0];if(a0){f=a0.preamble;if(f){a=f.apply(this,a)||a;}}f=bases[i].prototype;f=f.hasOwnProperty("preamble")&&f.preamble;if(f){a=f.apply(this,a)||a;}if(++i==l){break;}_1115[i]=a;}}for(i=l-1;i>=0;--i){f=bases[i];m=f._meta;f=m?m.ctor:f;if(f){f.apply(this,_1115?_1115[i]:a);}}f=this.postscript;if(f){f.apply(this,args);}};};function _1117(ctor,_1118){return function(){var a=arguments,t=a,a0=a[0],f;if(!(this instanceof a.callee)){return _1116(a);}if(_1118){if(a0){f=a0.preamble;if(f){t=f.apply(this,t)||t;}}f=this.preamble;if(f){f.apply(this,t);}}if(ctor){ctor.apply(this,a);}f=this.postscript;if(f){f.apply(this,a);}};};function _1119(bases){return function(){var a=arguments,i=0,f,m;if(!(this instanceof a.callee)){return _1116(a);}for(;f=bases[i];++i){m=f._meta;f=m?m.ctor:f;if(f){f.apply(this,a);break;}}f=this.postscript;if(f){f.apply(this,a);}};};function chain(name,bases,_111a){return function(){var b,m,f,i=0,step=1;if(_111a){i=bases.length-1;step=-1;}for(;b=bases[i];i+=step){m=b._meta;f=(m?m.hidden:b.prototype)[name];if(f){f.apply(this,arguments);}}};};function _111b(ctor){xtor.prototype=ctor.prototype;var t=new xtor;xtor.prototype=null;return t;};function _1116(args){var ctor=args.callee,t=_111b(ctor);ctor.apply(t,args);return t;};function _1112(_111c,_111d,props){if(typeof _111c!="string"){props=_111d;_111d=_111c;_111c="";}props=props||{};var proto,i,t,ctor,name,bases,_111e,_111f=1,_1120=_111d;if(opts.call(_111d)=="[object Array]"){bases=c3mro(_111d,_111c);t=bases[0];_111f=bases.length-t;_111d=bases[_111f];}else{bases=[0];if(_111d){if(opts.call(_111d)=="[object Function]"){t=_111d._meta;bases=bases.concat(t?t.bases:_111d);}else{err("base class is not a callable constructor.",_111c);}}else{if(_111d!==null){err("unknown base class. Did you use dojo.require to pull it in?",_111c);}}}if(_111d){for(i=_111f-1;;--i){proto=_111b(_111d);if(!i){break;}t=bases[i];(t._meta?_1108:mix)(proto,t.prototype);ctor=new Function;ctor.superclass=_111d;ctor.prototype=proto;_111d=proto.constructor=ctor;}}else{proto={};}_1112.safeMixin(proto,props);t=props.constructor;if(t!==op.constructor){t.nom=cname;proto.constructor=t;}for(i=_111f-1;i;--i){t=bases[i]._meta;if(t&&t.chains){_111e=mix(_111e||{},t.chains);}}if(proto["-chains-"]){_111e=mix(_111e||{},proto["-chains-"]);}t=!_111e||!_111e.hasOwnProperty(cname);bases[0]=ctor=(_111e&&_111e.constructor==="manual")?_1119(bases):(bases.length==1?_1117(props.constructor,t):_1113(bases,t));ctor._meta={bases:bases,hidden:props,chains:_111e,parents:_1120,ctor:props.constructor};ctor.superclass=_111d&&_111d.prototype;ctor.extend=_1110;ctor.prototype=proto;proto.constructor=ctor;proto.getInherited=_1104;proto.isInstanceOf=_1107;proto.inherited=_1106;proto.__inherited=_1101;if(_111c){proto.declaredClass=_111c;lang.setObject(_111c,ctor);}if(_111e){for(name in _111e){if(proto[name]&&typeof _111e[name]=="string"&&name!=cname){t=proto[name]=chain(name,bases,_111e[name]==="after");t.nom=name;}}}return ctor;};dojo.safeMixin=_1112.safeMixin=_110c;dojo.declare=_1112;return _1112;});},"dojo/domReady":function(){define(["./has"],function(has){var _1121=this,doc=document,_1122={"loaded":1,"complete":1},_1123=typeof doc.readyState!="string",ready=!!_1122[doc.readyState];if(_1123){doc.readyState="loading";}if(!ready){var _1124=[],tests=[],_1125=function(evt){evt=evt||_1121.event;if(ready||(evt.type=="readystatechange"&&!_1122[doc.readyState])){return;}ready=1;if(_1123){doc.readyState="complete";}while(_1124.length){(_1124.shift())();}},on=function(node,event){node.addEventListener(event,_1125,false);_1124.push(function(){node.removeEventListener(event,_1125,false);});};if(!has("dom-addeventlistener")){on=function(node,event){event="on"+event;node.attachEvent(event,_1125);_1124.push(function(){node.detachEvent(event,_1125);});};var div=doc.createElement("div");try{if(div.doScroll&&_1121.frameElement===null){tests.push(function(){try{div.doScroll("left");return 1;}catch(e){}});}}catch(e){}}on(doc,"DOMContentLoaded");on(_1121,"load");if("onreadystatechange" in doc){on(doc,"readystatechange");}else{if(!_1123){tests.push(function(){return _1122[doc.readyState];});}}if(tests.length){var _1126=function(){if(ready){return;}var i=tests.length;while(i--){if(tests[i]()){_1125("poller");return;}}setTimeout(_1126,30);};_1126();}}function _1127(_1128){if(ready){_1128(1);}else{_1124.push(_1128);}};_1127.load=function(id,req,load){_1127(load);};return _1127;});},"dojo/dnd/Target":function(){define(["./Source"],function(_1129){return dojo.declare("dojo.dnd.Target",_1129,{constructor:function(node,_112a){this.isSource=false;dojo.removeClass(this.node,"dojoDndSource");}});});},"dojo/text":function(){define(["./_base/kernel","require","./has","./_base/xhr"],function(dojo,_112b,has,xhr){var _112c;if(1){_112c=function(url,sync,load){xhr("GET",{url:url,sync:!!sync,load:load});};}else{if(_112b.getText){_112c=_112b.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _112d={},strip=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _112e=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_112e){text=_112e[1];}}else{text="";}return text;},_112f={},_1130={},_1131={dynamic:true,normalize:function(id,_1132){var parts=id.split("!"),url=parts[0];return (/^\./.test(url)?_1132(url):url)+(parts[1]?"!"+parts[1]:"");},load:function(id,_1133,load){var parts=id.split("!"),_1134=parts.length>1,_1135=parts[0],url=_1133.toUrl(parts[0]),text=_112f,_1136=function(text){load(_1134?strip(text):text);};if(_1135 in _112d){text=_112d[_1135];}else{if(url in _1133.cache){text=_1133.cache[url];}else{if(url in _112d){text=_112d[url];}}}if(text===_112f){if(_1130[url]){_1130[url].push(_1136);}else{var _1137=_1130[url]=[_1136];_112c(url,!_1133.async,function(text){_112d[_1135]=_112d[url]=text;for(var i=0;i<_1137.length;){_1137[i++](text);}delete _1130[url];});}}else{_1136(text);}}};dojo.cache=function(_1138,url,value){var key;if(typeof _1138=="string"){if(/\//.test(_1138)){key=_1138;value=url;}else{key=_112b.toUrl(_1138.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_1138+"";value=url;}var val=(value!=undefined&&typeof value!="string")?value.value:value,_1139=value&&value.sanitize;if(typeof val=="string"){_112d[key]=val;return _1139?strip(val):val;}else{if(val===null){delete _112d[key];return null;}else{if(!(key in _112d)){_112c(key,true,function(text){_112d[key]=text;});}return _1139?strip(_112d[key]):_112d[key];}}};return _1131;});},"dojox/lang/utils":function(){define("dojox/lang/utils",["..","dojo/_base/lang"],function(dojox,lang){var du=lang.getObject("lang.utils",true,dojox);var empty={},opts=Object.prototype.toString;var clone=function(o){if(o){switch(opts.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return lang.delegate(o);}}return o;};lang.mixin(du,{coerceType:function(_113a,_113b){switch(typeof _113a){case "number":return Number(eval("("+_113b+")"));case "string":return String(_113b);case "boolean":return Boolean(eval("("+_113b+")"));}return eval("("+_113b+")");},updateWithObject:function(_113c,_113d,conv){if(!_113d){return _113c;}for(var x in _113c){if(x in _113d&&!(x in empty)){var t=_113c[x];if(t&&typeof t=="object"){du.updateWithObject(t,_113d[x],conv);}else{_113c[x]=conv?du.coerceType(t,_113d[x]):clone(_113d[x]);}}}return _113c;},updateWithPattern:function(_113e,_113f,_1140,conv){if(!_113f||!_1140){return _113e;}for(var x in _1140){if(x in _113f&&!(x in empty)){_113e[x]=conv?du.coerceType(_1140[x],_113f[x]):clone(_113f[x]);}}return _113e;},merge:function(_1141,mixin){if(mixin){var otype=opts.call(_1141),mtype=opts.call(mixin),t,i,l,m;switch(mtype){case "[object Array]":if(mtype==otype){t=new Array(Math.max(_1141.length,mixin.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_1141[i],mixin[i]);}return t;}return mixin.slice(0);case "[object Object]":if(mtype==otype&&_1141){t=lang.delegate(_1141);for(i in mixin){if(i in _1141){l=_1141[i];m=mixin[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=lang.clone(mixin[i]);}}return t;}return lang.clone(mixin);}}return mixin;}});return du;});},"dojo/i18n":function(){define(["./_base/kernel","require","./has","./_base/array","./_base/lang","./_base/xhr"],function(dojo,_1142,has,array,lang){var _1143=dojo.i18n={},nlsRe=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_1144=function(root,_1145,_1146,_1147){for(var _1148=[_1146+_1147],_1149=_1145.split("-"),_114a="",i=0;i<_1149.length;i++){_114a+=(_114a?"-":"")+_1149[i];if(!root||root[_114a]){_1148.push(_1146+_114a+"/"+_1147);}}return _1148;},cache={},_114b=dojo.getL10nName=function(_114c,_114d,_114e){_114e=_114e?_114e.toLowerCase():dojo.locale;_114c="dojo/i18n!"+_114c.replace(/\./g,"/");_114d=_114d.replace(/\./g,"/");return (/root/i.test(_114e))?(_114c+"/nls/"+_114d):(_114c+"/nls/"+_114e+"/"+_114d);},_114f=function(_1150,_1151,_1152,_1153,_1154,load){_1150([_1151],function(root){var _1155=cache[_1151+"/"]=lang.clone(root.root),_1156=_1144(!root._v1x&&root,_1154,_1152,_1153);_1150(_1156,function(){for(var i=1;i<_1156.length;i++){cache[_1156[i]]=_1155=lang.mixin(lang.clone(_1155),arguments[i]);}var _1157=_1151+"/"+_1154;cache[_1157]=_1155;load&&load(lang.delegate(_1155));});});},_1158=function(id,_1159){var match=nlsRe.exec(id),_115a=match[1];return /^\./.test(_115a)?_1159(_115a)+"/"+id.substring(_115a.length):id;};load=function(id,_115b,load){var match=nlsRe.exec(id),_115c=match[1]+"/",_115d=match[5]||match[4],_115e=_115c+_115d,_115f=(match[5]&&match[4]),_1160=_115f||dojo.locale,_1161=_115e+"/"+_1160;if(_115f){if(cache[_1161]){load(cache[_1161]);}else{_114f(_115b,_115e,_115c,_115d,_1160,load);}return;}var extra=dojo.config.extraLocale||[];extra=lang.isArray(extra)?extra:[extra];extra.push(_1160);array.forEach(extra,function(_1162){_114f(_115b,_115e,_115c,_115d,_1162,_1162==_1160&&load);});};true||has.add("dojo-v1x-i18n-Api",1);if(1){var _1163=new Function("bundle","var __preAmdResult, __amdResult; function define(bundle){__amdResult= bundle;} __preAmdResult= eval(bundle); return [__preAmdResult, __amdResult];"),fixup=function(url,_1164,_1165){return _1164?(/nls\/[^\/]+\/[^\/]+$/.test(url)?_1164:{root:_1164,_v1x:1}):_1165;},_1166=function(deps,_1167){var _1168=[];dojo.forEach(deps,function(mid){var url=_1142.toUrl(mid+".js");if(cache[url]){_1168.push(cache[url]);}else{try{var _1169=_1142(mid);if(_1169){_1168.push(_1169);return;}}catch(e){}dojo.xhrGet({url:url,sync:true,load:function(text){var _116a=_1163(text);_1168.push(cache[url]=fixup(url,_116a[0],_116a[1]));},error:function(){_1168.push(cache[url]={});}});}});_1167.apply(null,_1168);};_1143.getLocalization=function(_116b,_116c,_116d){var _116e,_116f=_114b(_116b,_116c,_116d).substring(10);load(_116f,(1&&!_1142.isXdUrl(_1142.toUrl(_116f+".js"))?_1166:_1142),function(_1170){_116e=_1170;});return _116e;};_1143.normalizeLocale=function(_1171){var _1172=_1171?_1171.toLowerCase():dojo.locale;if(_1172=="root"){_1172="ROOT";}return _1172;};}return lang.mixin(_1143,{dynamic:true,normalize:_1158,load:load,cache:function(mid,value){cache[mid]=value;}});});},"dojox/charting/plot2d/Markers":function(){define("dojox/charting/plot2d/Markers",["dojo/_base/declare","./Default"],function(_1173,_1174){return _1173("dojox.charting.plot2d.Markers",_1174,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Columns":function(){define("dojox/charting/plot2d/Columns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_1175,Base,dc,df,dfr,du,fx){var _1176=dfr.lambda("item.purgeGroup()");return _1175("dojox.charting.plot2d.Columns",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,_1177){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_1177);du.updateWithPattern(this.opt,_1177,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var stats=dc.collectSimpleStats(this.series);stats.hmin-=0.5;stats.hmax+=0.5;return stats;},createRect:function(run,_1178,_1179){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_1179);_1178.add(rect);}else{rect=_1178.createRect(_1179);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_117a){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_117a);}var t=this.getSeriesStats();this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_1176);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_117b=Math.max(0,this._vScaler.bounds.lower),_117c=vt(_117b),min=Math.max(0,Math.floor(this._hScaler.bounds.from-1)),max=Math.ceil(this._hScaler.bounds.to),_117d=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var theme=t.next("column",[this.opt,run]),s=run.group,_117e=new Array(run.data.length);var l=Math.min(run.data.length,max);for(var j=min;j<l;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y,vv=vt(v),_117f=vv-_117c,h=Math.abs(_117f),_1180=typeof value!="number"?t.addMixin(theme,"column",value,true):t.post(theme,"column");if(width>=1&&h>=0){var rect={x:_117a.l+ht(j+0.5)+gap,y:dim.height-_117a.b-(v>_117b?vv:_117c),width:width,height:h};var _1181=this._plotFill(_1180.series.fill,dim,_117a);_1181=this._shapeFill(_1181,rect);var shape=this.createRect(run,s,rect).setFill(_1181).setStroke(_1180.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(_117d){var o={element:"column",index:j,run:run,shape:shape,x:j+0.5,y:v};this._connectEvents(o);_117e[j]=o;}if(this.animate){this._animateColumn(shape,dim.height-_117a.b-_117c,h);}}}}this._eventSeries[run.name]=_117e;run.dirty=false;}this.dirty=false;return this;},_animateColumn:function(shape,_1182,vsize){fx.animateTransform(lang.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,_1182-(_1182/vsize)],end:[0,0]},{name:"scale",start:[1,1/vsize],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/ColorPalette":function(){require({cache:{"url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"grid\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n"}});define("dijit/ColorPalette",["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/window","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_1183,_1184,_1185,_1186,_1187,i18n,Color,_1188,_1189,_118a,win,_118b){var _118c=_1188("dijit.ColorPalette",[_1185,_1186,_1187],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_1184,baseClass:"dijitColorPalette",_dyeFactory:function(value,row,col){return new this._dyeClass(value,row,col);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_1188(_118c._Color,{hc:_1189.contains(win.body(),"dijit_a11y"),palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_118c._Color=_1188("dijit._Color",Color,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_1183.toUrl("./themes/a11y/colors7x10.png"),"3x4":_1183.toUrl("./themes/a11y/colors3x4.png")},constructor:function(alias,row,col){this._alias=alias;this._row=row;this._col=col;this.setColor(Color.named[alias]);},getValue:function(){return this.toHex();},fillCell:function(cell,_118d){var html=_118b.substitute(this.hc?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_118d,alt:this._alias,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_118a.place(html,cell);}});return _118c;});},"dojo/data/util/simpleFetch":function(){define(["dojo/_base/lang","dojo/_base/window","./sorter"],function(lang,_118e,_118f){var _1190=lang.getObject("dojo.data.util.simpleFetch",true);_1190.fetch=function(_1191){_1191=_1191||{};if(!_1191.store){_1191.store=this;}var self=this;var _1192=function(_1193,_1194){if(_1194.onError){var scope=_1194.scope||_118e.global;_1194.onError.call(scope,_1193,_1194);}};var _1195=function(items,_1196){var _1197=_1196.abort||null;var _1198=false;var _1199=_1196.start?_1196.start:0;var _119a=(_1196.count&&(_1196.count!==Infinity))?(_1199+_1196.count):items.length;_1196.abort=function(){_1198=true;if(_1197){_1197.call(_1196);}};var scope=_1196.scope||_118e.global;if(!_1196.store){_1196.store=self;}if(_1196.onBegin){_1196.onBegin.call(scope,items.length,_1196);}if(_1196.sort){items.sort(_118f.createSortFunction(_1196.sort,self));}if(_1196.onItem){for(var i=_1199;(i<items.length)&&(i<_119a);++i){var item=items[i];if(!_1198){_1196.onItem.call(scope,item,_1196);}}}if(_1196.onComplete&&!_1198){var _119b=null;if(!_1196.onItem){_119b=items.slice(_1199,_119a);}_1196.onComplete.call(scope,_119b,_1196);}};this._fetchItems(_1191,_1195,_1192);return _1191;};return _1190;});},"dijit/_CssStateMixin":function(){define("dijit/_CssStateMixin",["dojo/touch","dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/_base/window"],function(touch,array,_119c,_119d,lang,win){return _119c("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);array.forEach(["onmouseenter","onmouseleave",touch.press],function(e){this.connect(this.domNode,e,"_cssMouseEvent");},this);array.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._setStateClass();},_cssMouseEvent:function(event){if(!this.disabled){switch(event.type){case "mouseenter":case "mouseover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseleave":case "mouseout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchpress":this._set("active",true);this._mouseDown=true;var _119e=this.connect(win.body(),touch.release,function(){this._mouseDown=false;this._set("active",false);this.disconnect(_119e);});break;}}},_setStateClass:function(){var _119f=this.baseClass.split(" ");function _11a0(_11a1){_119f=_119f.concat(array.map(_119f,function(c){return c+_11a1;}),"dijit"+_11a1);};if(!this.isLeftToRight()){_11a0("Rtl");}var _11a2=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_11a0(_11a2);}if(this.state){_11a0(this.state);}if(this.selected){_11a0("Selected");}if(this.disabled){_11a0("Disabled");}else{if(this.readOnly){_11a0("ReadOnly");}else{if(this.active){_11a0("Active");}else{if(this.hovering){_11a0("Hover");}}}}if(this.focused){_11a0("Focused");}var tn=this.stateNode||this.domNode,_11a3={};array.forEach(tn.className.split(" "),function(c){_11a3[c]=true;});if("_stateClasses" in this){array.forEach(this._stateClasses,function(c){delete _11a3[c];});}array.forEach(_119f,function(c){_11a3[c]=true;});var _11a4=[];for(var c in _11a3){_11a4.push(c);}tn.className=_11a4.join(" ");this._stateClasses=_119f;},_trackMouseState:function(node,clazz){var _11a5=false,_11a6=false,_11a7=false;var self=this,cn=lang.hitch(this,"connect",node);function _11a8(){var _11a9=("disabled" in self&&self.disabled)||("readonly" in self&&self.readonly);_119d.toggle(node,clazz+"Hover",_11a5&&!_11a6&&!_11a9);_119d.toggle(node,clazz+"Active",_11a6&&!_11a9);_119d.toggle(node,clazz+"Focused",_11a7&&!_11a9);};cn("onmouseenter",function(){_11a5=true;_11a8();});cn("onmouseleave",function(){_11a5=false;_11a6=false;_11a8();});cn(touch.press,function(){_11a6=true;_11a8();});cn(touch.release,function(){_11a6=false;_11a8();});cn("onfocus",function(){_11a7=true;_11a8();});cn("onblur",function(){_11a7=false;_11a8();});this.watch("disabled",_11a8);this.watch("readOnly",_11a8);}});});},"dojo/dnd/Source":function(){define(["../main","./Selector","./Manager"],function(dojo,_11aa,_11ab){if(!dojo.isAsync){dojo.ready(0,function(){var _11ac=["dojo/dnd/AutoSource","dojo/dnd/Target"];require(_11ac);});}return dojo.declare("dojo.dnd.Source",_11aa,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_11ad){dojo.mixin(this,dojo.mixin({},_11ad));var type=this.accept;if(type.length){this.accept={};for(var i=0;i<type.length;++i){this.accept[type[i]]=1;}}this.isDragging=false;this.mouseDown=false;this.targetAnchor=null;this.targetBox=null;this.before=true;this._lastX=0;this._lastY=0;this.sourceState="";if(this.isSource){dojo.addClass(this.node,"dojoDndSource");}this.targetState="";if(this.accept){dojo.addClass(this.node,"dojoDndTarget");}if(this.horizontal){dojo.addClass(this.node,"dojoDndHorizontal");}this.topics=[dojo.subscribe("/dnd/source/over",this,"onDndSourceOver"),dojo.subscribe("/dnd/start",this,"onDndStart"),dojo.subscribe("/dnd/drop",this,"onDndDrop"),dojo.subscribe("/dnd/cancel",this,"onDndCancel")];},checkAcceptance:function(_11ae,nodes){if(this==_11ae){return !this.copyOnly||this.selfAccept;}for(var i=0;i<nodes.length;++i){var type=_11ae.getItem(nodes[i].id).type;var flag=false;for(var j=0;j<type.length;++j){if(type[j] in this.accept){flag=true;break;}}if(!flag){return false;}}return true;},copyState:function(_11af,self){if(_11af){return true;}if(arguments.length<2){self=this==_11ab.manager().target;}if(self){if(this.copyOnly){return this.selfCopy;}}else{return this.copyOnly;}return false;},destroy:function(){dojo.dnd.Source.superclass.destroy.call(this);dojo.forEach(this.topics,dojo.unsubscribe);this.targetAnchor=null;},onMouseMove:function(e){if(this.isDragging&&this.targetState=="Disabled"){return;}dojo.dnd.Source.superclass.onMouseMove.call(this,e);var m=_11ab.manager();if(!this.isDragging){if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){var nodes=this.getSelectedNodes();if(nodes.length){m.startDrag(this,nodes,this.copyState(dojo.isCopyKey(e),true));}}}if(this.isDragging){var _11b0=false;if(this.current){if(!this.targetBox||this.targetAnchor!=this.current){this.targetBox=dojo.position(this.current,true);}if(this.horizontal){_11b0=(e.pageX-this.targetBox.x)<(this.targetBox.w/2);}else{_11b0=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);}}if(this.current!=this.targetAnchor||_11b0!=this.before){this._markTargetAnchor(_11b0);m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));}}},onMouseDown:function(e){if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dojo.dnd.isFormElement(e))){this.mouseDown=true;this._lastX=e.pageX;this._lastY=e.pageY;dojo.dnd.Source.superclass.onMouseDown.call(this,e);}},onMouseUp:function(e){if(this.mouseDown){this.mouseDown=false;dojo.dnd.Source.superclass.onMouseUp.call(this,e);}},onDndSourceOver:function(_11b1){if(this!=_11b1){this.mouseDown=false;if(this.targetAnchor){this._unmarkTargetAnchor();}}else{if(this.isDragging){var m=_11ab.manager();m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));}}},onDndStart:function(_11b2,nodes,copy){if(this.autoSync){this.sync();}if(this.isSource){this._changeState("Source",this==_11b2?(copy?"Copied":"Moved"):"");}var _11b3=this.accept&&this.checkAcceptance(_11b2,nodes);this._changeState("Target",_11b3?"":"Disabled");if(this==_11b2){_11ab.manager().overSource(this);}this.isDragging=true;},onDndDrop:function(_11b4,nodes,copy,_11b5){if(this==_11b5){this.onDrop(_11b4,nodes,copy);}this.onDndCancel();},onDndCancel:function(){if(this.targetAnchor){this._unmarkTargetAnchor();this.targetAnchor=null;}this.before=true;this.isDragging=false;this.mouseDown=false;this._changeState("Source","");this._changeState("Target","");},onDrop:function(_11b6,nodes,copy){if(this!=_11b6){this.onDropExternal(_11b6,nodes,copy);}else{this.onDropInternal(nodes,copy);}},onDropExternal:function(_11b7,nodes,copy){var _11b8=this._normalizedCreator;if(this.creator){this._normalizedCreator=function(node,hint){return _11b8.call(this,_11b7.getItem(node.id).data,hint);};}else{if(copy){this._normalizedCreator=function(node,hint){var t=_11b7.getItem(node.id);var n=node.cloneNode(true);n.id=dojo.dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}else{this._normalizedCreator=function(node,hint){var t=_11b7.getItem(node.id);_11b7.delItem(node.id);return {node:node,data:t.data,type:t.type};};}}this.selectNone();if(!copy&&!this.creator){_11b7.selectNone();}this.insertNodes(true,nodes,this.before,this.current);if(!copy&&this.creator){_11b7.deleteSelectedNodes();}this._normalizedCreator=_11b8;},onDropInternal:function(nodes,copy){var _11b9=this._normalizedCreator;if(this.current&&this.current.id in this.selection){return;}if(copy){if(this.creator){this._normalizedCreator=function(node,hint){return _11b9.call(this,this.getItem(node.id).data,hint);};}else{this._normalizedCreator=function(node,hint){var t=this.getItem(node.id);var n=node.cloneNode(true);n.id=dojo.dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}}else{if(!this.current){return;}this._normalizedCreator=function(node,hint){var t=this.getItem(node.id);return {node:node,data:t.data,type:t.type};};}this._removeSelection();this.insertNodes(true,nodes,this.before,this.current);this._normalizedCreator=_11b9;},onDraggingOver:function(){},onDraggingOut:function(){},onOverEvent:function(){dojo.dnd.Source.superclass.onOverEvent.call(this);_11ab.manager().overSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOver();}},onOutEvent:function(){dojo.dnd.Source.superclass.onOutEvent.call(this);_11ab.manager().outSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOut();}},_markTargetAnchor:function(_11ba){if(this.current==this.targetAnchor&&this.before==_11ba){return;}if(this.targetAnchor){this._removeItemClass(this.targetAnchor,this.before?"Before":"After");}this.targetAnchor=this.current;this.targetBox=null;this.before=_11ba;if(this.targetAnchor){this._addItemClass(this.targetAnchor,this.before?"Before":"After");}},_unmarkTargetAnchor:function(){if(!this.targetAnchor){return;}this._removeItemClass(this.targetAnchor,this.before?"Before":"After");this.targetAnchor=null;this.targetBox=null;this.before=true;},_markDndStatus:function(copy){this._changeState("Source",copy?"Copied":"Moved");},_legalMouseDown:function(e){if(!dojo.mouseButtons.isLeft(e)){return false;}if(!this.withHandles){return true;}for(var node=e.target;node&&node!==this.node;node=node.parentNode){if(dojo.hasClass(node,"dojoDndHandle")){return true;}if(dojo.hasClass(node,"dojoDndItem")||dojo.hasClass(node,"dojoDndIgnore")){break;}}return false;}});});},"dojox/charting/action2d/Tooltip":function(){define("dojox/charting/action2d/Tooltip",["dojo/_base/kernel","dijit/Tooltip","dojo/_base/lang","dojo/_base/html","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(dojo,_11bb,lang,html,_11bc,_11bd,m,df,dfs,dff){var _11be=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var pi4=Math.PI/4,pi2=Math.PI/2;return _11bc("dojox.charting.action2d.Tooltip",_11bd,{defaultParams:{text:_11be},optionalParams:{},constructor:function(chart,plot,_11bf){this.text=_11bf&&_11bf.text?_11bf.text:_11be;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_11bb.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||o.type!=="onmouseover"){return;}var _11c0={type:"rect"},_11c1=["after","before"];switch(o.element){case "marker":_11c0.x=o.cx;_11c0.y=o.cy;_11c0.w=_11c0.h=1;break;case "circle":_11c0.x=o.cx-o.cr;_11c0.y=o.cy-o.cr;_11c0.w=_11c0.h=2*o.cr;break;case "column":_11c1=["above","below"];case "bar":_11c0=lang.clone(o.shape.getShape());break;case "candlestick":_11c0.x=o.x;_11c0.y=o.y;_11c0.w=o.width;_11c0.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _11c2=m._degToRad(o.plot.opt.startAngle),angle=(this.angles[o.index]+this.angles[o.index+1])/2+_11c2;_11c0.x=o.cx+o.cr*Math.cos(angle);_11c0.y=o.cy+o.cr*Math.sin(angle);_11c0.w=_11c0.h=1;if(angle<pi4){}else{if(angle<pi2+pi4){_11c1=["below","above"];}else{if(angle<Math.PI+pi4){_11c1=["before","after"];}else{if(angle<2*Math.PI-pi4){_11c1=["above","below"];}}}}break;}var lt=this.chart.getCoords();_11c0.x+=lt.x;_11c0.y+=lt.y;_11c0.x=Math.round(_11c0.x);_11c0.y=Math.round(_11c0.y);_11c0.w=Math.ceil(_11c0.w);_11c0.h=Math.ceil(_11c0.h);this.aroundRect=_11c0;var _11c3=this.text(o);if(this.chart.getTextDir){var _11c4=(html.style(this.chart.node,"direction")=="rtl");var _11c5=(this.chart.getTextDir(_11c3)=="rtl");}if(_11c3){if(_11c5&&!_11c4){_11bb.show("<span dir = 'rtl'>"+_11c3+"</span>",this.aroundRect,_11c1);}else{if(!_11c5&&_11c4){_11bb.show("<span dir = 'ltr'>"+_11c3+"</span>",this.aroundRect,_11c1);}else{_11bb.show(_11c3,this.aroundRect,_11c1);}}}}});});},"dojo/NodeList-dom":function(){define(["./_base/kernel","./query","./_base/array","./_base/lang","./dom-class","./dom-construct","./dom-geometry","./dom-attr","./dom-style"],function(dojo,query,array,lang,_11c6,_11c7,_11c8,_11c9,_11ca){var _11cb=function(a){return a.length==1&&(typeof a[0]=="string");};var _11cc=function(node){var p=node.parentNode;if(p){p.removeChild(node);}};var _11cd=query.NodeList,awc=_11cd._adaptWithCondition,aafe=_11cd._adaptAsForEach,aam=_11cd._adaptAsMap;function _11ce(_11cf){return function(node,name,value){if(arguments.length==2){return _11cf[typeof name=="string"?"get":"set"](node,name);}return _11cf.set(node,name,value);};};lang.extend(_11cd,{_normalize:function(_11d0,_11d1){var parse=_11d0.parse===true;if(typeof _11d0.template=="string"){var _11d2=_11d0.templateFunc||(dojo.string&&dojo.string.substitute);_11d0=_11d2?_11d2(_11d0.template,_11d0):_11d0;}var type=(typeof _11d0);if(type=="string"||type=="number"){_11d0=_11c7.toDom(_11d0,(_11d1&&_11d1.ownerDocument));if(_11d0.nodeType==11){_11d0=lang._toArray(_11d0.childNodes);}else{_11d0=[_11d0];}}else{if(!lang.isArrayLike(_11d0)){_11d0=[_11d0];}else{if(!lang.isArray(_11d0)){_11d0=lang._toArray(_11d0);}}}if(parse){_11d0._runParse=true;}return _11d0;},_cloneNode:function(node){return node.cloneNode(true);},_place:function(ary,_11d3,_11d4,_11d5){if(_11d3.nodeType!=1&&_11d4=="only"){return;}var rNode=_11d3,_11d6;var _11d7=ary.length;for(var i=_11d7-1;i>=0;i--){var node=(_11d5?this._cloneNode(ary[i]):ary[i]);if(ary._runParse&&dojo.parser&&dojo.parser.parse){if(!_11d6){_11d6=rNode.ownerDocument.createElement("div");}_11d6.appendChild(node);dojo.parser.parse(_11d6);node=_11d6.firstChild;while(_11d6.firstChild){_11d6.removeChild(_11d6.firstChild);}}if(i==_11d7-1){_11c7.place(node,rNode,_11d4);}else{rNode.parentNode.insertBefore(node,rNode);}rNode=node;}},attr:awc(_11ce(_11c9),_11cb),style:awc(_11ce(_11ca),_11cb),addClass:aafe(_11c6.add),removeClass:aafe(_11c6.remove),replaceClass:aafe(_11c6.replace),toggleClass:aafe(_11c6.toggle),empty:aafe(_11c7.empty),removeAttr:aafe(_11c9.remove),position:aam(_11c8.position),marginBox:aam(_11c8.getMarginBox),place:function(_11d8,_11d9){var item=query(_11d8)[0];return this.forEach(function(node){_11c7.place(node,item,_11d9);});},orphan:function(_11da){return (_11da?query._filterResult(this,_11da):this).forEach(_11cc);},adopt:function(_11db,_11dc){return query(_11db).place(this[0],_11dc)._stash(this);},query:function(_11dd){if(!_11dd){return this;}var ret=new _11cd;this.map(function(node){query(_11dd,node).forEach(function(_11de){if(_11de!==undefined){ret.push(_11de);}});});return ret._stash(this);},filter:function(_11df){var a=arguments,items=this,start=0;if(typeof _11df=="string"){items=query._filterResult(this,a[0]);if(a.length==1){return items._stash(this);}start=1;}return this._wrap(array.filter(items,a[start],a[start+1]),this);},addContent:function(_11e0,_11e1){_11e0=this._normalize(_11e0,this[0]);for(var i=0,node;(node=this[i]);i++){this._place(_11e0,node,_11e1,i>0);}return this;}});return _11cd;});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./registry"],function(_11e2,array,_11e3,_11e4,_11e5,_11e6,dom,_11e7,_11e8,_11e9,_11ea,_11eb,_11ec,lang,on,ready,_11ed,topic,win,_11ee){if(!_11ec.isAsync){ready(0,function(){var _11ef=["dijit/_base/manager"];_11e2(_11ef);});}var _11f0={};function _11f1(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _11f2(attr){return function(val){_11e7[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};return _11e6("dijit._WidgetBase",_11ed,{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_11f2("lang"),dir:"",_setDirAttr:_11f2("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,attributeMap:{},_blankGif:_11e4.blankGif||_11e2.toUrl("dojo/resources/blank.gif"),postscript:function(_11f3,_11f4){this.create(_11f3,_11f4);},create:function(_11f5,_11f6){this.srcNodeRef=dom.byId(_11f6);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_11f5){this.params=_11f5;lang.mixin(this,_11f5);}this.postMixInProperties();if(!this.id){this.id=_11ee.getUniqueId(this.declaredClass.replace(/\./g,"_"));}_11ee.add(this);this.buildRendering();if(this.domNode){this._applyAttributes();var _11f7=this.srcNodeRef;if(_11f7&&_11f7.parentNode&&this.domNode!==_11f7){_11f7.parentNode.replaceChild(this.domNode,_11f7);}}if(this.domNode){this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(this.srcNodeRef&&!this.srcNodeRef.parentNode){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var proto=ctor.prototype;for(var _11f8 in proto){if(_11f8 in this.attributeMap){continue;}var _11f9="_set"+_11f8.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_11f9 in proto){list.push(_11f8);}}}array.forEach(list,function(attr){if(this.params&&attr in this.params){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(var param in this.params){this.set(param,this[param]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||_11e9.create("div");}if(this.baseClass){var _11fa=this.baseClass.split(" ");if(!this.isLeftToRight()){_11fa=_11fa.concat(array.map(_11fa,function(name){return name+"Rtl";}));}_11e8.add(this.domNode,_11fa);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;array.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_11fb){this._beingDestroyed=true;this.destroyDescendants(_11fb);this.destroy(_11fb);},destroy:function(_11fc){this._beingDestroyed=true;this.uninitialize();var c;while(c=this._connects.pop()){c.remove();}var w;while(w=this._supportingWidgets.pop()){if(w.destroyRecursive){w.destroyRecursive();}else{if(w.destroy){w.destroy();}}}this.destroyRendering(_11fc);_11ee.remove(this.id);this._destroyed=true;},destroyRendering:function(_11fd){if(this.bgIframe){this.bgIframe.destroy(_11fd);delete this.bgIframe;}if(this.domNode){if(_11fd){_11e7.remove(this.domNode,"widgetId");}else{_11e9.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_11fd){_11e9.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_11fe){array.forEach(this.getChildren(),function(_11ff){if(_11ff.destroyRecursive){_11ff.destroyRecursive(_11fe);}});},uninitialize:function(){return false;},_setStyleAttr:function(value){var _1200=this.domNode;if(lang.isObject(value)){_11eb.set(_1200,value);}else{if(_1200.style.cssText){_1200.style.cssText+="; "+value;}else{_1200.style.cssText=value;}}this._set("style",value);},_attrToDom:function(attr,value,_1201){_1201=arguments.length>=3?_1201:this.attributeMap[attr];array.forEach(lang.isArray(_1201)?_1201:[_1201],function(_1202){var _1203=this[_1202.node||_1202||"domNode"];var type=_1202.type||"attribute";switch(type){case "attribute":if(lang.isFunction(value)){value=lang.hitch(this,value);}var _1204=_1202.attribute?_1202.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);_11e7.set(_1203,_1204,value);break;case "innerText":_1203.innerHTML="";_1203.appendChild(win.doc.createTextNode(value));break;case "innerHTML":_1203.innerHTML=value;break;case "class":_11e8.replace(_1203,value,this[attr]);break;}},this);},get:function(name){var names=this._getAttrNames(name);return this[names.g]?this[names.g]():this[name];},set:function(name,value){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var names=this._getAttrNames(name),_1205=this[names.s];if(lang.isFunction(_1205)){var _1206=_1205.apply(this,Array.prototype.slice.call(arguments,1));}else{var _1207=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_1207].tagName,_1208=_11f0[tag]||(_11f0[tag]=_11f1(this[_1207])),map=name in this.attributeMap?this.attributeMap[name]:names.s in this?this[names.s]:((names.l in _1208&&typeof value!="function")||/^aria-|^data-|^role$/.test(name))?_1207:null;if(map!=null){this._attrToDom(name,value,map);}this._set(name,value);}return _1206||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,value){var _1209=this[name];this[name]=value;if(this._watchCallbacks&&this._created&&value!==_1209){this._watchCallbacks(name,_1209,value);}},on:function(type,func){return _11e3.after(this,this._onMap(type),func,true);},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_11ee.findWidgets(this.containerNode):[];},getParent:function(){return _11ee.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,event,_120a){var _120b=_11e5.connect(obj,event,this,_120a);this._connects.push(_120b);return _120b;},disconnect:function(_120c){var i=array.indexOf(this._connects,_120c);if(i!=-1){_120c.remove();this._connects.splice(i,1);}},subscribe:function(t,_120d){var _120e=topic.subscribe(t,lang.hitch(this,_120d));this._connects.push(_120e);return _120e;},unsubscribe:function(_120f){this.disconnect(_120f);},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_11ea.isBodyLtr();},isFocusable:function(){return this.focus&&(_11eb.get(this.domNode,"display")!="none");},placeAt:function(_1210,_1211){if(_1210.declaredClass&&_1210.addChild){_1210.addChild(this,_1211);}else{_11e9.place(this.domNode,_1210,_1211);}return this;},getTextDir:function(text,_1212){return _1212;},applyTextDir:function(){}});});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_1213){dojo.cookie=function(name,value,props){var c=document.cookie,ret;if(arguments.length==1){var _1214=c.match(new RegExp("(?:^|; )"+_1213.escapeString(name)+"=([^;]*)"));ret=_1214?decodeURIComponent(_1214[1]):undefined;}else{props=props||{};var exp=props.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=props.expires=d;}if(exp&&exp.toUTCString){props.expires=exp.toUTCString();}value=encodeURIComponent(value);var _1215=name+"="+value,_1216;for(_1216 in props){_1215+="; "+_1216;var _1217=props[_1216];if(_1217!==true){_1215+="="+_1217;}}document.cookie=_1215;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dojo/_base/fx":function(){define(["./kernel","./lang","../Evented","./Color","./connect","./sniff","../dom","../dom-style"],function(dojo,lang,_1218,Color,_1219,has,dom,style){var _121a=lang.mixin;dojo._Line=function(start,end){this.start=start;this.end=end;};dojo._Line.prototype.getValue=function(n){return ((this.end-this.start)*n)+this.start;};dojo.Animation=function(args){_121a(this,args);if(lang.isArray(this.curve)){this.curve=new dojo._Line(this.curve[0],this.curve[1]);}};dojo.Animation.prototype=new _1218();dojo._Animation=dojo.Animation;lang.extend(dojo.Animation,{duration:350,repeat:0,rate:20,_percent:0,_startRepeatCount:0,_getStep:function(){var _121b=this._percent,_121c=this.easing;return _121c?_121c(_121b):_121b;},_fire:function(evt,args){var a=args||[];if(this[evt]){if(dojo.config.debugAtAllCosts){this[evt].apply(this,a);}else{try{this[evt].apply(this,a);}catch(e){console.error("exception in animation handler for:",evt);console.error(e);}}}return this;},play:function(delay,_121d){var _121e=this;if(_121e._delayTimer){_121e._clearTimer();}if(_121d){_121e._stopTimer();_121e._active=_121e._paused=false;_121e._percent=0;}else{if(_121e._active&&!_121e._paused){return _121e;}}_121e._fire("beforeBegin",[_121e.node]);var de=delay||_121e.delay,_121f=lang.hitch(_121e,"_play",_121d);if(de>0){_121e._delayTimer=setTimeout(_121f,de);return _121e;}_121f();return _121e;},_play:function(_1220){var _1221=this;if(_1221._delayTimer){_1221._clearTimer();}_1221._startTime=new Date().valueOf();if(_1221._paused){_1221._startTime-=_1221.duration*_1221._percent;}_1221._active=true;_1221._paused=false;var value=_1221.curve.getValue(_1221._getStep());if(!_1221._percent){if(!_1221._startRepeatCount){_1221._startRepeatCount=_1221.repeat;}_1221._fire("onBegin",[value]);}_1221._fire("onPlay",[value]);_1221._cycle();return _1221;},pause:function(){var _1222=this;if(_1222._delayTimer){_1222._clearTimer();}_1222._stopTimer();if(!_1222._active){return _1222;}_1222._paused=true;_1222._fire("onPause",[_1222.curve.getValue(_1222._getStep())]);return _1222;},gotoPercent:function(_1223,_1224){var _1225=this;_1225._stopTimer();_1225._active=_1225._paused=true;_1225._percent=_1223;if(_1224){_1225.play();}return _1225;},stop:function(_1226){var _1227=this;if(_1227._delayTimer){_1227._clearTimer();}if(!_1227._timer){return _1227;}_1227._stopTimer();if(_1226){_1227._percent=1;}_1227._fire("onStop",[_1227.curve.getValue(_1227._getStep())]);_1227._active=_1227._paused=false;return _1227;},status:function(){if(this._active){return this._paused?"paused":"playing";}return "stopped";},_cycle:function(){var _1228=this;if(_1228._active){var curr=new Date().valueOf();var step=(curr-_1228._startTime)/(_1228.duration);if(step>=1){step=1;}_1228._percent=step;if(_1228.easing){step=_1228.easing(step);}_1228._fire("onAnimate",[_1228.curve.getValue(step)]);if(_1228._percent<1){_1228._startTimer();}else{_1228._active=false;if(_1228.repeat>0){_1228.repeat--;_1228.play(null,true);}else{if(_1228.repeat==-1){_1228.play(null,true);}else{if(_1228._startRepeatCount){_1228.repeat=_1228._startRepeatCount;_1228._startRepeatCount=0;}}}_1228._percent=0;_1228._fire("onEnd",[_1228.node]);!_1228.repeat&&_1228._stopTimer();}}return _1228;},_clearTimer:function(){clearTimeout(this._delayTimer);delete this._delayTimer;}});var ctr=0,timer=null,_1229={run:function(){}};lang.extend(dojo.Animation,{_startTimer:function(){if(!this._timer){this._timer=_1219.connect(_1229,"run",this,"_cycle");ctr++;}if(!timer){timer=setInterval(lang.hitch(_1229,"run"),this.rate);}},_stopTimer:function(){if(this._timer){_1219.disconnect(this._timer);this._timer=null;ctr--;}if(ctr<=0){clearInterval(timer);timer=null;ctr=0;}}});var _122a=has("ie")?function(node){var ns=node.style;if(!ns.width.length&&style.get(node,"width")=="auto"){ns.width="auto";}}:function(){};dojo._fade=function(args){args.node=dom.byId(args.node);var fArgs=_121a({properties:{}},args),props=(fArgs.properties.opacity={});props.start=!("start" in fArgs)?function(){return +style.get(fArgs.node,"opacity")||0;}:fArgs.start;props.end=fArgs.end;var anim=dojo.animateProperty(fArgs);_1219.connect(anim,"beforeBegin",lang.partial(_122a,fArgs.node));return anim;};dojo.fadeIn=function(args){return dojo._fade(_121a({end:1},args));};dojo.fadeOut=function(args){return dojo._fade(_121a({end:0},args));};dojo._defaultEasing=function(n){return 0.5+((Math.sin((n+1.5)*Math.PI))/2);};var _122b=function(_122c){this._properties=_122c;for(var p in _122c){var prop=_122c[p];if(prop.start instanceof Color){prop.tempColor=new Color();}}};_122b.prototype.getValue=function(r){var ret={};for(var p in this._properties){var prop=this._properties[p],start=prop.start;if(start instanceof Color){ret[p]=Color.blendColors(start,prop.end,r,prop.tempColor).toCss();}else{if(!lang.isArray(start)){ret[p]=((prop.end-start)*r)+start+(p!="opacity"?prop.units||"px":0);}}}return ret;};dojo.animateProperty=function(args){var n=args.node=dom.byId(args.node);if(!args.easing){args.easing=dojo._defaultEasing;}var anim=new dojo.Animation(args);_1219.connect(anim,"beforeBegin",anim,function(){var pm={};for(var p in this.properties){if(p=="width"||p=="height"){this.node.display="block";}var prop=this.properties[p];if(lang.isFunction(prop)){prop=prop(n);}prop=pm[p]=_121a({},(lang.isObject(prop)?prop:{end:prop}));if(lang.isFunction(prop.start)){prop.start=prop.start(n);}if(lang.isFunction(prop.end)){prop.end=prop.end(n);}var _122d=(p.toLowerCase().indexOf("color")>=0);function _122e(node,p){var v={height:node.offsetHeight,width:node.offsetWidth}[p];if(v!==undefined){return v;}v=style.get(node,p);return (p=="opacity")?+v:(_122d?v:parseFloat(v));};if(!("end" in prop)){prop.end=_122e(n,p);}else{if(!("start" in prop)){prop.start=_122e(n,p);}}if(_122d){prop.start=new Color(prop.start);prop.end=new Color(prop.end);}else{prop.start=(p=="opacity")?+prop.start:parseFloat(prop.start);}}this.curve=new _122b(pm);});_1219.connect(anim,"onAnimate",lang.hitch(style,"set",anim.node));return anim;};dojo.anim=function(node,_122f,_1230,_1231,onEnd,delay){return dojo.animateProperty({node:node,duration:_1230||dojo.Animation.prototype.duration,properties:_122f,easing:_1231,onEnd:onEnd}).play(delay||0);};return {_Line:dojo._Line,Animation:dojo.Animation,_fade:dojo._fade,fadeIn:dojo.fadeIn,fadeOut:dojo.fadeOut,_defaultEasing:dojo._defaultEasing,animateProperty:dojo.animateProperty,anim:dojo.anim};});},"dijit/_editor/html":function(){define("dijit/_editor/html",["dojo/_base/lang","dojo/_base/sniff",".."],function(lang,has,dijit){lang.getObject("_editor",true,dijit);dijit._editor.escapeXml=function(str,_1232){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_1232){str=str.replace(/'/gm,"&#39;");}return str;};dijit._editor.getNodeHtml=function(node){var _1233;switch(node.nodeType){case 1:var lName=node.nodeName.toLowerCase();if(!lName||lName.charAt(0)=="/"){return "";}_1233="<"+lName;var _1234=[];var attr;if(has("ie")&&node.outerHTML){var s=node.outerHTML;s=s.substr(0,s.indexOf(">")).replace(/(['"])[^"']*\1/g,"");var reg=/(\b\w+)\s?=/g;var m,key;while((m=reg.exec(s))){key=m[1];if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(node.getAttribute("_djrealurl")){_1234.push([key,node.getAttribute("_djrealurl")]);continue;}}var val,match;switch(key){case "style":val=node.style.cssText.toLowerCase();break;case "class":val=node.className;break;case "width":if(lName==="img"){match=/width=(\S+)/i.exec(s);if(match){val=match[1];}break;}case "height":if(lName==="img"){match=/height=(\S+)/i.exec(s);if(match){val=match[1];}break;}default:val=node.getAttribute(key);}if(val!=null){_1234.push([key,val.toString()]);}}}}else{var i=0;while((attr=node.attributes[i++])){var n=attr.name;if(n.substr(0,3)!="_dj"){var v=attr.value;if(n=="src"||n=="href"){if(node.getAttribute("_djrealurl")){v=node.getAttribute("_djrealurl");}}_1234.push([n,v]);}}}_1234.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((attr=_1234[j++])){_1233+=" "+attr[0]+"=\""+(lang.isString(attr[1])?dijit._editor.escapeXml(attr[1],true):attr[1])+"\"";}if(lName==="script"){_1233+=">"+node.innerHTML+"</"+lName+">";}else{if(node.childNodes.length){_1233+=">"+dijit._editor.getChildrenHtml(node)+"</"+lName+">";}else{switch(lName){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_1233+=" />";break;default:_1233+="></"+lName+">";}}}break;case 4:case 3:_1233=dijit._editor.escapeXml(node.nodeValue,true);break;case 8:_1233="<!--"+dijit._editor.escapeXml(node.nodeValue,true)+"-->";break;default:_1233="<!-- Element not recognized - Type: "+node.nodeType+" Name: "+node.nodeName+"-->";}return _1233;};dijit._editor.getChildrenHtml=function(dom){var out="";if(!dom){return out;}var nodes=dom["childNodes"]||dom;var _1235=!has("ie")||nodes!==dom;var node,i=0;while((node=nodes[i++])){if(!_1235||node.parentNode==dom){out+=dijit._editor.getNodeHtml(node);}}return out;};return dijit._editor;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./_base/sniff","./_base/window"],function(_1236,lang,ready,has,_1237){var html=_1237.doc.documentElement,ie=has("ie"),opera=has("opera"),maj=Math.floor,ff=has("ff"),_1238=_1236.boxModel.replace(/-/,""),_1239={"dj_ie":ie,"dj_ie6":maj(ie)==6,"dj_ie7":maj(ie)==7,"dj_ie8":maj(ie)==8,"dj_ie9":maj(ie)==9,"dj_quirks":has("quirks"),"dj_iequirks":ie&&has("quirks"),"dj_opera":opera,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ff3":maj(ff)==3};_1239["dj_"+_1238]=true;var _123a="";for(var clz in _1239){if(_1239[clz]){_123a+=clz+" ";}}html.className=lang.trim(html.className+" "+_123a);ready(90,function(){if(!_1236.isBodyLtr()){var _123b="dj_rtl dijitRtl "+_123a.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_123b+"dj_rtl dijitRtl "+_123a.replace(/ /g,"-rtl "));}});return has;});},"dojo/_base/NodeList":function(){define(["./kernel","../query","./array","./html","../NodeList-dom"],function(dojo,query,array){var _123c=query.NodeList;var nlp=_123c.prototype;nlp.connect=_123c._adaptAsForEach(function(){return dojo.connect.apply(this,arguments);});nlp.coords=_123c._adaptAsMap(dojo.coords);_123c.events=["blur","focus","change","click","error","keydown","keypress","keyup","load","mousedown","mouseenter","mouseleave","mousemove","mouseout","mouseover","mouseup","submit"];array.forEach(_123c.events,function(evt){var _123d="on"+evt;nlp[_123d]=function(a,b){return this.connect(_123d,a,b);};});dojo.NodeList=_123c;return dojo.NodeList;});},"dijit/form/nls/validate":function(){define({root:({invalidMessage:"The value entered is not valid.",missingMessage:"This value is required.",rangeMessage:"This value is out of range."}),"zh":true,"zh-tw":true,"tr":true,"th":true,"sv":true,"sl":true,"sk":true,"ru":true,"ro":true,"pt":true,"pt-pt":true,"pl":true,"nl":true,"nb":true,"ko":true,"kk":true,"ja":true,"it":true,"hu":true,"he":true,"fr":true,"fi":true,"es":true,"el":true,"de":true,"da":true,"cs":true,"ca":true,"ar":true});},"dojox/charting/scaler/primitive":function(){define("dojox/charting/scaler/primitive",["dojo/_base/lang"],function(lang){var _123e=lang.getObject("dojox.charting.scaler.primitive",true);return lang.mixin(_123e,{buildScaler:function(min,max,span,_123f){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:_123e};},buildTicks:function(_1240,_1241){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_1242){var _1243=_1242.bounds.from,scale=_1242.bounds.scale;return function(x){return (x-_1243)*scale;};},getTransformerFromPlot:function(_1244){var _1245=_1244.bounds.from,scale=_1244.bounds.scale;return function(x){return x/scale+_1245;};}});});},"dojox/charting/themes/PlotKit/red":function(){define("dojox/charting/themes/PlotKit/red",["./base","../../Theme"],function(pk,Theme){pk.red=pk.base.clone();pk.red.chart.fill=pk.red.plotarea.fill="#f5e6e6";pk.red.colors=Theme.defineColors({hue:1,saturation:60,low:40,high:88});return pk.red;});},"dojox/lang/functional/reversed":function(){define("dojox/lang/functional/reversed",["dojo/_base/lang","dojo/_base/window","./lambda"],function(lang,win,df){lang.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dijit/form/_FormWidget":function(){define("dijit/form/_FormWidget",["dojo/_base/declare","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_1246,_1247,ready,_1248,_1249,_124a,_124b){if(!_1247.isAsync){ready(0,function(){var _124c=["dijit/form/_FormValueWidget"];require(_124c);});}return _1246("dijit.form._FormWidget",[_1248,_124a,_1249,_124b],{setDisabled:function(_124d){_1247.deprecated("setDisabled("+_124d+") is deprecated. Use set('disabled',"+_124d+") instead.","","2.0");this.set("disabled",_124d);},setValue:function(value){_1247.deprecated("dijit.form._FormWidget:setValue("+value+") is deprecated.  Use set('value',"+value+") instead.","","2.0");this.set("value",value);},getValue:function(){_1247.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=this.name?("name=\""+this.name.replace(/'/g,"&quot;")+"\""):"";this.inherited(arguments);},_setTypeAttr:null});});},"dojo/query":function(){define(["./_base/kernel","./has","./dom","./on","./_base/array","./_base/lang","./selector/_loader","./selector/_loader!default"],function(dojo,has,dom,on,array,lang,_124e,_124f){"use strict";has.add("array-extensible",function(){return lang.delegate([],{length:1}).length==1&&!has("bug-for-in-skips-shadowed");});var ap=Array.prototype,aps=ap.slice,apc=ap.concat,_1250=array.forEach;var tnl=function(a,_1251,_1252){var _1253=new (_1252||this._NodeListCtor||nl)(a);return _1251?_1253._stash(_1251):_1253;};var _1254=function(f,a,o){a=[0].concat(aps.call(a,0));o=o||dojo.global;return function(node){a[0]=node;return f.apply(o,a);};};var _1255=function(f,o){return function(){this.forEach(_1254(f,arguments,o));return this;};};var _1256=function(f,o){return function(){return this.map(_1254(f,arguments,o));};};var _1257=function(f,o){return function(){return this.filter(_1254(f,arguments,o));};};var _1258=function(f,g,o){return function(){var a=arguments,body=_1254(f,a,o);if(g.call(o||dojo.global,a)){return this.map(body);}this.forEach(body);return this;};};var _1259=function(array){var isNew=this instanceof nl&&has("array-extensible");if(typeof array=="number"){array=Array(array);}var _125a=(array&&"length" in array)?array:arguments;if(isNew||!_125a.sort){var _125b=isNew?this:[],l=_125b.length=_125a.length;for(var i=0;i<l;i++){_125b[i]=_125a[i];}if(isNew){return _125b;}_125a=_125b;}lang._mixin(_125a,nlp);_125a._NodeListCtor=function(array){return nl(array);};return _125a;};var nl=_1259,nlp=nl.prototype=has("array-extensible")?[]:{};nl._wrap=nlp._wrap=tnl;nl._adaptAsMap=_1256;nl._adaptAsForEach=_1255;nl._adaptAsFilter=_1257;nl._adaptWithCondition=_1258;_1250(["slice","splice"],function(name){var f=ap[name];nlp[name]=function(){return this._wrap(f.apply(this,arguments),name=="slice"?this:null);};});_1250(["indexOf","lastIndexOf","every","some"],function(name){var f=array[name];nlp[name]=function(){return f.apply(dojo,[this].concat(aps.call(arguments,0)));};});lang.extend(_1259,{constructor:nl,_NodeListCtor:nl,toString:function(){return this.join(",");},_stash:function(_125c){this._parent=_125c;return this;},on:function(_125d,_125e){var _125f=this.map(function(node){return on(node,_125d,_125e);});_125f.remove=function(){for(var i=0;i<_125f.length;i++){_125f[i].remove();}};return _125f;},end:function(){if(this._parent){return this._parent;}else{return new this._NodeListCtor(0);}},concat:function(item){var t=lang.isArray(this)?this:aps.call(this,0),m=array.map(arguments,function(a){return a&&!lang.isArray(a)&&(typeof _1259!="undefined"&&a.constructor===_1259||a.constructor===this._NodeListCtor)?aps.call(a,0):a;});return this._wrap(apc.apply(t,m),this);},map:function(func,obj){return this._wrap(array.map(this,func,obj),this);},forEach:function(_1260,_1261){_1250(this,_1260,_1261);return this;},filter:function(_1262){var a=arguments,items=this,start=0;if(typeof _1262=="string"){items=query._filterResult(this,a[0]);if(a.length==1){return items._stash(this);}start=1;}return this._wrap(array.filter(items,a[start],a[start+1]),this);},instantiate:function(_1263,_1264){var c=lang.isFunction(_1263)?_1263:lang.getObject(_1263);_1264=_1264||{};return this.forEach(function(node){new c(_1264,node);});},at:function(){var t=new this._NodeListCtor(0);_1250(arguments,function(i){if(i<0){i=this.length+i;}if(this[i]){t.push(this[i]);}},this);return t._stash(this);}});function _1265(_1266,_1267){var query=function(query,root){if(typeof root=="string"){root=dom.byId(root);if(!root){return new _1267([]);}}var _1268=typeof query=="string"?_1266(query,root):query.orphan?query:[query];if(_1268.orphan){return _1268;}return new _1267(_1268);};query.matches=_1266.match||function(node,_1269,root){return query.filter([node],_1269,root).length>0;};query.filter=_1266.filter||function(nodes,_126a,root){return query(_126a,root).filter(function(node){return array.indexOf(nodes,node)>-1;});};if(typeof _1266!="function"){var _126b=_1266.search;_1266=function(_126c,root){return _126b(root||document,_126c);};}return query;};var query=_1265(_124f,_1259);dojo.query=_1265(_124f,function(array){return _1259(array);});query.load=function(id,_126d,_126e,_126f){_124e.load(id,_126d,function(_1270){_126e(_1265(_1270,_1259));});};dojo._filterQueryResult=query._filterResult=function(nodes,_1271,root){return new _1259(query.filter(nodes,_1271,root));};dojo.NodeList=query.NodeList=_1259;return query;});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _1272={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_1272.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _1272.bounceIn(n*2)/2;}return (_1272.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_1272);return _1272;});},"dojox/charting/axis2d/Invisible":function(){define("dojox/charting/axis2d/Invisible",["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/string"],function(lang,_1273,Base,lin,g,du,df,_1274){var merge=du.merge,_1275=4,_1276=45;return _1273("dojox.charting.axis2d.Invisible",Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null},constructor:function(chart,_1277){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_1277);du.updateWithPattern(this.opt,_1277,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(scale,_1278){this.scale=scale;this.offset=_1278;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},_groupLabelWidth:function(_1279,font,_127a){if(!_1279.length){return 0;}if(lang.isObject(_1279[0])){_1279=df.map(_1279,function(label){return label.text;});}if(_127a){_1279=df.map(_1279,function(label){return lang.trim(label).length==0?"":label.substring(0,_127a)+this.trailingSymbol;},this);}var s=_1279.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},calculate:function(min,max,span,_127b){if(this.initialized()){return this;}var o=this.opt;this.labels="labels" in o?o.labels:_127b;this.scaler=lin.buildScaler(min,max,span,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,span,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var ta=this.chart.theme.axis,_127c=0,_127d=o.rotation%360,_127e=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=_127e?g.normalizedLength(g.splitFontString(_127e).size):0,cosr=Math.abs(Math.cos(_127d*Math.PI/180)),sinr=Math.abs(Math.sin(_127d*Math.PI/180));if(_127d<0){_127d+=360;}if(size){if(this.vertical?_127d!=0&&_127d!=180:_127d!=90&&_127d!=270){if(this.labels){_127c=this._groupLabelWidth(this.labels,_127e,o.maxLabelCharCount);}else{var _127f=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}t.push(_1274.rep("9",_127f));var _1280=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(_1280>0){t.push(".");t.push(_1274.rep("9",_1280));}_127c=g._base._getTextBox(t.join(""),{font:_127e}).w;}_127c=o.maxLabelSize?Math.min(o.maxLabelSize,_127c):_127c;}else{_127c=size;}switch(_127d){case 0:case 90:case 180:case 270:break;default:var gap1=Math.sqrt(_127c*_127c+size*size),gap2=this.vertical?size*cosr+_127c*sinr:_127c*cosr+size*sinr;_127c=Math.min(gap1,gap2);break;}}this.scaler.minMinorStep=_127c+_1275;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dijit/MenuItem":function(){require({cache:{"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n"}});define("dijit/MenuItem",["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/event","dojo/_base/kernel","dojo/_base/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_1281,dom,_1282,_1283,event,_1284,has,_1285,_1286,_1287,_1288,_1289){return _1281("dijit.MenuItem",[_1285,_1286,_1287,_1288],{templateString:_1289,baseClass:"dijitMenuItem",label:"",_setLabelAttr:{node:"containerNode",type:"innerHTML"},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_128a){if(_128a&&!("label" in this.params)){this.set("label",_128a.innerHTML);}},buildRendering:function(){this.inherited(arguments);var label=this.id+"_text";_1282.set(this.containerNode,"id",label);if(this.accelKeyNode){_1282.set(this.accelKeyNode,"id",this.id+"_accel");label+=" "+this.id+"_accel";}this.domNode.setAttribute("aria-labelledby",label);dom.setSelectable(this.domNode,false);},_onHover:function(){this.getParent().onItemHover(this);},_onUnhover:function(){this.getParent().onItemUnhover(this);this._set("hovering",false);},_onClick:function(evt){this.getParent().onItemClick(this,evt);event.stop(evt);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_onFocus:function(){this._setSelected(true);this.getParent()._onItemFocus(this);this.inherited(arguments);},_setSelected:function(_128b){_1283.toggle(this.domNode,"dijitMenuItemSelected",_128b);},setLabel:function(_128c){_1284.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_128c);},setDisabled:function(_128d){_1284.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_128d);},_setDisabledAttr:function(value){this.focusNode.setAttribute("aria-disabled",value?"true":"false");this._set("disabled",value);},_setAccelKeyAttr:function(value){this.accelKeyNode.style.display=value?"":"none";this.accelKeyNode.innerHTML=value;_1282.set(this.containerNode,"colSpan",value?"1":"2");this._set("accelKey",value);}});});},"dojox/charting/axis2d/common":function(){define("dojox/charting/axis2d/common",["dojo/_base/lang","dojo/_base/html","dojo/_base/window","dojo/dom-geometry","dojox/gfx"],function(lang,html,win,_128e,g){var _128f=lang.getObject("dojox.charting.axis2d.common",true);var _1290=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _1291=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _128e.getMarginBox(n).w;}};return lang.mixin(_128f,{createText:{gfx:function(chart,_1292,x,y,align,text,font,_1293){return _1292.createText({x:x,y:y,text:text,align:align}).setFont(font).setFill(_1293);},html:function(chart,_1294,x,y,align,text,font,_1295,_1296){var p=win.doc.createElement("div"),s=p.style,_1297;if(chart.getTextDir){p.dir=chart.getTextDir(text);}_1290(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_1295;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_1296){_1297=_1291(p);}if(p.dir=="rtl"){x+=_1296?_1296:_1297;}win.body().removeChild(p);s.position="relative";if(_1296){s.width=_1296+"px";switch(align){case "middle":s.textAlign="center";s.left=(x-_1296/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_1296)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(align){case "middle":s.left=Math.floor(x-_1297/2)+"px";break;case "end":s.left=Math.floor(x-_1297)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_1290(w);w.width="0px";w.height="0px";wrap.appendChild(p);chart.node.insertBefore(wrap,chart.node.firstChild);return wrap;}}});});},"dojox/grid/_EditManager":function(){define("dojox/grid/_EditManager",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,array,_1298,_1299,has,util){return _1298("dojox.grid._EditManager",null,{constructor:function(_129a){this.grid=_129a;if(has("ie")){this.connections=[_1299.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];}else{this.connections=[_1299.connect(this.grid,"onBlur",this,"apply")];}},info:{},destroy:function(){array.forEach(this.connections,_1299.disconnect);},cellFocus:function(_129b,_129c){if(this.grid.singleClickEdit||this.isEditRow(_129c)){this.setEditCell(_129b,_129c);}else{this.apply();}if(this.isEditing()||(_129b&&_129b.editable&&_129b.alwaysEditing)){this._focusEditor(_129b,_129c);}},rowClick:function(e){if(this.isEditing()&&!this.isEditRow(e.rowIndex)){this.apply();}},styleRow:function(inRow){if(inRow.index==this.info.rowIndex){inRow.customClasses+=" dojoxGridRowEditing";}},dispatchEvent:function(e){var c=e.cell,ed=(c&&c["editable"])?c:0;return ed&&ed.dispatchEvent(e.dispatch,e);},isEditing:function(){return this.info.rowIndex!==undefined;},isEditCell:function(_129d,_129e){return (this.info.rowIndex===_129d)&&(this.info.cell.index==_129e);},isEditRow:function(_129f){return this.info.rowIndex===_129f;},setEditCell:function(_12a0,_12a1){if(!this.isEditCell(_12a1,_12a0.index)&&this.grid.canEdit&&this.grid.canEdit(_12a0,_12a1)){this.start(_12a0,_12a1,this.isEditRow(_12a1)||_12a0.editable);}},_focusEditor:function(_12a2,_12a3){util.fire(_12a2,"focus",[_12a3]);},focusEditor:function(){if(this.isEditing()){this._focusEditor(this.info.cell,this.info.rowIndex);}},_boomerangWindow:500,_shouldCatchBoomerang:function(){return this._catchBoomerang>new Date().getTime();},_boomerangFocus:function(){if(this._shouldCatchBoomerang()){this.grid.focus.focusGrid();this.focusEditor();this._catchBoomerang=0;}},_doCatchBoomerang:function(){if(has("ie")){this._catchBoomerang=new Date().getTime()+this._boomerangWindow;}},start:function(_12a4,_12a5,_12a6){if(!this._isValidInput()){return;}this.grid.beginUpdate();this.editorApply();if(this.isEditing()&&!this.isEditRow(_12a5)){this.applyRowEdit();this.grid.updateRow(_12a5);}if(_12a6){this.info={cell:_12a4,rowIndex:_12a5};this.grid.doStartEdit(_12a4,_12a5);this.grid.updateRow(_12a5);}else{this.info={};}this.grid.endUpdate();this.grid.focus.focusGrid();this._focusEditor(_12a4,_12a5);this._doCatchBoomerang();},_editorDo:function(_12a7){var c=this.info.cell;if(c&&c.editable){c[_12a7](this.info.rowIndex);}},editorApply:function(){this._editorDo("apply");},editorCancel:function(){this._editorDo("cancel");},applyCellEdit:function(_12a8,_12a9,_12aa){if(this.grid.canEdit(_12a9,_12aa)){this.grid.doApplyCellEdit(_12a8,_12aa,_12a9.field);}},applyRowEdit:function(){this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);},apply:function(){if(this.isEditing()&&this._isValidInput()){this.grid.beginUpdate();this.editorApply();this.applyRowEdit();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},cancel:function(){if(this.isEditing()){this.grid.beginUpdate();this.editorCancel();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},save:function(_12ab,_12ac){var c=this.info.cell;if(this.isEditRow(_12ab)&&(!_12ac||c.view==_12ac)&&c.editable){c.save(c,this.info.rowIndex);}},restore:function(_12ad,_12ae){var c=this.info.cell;if(this.isEditRow(_12ae)&&c.view==_12ad&&c.editable){c.restore(this.info.rowIndex);}},_isValidInput:function(){var w=(this.info.cell||{}).widget;if(!w||!w.isValid){return true;}w.focused=true;return w.isValid(true);}});});},"dojox/grid/_ViewManager":function(){define("dojox/grid/_ViewManager",["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_12af,has,_12b0){return _12af("dojox.grid._ViewManager",null,{constructor:function(_12b1){this.grid=_12b1;},defaultWidth:200,views:[],resize:function(){this.onEach("resize");},render:function(){this.onEach("render");},addView:function(_12b2){_12b2.idx=this.views.length;this.views.push(_12b2);},destroyViews:function(){for(var i=0,v;v=this.views[i];i++){v.destroy();}this.views=[];},getContentNodes:function(){var nodes=[];for(var i=0,v;v=this.views[i];i++){nodes.push(v.contentNode);}return nodes;},forEach:function(_12b3){for(var i=0,v;v=this.views[i];i++){_12b3(v,i);}},onEach:function(_12b4,_12b5){_12b5=_12b5||[];for(var i=0,v;v=this.views[i];i++){if(_12b4 in v){v[_12b4].apply(v,_12b5);}}},normalizeHeaderNodeHeight:function(){var _12b6=[];for(var i=0,v;(v=this.views[i]);i++){if(v.headerContentNode.firstChild){_12b6.push(v.headerContentNode);}}this.normalizeRowNodeHeights(_12b6);},normalizeRowNodeHeights:function(_12b7){var h=0;var _12b8=[];if(this.grid.rowHeight){h=this.grid.rowHeight;}else{if(_12b7.length<=1){return;}for(var i=0,n;(n=_12b7[i]);i++){if(!_12b0.contains(n,"dojoxGridNonNormalizedCell")){_12b8[i]=n.firstChild.offsetHeight;h=Math.max(h,_12b8[i]);}}h=(h>=0?h:0);if((has("mozilla")||has("ie")>8)&&h){h++;}}for(i=0;(n=_12b7[i]);i++){if(_12b8[i]!=h){n.firstChild.style.height=h+"px";}}},resetHeaderNodeHeight:function(){for(var i=0,v,n;(v=this.views[i]);i++){n=v.headerContentNode.firstChild;if(n){n.style.height="";}}},renormalizeRow:function(_12b9){var _12ba=[];for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_12b9));i++){n.firstChild.style.height="";_12ba.push(n);}this.normalizeRowNodeHeights(_12ba);},getViewWidth:function(_12bb){return this.views[_12bb].getWidth()||this.defaultWidth;},measureHeader:function(){this.resetHeaderNodeHeight();this.forEach(function(_12bc){_12bc.headerContentNode.style.height="";});var h=0;this.forEach(function(_12bd){h=Math.max(_12bd.headerNode.offsetHeight,h);});return h;},measureContent:function(){var h=0;this.forEach(function(_12be){h=Math.max(_12be.domNode.offsetHeight,h);});return h;},findClient:function(_12bf){var c=this.grid.elasticView||-1;if(c<0){for(var i=1,v;(v=this.views[i]);i++){if(v.viewWidth){for(i=1;(v=this.views[i]);i++){if(!v.viewWidth){c=i;break;}}break;}}}if(c<0){c=Math.floor(this.views.length/2);}return c;},arrange:function(l,w){var i,v,vw,len=this.views.length,self=this;var c=(w<=0?len:this.findClient());var _12c0=function(v,l){var ds=v.domNode.style;var hs=v.headerNode.style;if(!self.grid.isLeftToRight()){ds.right=l+"px";if(has("ff")<4||has("webkit")){hs.right=l+v.getScrollbarWidth()+"px";hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";}else{hs.right=l+"px";}}else{ds.left=l+"px";hs.left=l+"px";}ds.top=0+"px";hs.top=0;};for(i=0;(v=this.views[i])&&(i<c);i++){vw=this.getViewWidth(i);v.setSize(vw,0);_12c0(v,l);if(v.headerContentNode&&v.headerContentNode.firstChild){vw=v.getColumnsWidth()+v.getScrollbarWidth();}else{vw=v.domNode.offsetWidth;}l+=vw;}i++;var r=w;for(var j=len-1;(v=this.views[j])&&(i<=j);j--){vw=this.getViewWidth(j);v.setSize(vw,0);vw=v.domNode.offsetWidth;r-=vw;_12c0(v,r);}if(c<len){v=this.views[c];vw=Math.max(1,r-l);v.setSize(vw+"px",0);_12c0(v,l);}return l;},renderRow:function(_12c1,_12c2,_12c3){var _12c4=[];for(var i=0,v,n,_12c5;(v=this.views[i])&&(n=_12c2[i]);i++){_12c5=v.renderRow(_12c1);n.appendChild(_12c5);_12c4.push(_12c5);}if(!_12c3){this.normalizeRowNodeHeights(_12c4);}},rowRemoved:function(_12c6){this.onEach("rowRemoved",[_12c6]);},updateRow:function(_12c7,_12c8){for(var i=0,v;v=this.views[i];i++){v.updateRow(_12c7);}if(!_12c8){this.renormalizeRow(_12c7);}},updateRowStyles:function(_12c9){this.onEach("updateRowStyles",[_12c9]);},setScrollTop:function(inTop){var top=inTop;for(var i=0,v;v=this.views[i];i++){top=v.setScrollTop(inTop);if(has("ie")&&v.headerNode&&v.scrollboxNode){v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;}}return top;},getFirstScrollingView:function(){for(var i=0,v;(v=this.views[i]);i++){if(v.hasHScrollbar()||v.hasVScrollbar()){return v;}}return null;}});});},"dojox/gfx/fx":function(){define("dojox/gfx/fx",["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect"],function(lang,g,m,Color,arr,fx,Hub){var fxg=g.fx={};function _12ca(start,end){this.start=start,this.end=end;};_12ca.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _12cb(start,end,units){this.start=start,this.end=end;this.units=units;};_12cb.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _12cc(start,end){this.start=start,this.end=end;this.temp=new Color();};_12cc.prototype.getValue=function(r){return Color.blendColors(this.start,this.end,r,this.temp);};function _12cd(_12ce){this.values=_12ce;this.length=_12ce.length;};_12cd.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _12cf(_12d0,def){this.values=_12d0;this.def=def?def:{};};_12cf.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _12d1(stack,_12d2){this.stack=stack;this.original=_12d2;};_12d1.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_12d3=f.apply(m,val);if(_12d3 instanceof m.Matrix2D){ret.push(_12d3);}},this);return ret;};var _12d4=new Color(0,0,0,0);function _12d5(prop,obj,name,def){if(prop.values){return new _12cd(prop.values);}var value,start,end;if(prop.start){start=g.normalizeColor(prop.start);}else{start=value=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!value){value=obj?(name?obj[name]:obj):def;}end=value;}return new _12cc(start,end);};function _12d6(prop,obj,name,def){if(prop.values){return new _12cd(prop.values);}var value,start,end;if(prop.start){start=prop.start;}else{start=value=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof value!="number"){value=obj?obj[name]:def;}end=value;}return new _12ca(start,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),shape=args.shape,_12d7;Hub.connect(anim,"beforeBegin",anim,function(){_12d7=shape.getStroke();var prop=args.color,_12d8={},value,start,end;if(prop){_12d8.color=_12d5(prop,_12d7,"color",_12d4);}prop=args.style;if(prop&&prop.values){_12d8.style=new _12cd(prop.values);}prop=args.width;if(prop){_12d8.width=_12d6(prop,_12d7,"width",1);}prop=args.cap;if(prop&&prop.values){_12d8.cap=new _12cd(prop.values);}prop=args.join;if(prop){if(prop.values){_12d8.join=new _12cd(prop.values);}else{start=prop.start?prop.start:(_12d7&&_12d7.join||0);end=prop.end?prop.end:(_12d7&&_12d7.join||0);if(typeof start=="number"&&typeof end=="number"){_12d8.join=new _12ca(start,end);}}}this.curve=new _12cf(_12d8,_12d7);});Hub.connect(anim,"onAnimate",shape,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),shape=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=shape.getFill();var prop=args.color,_12d9={};if(prop){this.curve=_12d5(prop,fill,"",_12d4);}});Hub.connect(anim,"onAnimate",shape,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),shape=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=shape.getFont();var prop=args.style,_12da={},value,start,end;if(prop&&prop.values){_12da.style=new _12cd(prop.values);}prop=args.variant;if(prop&&prop.values){_12da.variant=new _12cd(prop.values);}prop=args.weight;if(prop&&prop.values){_12da.weight=new _12cd(prop.values);}prop=args.family;if(prop&&prop.values){_12da.family=new _12cd(prop.values);}prop=args.size;if(prop&&prop.units){start=parseFloat(prop.start?prop.start:(shape.font&&shape.font.size||"0"));end=parseFloat(prop.end?prop.end:(shape.font&&shape.font.size||"0"));_12da.size=new _12cb(start,end,prop.units);}this.curve=new _12cf(_12da,font);});Hub.connect(anim,"onAnimate",shape,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),shape=args.shape,_12db;Hub.connect(anim,"beforeBegin",anim,function(){_12db=shape.getTransform();this.curve=new _12d1(args.transform,_12db);});Hub.connect(anim,"onAnimate",shape,"setTransform");return anim;};return fxg;});},"dojo/ready":function(){define(["./_base/kernel","./has","require","./domReady","./_base/lang"],function(dojo,has,_12dc,_12dd,lang){var _12de=0,_12df,loadQ=[],_12e0=0,_12e1=function(){_12de=1;dojo._postLoad=dojo.config.afterOnLoad=true;if(loadQ.length){_12df(_12e2);}},_12e2=function(){if(_12de&&!_12e0&&loadQ.length){_12e0=1;var f=loadQ.shift();try{f();}finally{_12e0=0;}_12e0=0;if(loadQ.length){_12df(_12e2);}}};if(1){_12dc.on("idle",_12e2);_12df=function(){if(_12dc.idle()){_12e2();}};}else{_12df=function(){_12dc.ready(_12e2);};}var ready=dojo.ready=dojo.addOnLoad=function(_12e3,_12e4,_12e5){var _12e6=lang._toArray(arguments);if(typeof _12e3!="number"){_12e5=_12e4;_12e4=_12e3;_12e3=1000;}else{_12e6.shift();}_12e5=_12e5?lang.hitch.apply(dojo,_12e6):function(){_12e4();};_12e5.priority=_12e3;for(var i=0;i<loadQ.length&&_12e3>=loadQ[i].priority;i++){}loadQ.splice(i,0,_12e5);_12df();};true||has.add("dojo-config-addOnLoad",1);if(1){var dca=dojo.config.addOnLoad;if(dca){ready[(lang.isArray(dca)?"apply":"call")](dojo,dca);}}if(1&&dojo.config.parseOnLoad&&!dojo.isAsync){ready(99,function(){if(!dojo.parser){dojo.deprecated("Add explicit require(['dojo/parser']);","","2.0");_12dc(["dojo/parser"]);}});}if(1){_12dd(_12e1);}else{_12e1();}return ready;});},"dijit/DropDownMenu":function(){require({cache:{"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n"}});define("dijit/DropDownMenu",["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_12e7,event,keys,_12e8,_12e9,_12ea){return _12e7("dijit.DropDownMenu",[_12ea,_12e9],{templateString:_12e8,baseClass:"dijitMenu",postCreate:function(){var l=this.isLeftToRight();this._openSubMenuKey=l?keys.RIGHT_ARROW:keys.LEFT_ARROW;this._closeSubMenuKey=l?keys.LEFT_ARROW:keys.RIGHT_ARROW;this.connectKeyNavHandlers([keys.UP_ARROW],[keys.DOWN_ARROW]);},_onKeyPress:function(evt){if(evt.ctrlKey||evt.altKey){return;}switch(evt.charOrCode){case this._openSubMenuKey:this._moveToPopup(evt);event.stop(evt);break;case this._closeSubMenuKey:if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{event.stop(evt);}break;}}});});},"dojo/mouse":function(){define(["./_base/kernel","./on","./has","./dom","./_base/window"],function(dojo,on,has,dom,win){has.add("dom-quirks",win.doc&&win.doc.compatMode=="BackCompat");has.add("events-mouseenter",win.doc&&"onmouseenter" in win.doc.createElement("div"));var _12eb;if(has("dom-quirks")||!has("dom-addeventlistener")){_12eb={LEFT:1,MIDDLE:4,RIGHT:2,isButton:function(e,_12ec){return e.button&_12ec;},isLeft:function(e){return e.button&1;},isMiddle:function(e){return e.button&4;},isRight:function(e){return e.button&2;}};}else{_12eb={LEFT:0,MIDDLE:1,RIGHT:2,isButton:function(e,_12ed){return e.button==_12ed;},isLeft:function(e){return e.button==0;},isMiddle:function(e){return e.button==1;},isRight:function(e){return e.button==2;}};}dojo.mouseButtons=_12eb;function _12ee(type,_12ef){var _12f0=function(node,_12f1){return on(node,type,function(evt){if(!dom.isDescendant(evt.relatedTarget,_12ef?evt.target:node)){return _12f1.call(this,evt);}});};if(!_12ef){_12f0.bubble=_12ee(type,true);}return _12f0;};return {enter:_12ee("mouseover"),leave:_12ee("mouseout"),isLeft:_12eb.isLeft,isMiddle:_12eb.isMiddle,isRight:_12eb.isRight};});},"dijit/_base/typematic":function(){define("dijit/_base/typematic",["../typematic"],function(){});},"dojox/lang/functional/sequence":function(){define("dojox/lang/functional/sequence",["dojo/_base/lang","./lambda"],function(lang,df){lang.mixin(df,{repeat:function(n,f,z,o){o=o||dojo.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||dojo.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});return df;});},"dojo/aspect":function(){define([],function(){"use strict";function _12f2(_12f3,type,_12f4,_12f5){var _12f6=_12f3[type];var _12f7=type=="around";var _12f8;if(_12f7){var _12f9=_12f4(function(){return _12f6.advice(this,arguments);});_12f8={remove:function(){_12f8.cancelled=true;},advice:function(_12fa,args){return _12f8.cancelled?_12f6.advice(_12fa,args):_12f9.apply(_12fa,args);}};}else{_12f8={remove:function(){var _12fb=_12f8.previous;var next=_12f8.next;if(!next&&!_12fb){delete _12f3[type];}else{if(_12fb){_12fb.next=next;}else{_12f3[type]=next;}if(next){next.previous=_12fb;}}},advice:_12f4,receiveArguments:_12f5};}if(_12f6&&!_12f7){if(type=="after"){var next=_12f6;while(next){_12f6=next;next=next.next;}_12f6.next=_12f8;_12f8.previous=_12f6;}else{if(type=="before"){_12f3[type]=_12f8;_12f8.next=_12f6;_12f6.previous=_12f8;}}}else{_12f3[type]=_12f8;}return _12f8;};function _12fc(type){return function(_12fd,_12fe,_12ff,_1300){var _1301=_12fd[_12fe],_1302;if(!_1301||_1301.target!=_12fd){_1302=_12fd[_12fe]=function(){var args=arguments;var _1303=_1302.before;while(_1303){args=_1303.advice.apply(this,args)||args;_1303=_1303.next;}if(_1302.around){var _1304=_1302.around.advice(this,args);}var after=_1302.after;while(after){_1304=after.receiveArguments?after.advice.apply(this,args)||_1304:after.advice.call(this,_1304);after=after.next;}return _1304;};if(_1301){_1302.around={advice:function(_1305,args){return _1301.apply(_1305,args);}};}_1302.target=_12fd;}var _1306=_12f2((_1302||_1301),type,_12ff,_1300);_12ff=null;return _1306;};};return {before:_12fc("before"),around:_12fc("around"),after:_12fc("after")};});},"dojo/_base/sniff":function(){define(["./kernel","../has"],function(dojo,has){if(!1){return has;}dojo.isBrowser=true,dojo._name="browser";var _1307=has.add,n=navigator,dua=n.userAgent,dav=n.appVersion,tv=parseFloat(dav),_1308,isAIR,_1309,_130a,_130b,isMac,_130c,_130d,isMoz,isIE,isFF,_130e,isIos,_130f,isWii;if(dua.indexOf("AdobeAIR")>=0){isAIR=1;}_1309=(dav.indexOf("Konqueror")>=0)?tv:0;_130a=parseFloat(dua.split("WebKit/")[1])||undefined;_130b=parseFloat(dua.split("Chrome/")[1])||undefined;isMac=dav.indexOf("Macintosh")>=0;isIos=/iPhone|iPod|iPad/.test(dua);_130f=parseFloat(dua.split("Android ")[1])||undefined;isWii=typeof opera!="undefined"&&opera.wiiremote;var index=Math.max(dav.indexOf("WebKit"),dav.indexOf("Safari"),0);if(index&&!_130b){_130c=parseFloat(dav.split("Version/")[1]);if(!_130c||parseFloat(dav.substr(index+7))<=419.3){_130c=2;}}if(!has("dojo-webkit")){if(dua.indexOf("Opera")>=0){_1308=tv;if(_1308>=9.8){_1308=parseFloat(dua.split("Version/")[1])||tv;}}if(dua.indexOf("Gecko")>=0&&!_1309&&!_130a){_130d=isMoz=tv;}if(isMoz){isFF=parseFloat(dua.split("Firefox/")[1]||dua.split("Minefield/")[1])||undefined;}if(document.all&&!_1308){isIE=parseFloat(dav.split("MSIE ")[1])||undefined;var mode=document.documentMode;if(mode&&mode!=5&&Math.floor(isIE)!=mode){isIE=mode;}}}_130e=document.compatMode=="BackCompat";_1307("opera",dojo.isOpera=_1308);_1307("air",dojo.isAIR=isAIR);_1307("khtml",dojo.isKhtml=_1309);_1307("webkit",dojo.isWebKit=_130a);_1307("chrome",dojo.isChrome=_130b);_1307("mac",dojo.isMac=isMac);_1307("safari",dojo.isSafari=_130c);_1307("mozilla",dojo.isMozilla=dojo.isMoz=_130d);_1307("ie",dojo.isIE=isIE);_1307("ff",dojo.isFF=isFF);_1307("quirks",dojo.isQuirks=_130e);_1307("ios",dojo.isIos=isIos);_1307("android",dojo.isAndroid=_130f);dojo.locale=dojo.locale||(isIE?n.userLanguage:n.language).toLowerCase();return has;});},"dojox/grid/_Grid":function(){require({cache:{"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n"}});define("dojox/grid/_Grid",["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(dojo,dojox,_1310,_1311,_1312,_1313,_1314,_1315,_1316,_1317,_1318,_1319,_131a,util,_131b,_131c,_131d,_131e,_131f,array,lang,has,_1320,html,query){if(!dojo.isCopyKey){dojo.isCopyKey=dojo.dnd.getCopyKeyState;}var _1321=_1310("dojox.grid._Grid",[_131b,_131c,_1311],{templateString:_131e,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,sortInfo:0,themeable:true,_placeholders:null,_layoutClass:_1313,buildRendering:function(){this.inherited(arguments);if(!this.domNode.getAttribute("tabIndex")){this.domNode.tabIndex="0";}this.createScroller();this.createLayout();this.createViews();this.createManagers();this.createSelection();this.connect(this.selection,"onSelected","onSelected");this.connect(this.selection,"onDeselected","onDeselected");this.connect(this.selection,"onChanged","onSelectionChanged");_1320.initOnFontResize();this.connect(_1320,"onFontResize","textSizeChanged");util.funnelEvents(this.domNode,this,"doKeyEvent",util.keyEvents);if(this.selectionMode!="none"){this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");}html.addClass(this.domNode,this.classTag);if(!this.isLeftToRight()){html.addClass(this.domNode,this.classTag+"Rtl");}},postMixInProperties:function(){this.inherited(arguments);var _1322=dojo.i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_131f.substitute(this.loadingMessage,_1322);this.errorMessage=_131f.substitute(this.errorMessage,_1322);if(this.srcNodeRef&&this.srcNodeRef.style.height){this.height=this.srcNodeRef.style.height;}this._setAutoHeightAttr(this.autoHeight,true);this.lastScrollTop=this.scrollTop=0;},postCreate:function(){this._placeholders=[];this._setHeaderMenuAttr(this.headerMenu);this._setStructureAttr(this.structure);this._click=[];this.inherited(arguments);if(this.domNode&&this.autoWidth&&this.initialWidth){this.domNode.style.width=this.initialWidth;}if(this.domNode&&!this.editable){html.attr(this.domNode,"aria-readonly","true");}},destroy:function(){this.domNode.onReveal=null;this.domNode.onSizeChange=null;delete this._click;if(this.scroller){this.scroller.destroy();delete this.scroller;}this.edit.destroy();delete this.edit;this.views.destroyViews();if(this.focus){this.focus.destroy();delete this.focus;}if(this.headerMenu&&this._placeholders.length){array.forEach(this._placeholders,function(p){p.unReplace(true);});this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.inherited(arguments);},_setAutoHeightAttr:function(ah,_1323){if(typeof ah=="string"){if(!ah||ah=="false"){ah=false;}else{if(ah=="true"){ah=true;}else{ah=window.parseInt(ah,10);}}}if(typeof ah=="number"){if(isNaN(ah)){ah=false;}if(ah<0){ah=true;}else{if(ah===0){ah=false;}}}this.autoHeight=ah;if(typeof ah=="boolean"){this._autoHeight=ah;}else{if(typeof ah=="number"){this._autoHeight=(ah>=this.get("rowCount"));}else{this._autoHeight=false;}}if(this._started&&!_1323){this.render();}},_getRowCountAttr:function(){return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;},textSizeChanged:function(){this.render();},sizeChange:function(){this.update();},createManagers:function(){this.rows=new _1316(this);this.focus=new _1317(this);this.edit=new _1318(this);},createSelection:function(){this.selection=new _1319(this);},createScroller:function(){this.scroller=new _1312();this.scroller.grid=this;this.scroller.renderRow=lang.hitch(this,"renderRow");this.scroller.removeRow=lang.hitch(this,"rowRemoved");},createLayout:function(){this.layout=new this._layoutClass(this);this.connect(this.layout,"moveColumn","onMoveColumn");},onMoveColumn:function(){this.render();},onResizeColumn:function(_1324){},createViews:function(){this.views=new _1315(this);this.views.createView=lang.hitch(this,"createView");},createView:function(_1325,idx){var c=lang.getObject(_1325);var view=new c({grid:this,index:idx});this.viewsNode.appendChild(view.domNode);this.viewsHeaderNode.appendChild(view.headerNode);this.views.addView(view);html.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");return view;},buildViews:function(){for(var i=0,vs;(vs=this.layout.structure[i]);i++){this.createView(vs.type||dojox._scopeName+".grid._View",i).setStructure(vs);}this.scroller.setContentNodes(this.views.getContentNodes());},_setStructureAttr:function(_1326){var s=_1326;if(s&&lang.isString(s)){dojo.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");s=lang.getObject(s);}this.structure=s;if(!s){if(this.layout.structure){s=this.layout.structure;}else{return;}}this.views.destroyViews();this.focus.focusView=null;if(s!==this.layout.structure){this.layout.setStructure(s);}this._structureChanged();},setStructure:function(_1327){dojo.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");this._setStructureAttr(_1327);},getColumnTogglingItems:function(){var items,_1328=[];items=array.map(this.layout.cells,function(cell){if(!cell.menuItems){cell.menuItems=[];}var self=this;var item=new _131d({label:cell.name,checked:!cell.hidden,_gridCell:cell,onChange:function(_1329){if(self.layout.setColumnVisibility(this._gridCell.index,_1329)){var items=this._gridCell.menuItems;if(items.length>1){array.forEach(items,function(item){if(item!==this){item.setAttribute("checked",_1329);}},this);}_1329=array.filter(self.layout.cells,function(c){if(c.menuItems.length>1){array.forEach(c.menuItems,"item.set('disabled', false);");}else{c.menuItems[0].set("disabled",false);}return !c.hidden;});if(_1329.length==1){array.forEach(_1329[0].menuItems,"item.set('disabled', true);");}}},destroy:function(){var index=array.indexOf(this._gridCell.menuItems,this);this._gridCell.menuItems.splice(index,1);delete this._gridCell;_131d.prototype.destroy.apply(this,arguments);}});cell.menuItems.push(item);if(!cell.hidden){_1328.push(item);}return item;},this);if(_1328.length==1){_1328[0].set("disabled",true);}return items;},_setHeaderMenuAttr:function(menu){if(this._placeholders&&this._placeholders.length){array.forEach(this._placeholders,function(p){p.unReplace(true);});this._placeholders=[];}if(this.headerMenu){this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.headerMenu=menu;if(!menu){return;}this.headerMenu.bindDomNode(this.viewsHeaderNode);if(this.headerMenu.getPlaceholders){this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);}},setHeaderMenu:function(menu){dojo.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");this._setHeaderMenuAttr(menu);},setupHeaderMenu:function(){if(this._placeholders&&this._placeholders.length){array.forEach(this._placeholders,function(p){if(p._replaced){p.unReplace(true);}p.replace(this.getColumnTogglingItems());},this);}},_fetch:function(start){this.setScrollTop(0);},getItem:function(_132a){return null;},showMessage:function(_132b){if(_132b){this.messagesNode.innerHTML=_132b;this.messagesNode.style.display="";}else{this.messagesNode.innerHTML="";this.messagesNode.style.display="none";}},_structureChanged:function(){this.buildViews();if(this.autoRender&&this._started){this.render();}},hasLayout:function(){return this.layout.cells.length;},resize:function(_132c,_132d){if(dojo.isIE&&!_132c&&!_132d&&this._autoHeight){return;}this._pendingChangeSize=_132c;this._pendingResultSize=_132d;this.sizeChange();},_getPadBorder:function(){this._padBorder=this._padBorder||html._getPadBorderExtents(this.domNode);return this._padBorder;},_getHeaderHeight:function(){var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();vns.height=t+"px";this.views.normalizeHeaderNodeHeight();return t;},_resize:function(_132e,_132f){_132e=_132e||this._pendingChangeSize;_132f=_132f||this._pendingResultSize;delete this._pendingChangeSize;delete this._pendingResultSize;if(!this.domNode){return;}var pn=this.domNode.parentNode;if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){return;}var _1330=this._getPadBorder();var hh=undefined;var h;if(this._autoHeight){this.domNode.style.height="auto";}else{if(typeof this.autoHeight=="number"){h=hh=this._getHeaderHeight();h+=(this.scroller.averageRowHeight*this.autoHeight);this.domNode.style.height=h+"px";}else{if(this.domNode.clientHeight<=_1330.h){if(pn==document.body){this.domNode.style.height=this.defaultHeight;}else{if(this.height){this.domNode.style.height=this.height;}else{this.fitTo="parent";}}}}}if(_132f){_132e=_132f;}if(!this._autoHeight&&_132e){html.marginBox(this.domNode,_132e);this.height=this.domNode.style.height;delete this.fitTo;}else{if(this.fitTo=="parent"){h=this._parentContentBoxHeight=this._parentContentBoxHeight||html._getContentBox(pn).h;this.domNode.style.height=Math.max(0,h)+"px";}}var _1331=array.some(this.views.views,function(v){return v.flexCells;});if(!this._autoHeight&&(h||html._getContentBox(this.domNode).h)===0){this.viewsHeaderNode.style.display="none";}else{this.viewsHeaderNode.style.display="block";if(!_1331&&hh===undefined){hh=this._getHeaderHeight();}}if(_1331){hh=undefined;}this.adaptWidth();this.adaptHeight(hh);this.postresize();},adaptWidth:function(){var _1332=(!this.initialWidth&&this.autoWidth);var w=_1332?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);this.views.onEach("adaptWidth");if(_1332){this.domNode.style.width=vw+"px";}},adaptHeight:function(_1333){var t=_1333===undefined?this._getHeaderHeight():_1333;var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);this.views.onEach("setSize",[0,h]);this.views.onEach("adaptHeight");if(!this._autoHeight){var _1334=0,_1335=0;var _1336=array.filter(this.views.views,function(v){var has=v.hasHScrollbar();if(has){_1334++;}else{_1335++;}return (!has);});if(_1334>0&&_1335>0){array.forEach(_1336,function(v){v.adaptHeight(true);});}}if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){this.scroller.windowHeight=h;}else{this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);}},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.autoRender){this.render();}},render:function(){if(!this.domNode){return;}if(!this._started){return;}if(!this.hasLayout()){this.scroller.init(0,this.keepRows,this.rowsPerPage);return;}this.update=this.defaultUpdate;this._render();},_render:function(){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this.setScrollTop(0);this.postrender();},prerender:function(){this.keepRows=this._autoHeight?0:this.keepRows;this.scroller.setKeepInfo(this.keepRows);this.views.render();this._resize();},postrender:function(){this.postresize();this.focus.initFocusView();html.setSelectable(this.domNode,this.selectable);},postresize:function(){if(this._autoHeight){var size=Math.max(this.views.measureContent())+"px";this.viewsNode.style.height=size;}},renderRow:function(_1337,_1338){this.views.renderRow(_1337,_1338,this._skipRowRenormalize);},rowRemoved:function(_1339){this.views.rowRemoved(_1339);},invalidated:null,updating:false,beginUpdate:function(){this.invalidated=[];this.updating=true;},endUpdate:function(){this.updating=false;var i=this.invalidated,r;if(i.all){this.update();}else{if(i.rowCount!=undefined){this.updateRowCount(i.rowCount);}else{for(r in i){this.updateRow(Number(r));}}}this.invalidated=[];},defaultUpdate:function(){if(!this.domNode){return;}if(this.updating){this.invalidated.all=true;return;}this.lastScrollTop=this.scrollTop;this.prerender();this.scroller.invalidateNodes();this.setScrollTop(this.lastScrollTop);this.postrender();},update:function(){this.render();},updateRow:function(_133a){_133a=Number(_133a);if(this.updating){this.invalidated[_133a]=true;}else{this.views.updateRow(_133a);this.scroller.rowHeightChanged(_133a);}},updateRows:function(_133b,_133c){_133b=Number(_133b);_133c=Number(_133c);var i;if(this.updating){for(i=0;i<_133c;i++){this.invalidated[i+_133b]=true;}}else{for(i=0;i<_133c;i++){this.views.updateRow(i+_133b,this._skipRowRenormalize);}this.scroller.rowHeightChanged(_133b);}},updateRowCount:function(_133d){if(this.updating){this.invalidated.rowCount=_133d;}else{this.rowCount=_133d;this._setAutoHeightAttr(this.autoHeight,true);if(this.layout.cells.length){this.scroller.updateRowCount(_133d);}this._resize();if(this.layout.cells.length){this.setScrollTop(this.scrollTop);}}},updateRowStyles:function(_133e){this.views.updateRowStyles(_133e);},getRowNode:function(_133f){if(this.focus.focusView&&!(this.focus.focusView instanceof _131a)){return this.focus.focusView.rowNodes[_133f];}else{for(var i=0,cView;(cView=this.views.views[i]);i++){if(!(cView instanceof _131a)){return cView.rowNodes[_133f];}}}return null;},rowHeightChanged:function(_1340){this.views.renormalizeRow(_1340);this.scroller.rowHeightChanged(_1340);},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(inTop){if(!this.fastScroll){this.setScrollTop(inTop);return;}var delta=Math.abs(this.lastScrollTop-inTop);this.lastScrollTop=inTop;if(delta>this.scrollRedrawThreshold||this.delayScroll){this.delayScroll=true;this.scrollTop=inTop;this.views.setScrollTop(inTop);if(this._pendingScroll){window.clearTimeout(this._pendingScroll);}var _1341=this;this._pendingScroll=window.setTimeout(function(){delete _1341._pendingScroll;_1341.finishScrollJob();},200);}else{this.setScrollTop(inTop);}},finishScrollJob:function(){this.delayScroll=false;this.setScrollTop(this.scrollTop);},setScrollTop:function(inTop){this.scroller.scroll(this.views.setScrollTop(inTop));},scrollToRow:function(_1342){this.setScrollTop(this.scroller.findScrollTop(_1342)+1);},styleRowNode:function(_1343,_1344){if(_1344){this.rows.styleRowNode(_1343,_1344);}},_mouseOut:function(e){this.rows.setOverRow(-2);},getCell:function(_1345){return this.layout.cells[_1345];},setCellWidth:function(_1346,_1347){this.getCell(_1346).unitWidth=_1347;},getCellName:function(_1348){return "Cell "+_1348.index;},canSort:function(_1349){},sort:function(){},getSortAsc:function(_134a){_134a=_134a==undefined?this.sortInfo:_134a;return Boolean(_134a>0);},getSortIndex:function(_134b){_134b=_134b==undefined?this.sortInfo:_134b;return Math.abs(_134b)-1;},setSortIndex:function(_134c,inAsc){var si=_134c+1;if(inAsc!=undefined){si*=(inAsc?1:-1);}else{if(this.getSortIndex()==_134c){si=-this.sortInfo;}}this.setSortInfo(si);},setSortInfo:function(_134d){if(this.canSort(_134d)){this.sortInfo=_134d;this.sort();this.update();}},doKeyEvent:function(e){e.dispatch="do"+e.type;this.onKeyEvent(e);},_dispatch:function(m,e){if(m in this){return this[m](e);}return false;},dispatchKeyEvent:function(e){this._dispatch(e.dispatch,e);},dispatchContentEvent:function(e){this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);},dispatchHeaderEvent:function(e){e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);},dokeydown:function(e){this.onKeyDown(e);},doclick:function(e){if(e.cellNode){this.onCellClick(e);}else{this.onRowClick(e);}},dodblclick:function(e){if(e.cellNode){this.onCellDblClick(e);}else{this.onRowDblClick(e);}},docontextmenu:function(e){if(e.cellNode){this.onCellContextMenu(e);}else{this.onRowContextMenu(e);}},doheaderclick:function(e){if(e.cellNode){this.onHeaderCellClick(e);}else{this.onHeaderClick(e);}},doheaderdblclick:function(e){if(e.cellNode){this.onHeaderCellDblClick(e);}else{this.onHeaderDblClick(e);}},doheadercontextmenu:function(e){if(e.cellNode){this.onHeaderCellContextMenu(e);}else{this.onHeaderContextMenu(e);}},doStartEdit:function(_134e,_134f){this.onStartEdit(_134e,_134f);},doApplyCellEdit:function(_1350,_1351,_1352){this.onApplyCellEdit(_1350,_1351,_1352);},doCancelEdit:function(_1353){this.onCancelEdit(_1353);},doApplyEdit:function(_1354){this.onApplyEdit(_1354);},addRow:function(){this.updateRowCount(this.get("rowCount")+1);},removeSelectedRows:function(){if(this.allItemsSelected){this.updateRowCount(0);}else{this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));}this.selection.clear();}});_1321.markupFactory=function(props,node,ctor,_1355){var _1356=function(n){var w=html.attr(n,"width")||"auto";if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){w=parseInt(w,10)+"px";}return w;};if(!props.structure&&node.nodeName.toLowerCase()=="table"){props.structure=query("> colgroup",node).map(function(cg){var sv=html.attr(cg,"span");var v={noscroll:(html.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};if(html.hasAttr(cg,"width")){v.width=_1356(cg);}return v;});if(!props.structure.length){props.structure.push({__span:Infinity,cells:[]});}query("thead > tr",node).forEach(function(tr,_1357){var _1358=0;var _1359=0;var _135a;var cView=null;query("> th",tr).map(function(th){if(!cView){_135a=0;cView=props.structure[0];}else{if(_1358>=(_135a+cView.__span)){_1359++;_135a+=cView.__span;var _135b=cView;cView=props.structure[_1359];}}var cell={name:lang.trim(html.attr(th,"name")||th.innerHTML),colSpan:parseInt(html.attr(th,"colspan")||1,10),type:lang.trim(html.attr(th,"cellType")||""),id:lang.trim(html.attr(th,"id")||"")};_1358+=cell.colSpan;var _135c=html.attr(th,"rowspan");if(_135c){cell.rowSpan=_135c;}if(html.hasAttr(th,"width")){cell.width=_1356(th);}if(html.hasAttr(th,"relWidth")){cell.relWidth=window.parseInt(html.attr(th,"relWidth"),10);}if(html.hasAttr(th,"hidden")){cell.hidden=(html.attr(th,"hidden")=="true"||html.attr(th,"hidden")===true);}if(_1355){_1355(th,cell);}cell.type=cell.type?lang.getObject(cell.type):dojox.grid.cells.Cell;if(cell.type&&cell.type.markupFactory){cell.type.markupFactory(th,cell);}if(!cView.cells[_1357]){cView.cells[_1357]=[];}cView.cells[_1357].push(cell);});});}return new ctor(props,node);};return _1321;});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_135d,_135e,_135f){return _135d("dojo.store.Memory",null,{constructor:function(_1360){for(var i in _1360){this[i]=_1360[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_135f,get:function(id){return this.data[this.index[id]];},getIdentity:function(_1361){return _1361[this.idProperty];},put:function(_1362,_1363){var data=this.data,index=this.index,_1364=this.idProperty;var id=(_1363&&"id" in _1363)?_1363.id:_1364 in _1362?_1362[_1364]:Math.random();if(id in index){if(_1363&&_1363.overwrite===false){throw new Error("Object already exists");}data[index[id]]=_1362;}else{index[id]=data.push(_1362)-1;}return id;},add:function(_1365,_1366){(_1366=_1366||{}).overwrite=false;return this.put(_1365,_1366);},remove:function(id){var index=this.index;var data=this.data;if(id in index){data.splice(index[id],1);this.setData(data);return true;}},query:function(query,_1367){return _135e(this.queryEngine(query,_1367)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dojox/grid/_Events":function(){define("dojox/grid/_Events",["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(keys,_1368,_1369,event,has){return _1369("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){this.dispatchKeyEvent(e);},onContentEvent:function(e){this.dispatchContentEvent(e);},onHeaderEvent:function(e){this.dispatchHeaderEvent(e);},onStyleRow:function(inRow){var i=inRow;i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");this.focus.styleRow(inRow);this.edit.styleRow(inRow);},onKeyDown:function(e){if(e.altKey||e.metaKey){return;}var _136a;switch(e.keyCode){case keys.ESCAPE:this.edit.cancel();break;case keys.ENTER:if(!this.edit.isEditing()){_136a=this.focus.getHeaderIndex();if(_136a>=0){this.setSortIndex(_136a);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);}event.stop(e);}if(!e.shiftKey){var _136b=this.edit.isEditing();this.edit.apply();if(!_136b){this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);}}if(!this.edit.isEditing()){var _136c=this.focus.focusView||this.views.views[0];_136c.content.decorateEvent(e);this.onRowClick(e);event.stop(e);}break;case keys.SPACE:if(!this.edit.isEditing()){_136a=this.focus.getHeaderIndex();if(_136a>=0){this.setSortIndex(_136a);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);}event.stop(e);}break;case keys.TAB:this.focus[e.shiftKey?"previousKey":"nextKey"](e);break;case keys.LEFT_ARROW:case keys.RIGHT_ARROW:if(!this.edit.isEditing()){var _136d=e.keyCode;event.stop(e);_136a=this.focus.getHeaderIndex();if(_136a>=0&&(e.shiftKey&&e.ctrlKey)){this.focus.colSizeAdjust(e,_136a,(_136d==keys.LEFT_ARROW?-1:1)*5);}else{var _136e=(_136d==keys.LEFT_ARROW)?1:-1;if(this.isLeftToRight()){_136e*=-1;}this.focus.move(0,_136e);}}break;case keys.UP_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){event.stop(e);this.focus.move(-1,0);}break;case keys.DOWN_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){event.stop(e);this.focus.move(1,0);}break;case keys.PAGE_UP:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){event.stop(e);if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);}}break;case keys.PAGE_DOWN:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){event.stop(e);if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);}}break;default:break;}},onMouseOver:function(e){e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);},onMouseOut:function(e){e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);},onMouseDown:function(e){e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);},onMouseOverRow:function(e){if(!this.rows.isOver(e.rowIndex)){this.rows.setOverRow(e.rowIndex);e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);}},onMouseOutRow:function(e){if(this.rows.isOver(-1)){this.onHeaderMouseOut(e);}else{if(!this.rows.isOver(-2)){this.rows.setOverRow(-2);this.onRowMouseOut(e);}}},onMouseDownRow:function(e){if(e.rowIndex!=-1){this.onRowMouseDown(e);}},onCellMouseOver:function(e){if(e.cellNode){_1368.add(e.cellNode,this.cellOverClass);}},onCellMouseOut:function(e){if(e.cellNode){_1368.remove(e.cellNode,this.cellOverClass);}},onCellMouseDown:function(e){},onCellClick:function(e){this._click[0]=this._click[1];this._click[1]=e;if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){this.focus.setFocusCell(e.cell,e.rowIndex);}if(this._click.length>1&&this._click[0]==null){this._click.shift();}this.onRowClick(e);},onCellDblClick:function(e){var event;if(this._click.length>1&&has("ie")){event=this._click[1];}else{if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){event=this._click[0];}else{event=e;}}this.focus.setFocusCell(event.cell,event.rowIndex);this.onRowClick(event);this.edit.setEditCell(event.cell,event.rowIndex);this.onRowDblClick(e);},onCellContextMenu:function(e){this.onRowContextMenu(e);},onCellFocus:function(_136f,_1370){this.edit.cellFocus(_136f,_1370);},onRowClick:function(e){this.edit.rowClick(e);this.selection.clickSelectEvent(e);},onRowDblClick:function(e){},onRowMouseOver:function(e){},onRowMouseOut:function(e){},onRowMouseDown:function(e){},onRowContextMenu:function(e){event.stop(e);},onHeaderMouseOver:function(e){},onHeaderMouseOut:function(e){},onHeaderCellMouseOver:function(e){if(e.cellNode){_1368.add(e.cellNode,this.cellOverClass);}},onHeaderCellMouseOut:function(e){if(e.cellNode){_1368.remove(e.cellNode,this.cellOverClass);}},onHeaderCellMouseDown:function(e){},onHeaderClick:function(e){},onHeaderCellClick:function(e){this.setSortIndex(e.cell.index);this.onHeaderClick(e);},onHeaderDblClick:function(e){},onHeaderCellDblClick:function(e){this.onHeaderDblClick(e);},onHeaderCellContextMenu:function(e){this.onHeaderContextMenu(e);},onHeaderContextMenu:function(e){if(!this.headerMenu){event.stop(e);}},onStartEdit:function(_1371,_1372){},onApplyCellEdit:function(_1373,_1374,_1375){},onCancelEdit:function(_1376){},onApplyEdit:function(_1377){},onCanSelect:function(_1378){return true;},onCanDeselect:function(_1379){return true;},onSelected:function(_137a){this.updateRowStyles(_137a);},onDeselected:function(_137b){this.updateRowStyles(_137b);},onSelectionChanged:function(){}});});},"dojo/on":function(){define(["./has!dom-addeventlistener?:./aspect","./_base/kernel","./has"],function(_137c,dojo,has){"use strict";if(1){var major=window.ScriptEngineMajorVersion;has.add("jscript",major&&(major()+ScriptEngineMinorVersion()/10));has.add("event-orientationchange",has("touch")&&!has("android"));}var on=function(_137d,type,_137e,_137f){if(_137d.on){return _137d.on(type,_137e);}return on.parse(_137d,type,_137e,_1380,_137f,this);};on.pausable=function(_1381,type,_1382,_1383){var _1384;var _1385=on(_1381,type,function(){if(!_1384){return _1382.apply(this,arguments);}},_1383);_1385.pause=function(){_1384=true;};_1385.resume=function(){_1384=false;};return _1385;};on.once=function(_1386,type,_1387,_1388){var _1389=on(_1386,type,function(){_1389.remove();return _1387.apply(this,arguments);});return _1389;};on.parse=function(_138a,type,_138b,_138c,_138d,_138e){if(type.call){return type.call(_138e,_138a,_138b);}if(type.indexOf(",")>-1){var _138f=type.split(/\s*,\s*/);var _1390=[];var i=0;var _1391;while(_1391=_138f[i++]){_1390.push(_138c(_138a,_1391,_138b,_138d,_138e));}_1390.remove=function(){for(var i=0;i<_1390.length;i++){_1390[i].remove();}};return _1390;}return _138c(_138a,type,_138b,_138d,_138e);};var _1392=/^touch/;function _1380(_1393,type,_1394,_1395,_1396){var _1397=type.match(/(.*):(.*)/);if(_1397){type=_1397[2];_1397=_1397[1];return on.selector(_1397,type).call(_1396,_1393,_1394);}if(has("touch")){if(_1392.test(type)){_1394=_1398(_1394);}if(!has("event-orientationchange")&&(type=="orientationchange")){type="resize";_1393=window;_1394=_1398(_1394);}}if(_1393.addEventListener){var _1399=type in _139a;_1393.addEventListener(_1399?_139a[type]:type,_1394,_1399);return {remove:function(){_1393.removeEventListener(type,_1394,_1399);}};}type="on"+type;if(_139b&&_1393.attachEvent){return _139b(_1393,type,_1394);}throw new Error("Target must be an event emitter");};on.selector=function(_139c,_139d,_139e){return function(_139f,_13a0){var _13a1=this;var _13a2=_139d.bubble;if(_13a2){_139d=_13a2;}else{if(_139e!==false){_139e=true;}}return on(_139f,_139d,function(event){var _13a3=event.target;_13a1=_13a1&&_13a1.matches?_13a1:dojo.query;while(!_13a1.matches(_13a3,_139c,_139f)){if(_13a3==_139f||!_139e||!(_13a3=_13a3.parentNode)){return;}}return _13a0.call(_13a3,event);});};};function _13a4(){this.cancelable=false;};function _13a5(){this.bubbles=false;};var slice=[].slice,_13a6=on.emit=function(_13a7,type,event){var args=slice.call(arguments,2);var _13a8="on"+type;if("parentNode" in _13a7){var _13a9=args[0]={};for(var i in event){_13a9[i]=event[i];}_13a9.preventDefault=_13a4;_13a9.stopPropagation=_13a5;_13a9.target=_13a7;_13a9.type=type;event=_13a9;}do{_13a7[_13a8]&&_13a7[_13a8].apply(_13a7,args);}while(event&&event.bubbles&&(_13a7=_13a7.parentNode));return event&&event.cancelable&&event;};var _139a={};if(has("dom-addeventlistener")){_139a={focusin:"focus",focusout:"blur"};if(has("opera")){_139a.keydown="keypress";}on.emit=function(_13aa,type,event){if(_13aa.dispatchEvent&&document.createEvent){var _13ab=document.createEvent("HTMLEvents");_13ab.initEvent(type,!!event.bubbles,!!event.cancelable);for(var i in event){var value=event[i];if(!(i in _13ab)){_13ab[i]=event[i];}}return _13aa.dispatchEvent(_13ab)&&_13ab;}return _13a6.apply(on,arguments);};}else{on._fixEvent=function(evt,_13ac){if(!evt){var w=_13ac&&(_13ac.ownerDocument||_13ac.document||_13ac).parentWindow||window;evt=w.event;}if(!evt){return (evt);}if(!evt.target){evt.target=evt.srcElement;evt.currentTarget=(_13ac||evt.srcElement);if(evt.type=="mouseover"){evt.relatedTarget=evt.fromElement;}if(evt.type=="mouseout"){evt.relatedTarget=evt.toElement;}if(!evt.stopPropagation){evt.stopPropagation=_13ad;evt.preventDefault=_13ae;}switch(evt.type){case "keypress":var c=("charCode" in evt?evt.charCode:evt.keyCode);if(c==10){c=0;evt.keyCode=13;}else{if(c==13||c==27){c=0;}else{if(c==3){c=99;}}}evt.charCode=c;_13af(evt);break;}}return evt;};var _13b0=function(_13b1){this.handle=_13b1;};_13b0.prototype.remove=function(){delete _dojoIEListeners_[this.handle];};var _13b2=function(_13b3){return function(evt){evt=on._fixEvent(evt,this);return _13b3.call(this,evt);};};var _139b=function(_13b4,type,_13b5){_13b5=_13b2(_13b5);if(((_13b4.ownerDocument?_13b4.ownerDocument.parentWindow:_13b4.parentWindow||_13b4.window||window)!=top||has("jscript")<5.8)&&!has("config-_allow_leaks")){if(typeof _dojoIEListeners_=="undefined"){_dojoIEListeners_=[];}var _13b6=_13b4[type];if(!_13b6||!_13b6.listeners){var _13b7=_13b6;_13b4[type]=_13b6=Function("event","var callee = arguments.callee; for(var i = 0; i<callee.listeners.length; i++){var listener = _dojoIEListeners_[callee.listeners[i]]; if(listener){listener.call(this,event);}}");_13b6.listeners=[];_13b6.global=this;if(_13b7){_13b6.listeners.push(_dojoIEListeners_.push(_13b7)-1);}}var _13b8;_13b6.listeners.push(_13b8=(_13b6.global._dojoIEListeners_.push(_13b5)-1));return new _13b0(_13b8);}return _137c.after(_13b4,type,_13b5,true);};var _13af=function(evt){evt.keyChar=evt.charCode?String.fromCharCode(evt.charCode):"";evt.charOrCode=evt.keyChar||evt.keyCode;};var _13ad=function(){this.cancelBubble=true;};var _13ae=on._preventDefault=function(){this.bubbledKeyCode=this.keyCode;if(this.ctrlKey){try{this.keyCode=0;}catch(e){}}this.returnValue=false;};}if(has("touch")){var Event=function(){};var _13b9=window.orientation;var _1398=function(_13ba){return function(_13bb){var event=_13bb.corrected;if(!event){var type=_13bb.type;try{delete _13bb.type;}catch(e){}if(_13bb.type){Event.prototype=_13bb;var event=new Event;event.preventDefault=function(){_13bb.preventDefault();};event.stopPropagation=function(){_13bb.stopPropagation();};}else{event=_13bb;event.type=type;}_13bb.corrected=event;if(type=="resize"){if(_13b9==window.orientation){return null;}_13b9=window.orientation;event.type="orientationchange";return _13ba.call(this,event);}if(!("rotation" in event)){event.rotation=0;event.scale=1;}var _13bc=event.changedTouches[0];for(var i in _13bc){delete event[i];event[i]=_13bc[i];}}return _13ba.call(this,event);};};}return on;});},"dijit/form/_ListBase":function(){define("dijit/form/_ListBase",["dojo/_base/declare","dojo/window"],function(_13bd,_13be){return _13bd("dijit.form._ListBase",null,{selected:null,_getTarget:function(evt){var tgt=evt.target;var _13bf=this.containerNode;if(tgt==_13bf||tgt==this.domNode){return null;}while(tgt&&tgt.parentNode!=_13bf){tgt=tgt.parentNode;}return tgt;},selectFirstNode:function(){var first=this.containerNode.firstChild;while(first&&first.style.display=="none"){first=first.nextSibling;}this._setSelectedAttr(first);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last);},selectNextNode:function(){var _13c0=this._getSelectedAttr();if(!_13c0){this.selectFirstNode();}else{var next=_13c0.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next);}}},selectPreviousNode:function(){var _13c1=this._getSelectedAttr();if(!_13c1){this.selectLastNode();}else{var prev=_13c1.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev);}}},_setSelectedAttr:function(node){if(this.selected!=node){var _13c2=this._getSelectedAttr();if(_13c2){this.onDeselect(_13c2);this.selected=null;}if(node&&node.parentNode==this.containerNode){this.selected=node;_13be.scrollIntoView(node);this.onSelect(node);}}else{if(node){this.onSelect(node);}}},_getSelectedAttr:function(){var v=this.selected;return (v&&v.parentNode==this.containerNode)?v:(this.selected=null);}});});},"dijit/typematic":function(){define("dijit/typematic",["dojo/_base/array","dojo/_base/connect","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/_base/sniff","."],function(array,_13c3,event,_13c4,lang,on,has,dijit){var _13c5=(dijit.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_13c6,node,_13c7,obj,_13c8,_13c9,_13ca){if(obj!=this._obj){this.stop();this._initialDelay=_13c9||500;this._subsequentDelay=_13c8||0.9;this._minDelay=_13ca||10;this._obj=obj;this._evt=evt;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=lang.hitch(_13c6,_13c7);this._fireEventAndReload();this._evt=lang.mixin({faux:true},evt);}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,_13cb,_13cc,_13cd,_13ce,_13cf,_13d0){if(_13cb.keyCode){_13cb.charOrCode=_13cb.keyCode;_13c4.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}else{if(_13cb.charCode){_13cb.charOrCode=String.fromCharCode(_13cb.charCode);_13c4.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}}var _13d1=[on(node,_13c3._keypress,lang.hitch(this,function(evt){if(evt.charOrCode==_13cb.charOrCode&&(_13cb.ctrlKey===undefined||_13cb.ctrlKey==evt.ctrlKey)&&(_13cb.altKey===undefined||_13cb.altKey==evt.altKey)&&(_13cb.metaKey===undefined||_13cb.metaKey==(evt.metaKey||false))&&(_13cb.shiftKey===undefined||_13cb.shiftKey==evt.shiftKey)){event.stop(evt);_13c5.trigger(evt,_13cc,node,_13cd,_13cb,_13ce,_13cf,_13d0);}else{if(_13c5._obj==_13cb){_13c5.stop();}}})),on(node,"keyup",lang.hitch(this,function(){if(_13c5._obj==_13cb){_13c5.stop();}}))];return {remove:function(){array.forEach(_13d1,function(h){h.remove();});}};},addMouseListener:function(node,_13d2,_13d3,_13d4,_13d5,_13d6){var _13d7=[on(node,"mousedown",lang.hitch(this,function(evt){event.stop(evt);_13c5.trigger(evt,_13d2,node,_13d3,node,_13d4,_13d5,_13d6);})),on(node,"mouseup",lang.hitch(this,function(evt){if(this._obj){event.stop(evt);}_13c5.stop();})),on(node,"mouseout",lang.hitch(this,function(evt){event.stop(evt);_13c5.stop();})),on(node,"mousemove",lang.hitch(this,function(evt){evt.preventDefault();})),on(node,"dblclick",lang.hitch(this,function(evt){event.stop(evt);if(has("ie")){_13c5.trigger(evt,_13d2,node,_13d3,node,_13d4,_13d5,_13d6);setTimeout(lang.hitch(this,_13c5.stop),50);}}))];return {remove:function(){array.forEach(_13d7,function(h){h.remove();});}};},addListener:function(_13d8,_13d9,_13da,_13db,_13dc,_13dd,_13de,_13df){var _13e0=[this.addKeyListener(_13d9,_13da,_13db,_13dc,_13dd,_13de,_13df),this.addMouseListener(_13d8,_13db,_13dc,_13dd,_13de,_13df)];return {remove:function(){array.forEach(_13e0,function(h){h.remove();});}};}});return _13c5;});},"dojox/charting/plot2d/Pie":function(){define("dojox/charting/plot2d/Pie",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","../Element","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils"],function(lang,arr,_13e1,_13e2,_13e3,dc,da,g,m,df,du){var _13e4=0.2;return _13e1("dojox.charting.plot2d.Pie",[_13e2,_13e3],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",labelWiring:{}},constructor:function(chart,_13e5){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_13e5);du.updateWithPattern(this.opt,_13e5,this.optionalParams);this.run=null;this.dyn=[];},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},initializeScalers:function(){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_13e6){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_13e6.l-_13e6.r)/2,ry=(dim.height-_13e6.t-_13e6.b)/2,r=Math.min(rx,ry),_13e7="font" in this.opt?this.opt.font:t.axis.font,size=_13e7?g.normalizedLength(g.splitFontString(_13e7).size):0,_13e8="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_13e9=m._degToRad(this.opt.startAngle),start=_13e9,step,_13ea,_13eb,_13ec,shift,_13ed,run=this.run.data,_13ee=this.events();if(typeof run[0]=="number"){_13ea=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_13ea,"<= 0")){return this;}_13eb=df.map(_13ea,"/this",df.foldl(_13ea,"+",0));if(this.opt.labels){_13ec=arr.map(_13eb,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_13ea=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_13ea,"<= 0")){return this;}_13eb=df.map(_13ea,"/this",df.foldl(_13ea,"+",0));if(this.opt.labels){_13ec=arr.map(_13eb,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}var _13ef=df.map(run,function(v,i){if(v===null||typeof v=="number"){return t.next("slice",[this.opt,this.run],true);}return t.next("slice",[this.opt,this.run,v],true);},this);if(this.opt.labels){shift=df.foldl1(df.map(_13ec,function(label,i){var font=_13ef[i].series.font;return g._base._getTextBox(label,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*shift,ry-size)+this.opt.labelOffset;}_13ed=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_13ed=r-this.opt.labelOffset;}var _13f0={cx:_13e6.l+rx,cy:_13e6.t+ry,r:r};this.dyn=[];var _13f1=new Array(_13eb.length);arr.some(_13eb,function(slice,i){if(slice<0){return false;}if(slice==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],theme=_13ef[i],_13f2;if(slice>=1){_13f2=this._plotFill(theme.series.fill,dim,_13e6);_13f2=this._shapeFill(_13f2,{x:_13f0.cx-_13f0.r,y:_13f0.cy-_13f0.r,width:2*_13f0.r,height:2*_13f0.r});_13f2=this._pseudoRadialFill(_13f2,{x:_13f0.cx,y:_13f0.cy},_13f0.r);var shape=s.createCircle(_13f0).setFill(_13f2).setStroke(theme.series.stroke);this.dyn.push({fill:_13f2,stroke:theme.series.stroke});if(_13ee){var o={element:"slice",index:i,run:this.run,shape:shape,x:i,y:typeof v=="number"?v:v.y,cx:_13f0.cx,cy:_13f0.cy,cr:r};this._connectEvents(o);_13f1[i]=o;}return true;}var end=start+slice*2*Math.PI;if(i+1==_13eb.length){end=_13e9+2*Math.PI;}var step=end-start,x1=_13f0.cx+r*Math.cos(start),y1=_13f0.cy+r*Math.sin(start),x2=_13f0.cx+r*Math.cos(end),y2=_13f0.cy+r*Math.sin(end);var _13f3=m._degToRad(this.opt.fanSize);if(theme.series.fill&&theme.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>_13f3){var group=s.createGroup(),nfans=Math.ceil(step/_13f3),delta=step/nfans;_13f2=this._shapeFill(theme.series.fill,{x:_13f0.cx-_13f0.r,y:_13f0.cy-_13f0.r,width:2*_13f0.r,height:2*_13f0.r});for(var j=0;j<nfans;++j){var fansx=j==0?x1:_13f0.cx+r*Math.cos(start+(j-_13e4)*delta),fansy=j==0?y1:_13f0.cy+r*Math.sin(start+(j-_13e4)*delta),fanex=j==nfans-1?x2:_13f0.cx+r*Math.cos(start+(j+1+_13e4)*delta),faney=j==nfans-1?y2:_13f0.cy+r*Math.sin(start+(j+1+_13e4)*delta),fan=group.createPath().moveTo(_13f0.cx,_13f0.cy).lineTo(fansx,fansy).arcTo(r,r,0,delta>Math.PI,true,fanex,faney).lineTo(_13f0.cx,_13f0.cy).closePath().setFill(this._pseudoRadialFill(_13f2,{x:_13f0.cx,y:_13f0.cy},r,start+(j+0.5)*delta,start+(j+0.5)*delta));}group.createPath().moveTo(_13f0.cx,_13f0.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_13f0.cx,_13f0.cy).closePath().setStroke(theme.series.stroke);shape=group;}else{shape=s.createPath().moveTo(_13f0.cx,_13f0.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_13f0.cx,_13f0.cy).closePath().setStroke(theme.series.stroke);var _13f2=theme.series.fill;if(_13f2&&_13f2.type==="radial"){_13f2=this._shapeFill(_13f2,{x:_13f0.cx-_13f0.r,y:_13f0.cy-_13f0.r,width:2*_13f0.r,height:2*_13f0.r});if(this.opt.radGrad==="linear"){_13f2=this._pseudoRadialFill(_13f2,{x:_13f0.cx,y:_13f0.cy},r,start,end);}}else{if(_13f2&&_13f2.type==="linear"){_13f2=this._plotFill(_13f2,dim,_13e6);_13f2=this._shapeFill(_13f2,shape.getBoundingBox());}}shape.setFill(_13f2);}this.dyn.push({fill:_13f2,stroke:theme.series.stroke});if(_13ee){var o={element:"slice",index:i,run:this.run,shape:shape,x:i,y:typeof v=="number"?v:v.y,cx:_13f0.cx,cy:_13f0.cy,cr:r};this._connectEvents(o);_13f1[i]=o;}start=end;return false;},this);if(this.opt.labels){if(this.opt.labelStyle=="default"){start=_13e9;arr.some(_13eb,function(slice,i){if(slice<=0){return false;}var theme=_13ef[i];if(slice>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_13f0.cx,_13f0.cy+size/2,"middle",_13ec[i],theme.series.font,theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}return true;}var end=start+slice*2*Math.PI,v=run[i];if(i+1==_13eb.length){end=_13e9+2*Math.PI;}var _13f4=(start+end)/2,x=_13f0.cx+_13ed*Math.cos(_13f4),y=_13f0.cy+_13ed*Math.sin(_13f4)+size/2;var elem=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_13ec[i],theme.series.font,theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}start=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){start=_13e9;var _13f5=[];arr.forEach(_13eb,function(slice,i){var end=start+slice*2*Math.PI;if(i+1==_13eb.length){end=_13e9+2*Math.PI;}var _13f6=(start+end)/2;_13f5.push({angle:_13f6,left:Math.cos(_13f6)<0,theme:_13ef[i],index:i,omit:end-start<0.001});start=end;});var _13f7=g._base._getTextBox("a",{font:_13e7}).h;this._getProperLabelRadius(_13f5,_13f7,_13f0.r*1.1);arr.forEach(_13f5,function(slice,i){if(!slice.omit){var _13f8=_13f0.cx-_13f0.r*2,_13f9=_13f0.cx+_13f0.r*2,_13fa=g._base._getTextBox(_13ec[i],{font:_13e7}).w,x=_13f0.cx+slice.labelR*Math.cos(slice.angle),y=_13f0.cy+slice.labelR*Math.sin(slice.angle),_13fb=(slice.left)?(_13f8+_13fa):(_13f9-_13fa),_13fc=(slice.left)?_13f8:_13fb;var _13fd=s.createPath().moveTo(_13f0.cx+_13f0.r*Math.cos(slice.angle),_13f0.cy+_13f0.r*Math.sin(slice.angle));if(Math.abs(slice.labelR*Math.cos(slice.angle))<_13f0.r*2-_13fa){_13fd.lineTo(x,y);}_13fd.lineTo(_13fb,y).setStroke(slice.theme.series.labelWiring);var elem=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_13fc,y,"left",_13ec[i],slice.theme.series.font,slice.theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_13f1[esi++];});return this;},_getProperLabelRadius:function(_13fe,_13ff,_1400){var _1401={},_1402={},_1403=1,_1404=1;if(_13fe.length==1){_13fe[0].labelR=_1400;return;}for(var i=0;i<_13fe.length;i++){var _1405=Math.abs(Math.sin(_13fe[i].angle));if(_13fe[i].left){if(_1403>_1405){_1403=_1405;_1401=_13fe[i];}}else{if(_1404>_1405){_1404=_1405;_1402=_13fe[i];}}}_1401.labelR=_1402.labelR=_1400;this._calculateLabelR(_1401,_13fe,_13ff);this._calculateLabelR(_1402,_13fe,_13ff);},_calculateLabelR:function(_1406,_1407,_1408){var i=_1406.index,_1409=_1407.length,_140a=_1406.labelR;while(!(_1407[i%_1409].left^_1407[(i+1)%_1409].left)){if(!_1407[(i+1)%_1409].omit){var _140b=(Math.sin(_1407[i%_1409].angle)*_140a+((_1407[i%_1409].left)?(-_1408):_1408))/Math.sin(_1407[(i+1)%_1409].angle);_140a=(_140b<_1406.labelR)?_1406.labelR:_140b;_1407[(i+1)%_1409].labelR=_140a;}i++;}i=_1406.index;var j=(i==0)?_1409-1:i-1;while(!(_1407[i].left^_1407[j].left)){if(!_1407[j].omit){var _140b=(Math.sin(_1407[i].angle)*_140a+((_1407[i].left)?_1408:(-_1408)))/Math.sin(_1407[j].angle);_140a=(_140b<_1406.labelR)?_1406.labelR:_140b;_1407[j].labelR=_140a;}i--;j--;i=(i<0)?i+_1407.length:i;j=(j<0)?j+_1407.length:j;}},_getLabel:function(_140c){return dc.getLabel(_140c,this.opt.fixed,this.opt.precision);}});});},"dojox/charting/plot2d/common":function(){define("dojox/charting/plot2d/common",["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,Color,g,df,sc){var _140d=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_140d,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_140e){if(!_140e){return _140e;}if(typeof _140e=="string"||_140e instanceof Color){_140e={color:_140e};}return g.makeParameters(g.defaultStroke,_140e);},augmentColor:function(_140f,color){var t=new Color(_140f),c=new Color(color);c.a=t.a;return c;},augmentStroke:function(_1410,color){var s=_140d.makeStroke(_1410);if(s){s.color=_140d.augmentColor(s.color,color);}return s;},augmentFill:function(fill,color){var fc,c=new Color(color);if(typeof fill=="string"||fill instanceof Color){return _140d.augmentColor(fill,color);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_1411){var stats=lang.delegate(_140d.defaultStats);for(var i=0;i<_1411.length;++i){var run=_1411[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _1412=stats.vmin,_1413=stats.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,y);stats.vmax=Math.max(stats.vmax,y);}});}if("ymin" in run){stats.vmin=Math.min(_1412,run.ymin);}if("ymax" in run){stats.vmax=Math.max(_1413,run.ymax);}}else{var _1414=stats.hmin,_1415=stats.hmax,_1412=stats.vmin,_1413=stats.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,y);stats.vmax=Math.max(stats.vmax,y);}});}if("xmin" in run){stats.hmin=Math.min(_1414,run.xmin);}if("xmax" in run){stats.hmax=Math.max(_1415,run.xmax);}if("ymin" in run){stats.vmin=Math.min(_1412,run.ymin);}if("ymax" in run){stats.vmax=Math.max(_1413,run.ymax);}}break;}}}return stats;},calculateBarSize:function(_1416,opt,_1417){if(!_1417){_1417=1;}var gap=opt.gap,size=(_1416-2*gap)/_1417;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_1416-size*_1417)/2;return {size:size,gap:gap};},collectStackedStats:function(_1418){var stats=lang.clone(_140d.defaultStats);if(_1418.length){stats.hmin=Math.min(stats.hmin,1);stats.hmax=df.foldl(_1418,"seed, run -> Math.max(seed, run.data.length)",stats.hmax);for(var i=0;i<stats.hmax;++i){var v=_1418[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}stats.vmin=Math.min(stats.vmin,v);for(var j=1;j<_1418.length;++j){var t=_1418[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}stats.vmax=Math.max(stats.vmax,v);}}return stats;},curve:function(a,_1419){var array=a.slice(0);if(_1419=="x"){array[array.length]=arr[0];}var p=arr.map(array,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_1419)){var dx=item.x-array[i-1].x,dy=array[i-1].y;return "C"+(item.x-(_1419-1)*(dx/_1419))+","+dy+" "+(item.x-(dx/_1419))+","+item.y+" "+item.x+","+item.y;}else{if(_1419=="X"||_1419=="x"||_1419=="S"){var p0,p1=array[i-1],p2=array[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_1419=="x"){p0=array[array.length-2];}else{p0=p1;}f=1/3;}else{p0=array[i-2];}if(i==(array.length-1)){if(_1419=="x"){p3=array[1];}else{p3=p2;}f=1/3;}else{p3=array[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var p0p2f=p0p2*f;var p1p3f=p1p3*f;if(p0p2f>p1p2/2&&p1p3f>p1p2/2){p0p2f=p1p2/2;p1p3f=p1p2/2;}else{if(p0p2f>p1p2/2){p0p2f=p1p2/2;p1p3f=p1p2/2*p1p3/p0p2;}else{if(p1p3f>p1p2/2){p1p3f=p1p2/2;p0p2f=p1p2/2*p0p2/p1p3;}}}if(_1419=="S"){if(p0==p1){p0p2f=0;}if(p2==p3){p1p3f=0;}}bz1x=p1.x+p0p2f*(p2.x-p0.x)/p0p2;bz1y=p1.y+p0p2f*(p2.y-p0.y)/p0p2;bz2x=p2.x-p1p3f*(p3.x-p1.x)/p1p3;bz2y=p2.y-p1p3f*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_141a,fixed,_141b){return sc.doIfLoaded("dojo/number",function(_141c){return (fixed?_141c.format(_141a,{places:_141b}):_141c.format(_141a))||"";},function(){return fixed?_141a.toFixed(_141b):_141a.toString();});}});});},"dojo/dnd/move":function(){define(["../main","./Mover","./Moveable"],function(dojo){dojo.declare("dojo.dnd.move.constrainedMoveable",dojo.dnd.Moveable,{constraints:function(){},within:false,constructor:function(node,_141d){if(!_141d){_141d={};}this.constraints=_141d.constraints;this.within=_141d.within;},onFirstMove:function(mover){var c=this.constraintBox=this.constraints.call(this,mover);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=dojo._getMarginSize(mover.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(mover,_141e){var c=this.constraintBox,s=mover.node.style;this.onMoving(mover,_141e);_141e.l=_141e.l<c.l?c.l:c.r<_141e.l?c.r:_141e.l;_141e.t=_141e.t<c.t?c.t:c.b<_141e.t?c.b:_141e.t;s.left=_141e.l+"px";s.top=_141e.t+"px";this.onMoved(mover,_141e);}});dojo.declare("dojo.dnd.move.boxConstrainedMoveable",dojo.dnd.move.constrainedMoveable,{box:{},constructor:function(node,_141f){var box=_141f&&_141f.box;this.constraints=function(){return box;};}});dojo.declare("dojo.dnd.move.parentConstrainedMoveable",dojo.dnd.move.constrainedMoveable,{area:"content",constructor:function(node,_1420){var area=_1420&&_1420.area;this.constraints=function(){var n=this.node.parentNode,s=dojo.getComputedStyle(n),mb=dojo._getMarginBox(n,s);if(area=="margin"){return mb;}var t=dojo._getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=dojo._getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=dojo._getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});dojo.dnd.constrainedMover=dojo.dnd.move.constrainedMover;dojo.dnd.boxConstrainedMover=dojo.dnd.move.boxConstrainedMover;dojo.dnd.parentConstrainedMover=dojo.dnd.move.parentConstrainedMover;return dojo.dnd.move;});},"url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"grid\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","dojox/charting/themes/PlotKit/cyan":function(){define("dojox/charting/themes/PlotKit/cyan",["./base","../../Theme"],function(pk,Theme){pk.cyan=pk.base.clone();pk.cyan.chart.fill=pk.cyan.plotarea.fill="#e6f1f5";pk.cyan.colors=Theme.defineColors({hue:194,saturation:60,low:40,high:88});return pk.cyan;});},"dojo/_base/connect":function(){define(["./kernel","../on","../topic","../aspect","./event","../mouse","./sniff","./lang","../keys"],function(_1421,on,hub,_1422,_1423,mouse,has,lang){has.add("events-keypress-typed",function(){var _1424={charCode:0};try{_1424=document.createEvent("KeyboardEvent");(_1424.initKeyboardEvent||_1424.initKeyEvent).call(_1424,"keypress",true,true,null,false,false,false,false,9,3);}catch(e){}return _1424.charCode==0&&!has("opera");});function _1425(obj,event,_1426,_1427,_1428){_1427=lang.hitch(_1426,_1427);if(!obj||!(obj.addEventListener||obj.attachEvent)){return _1422.after(obj||_1421.global,event,_1427,true);}if(typeof event=="string"&&event.substring(0,2)=="on"){event=event.substring(2);}if(!obj){obj=_1421.global;}if(!_1428){switch(event){case "keypress":event=_1429;break;case "mouseenter":event=mouse.enter;break;case "mouseleave":event=mouse.leave;break;}}return on(obj,event,_1427,_1428);};var _142a={106:42,111:47,186:59,187:43,188:44,189:45,190:46,191:47,192:96,219:91,220:92,221:93,222:39,229:113};var _142b=has("mac")?"metaKey":"ctrlKey";var _142c=function(evt,props){var faux=lang.mixin({},evt,props);_142d(faux);faux.preventDefault=function(){evt.preventDefault();};faux.stopPropagation=function(){evt.stopPropagation();};return faux;};function _142d(evt){evt.keyChar=evt.charCode?String.fromCharCode(evt.charCode):"";evt.charOrCode=evt.keyChar||evt.keyCode;};var _1429;if(has("events-keypress-typed")){var _142e=function(e,code){try{return (e.keyCode=code);}catch(e){return 0;}};_1429=function(_142f,_1430){var _1431=on(_142f,"keydown",function(evt){var k=evt.keyCode;var _1432=(k!=13||(has("ie")>=9&&!has("quirks")))&&k!=32&&(k!=27||!has("ie"))&&(k<48||k>90)&&(k<96||k>111)&&(k<186||k>192)&&(k<219||k>222)&&k!=229;if(_1432||evt.ctrlKey){var c=_1432?0:k;if(evt.ctrlKey){if(k==3||k==13){return _1430.call(evt.currentTarget,evt);}else{if(c>95&&c<106){c-=48;}else{if((!evt.shiftKey)&&(c>=65&&c<=90)){c+=32;}else{c=_142a[c]||c;}}}}var faux=_142c(evt,{type:"keypress",faux:true,charCode:c});_1430.call(evt.currentTarget,faux);if(has("ie")){_142e(evt,faux.keyCode);}}});var _1433=on(_142f,"keypress",function(evt){var c=evt.charCode;c=c>=32?c:0;evt=_142c(evt,{charCode:c,faux:true});return _1430.call(this,evt);});return {remove:function(){_1431.remove();_1433.remove();}};};}else{if(has("opera")){_1429=function(_1434,_1435){return on(_1434,"keypress",function(evt){var c=evt.which;if(c==3){c=99;}c=c<32&&!evt.shiftKey?0:c;if(evt.ctrlKey&&!evt.shiftKey&&c>=65&&c<=90){c+=32;}return _1435.call(this,_142c(evt,{charCode:c}));});};}else{_1429=function(_1436,_1437){return on(_1436,"keypress",function(evt){_142d(evt);return _1437.call(this,evt);});};}}var _1438={_keypress:_1429,connect:function(obj,event,_1439,_143a,_143b){var a=arguments,args=[],i=0;args.push(typeof a[0]=="string"?null:a[i++],a[i++]);var a1=a[i+1];args.push(typeof a1=="string"||typeof a1=="function"?a[i++]:null,a[i++]);for(var l=a.length;i<l;i++){args.push(a[i]);}return _1425.apply(this,args);},disconnect:function(_143c){if(_143c){_143c.remove();}},subscribe:function(topic,_143d,_143e){return hub.subscribe(topic,lang.hitch(_143d,_143e));},publish:function(topic,args){return hub.publish.apply(hub,[topic].concat(args));},connectPublisher:function(topic,obj,event){var pf=function(){_1438.publish(topic,arguments);};return event?_1438.connect(obj,event,pf):_1438.connect(obj,pf);},isCopyKey:function(e){return e[_142b];}};_1438.unsubscribe=_1438.disconnect;1&&lang.mixin(_1421,_1438);return _1438;});},"dojox/validate":function(){define("dojox/validate",["./validate/_base"],function(_143f){return _143f;});},"dijit/form/_ComboBoxMenu":function(){define("dijit/form/_ComboBoxMenu",["dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_1440,_1441,_1442,_1443,keys,_1444,_1445,_1446,_1447){return _1440("dijit.form._ComboBoxMenu",[_1444,_1445,_1447,_1446],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",_createMenuItem:function(){return _1442.create("div",{"class":"dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl"),role:"option"});},onHover:function(node){_1441.add(node,"dijitMenuItemHover");},onUnhover:function(node){_1441.remove(node,"dijitMenuItemHover");},onSelect:function(node){_1441.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_1441.remove(node,"dijitMenuItemSelected");},_page:function(up){var _1448=0;var _1449=this.domNode.scrollTop;var _144a=_1443.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_1448<_144a){if(up){if(!this.getHighlightedOption().previousSibling||this._highlighted_option.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!this.getHighlightedOption().nextSibling||this._highlighted_option.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _144b=this.domNode.scrollTop;_1448+=(_144b-_1449)*(up?-1:1);_1449=_144b;}},handleKey:function(evt){switch(evt.charOrCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/layout/_TabContainerBase":function(){require({cache:{"url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n"}});define("dijit/layout/_TabContainerBase",["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_144c,_144d,_144e,_144f,_1450,_1451,_1452,_1453){return _1450("dijit.layout._TabContainerBase",[_144d,_144f],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_144c,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_1453.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_1451.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_1451.add(this.domNode,"dijitTabContainerNested");_1451.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_1451.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_1451.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_1451.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_1451.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _1454=this.tabPosition.replace(/-h/,"");this.tablist.layoutAlign=_1454;var _1455=[this.tablist,{domNode:this.tablistSpacer,layoutAlign:_1454},{domNode:this.containerNode,layoutAlign:"client"}];_144e.layoutChildren(this.domNode,this._contentBox,_1455);this._containerContentBox=_144e.marginBox2contentBox(this.containerNode,_1455[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var width=_1452.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:width});}if(sc&&sc.resize){sc.resize();}}},destroy:function(){if(this.tablist){this.tablist.destroy();}this.inherited(arguments);}});});},"dijit/_KeyNavContainer":function(){define("dijit/_KeyNavContainer",["dojo/_base/kernel","./_Container","./_FocusMixin","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/event","dojo/dom-attr","dojo/_base/lang"],function(_1456,_1457,_1458,array,keys,_1459,event,_145a,lang){return _1459("dijit._KeyNavContainer",[_1458,_1457],{tabIndex:"0",connectKeyNavHandlers:function(_145b,_145c){var _145d=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");array.forEach(_145b,function(code){_145d[code]=prev;});array.forEach(_145c,function(code){_145d[code]=next;});_145d[keys.HOME]=lang.hitch(this,"focusFirstChild");_145d[keys.END]=lang.hitch(this,"focusLastChild");this.connect(this.domNode,"onkeypress","_onContainerKeypress");this.connect(this.domNode,"onfocus","_onContainerFocus");},startupKeyNavChildren:function(){_1456.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);array.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_145e,_145f){this.inherited(arguments);this._startupChild(_145e);},focus:function(){this.focusFirstChild();},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},focusChild:function(_1460,last){if(!_1460){return;}if(this.focusedChild&&_1460!==this.focusedChild){this._onChildBlur(this.focusedChild);}_1460.set("tabIndex",this.tabIndex);_1460.focus(last?"end":"start");this._set("focusedChild",_1460);},_startupChild:function(_1461){_1461.set("tabIndex","-1");this.connect(_1461,"_onFocus",function(){_1461.set("tabIndex",this.tabIndex);});this.connect(_1461,"_onBlur",function(){_1461.set("tabIndex","-1");});},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focusFirstChild();_145a.set(this.domNode,"tabIndex","-1");},_onBlur:function(evt){if(this.tabIndex){_145a.set(this.domNode,"tabIndex",this.tabIndex);}this.focusedChild=null;this.inherited(arguments);},_onContainerKeypress:function(evt){if(evt.ctrlKey||evt.altKey){return;}var func=this._keyNavCodes[evt.charOrCode];if(func){func();event.stop(evt);}},_onChildBlur:function(){},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},_getNextFocusableChild:function(child,dir){if(child){child=this._getSiblingOfChild(child,dir);}var _1462=this.getChildren();for(var i=0;i<_1462.length;i++){if(!child){child=_1462[(dir>0)?0:(_1462.length-1)];}if(child.isFocusable()){return child;}child=this._getSiblingOfChild(child,dir);}return null;}});});},"dijit/form/DataList":function(){define("dijit/form/DataList",["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_1463,dom,lang,query,_1464,_1465){function _1466(_1467){return {id:_1467.value,value:_1467.value,name:lang.trim(_1467.innerText||_1467.textContent||"")};};return _1463("dijit.form.DataList",_1464,{constructor:function(_1468,_1469){this.domNode=dom.byId(_1469);lang.mixin(this,_1468);if(this.id){_1465.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:query("option",this.domNode).map(_1466)}]);},destroy:function(){_1465.remove(this.id);},fetchSelectedItem:function(){var _146a=query("> option[selected]",this.domNode)[0]||query("> option",this.domNode)[0];return _146a&&_1466(_146a);}});});},"dijit/Tooltip":function(){require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","."],function(array,_146b,fx,dom,_146c,_146d,_146e,lang,has,win,_146f,place,_1470,_1471,_1472,_1473,dijit){var _1474=_146b("dijit._MasterTooltip",[_1470,_1471],{duration:_146f.defaultDuration,templateString:_1473,postCreate:function(){win.body().appendChild(this.domNode);this.bgIframe=new _1472(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_1475,_1476,_1477,rtl,_1478){if(this.aroundNode&&this.aroundNode===_1476&&this.containerNode.innerHTML==_1475){return;}this.domNode.width="auto";if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_1475;this.set("textDir",_1478);this.containerNode.align=rtl?"right":"left";var pos=place.around(this.domNode,_1476,_1477&&_1477.length?_1477:_1479.defaultPosition,!rtl,lang.hitch(this,"orient"));var _147a=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_147a.y+((_147a.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_147a.x+((_147a.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}_146e.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_1476;},orient:function(node,_147b,_147c,_147d,_147e){this.connectorNode.style.top="";var _147f=_147d.w-this.connectorNode.offsetWidth;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_147b+"-"+_147c];this.domNode.style.width="auto";var size=_146d.getContentBox(this.domNode);var width=Math.min((Math.max(_147f,1)),size.w);var _1480=width<size.w;this.domNode.style.width=width+"px";if(_1480){this.containerNode.style.overflow="auto";var _1481=this.containerNode.scrollWidth;this.containerNode.style.overflow="visible";if(_1481>width){_1481=_1481+_146e.get(this.domNode,"paddingLeft")+_146e.get(this.domNode,"paddingRight");this.domNode.style.width=_1481+"px";}}if(_147c.charAt(0)=="B"&&_147b.charAt(0)=="B"){var mb=_146d.getMarginBox(node);var _1482=this.connectorNode.offsetHeight;if(mb.h>_147d.h){var _1483=_147d.h-((_147e.h+_1482)>>1);this.connectorNode.style.top=_1483+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_147e.h/2-_1482/2,0),mb.h-_1482)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_147f);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_1484){if(this._onDeck&&this._onDeck[1]==_1484){this._onDeck=null;}else{if(this.aroundNode===_1484){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}},_setAutoTextDir:function(node){this.applyTextDir(node,has("ie")?node.outerText:node.textContent);array.forEach(node.children,function(child){this._setAutoTextDir(child);},this);},_setTextDirAttr:function(_1485){this._set("textDir",typeof _1485!="undefined"?_1485:"");if(_1485=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});dijit.showTooltip=function(_1486,_1487,_1488,rtl,_1489){if(!_1479._masterTT){dijit._masterTT=_1479._masterTT=new _1474();}return _1479._masterTT.show(_1486,_1487,_1488,rtl,_1489);};dijit.hideTooltip=function(_148a){return _1479._masterTT&&_1479._masterTT.hide(_148a);};var _1479=_146b("dijit.Tooltip",_1470,{label:"",showDelay:400,connectId:[],position:[],_setConnectIdAttr:function(newId){array.forEach(this._connections||[],function(_148b){array.forEach(_148b,lang.hitch(this,"disconnect"));},this);this._connectIds=array.filter(lang.isArrayLike(newId)?newId:(newId?[newId]:[]),function(id){return dom.byId(id);});this._connections=array.map(this._connectIds,function(id){var node=dom.byId(id);return [this.connect(node,"onmouseenter","_onHover"),this.connect(node,"onmouseleave","_onUnHover"),this.connect(node,"onfocus","_onHover"),this.connect(node,"onblur","_onUnHover")];},this);this._set("connectId",newId);},addTarget:function(node){var id=node.id||node;if(array.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=array.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_146c.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;array.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},_onHover:function(e){if(!this._showTimer){var _148c=e.target;this._showTimer=setTimeout(lang.hitch(this,function(){this.open(_148c);}),this.showDelay);}},_onUnHover:function(){if(this._focus){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}this.close();},open:function(_148d){if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}_1479.show(this.label||this.domNode.innerHTML,_148d,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_148d;this.onShow(_148d,this.position);},close:function(){if(this._connectNode){_1479.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},onShow:function(){},onHide:function(){},uninitialize:function(){this.close();this.inherited(arguments);}});_1479._MasterTooltip=_1474;_1479.show=dijit.showTooltip;_1479.hide=dijit.hideTooltip;_1479.defaultPosition=["after","before"];return _1479;});},"dojox/charting/plot2d/StackedAreas":function(){define("dojox/charting/plot2d/StackedAreas",["dojo/_base/declare","./Stacked"],function(_148e,_148f){return _148e("dojox.charting.plot2d.StackedAreas",_148f,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/PopupMenuItem":function(){define("dijit/PopupMenuItem",["dojo/_base/declare","dojo/dom-style","dojo/query","dojo/_base/window","./registry","./MenuItem","./hccss"],function(_1490,_1491,query,win,_1492,_1493){return _1490("dijit.PopupMenuItem",_1493,{_fillContent:function(){if(this.srcNodeRef){var nodes=query("*",this.srcNodeRef);this.inherited(arguments,[nodes[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=query("[widgetId]",this.dropDownContainer)[0];this.popup=_1492.byNode(node);}win.body().appendChild(this.popup.domNode);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_1491.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_1494){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_1494);}delete this.popup;}this.inherited(arguments);}});});},"dojo/selector/acme":function(){define(["../_base/kernel","../has","../dom","../_base/sniff","../_base/array","../_base/lang","../_base/window"],function(dojo,has,dom){var trim=dojo.trim;var each=dojo.forEach;var _1495=function(){return dojo.doc;};var _1496=((dojo.isWebKit||dojo.isMozilla)&&((_1495().compatMode)=="BackCompat"));var _1497=">~+";var _1498=false;var _1499=function(){return true;};var _149a=function(query){if(_1497.indexOf(query.slice(-1))>=0){query+=" * ";}else{query+=" ";}var ts=function(s,e){return trim(query.slice(s,e));};var _149b=[];var _149c=-1,_149d=-1,_149e=-1,_149f=-1,_14a0=-1,inId=-1,inTag=-1,lc="",cc="",_14a1;var x=0,ql=query.length,_14a2=null,_14a3=null;var _14a4=function(){if(inTag>=0){var tv=(inTag==x)?null:ts(inTag,x);_14a2[(_1497.indexOf(tv)<0)?"tag":"oper"]=tv;inTag=-1;}};var endId=function(){if(inId>=0){_14a2.id=ts(inId,x).replace(/\\/g,"");inId=-1;}};var _14a5=function(){if(_14a0>=0){_14a2.classes.push(ts(_14a0+1,x).replace(/\\/g,""));_14a0=-1;}};var _14a6=function(){endId();_14a4();_14a5();};var _14a7=function(){_14a6();if(_149f>=0){_14a2.pseudos.push({name:ts(_149f+1,x)});}_14a2.loops=(_14a2.pseudos.length||_14a2.attrs.length||_14a2.classes.length);_14a2.oquery=_14a2.query=ts(_14a1,x);_14a2.otag=_14a2.tag=(_14a2["oper"])?null:(_14a2.tag||"*");if(_14a2.tag){_14a2.tag=_14a2.tag.toUpperCase();}if(_149b.length&&(_149b[_149b.length-1].oper)){_14a2.infixOper=_149b.pop();_14a2.query=_14a2.infixOper.query+" "+_14a2.query;}_149b.push(_14a2);_14a2=null;};for(;lc=cc,cc=query.charAt(x),x<ql;x++){if(lc=="\\"){continue;}if(!_14a2){_14a1=x;_14a2={query:null,pseudos:[],attrs:[],classes:[],tag:null,oper:null,id:null,getTag:function(){return (_1498)?this.otag:this.tag;}};inTag=x;}if(_149c>=0){if(cc=="]"){if(!_14a3.attr){_14a3.attr=ts(_149c+1,x);}else{_14a3.matchFor=ts((_149e||_149c+1),x);}var cmf=_14a3.matchFor;if(cmf){if((cmf.charAt(0)=="\"")||(cmf.charAt(0)=="'")){_14a3.matchFor=cmf.slice(1,-1);}}_14a2.attrs.push(_14a3);_14a3=null;_149c=_149e=-1;}else{if(cc=="="){var _14a8=("|~^$*".indexOf(lc)>=0)?lc:"";_14a3.type=_14a8+cc;_14a3.attr=ts(_149c+1,x-_14a8.length);_149e=x+1;}}}else{if(_149d>=0){if(cc==")"){if(_149f>=0){_14a3.value=ts(_149d+1,x);}_149f=_149d=-1;}}else{if(cc=="#"){_14a6();inId=x+1;}else{if(cc=="."){_14a6();_14a0=x;}else{if(cc==":"){_14a6();_149f=x;}else{if(cc=="["){_14a6();_149c=x;_14a3={};}else{if(cc=="("){if(_149f>=0){_14a3={name:ts(_149f+1,x),value:null};_14a2.pseudos.push(_14a3);}_149d=x;}else{if((cc==" ")&&(lc!=cc)){_14a7();}}}}}}}}}return _149b;};var agree=function(first,_14a9){if(!first){return _14a9;}if(!_14a9){return first;}return function(){return first.apply(window,arguments)&&_14a9.apply(window,arguments);};};var _14aa=function(i,arr){var r=arr||[];if(i){r.push(i);}return r;};var _14ab=function(n){return (1==n.nodeType);};var blank="";var _14ac=function(elem,attr){if(!elem){return blank;}if(attr=="class"){return elem.className||blank;}if(attr=="for"){return elem.htmlFor||blank;}if(attr=="style"){return elem.style.cssText||blank;}return (_1498?elem.getAttribute(attr):elem.getAttribute(attr,2))||blank;};var attrs={"*=":function(attr,value){return function(elem){return (_14ac(elem,attr).indexOf(value)>=0);};},"^=":function(attr,value){return function(elem){return (_14ac(elem,attr).indexOf(value)==0);};},"$=":function(attr,value){return function(elem){var ea=" "+_14ac(elem,attr);return (ea.lastIndexOf(value)==(ea.length-value.length));};},"~=":function(attr,value){var tval=" "+value+" ";return function(elem){var ea=" "+_14ac(elem,attr)+" ";return (ea.indexOf(tval)>=0);};},"|=":function(attr,value){var _14ad=value+"-";return function(elem){var ea=_14ac(elem,attr);return ((ea==value)||(ea.indexOf(_14ad)==0));};},"=":function(attr,value){return function(elem){return (_14ac(elem,attr)==value);};}};var _14ae=(typeof _1495().firstChild.nextElementSibling=="undefined");var _14af=!_14ae?"nextElementSibling":"nextSibling";var _14b0=!_14ae?"previousElementSibling":"previousSibling";var _14b1=(_14ae?_14ab:_1499);var _14b2=function(node){while(node=node[_14b0]){if(_14b1(node)){return false;}}return true;};var _14b3=function(node){while(node=node[_14af]){if(_14b1(node)){return false;}}return true;};var _14b4=function(node){var root=node.parentNode;var i=0,tret=root.children||root.childNodes,ci=(node["_i"]||-1),cl=(root["_l"]||-1);if(!tret){return -1;}var l=tret.length;if(cl==l&&ci>=0&&cl>=0){return ci;}root["_l"]=l;ci=-1;for(var te=root["firstElementChild"]||root["firstChild"];te;te=te[_14af]){if(_14b1(te)){te["_i"]=++i;if(node===te){ci=i;}}}return ci;};var _14b5=function(elem){return !((_14b4(elem))%2);};var isOdd=function(elem){return ((_14b4(elem))%2);};var _14b6={"checked":function(name,_14b7){return function(elem){return !!("checked" in elem?elem.checked:elem.selected);};},"first-child":function(){return _14b2;},"last-child":function(){return _14b3;},"only-child":function(name,_14b8){return function(node){return _14b2(node)&&_14b3(node);};},"empty":function(name,_14b9){return function(elem){var cn=elem.childNodes;var cnl=elem.childNodes.length;for(var x=cnl-1;x>=0;x--){var nt=cn[x].nodeType;if((nt===1)||(nt==3)){return false;}}return true;};},"contains":function(name,_14ba){var cz=_14ba.charAt(0);if(cz=="\""||cz=="'"){_14ba=_14ba.slice(1,-1);}return function(elem){return (elem.innerHTML.indexOf(_14ba)>=0);};},"not":function(name,_14bb){var p=_149a(_14bb)[0];var _14bc={el:1};if(p.tag!="*"){_14bc.tag=1;}if(!p.classes.length){_14bc.classes=1;}var ntf=_14bd(p,_14bc);return function(elem){return (!ntf(elem));};},"nth-child":function(name,_14be){var pi=parseInt;if(_14be=="odd"){return isOdd;}else{if(_14be=="even"){return _14b5;}}if(_14be.indexOf("n")!=-1){var _14bf=_14be.split("n",2);var pred=_14bf[0]?((_14bf[0]=="-")?-1:pi(_14bf[0])):1;var idx=_14bf[1]?pi(_14bf[1]):0;var lb=0,ub=-1;if(pred>0){if(idx<0){idx=(idx%pred)&&(pred+(idx%pred));}else{if(idx>0){if(idx>=pred){lb=idx-idx%pred;}idx=idx%pred;}}}else{if(pred<0){pred*=-1;if(idx>0){ub=idx;idx=idx%pred;}}}if(pred>0){return function(elem){var i=_14b4(elem);return (i>=lb)&&(ub<0||i<=ub)&&((i%pred)==idx);};}else{_14be=idx;}}var _14c0=pi(_14be);return function(elem){return (_14b4(elem)==_14c0);};}};var _14c1=(dojo.isIE&&(dojo.isIE<9||dojo.isQuirks))?function(cond){var clc=cond.toLowerCase();if(clc=="class"){cond="className";}return function(elem){return (_1498?elem.getAttribute(cond):elem[cond]||elem[clc]);};}:function(cond){return function(elem){return (elem&&elem.getAttribute&&elem.hasAttribute(cond));};};var _14bd=function(query,_14c2){if(!query){return _1499;}_14c2=_14c2||{};var ff=null;if(!("el" in _14c2)){ff=agree(ff,_14ab);}if(!("tag" in _14c2)){if(query.tag!="*"){ff=agree(ff,function(elem){return (elem&&(elem.tagName==query.getTag()));});}}if(!("classes" in _14c2)){each(query.classes,function(cname,idx,arr){var re=new RegExp("(?:^|\\s)"+cname+"(?:\\s|$)");ff=agree(ff,function(elem){return re.test(elem.className);});ff.count=idx;});}if(!("pseudos" in _14c2)){each(query.pseudos,function(_14c3){var pn=_14c3.name;if(_14b6[pn]){ff=agree(ff,_14b6[pn](pn,_14c3.value));}});}if(!("attrs" in _14c2)){each(query.attrs,function(attr){var _14c4;var a=attr.attr;if(attr.type&&attrs[attr.type]){_14c4=attrs[attr.type](a,attr.matchFor);}else{if(a.length){_14c4=_14c1(a);}}if(_14c4){ff=agree(ff,_14c4);}});}if(!("id" in _14c2)){if(query.id){ff=agree(ff,function(elem){return (!!elem&&(elem.id==query.id));});}}if(!ff){if(!("default" in _14c2)){ff=_1499;}}return ff;};var _14c5=function(_14c6){return function(node,ret,bag){while(node=node[_14af]){if(_14ae&&(!_14ab(node))){continue;}if((!bag||_14c7(node,bag))&&_14c6(node)){ret.push(node);}break;}return ret;};};var _14c8=function(_14c9){return function(root,ret,bag){var te=root[_14af];while(te){if(_14b1(te)){if(bag&&!_14c7(te,bag)){break;}if(_14c9(te)){ret.push(te);}}te=te[_14af];}return ret;};};var _14ca=function(_14cb){_14cb=_14cb||_1499;return function(root,ret,bag){var te,x=0,tret=root.children||root.childNodes;while(te=tret[x++]){if(_14b1(te)&&(!bag||_14c7(te,bag))&&(_14cb(te,x))){ret.push(te);}}return ret;};};var _14cc=function(node,root){var pn=node.parentNode;while(pn){if(pn==root){break;}pn=pn.parentNode;}return !!pn;};var _14cd={};var _14ce=function(query){var _14cf=_14cd[query.query];if(_14cf){return _14cf;}var io=query.infixOper;var oper=(io?io.oper:"");var _14d0=_14bd(query,{el:1});var qt=query.tag;var _14d1=("*"==qt);var ecs=_1495()["getElementsByClassName"];if(!oper){if(query.id){_14d0=(!query.loops&&_14d1)?_1499:_14bd(query,{el:1,id:1});_14cf=function(root,arr){var te=dom.byId(query.id,(root.ownerDocument||root));if(!te||!_14d0(te)){return;}if(9==root.nodeType){return _14aa(te,arr);}else{if(_14cc(te,root)){return _14aa(te,arr);}}};}else{if(ecs&&/\{\s*\[native code\]\s*\}/.test(String(ecs))&&query.classes.length&&!_1496){_14d0=_14bd(query,{el:1,classes:1,id:1});var _14d2=query.classes.join(" ");_14cf=function(root,arr,bag){var ret=_14aa(0,arr),te,x=0;var tret=root.getElementsByClassName(_14d2);while((te=tret[x++])){if(_14d0(te,root)&&_14c7(te,bag)){ret.push(te);}}return ret;};}else{if(!_14d1&&!query.loops){_14cf=function(root,arr,bag){var ret=_14aa(0,arr),te,x=0;var tret=root.getElementsByTagName(query.getTag());while((te=tret[x++])){if(_14c7(te,bag)){ret.push(te);}}return ret;};}else{_14d0=_14bd(query,{el:1,tag:1,id:1});_14cf=function(root,arr,bag){var ret=_14aa(0,arr),te,x=0;var tret=root.getElementsByTagName(query.getTag());while((te=tret[x++])){if(_14d0(te,root)&&_14c7(te,bag)){ret.push(te);}}return ret;};}}}}else{var _14d3={el:1};if(_14d1){_14d3.tag=1;}_14d0=_14bd(query,_14d3);if("+"==oper){_14cf=_14c5(_14d0);}else{if("~"==oper){_14cf=_14c8(_14d0);}else{if(">"==oper){_14cf=_14ca(_14d0);}}}}return _14cd[query.query]=_14cf;};var _14d4=function(root,_14d5){var _14d6=_14aa(root),qp,x,te,qpl=_14d5.length,bag,ret;for(var i=0;i<qpl;i++){ret=[];qp=_14d5[i];x=_14d6.length-1;if(x>0){bag={};ret.nozip=true;}var gef=_14ce(qp);for(var j=0;(te=_14d6[j]);j++){gef(te,ret,bag);}if(!ret.length){break;}_14d6=ret;}return ret;};var _14d7={},_14d8={};var _14d9=function(query){var _14da=_149a(trim(query));if(_14da.length==1){var tef=_14ce(_14da[0]);return function(root){var r=tef(root,[]);if(r){r.nozip=true;}return r;};}return function(root){return _14d4(root,_14da);};};var nua=navigator.userAgent;var wk="WebKit/";var is525=(dojo.isWebKit&&(nua.indexOf(wk)>0)&&(parseFloat(nua.split(wk)[1])>528));var noZip=dojo.isIE?"commentStrip":"nozip";var qsa="querySelectorAll";var _14db=(!!_1495()[qsa]&&(!dojo.isSafari||(dojo.isSafari>3.1)||is525));var _14dc=/n\+\d|([^ ])?([>~+])([^ =])?/g;var _14dd=function(match,pre,ch,post){return ch?(pre?pre+" ":"")+ch+(post?" "+post:""):match;};var _14de=function(query,_14df){query=query.replace(_14dc,_14dd);if(_14db){var _14e0=_14d8[query];if(_14e0&&!_14df){return _14e0;}}var _14e1=_14d7[query];if(_14e1){return _14e1;}var qcz=query.charAt(0);var _14e2=(-1==query.indexOf(" "));if((query.indexOf("#")>=0)&&(_14e2)){_14df=true;}var _14e3=(_14db&&(!_14df)&&(_1497.indexOf(qcz)==-1)&&(!dojo.isIE||(query.indexOf(":")==-1))&&(!(_1496&&(query.indexOf(".")>=0)))&&(query.indexOf(":contains")==-1)&&(query.indexOf(":checked")==-1)&&(query.indexOf("|=")==-1));if(_14e3){var tq=(_1497.indexOf(query.charAt(query.length-1))>=0)?(query+" *"):query;return _14d8[query]=function(root){try{if(!((9==root.nodeType)||_14e2)){throw "";}var r=root[qsa](tq);r[noZip]=true;return r;}catch(e){return _14de(query,true)(root);}};}else{var parts=query.split(/\s*,\s*/);return _14d7[query]=((parts.length<2)?_14d9(query):function(root){var _14e4=0,ret=[],tp;while((tp=parts[_14e4++])){ret=ret.concat(_14d9(tp)(root));}return ret;});}};var _14e5=0;var _14e6=dojo.isIE?function(node){if(_1498){return (node.getAttribute("_uid")||node.setAttribute("_uid",++_14e5)||_14e5);}else{return node.uniqueID;}}:function(node){return (node._uid||(node._uid=++_14e5));};var _14c7=function(node,bag){if(!bag){return 1;}var id=_14e6(node);if(!bag[id]){return bag[id]=1;}return 0;};var _14e7="_zipIdx";var _14e8=function(arr){if(arr&&arr.nozip){return arr;}var ret=[];if(!arr||!arr.length){return ret;}if(arr[0]){ret.push(arr[0]);}if(arr.length<2){return ret;}_14e5++;if(dojo.isIE&&_1498){var szidx=_14e5+"";arr[0].setAttribute(_14e7,szidx);for(var x=1,te;te=arr[x];x++){if(arr[x].getAttribute(_14e7)!=szidx){ret.push(te);}te.setAttribute(_14e7,szidx);}}else{if(dojo.isIE&&arr.commentStrip){try{for(var x=1,te;te=arr[x];x++){if(_14ab(te)){ret.push(te);}}}catch(e){}}else{if(arr[0]){arr[0][_14e7]=_14e5;}for(var x=1,te;te=arr[x];x++){if(arr[x][_14e7]!=_14e5){ret.push(te);}te[_14e7]=_14e5;}}}return ret;};var query=function(query,root){root=root||_1495();var od=root.ownerDocument||root.documentElement;_1498=(root.contentType&&root.contentType=="application/xml")||(dojo.isOpera&&(root.doctype||od.toString()=="[object XMLDocument]"))||(!!od)&&(dojo.isIE?od.xml:(root.xmlVersion||od.xmlVersion));var r=_14de(query)(root);if(r&&r.nozip){return r;}return _14e8(r);};query.filter=function(_14e9,_14ea,root){var _14eb=[],parts=_149a(_14ea),_14ec=(parts.length==1&&!/[^\w#\.]/.test(_14ea))?_14bd(parts[0]):function(node){return dojo.query(_14ea,root).indexOf(node)!=-1;};for(var x=0,te;te=_14e9[x];x++){if(_14ec(te)){_14eb.push(te);}}return _14eb;};return query;});},"dijit/main":function(){define("dijit/main",["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/layout/ContentPane":function(){define("dijit/layout/ContentPane",["dojo/_base/kernel","dojo/_base/lang","../_Widget","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/_base/window","dojo/_base/xhr","dojo/i18n"],function(_14ed,lang,_14ee,_14ef,_14f0,html,_14f1,array,_14f2,_14f3,dom,_14f4,win,xhr,i18n){return _14f2("dijit.layout.ContentPane",[_14ee,_14ef],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_14ed._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,create:function(_14f5,_14f6){if((!_14f5||!_14f5.template)&&_14f6&&!("href" in _14f5)&&!("content" in _14f5)){var df=win.doc.createDocumentFragment();_14f6=dom.byId(_14f6);while(_14f6.firstChild){df.appendChild(_14f6.firstChild);}_14f5=lang.delegate(_14f5,{content:df});}this.inherited(arguments,[_14f5,_14f6]);},postMixInProperties:function(){this.inherited(arguments);var _14f7=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_14f0.substitute(this.loadingMessage,_14f7);this.errorMessage=_14f0.substitute(this.errorMessage,_14f7);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.title="";if(!_14f4.get(this.domNode,"role")){this.domNode.setAttribute("role","group");}},startup:function(){this.inherited(arguments);if(this._contentSetter){array.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_14ed.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _14f3(lang.hitch(this,"cancel"));this.onLoadDeferred.addCallback(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_14ed.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _14f3(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.addCallback(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},uninitialize:function(){if(this._beingDestroyed){this.cancel();}this.inherited(arguments);},destroyRecursive:function(_14f8){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _14f3(lang.hitch(this,"cancel"));this.onLoadDeferred.addCallback(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _14f9={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_14f9,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_14f9));hand.addCallback(function(html){try{self._isDownloaded=true;self._setContent(html,false);self.onDownloadEnd();}catch(err){self._onError("Content",err);}delete self._xhrDfd;return html;});hand.addErrback(function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.callback(data);}catch(e){console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_14fa){if(this.isLoaded){this._onUnloadHandler();}var _14fb=this._contentSetter;array.forEach(this.getChildren(),function(_14fc){if(_14fc.destroyRecursive){_14fc.destroyRecursive(_14fa);}});if(_14fb){array.forEach(_14fb.parseResults,function(_14fd){if(_14fd.destroyRecursive&&_14fd.domNode&&_14fd.domNode.parentNode==win.body()){_14fd.destroyRecursive(_14fa);}});delete _14fb.parseResults;}if(!_14fa){html._emptyNode(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_14fe){this.destroyDescendants();var _14ff=this._contentSetter;if(!(_14ff&&_14ff instanceof html._ContentSetter)){_14ff=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _1500=this.onContentError(e);try{this.containerNode.innerHTML=_1500;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _1501=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});_14ff.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_1501);delete this._contentSetterParams;if(this.doLayout){this._checkIfSingleChild();}if(!_14fe){if(this._started){delete this._started;this.startup();this._scheduleLayout();}this._onLoadHandler(cont);}},_onError:function(type,err,_1502){this.onLoadDeferred.errback(err);var _1503=this["on"+type+"Error"].call(this,err);if(_1502){console.error(_1502,err);}else{if(_1503){this._setContent(_1503,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dojox/grid/_SelectionPreserver":function(){define("dojox/grid/_SelectionPreserver",["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_1504,_1505,lang,array){return _1504("dojox.grid._SelectionPreserver",null,{constructor:function(_1506){this.selection=_1506;var grid=this.grid=_1506.grid;this.reset();this._connects=[_1505.connect(grid,"_setStore",this,"reset"),_1505.connect(grid,"_addItem",this,"_reSelectById"),_1505.connect(_1506,"addToSelection",lang.hitch(this,"_selectById",true)),_1505.connect(_1506,"deselect",lang.hitch(this,"_selectById",false)),_1505.connect(_1506,"deselectAll",this,"reset")];},destroy:function(){this.reset();array.forEach(this._connects,_1505.disconnect);delete this._connects;},reset:function(){this._selectedById={};},_reSelectById:function(item,index){if(item&&this.grid._hasIdentity){this.selection.selected[index]=this._selectedById[this.grid.store.getIdentity(item)];}},_selectById:function(_1507,_1508){if(this.selection.mode=="none"||!this.grid._hasIdentity){return;}var item=_1508,g=this.grid;if(typeof _1508=="number"||typeof _1508=="string"){var entry=g._by_idx[_1508];item=entry&&entry.item;}if(item){this._selectedById[g.store.getIdentity(item)]=!!_1507;}return item;}});});},"dijit/_WidgetsInTemplateMixin":function(){define("dijit/_WidgetsInTemplateMixin",["dojo/_base/array","dojo/_base/declare","dojo/parser","dijit/registry"],function(array,_1509,_150a,_150b){return _1509("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,_beforeFillContent:function(){if(this.widgetsInTemplate){var node=this.domNode;var cw=(this._startupWidgets=_150a.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,scope:"dojo"}));this._supportingWidgets=_150b.findWidgets(node);this._attachTemplateNodes(cw,function(n,p){return n[p];});}},startup:function(){array.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this.inherited(arguments);}});});},"dijit/form/VerticalRule":function(){define("dijit/form/VerticalRule",["dojo/_base/declare","./HorizontalRule"],function(_150c,_150d){return _150c("dijit.form.VerticalRule",_150d,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});});},"dijit/_HasDropDown":function(){define("dijit/_HasDropDown",["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/touch","dojo/_base/window","dojo/window","./registry","./focus","./popup","./_FocusMixin"],function(_150e,_150f,event,dom,_1510,_1511,_1512,_1513,has,keys,lang,touch,win,_1514,_1515,focus,popup,_1516){return _150e("dijit._HasDropDown",_1516,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}event.stop(e);this._docHandler=this.connect(win.doc,touch.release,"_onDropDownMouseUp");this.toggleDropDown();},_onDropDownMouseUp:function(e){if(e&&this._docHandler){this.disconnect(this._docHandler);}var _1517=this.dropDown,_1518=false;if(e&&this._opened){var c=_1512.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_1518){if(_1511.contains(t,"dijitPopup")){_1518=true;}else{t=t.parentNode;}}if(_1518){t=e.target;if(_1517.onItemClick){var _1519;while(t&&!(_1519=_1515.byNode(t))){t=t.parentNode;}if(_1519&&_1519.onClick&&_1519.getParent){_1519.getParent().onItemClick(_1519,e);}}return;}}}if(this._opened){if(_1517.focus&&_1517.autoFocus!==false){window.setTimeout(lang.hitch(_1517,"focus"),1);}}else{setTimeout(lang.hitch(this,"focus"),0);}if(has("ios")){this._justGotMouseUp=true;setTimeout(lang.hitch(this,function(){this._justGotMouseUp=false;}),0);}},_onDropDownClick:function(e){if(has("ios")&&!this._justGotMouseUp){this._onDropDownMouseDown(e);this._onDropDownMouseUp(e);}if(this._stopClickEvents){event.stop(e);}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _151a={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_1511.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_151a+"ArrowButton");},postCreate:function(){this.inherited(arguments);this.connect(this._buttonNode,touch.press,"_onDropDownMouseDown");this.connect(this._buttonNode,"onclick","_onDropDownClick");this.connect(this.focusNode,"onkeypress","_onKey");this.connect(this.focusNode,"onkeyup","_onKeyUp");},destroy:function(){if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_151b=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){event.stop(e);return;}}if(d&&this._opened&&e.charOrCode==keys.ESCAPE){this.closeDropDown();event.stop(e);}else{if(!this._opened&&(e.charOrCode==keys.DOWN_ARROW||((e.charOrCode==keys.ENTER||e.charOrCode==" ")&&((_151b.tagName||"").toLowerCase()!=="input"||(_151b.type&&_151b.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;event.stop(e);}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){setTimeout(lang.hitch(d,"focus"),1);}}},_onBlur:function(){var _151c=focus.curNode&&this.dropDown&&dom.isDescendant(focus.curNode,this.dropDown.domNode);this.closeDropDown(_151c);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_151d){_151d();},loadAndOpenDropDown:function(){var d=new _150f(),_151e=lang.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_151e);}else{_151e();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown();}},openDropDown:function(){var _151f=this.dropDown,_1520=_151f.domNode,_1521=this._aroundNode||this.domNode,self=this;if(!this._preparedNode){this._preparedNode=true;if(_1520.style.width){this._explicitDDWidth=true;}if(_1520.style.height){this._explicitDDHeight=true;}}if(this.maxHeight||this.forceWidth||this.autoWidth){var _1522={display:"",visibility:"hidden"};if(!this._explicitDDWidth){_1522.width="";}if(!this._explicitDDHeight){_1522.height="";}_1513.set(_1520,_1522);var _1523=this.maxHeight;if(_1523==-1){var _1524=_1514.getBox(),_1525=_1512.position(_1521,false);_1523=Math.floor(Math.max(_1525.y,_1524.h-(_1525.y+_1525.h)));}popup.moveOffScreen(_151f);if(_151f.startup&&!_151f._started){_151f.startup();}var mb=_1512.getMarginSize(_1520);var _1526=(_1523&&mb.h>_1523);_1513.set(_1520,{overflowX:"hidden",overflowY:_1526?"auto":"hidden"});if(_1526){mb.h=_1523;if("w" in mb){mb.w+=16;}}else{delete mb.h;}if(this.forceWidth){mb.w=_1521.offsetWidth;}else{if(this.autoWidth){mb.w=Math.max(mb.w,_1521.offsetWidth);}else{delete mb.w;}}if(lang.isFunction(_151f.resize)){_151f.resize(mb);}else{_1512.setMarginBox(_1520,mb);}}var _1527=popup.open({parent:this,popup:_151f,around:_1521,orient:this.dropDownPosition,onExecute:function(){self.closeDropDown(true);},onCancel:function(){self.closeDropDown(true);},onClose:function(){_1510.set(self._popupStateNode,"popupActive",false);_1511.remove(self._popupStateNode,"dijitHasDropDownOpen");self._opened=false;}});_1510.set(this._popupStateNode,"popupActive","true");_1511.add(self._popupStateNode,"dijitHasDropDownOpen");this._opened=true;return _1527;},closeDropDown:function(focus){if(this._opened){if(focus){this.focus();}popup.close(this.dropDown);this._opened=false;}}});});},"dojo/_base/event":function(){define(["./kernel","../on","../has","../dom-geometry"],function(dojo,on,has,dom){if(on._fixEvent){var _1528=on._fixEvent;on._fixEvent=function(evt,se){evt=_1528(evt,se);if(evt){dom.normalizeEvent(evt);}return evt;};}dojo.fixEvent=function(evt,_1529){if(on._fixEvent){return on._fixEvent(evt,_1529);}return evt;};dojo.stopEvent=function(evt){if(has("dom-addeventlistener")||(evt&&evt.preventDefault)){evt.preventDefault();evt.stopPropagation();}else{evt=evt||window.event;evt.cancelBubble=true;on._preventDefault.call(evt);}};return {fix:dojo.fixEvent,stop:dojo.stopEvent};});},"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n","dojo/_base/html":function(){define(["./kernel","../dom","../dom-style","../dom-attr","../dom-prop","../dom-class","../dom-construct","../dom-geometry"],function(dojo,dom,style,attr,prop,cls,ctr,geom){dojo.byId=dom.byId;dojo.isDescendant=dom.isDescendant;dojo.setSelectable=dom.setSelectable;dojo.getAttr=attr.get;dojo.setAttr=attr.set;dojo.hasAttr=attr.has;dojo.removeAttr=attr.remove;dojo.getNodeProp=attr.getNodeProp;dojo.attr=function(node,name,value){if(arguments.length==2){return attr[typeof name=="string"?"get":"set"](node,name);}return attr.set(node,name,value);};dojo.hasClass=cls.contains;dojo.addClass=cls.add;dojo.removeClass=cls.remove;dojo.toggleClass=cls.toggle;dojo.replaceClass=cls.replace;dojo._toDom=dojo.toDom=ctr.toDom;dojo.place=ctr.place;dojo.create=ctr.create;dojo.empty=function(node){ctr.empty(node);};dojo._destroyElement=dojo.destroy=function(node){ctr.destroy(node);};dojo._getPadExtents=dojo.getPadExtents=geom.getPadExtents;dojo._getBorderExtents=dojo.getBorderExtents=geom.getBorderExtents;dojo._getPadBorderExtents=dojo.getPadBorderExtents=geom.getPadBorderExtents;dojo._getMarginExtents=dojo.getMarginExtents=geom.getMarginExtents;dojo._getMarginSize=dojo.getMarginSize=geom.getMarginSize;dojo._getMarginBox=dojo.getMarginBox=geom.getMarginBox;dojo.setMarginBox=geom.setMarginBox;dojo._getContentBox=dojo.getContentBox=geom.getContentBox;dojo.setContentSize=geom.setContentSize;dojo._isBodyLtr=dojo.isBodyLtr=geom.isBodyLtr;dojo._docScroll=dojo.docScroll=geom.docScroll;dojo._getIeDocumentElementOffset=dojo.getIeDocumentElementOffset=geom.getIeDocumentElementOffset;dojo._fixIeBiDiScrollLeft=dojo.fixIeBiDiScrollLeft=geom.fixIeBiDiScrollLeft;dojo.position=geom.position;dojo.marginBox=function marginBox(node,box){return box?geom.setMarginBox(node,box):geom.getMarginBox(node);};dojo.contentBox=function contentBox(node,box){return box?geom.setContentSize(node,box):geom.getContentBox(node);};dojo.coords=function(node,_152a){dojo.deprecated("dojo.coords()","Use dojo.position() or dojo.marginBox().");node=dom.byId(node);var s=style.getComputedStyle(node),mb=geom.getMarginBox(node,s);var abs=geom.position(node,_152a);mb.x=abs.x;mb.y=abs.y;return mb;};dojo.getProp=prop.get;dojo.setProp=prop.set;dojo.prop=function(node,name,value){if(arguments.length==2){return prop[typeof name=="string"?"get":"set"](node,name);}return prop.set(node,name,value);};dojo.getStyle=style.get;dojo.setStyle=style.set;dojo.getComputedStyle=style.getComputedStyle;dojo.__toPixelValue=dojo.toPixelValue=style.toPixelValue;dojo.style=function(node,name,value){switch(arguments.length){case 1:return style.get(node);case 2:return style[typeof name=="string"?"get":"set"](node,name);}return style.set(node,name,value);};return dojo;});},"dojo/_base/kernel":function(){define(["../has","./config","require","module"],function(has,_152b,_152c,_152d){var i,p,dijit={},dojox={},dojo={config:_152b,global:this,dijit:dijit,dojox:dojox};var _152e={dojo:["dojo",dojo],dijit:["dijit",dijit],dojox:["dojox",dojox]},_152f=(_152c.packs&&_152c.packs[_152d.id.match(/[^\/]+/)[0]].packageMap)||{},item;for(p in _152f){if(_152e[p]){_152e[p][0]=_152f[p];}else{_152e[p]=[_152f[p],{}];}}for(p in _152e){item=_152e[p];item[1]._scopeName=item[0];if(!_152b.noGlobals){this[item[0]]=item[1];}}dojo.scopeMap=_152e;dojo.baseUrl=dojo.config.baseUrl=_152c.baseUrl;dojo.isAsync=!1||_152c.async;dojo.locale=_152b.locale;var rev="$Rev: 27407 $".match(/\d+/);dojo.version={major:1,minor:7,patch:1,flag:"",revision:rev?+rev[0]:NaN,toString:function(){var v=dojo.version;return v.major+"."+v.minor+"."+v.patch+v.flag+" ("+v.revision+")";}};true||has.add("extend-dojo",1);if(1){dojo.eval=_152c.eval;}else{var eval_=new Function("__text","return eval(__text);");dojo.eval=function(text,hint){return eval_(text+"\r\n////@ sourceURL="+hint);};}if(0){dojo.exit=function(_1530){quit(_1530);};}else{dojo.exit=function(){};}true||has.add("dojo-guarantee-console",1);if(1){typeof console!="undefined"||(console={});var cn=["assert","count","debug","dir","dirxml","error","group","groupEnd","info","profile","profileEnd","time","timeEnd","trace","warn","log"];var tn;i=0;while((tn=cn[i++])){if(!console[tn]){(function(){var tcn=tn+"";console[tcn]=("log" in console)?function(){var a=Array.apply({},arguments);a.unshift(tcn+":");console["log"](a.join(" "));}:function(){};console[tcn]._fake=true;})();}}}has.add("dojo-debug-messages",!!_152b.isDebug);if(has("dojo-debug-messages")){dojo.deprecated=function(_1531,extra,_1532){var _1533="DEPRECATED: "+_1531;if(extra){_1533+=" "+extra;}if(_1532){_1533+=" -- will be removed in version: "+_1532;}console.warn(_1533);};dojo.experimental=function(_1534,extra){var _1535="EXPERIMENTAL: "+_1534+" -- APIs subject to change without notice.";if(extra){_1535+=" "+extra;}console.warn(_1535);};}else{dojo.deprecated=dojo.experimental=function(){};}true||has.add("dojo-modulePaths",1);if(1){if(_152b.modulePaths){dojo.deprecated("dojo.modulePaths","use paths configuration");var paths={};for(p in _152b.modulePaths){paths[p.replace(/\./g,"/")]=_152b.modulePaths[p];}_152c({paths:paths});}}true||has.add("dojo-moduleUrl",1);if(1){dojo.moduleUrl=function(_1536,url){dojo.deprecated("dojo.moduleUrl()","use require.toUrl","2.0");var _1537=null;if(_1536){_1537=_152c.toUrl(_1536.replace(/\./g,"/")+(url?("/"+url):"")+"/*.*").replace(/\/\*\.\*/,"")+(url?"":"/");}return _1537;};}dojo._hasResource={};return dojo;});},"dojox/gfx/_base":function(){define("dojox/gfx/_base",["dojo/_base/lang","dojo/_base/html","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(lang,html,Color,has,win,arr,dom,_1538,_1539){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_153a){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_153a+" ")>=0;};g._addClass=function(node,_153b){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_153b+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_153b);}};g._removeClass=function(node,_153c){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_153c+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _153d={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_1538.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _153d){div.style.fontSize=p;_153d[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _153d;};var _153e=null;b._getCachedFontMeasurements=function(_153f){if(_153f||!_153e){_153e=b._getFontMeasurements();}return _153e;};var _1540=null,empty={};b._getTextBox=function(text,style,_1541){var m,s,al=arguments.length;var i;if(!_1540){_1540=_1538.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_1540;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&style){for(i in style){if(i in empty){continue;}s[i]=style[i];}}if(al>2&&_1541){m.className=_1541;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _1539.getMarginBox(m);}};var _1542=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"xUnique"+(++_1542);}while(dom.byId(id));return id;};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _1543={};return function(type){var t=_1543[type];if(t){return new t();}t=_1543[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(color){return (color instanceof Color)?color:new Color(color);},normalizeParameters:function(_1544,_1545){var x;if(_1545){var empty={};for(x in _1544){if(x in _1545&&!(x in empty)){_1544[x]=_1545[x];}}}return _1544;},makeParameters:function(_1546,_1547){var i=null;if(!_1547){return lang.delegate(_1546);}var _1548={};for(i in _1546){if(!(i in _1548)){_1548[i]=lang.clone((i in _1547)?_1547[i]:_1546[i]);}}return _1548;},formatNumber:function(x,_1549){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var point=val.indexOf(".");if(point>=0&&val.length-point>5){val=x.toFixed(4);}}if(x<0){return val;}return _1549?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _154a=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_154a;case "in":return val*72*_154a;case "pc":return val*12*_154a;case "mm":return val*g.mm_in_pt*_154a;case "cm":return val*g.cm_in_pt*_154a;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_154b){var ns=typeof _154b=="string"?g[_154b]:_154b;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});}}});return g;});},"dojo/nls/colors":function(){define({root:({aliceblue:"alice blue",antiquewhite:"antique white",aqua:"aqua",aquamarine:"aquamarine",azure:"azure",beige:"beige",bisque:"bisque",black:"black",blanchedalmond:"blanched almond",blue:"blue",blueviolet:"blue-violet",brown:"brown",burlywood:"burlywood",cadetblue:"cadet blue",chartreuse:"chartreuse",chocolate:"chocolate",coral:"coral",cornflowerblue:"cornflower blue",cornsilk:"cornsilk",crimson:"crimson",cyan:"cyan",darkblue:"dark blue",darkcyan:"dark cyan",darkgoldenrod:"dark goldenrod",darkgray:"dark gray",darkgreen:"dark green",darkgrey:"dark gray",darkkhaki:"dark khaki",darkmagenta:"dark magenta",darkolivegreen:"dark olive green",darkorange:"dark orange",darkorchid:"dark orchid",darkred:"dark red",darksalmon:"dark salmon",darkseagreen:"dark sea green",darkslateblue:"dark slate blue",darkslategray:"dark slate gray",darkslategrey:"dark slate gray",darkturquoise:"dark turquoise",darkviolet:"dark violet",deeppink:"deep pink",deepskyblue:"deep sky blue",dimgray:"dim gray",dimgrey:"dim gray",dodgerblue:"dodger blue",firebrick:"fire brick",floralwhite:"floral white",forestgreen:"forest green",fuchsia:"fuchsia",gainsboro:"gainsboro",ghostwhite:"ghost white",gold:"gold",goldenrod:"goldenrod",gray:"gray",green:"green",greenyellow:"green-yellow",grey:"gray",honeydew:"honeydew",hotpink:"hot pink",indianred:"indian red",indigo:"indigo",ivory:"ivory",khaki:"khaki",lavender:"lavender",lavenderblush:"lavender blush",lawngreen:"lawn green",lemonchiffon:"lemon chiffon",lightblue:"light blue",lightcoral:"light coral",lightcyan:"light cyan",lightgoldenrodyellow:"light goldenrod yellow",lightgray:"light gray",lightgreen:"light green",lightgrey:"light gray",lightpink:"light pink",lightsalmon:"light salmon",lightseagreen:"light sea green",lightskyblue:"light sky blue",lightslategray:"light slate gray",lightslategrey:"light slate gray",lightsteelblue:"light steel blue",lightyellow:"light yellow",lime:"lime",limegreen:"lime green",linen:"linen",magenta:"magenta",maroon:"maroon",mediumaquamarine:"medium aquamarine",mediumblue:"medium blue",mediumorchid:"medium orchid",mediumpurple:"medium purple",mediumseagreen:"medium sea green",mediumslateblue:"medium slate blue",mediumspringgreen:"medium spring green",mediumturquoise:"medium turquoise",mediumvioletred:"medium violet-red",midnightblue:"midnight blue",mintcream:"mint cream",mistyrose:"misty rose",moccasin:"moccasin",navajowhite:"navajo white",navy:"navy",oldlace:"old lace",olive:"olive",olivedrab:"olive drab",orange:"orange",orangered:"orange red",orchid:"orchid",palegoldenrod:"pale goldenrod",palegreen:"pale green",paleturquoise:"pale turquoise",palevioletred:"pale violet-red",papayawhip:"papaya whip",peachpuff:"peach puff",peru:"peru",pink:"pink",plum:"plum",powderblue:"powder blue",purple:"purple",red:"red",rosybrown:"rosy brown",royalblue:"royal blue",saddlebrown:"saddle brown",salmon:"salmon",sandybrown:"sandy brown",seagreen:"sea green",seashell:"seashell",sienna:"sienna",silver:"silver",skyblue:"sky blue",slateblue:"slate blue",slategray:"slate gray",slategrey:"slate gray",snow:"snow",springgreen:"spring green",steelblue:"steel blue",tan:"tan",teal:"teal",thistle:"thistle",tomato:"tomato",transparent:"transparent",turquoise:"turquoise",violet:"violet",wheat:"wheat",white:"white",whitesmoke:"white smoke",yellow:"yellow",yellowgreen:"yellow green"}),"zh":true,"zh-tw":true,"tr":true,"th":true,"sv":true,"sl":true,"sk":true,"ru":true,"ro":true,"pt":true,"pt-pt":true,"pl":true,"nl":true,"nb":true,"ko":true,"kk":true,"ja":true,"it":true,"hu":true,"he":true,"fr":true,"fi":true,"es":true,"el":true,"de":true,"da":true,"cs":true,"ca":true,"ar":true});},"dojox/charting/themes/PlotKit/purple":function(){define("dojox/charting/themes/PlotKit/purple",["./base","../../Theme"],function(pk,Theme){pk.purple=pk.base.clone();pk.purple.chart.fill=pk.purple.plotarea.fill="#eee6f5";pk.purple.colors=Theme.defineColors({hue:271,saturation:60,low:40,high:88});return pk.purple;});},"dijit/form/_CheckBoxMixin":function(){define("dijit/form/_CheckBoxMixin",["dojo/_base/declare","dojo/dom-attr","dojo/_base/event"],function(_154c,_154d,event){return _154c("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(value){this._set("readOnly",value);_154d.set(this.focusNode,"readOnly",value);this.focusNode.setAttribute("aria-readonly",value);},_setLabelAttr:undefined,postMixInProperties:function(){if(this.value==""){this.value="on";}this.inherited(arguments);},reset:function(){this.inherited(arguments);this._set("value",this.params.value||"on");_154d.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){event.stop(e);return false;}return this.inherited(arguments);}});});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(dojo,lang,_154e,_154f,dom,_1550,_1551){lang.getObject("html",true,dojo);var _1552=0;dojo.html._secureForInnerHtml=function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");};dojo.html._emptyNode=_1550.empty;dojo.html._setNodeContent=function(node,cont){_1550.empty(node);if(cont){if(typeof cont=="string"){cont=_1550.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _1553=cont.length,i=0;i<cont.length;i=_1553==cont.length?i+1:0){_1550.place(cont[i],node,"last");}}else{_1550.place(cont,node,"last");}}return node;};_154f("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:dojo._scopeName,startup:true,constructor:function(_1554,node){lang.mixin(this,_1554||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_1552++].join("_");}},set:function(cont,_1555){if(undefined!==cont){this.content=cont;}if(_1555){this._mixin(_1555);}this.onBegin();this.setContent();this.onEnd();return this.node;},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=dojo.html._setNodeContent(node,this.content);}catch(e){var _1556=this.onContentError(e);try{node.innerHTML=_1556;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseResults&&this.parseResults.length){_154e.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}dojo.html._emptyNode(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=dojo.html._secureForInnerHtml(cont);}if(this.extractContent){var match=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(match){cont=match[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.node;delete this.content;},onContentError:function(err){return "Error occured setting content: "+err;},_mixin:function(_1557){var empty={},key;for(key in _1557){if(key in empty){continue;}this[key]=_1557[key];}},_parse:function(){var _1558=this.node;try{var _1559={};_154e.forEach(["dir","lang","textDir"],function(name){if(this[name]){_1559[name]=this[name];}},this);this.parseResults=_1551.parse({rootNode:_1558,noStart:!this.startup,inherited:_1559,scope:this.parserScope});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_155a){var _155b=this["on"+type+"Error"].call(this,err);if(_155a){console.error(_155a,err);}else{if(_155b){dojo.html._setNodeContent(this.node,_155b,true);}}}});dojo.html.set=function(node,cont,_155c){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(!_155c){return dojo.html._setNodeContent(node,cont,true);}else{var op=new dojo.html._ContentSetter(lang.mixin(_155c,{content:cont,node:node}));return op.set();}};return dojo.html;});},"dojo/_base/loader":function(){define(["./kernel","../has","require","module","./json","./lang","./array"],function(dojo,has,_155d,_155e,json,lang,array){if(!1){console.error("cannot load the Dojo v1.x loader with a foreign loader");return 0;}var _155f=function(id){return {src:_155e.id,id:id};},_1560=function(name){return name.replace(/\./g,"/");},_1561=/\/\/>>built/,_1562=[],_1563=[],_1564=function(mid,_1565,_1566){_1562.push(_1566);array.forEach(mid.split(","),function(mid){var _1567=_1568(mid,_1565.module);_1563.push(_1567);_1569(_1567);});_156a();},_156a=function(){_1563=array.filter(_1563,function(_156b){return _156b.injected!==_1592&&!_156b.executed;});if(!_1563.length){_156d.holdIdle();var _156c=_1562;_1562=[];array.forEach(_156c,function(cb){cb(1);});_156d.releaseIdle();}},_156e=function(mid,_156f,_1570){_156f([mid],function(_1571){_156f(_1571.names,function(){for(var _1572="",args=[],i=0;i<arguments.length;i++){_1572+="var "+_1571.names[i]+"= arguments["+i+"]; ";args.push(arguments[i]);}eval(_1572);var _1573=_156f.module,deps=[],hold={},_1574=[],p,_1575={provide:function(_1576){_1576=_1560(_1576);var _1577=_1568(_1576,_1573);if(_1577!==_1573){_1598(_1577);}},require:function(_1578,_1579){_1578=_1560(_1578);_1579&&(_1568(_1578,_1573).result=_1593);_1574.push(_1578);},requireLocalization:function(_157a,_157b,_157c){deps.length||(deps=["dojo/i18n"]);_157c=(_157c||dojo.locale).toLowerCase();_157a=_1560(_157a)+"/nls/"+(/root/i.test(_157c)?"":_157c+"/")+_1560(_157b);if(_1568(_157a,_1573).isXd){deps.push("dojo/i18n!"+_157a);}},loadInit:function(f){f();}};try{for(p in _1575){hold[p]=dojo[p];dojo[p]=_1575[p];}_1571.def.apply(null,args);}catch(e){_1599("error",[_155f("failedDojoLoadInit"),e]);}finally{for(p in _1575){dojo[p]=hold[p];}}_1574.length&&deps.push("dojo/require!"+_1574.join(","));_1562.push(_1570);array.forEach(_1574,function(mid){var _157d=_1568(mid,_156f.module);_1563.push(_157d);_1569(_157d);});_156a();});});},_157e=function(text,_157f,_1580){var _1581=/\(|\)/g,_1582=1,match;_1581.lastIndex=_157f;while((match=_1581.exec(text))){if(match[0]==")"){_1582-=1;}else{_1582+=1;}if(_1582==0){break;}}if(_1582!=0){throw "unmatched paren around character "+_1581.lastIndex+" in: "+text;}return [dojo.trim(text.substring(_1580,_1581.lastIndex))+";\n",_1581.lastIndex];},_1583=/(\/\*([\s\S]*?)\*\/|\/\/(.*)$)/mg,_1584=/(^|\s)dojo\.(loadInit|require|provide|requireLocalization|requireIf|requireAfterIf|platformRequire)\s*\(/mg,_1585=/(^|\s)(require|define)\s*\(/m,_1586=function(text,_1587){var match,_1588,_1589,_158a,_158b=[],_158c=[],_158d=[];_1587=_1587||text.replace(_1583,function(match){_1584.lastIndex=_1585.lastIndex=0;return (_1584.test(match)||_1585.test(match))?"":match;});while((match=_1584.exec(_1587))){_1588=_1584.lastIndex;_1589=_1588-match[0].length;_158a=_157e(_1587,_1588,_1589);if(match[2]=="loadInit"){_158b.push(_158a[0]);}else{_158c.push(_158a[0]);}_1584.lastIndex=_158a[1];}_158d=_158b.concat(_158c);if(_158d.length||!_1585.test(_1587)){return [text.replace(/(^|\s)dojo\.loadInit\s*\(/g,"\n0 && dojo.loadInit("),_158d.join(""),_158d];}else{return 0;}},_158e=function(_158f,text){var _1590,id,names=[],_1591=[];if(_1561.test(text)||!(_1590=_1586(text))){return 0;}id=_158f.mid+"-*loadInit";for(var p in _1568("dojo",_158f).result.scopeMap){names.push(p);_1591.push("\""+p+"\"");}return "// xdomain rewrite of "+_158f.path+"\n"+"define('"+id+"',{\n"+"\tnames:"+dojo.toJson(names)+",\n"+"\tdef:function("+names.join(",")+"){"+_1590[1]+"}"+"});\n\n"+"define("+dojo.toJson(names.concat(["dojo/loadInit!"+id]))+", function("+names.join(",")+"){\n"+_1590[0]+"});";},_156d=_155d.initSyncLoader(_1564,_156a,_158e),sync=_156d.sync,xd=_156d.xd,_1592=_156d.arrived,_1593=_156d.nonmodule,_1594=_156d.executing,_1595=_156d.executed,_1596=_156d.syncExecStack,_1597=_156d.modules,execQ=_156d.execQ,_1568=_156d.getModule,_1569=_156d.injectModule,_1598=_156d.setArrived,_1599=_156d.signal,_159a=_156d.finishExec,_159b=_156d.execModule,_159c=_156d.getLegacyMode;dojo.provide=function(mid){var _159d=_1596[0],_159e=lang.mixin(_1568(_1560(mid),_155d.module),{executed:_1594,result:lang.getObject(mid,true)});_1598(_159e);if(_159d){(_159d.provides||(_159d.provides=[])).push(function(){_159e.result=lang.getObject(mid);delete _159e.provides;_159e.executed!==_1595&&_159a(_159e);});}return _159e.result;};has.add("config-publishRequireResult",1,0,0);dojo.require=function(_159f,_15a0){function _15a1(mid,_15a2){var _15a3=_1568(_1560(mid),_155d.module);if(_1596.length&&_1596[0].finish){_1596[0].finish.push(mid);return undefined;}if(_15a3.executed){return _15a3.result;}_15a2&&(_15a3.result=_1593);var _15a4=_159c();_1569(_15a3);_15a4=_159c();if(_15a3.executed!==_1595&&_15a3.injected===_1592){_156d.holdIdle();_159b(_15a3);_156d.releaseIdle();}if(_15a3.executed){return _15a3.result;}if(_15a4==sync){if(_15a3.cjs){execQ.unshift(_15a3);}else{_1596.length&&(_1596[0].finish=[mid]);}}else{execQ.push(_15a3);}return undefined;};var _15a5=_15a1(_159f,_15a0);if(has("config-publishRequireResult")&&!lang.exists(_159f)&&_15a5!==undefined){lang.setObject(_159f,_15a5);}return _15a5;};dojo.loadInit=function(f){f();};dojo.registerModulePath=function(_15a6,_15a7){var paths={};paths[_15a6.replace(/\./g,"/")]=_15a7;_155d({paths:paths});};dojo.platformRequire=function(_15a8){var _15a9=(_15a8.common||[]).concat(_15a8[dojo._name]||_15a8["default"]||[]),temp;while(_15a9.length){if(lang.isArray(temp=_15a9.shift())){dojo.require.apply(dojo,temp);}else{dojo.require(temp);}}};dojo.requireIf=dojo.requireAfterIf=function(_15aa,_15ab,_15ac){if(_15aa){dojo.require(_15ab,_15ac);}};dojo.requireLocalization=function(_15ad,_15ae,_15af){_155d(["../i18n"],function(i18n){i18n.getLocalization(_15ad,_15ae,_15af);});};return {extractLegacyApiApplications:_1586,require:_156d.dojoRequirePlugin,loadInit:_156e};});},"dojo/dom-style":function(){define(["./_base/sniff","./dom"],function(has,dom){var _15b0,style={};if(has("webkit")){_15b0=function(node){var s;if(node.nodeType==1){var dv=node.ownerDocument.defaultView;s=dv.getComputedStyle(node,null);if(!s&&node.style){node.style.display="";s=dv.getComputedStyle(node,null);}}return s||{};};}else{if(has("ie")&&(has("ie")<9||has("quirks"))){_15b0=function(node){return node.nodeType==1?node.currentStyle:{};};}else{_15b0=function(node){return node.nodeType==1?node.ownerDocument.defaultView.getComputedStyle(node,null):{};};}}style.getComputedStyle=_15b0;var _15b1;if(!has("ie")){_15b1=function(_15b2,value){return parseFloat(value)||0;};}else{_15b1=function(_15b3,_15b4){if(!_15b4){return 0;}if(_15b4=="medium"){return 4;}if(_15b4.slice&&_15b4.slice(-2)=="px"){return parseFloat(_15b4);}var s=_15b3.style,rs=_15b3.runtimeStyle,cs=_15b3.currentStyle,sLeft=s.left,_15b5=rs.left;rs.left=cs.left;try{s.left=_15b4;_15b4=s.pixelLeft;}catch(e){_15b4=0;}s.left=sLeft;rs.left=_15b5;return _15b4;};}style.toPixelValue=_15b1;var astr="DXImageTransform.Microsoft.Alpha";var af=function(n,f){try{return n.filters.item(astr);}catch(e){return f?{}:null;}};var _15b6=has("ie")<9||(has("ie")&&has("quirks"))?function(node){try{return af(node).Opacity/100;}catch(e){return 1;}}:function(node){return _15b0(node).opacity;};var _15b7=has("ie")<9||(has("ie")&&has("quirks"))?function(node,_15b8){var ov=_15b8*100,_15b9=_15b8==1;node.style.zoom=_15b9?"":1;if(!af(node)){if(_15b9){return _15b8;}node.style.filter+=" progid:"+astr+"(Opacity="+ov+")";}else{af(node,1).Opacity=ov;}af(node,1).Enabled=!_15b9;if(node.tagName.toLowerCase()=="tr"){for(var td=node.firstChild;td;td=td.nextSibling){if(td.tagName.toLowerCase()=="td"){_15b7(td,_15b8);}}}return _15b8;}:function(node,_15ba){return node.style.opacity=_15ba;};var _15bb={left:true,top:true};var _15bc=/margin|padding|width|height|max|min|offset/;function _15bd(node,type,value){type=type.toLowerCase();if(has("ie")){if(value=="auto"){if(type=="height"){return node.offsetHeight;}if(type=="width"){return node.offsetWidth;}}if(type=="fontweight"){switch(value){case 700:return "bold";case 400:default:return "normal";}}}if(!(type in _15bb)){_15bb[type]=_15bc.test(type);}return _15bb[type]?_15b1(node,value):value;};var _15be=has("ie")?"styleFloat":"cssFloat",_15bf={"cssFloat":_15be,"styleFloat":_15be,"float":_15be};style.get=function getStyle(node,name){var n=dom.byId(node),l=arguments.length,op=(name=="opacity");if(l==2&&op){return _15b6(n);}name=_15bf[name]||name;var s=style.getComputedStyle(n);return (l==1)?s:_15bd(n,name,s[name]||n.style[name]);};style.set=function setStyle(node,name,value){var n=dom.byId(node),l=arguments.length,op=(name=="opacity");name=_15bf[name]||name;if(l==3){return op?_15b7(n,value):n.style[name]=value;}for(var x in name){style.set(node,x,name[x]);}return style.getComputedStyle(n);};return style;});},"dojo/Stateful":function(){define(["./_base/kernel","./_base/declare","./_base/lang","./_base/array"],function(dojo,_15c0,lang,array){return dojo.declare("dojo.Stateful",null,{postscript:function(mixin){if(mixin){lang.mixin(this,mixin);}},get:function(name){return this[name];},set:function(name,value){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _15c1=this[name];this[name]=value;if(this._watchCallbacks){this._watchCallbacks(name,_15c1,value);}return this;},watch:function(name,_15c2){var _15c3=this._watchCallbacks;if(!_15c3){var self=this;_15c3=this._watchCallbacks=function(name,_15c4,value,_15c5){var _15c6=function(_15c7){if(_15c7){_15c7=_15c7.slice();for(var i=0,l=_15c7.length;i<l;i++){try{_15c7[i].call(self,name,_15c4,value);}catch(e){console.error(e);}}}};_15c6(_15c3["_"+name]);if(!_15c5){_15c6(_15c3["*"]);}};}if(!_15c2&&typeof name==="function"){_15c2=name;name="*";}else{name="_"+name;}var _15c8=_15c3[name];if(typeof _15c8!=="object"){_15c8=_15c3[name]=[];}_15c8.push(_15c2);return {unwatch:function(){_15c8.splice(array.indexOf(_15c8,_15c2),1);}};}});});},"dojox/gfx/svg":function(){define("dojox/gfx/svg",["dojo/_base/lang","dojo/_base/window","dojo/dom","dojo/_base/declare","dojo/_base/array","dojo/dom-geometry","dojo/_base/Color","./_base","./shape","./path"],function(lang,win,dom,_15c9,arr,_15ca,Color,g,gs,_15cb){var svg=g.svg={};svg.useSvgWeb=(typeof window.svgweb!="undefined");var _15cc=navigator.userAgent.toLowerCase(),_15cd=_15cc.search("iphone")>-1||_15cc.search("ipad")>-1||_15cc.search("ipod")>-1;function _15ce(ns,_15cf){if(win.doc.createElementNS){return win.doc.createElementNS(ns,_15cf);}else{return win.doc.createElement(_15cf);}};function _15d0(text){if(svg.useSvgWeb){return win.doc.createTextNode(text,true);}else{return win.doc.createTextNode(text);}};function _15d1(){if(svg.useSvgWeb){return win.doc.createDocumentFragment(true);}else{return win.doc.createDocumentFragment();}};svg.xmlns={xlink:"http://www.w3.org/1999/xlink",svg:"http://www.w3.org/2000/svg"};svg.getRef=function(name){if(!name||name=="none"){return null;}if(name.match(/^url\(#.+\)$/)){return dom.byId(name.slice(5,-1));}if(name.match(/^#dojoUnique\d+$/)){return dom.byId(name.slice(1));}return null;};svg.dasharray={solid:"none",shortdash:[4,1],shortdot:[1,1],shortdashdot:[4,1,1,1],shortdashdotdot:[4,1,1,1,1,1],dot:[1,3],dash:[4,3],longdash:[8,3],dashdot:[4,3,1,3],longdashdot:[8,3,1,3],longdashdotdot:[8,3,1,3,1,3]};_15c9("dojox.gfx.svg.Shape",gs.Shape,{setFill:function(fill){if(!fill){this.fillStyle=null;this.rawNode.setAttribute("fill","none");this.rawNode.setAttribute("fill-opacity",0);return this;}var f;var _15d2=function(x){this.setAttribute(x,f[x].toFixed(8));};if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);var _15d3=this._setFillObject(f,"linearGradient");arr.forEach(["x1","y1","x2","y2"],_15d2,_15d3);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);var grad=this._setFillObject(f,"radialGradient");arr.forEach(["cx","cy","r"],_15d2,grad);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);var _15d4=this._setFillObject(f,"pattern");arr.forEach(["x","y","width","height"],_15d2,_15d4);break;}this.fillStyle=f;return this;}f=g.normalizeColor(fill);this.fillStyle=f;this.rawNode.setAttribute("fill",f.toCss());this.rawNode.setAttribute("fill-opacity",f.a);this.rawNode.setAttribute("fill-rule","evenodd");return this;},setStroke:function(_15d5){var rn=this.rawNode;if(!_15d5){this.strokeStyle=null;rn.setAttribute("stroke","none");rn.setAttribute("stroke-opacity",0);return this;}if(typeof _15d5=="string"||lang.isArray(_15d5)||_15d5 instanceof Color){_15d5={color:_15d5};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_15d5);s.color=g.normalizeColor(s.color);if(s){rn.setAttribute("stroke",s.color.toCss());rn.setAttribute("stroke-opacity",s.color.a);rn.setAttribute("stroke-width",s.width);rn.setAttribute("stroke-linecap",s.cap);if(typeof s.join=="number"){rn.setAttribute("stroke-linejoin","miter");rn.setAttribute("stroke-miterlimit",s.join);}else{rn.setAttribute("stroke-linejoin",s.join);}var da=s.style.toLowerCase();if(da in svg.dasharray){da=svg.dasharray[da];}if(da instanceof Array){da=lang._toArray(da);for(var i=0;i<da.length;++i){da[i]*=s.width;}if(s.cap!="butt"){for(var i=0;i<da.length;i+=2){da[i]-=s.width;if(da[i]<1){da[i]=1;}}for(var i=1;i<da.length;i+=2){da[i]+=s.width;}}da=da.join(",");}rn.setAttribute("stroke-dasharray",da);rn.setAttribute("dojoGfxStrokeStyle",s.style);}return this;},_getParentSurface:function(){var _15d6=this.parent;for(;_15d6&&!(_15d6 instanceof g.Surface);_15d6=_15d6.parent){}return _15d6;},_setFillObject:function(f,_15d7){var svgns=svg.xmlns.svg;this.fillStyle=f;var _15d8=this._getParentSurface(),defs=_15d8.defNode,fill=this.rawNode.getAttribute("fill"),ref=svg.getRef(fill);if(ref){fill=ref;if(fill.tagName.toLowerCase()!=_15d7.toLowerCase()){var id=fill.id;fill.parentNode.removeChild(fill);fill=_15ce(svgns,_15d7);fill.setAttribute("id",id);defs.appendChild(fill);}else{while(fill.childNodes.length){fill.removeChild(fill.lastChild);}}}else{fill=_15ce(svgns,_15d7);fill.setAttribute("id",g._base._getUniqueId());defs.appendChild(fill);}if(_15d7=="pattern"){fill.setAttribute("patternUnits","userSpaceOnUse");var img=_15ce(svgns,"image");img.setAttribute("x",0);img.setAttribute("y",0);img.setAttribute("width",f.width.toFixed(8));img.setAttribute("height",f.height.toFixed(8));img.setAttributeNS(svg.xmlns.xlink,"xlink:href",f.src);fill.appendChild(img);}else{fill.setAttribute("gradientUnits","userSpaceOnUse");for(var i=0;i<f.colors.length;++i){var c=f.colors[i],t=_15ce(svgns,"stop"),cc=c.color=g.normalizeColor(c.color);t.setAttribute("offset",c.offset.toFixed(8));t.setAttribute("stop-color",cc.toCss());t.setAttribute("stop-opacity",cc.a);fill.appendChild(t);}}this.rawNode.setAttribute("fill","url(#"+fill.getAttribute("id")+")");this.rawNode.removeAttribute("fill-opacity");this.rawNode.setAttribute("fill-rule","evenodd");return fill;},_applyTransform:function(){var _15d9=this.matrix;if(_15d9){var tm=this.matrix;this.rawNode.setAttribute("transform","matrix("+tm.xx.toFixed(8)+","+tm.yx.toFixed(8)+","+tm.xy.toFixed(8)+","+tm.yy.toFixed(8)+","+tm.dx.toFixed(8)+","+tm.dy.toFixed(8)+")");}else{this.rawNode.removeAttribute("transform");}return this;},setRawNode:function(_15da){var r=this.rawNode=_15da;if(this.shape.type!="image"){r.setAttribute("fill","none");}r.setAttribute("fill-opacity",0);r.setAttribute("stroke","none");r.setAttribute("stroke-opacity",0);r.setAttribute("stroke-width",1);r.setAttribute("stroke-linecap","butt");r.setAttribute("stroke-linejoin","miter");r.setAttribute("stroke-miterlimit",4);r.__gfxObject__=this.getUID();},setShape:function(_15db){this.shape=g.makeParameters(this.shape,_15db);for(var i in this.shape){if(i!="type"){this.rawNode.setAttribute(i,this.shape[i]);}}this.bbox=null;return this;},_moveToFront:function(){this.rawNode.parentNode.appendChild(this.rawNode);return this;},_moveToBack:function(){this.rawNode.parentNode.insertBefore(this.rawNode,this.rawNode.parentNode.firstChild);return this;}});_15c9("dojox.gfx.svg.Group",svg.Shape,{constructor:function(){gs.Container._init.call(this);},setRawNode:function(_15dc){this.rawNode=_15dc;this.rawNode.__gfxObject__=this.getUID();}});svg.Group.nodeType="g";_15c9("dojox.gfx.svg.Rect",[svg.Shape,gs.Rect],{setShape:function(_15dd){this.shape=g.makeParameters(this.shape,_15dd);this.bbox=null;for(var i in this.shape){if(i!="type"&&i!="r"){this.rawNode.setAttribute(i,this.shape[i]);}}if(this.shape.r!=null){this.rawNode.setAttribute("ry",this.shape.r);this.rawNode.setAttribute("rx",this.shape.r);}return this;}});svg.Rect.nodeType="rect";_15c9("dojox.gfx.svg.Ellipse",[svg.Shape,gs.Ellipse],{});svg.Ellipse.nodeType="ellipse";_15c9("dojox.gfx.svg.Circle",[svg.Shape,gs.Circle],{});svg.Circle.nodeType="circle";_15c9("dojox.gfx.svg.Line",[svg.Shape,gs.Line],{});svg.Line.nodeType="line";_15c9("dojox.gfx.svg.Polyline",[svg.Shape,gs.Polyline],{setShape:function(_15de,_15df){if(_15de&&_15de instanceof Array){this.shape=g.makeParameters(this.shape,{points:_15de});if(_15df&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.shape=g.makeParameters(this.shape,_15de);}this.bbox=null;this._normalizePoints();var attr=[],p=this.shape.points;for(var i=0;i<p.length;++i){attr.push(p[i].x.toFixed(8),p[i].y.toFixed(8));}this.rawNode.setAttribute("points",attr.join(" "));return this;}});svg.Polyline.nodeType="polyline";_15c9("dojox.gfx.svg.Image",[svg.Shape,gs.Image],{setShape:function(_15e0){this.shape=g.makeParameters(this.shape,_15e0);this.bbox=null;var _15e1=this.rawNode;for(var i in this.shape){if(i!="type"&&i!="src"){_15e1.setAttribute(i,this.shape[i]);}}_15e1.setAttribute("preserveAspectRatio","none");_15e1.setAttributeNS(svg.xmlns.xlink,"xlink:href",this.shape.src);_15e1.__gfxObject__=this.getUID();return this;}});svg.Image.nodeType="image";_15c9("dojox.gfx.svg.Text",[svg.Shape,gs.Text],{setShape:function(_15e2){this.shape=g.makeParameters(this.shape,_15e2);this.bbox=null;var r=this.rawNode,s=this.shape;r.setAttribute("x",s.x);r.setAttribute("y",s.y);r.setAttribute("text-anchor",s.align);r.setAttribute("text-decoration",s.decoration);r.setAttribute("rotate",s.rotated?90:0);r.setAttribute("kerning",s.kerning?"auto":0);r.setAttribute("text-rendering","optimizeLegibility");if(r.firstChild){r.firstChild.nodeValue=s.text;}else{r.appendChild(_15d0(s.text));}return this;},getTextWidth:function(){var _15e3=this.rawNode,_15e4=_15e3.parentNode,_15e5=_15e3.cloneNode(true);_15e5.style.visibility="hidden";var _15e6=0,_15e7=_15e5.firstChild.nodeValue;_15e4.appendChild(_15e5);if(_15e7!=""){while(!_15e6){if(_15e5.getBBox){_15e6=parseInt(_15e5.getBBox().width);}else{_15e6=68;}}}_15e4.removeChild(_15e5);return _15e6;}});svg.Text.nodeType="text";_15c9("dojox.gfx.svg.Path",[svg.Shape,_15cb.Path],{_updateWithSegment:function(_15e8){this.inherited(arguments);if(typeof (this.shape.path)=="string"){this.rawNode.setAttribute("d",this.shape.path);}},setShape:function(_15e9){this.inherited(arguments);if(this.shape.path){this.rawNode.setAttribute("d",this.shape.path);}else{this.rawNode.removeAttribute("d");}return this;}});svg.Path.nodeType="path";_15c9("dojox.gfx.svg.TextPath",[svg.Shape,_15cb.TextPath],{_updateWithSegment:function(_15ea){this.inherited(arguments);this._setTextPath();},setShape:function(_15eb){this.inherited(arguments);this._setTextPath();return this;},_setTextPath:function(){if(typeof this.shape.path!="string"){return;}var r=this.rawNode;if(!r.firstChild){var tp=_15ce(svg.xmlns.svg,"textPath"),tx=_15d0("");tp.appendChild(tx);r.appendChild(tp);}var ref=r.firstChild.getAttributeNS(svg.xmlns.xlink,"href"),path=ref&&svg.getRef(ref);if(!path){var _15ec=this._getParentSurface();if(_15ec){var defs=_15ec.defNode;path=_15ce(svg.xmlns.svg,"path");var id=g._base._getUniqueId();path.setAttribute("id",id);defs.appendChild(path);r.firstChild.setAttributeNS(svg.xmlns.xlink,"xlink:href","#"+id);}}if(path){path.setAttribute("d",this.shape.path);}},_setText:function(){var r=this.rawNode;if(!r.firstChild){var tp=_15ce(svg.xmlns.svg,"textPath"),tx=_15d0("");tp.appendChild(tx);r.appendChild(tp);}r=r.firstChild;var t=this.text;r.setAttribute("alignment-baseline","middle");switch(t.align){case "middle":r.setAttribute("text-anchor","middle");r.setAttribute("startOffset","50%");break;case "end":r.setAttribute("text-anchor","end");r.setAttribute("startOffset","100%");break;default:r.setAttribute("text-anchor","start");r.setAttribute("startOffset","0%");break;}r.setAttribute("baseline-shift","0.5ex");r.setAttribute("text-decoration",t.decoration);r.setAttribute("rotate",t.rotated?90:0);r.setAttribute("kerning",t.kerning?"auto":0);r.firstChild.data=t.text;}});svg.TextPath.nodeType="text";_15c9("dojox.gfx.svg.Surface",gs.Surface,{constructor:function(){gs.Container._init.call(this);},destroy:function(){this.defNode=null;this.inherited(arguments);},setDimensions:function(width,_15ed){if(!this.rawNode){return this;}this.rawNode.setAttribute("width",width);this.rawNode.setAttribute("height",_15ed);return this;},getDimensions:function(){var t=this.rawNode?{width:g.normalizedLength(this.rawNode.getAttribute("width")),height:g.normalizedLength(this.rawNode.getAttribute("height"))}:null;return t;}});svg.createSurface=function(_15ee,width,_15ef){var s=new svg.Surface();s.rawNode=_15ce(svg.xmlns.svg,"svg");s.rawNode.setAttribute("overflow","hidden");if(width){s.rawNode.setAttribute("width",width);}if(_15ef){s.rawNode.setAttribute("height",_15ef);}var _15f0=_15ce(svg.xmlns.svg,"defs");s.rawNode.appendChild(_15f0);s.defNode=_15f0;s._parent=dom.byId(_15ee);s._parent.appendChild(s.rawNode);return s;};var Font={_setFont:function(){var f=this.fontStyle;this.rawNode.setAttribute("font-style",f.style);this.rawNode.setAttribute("font-variant",f.variant);this.rawNode.setAttribute("font-weight",f.weight);this.rawNode.setAttribute("font-size",f.size);this.rawNode.setAttribute("font-family",f.family);}};var C=gs.Container,_15f1={openBatch:function(){this.fragment=_15d1();},closeBatch:function(){if(this.fragment){this.rawNode.appendChild(this.fragment);delete this.fragment;}},add:function(shape){if(this!=shape.getParent()){if(this.fragment){this.fragment.appendChild(shape.rawNode);}else{this.rawNode.appendChild(shape.rawNode);}C.add.apply(this,arguments);}return this;},remove:function(shape,_15f2){if(this==shape.getParent()){if(this.rawNode==shape.rawNode.parentNode){this.rawNode.removeChild(shape.rawNode);}if(this.fragment&&this.fragment==shape.rawNode.parentNode){this.fragment.removeChild(shape.rawNode);}C.remove.apply(this,arguments);}return this;},clear:function(){var r=this.rawNode;while(r.lastChild){r.removeChild(r.lastChild);}var _15f3=this.defNode;if(_15f3){while(_15f3.lastChild){_15f3.removeChild(_15f3.lastChild);}r.appendChild(_15f3);}return C.clear.apply(this,arguments);},_moveChildToFront:C._moveChildToFront,_moveChildToBack:C._moveChildToBack};var _15f4={createObject:function(_15f5,_15f6){if(!this.rawNode){return null;}var shape=new _15f5(),node=_15ce(svg.xmlns.svg,_15f5.nodeType);shape.setRawNode(node);shape.setShape(_15f6);this.add(shape);return shape;}};lang.extend(svg.Text,Font);lang.extend(svg.TextPath,Font);lang.extend(svg.Group,_15f1);lang.extend(svg.Group,gs.Creator);lang.extend(svg.Group,_15f4);lang.extend(svg.Surface,_15f1);lang.extend(svg.Surface,gs.Creator);lang.extend(svg.Surface,_15f4);svg.fixTarget=function(event,_15f7){if(!event.gfxTarget){if(_15cd&&event.target.wholeText){event.gfxTarget=gs.byId(event.target.parentElement.__gfxObject__);}else{event.gfxTarget=gs.byId(event.target.__gfxObject__);}}return true;};if(svg.useSvgWeb){svg.createSurface=function(_15f8,width,_15f9){var s=new svg.Surface();if(!width||!_15f9){var pos=_15ca.position(_15f8);width=width||pos.w;_15f9=_15f9||pos.h;}_15f8=dom.byId(_15f8);var id=_15f8.id?_15f8.id+"_svgweb":g._base._getUniqueId();var _15fa=_15ce(svg.xmlns.svg,"svg");_15fa.id=id;_15fa.setAttribute("width",width);_15fa.setAttribute("height",_15f9);svgweb.appendChild(_15fa,_15f8);_15fa.addEventListener("SVGLoad",function(){s.rawNode=this;s.isLoaded=true;var _15fb=_15ce(svg.xmlns.svg,"defs");s.rawNode.appendChild(_15fb);s.defNode=_15fb;if(s.onLoad){s.onLoad(s);}},false);s.isLoaded=false;return s;};svg.Surface.extend({destroy:function(){var _15fc=this.rawNode;svgweb.removeChild(_15fc,_15fc.parentNode);}});var _15fd={connect:function(name,_15fe,_15ff){if(name.substring(0,2)==="on"){name=name.substring(2);}if(arguments.length==2){_15ff=_15fe;}else{_15ff=lang.hitch(_15fe,_15ff);}this.getEventSource().addEventListener(name,_15ff,false);return [this,name,_15ff];},disconnect:function(token){this.getEventSource().removeEventListener(token[1],token[2],false);delete token[0];}};lang.extend(svg.Shape,_15fd);lang.extend(svg.Surface,_15fd);}return svg;});},"dijit/layout/LayoutContainer":function(){define("dijit/layout/LayoutContainer",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","../_WidgetBase","./_LayoutWidget","./utils"],function(_1600,lang,_1601,_1602,_1603,_1604){lang.extend(_1602,{layoutAlign:"none"});return _1601("dijit.layout.LayoutContainer",_1603,{baseClass:"dijitLayoutContainer",constructor:function(){_1600.deprecated("dijit.layout.LayoutContainer is deprecated","use BorderContainer instead",2);},layout:function(){_1604.layoutChildren(this.domNode,this._contentBox,this.getChildren());},addChild:function(child,_1605){this.inherited(arguments);if(this._started){_1604.layoutChildren(this.domNode,this._contentBox,this.getChildren());}},removeChild:function(_1606){this.inherited(arguments);if(this._started){_1604.layoutChildren(this.domNode,this._contentBox,this.getChildren());}}});});},"dojox/charting/action2d/PlotAction":function(){define("dojox/charting/action2d/PlotAction",["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional","dojox/lang/functional/object"],function(hub,_1607,Base,dfe,df,dlfo){var _1608=400,_1609=dfe.backOut;return _1607("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(chart,plot,_160a){this.anim={};if(!_160a){_160a={};}this.duration=_160a.duration?_160a.duration:_1608;this.easing=_160a.easing?_160a.easing:_1609;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojo/dnd/autoscroll":function(){define(["../main","../window"],function(dojo){dojo.getObject("dnd",true,dojo);dojo.dnd.getViewport=dojo.window.getBox;dojo.dnd.V_TRIGGER_AUTOSCROLL=32;dojo.dnd.H_TRIGGER_AUTOSCROLL=32;dojo.dnd.V_AUTOSCROLL_VALUE=16;dojo.dnd.H_AUTOSCROLL_VALUE=16;dojo.dnd.autoScroll=function(e){var v=dojo.window.getBox(),dx=0,dy=0;if(e.clientX<dojo.dnd.H_TRIGGER_AUTOSCROLL){dx=-dojo.dnd.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-dojo.dnd.H_TRIGGER_AUTOSCROLL){dx=dojo.dnd.H_AUTOSCROLL_VALUE;}}if(e.clientY<dojo.dnd.V_TRIGGER_AUTOSCROLL){dy=-dojo.dnd.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-dojo.dnd.V_TRIGGER_AUTOSCROLL){dy=dojo.dnd.V_AUTOSCROLL_VALUE;}}window.scrollBy(dx,dy);};dojo.dnd._validNodes={"div":1,"p":1,"td":1};dojo.dnd._validOverflow={"auto":1,"scroll":1};dojo.dnd.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_160b,_160c;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in dojo.dnd._validNodes)){var s=dojo.getComputedStyle(n),_160d=(s.overflow.toLowerCase() in dojo.dnd._validOverflow),_160e=(s.overflowX.toLowerCase() in dojo.dnd._validOverflow),_160f=(s.overflowY.toLowerCase() in dojo.dnd._validOverflow);if(_160d||_160e||_160f){b=dojo._getContentBox(n,s);t=dojo.position(n,true);}if(_160d||_160e){w=Math.min(dojo.dnd.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(dojo.isWebKit||dojo.isOpera){rx+=dojo.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_160b=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_160d||_160f){h=Math.min(dojo.dnd.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(dojo.isWebKit||dojo.isOpera){ry+=dojo.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_160c=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}dojo.dnd.autoScroll(e);};return dojo.dnd;});},"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","dojox/charting/plot2d/_PlotEvents":function(){define("dojox/charting/plot2d/_PlotEvents",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(lang,arr,_1610,hub){return _1610("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=lang.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";arr.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_1611,_1612){this.dirty=true;return hub.connect(this,"plotEvent",_1611,_1612);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){arr.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_1613){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_1613,this,function(e){o.type=_1613;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_1614){var a=this._eventSeries[_1614];if(a){arr.forEach(a,this._connectEvents,this);}},fireEvent:function(_1615,_1616,index,_1617){var s=this._eventSeries[_1615];if(s&&s.length&&index<s.length){var o=s[index];o.type=_1616;o.event=_1617||null;this.raiseEvent(o);o.event=null;}}});});},"dojox/grid/cells":function(){define("dojox/grid/cells",["../main","./cells/_base"],function(dojox){return dojox.grid.cells;});},"dijit/layout/utils":function(){define("dijit/layout/utils",["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang",".."],function(array,_1618,_1619,_161a,lang,dijit){var _161b=lang.getObject("layout",true,dijit);_161b.marginBox2contentBox=function(node,mb){var cs=_161a.getComputedStyle(node);var me=_1619.getMarginExtents(node,cs);var pb=_1619.getPadBorderExtents(node,cs);return {l:_161a.toPixelValue(node,cs.paddingLeft),t:_161a.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};};function _161c(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_161d,dim){var _161e=_161d.resize?_161d.resize(dim):_1619.setMarginBox(_161d.domNode,dim);if(_161e){lang.mixin(_161d,_161e);}else{lang.mixin(_161d,_1619.getMarginBox(_161d.domNode));lang.mixin(_161d,dim);}};_161b.layoutChildren=function(_161f,dim,_1620,_1621,_1622){dim=lang.mixin({},dim);_1618.add(_161f,"dijitLayoutContainer");_1620=array.filter(_1620,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(array.filter(_1620,function(item){return item.region=="center"||item.layoutAlign=="client";}));array.forEach(_1620,function(child){var elm=child.domNode,pos=(child.region||child.layoutAlign);if(!pos){throw new Error("No region setting for "+child.id);}var _1623=elm.style;_1623.left=dim.l+"px";_1623.top=dim.t+"px";_1623.position="absolute";_1618.add(elm,"dijitAlign"+_161c(pos));var _1624={};if(_1621&&_1621==child.id){_1624[child.region=="top"||child.region=="bottom"?"h":"w"]=_1622;}if(pos=="top"||pos=="bottom"){_1624.w=dim.w;size(child,_1624);dim.h-=child.h;if(pos=="top"){dim.t+=child.h;}else{_1623.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_1624.h=dim.h;size(child,_1624);dim.w-=child.w;if(pos=="left"){dim.l+=child.w;}else{_1623.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(child,dim);}}}});};return {marginBox2contentBox:_161b.marginBox2contentBox,layoutChildren:_161b.layoutChildren};});},"dijit/ProgressBar":function(){require({cache:{"url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><img data-dojo-attach-point=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\n/></div>\n"}});define("dijit/ProgressBar",["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_1625,_1626,_1627,lang,_1628,_1629,_162a,_162b){return _1626("dijit.ProgressBar",[_1629,_162a],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_162b,_indeterminateHighContrastImagePath:_1625.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!("value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},update:function(_162c){lang.mixin(this,_162c||{});var tip=this.internalProgress,ap=this.domNode;var _162d=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");ap.removeAttribute("aria-valuemin");ap.removeAttribute("aria-valuemax");}else{if(String(this.progress).indexOf("%")!=-1){_162d=Math.min(parseFloat(this.progress)/100,1);this.progress=_162d*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_162d=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-describedby",this.labelNode.id);ap.setAttribute("aria-valuenow",this.progress);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);}this.labelNode.innerHTML=this.report(_162d);_1627.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);tip.style.width=(_162d*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(label){this._set("label",label);this.update();},_setIndeterminateAttr:function(_162e){this.indeterminate=_162e;this.update();},report:function(_162f){return this.label?this.label:(this.indeterminate?"&#160;":_1628.format(_162f,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dojo/cldr/nls/currency":function(){define({root:{"USD_symbol":"US$","CAD_symbol":"CA$","GBP_symbol":"£","HKD_symbol":"HK$","JPY_symbol":"JP¥","AUD_symbol":"AU$","CNY_symbol":"CN¥","EUR_symbol":"€"},"ar":true,"ca":true,"cs":true,"da":true,"de":true,"el":true,"en":true,"en-au":true,"en-ca":true,"es":true,"fi":true,"fr":true,"he":true,"hu":true,"it":true,"ja":true,"ko":true,"nb":true,"nl":true,"pl":true,"pt":true,"ro":true,"ru":true,"sk":true,"sl":true,"sv":true,"th":true,"tr":true,"zh":true,"zh-hant":true,"zh-hk":true,"zh-tw":true});},"dojo/has":function(){define(["require"],function(_1630){var has=_1630.has||function(){};if(!1){var _1631=typeof window!="undefined"&&typeof location!="undefined"&&typeof document!="undefined"&&window.location==location&&window.document==document,_1632=this,doc=_1631&&document,_1633=doc&&doc.createElement("DiV"),cache={};has=function(name){return cache[name]=typeof cache[name]=="function"?cache[name](_1632,doc,_1633):cache[name];};has.cache=cache;has.add=function(name,test,now,force){(typeof cache[name]=="undefined"||force)&&(cache[name]=test);return now&&has(name);};true||has.add("host-browser",_1631);true||has.add("dom",_1631);true||has.add("dojo-dom-ready-api",1);true||has.add("dojo-sniff",1);}if(1){var agent=navigator.userAgent;has.add("dom-addeventlistener",!!document.addEventListener);has.add("touch","ontouchstart" in document);has.add("device-width",screen.availWidth||innerWidth);has.add("agent-ios",!!agent.match(/iPhone|iP[ao]d/));has.add("agent-android",agent.indexOf("android")>1);}has.clearElement=function(_1634){_1634.innerHTML="";return _1634;};has.normalize=function(id,_1635){var _1636=id.match(/[\?:]|[^:\?]*/g),i=0,get=function(skip){var term=_1636[i++];if(term==":"){return 0;}else{if(_1636[i++]=="?"){if(!skip&&has(term)){return get();}else{get(true);return get(skip);}}return term||0;}};id=get();return id&&_1635(id);};has.load=function(id,_1637,_1638){if(id){_1637([id],_1638);}else{_1638();}};return has;});},"dojox/gfx/gradient":function(){define("dojox/gfx/gradient",["dojo/_base/lang","./matrix","dojo/_base/Color"],function(lang,m,Color){var grad=lang.getObject("dojox.gfx.gradient",true);var C=Color;grad.rescale=function(stops,from,to){var len=stops.length,_1639=(to<from),_163a;if(_1639){var tmp=from;from=to;to=tmp;}if(!len){return [];}if(to<=stops[0].offset){_163a=[{offset:0,color:stops[0].color},{offset:1,color:stops[0].color}];}else{if(from>=stops[len-1].offset){_163a=[{offset:0,color:stops[len-1].color},{offset:1,color:stops[len-1].color}];}else{var span=to-from,stop,prev,i;_163a=[];if(from<0){_163a.push({offset:0,color:new C(stops[0].color)});}for(i=0;i<len;++i){stop=stops[i];if(stop.offset>=from){break;}}if(i){prev=stops[i-1];_163a.push({offset:0,color:Color.blendColors(new C(prev.color),new C(stop.color),(from-prev.offset)/(stop.offset-prev.offset))});}else{_163a.push({offset:0,color:new C(stop.color)});}for(;i<len;++i){stop=stops[i];if(stop.offset>=to){break;}_163a.push({offset:(stop.offset-from)/span,color:new C(stop.color)});}if(i<len){prev=stops[i-1];_163a.push({offset:1,color:Color.blendColors(new C(prev.color),new C(stop.color),(to-prev.offset)/(stop.offset-prev.offset))});}else{_163a.push({offset:1,color:new C(stops[len-1].color)});}}}if(_1639){_163a.reverse();for(i=0,len=_163a.length;i<len;++i){stop=_163a[i];stop.offset=1-stop.offset;}}return _163a;};function _163b(x,y,_163c,_163d,_163e,scale){var r=m.multiplyPoint(_163c,x,y),p=m.multiplyPoint(_163d,r);return {r:r,p:p,o:m.multiplyPoint(_163e,p).x/scale};};function _163f(a,b){return a.o-b.o;};grad.project=function(_1640,_1641,tl,rb,ttl,trb){_1640=_1640||m.identity;var f1=m.multiplyPoint(_1640,_1641.x1,_1641.y1),f2=m.multiplyPoint(_1640,_1641.x2,_1641.y2),angle=Math.atan2(f2.y-f1.y,f2.x-f1.x),_1642=m.project(f2.x-f1.x,f2.y-f1.y),pf1=m.multiplyPoint(_1642,f1),pf2=m.multiplyPoint(_1642,f2),_1643=new m.Matrix2D([m.rotate(-angle),{dx:-pf1.x,dy:-pf1.y}]),scale=m.multiplyPoint(_1643,pf2).x,_1644=[_163b(tl.x,tl.y,_1640,_1642,_1643,scale),_163b(rb.x,rb.y,_1640,_1642,_1643,scale),_163b(tl.x,rb.y,_1640,_1642,_1643,scale),_163b(rb.x,tl.y,_1640,_1642,_1643,scale)].sort(_163f),from=_1644[0].o,to=_1644[3].o,stops=grad.rescale(_1641.colors,from,to),_1645=Math.atan2(_1644[3].r.y-_1644[0].r.y,_1644[3].r.x-_1644[0].r.x);return {type:"linear",x1:_1644[0].p.x,y1:_1644[0].p.y,x2:_1644[3].p.x,y2:_1644[3].p.y,colors:stops,angle:angle};};return grad;});},"dijit/_PaletteMixin":function(){define("dijit/_PaletteMixin",["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/keys","dojo/_base/lang","./_CssStateMixin","./focus","./typematic"],function(_1646,_1647,_1648,_1649,event,keys,lang,_164a,focus,_164b){return _1646("dijit._PaletteMixin",[_164a],{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:"",summary:"",_setSummaryAttr:"paletteTableNode",_dyeFactory:function(value){var _164c=lang.getObject(this.dyeClass);return new _164c(value);},_preparePalette:function(_164d,_164e){this._cells=[];var url=this._blankGif;this.connect(this.gridNode,"ondijitclick","_onCellClick");for(var row=0;row<_164d.length;row++){var _164f=_1649.create("tr",{tabIndex:"-1"},this.gridNode);for(var col=0;col<_164d[row].length;col++){var value=_164d[row][col];if(value){var _1650=this._dyeFactory(value,row,col);var _1651=_1649.create("td",{"class":this.cellClass,tabIndex:"-1",title:_164e[value],role:"gridcell"});_1650.fillCell(_1651,url);_1649.place(_1651,_164f);_1651.index=this._cells.length;this._cells.push({node:_1651,dye:_1650});}}}this._xDim=_164d[0].length;this._yDim=_164d.length;var _1652={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _1652){this._connects.push(_164b.addKeyListener(this.domNode,{charOrCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _1653=_1652[key];return function(count){this._navigateByKey(_1653,count);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){focus.focus(this._currentFocus);},_onCellClick:function(evt){var _1654=evt.target;while(_1654.tagName!="TD"){if(!_1654.parentNode||_1654==this.gridNode){return;}_1654=_1654.parentNode;}var value=this._getDye(_1654).getValue();this._setCurrent(_1654);focus.focus(_1654);this._setValueAttr(value,true);event.stop(evt);},_setCurrent:function(node){if("_currentFocus" in this){_1647.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_1647.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(value,_1655){if(this._selectedCell>=0){_1648.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(value){for(var i=0;i<this._cells.length;i++){if(value==this._cells[i].dye.getValue()){this._selectedCell=i;_1648.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?value:null);if(_1655||_1655===undefined){this.onChange(value);}},onChange:function(){},_navigateByKey:function(_1656,_1657){if(_1657==-1){return;}var _1658=this._currentFocus.index+_1656;if(_1658<this._cells.length&&_1658>-1){var _1659=this._cells[_1658].node;this._setCurrent(_1659);setTimeout(lang.hitch(dijit,"focus",_1659),0);}},_getDye:function(cell){return this._cells[cell.index].dye;}});});},"dijit/form/nls/ComboBox":function(){define({root:({previousMessage:"Previous choices",nextMessage:"More choices"}),"zh":true,"zh-tw":true,"tr":true,"th":true,"sv":true,"sl":true,"sk":true,"ru":true,"ro":true,"pt":true,"pt-pt":true,"pl":true,"nl":true,"nb":true,"ko":true,"kk":true,"ja":true,"it":true,"hu":true,"he":true,"fr":true,"fi":true,"es":true,"el":true,"de":true,"da":true,"cs":true,"ca":true,"ar":true});},"dijit/_editor/selection":function(){define("dijit/_editor/selection",["dojo/dom","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window",".."],function(dom,lang,has,win,dijit){lang.getObject("_editor.selection",true,dijit);lang.mixin(dijit._editor.selection,{getType:function(){if(has("ie")<9){return win.doc.selection.type.toLowerCase();}else{var stype="text";var oSel;try{oSel=win.global.getSelection();}catch(e){}if(oSel&&oSel.rangeCount==1){var _165a=oSel.getRangeAt(0);if((_165a.startContainer==_165a.endContainer)&&((_165a.endOffset-_165a.startOffset)==1)&&(_165a.startContainer.nodeType!=3)){stype="control";}}return stype;}},getSelectedText:function(){if(has("ie")<9){if(dijit._editor.selection.getType()=="control"){return null;}return win.doc.selection.createRange().text;}else{var _165b=win.global.getSelection();if(_165b){return _165b.toString();}}return "";},getSelectedHtml:function(){if(has("ie")<9){if(dijit._editor.selection.getType()=="control"){return null;}return win.doc.selection.createRange().htmlText;}else{var _165c=win.global.getSelection();if(_165c&&_165c.rangeCount){var i;var html="";for(i=0;i<_165c.rangeCount;i++){var frag=_165c.getRangeAt(i).cloneContents();var div=win.doc.createElement("div");div.appendChild(frag);html+=div.innerHTML;}return html;}return null;}},getSelectedElement:function(){if(dijit._editor.selection.getType()=="control"){if(has("ie")<9){var range=win.doc.selection.createRange();if(range&&range.item){return win.doc.selection.createRange().item(0);}}else{var _165d=win.global.getSelection();return _165d.anchorNode.childNodes[_165d.anchorOffset];}}return null;},getParentElement:function(){if(dijit._editor.selection.getType()=="control"){var p=this.getSelectedElement();if(p){return p.parentNode;}}else{if(has("ie")<9){var r=win.doc.selection.createRange();r.collapse(true);return r.parentElement();}else{var _165e=win.global.getSelection();if(_165e){var node=_165e.anchorNode;while(node&&(node.nodeType!=1)){node=node.parentNode;}return node;}}}return null;},hasAncestorElement:function(_165f){return this.getAncestorElement.apply(this,arguments)!=null;},getAncestorElement:function(_1660){var node=this.getSelectedElement()||this.getParentElement();return this.getParentOfType(node,arguments);},isTag:function(node,tags){if(node&&node.tagName){var _1661=node.tagName.toLowerCase();for(var i=0;i<tags.length;i++){var _1662=String(tags[i]).toLowerCase();if(_1661==_1662){return _1662;}}}return "";},getParentOfType:function(node,tags){while(node){if(this.isTag(node,tags).length){return node;}node=node.parentNode;}return null;},collapse:function(_1663){if(window.getSelection){var _1664=win.global.getSelection();if(_1664.removeAllRanges){if(_1663){_1664.collapseToStart();}else{_1664.collapseToEnd();}}else{_1664.collapse(_1663);}}else{if(has("ie")){var range=win.doc.selection.createRange();range.collapse(_1663);range.select();}}},remove:function(){var sel=win.doc.selection;if(has("ie")<9){if(sel.type.toLowerCase()!="none"){sel.clear();}return sel;}else{sel=win.global.getSelection();sel.deleteFromDocument();return sel;}},selectElementChildren:function(_1665,_1666){var _1667=win.global;var doc=win.doc;var range;_1665=dom.byId(_1665);if(doc.selection&&has("ie")<9&&win.body().createTextRange){range=_1665.ownerDocument.body.createTextRange();range.moveToElementText(_1665);if(!_1666){try{range.select();}catch(e){}}}else{if(_1667.getSelection){var _1668=win.global.getSelection();if(has("opera")){if(_1668.rangeCount){range=_1668.getRangeAt(0);}else{range=doc.createRange();}range.setStart(_1665,0);range.setEnd(_1665,(_1665.nodeType==3)?_1665.length:_1665.childNodes.length);_1668.addRange(range);}else{_1668.selectAllChildren(_1665);}}}},selectElement:function(_1669,_166a){var range;var doc=win.doc;var _166b=win.global;_1669=dom.byId(_1669);if(has("ie")<9&&win.body().createTextRange){try{var tg=_1669.tagName?_1669.tagName.toLowerCase():"";if(tg==="img"||tg==="table"){range=win.body().createControlRange();}else{range=win.body().createRange();}range.addElement(_1669);if(!_166a){range.select();}}catch(e){this.selectElementChildren(_1669,_166a);}}else{if(_166b.getSelection){var _166c=_166b.getSelection();range=doc.createRange();if(_166c.removeAllRanges){if(has("opera")){if(_166c.getRangeAt(0)){range=_166c.getRangeAt(0);}}range.selectNode(_1669);_166c.removeAllRanges();_166c.addRange(range);}}}},inSelection:function(node){if(node){var _166d;var doc=win.doc;var range;if(win.global.getSelection){var sel=win.global.getSelection();if(sel&&sel.rangeCount>0){range=sel.getRangeAt(0);}if(range&&range.compareBoundaryPoints&&doc.createRange){try{_166d=doc.createRange();_166d.setStart(node,0);if(range.compareBoundaryPoints(range.START_TO_END,_166d)===1){return true;}}catch(e){}}}else{if(doc.selection){range=doc.selection.createRange();try{_166d=node.ownerDocument.body.createControlRange();if(_166d){_166d.addElement(node);}}catch(e1){try{_166d=node.ownerDocument.body.createTextRange();_166d.moveToElementText(node);}catch(e2){}}if(range&&_166d){if(range.compareEndPoints("EndToStart",_166d)===1){return true;}}}}}return false;}});return dijit._editor.selection;});},"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>","dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(focus,_166e,_166f,lang){lang.extend(_166e,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _166f("dijit._FocusMixin",null,{_focusManager:focus});});},"dijit/form/ValidationTextBox":function(){require({cache:{"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n"}});define("dijit/form/ValidationTextBox",["dojo/_base/declare","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_1670,i18n,_1671,_1672,_1673){return _1670("dijit.form.ValidationTextBox",_1671,{templateString:_1673,baseClass:"dijitTextBox dijitValidationTextBox",required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},regExp:".*",regExpGen:function(){return this.regExp;},state:"",tooltipPosition:[],_setValueAttr:function(){this.inherited(arguments);this.validate(this.focused);},validator:function(value,_1674){return (new RegExp("^(?:"+this.regExpGen(_1674)+")"+(this.required?"":"?")+"$")).test(value)&&(!this.required||!this._isEmpty(value))&&(this._isEmpty(value)||this.parse(value,_1674)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.constraints);},_isEmpty:function(value){return (this.trim?/^\s*$/:/^$/).test(value);},getErrorMessage:function(){return (this.required&&this._isEmpty(this.textbox.value))?this.missingMessage:this.invalidMessage;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_1675){var _1676="";var _1677=this.disabled||this.isValid(_1675);if(_1677){this._maskValidSubsetError=true;}var _1678=this._isEmpty(this.textbox.value);var _1679=!_1677&&_1675&&this._isValidSubset();this._set("state",_1677?"":(((((!this._hasBeenBlurred||_1675)&&_1678)||_1679)&&this._maskValidSubsetError)?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",_1677?"false":"true");if(this.state=="Error"){this._maskValidSubsetError=_1675&&_1679;_1676=this.getErrorMessage(_1675);}else{if(this.state=="Incomplete"){_1676=this.getPromptMessage(_1675);this._maskValidSubsetError=!this._hasBeenBlurred||_1675;}else{if(_1678){_1676=this.getPromptMessage(_1675);}}}this.set("message",_1676);return _1677;},displayMessage:function(_167a){if(_167a&&this.focused){_1672.show(_167a,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_1672.hide(this.domNode);}},_refreshState:function(){this.validate(this.focused);this.inherited(arguments);},constructor:function(){this.constraints={};},_setConstraintsAttr:function(_167b){if(!_167b.locale&&this.lang){_167b.locale=this.lang;}this._set("constraints",_167b);this._computePartialRE();},_computePartialRE:function(){var p=this.regExpGen(this.constraints);this.regExp=p;var _167c="";if(p!=".*"){this.regExp.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_167c+=re;break;case ")":_167c+="|$)";break;default:_167c+="(?:"+re+"|$)";break;}});}try{"".search(_167c);}catch(e){_167c=this.regExp;console.warn("RegExp error in "+this.declaredClass+": "+this.regExp);}this._partialre="^(?:"+_167c+")$";},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);if(this.invalidMessage=="$_unset_$"){this.invalidMessage=this.messages.invalidMessage;}if(!this.invalidMessage){this.invalidMessage=this.promptMessage;}if(this.missingMessage=="$_unset_$"){this.missingMessage=this.messages.missingMessage;}if(!this.missingMessage){this.missingMessage=this.invalidMessage;}this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(value){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(value){this._set("required",value);this.focusNode.setAttribute("aria-required",value);this._refreshState();},_setMessageAttr:function(_167d){this._set("message",_167d);this.displayMessage(_167d);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);}});});},"url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_menuBtn\"\n\t\t\tdata-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t\tdata-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_leftBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_rightBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'\n\t\t\t\tdata-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","dojox/charting/plot2d/StackedColumns":function(){define("dojox/charting/plot2d/StackedColumns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_167e,_167f,dc,df,dfr,dfs){var _1680=dfr.lambda("item.purgeGroup()");return _167e("dojox.charting.plot2d.StackedColumns",_167f,{getSeriesStats:function(){var stats=dc.collectStackedStats(this.series);this._maxRunLength=stats.hmax;stats.hmin-=0.5;stats.hmax+=0.5;return stats;},render:function(dim,_1681){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_1681);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_1680);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1682=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var theme=t.next("column",[this.opt,run]),s=run.group,_1683=new Array(acc.length);for(var j=0;j<acc.length;++j){var value=run.data[j];if(value!==null){var v=acc[j],_1684=vt(v),_1685=typeof value!="number"?t.addMixin(theme,"column",value,true):t.post(theme,"column");if(width>=1&&_1684>=0){var rect={x:_1681.l+ht(j+0.5)+gap,y:dim.height-_1681.b-vt(v),width:width,height:_1684};var _1686=this._plotFill(_1685.series.fill,dim,_1681);_1686=this._shapeFill(_1686,rect);var shape=s.createRect(rect).setFill(_1686).setStroke(_1685.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(_1682){var o={element:"column",index:j,run:run,shape:shape,x:j+0.5,y:v};this._connectEvents(o);_1683[j]=o;}if(this.animate){this._animateColumn(shape,dim.height-_1681.b,_1684);}}}}this._eventSeries[run.name]=_1683;run.dirty=false;for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dijit/form/NumberTextBox":function(){define("dijit/form/NumberTextBox",["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_1687,lang,_1688,_1689){var _168a=_1687("dijit.form.NumberTextBoxMixin",null,{regExpGen:_1688.regexp,value:NaN,editOptions:{pattern:"#.######"},_formatter:_1688.format,postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_168b){var _168c=typeof _168b.places=="number"?_168b.places:0;if(_168c){_168c++;}if(typeof _168b.max!="number"){_168b.max=9*Math.pow(10,15-_168c);}if(typeof _168b.min!="number"){_168b.min=-9*Math.pow(10,15-_168c);}this.inherited(arguments,[_168b]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}},_onFocus:function(){if(this.disabled){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _168d=this.format(val,this.constraints);if(_168d!==undefined){this.textbox.value=_168d;}}this.inherited(arguments);},format:function(value,_168e){var _168f=String(value);if(typeof value!="number"){return _168f;}if(isNaN(value)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(value,_168e))&&_168e.exponent!==false&&/\de[-+]?\d/i.test(_168f)){return _168f;}if(this.editOptions&&this.focused){_168e=lang.mixin({},_168e,this.editOptions);}return this._formatter(value,_168e);},_parser:_1688.parse,parse:function(value,_1690){var v=this._parser(value,lang.mixin({},_1690,(this.editOptions&&this.focused)?this.editOptions:{}));if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(value,_1690);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(value){return (value===null||value===""||value===undefined)?NaN:this.inherited(arguments);},serialize:function(value,_1691){return (typeof value!="number"||isNaN(value))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.mixin({},this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(value,_1692,_1693){if(value!==undefined&&_1693===undefined){_1693=String(value);if(typeof value=="number"){if(isNaN(value)){_1693="";}else{if(("rangeCheck" in this&&this.rangeCheck(value,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_1693)){_1693=undefined;}}}else{if(!value){_1693="";value=NaN;}else{value=undefined;}}}this.inherited(arguments,[value,_1692,_1693]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_1688._realNumberRegexp(lang.mixin({},this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_1694){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}}});var _1695=_1687("dijit.form.NumberTextBox",[_1689,_168a],{baseClass:"dijitTextBox dijitNumberTextBox"});_1695.Mixin=_168a;return _1695;});},"dojo/_base/url":function(){define(["./kernel"],function(dojo){var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_1696=function(){var n=null,_1697=arguments,uri=[_1697[0]];for(var i=1;i<_1697.length;i++){if(!_1697[i]){continue;}var _1698=new _1696(_1697[i]+""),_1699=new _1696(uri[0]+"");if(_1698.path==""&&!_1698.scheme&&!_1698.authority&&!_1698.query){if(_1698.fragment!=n){_1699.fragment=_1698.fragment;}_1698=_1699;}else{if(!_1698.scheme){_1698.scheme=_1699.scheme;if(!_1698.authority){_1698.authority=_1699.authority;if(_1698.path.charAt(0)!="/"){var path=_1699.path.substring(0,_1699.path.lastIndexOf("/")+1)+_1698.path;var segs=path.split("/");for(var j=0;j<segs.length;j++){if(segs[j]=="."){if(j==segs.length-1){segs[j]="";}else{segs.splice(j,1);j--;}}else{if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){if(j==(segs.length-1)){segs.splice(j,1);segs[j-1]="";}else{segs.splice(j-1,2);j-=2;}}}}_1698.path=segs.join("/");}}}}uri=[];if(_1698.scheme){uri.push(_1698.scheme,":");}if(_1698.authority){uri.push("//",_1698.authority);}uri.push(_1698.path);if(_1698.query){uri.push("?",_1698.query);}if(_1698.fragment){uri.push("#",_1698.fragment);}}this.uri=uri.join("");var r=this.uri.match(ore);this.scheme=r[2]||(r[1]?"":n);this.authority=r[4]||(r[3]?"":n);this.path=r[5];this.query=r[7]||(r[6]?"":n);this.fragment=r[9]||(r[8]?"":n);if(this.authority!=n){r=this.authority.match(ire);this.user=r[3]||n;this.password=r[4]||n;this.host=r[6]||r[7];this.port=r[9]||n;}};_1696.prototype.toString=function(){return this.uri;};return dojo._Url=_1696;});},"dijit/form/_ComboBoxMenuMixin":function(){define("dijit/form/_ComboBoxMenuMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/i18n","dojo/_base/window","dojo/i18n!./nls/ComboBox"],function(array,_169a,_169b,i18n,win){return _169a("dijit.form._ComboBoxMenuMixin",null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(value){this.value=value;this.onChange(value);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_169c){var _169d=this._createMenuItem();var _169e=_169c(item);if(_169e.html){_169d.innerHTML=_169e.label;}else{_169d.appendChild(win.doc.createTextNode(_169e.label));}if(_169d.innerHTML==""){_169d.innerHTML="&#160;";}this.applyTextDir(_169d,(_169d.innerText||_169d.textContent||""));_169d.item=item;return _169d;},createOptions:function(_169f,_16a0,_16a1){this.previousButton.style.display=(_16a0.start==0)?"none":"";_169b.set(this.previousButton,"id",this.id+"_prev");array.forEach(_169f,function(item,i){var _16a2=this._createOption(item,_16a1);_169b.set(_16a2,"id",this.id+i);this.nextButton.parentNode.insertBefore(_16a2,this.nextButton);},this);var _16a3=false;if(_169f.total&&!_169f.total.then&&_169f.total!=-1){if((_16a0.start+_16a0.count)<_169f.total){_16a3=true;}else{if((_16a0.start+_16a0.count)>_169f.total&&_16a0.count==_169f.length){_16a3=true;}}}else{if(_16a0.count==_169f.length){_16a3=true;}}this.nextButton.style.display=_16a3?"":"none";_169b.set(this.nextButton,"id",this.id+"_next");return this.containerNode.childNodes;},clearResultList:function(){var _16a4=this.containerNode;while(_16a4.childNodes.length>2){_16a4.removeChild(_16a4.childNodes[_16a4.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this._getSelectedAttr();}});});},"dijit/Tree":function(){require({cache:{"url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\" data-dojo-attach-event=\"onmouseenter:_onMouseEnter, onmouseleave:_onMouseLeave, onclick:_onClick, ondblclick:_onDblClick\"\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t/><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\" data-dojo-attach-event=\"onfocus:_onLabelFocus\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","url:dijit/templates/Tree.html":"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\"\n\tdata-dojo-attach-event=\"onkeypress:_onKeyPress\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n"}});define("dijit/Tree",["dojo/_base/array","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/_base/Deferred","dojo/DeferredList","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/fx","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/topic","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector"],function(array,_16a5,_16a6,_16a7,_16a8,_16a9,dom,_16aa,_16ab,_16ac,event,_16ad,_16ae,keys,lang,topic,focus,_16af,_16b0,_16b1,_16b2,_16b3,_16b4,_16b5,_16b6,_16b7,_16b8,_16b9,_16ba){var _16bb=_16a7("dijit._TreeNode",[_16b1,_16b2,_16b3,_16b4,_16b5],{item:null,isTreeNode:true,label:"",_setLabelAttr:{node:"labelNode",type:"innerText"},isExpandable:null,isExpanded:false,state:"UNCHECKED",templateString:_16b6,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow",labelNode:"dijitTreeLabel"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_16bc){var _16bd=(Math.max(_16bc,0)*this.tree._nodePixelIndent)+"px";_16ac.set(this.domNode,"backgroundPosition",_16bd+" 0px");_16ac.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_16bd);array.forEach(this.getChildren(),function(child){child.set("indent",_16bc+1);});this._set("indent",_16bc);},markProcessing:function(){this.state="LOADING";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,model=tree.model;if(tree._v10Compat&&item===model.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");},_applyClassAndSty