/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TextInputWidgetProvider
extends AbstractWidgetProvider {
    private static final int VERTICAL_INCREMENT = 2;
    public static final int PWD_SIZE = 18;
    private int DEFAULTSIZE;
    private int _size;
    private String _value;

    public TextInputWidgetProvider(ICSSStyle style) {
        this(style, 20);
    }

    public TextInputWidgetProvider(ICSSStyle style, int size) {
        super(style);
        this._size = this.DEFAULTSIZE = 20;
        this.DEFAULTSIZE = size;
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultHeight();
        }
        return new DimensionInfo(width, height, -1);
    }

    private int getDefaultHeight() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        Font swtfont = font.getSwtFont();
        int fontSize = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
        return fontSize + 2;
    }

    public int getDefaultWidth() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        return this.computeWidth(style.getCSSFont());
    }

    private int computeWidth(ICSSFont font) {
        int fontWidth = FigureUtilities.getTextWidth((String)"abcde", (Font)font.getSwtFont());
        return (fontWidth + 1) * this._size / 5;
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        String value = this.getValue();
        if (value != null) {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            Object textAlign = style.getStyleProperty("text-align");
            Font font = style.getCSSFont().getSwtFont();
            g.setFont(font);
            Color newColor = null;
            Object color = style.getColor();
            if (color instanceof Color) {
                g.setForegroundColor((Color)color);
            } else if (color instanceof RGB) {
                newColor = new Color((Device)Display.getCurrent(), (RGB)color);
                g.setForegroundColor(newColor);
            } else {
                g.setForegroundColor(ColorConstants.black);
            }
            g.clipRect(rect);
            int width = FigureUtilities.getTextWidth((String)value, (Font)g.getFont());
            int x = TextLayoutSupport.getBeginX(textAlign, rect, width);
            int y = rect.y + 1;
            g.drawString(value, x, y);
            TextLayoutSupport.paintTextDecoration(g, new Rectangle(x, y, width, g.getFontMetrics().getHeight()), (Integer)this.getCSSStyle().getStyleProperty("text-decoration"));
            if (newColor != null) {
                newColor.dispose();
            }
        }
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setSize(int size) {
        this._size = size <= 0 ? this.DEFAULTSIZE : size;
    }

    public String getValue() {
        return this._value;
    }
}

