/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.core.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.deployment.core.DeploymentDescParser;
import org.eclipse.edt.ide.deployment.core.model.DeploymentTarget;
import org.eclipse.edt.ide.deployment.core.model.RUIApplication;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.deployment.core.model.Service;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;

public class DeploymentDesc
extends RuntimeDeploymentDesc {
    private List<Service> services = new ArrayList<Service>();
    private RUIApplication ruiApplication;
    private ArrayList<String> eglParts;
    private List<String> resourceOmissions = new ArrayList<String>();
    private DeploymentTarget target;
    private String eglddFileName;

    public static DeploymentDesc createDeploymentDescriptor(String filepath) throws Exception {
        DeploymentDesc desc = new DeploymentDesc();
        desc.setName(DeploymentDesc.getNameFromFilePath((String)filepath));
        DeploymentDescParser parser = new DeploymentDescParser();
        parser.parse(desc, filepath);
        return desc;
    }

    public static DeploymentDesc createDeploymentDescriptor(String name, InputStream is) throws Exception {
        DeploymentDesc desc = new DeploymentDesc();
        desc.setName(name);
        DeploymentDescParser parser = new DeploymentDescParser();
        parser.parse(desc, is);
        return desc;
    }

    private DeploymentDesc() {
    }

    public List<Restservice> getRestservices() {
        ArrayList<Restservice> restServices = new ArrayList<Restservice>();
        for (Service service : this.services) {
            if (!(service instanceof Restservice)) continue;
            restServices.add((Restservice)service);
        }
        return restServices;
    }

    public void setName(String name) {
        this.eglddFileName = name;
        super.setName(name);
    }

    public String getEGLDDFileName() {
        return this.eglddFileName;
    }

    public RUIApplication getRUIApplication() {
        return this.ruiApplication;
    }

    public void setRUIApplication(RUIApplication application) {
        this.ruiApplication = application;
    }

    public void setTarget(DeploymentTarget target) {
        this.target = target;
    }

    public DeploymentTarget getDeploymentTarget() {
        return this.target;
    }

    public void addService(Service service) {
        if (Service.SERVICE_REST.equalsIgnoreCase(service.getType())) {
            this.services.add(new Restservice(service));
        }
    }

    public void removeResourceOmission(String resource) {
        this.resourceOmissions.remove(resource);
    }

    public List<String> getResourceOmissions() {
        return this.resourceOmissions;
    }

    public void addResourceOmission(String resource) {
        this.resourceOmissions.add(resource);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public ArrayList<String> getEGLServiceParts() {
        if (this.eglParts == null) {
            this.eglParts = new ArrayList();
            for (Service ws : this.getServices()) {
                this.eglParts.add(ws.getImplementation());
            }
        }
        return this.eglParts;
    }

    public static /* bridge */ /* synthetic */ RuntimeDeploymentDesc createDeploymentDescriptor(String string, InputStream inputStream) throws Exception {
        return DeploymentDesc.createDeploymentDescriptor(string, inputStream);
    }
}

