/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.AS400JDBCManagedConnectionPoolDataSource;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.EventLog;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDConnectionPoolKey;
import com.ibm.as400.access.JDConnectionPoolManager;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class AS400JDBCManagedDataSource
implements DataSource,
Referenceable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    static final String copyright = "Copyright (C) 2005-2010 International Business Machines Corporation and others.";
    private static final boolean DEBUG = false;
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String DESCRIPTION = "description";
    private static final String SERVER_NAME = "serverName";
    private static final String USER = "user";
    private static final String KEY_RING_NAME = "key ring name";
    private static final String PASSWORD = "pw";
    private static final String KEY_RING_PASSWORD = "key ring password";
    private static final String SECURE = "secure";
    private static final String SAVE_PASSWORD = "savepw";
    private static final String PLAIN_TEXT_PASSWORD = "pwd";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String TOOLBOX_DRIVER = "jdbc:as400:";
    private static final int MAX_THRESHOLD = 0x1000000;
    private static final String SOCKET_KEEP_ALIVE = "soKeepAlive";
    private static final String SOCKET_RECEIVE_BUFFER_SIZE = "soReceiveBufferSize";
    private static final String SOCKET_SEND_BUFFER_SIZE = "soSendBufferSize";
    private static final String SOCKET_LINGER = "soLinger";
    private static final String SOCKET_TIMEOUT = "soTimeout";
    private static final String SOCKET_TCP_NO_DELAY = "soTCPNoDelay";
    private transient AS400 as400_;
    private String dataSourceName_;
    private String description_;
    private char[] serialPWBytes_;
    private int pwHashcode_;
    private String serialServerName_;
    private String serialUserName_;
    private String serialKeyRingName_;
    private boolean isSecure_;
    private char[] serialKeyRingPWBytes_;
    private boolean savePasswordWhenSerialized_;
    private JDProperties properties_;
    private SocketProperties sockProps_;
    private transient PrintWriter writer_;
    transient EventLog log_;
    private transient AS400JDBCManagedConnectionPoolDataSource cpds_;
    private boolean dataSourceNameSpecified_;
    private transient JDConnectionPoolManager poolManager_;
    private transient boolean poolManagerInitialized_;
    private transient JDConnectionPoolKey defaultConnectionPoolKey_;
    private transient boolean connectionKeyNeedsUpdate_;
    private transient boolean inUse_;
    public static final int MAX_STORAGE_LIMIT = 2147352578;
    static final int TRACE_CLIENT = 1;
    public static final int SERVER_TRACE_START_DATABASE_MONITOR = 2;
    public static final int SERVER_TRACE_DEBUG_SERVER_JOB = 4;
    public static final int SERVER_TRACE_SAVE_SERVER_JOBLOG = 8;
    public static final int SERVER_TRACE_TRACE_SERVER_JOB = 16;
    public static final int SERVER_TRACE_SAVE_SQL_INFORMATION = 32;

    public AS400JDBCManagedDataSource() {
        this.properties_ = new JDProperties();
        this.sockProps_ = new SocketProperties();
        this.connectionKeyNeedsUpdate_ = true;
        this.initializeTransient();
    }

    public AS400JDBCManagedDataSource(String string) {
        this();
        this.setServerName(string);
    }

    public AS400JDBCManagedDataSource(String string, String string2, String string3) {
        this();
        this.setServerName(string);
        this.setUser(string2);
        this.setPassword(string3);
    }

    public AS400JDBCManagedDataSource(String string, String string2, String string3, String string4, String string5) {
        this();
        this.setSecure(true);
        try {
            this.as400_ = new SecureAS400(this.as400_);
            ((SecureAS400)this.as400_).setKeyRingName(string4, string5);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.serialKeyRingName_ = string4;
        this.serialKeyRingPWBytes_ = AS400JDBCManagedDataSource.xpwConfuse(string5);
        this.setServerName(string);
        this.setUser(string2);
        this.setPassword(string3);
    }

    AS400JDBCManagedDataSource(Reference reference) {
        Object object;
        Properties properties;
        block25: {
            this.properties_ = new JDProperties();
            this.sockProps_ = new SocketProperties();
            this.connectionKeyNeedsUpdate_ = true;
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            properties = new Properties();
            if (((String)reference.get(SECURE).getContent()).equalsIgnoreCase(TRUE_)) {
                this.isSecure_ = true;
                this.as400_ = new SecureAS400();
                this.serialKeyRingName_ = (String)reference.get(KEY_RING_NAME).getContent();
                this.serialKeyRingPWBytes_ = (char[])(reference.get(KEY_RING_PASSWORD) != null ? ((String)reference.get(KEY_RING_PASSWORD).getContent()).toCharArray() : null);
                try {
                    if (this.serialKeyRingPWBytes_ != null && this.serialKeyRingPWBytes_.length > 0) {
                        ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_, AS400JDBCManagedDataSource.xpwDeconfuse(this.serialKeyRingPWBytes_));
                        break block25;
                    }
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.isSecure_ = false;
                this.as400_ = new AS400();
            }
        }
        boolean bl = this instanceof AS400JDBCManagedConnectionPoolDataSource;
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            object = (StringRefAddr)enumeration.nextElement();
            String string = ((RefAddr)object).getType();
            String string2 = (String)reference.get(string).getContent();
            if (string.equals(DATASOURCE_NAME)) {
                this.setDataSourceName(string2);
                continue;
            }
            if (string.equals(DESCRIPTION)) {
                this.setDescription(string2);
                continue;
            }
            if (string.equals(SERVER_NAME)) {
                this.setServerName(string2);
                continue;
            }
            if (string.equals(USER)) {
                this.setUser(string2);
                ((Hashtable)properties).put(string, string2);
                continue;
            }
            if (string.equals(PLAIN_TEXT_PASSWORD)) {
                this.setPassword(string2);
                continue;
            }
            if (string.equals(PASSWORD)) {
                if (reference.get(PLAIN_TEXT_PASSWORD) != null) {
                    this.setPassword((String)reference.get(PLAIN_TEXT_PASSWORD).getContent());
                    continue;
                }
                if (string2 == null) continue;
                this.serialPWBytes_ = string2.toCharArray();
                this.pwHashcode_ = AS400JDBCManagedDataSource.xpwDeconfuse(this.serialPWBytes_).hashCode();
                this.as400_.setPassword(AS400JDBCManagedDataSource.xpwDeconfuse(this.serialPWBytes_));
                continue;
            }
            if (string.equals(SAVE_PASSWORD)) {
                this.savePasswordWhenSerialized_ = string2.equals(TRUE_);
                continue;
            }
            if (string.equals(KEY_RING_NAME) || string.equals(KEY_RING_PASSWORD)) continue;
            if (string.equals(SOCKET_KEEP_ALIVE)) {
                this.sockProps_.setKeepAlive(string2.equals(TRUE_));
                continue;
            }
            if (string.equals(SOCKET_RECEIVE_BUFFER_SIZE)) {
                this.sockProps_.setReceiveBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_SEND_BUFFER_SIZE)) {
                this.sockProps_.setSendBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_LINGER)) {
                this.sockProps_.setSoLinger(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_TIMEOUT)) {
                this.sockProps_.setSoTimeout(Integer.parseInt(string2));
                continue;
            }
            if (string.equals(SOCKET_TCP_NO_DELAY)) {
                this.sockProps_.setTcpNoDelay(string2.equals(TRUE_));
                continue;
            }
            if (bl && AS400JDBCManagedConnectionPoolDataSource.isConnectionPoolProperty(string)) continue;
            ((Hashtable)properties).put(string, string2);
        }
        this.properties_ = new JDProperties(properties, null);
        if (this.sockProps_.isAnyOptionSet()) {
            this.as400_.setSocketProperties(this.sockProps_);
        }
        if ((object = this.properties_.getString(18)) != null && ((String)object).equalsIgnoreCase(FALSE_)) {
            this.setPrompt(false);
        } else if (object != null && ((String)object).equalsIgnoreCase(TRUE_)) {
            this.setPrompt(true);
        }
    }

    public boolean checkPoolHealth(boolean bl) {
        if (this.poolManager_ == null) {
            this.logWarning("Connection pool does not exist");
            return false;
        }
        return this.poolManager_.checkHealth(bl);
    }

    final AS400JDBCConnection createPhysicalConnection() throws SQLException {
        if (this.cpds_ != null) {
            return this.cpds_.createPhysicalConnection();
        }
        AS400 aS400 = null;
        aS400 = this.isSecure_ || this.isSecure() ? new SecureAS400(this.as400_) : new AS400(this.as400_);
        if (this.sockProps_.isAnyOptionSet()) {
            aS400.setSocketProperties(this.sockProps_);
        }
        return this.createPhysicalConnection(aS400);
    }

    final AS400JDBCConnection createPhysicalConnection(String string, String string2) throws SQLException {
        if (string == null) {
            throw new NullPointerException(USER);
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        if (this.cpds_ != null) {
            return this.cpds_.createPhysicalConnection(string, string2);
        }
        AS400 aS400 = null;
        aS400 = this.isSecure_ || this.isSecure() ? new SecureAS400(this.as400_) : new AS400(this.as400_);
        try {
            aS400.setUserId(string);
            aS400.setPassword(string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!this.isPrompt()) {
                aS400.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (this.sockProps_.isAnyOptionSet()) {
            aS400.setSocketProperties(this.sockProps_);
        }
        return this.createPhysicalConnection(aS400);
    }

    private AS400JDBCConnection createPhysicalConnection(AS400 aS400) throws SQLException {
        AS400JDBCConnection aS400JDBCConnection = new AS400JDBCConnection();
        aS400JDBCConnection.setProperties(new JDDataSourceURL("jdbc:as400://" + aS400.getSystemName()), this.properties_, aS400);
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation(ResourceBundleLoader.getText("AS400_JDBC_DS_CONN_CREATED"));
        }
        return aS400JDBCConnection;
    }

    public Object clone() {
        try {
            AS400JDBCManagedDataSource aS400JDBCManagedDataSource = (AS400JDBCManagedDataSource)super.clone();
            aS400JDBCManagedDataSource.properties_ = (JDProperties)this.properties_.clone();
            return aS400JDBCManagedDataSource;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, cloneNotSupportedException);
            throw new UnsupportedOperationException("clone()");
        }
    }

    public void closePool() {
        if (this.poolManager_ != null) {
            this.poolManager_.closePool();
        }
    }

    public String getAccess() {
        return this.properties_.getString(0);
    }

    public int getBehaviorOverride() {
        return this.properties_.getInt(50);
    }

    public int getBidiStringType() {
        String string = this.properties_.getString(42);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getBlockCriteria() {
        return this.properties_.getInt(2);
    }

    public int getBlockSize() {
        return this.properties_.getInt(1);
    }

    public int getConcurrentAccessResolution() {
        return this.properties_.getInt(79);
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        if (this.dataSourceNameSpecified_) {
            connection = this.getConnectionFromPool(null, null);
            if (connection == null) {
                connection = this.createPhysicalConnection();
            }
        } else {
            if (JDTrace.isTraceOn() || this.log_ != null) {
                this.logWarning("No datasource name was specified, so connections will not be pooled");
            }
            connection = this.createPhysicalConnection();
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null) {
            throw new NullPointerException(USER);
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        Connection connection = null;
        if (this.dataSourceNameSpecified_) {
            JDConnectionPoolKey jDConnectionPoolKey = new JDConnectionPoolKey(string, string2.hashCode());
            connection = this.getConnectionFromPool(jDConnectionPoolKey, string2);
            if (connection == null) {
                connection = this.createPhysicalConnection(string, string2);
            }
        } else {
            if (JDTrace.isTraceOn() || this.log_ != null) {
                this.logWarning("No datasource name was specified, so connections will not be pooled");
            }
            connection = this.createPhysicalConnection(string, string2);
        }
        return connection;
    }

    private final AS400JDBCConnectionHandle getConnectionFromPool(JDConnectionPoolKey jDConnectionPoolKey, String string) throws SQLException {
        AS400JDBCConnectionHandle aS400JDBCConnectionHandle = null;
        if (!this.poolManagerInitialized_) {
            this.initializeConnectionPool();
        }
        if ((aS400JDBCConnectionHandle = this.poolManager_.getConnection(jDConnectionPoolKey, string)) == null && (JDTrace.isTraceOn() || this.log_ != null)) {
            this.logWarning("Connection pool is at or near capacity, so returning a non-pooled connection");
        }
        return aS400JDBCConnectionHandle;
    }

    final JDConnectionPoolKey getConnectionPoolKey() {
        if (this.connectionKeyNeedsUpdate_) {
            if (this.defaultConnectionPoolKey_ == null) {
                this.defaultConnectionPoolKey_ = new JDConnectionPoolKey(this.serialUserName_, this.pwHashcode_);
            } else {
                this.defaultConnectionPoolKey_.update(this.serialUserName_, this.pwHashcode_);
            }
        }
        this.connectionKeyNeedsUpdate_ = false;
        return this.defaultConnectionPoolKey_;
    }

    public String getCursorSensitivity() {
        return this.properties_.getString(49);
    }

    public String getDatabaseName() {
        return this.properties_.getString(47);
    }

    public String getDataSourceName() {
        return this.dataSourceName_ == null ? "" : this.dataSourceName_;
    }

    public String getDateFormat() {
        return this.properties_.getString(3);
    }

    public String getDateSeparator() {
        return this.properties_.getString(4);
    }

    public String getDecfloatRoundingMode() {
        return this.properties_.getString(74);
    }

    public String getDecimalSeparator() {
        return this.properties_.getString(5);
    }

    public String getIgnoreWarnings() {
        return this.properties_.getString(77);
    }

    public String getDescription() {
        return this.description_ == null ? "" : this.description_;
    }

    public String getDriver() {
        return this.properties_.getString(41);
    }

    public String getErrors() {
        return this.properties_.getString(6);
    }

    public String getLibraries() {
        return this.properties_.getString(8);
    }

    public int getLobThreshold() {
        return this.properties_.getInt(31);
    }

    public int getLoginTimeout() {
        return this.properties_.getInt(58);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.writer_;
    }

    public int getMetaDataSource() {
        return this.properties_.getInt(72);
    }

    public int getMetadataSource() {
        return this.getMetaDataSource();
    }

    public String getNaming() {
        return this.properties_.getString(9);
    }

    public String getPackage() {
        return this.properties_.getString(10);
    }

    public String getPackageCriteria() {
        return this.properties_.getString(30);
    }

    public String getPackageError() {
        return this.properties_.getString(14);
    }

    public String getPackageLibrary() {
        return this.properties_.getString(15);
    }

    final char[] getPWBytes() {
        return this.serialPWBytes_;
    }

    public String getProxyServer() {
        return this.properties_.getString(34);
    }

    public int getQueryOptimizeGoal() {
        return this.properties_.getInt(66);
    }

    public String getQueryTimeoutMechanism() {
        return this.properties_.getString(84);
    }

    public int getQueryStorageLimit() {
        return this.properties_.getInt(73);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        DriverPropertyInfo[] driverPropertyInfoArray = this.properties_.getInfo();
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            if (driverPropertyInfoArray[i].value == null) continue;
            reference.add(new StringRefAddr(driverPropertyInfoArray[i].name, driverPropertyInfoArray[i].value));
        }
        if (this.sockProps_.keepAliveSet_) {
            reference.add(new StringRefAddr(SOCKET_KEEP_ALIVE, this.sockProps_.keepAlive_ ? TRUE_ : FALSE_));
        }
        if (this.sockProps_.receiveBufferSizeSet_) {
            reference.add(new StringRefAddr(SOCKET_RECEIVE_BUFFER_SIZE, Integer.toString(this.sockProps_.receiveBufferSize_)));
        }
        if (this.sockProps_.sendBufferSizeSet_) {
            reference.add(new StringRefAddr(SOCKET_SEND_BUFFER_SIZE, Integer.toString(this.sockProps_.sendBufferSize_)));
        }
        if (this.sockProps_.soLingerSet_) {
            reference.add(new StringRefAddr(SOCKET_LINGER, Integer.toString(this.sockProps_.soLinger_)));
        }
        if (this.sockProps_.soTimeoutSet_) {
            reference.add(new StringRefAddr(SOCKET_TIMEOUT, Integer.toString(this.sockProps_.soTimeout_)));
        }
        if (this.sockProps_.tcpNoDelaySet_) {
            reference.add(new StringRefAddr(SOCKET_TCP_NO_DELAY, this.sockProps_.tcpNoDelay_ ? TRUE_ : FALSE_));
        }
        if (this.dataSourceName_ != null) {
            reference.add(new StringRefAddr(DATASOURCE_NAME, this.dataSourceName_));
        }
        if (this.description_ != null) {
            reference.add(new StringRefAddr(DESCRIPTION, this.description_));
        }
        reference.add(new StringRefAddr(SERVER_NAME, this.getServerName()));
        reference.add(new StringRefAddr(USER, this.getUser()));
        reference.add(new StringRefAddr(KEY_RING_NAME, this.serialKeyRingName_));
        if (this.savePasswordWhenSerialized_) {
            if (this.serialPWBytes_ != null) {
                reference.add(new StringRefAddr(PASSWORD, new String(this.serialPWBytes_)));
            } else {
                reference.add(new StringRefAddr(PASSWORD, null));
            }
            if (this.serialKeyRingPWBytes_ != null) {
                reference.add(new StringRefAddr(KEY_RING_PASSWORD, new String(this.serialKeyRingPWBytes_)));
            } else {
                reference.add(new StringRefAddr(KEY_RING_PASSWORD, null));
            }
        }
        reference.add(new StringRefAddr(SAVE_PASSWORD, this.savePasswordWhenSerialized_ ? TRUE_ : FALSE_));
        return reference;
    }

    public String getRemarks() {
        return this.properties_.getString(19);
    }

    public String getSecondaryUrl() {
        return this.properties_.getString(35);
    }

    public String getSecondaryURL() {
        return this.getSecondaryUrl();
    }

    public String getServerName() {
        return this.as400_.getSystemName();
    }

    public int getServerTraceCategories() {
        return this.properties_.getInt(46);
    }

    public int getServerTrace() {
        return this.getServerTraceCategories();
    }

    public long getSocketTimeout() {
        return this.getSoTimeout();
    }

    public String getSort() {
        return this.properties_.getString(20);
    }

    public String getSortLanguage() {
        return this.properties_.getString(21);
    }

    public String getSortTable() {
        return this.properties_.getString(22);
    }

    public String getSortWeight() {
        return this.properties_.getString(23);
    }

    public String getTimeFormat() {
        return this.properties_.getString(24);
    }

    public String getTimeSeparator() {
        return this.properties_.getString(25);
    }

    public String getTransactionIsolation() {
        return this.properties_.getString(27);
    }

    public String getQaqqiniLibrary() {
        return this.properties_.getString(57);
    }

    public String getQaqqinilib() {
        return this.getQaqqiniLibrary();
    }

    public String getUser() {
        return this.as400_.getUserId();
    }

    public int getXALooselyCoupledSupport() {
        return this.properties_.getInt(70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeConnectionPool() throws SQLException {
        if (!this.dataSourceNameSpecified_) {
            this.logWarning("No datasource name was specified, so connections will not be pooled");
            return;
        }
        Object object = this;
        synchronized (object) {
            this.inUse_ = true;
        }
        if (this.poolManager_ == null) {
            try {
                object = new InitialContext();
                this.cpds_ = (AS400JDBCManagedConnectionPoolDataSource)object.lookup(this.dataSourceName_);
                if (this.cpds_ == null) {
                    this.logError("Data source name is not bound in JNDI: " + this.dataSourceName_);
                    JDError.throwSQLException(this, "HY010");
                }
                this.getConnectionPoolKey();
                this.poolManager_ = new JDConnectionPoolManager(this, this.cpds_);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
                JDError.throwSQLException(this, "HY010");
            }
        }
        this.poolManagerInitialized_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initializeTransient() {
        Object object;
        this.poolManager_ = null;
        this.poolManagerInitialized_ = false;
        this.defaultConnectionPoolKey_ = null;
        this.connectionKeyNeedsUpdate_ = true;
        this.as400_ = this.isSecure_ ? new SecureAS400() : new AS400();
        if (this.sockProps_.isAnyOptionSet()) {
            this.as400_.setSocketProperties(this.sockProps_);
        }
        if (this.serialServerName_ != null) {
            this.setServerName(this.serialServerName_);
        }
        if (this.serialUserName_ != null) {
            this.setUser(this.serialUserName_);
            if (this.serialPWBytes_ != null && this.serialPWBytes_.length > 0) {
                this.as400_.setPassword(AS400JDBCManagedDataSource.xpwDeconfuse(this.serialPWBytes_));
            }
        }
        try {
            if (this.serialKeyRingName_ != null && this.isSecure_) {
                if (this.serialKeyRingPWBytes_ != null && this.serialKeyRingPWBytes_.length > 0) {
                    object = AS400JDBCManagedDataSource.xpwDeconfuse(this.serialKeyRingPWBytes_);
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_, (String)object);
                } else {
                    ((SecureAS400)this.as400_).setKeyRingName(this.serialKeyRingName_);
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (this.properties_ != null && !this.isPrompt()) {
                this.as400_.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        object = this;
        synchronized (object) {
            this.inUse_ = false;
        }
    }

    public void invalidate(String string, String string2) {
        this.invalidate(string, string2 == null ? null : AS400JDBCManagedDataSource.xpwConfuse(string2));
    }

    private final void invalidate(String string, char[] cArray) {
        int n = cArray == null ? 0 : AS400JDBCManagedDataSource.xpwDeconfuse(cArray).hashCode();
        JDConnectionPoolKey jDConnectionPoolKey = new JDConnectionPoolKey(string, n);
        if (this.poolManager_ != null) {
            this.poolManager_.invalidate(jDConnectionPoolKey);
        }
    }

    public boolean isAutoCommit() {
        return this.properties_.getBoolean(76);
    }

    public boolean isAutocommitException() {
        return this.properties_.getBoolean(75);
    }

    public boolean isBidiImplicitReordering() {
        return this.properties_.getBoolean(60);
    }

    public boolean isBidiNumericOrdering() {
        return this.properties_.getBoolean(61);
    }

    public boolean isBigDecimal() {
        return this.properties_.getBoolean(37);
    }

    public boolean isCursorHold() {
        return this.properties_.getBoolean(39);
    }

    public boolean isDataCompression() {
        return this.properties_.getBoolean(36);
    }

    public boolean isDataTruncation() {
        return this.properties_.getBoolean(33);
    }

    public boolean isExtendedDynamic() {
        return this.properties_.getBoolean(7);
    }

    public boolean isExtendedMetaData() {
        return this.properties_.getBoolean(48);
    }

    public boolean isExtendedMetadata() {
        return this.isExtendedMetaData();
    }

    public boolean isFullOpen() {
        return this.properties_.getBoolean(45);
    }

    public boolean isHoldInputLocators() {
        return this.properties_.getBoolean(62);
    }

    public boolean isHoldStatements() {
        return this.properties_.getBoolean(63);
    }

    private final synchronized boolean isInUse() {
        return this.inUse_;
    }

    public boolean isJvm16Synchronize() {
        return this.properties_.getBoolean(80);
    }

    public boolean isLazyClose() {
        return this.properties_.getBoolean(40);
    }

    public boolean isPackageAdd() {
        return this.properties_.getBoolean(11);
    }

    public boolean isPackageCache() {
        return this.properties_.getBoolean(12);
    }

    public boolean isPackageClear() {
        return false;
    }

    public boolean isPrefetch() {
        return this.properties_.getBoolean(17);
    }

    public boolean isPrompt() {
        return this.properties_.getBoolean(18);
    }

    public boolean isRollbackCursorHold() {
        return this.properties_.getBoolean(64);
    }

    public boolean isSavePasswordWhenSerialized() {
        return this.savePasswordWhenSerialized_;
    }

    public boolean isSecure() {
        return this.properties_.getBoolean(32);
    }

    public boolean isSecureCurrentUser() {
        return this.properties_.getBoolean(78);
    }

    public boolean isThreadUsed() {
        return this.properties_.getBoolean(38);
    }

    public boolean isTrace() {
        return this.properties_.getBoolean(26);
    }

    public boolean isTranslateBinary() {
        return this.properties_.getBoolean(28);
    }

    public boolean isTranslateBoolean() {
        return this.properties_.getBoolean(71);
    }

    public boolean isTrueAutoCommit() {
        return this.properties_.getBoolean(59);
    }

    public boolean isTrueAutocommit() {
        return this.isTrueAutoCommit();
    }

    void logProperty(String string, String string2) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, string, string2);
        }
    }

    final void logDiagnostic(String string) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string);
            if (this.log_ != null) {
                this.log_.log(string);
            }
        }
    }

    final void logError(String string) {
        String string2 = "ERROR: " + string;
        JDTrace.logInformation(this, string2);
        if (this.log_ != null) {
            this.log_.log(string2);
        }
    }

    final void logException(String string, Exception exception) {
        JDTrace.logException(this, string, exception);
        if (this.log_ != null) {
            this.log_.log(string, exception);
        }
    }

    final void logInformation(String string) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string);
            if (this.log_ != null) {
                this.log_.log(string);
            }
        }
    }

    final void logWarning(String string) {
        String string2 = "WARNING: " + string;
        JDTrace.logInformation(this, string2);
        if (this.log_ != null) {
            this.log_.log(string2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void setAccess(String string) {
        if (string == null) {
            throw new NullPointerException("access");
        }
        this.validateProperty("access", string, 0);
        this.properties_.setString(0, string);
    }

    public void setAutoCommit(boolean bl) {
        if (bl) {
            this.properties_.setString(76, TRUE_);
        } else {
            this.properties_.setString(76, FALSE_);
        }
    }

    public void setAutocommitException(boolean bl) {
        if (bl) {
            this.properties_.setString(75, TRUE_);
        } else {
            this.properties_.setString(75, FALSE_);
        }
    }

    public void setTrueAutoCommit(boolean bl) {
        if (bl) {
            this.properties_.setString(59, TRUE_);
        } else {
            this.properties_.setString(59, FALSE_);
        }
    }

    public void setTrueAutocommit(boolean bl) {
        this.setTrueAutoCommit(bl);
    }

    public void setBehaviorOverride(int n) {
        this.properties_.setString(50, Integer.toString(n));
    }

    public void setBidiStringType(int n) {
        this.validateProperty("bidiStringType", Integer.toString(n), 42);
        this.properties_.setString(42, Integer.toString(n));
    }

    public void setBidiImplicitReordering(boolean bl) {
        if (bl) {
            this.properties_.setString(60, TRUE_);
        } else {
            this.properties_.setString(60, FALSE_);
        }
    }

    public void setBidiNumericOrdering(boolean bl) {
        if (bl) {
            this.properties_.setString(61, TRUE_);
        } else {
            this.properties_.setString(61, FALSE_);
        }
    }

    public void setBigDecimal(boolean bl) {
        if (bl) {
            this.properties_.setString(37, TRUE_);
        } else {
            this.properties_.setString(37, FALSE_);
        }
    }

    public void setBlockCriteria(int n) {
        this.validateProperty("blockCriteria", Integer.toString(n), 2);
        this.properties_.setString(2, Integer.toString(n));
    }

    public void setBlockSize(int n) {
        this.validateProperty("blockSize", Integer.toString(n), 1);
        this.properties_.setString(1, new Integer(n).toString());
    }

    public void setConcurrentAccessResolution(int n) {
        String string = "concurrentAccessResolution";
        this.validateProperty(string, Integer.toString(n), 79);
        this.properties_.setString(79, Integer.toString(n));
    }

    public void setCursorSensitivity(String string) {
        this.validateProperty("cursorSensitivity", string, 49);
        this.properties_.setString(49, string);
    }

    public void setCursorHold(boolean bl) {
        if (bl) {
            this.properties_.setString(39, TRUE_);
        } else {
            this.properties_.setString(39, FALSE_);
        }
    }

    public void setDatabaseName(String string) {
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException("databaseName", 5);
        }
        if (string == null) {
            throw new NullPointerException("databaseName");
        }
        this.properties_.setString(47, string);
        this.connectionKeyNeedsUpdate_ = true;
    }

    public void setDataCompression(boolean bl) {
        if (bl) {
            this.properties_.setString(36, TRUE_);
        } else {
            this.properties_.setString(36, FALSE_);
        }
    }

    public void setDataSourceName(String string) {
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(DATASOURCE_NAME, 5);
        }
        if (string == null) {
            throw new NullPointerException(DATASOURCE_NAME);
        }
        this.dataSourceName_ = string;
        this.dataSourceNameSpecified_ = true;
        this.logProperty(DATASOURCE_NAME, this.dataSourceName_);
    }

    public void setDataTruncation(boolean bl) {
        if (bl) {
            this.properties_.setString(33, TRUE_);
        } else {
            this.properties_.setString(33, FALSE_);
        }
    }

    public void setDateFormat(String string) {
        if (string == null) {
            throw new NullPointerException("dateFormat");
        }
        this.validateProperty("dateFormat", string, 3);
        this.properties_.setString(3, string);
    }

    public void setDateSeparator(String string) {
        if (string == null) {
            throw new NullPointerException("dateSeparator");
        }
        this.validateProperty("dateSeparator", string, 4);
        this.properties_.setString(4, string);
    }

    public void setDecfloatRoundingMode(String string) {
        String string2 = "decfloatRoundingMode";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.validateProperty(string2, string, 74);
        this.getDecfloatRoundingMode();
        this.properties_.setString(74, string);
    }

    public void setDecimalSeparator(String string) {
        if (string == null) {
            throw new NullPointerException("decimalSeparator");
        }
        this.validateProperty("decimalSeparator", string, 5);
        this.properties_.setString(5, string);
    }

    public void setIgnoreWarnings(String string) {
        String string2 = "ignoreWarnings";
        if (string == null) {
            throw new NullPointerException(string2);
        }
        this.properties_.setString(77, string);
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException(DESCRIPTION);
        }
        this.description_ = string;
        this.logProperty(DESCRIPTION, this.description_);
    }

    public void setSort(String string) {
        if (string == null) {
            throw new NullPointerException("sort");
        }
        if (string.equals("job")) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "sort: " + this.getSort() + " (warning: " + this.getSort() + " will be used since sort=job is not valid)");
            }
            return;
        }
        this.validateProperty("sort", string, 20);
        this.properties_.setString(20, string);
    }

    public void setErrors(String string) {
        if (string == null) {
            throw new NullPointerException("errors");
        }
        this.validateProperty("errors", string, 6);
        this.properties_.setString(6, string);
    }

    public void setExtendedDynamic(boolean bl) {
        if (bl) {
            this.properties_.setString(7, TRUE_);
        } else {
            this.properties_.setString(7, FALSE_);
        }
    }

    public void setExtendedMetaData(boolean bl) {
        if (bl) {
            this.properties_.setString(48, TRUE_);
        } else {
            this.properties_.setString(48, FALSE_);
        }
    }

    public void setExtendedMetadata(boolean bl) {
        this.setExtendedMetaData(bl);
    }

    public void setFullOpen(boolean bl) {
        if (bl) {
            this.properties_.setString(45, TRUE_);
        } else {
            this.properties_.setString(45, FALSE_);
        }
    }

    public void setHoldInputLocators(boolean bl) {
        if (bl) {
            this.properties_.setString(62, TRUE_);
        } else {
            this.properties_.setString(62, FALSE_);
        }
    }

    public void setHoldStatements(boolean bl) {
        if (bl) {
            this.properties_.setString(63, TRUE_);
        } else {
            this.properties_.setString(63, FALSE_);
        }
    }

    public void setJvm16Synchronize(boolean bl) {
        if (bl) {
            this.properties_.setString(80, TRUE_);
        } else {
            this.properties_.setString(80, FALSE_);
        }
    }

    public void setLazyClose(boolean bl) {
        if (bl) {
            this.properties_.setString(40, TRUE_);
        } else {
            this.properties_.setString(40, FALSE_);
        }
    }

    public void setLibraries(String string) {
        if (string == null) {
            throw new NullPointerException("libraries");
        }
        this.properties_.setString(8, string);
    }

    public void setLobThreshold(int n) {
        if (n < 0 || n > 0x1000000) {
            throw new ExtendedIllegalArgumentException("threshold", 4);
        }
        this.properties_.setString(31, new Integer(n).toString());
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.properties_.setString(58, Integer.toString(n));
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.writer_ = printWriter;
        this.logProperty("logWriter", this.writer_ == null ? "null" : this.writer_.toString());
        this.log_ = printWriter == null ? null : new EventLog(printWriter);
    }

    public void setMetaDataSource(int n) {
        Integer n2 = new Integer(n);
        this.properties_.setString(72, n2.toString());
    }

    public void setMetadataSource(int n) {
        this.setMetaDataSource(n);
    }

    public void setNaming(String string) {
        if (string == null) {
            throw new NullPointerException("naming");
        }
        this.validateProperty("naming", string, 9);
        this.properties_.setString(9, string);
    }

    public void setPackage(String string) {
        if (string == null) {
            throw new NullPointerException("packageName");
        }
        this.properties_.setString(10, string);
    }

    public void setPackageAdd(boolean bl) {
        if (bl) {
            this.properties_.setString(11, TRUE_);
        } else {
            this.properties_.setString(11, FALSE_);
        }
    }

    public void setPackageCache(boolean bl) {
        if (bl) {
            this.properties_.setString(12, TRUE_);
        } else {
            this.properties_.setString(12, FALSE_);
        }
    }

    public void setPackageClear(boolean bl) {
    }

    public void setPackageCriteria(String string) {
        if (string == null) {
            throw new NullPointerException("packageCriteria");
        }
        this.validateProperty("packageCriteria", string, 30);
        this.properties_.setString(30, string);
    }

    public void setPackageError(String string) {
        if (string == null) {
            throw new NullPointerException("packageError");
        }
        this.validateProperty("packageError", string, 14);
        this.properties_.setString(14, string);
    }

    public void setPackageLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("packageLibrary");
        }
        this.properties_.setString(15, string);
    }

    public void setPassword(String string) {
        if (string == null) {
            throw new NullPointerException("password");
        }
        char[] cArray = AS400JDBCManagedDataSource.xpwConfuse(string);
        if (!Arrays.equals(cArray, this.serialPWBytes_)) {
            this.as400_.setPassword(string);
            this.invalidate(this.getUser(), this.serialPWBytes_);
            this.serialPWBytes_ = cArray;
            this.pwHashcode_ = string.hashCode();
            this.connectionKeyNeedsUpdate_ = true;
        }
        this.logInformation(ResourceBundleLoader.getText("AS400_JDBC_DS_PASSWORD_SET"));
        this.logProperty("password", "***");
    }

    public void setPrefetch(boolean bl) {
        if (bl) {
            this.properties_.setString(17, TRUE_);
        } else {
            this.properties_.setString(17, FALSE_);
        }
    }

    public void setPrompt(boolean bl) {
        if (bl) {
            this.properties_.setString(18, TRUE_);
        } else {
            this.properties_.setString(18, FALSE_);
        }
        try {
            this.as400_.setGuiAvailable(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setProperties(String string) {
        string = "jdbc:as400://dummyhost;" + string;
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string);
        Properties properties = jDDataSourceURL.getProperties();
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        if (JDProperties.isTraceSet(properties, null) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(properties, null) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(properties, null) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties, null) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = JDProperties.getPropertyIndex(string);
            if (n == 47) {
                this.setDatabaseName(string2);
                continue;
            }
            if (n == 29) {
                this.setUser(string2);
                continue;
            }
            if (n == 16) {
                this.setPassword(this.properties_.getString(16));
                continue;
            }
            if (n == 32) {
                this.setSecure(string2.equals(TRUE_));
                continue;
            }
            if (n == 67) {
                this.setKeepAlive(string2.equals(TRUE_));
                continue;
            }
            if (n == 68) {
                this.setReceiveBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (n == 69) {
                this.setSendBufferSize(Integer.parseInt(string2));
                continue;
            }
            if (n == 18) {
                this.setPrompt(string2.equals(TRUE_));
                continue;
            }
            if (n == 43) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Property: " + string + " can only be changed in AS400JDBCManagedDataSource constructor");
                continue;
            }
            if (n == 44) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Property: " + string + " can only be changed in AS400JDBCManagedDataSource constructor");
                continue;
            }
            if (n == -1) continue;
            this.properties_.setString(n, string2);
        }
    }

    public void setProxyServer(String string) {
        if (string == null) {
            throw new NullPointerException("proxyServer");
        }
        this.properties_.setString(34, string);
    }

    public void setQueryOptimizeGoal(int n) {
        String string = "queryOptimizeGoal";
        this.validateProperty(string, Integer.toString(n), 66);
        this.properties_.setString(66, Integer.toString(n));
    }

    public void setQueryTimeoutMechanism(String string) {
        String string2 = "queryTimeoutMechanism";
        String string3 = string;
        this.validateProperty(string2, string3, 84);
        this.properties_.setString(84, string3);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, string2 + ": " + string);
        }
    }

    public void setQueryStorageLimit(int n) {
        String string = "queryStorageLimit";
        if (n < -1 || n > 2147352578) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        this.properties_.setString(73, Integer.toString(n));
    }

    public void setRemarks(String string) {
        if (string == null) {
            throw new NullPointerException("remarks");
        }
        this.validateProperty("remarks", string, 19);
        this.properties_.setString(19, string);
    }

    public void setRollbackCursorHold(boolean bl) {
        if (bl) {
            this.properties_.setString(64, TRUE_);
        } else {
            this.properties_.setString(64, FALSE_);
        }
    }

    public void setSecondaryUrl(String string) {
        if (string == null) {
            throw new NullPointerException("url");
        }
        this.properties_.setString(35, string);
    }

    public void setSecondaryURL(String string) {
        this.setSecondaryUrl(string);
    }

    public void setSecure(boolean bl) {
        if (!bl && this.isSecure_) {
            throw new ExtendedIllegalStateException(SECURE, 5);
        }
        this.isSecure_ = bl;
        if (bl) {
            this.properties_.setString(32, TRUE_);
        } else {
            this.properties_.setString(32, FALSE_);
        }
    }

    public void setSecureCurrentUser(boolean bl) {
        if (bl) {
            this.properties_.setString(78, TRUE_);
        } else {
            this.properties_.setString(78, FALSE_);
        }
    }

    public void setServerName(String string) {
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(SERVER_NAME, 5);
        }
        if (string == null) {
            throw new NullPointerException(SERVER_NAME);
        }
        this.serialServerName_ = string;
        try {
            this.as400_.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.connectionKeyNeedsUpdate_ = true;
        this.logProperty(SERVER_NAME, this.as400_.getSystemName());
    }

    public void setServerTraceCategories(int n) {
        this.properties_.setString(46, Integer.toString(n));
    }

    public void setServerTrace(int n) {
        this.setServerTraceCategories(n);
    }

    public void setDriver(String string) {
        if (string == null) {
            throw new NullPointerException("driver");
        }
        this.validateProperty("driver", string, 41);
        this.properties_.setString(41, string);
    }

    public void setSavePasswordWhenSerialized(boolean bl) {
        this.savePasswordWhenSerialized_ = bl;
        this.logProperty("savePasswordWhenSerialized", String.valueOf(this.savePasswordWhenSerialized_));
    }

    public void setSocketTimeout(int n) {
        this.setSoTimeout(n);
    }

    public void setSortLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("language");
        }
        this.properties_.setString(21, string);
    }

    public void setSortTable(String string) {
        if (string == null) {
            throw new NullPointerException("table");
        }
        this.properties_.setString(22, string);
    }

    public void setSortWeight(String string) {
        if (string == null) {
            throw new NullPointerException("sortWeight");
        }
        this.validateProperty("sortWeight", string, 23);
        this.properties_.setString(23, string);
    }

    public void setThreadUsed(boolean bl) {
        if (bl) {
            this.properties_.setString(38, TRUE_);
        } else {
            this.properties_.setString(38, FALSE_);
        }
    }

    public void setTimeFormat(String string) {
        if (string == null) {
            throw new NullPointerException("timeFormat");
        }
        this.validateProperty("timeFormat", string, 24);
        this.properties_.setString(24, string);
    }

    public void setTimeSeparator(String string) {
        if (string == null) {
            throw new NullPointerException("timeSeparator");
        }
        this.validateProperty("timeSeparator", string, 25);
        this.properties_.setString(25, string);
    }

    public void setTrace(boolean bl) {
        if (bl) {
            this.properties_.setString(26, TRUE_);
        } else {
            this.properties_.setString(26, FALSE_);
        }
        if (bl) {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else {
            JDTrace.setTraceOn(false);
        }
    }

    public void setTransactionIsolation(String string) {
        if (string == null) {
            throw new NullPointerException("transactionIsolation");
        }
        this.validateProperty("transactionIsolation", string, 27);
        this.properties_.setString(27, string);
    }

    public void setTranslateBinary(boolean bl) {
        if (bl) {
            this.properties_.setString(28, TRUE_);
        } else {
            this.properties_.setString(28, FALSE_);
        }
    }

    public void setTranslateBoolean(boolean bl) {
        if (bl) {
            this.properties_.setString(71, TRUE_);
        } else {
            this.properties_.setString(71, FALSE_);
        }
    }

    public void setUser(String string) {
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(USER, 5);
        }
        this.serialUserName_ = string;
        this.properties_.setString(29, string);
        try {
            this.as400_.setUserId(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.connectionKeyNeedsUpdate_ = true;
    }

    public void setXALooselyCoupledSupport(int n) {
        String string = "xaLooselyCoupledSupport";
        this.validateProperty(string, Integer.toString(n), 70);
        this.properties_.setString(70, Integer.toString(n));
    }

    public boolean isKeepAlive() {
        return this.sockProps_.isKeepAlive();
    }

    public int getReceiveBufferSize() {
        return this.sockProps_.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return this.sockProps_.getSendBufferSize();
    }

    public long getSoLinger() {
        return 1000 * this.sockProps_.getSoLinger();
    }

    public long getSoTimeout() {
        return this.sockProps_.getSoTimeout();
    }

    public boolean isTcpNoDelay() {
        return this.sockProps_.isTcpNoDelay();
    }

    public void setKeepAlive(boolean bl) {
        this.sockProps_.setKeepAlive(bl);
        this.logProperty("keepAlive", String.valueOf(bl));
    }

    public void setReceiveBufferSize(int n) {
        this.sockProps_.setReceiveBufferSize(n);
        this.logProperty("receiveBufferSize", Integer.toString(n));
    }

    public void setSendBufferSize(int n) {
        this.sockProps_.setSendBufferSize(n);
        this.logProperty("sendBufferSize", Integer.toString(n));
    }

    public void setSoLinger(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new ExtendedIllegalArgumentException(SOCKET_LINGER, 4);
        }
        this.sockProps_.setSoLinger((int)(l / 1000L));
        this.logProperty(SOCKET_LINGER, Long.toString(l));
    }

    public void setSoTimeout(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new ExtendedIllegalArgumentException(SOCKET_TIMEOUT, 4);
        }
        this.sockProps_.setSoTimeout((int)l);
        this.logProperty(SOCKET_TIMEOUT, Long.toString(l));
    }

    public void setTcpNoDelay(boolean bl) {
        this.sockProps_.setTcpNoDelay(bl);
        this.logProperty("tcpNoDelay", String.valueOf(bl));
    }

    public int getPackageCCSID() {
        return this.properties_.getInt(51);
    }

    public int getPackageCcsid() {
        return this.getPackageCCSID();
    }

    public void setPackageCCSID(int n) {
        this.validateProperty("packageCCSID", Integer.toString(n), 51);
        this.properties_.setString(51, Integer.toString(n));
    }

    public void setPackageCcsid(int n) {
        this.setPackageCCSID(n);
    }

    public int getMinimumDivideScale() {
        return this.properties_.getInt(52);
    }

    public int getMaximumBlockedInputRows() {
        return this.properties_.getInt(83);
    }

    public int getMaximumPrecision() {
        return this.properties_.getInt(53);
    }

    public int getMaximumScale() {
        return this.properties_.getInt(54);
    }

    public void setMinimumDivideScale(int n) {
        this.validateProperty("minimumDivideScale", Integer.toString(n), 52);
        this.properties_.setString(52, Integer.toString(n));
    }

    public void setMaximumBlockedInputRows(int n) {
        this.validateProperty("maximumBlockedInputRows", Integer.toString(n), 83);
        this.properties_.setString(53, Integer.toString(n));
    }

    public void setMaximumPrecision(int n) {
        this.validateProperty("maximumPrecision", Integer.toString(n), 53);
        this.properties_.setString(53, Integer.toString(n));
    }

    public void setMaximumScale(int n) {
        this.validateProperty("maximumScale", Integer.toString(n), 54);
        this.properties_.setString(54, Integer.toString(n));
    }

    public String getTranslateHex() {
        return this.properties_.getString(55);
    }

    public void setTranslateHex(String string) {
        this.validateProperty("translateHex", string, 55);
        this.properties_.setString(55, string);
    }

    public void setQaqqiniLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("qaqqiniLibrary");
        }
        this.properties_.setString(57, string);
    }

    public void setQaqqinilib(String string) {
        this.setQaqqiniLibrary(string);
    }

    public String getToolboxTraceCategory() {
        return this.properties_.getString(56);
    }

    public String getToolboxTrace() {
        return this.getToolboxTraceCategory();
    }

    public void setToolboxTraceCategory(String string) {
        this.validateProperty("toolboxTrace", string, 56);
        this.properties_.setString(56, string);
    }

    public void setToolboxTrace(String string) {
        this.setToolboxTraceCategory(string);
    }

    private final void validateProperty(String string, String string2, int n) {
        if (string2.length() != 0) {
            DriverPropertyInfo[] driverPropertyInfoArray = this.properties_.getInfo();
            String[] stringArray = driverPropertyInfoArray[n].choices;
            if (n == 51) {
                try {
                    int n2 = Integer.valueOf(string2);
                    if (n2 < 1) {
                        throw new ExtendedIllegalArgumentException(string, 2);
                    }
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExtendedIllegalArgumentException(string, 2);
                }
            }
            boolean bl = true;
            int n3 = 0;
            while (bl && n3 < stringArray.length) {
                if (string2.equalsIgnoreCase(stringArray[n3])) {
                    bl = false;
                    continue;
                }
                ++n3;
            }
            if (bl) {
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.savePasswordWhenSerialized_) {
            this.serialPWBytes_ = null;
            this.pwHashcode_ = 0;
            this.serialKeyRingPWBytes_ = null;
        }
        objectOutputStream.defaultWriteObject();
    }

    public String toString() {
        return this.getDataSourceName();
    }

    private static final char[] xpwConfuse(String string) {
        Random random = new Random();
        byte[] byArray = new byte[18];
        random.nextBytes(byArray);
        char[] cArray = BinaryConverter.byteArrayToCharArray(byArray);
        byte[] byArray2 = new byte[14];
        random.nextBytes(byArray2);
        char[] cArray2 = BinaryConverter.byteArrayToCharArray(byArray2);
        char[] cArray3 = AS400JDBCManagedDataSource.xencode(cArray, cArray2, string.toCharArray());
        char[] cArray4 = new char[string.length() + 16];
        System.arraycopy(cArray, 0, cArray4, 0, 9);
        System.arraycopy(cArray2, 0, cArray4, 9, 7);
        System.arraycopy(cArray3, 0, cArray4, 16, string.length());
        return cArray4;
    }

    private static final String xpwDeconfuse(char[] cArray) {
        char[] cArray2 = new char[9];
        System.arraycopy(cArray, 0, cArray2, 0, 9);
        char[] cArray3 = new char[7];
        System.arraycopy(cArray, 9, cArray3, 0, 7);
        char[] cArray4 = new char[cArray.length - 16];
        System.arraycopy(cArray, 16, cArray4, 0, cArray.length - 16);
        return new String(AS400JDBCManagedDataSource.xdecode(cArray2, cArray3, cArray4));
    }

    private static final char[] xencode(char[] cArray, char[] cArray2, char[] cArray3) {
        int n;
        if (cArray3 == null) {
            return null;
        }
        int n2 = cArray3.length;
        char[] cArray4 = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray3[n] + cArray[n % 9]);
        }
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray4[n] ^ cArray2[n % 7]);
        }
        return cArray4;
    }

    private static final char[] xdecode(char[] cArray, char[] cArray2, char[] cArray3) {
        int n;
        int n2 = cArray3.length;
        char[] cArray4 = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray2[n % 7] ^ cArray3[n]);
        }
        for (n = 0; n < n2; ++n) {
            cArray4[n] = (char)(cArray4[n] - cArray[n % 9]);
        }
        return cArray4;
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCManagedDataSource", "javax.sql.DataSource"};
    }
}

