/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;

class DBVariableData
implements DBData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int headerCurOffsetToHost_ = -1;
    private int indicatorCurOffsetToHost_ = -1;
    private int dataCurOffsetToHost_ = -1;
    private int headerTotalSizeToHost_ = -1;
    private int indicatorTotalSizeToHost_ = -1;
    private int dataTotalSizeToHost_ = -1;
    private int offset_ = -1;
    private boolean vlfCompressed_ = false;
    private int rowCount_ = -1;
    private int columnCount_ = -1;
    private int indicatorSize_ = -1;
    private final int actual382fInArrayStart_ = 4;
    private final int actual3901OutArrayStart_ = 4;
    private int headerOffsetFromHost_ = -1;
    private int indicatorOffsetFromHost_ = -1;
    private int dataOffsetFromHost_ = -1;
    private int lengthFromHost_ = -1;
    private int[] indicatorOffsetsFromHost_ = null;
    private int[] dataOffsetsFromHost_ = null;
    private int[] indicatorCountsFromHost_ = null;
    private int[] dataLengthsFromHost_ = null;
    private int[] dataIsArrayFromHost_ = null;
    private int[] dataIsNullArrayFromHost_ = null;

    public DBVariableData() {
    }

    public DBVariableData(int n, int n2, int n3, int n4, int n5) throws DBDataStreamException {
        this.rowCount_ = 1;
        this.columnCount_ = n;
        this.indicatorSize_ = 2;
        this.headerTotalSizeToHost_ = n3;
        this.indicatorTotalSizeToHost_ = n4;
        this.dataTotalSizeToHost_ = n5;
    }

    public void overlay(byte[] byArray, int n) {
        if (this.rowCount_ == -1) {
            this.offset_ = n;
            this.lengthFromHost_ = 0;
            int n2 = 0;
            this.columnCount_ = BinaryConverter.byteArrayToShort(byArray, this.offset_ + 4);
            this.rowCount_ = 1;
            this.indicatorSize_ = 2;
            this.indicatorOffsetsFromHost_ = new int[this.columnCount_];
            this.indicatorCountsFromHost_ = new int[this.columnCount_];
            this.dataOffsetsFromHost_ = new int[this.columnCount_];
            this.dataLengthsFromHost_ = new int[this.columnCount_];
            this.dataIsArrayFromHost_ = new int[this.columnCount_];
            this.dataIsNullArrayFromHost_ = new int[this.columnCount_];
            int n3 = this.offset_ + 4 + 2;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                int n6;
                short s = BinaryConverter.byteArrayToShort(byArray, n3);
                if (s == -26351) {
                    n6 = BinaryConverter.byteArrayToShort(byArray, n3 + 2) == -1 ? 1 : 0;
                    this.dataIsArrayFromHost_[i] = 1;
                    if (n6 != 0) {
                        n3 += 4;
                        this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                        this.indicatorCountsFromHost_[i] = 0;
                        this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1];
                        this.dataLengthsFromHost_[i] = 0;
                        this.dataIsNullArrayFromHost_[i] = -1;
                        continue;
                    }
                    int n7 = BinaryConverter.byteArrayToInt(byArray, n3 + 4);
                    int n8 = BinaryConverter.byteArrayToInt(byArray, n3 + 8);
                    n4 += n7 * n8;
                    n5 += this.indicatorSize_ * n8;
                    this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                    this.indicatorCountsFromHost_[i] = n8;
                    this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1] + this.dataLengthsFromHost_[i - 1];
                    this.dataLengthsFromHost_[i] = n8 * n7;
                    n3 += 12;
                    this.dataIsNullArrayFromHost_[i] = 0;
                    continue;
                }
                if (s != -26350) continue;
                this.dataIsArrayFromHost_[i] = 0;
                n6 = BinaryConverter.byteArrayToInt(byArray, n3 + 4);
                n4 += n6;
                n5 += this.indicatorSize_;
                this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                this.indicatorCountsFromHost_[i] = 1;
                this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1] + this.dataLengthsFromHost_[i - 1];
                this.dataLengthsFromHost_[i] = n6;
                n3 += 8;
            }
            n2 = n3 - this.offset_;
            this.lengthFromHost_ = n2 + n5 + n4;
            this.rawBytes_ = byArray;
            this.headerOffsetFromHost_ = this.offset_;
            this.indicatorOffsetFromHost_ = this.offset_ + n2;
            this.dataOffsetFromHost_ = this.indicatorOffsetFromHost_ + n5;
        } else {
            this.rawBytes_ = byArray;
            this.offset_ = n;
            this.headerCurOffsetToHost_ = this.offset_ + 4;
            this.setColumnCount(this.columnCount_);
            this.indicatorCurOffsetToHost_ = this.offset_ + 4 + this.headerTotalSizeToHost_;
            this.dataCurOffsetToHost_ = this.indicatorCurOffsetToHost_ + this.indicatorTotalSizeToHost_;
        }
    }

    public int getLength() {
        if (this.dataTotalSizeToHost_ == -1) {
            return this.lengthFromHost_;
        }
        return 4 + this.headerTotalSizeToHost_ + this.indicatorTotalSizeToHost_ + this.dataTotalSizeToHost_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public int getColumnCount() {
        return this.columnCount_;
    }

    public int getIndicatorSize() {
        return this.indicatorSize_;
    }

    public int getRowSize() {
        return -1;
    }

    public int getIndicator(int n, int n2) {
        return this.getIndicator(n, n2, -1);
    }

    public int getRowDataOffset(int n) {
        if (this.dataCurOffsetToHost_ == -1) {
            return this.dataOffsetFromHost_;
        }
        return this.dataCurOffsetToHost_;
    }

    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    public void setRowCount(int n) {
    }

    public void setColumnCount(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.headerCurOffsetToHost_);
        this.headerCurOffsetToHost_ += 2;
    }

    public void setIndicatorSize(int n) {
    }

    public void setRowSize(int n) {
    }

    public void setHeaderColumnInfo(int n, short s, short s2, short s3, int n2, short s4) {
        if (s == 10000) {
            if (s2 == 0) {
                BinaryConverter.shortToByteArray((short)-26351, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.shortToByteArray(s3, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.intToByteArray(n2, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 4;
                BinaryConverter.intToByteArray(s4, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 4;
            } else {
                BinaryConverter.shortToByteArray((short)-26351, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.shortToByteArray(s2, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
            }
        } else {
            BinaryConverter.shortToByteArray((short)-26350, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 2;
            BinaryConverter.shortToByteArray(s, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 2;
            BinaryConverter.intToByteArray(n2, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 4;
        }
    }

    public void setIndicator(int n, int n2, int n3) {
        if (n == -1) {
            this.setHeaderColumnInfo(n2, (short)10000, (short)-1, (short)0, 0, (short)0);
        } else {
            BinaryConverter.shortToByteArray((short)n3, this.rawBytes_, this.indicatorCurOffsetToHost_);
            this.indicatorCurOffsetToHost_ += 2;
        }
    }

    public boolean isVariableFieldsCompressed() {
        return false;
    }

    public void resetRowCount(int n) {
    }

    public void setAliasCount(int n) {
    }

    public int getIndicator(int n, int n2, int n3) {
        if (n3 == -1) {
            if (this.dataIsArrayFromHost_[n2] == 0) {
                return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffsetFromHost_ + this.indicatorOffsetsFromHost_[n2]);
            }
            return this.dataIsNullArrayFromHost_[n2];
        }
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffsetFromHost_ + this.indicatorOffsetsFromHost_[n2] + n3 * this.indicatorSize_);
    }

    public int getDataTotalSize(int n) {
        return this.dataLengthsFromHost_[n];
    }

    public int[] getDataLengthsFromHost() {
        return this.dataLengthsFromHost_;
    }

    public int[] getIndicatorCountsFromHost() {
        return this.indicatorCountsFromHost_;
    }
}

