/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrnoException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Date;

public class FileAttributes {
    private AS400 system_;
    private String path_;
    private boolean followSymbolicLink_;
    private boolean attributesRetrieved_ = false;
    String objectType_;
    long extendedAttributeSize_;
    Date createTime_;
    Date accessTime_;
    Date changeTime_;
    Date modifyTime_;
    boolean storageFree_;
    boolean checkedOut_;
    String checkedOutUser_;
    Date checkOutTime_;
    public static final int LOCAL_OBJECT = 1;
    public static final int REMOTE_OBJECT = 2;
    int localRemote_;
    String objectOwner_;
    String primaryGroup_;
    String authorizationListName_;
    byte[] fileId_;
    short asp_;
    long dataSize_;
    long allocatedSize_;
    Date resetDate_;
    Date lastUsedDate_;
    int daysUsedCount_;
    boolean pcReadOnly_;
    boolean pcHidden_;
    boolean pcSystem_;
    boolean pcArchive_;
    boolean systemArchive_;
    int codePage_;
    public static final int FILE_FORMAT_TYPE1 = 0;
    public static final int FILE_FORMAT_TYPE2 = 1;
    int fileFormat_;
    public static final int UDFS_DEFAULT_TYPE1 = 0;
    public static final int UDFS_DEFAULT_TYPE2 = 1;
    int udfsDefaultFormat_ = 0;
    public static final int UDFS_PREFERRED_STORAGE_UNIT_ANY = 0;
    public static final int UDFS_PREFERRED_STORAGE_UNIT_SSD = 1;
    private int udfsStorageUnit_ = 0;
    boolean allowCheckpointWrite_;
    int ccsid_;
    boolean signed_;
    boolean systemSigned_;
    boolean multipleSignatures_;
    public static final int STORAGE_NORMAL = 0;
    public static final int STORAGE_MINIMIZE = 1;
    public static final int STORAGE_DYNAMIC = 2;
    int diskStorageOption_;
    int mainStorageOption_;
    public static final int DIRECTORY_FORMAT_TYPE1 = 0;
    public static final int DIRECTORY_FORMAT_TYPE2 = 1;
    int directoryFormat_;
    String audit_;
    public static final int SCANNING_NO = 0;
    public static final int SCANNING_YES = 1;
    public static final int SCANNING_CHANGE_ONLY = 2;
    int createObjectScan_;
    int scan_;
    public static final int SCAN_REQUIRED = 0;
    public static final int SCAN_SUCCESS = 1;
    public static final int SCAN_FAILURE = 2;
    public static final int SCAN_PENDING_CONVERSION = 5;
    public static final int SCAN_NOT_REQUIRED = 6;
    int scanStatus_;
    boolean scanSignaturesDifferent_;
    boolean binaryScan_;
    int scanCcsid1_;
    int scanCcsid2_;
    boolean allowSave_;
    boolean restrictedRenameAndUnlink_;
    boolean journalingStatus_;
    public static final int JOURNAL_SUBTREE = 128;
    public static final int JOURNAL_OPTIONAL_ENTRIES = 8;
    public static final int JOURNAL_AFTER_IMAGES = 32;
    public static final int JOURNAL_BEFORE_IMAGES = 64;
    int journalingOptions_;
    byte[] journalIdentifier_;
    String journal_;
    Date lastJournalingStartTime_;
    String startingJournalReceiverForApply_;
    String startingJournalReceiverAspDevice_;
    boolean applyJournaledChangesRequired_;
    boolean rollbackWasEnded_;
    String createObjectAuditing_;
    public static final int SYSTEM_USE_NONE = 0;
    public static final int SYSTEM_USE_VIRTUAL_VOLUME = 1;
    public static final int SYSTEM_USE_NETWORK_SERVER_STORAGE = 2;
    int systemUse_;
    boolean setEffectiveUserId_;
    boolean setEffectiveGroupId_;
    boolean containsTemporaryObjects_;
    boolean temporaryObject_;

    public FileAttributes(AS400 aS400, String string) {
        this(aS400, string, true);
    }

    public FileAttributes(AS400 aS400, String string, boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing FileAttributes object, system: " + aS400 + ", path: " + string + ", followSymbolicLink: " + bl);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.path_ = string;
        this.followSymbolicLink_ = bl;
    }

    private byte[] createPathName() throws IOException {
        Converter converter = new Converter(1200, this.system_);
        byte[] byArray = new byte[32 + this.path_.length() * 2];
        BinaryConverter.intToByteArray(1200, byArray, 0);
        BinaryConverter.intToByteArray(2, byArray, 12);
        BinaryConverter.intToByteArray(this.path_.length() * 2, byArray, 16);
        converter.stringToByteArray("/", byArray, 20, 2);
        converter.stringToByteArray(this.path_, byArray, 32);
        return byArray;
    }

    public String getObjectType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.objectType_;
    }

    public long getExtendedAttributeSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.extendedAttributeSize_;
    }

    public Date getCreateTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createTime_;
    }

    public void setCreateTime(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'createTime' is null.");
            throw new NullPointerException("createTime");
        }
        this.setAttributes(date, (byte)4);
    }

    public Date getAccessTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.accessTime_;
    }

    public void setAccessTime(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'accessTime' is null.");
            throw new NullPointerException("accessTime");
        }
        this.setAttributes(date, (byte)5);
    }

    public Date getChangeTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.changeTime_;
    }

    public Date getModifyTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.modifyTime_;
    }

    public void setModifyTime(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'modifyTime' is null.");
            throw new NullPointerException("modifyTime");
        }
        this.setAttributes(date, (byte)7);
    }

    public boolean isStorageFree() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.storageFree_;
    }

    public boolean isCheckedOut() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkedOut_;
    }

    public String getCheckedOutUser() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkedOutUser_;
    }

    public Date getCheckOutTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.checkOutTime_;
    }

    public int getLocalRemote() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.localRemote_;
    }

    public String getObjectOwner() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.objectOwner_;
    }

    public String getPrimaryGroup() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.primaryGroup_;
    }

    public String getAuthorizationListName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.authorizationListName_;
    }

    public byte[] getFileId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.fileId_;
    }

    public short getAsp() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.asp_;
    }

    public long getDataSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.dataSize_;
    }

    public long getAllocatedSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allocatedSize_;
    }

    public Date getResetDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.resetDate_;
    }

    public Date getLastUsedDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.lastUsedDate_;
    }

    public int getDaysUsedCount() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.daysUsedCount_;
    }

    public boolean isPcReadOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcReadOnly_;
    }

    public void setPcReadOnly(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)17);
    }

    public boolean isPcHidden() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcHidden_;
    }

    public void setPcHidden(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)18);
    }

    public boolean isPcSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcSystem_;
    }

    public void setPcSystem(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)19);
    }

    public boolean isPcArchive() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.pcArchive_;
    }

    public void setPcArchive(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)20);
    }

    public boolean isSystemArchive() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemArchive_;
    }

    public void setSystemArchive(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)21);
    }

    public int getCodePage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.codePage_;
    }

    public void setCodePage(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(n, (byte)22);
    }

    public int getFileFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.fileFormat_;
    }

    public int getUdfsDefaultFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.udfsDefaultFormat_;
    }

    public int getUdfsPreferredStorageUnit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.udfsStorageUnit_;
    }

    public boolean isAllowCheckpointWrite() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allowCheckpointWrite_;
    }

    public void setAllowCheckpointWrite(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)26);
    }

    public int getCcsid() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.ccsid_;
    }

    public void setCcsid(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(n, (byte)27);
    }

    public boolean isSigned() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.signed_;
    }

    public boolean isSystemSigned() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemSigned_;
    }

    public boolean isMultipleSignatures() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.multipleSignatures_;
    }

    public int getDiskStorageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.diskStorageOption_;
    }

    public void setDiskStorageOption(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)n, (byte)31);
    }

    public int getMainStorageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.mainStorageOption_;
    }

    public void setMainStorageOption(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)n, (byte)32);
    }

    public int getDirectoryFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.directoryFormat_;
    }

    public String getAudit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.audit_;
    }

    public int getCreateObjectScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createObjectScan_;
    }

    public void setCreateObjectScan(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)n, (byte)35);
    }

    public int getScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scan_;
    }

    public void setScan(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes((byte)n, (byte)36);
    }

    public int getScanStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanStatus_;
    }

    public boolean isScanSignaturesDifferent() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanSignaturesDifferent_;
    }

    public boolean isBinaryScan() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.binaryScan_;
    }

    public int getScanCcsid1() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanCcsid1_;
    }

    public int getScanCcsid2() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.scanCcsid2_;
    }

    public boolean isAllowSave() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.allowSave_;
    }

    public void setAllowSave(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)38);
    }

    public boolean isRestrictedRenameAndUnlink() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.restrictedRenameAndUnlink_;
    }

    public void setRestrictedRenameAndUnlink(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)39);
    }

    public boolean isJournalingStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalingStatus_;
    }

    public int getJournalingOptions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalingOptions_;
    }

    public byte[] getJournalIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journalIdentifier_;
    }

    public String getJournal() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.journal_;
    }

    public Date getJounalingStartTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getJournalingStartTime();
    }

    public Date getJournalingStartTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.lastJournalingStartTime_;
    }

    public String getStartingJournalReceiverForApply() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.startingJournalReceiverForApply_;
    }

    public String getStartingJournalReceiverAspDevice() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.startingJournalReceiverAspDevice_;
    }

    public boolean isApplyJournaledChangesRequired() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.applyJournaledChangesRequired_;
    }

    public boolean isRollbackWasEnded() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.rollbackWasEnded_;
    }

    public String getCreateObjectAuditing() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.createObjectAuditing_;
    }

    public void setCreateObjectAuditing(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'createObjectAuditing' is null.");
            throw new NullPointerException("createObjectAuditing");
        }
        this.setAttributes(string, (byte)41);
    }

    public int getSystemUse() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.systemUse_;
    }

    public void resetDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[18];
        byArray[7] = -56;
        byArray[11] = 2;
        this.setAttributes(byArray);
    }

    public boolean isSetEffectiveUserId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.setEffectiveUserId_;
    }

    public void setSetEffectiveUserId(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)1, (byte)44);
    }

    public boolean isSetEffectiveGroupId() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.setEffectiveGroupId_;
    }

    public void setSetEffectiveGroupId(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)1, (byte)45);
    }

    public boolean containsTemporaryObjects() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.containsTemporaryObjects_;
    }

    public boolean isTemporaryObject() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.getAttributes();
        return this.temporaryObject_;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        this.getAttributes();
    }

    private void getAttributes() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean bl;
        if (this.attributesRetrieved_) {
            return;
        }
        int n = this.system_.getVRM();
        int n2 = 2048;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, new byte[4]), new ProgramParameter(2, n2), new ProgramParameter(1, BinaryConverter.intToByteArray(n2)), new ProgramParameter(2, 4), new ProgramParameter(2, 4), new ProgramParameter(1, BinaryConverter.intToByteArray(this.followSymbolicLink_ ? 1 : 0))};
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QP0LLIB2.SRVPGM", "Qp0lGetAttr", 1, programParameterArray);
        do {
            int n3;
            bl = false;
            if (!serviceProgramCall.run()) {
                throw new AS400Exception(serviceProgramCall.getMessageList());
            }
            if (serviceProgramCall.getIntegerReturnValue() == -1) {
                n3 = serviceProgramCall.getErrno();
                Trace.log(2, "Get attributes was not successful, errno:", n3);
                throw new ErrnoException(this.system_, n3);
            }
            n3 = BinaryConverter.byteArrayToInt(programParameterArray[4].getOutputData(), 0);
            if (n2 >= n3) continue;
            bl = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Get attributes buffer too small, buffer size provided: " + n2 + ", buffer size needed: " + n3);
            }
            n2 = n3;
            programParameterArray[2] = new ProgramParameter(2, n2);
            programParameterArray[3] = new ProgramParameter(1, BinaryConverter.intToByteArray(n2));
        } while (bl);
        this.attributesRetrieved_ = true;
        Converter converter = new Converter(this.system_.getJobCcsid(), this.system_);
        byte[] byArray = programParameterArray[2].getOutputData();
        int n4 = 0;
        int n5 = -1;
        while (n5 != 0) {
            n5 = BinaryConverter.byteArrayToInt(byArray, n4);
            int n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 8);
            if (n6 != 0) {
                switch (BinaryConverter.byteArrayToInt(byArray, n4 + 4)) {
                    case 0: {
                        this.objectType_ = converter.byteArrayToString(byArray, n4 + 16, 10).trim();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.extendedAttributeSize_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16);
                        break;
                    }
                    case 4: {
                        this.createTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16) * 1000L);
                        break;
                    }
                    case 5: {
                        this.accessTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16) * 1000L);
                        break;
                    }
                    case 6: {
                        this.changeTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16) * 1000L);
                        break;
                    }
                    case 7: {
                        this.modifyTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16) * 1000L);
                        break;
                    }
                    case 8: {
                        this.storageFree_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 9: {
                        this.checkedOut_ = byArray[n4 + 16] == 1;
                        this.checkedOutUser_ = converter.byteArrayToString(byArray, n4 + 17, 10).trim();
                        this.checkOutTime_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 28) * 1000L);
                        break;
                    }
                    case 10: {
                        this.localRemote_ = byArray[n4 + 16];
                        break;
                    }
                    case 11: {
                        this.objectOwner_ = converter.byteArrayToString(byArray, n4 + 16, 10).trim();
                        this.primaryGroup_ = converter.byteArrayToString(byArray, n4 + 26, 10).trim();
                        this.authorizationListName_ = converter.byteArrayToString(byArray, n4 + 36, 10).trim();
                        break;
                    }
                    case 12: {
                        this.fileId_ = new byte[16];
                        System.arraycopy(byArray, n4 + 16, this.fileId_, 0, 16);
                        break;
                    }
                    case 13: {
                        this.asp_ = BinaryConverter.byteArrayToShort(byArray, n4 + 16);
                        break;
                    }
                    case 14: {
                        this.dataSize_ = BinaryConverter.byteArrayToLong(byArray, n4 + 16);
                        break;
                    }
                    case 15: {
                        this.allocatedSize_ = BinaryConverter.byteArrayToLong(byArray, n4 + 16);
                        break;
                    }
                    case 16: {
                        this.resetDate_ = new Date(BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 16) * 1000L);
                        long l = BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 20);
                        this.lastUsedDate_ = l == 0L ? null : new Date(l * 1000L);
                        this.daysUsedCount_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n4 + 24);
                        break;
                    }
                    case 17: {
                        this.pcReadOnly_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 18: {
                        this.pcHidden_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 19: {
                        this.pcSystem_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 20: {
                        this.pcArchive_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 21: {
                        this.systemArchive_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 22: {
                        this.codePage_ = BinaryConverter.byteArrayToInt(byArray, n4 + 16);
                        break;
                    }
                    case 23: {
                        this.fileFormat_ = byArray[n4 + 16];
                        break;
                    }
                    case 24: {
                        this.udfsDefaultFormat_ = byArray[n4 + 16];
                        break;
                    }
                    case 25: {
                        String string;
                        String string2;
                        if (n >= 328448) break;
                        this.journalingStatus_ = byArray[n4 + 16] == 1;
                        this.journalingOptions_ = byArray[n4 + 17] & 0xFF;
                        this.journalIdentifier_ = new byte[10];
                        System.arraycopy(byArray, 18, this.journalIdentifier_, 0, 10);
                        if (byArray[n4 + 28] == 0) {
                            this.journal_ = null;
                        } else {
                            string2 = converter.byteArrayToString(byArray, n4 + 28, 10).trim();
                            string = converter.byteArrayToString(byArray, n4 + 38, 10).trim();
                            this.journal_ = QSYSObjectPathName.toPath(string, string2, "JRN");
                        }
                        long l = BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 48);
                        this.lastJournalingStartTime_ = l == 0L ? null : new Date(l * 1000L);
                        break;
                    }
                    case 26: {
                        this.allowCheckpointWrite_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 27: {
                        this.ccsid_ = BinaryConverter.byteArrayToInt(byArray, n4 + 16);
                        break;
                    }
                    case 28: {
                        this.signed_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 29: {
                        this.systemSigned_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 30: {
                        this.multipleSignatures_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 31: {
                        this.diskStorageOption_ = byArray[n4 + 16];
                        break;
                    }
                    case 32: {
                        this.mainStorageOption_ = byArray[n4 + 16];
                        break;
                    }
                    case 33: {
                        this.directoryFormat_ = byArray[n4 + 16];
                        break;
                    }
                    case 34: {
                        this.audit_ = converter.byteArrayToString(byArray, n4 + 16, 10).trim();
                        break;
                    }
                    case 35: {
                        this.createObjectScan_ = byArray[n4 + 16];
                        break;
                    }
                    case 36: {
                        this.scan_ = byArray[n4 + 16];
                        break;
                    }
                    case 37: {
                        this.scanStatus_ = byArray[n4 + 16];
                        this.scanSignaturesDifferent_ = byArray[n4 + 17] == 1;
                        this.binaryScan_ = byArray[n4 + 18] == 1;
                        this.scanCcsid1_ = BinaryConverter.byteArrayToInt(byArray, n4 + 20);
                        this.scanCcsid2_ = BinaryConverter.byteArrayToInt(byArray, n4 + 24);
                        break;
                    }
                    case 38: {
                        this.allowSave_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 39: {
                        this.restrictedRenameAndUnlink_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 40: {
                        String string;
                        String string2;
                        this.journalingStatus_ = byArray[n4 + 16] == 1;
                        this.journalingOptions_ = byArray[n4 + 17] & 0xFF;
                        this.journalIdentifier_ = new byte[10];
                        System.arraycopy(byArray, 18, this.journalIdentifier_, 0, 10);
                        if (byArray[n4 + 28] == 0) {
                            this.journal_ = null;
                        } else {
                            string2 = converter.byteArrayToString(byArray, n4 + 28, 10).trim();
                            string = converter.byteArrayToString(byArray, n4 + 38, 10).trim();
                            this.journal_ = QSYSObjectPathName.toPath(string, string2, "JRN");
                        }
                        long l = BinaryConverter.byteArrayToUnsignedInt(byArray, n4 + 48);
                        this.lastJournalingStartTime_ = l == 0L ? null : new Date(l * 1000L);
                        string2 = converter.byteArrayToString(byArray, n4 + 52, 10).trim();
                        string = converter.byteArrayToString(byArray, n4 + 62, 10).trim();
                        this.startingJournalReceiverForApply_ = string2.equals("") ? null : QSYSObjectPathName.toPath(string, string2, "JRNRCV");
                        this.startingJournalReceiverAspDevice_ = converter.byteArrayToString(byArray, n4 + 72, 10).trim();
                        this.applyJournaledChangesRequired_ = byArray[n4 + 82] == 1;
                        this.rollbackWasEnded_ = byArray[n4 + 83] == 1;
                        break;
                    }
                    case 41: {
                        this.createObjectAuditing_ = converter.byteArrayToString(byArray, n4 + 16, 10).trim();
                        break;
                    }
                    case 42: {
                        this.systemUse_ = byArray[n4 + 16];
                        break;
                    }
                    case 43: {
                        this.temporaryObject_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 44: {
                        this.containsTemporaryObjects_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 45: {
                        this.udfsStorageUnit_ = byArray[n4 + 16];
                        break;
                    }
                    case 300: {
                        this.setEffectiveUserId_ = byArray[n4 + 16] == 1;
                        break;
                    }
                    case 301: {
                        this.setEffectiveGroupId_ = byArray[n4 + 16] == 1;
                        break;
                    }
                }
            }
            n4 = n5;
        }
    }

    private void setAttributes(String string, byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[26];
        byArray[7] = by;
        byArray[11] = 10;
        for (int i = 16; i < 26; ++i) {
            byArray[i] = 64;
        }
        Converter converter = new Converter(this.system_.getJobCcsid(), this.system_);
        converter.stringToByteArray(string, byArray, 16, 10);
        this.setAttributes(byArray);
    }

    private void setAttributes(byte by, byte by2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[17];
        byArray[7] = by2;
        byArray[11] = 1;
        byArray[16] = by;
        this.setAttributes(byArray);
    }

    private void setAttributes(int n, byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[20];
        byArray[7] = by;
        byArray[11] = 4;
        BinaryConverter.intToByteArray(n, byArray, 16);
        this.setAttributes(byArray);
    }

    private void setAttributes(boolean bl, byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAttributes(bl, (byte)0, by);
    }

    private void setAttributes(boolean bl, byte by, byte by2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[17];
        byArray[6] = by;
        byArray[7] = by2;
        byArray[11] = 1;
        if (bl) {
            byArray[16] = 1;
        }
        this.setAttributes(byArray);
    }

    private void setAttributes(Date date, byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[20];
        byArray[7] = by;
        byArray[11] = 4;
        BinaryConverter.unsignedIntToByteArray(date.getTime() / 1000L, byArray, 16);
        this.setAttributes(byArray);
    }

    private void setAttributes(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, this.createPathName()), new ProgramParameter(2, byArray), new ProgramParameter(1, BinaryConverter.intToByteArray(byArray.length)), new ProgramParameter(1, BinaryConverter.intToByteArray(this.followSymbolicLink_ ? 1 : 0))};
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QP0LLIB3.SRVPGM", "Qp0lSetAttr", 1, programParameterArray);
        if (!serviceProgramCall.run()) {
            throw new AS400Exception(serviceProgramCall.getMessageList());
        }
        if (serviceProgramCall.getIntegerReturnValue() == -1) {
            int n = serviceProgramCall.getErrno();
            Trace.log(2, "Set attributes was not successful, errno:", n);
            throw new ErrnoException(this.system_, n);
        }
    }
}

