/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCStatementListener;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDEscapeClause;
import com.ibm.as400.access.JDSQLTokenizer;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

class JDSQLStatement {
    static final int TYPE_UNDETERMINED = 0;
    static final int TYPE_OTHER = 1;
    static final int TYPE_SELECT = 2;
    static final int TYPE_CALL = 3;
    static final int TYPE_COMMIT = 4;
    static final int TYPE_ROLLBACK = 5;
    static final int TYPE_CONNECT = 6;
    static final int TYPE_BLOCK_INSERT = 7;
    private static final String AS_ = "AS";
    private static final String CALL_ = "CALL";
    private static final String CALL0_ = "?";
    private static final String CALL1_ = "?=";
    private static final String CALL2_ = "?=CALL";
    static final String COMMA_ = ",";
    private static final String CONNECT_ = "CONNECT";
    private static final String CONNECTION_ = "CONNECTION";
    static final String CROSS_ = "CROSS";
    private static final String CURRENT_ = "CURRENT";
    private static final String DECLARE_ = "DECLARE";
    private static final String DELETE_ = "DELETE";
    private static final String DISCONNECT_ = "DISCONNECT";
    static final String EXCEPTION_ = "EXCEPTION";
    private static final String FETCH_ = "FETCH";
    private static final String FOR_ = "FOR";
    private static final String FROM_ = "FROM";
    static final String INNER_ = "INNER";
    private static final String INSERT_ = "INSERT";
    static final String JOIN_ = "JOIN";
    static final String LEFT_ = "LEFT";
    private static final String LPAREN_ = "(";
    private static final String OF_ = "OF";
    private static final String ONLY_ = "ONLY";
    private static final String READ_ = "READ";
    private static final String RELEASE_ = "RELEASE";
    private static final String ROWS_ = "ROWS";
    private static final String SELECT_ = "SELECT";
    private static final String SET_ = "SET";
    private static final String UPDATE_ = "UPDATE";
    private static final String VALUES_ = "VALUES";
    private static final String WITH_ = "WITH";
    private static final String MERGE_ = "MERGE";
    private boolean canBeBatched_ = false;
    private String correlationName_ = null;
    private String csProcedure_ = null;
    private String csSchema_ = null;
    private boolean hasReturnValueParameter_ = false;
    private boolean isCall_ = false;
    private boolean isDeclare_ = false;
    private boolean isCurrentOf_ = false;
    private boolean isDRDAConnect_ = false;
    private boolean isDRDADisconnect_ = false;
    private boolean isForFetchOrReadOnly_ = false;
    private boolean isForUpdate_ = false;
    private boolean isImmediatelyExecutable_ = false;
    boolean isInsert_ = false;
    private boolean isSelect_ = false;
    private boolean isSet_ = false;
    private boolean isSubSelect_ = false;
    private boolean isPackaged_ = false;
    private boolean isUpdateOrDelete_ = false;
    private int nativeType_ = 1;
    private int numberOfParameters_;
    private String selectTable_ = null;
    private JDSQLTokenizer tokenizer_ = null;
    private String value_;
    private boolean selectTableNotSet_ = true;
    private boolean selectFromInsert_ = false;
    private static final Vector statementListeners_ = new Vector();

    static void addStatementListener(AS400JDBCStatementListener aS400JDBCStatementListener) {
        if (aS400JDBCStatementListener != null) {
            statementListeners_.add(aS400JDBCStatementListener);
        }
    }

    static void removeStatementListener(AS400JDBCStatementListener aS400JDBCStatementListener) {
        if (aS400JDBCStatementListener != null) {
            statementListeners_.remove(aS400JDBCStatementListener);
        }
    }

    JDSQLStatement(String string) throws SQLException {
        this(string, "", false, "default", null);
    }

    JDSQLStatement(String string, String string2, boolean bl, String string3, Connection connection) throws SQLException {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        if (string == null) {
            JDError.throwSQLException("42601");
        }
        if (string.trim().length() == 0) {
            JDError.throwSQLException("43617");
        }
        int n4 = string.length();
        for (n3 = 0; n3 < statementListeners_.size(); ++n3) {
            object2 = (AS400JDBCStatementListener)statementListeners_.elementAt(n3);
            object = object2.modifySQL(connection, string);
            if (object == null) continue;
            string = object;
            if (!JDTrace.isTraceOn()) continue;
            JDTrace.logInformation(this, "SQL statement modified. Result: " + string);
        }
        n3 = Short.MAX_VALUE;
        if (connection != null) {
            int n5 = n3 = ((AS400JDBCConnection)connection).getVRM() >= JDUtilities.vrm540 ? 0x1FFFFF : Short.MAX_VALUE;
        }
        if (n4 > n3) {
            object2 = string;
            object = new JDSQLTokenizer(string, " \t\n\r\f", true, false);
            string = ((JDSQLTokenizer)object).toString();
            if (((String)object2).length() != string.length()) {
                for (n2 = 0; n2 < statementListeners_.size(); ++n2) {
                    AS400JDBCStatementListener aS400JDBCStatementListener = (AS400JDBCStatementListener)statementListeners_.elementAt(n2);
                    aS400JDBCStatementListener.commentsStripped(connection, (String)object2, string);
                }
            }
        }
        this.value_ = bl ? JDEscapeClause.parse(string, string2, ((AS400JDBCConnection)connection).getVRM()) : string;
        this.value_ = AS400BidiTransform.convertSQLToHostCCSID(this.value_, (AS400JDBCConnection)connection);
        this.tokenizer_ = new JDSQLTokenizer(this.value_, " \t\n\r\f", false, false);
        this.numberOfParameters_ = this.tokenizer_.getNumberOfParameters();
        object2 = "";
        while (((String)object2).length() == 0 && this.tokenizer_.hasMoreTokens()) {
            object = this.tokenizer_.nextToken();
            int n6 = ((String)object).length();
            for (n2 = 0; n2 < n6 && ((String)object).charAt(n2) == '('; ++n2) {
            }
            if (n2 >= n6) continue;
            object2 = ((String)object).substring(n2).toUpperCase();
        }
        if (((String)object2).startsWith(SELECT_) || ((String)object2).equals(WITH_) || ((String)object2).startsWith(VALUES_)) {
            this.isSelect_ = true;
            this.nativeType_ = 2;
        } else if (((String)object2).equals(CALL_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
        } else if (((String)object2).equals(CALL0_) || ((String)object2).equals(CALL1_) || ((String)object2).equals(CALL2_)) {
            this.isCall_ = true;
            this.nativeType_ = 3;
            this.hasReturnValueParameter_ = true;
            --this.numberOfParameters_;
        } else if (((String)object2).equals(CONNECT_) || ((String)object2).equals(CONNECTION_) || ((String)object2).equals(DISCONNECT_)) {
            this.nativeType_ = 6;
            if (((String)object2).equals(CONNECT_)) {
                this.isDRDAConnect_ = true;
            } else if (((String)object2).equals(DISCONNECT_)) {
                this.isDRDADisconnect_ = true;
            }
        } else if (((String)object2).equals(RELEASE_)) {
            object = this.value_.toUpperCase();
            n2 = ((String)object).indexOf("SAVEPOINT");
            if (n2 < 0) {
                this.nativeType_ = 6;
            }
        } else if (((String)object2).equals(INSERT_)) {
            int n7;
            this.isInsert_ = true;
            object = this.value_.toUpperCase();
            n2 = ((String)object).indexOf(ROWS_);
            int n8 = ((String)object).length();
            if (n2 != -1) {
                n2 += 4;
                while (n2 < n8 && Character.isWhitespace(((String)object).charAt(n2))) {
                    ++n2;
                }
                if (((String)object).regionMatches(n2, VALUES_, 0, 6)) {
                    this.nativeType_ = 7;
                }
            }
            if ((n7 = ((String)object).indexOf(VALUES_)) != -1) {
                String string4;
                n7 += 6;
                while (n7 < n8 && Character.isWhitespace(((String)object).charAt(n7))) {
                    ++n7;
                }
                int n9 = ((String)object).lastIndexOf(")");
                if (n9 >= 1 && n9 > n7) {
                    string4 = ((String)object).substring(n7 + 1, n9);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ?\n\r\t");
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.canBeBatched_ = true;
                    }
                } else {
                    string4 = ((String)object).substring(n7);
                    if (string4.trim().equals(CALL0_)) {
                        this.canBeBatched_ = true;
                    }
                }
            }
        } else if (((String)object2).equals(UPDATE_) || ((String)object2).equals(DELETE_)) {
            if (((AS400JDBCConnection)connection).getVRM() >= JDUtilities.vrm710 && ((AS400JDBCConnection)connection).doUpdateDeleteBlocking()) {
                this.canBeBatched_ = true;
            }
            this.isUpdateOrDelete_ = true;
        } else if (((String)object2).equals(MERGE_)) {
            if (((AS400JDBCConnection)connection).getVRM() >= JDUtilities.vrm710) {
                this.canBeBatched_ = true;
            }
        } else if (((String)object2).equals(DECLARE_)) {
            this.isDeclare_ = true;
        } else if (((String)object2).equals(SET_)) {
            this.isSet_ = true;
            this.nativeType_ = 0;
        }
        if (this.isCall_) {
            int n10;
            while (this.tokenizer_.hasMoreTokens() && !((String)object2).endsWith(CALL_)) {
                object2 = this.tokenizer_.nextToken().toUpperCase();
            }
            object = this.tokenizer_.nextToken();
            n2 = ((String)object).indexOf(40);
            if (n2 != -1) {
                object = ((String)object).substring(0, n2);
            }
            String string5 = ((AS400JDBCConnection)connection).getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
            Object object3 = null;
            StringBuffer stringBuffer = null;
            int n11 = -1;
            int n12 = ((String)object).indexOf(string5);
            if (((String)object).indexOf(34) == -1 && n12 > 0 && n12 < ((String)object).length() - 1) {
                object3 = object;
            } else if (((String)object).endsWith(string5)) {
                if (this.tokenizer_.hasMoreTokens()) {
                    stringBuffer = new StringBuffer((String)object);
                    stringBuffer.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(string5)) {
                n11 = ((String)object).length();
                stringBuffer = new StringBuffer((String)object);
                stringBuffer.append(this.tokenizer_.nextToken());
                if (this.tokenizer_.hasMoreTokens()) {
                    stringBuffer.append(this.tokenizer_.nextToken());
                }
            } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(string5)) {
                n11 = ((String)object).length();
                stringBuffer = new StringBuffer((String)object);
                stringBuffer.append(this.tokenizer_.nextToken());
            } else {
                object3 = object;
            }
            if (stringBuffer != null && (n10 = ((String)(object3 = stringBuffer.toString())).indexOf(40)) != -1) {
                object3 = ((String)object3).substring(0, n10);
            }
            stringBuffer = null;
            n2 = n11 == -1 ? ((String)object3).indexOf(string5) : n11;
            if (n2 == -1) {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted((String)object3);
                this.csSchema_ = "";
            } else {
                this.csProcedure_ = JDUtilities.upperCaseIfNotQuoted(((String)object3).substring(n2 + 1));
                this.csSchema_ = JDUtilities.upperCaseIfNotQuoted(((String)object3).substring(0, n2));
            }
        }
        boolean bl2 = true;
        while (this.tokenizer_.hasMoreTokens()) {
            String string6 = this.tokenizer_.nextToken().toUpperCase();
            if (this.isInsert_ && string6.equals(SELECT_)) {
                this.isSubSelect_ = true;
            } else if (string6.equals(CURRENT_) && this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(OF_)) {
                this.isCurrentOf_ = true;
            } else if (string6.equals(FOR_)) {
                this.parseFor();
            } else if (this.isSelect_ && string6.equals(FROM_) && this.selectTableNotSet_) {
                this.selectTableNotSet_ = false;
                if (this.tokenizer_.hasMoreTokens() && !(string6 = this.tokenizer_.nextToken()).startsWith(LPAREN_)) {
                    String string7 = ((AS400JDBCConnection)connection).getProperties().getString(9).equalsIgnoreCase("sql") ? "." : "/";
                    if (string6.endsWith(string7)) {
                        StringBuffer stringBuffer = new StringBuffer(string6);
                        if (this.tokenizer_.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = stringBuffer.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().equals(string7)) {
                        StringBuffer stringBuffer = new StringBuffer(string6);
                        stringBuffer.append(this.tokenizer_.nextToken());
                        if (this.tokenizer_.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer_.nextToken());
                        }
                        this.selectTable_ = stringBuffer.toString();
                    } else if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.peekToken().startsWith(string7)) {
                        StringBuffer stringBuffer = new StringBuffer(string6);
                        stringBuffer.append(this.tokenizer_.nextToken());
                        this.selectTable_ = stringBuffer.toString();
                    } else {
                        this.selectTable_ = string6;
                    }
                    if (this.tokenizer_.hasMoreTokens()) {
                        string6 = this.tokenizer_.nextToken().toUpperCase();
                        if (string6.equals(AS_) && this.tokenizer_.hasMoreTokens()) {
                            this.correlationName_ = this.tokenizer_.nextToken().toUpperCase();
                        } else if (string6.equals(FOR_)) {
                            this.parseFor();
                        }
                    }
                }
            } else if (this.isSet_ && bl2 && string6.equals(CONNECTION_)) {
                this.nativeType_ = 6;
            }
            bl2 = false;
        }
        n2 = this.numberOfParameters_ > 0 || this.isInsert_ && this.isSubSelect_ || this.isCurrentOf_ && this.isUpdateOrDelete_ ? 1 : 0;
        this.isImmediatelyExecutable_ = n2 == 0 && !this.isSelect_;
        boolean bl3 = this.isPackaged_ = this.numberOfParameters_ > 0 && !this.isCurrentOf_ && !this.isUpdateOrDelete_ || this.isInsert_ && this.isSubSelect_ || this.isSelect_ && this.isForUpdate_ || this.isDeclare_;
        if (string3.equalsIgnoreCase("select")) {
            boolean bl4 = this.isPackaged_ = this.isPackaged_ || this.isSelect_;
        }
        if (this.hasReturnValueParameter_ && (n = this.value_.toUpperCase().indexOf(CALL_)) != -1) {
            this.value_ = this.value_.substring(n);
        }
        this.value_ = this.value_.trim();
        this.tokenizer_ = null;
    }

    boolean canBatch() {
        return this.canBeBatched_;
    }

    int countParameters() {
        return this.numberOfParameters_;
    }

    String getCorrelationName() {
        return this.correlationName_;
    }

    int getNativeType() {
        return this.nativeType_;
    }

    int getNumOfParameters() {
        return this.numberOfParameters_;
    }

    String getProcedure() {
        return this.csProcedure_;
    }

    String getSchema() {
        return this.csSchema_;
    }

    String getSelectTable() {
        return this.selectTable_;
    }

    boolean hasReturnValueParameter() {
        return this.hasReturnValueParameter_;
    }

    boolean isDRDAConnect() {
        return this.isDRDAConnect_;
    }

    boolean isDRDADisconnect() {
        return this.isDRDADisconnect_;
    }

    boolean isForFetchOnly() {
        return this.isForFetchOrReadOnly_;
    }

    boolean isForUpdate() {
        return this.isForUpdate_;
    }

    boolean isImmediatelyExecutable() {
        return this.isImmediatelyExecutable_;
    }

    boolean isPackaged() {
        return this.isPackaged_;
    }

    boolean isProcedureCall() {
        return this.isCall_;
    }

    boolean isSelect() {
        return this.isSelect_;
    }

    private void parseFor() {
        if (this.tokenizer_.hasMoreTokens()) {
            String string = this.tokenizer_.nextToken().toUpperCase();
            if (string.equals(FETCH_) || string.equals(READ_)) {
                if (this.tokenizer_.hasMoreTokens() && this.tokenizer_.nextToken().equalsIgnoreCase(ONLY_)) {
                    this.isForFetchOrReadOnly_ = true;
                }
            } else if (string.equals(UPDATE_)) {
                this.isForUpdate_ = true;
            }
        }
    }

    public void setNativeType(int n) {
        this.nativeType_ = n;
    }

    public void setSelectFromInsert(boolean bl) {
        this.selectFromInsert_ = bl;
    }

    public boolean isSelectFromInsert() {
        return this.selectFromInsert_;
    }

    public String toString() {
        return this.value_;
    }

    static {
        String string = SystemProperties.getProperty("com.ibm.as400.access.JDBC.statementListeners");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA_);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    JDSQLStatement.addStatementListener((AS400JDBCStatementListener)Class.forName(string2).newInstance());
                    Trace.log(3, "Successfully loaded JDBC statement listener " + string2);
                }
                catch (Throwable throwable) {
                    Trace.log(4, "Error instantiating JDBC statement listener: ", throwable);
                }
            }
        }
    }
}

