/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class ObjectReferences {
    private AS400 system_;
    private String path_;
    private boolean attributesRetrieved_ = false;
    private long referenceCount_;
    private boolean inUseIndicator_;
    private SimpleObjectReferenceTypesStructure simple_;
    private ExtendedObjectReferenceTypesStructure extended_;
    private JobUsingObjectStructure[] jobs_;

    public ObjectReferences(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ObjectReferences object, system: " + aS400 + ", path: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.path_ = string;
    }

    private byte[] createPathName() throws IOException {
        Converter converter = new Converter(1200, this.system_);
        byte[] byArray = new byte[32 + this.path_.length() * 2];
        BinaryConverter.intToByteArray(1200, byArray, 0);
        BinaryConverter.intToByteArray(2, byArray, 12);
        BinaryConverter.intToByteArray(this.path_.length() * 2, byArray, 16);
        converter.stringToByteArray("/", byArray, 20, 2);
        converter.stringToByteArray(this.path_, byArray, 32);
        return byArray;
    }

    public long getAttributeLock() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.attributeLock_;
    }

    public long getCheckedOut() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.checkedOut_;
    }

    public String getCheckedOutUserName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.checkedOutUserName_;
    }

    public long getCurrentDirectory() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.currentDirectory_;
    }

    public long getExecute() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.execute_;
    }

    public long getExecuteShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeShareWithReadersOnly_;
    }

    public long getExecuteShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeShareWithReadersAndWriters_;
    }

    public long getExecuteShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeShareWithWritersOnly_;
    }

    public long getExecuteShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeShareWithNeitherReadersNorWriters_;
    }

    public long getExecuteReadShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeReadShareWithReadersOnly_;
    }

    public long getExecuteReadShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeReadShareWithReadersAndWriters_;
    }

    public long getExecuteReadShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeReadShareWithWritersOnly_;
    }

    public long getExecuteReadShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.executeReadShareWithNeitherReadersNorWriters_;
    }

    public long getFileServerReference() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.fileServerReference_;
    }

    public long getFileServerWorkingDirectory() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.fileServerWorkingDirectory_;
    }

    public boolean isInUseIndicator() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.inUseIndicator_;
    }

    public long getInternalSaveLock() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.internalSaveLock_;
    }

    public long getLinkChangesLock() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.linkChangesLock_;
    }

    public long getReadOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.readOnly_;
    }

    public long getReadOnlyShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readOnlyShareWithReadersOnly_;
    }

    public long getReadOnlyShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readOnlyShareWithReadersAndWriters_;
    }

    public long getReadOnlyShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readOnlyShareWithWritersOnly_;
    }

    public long getReadOnlyShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readOnlyShareWithNeitherReadersNorWriters_;
    }

    public long getReadWrite() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.readWrite_;
    }

    public long getReadWriteShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readWriteShareWithReadersOnly_;
    }

    public long getReadWriteShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readWriteShareWithReadersAndWriters_;
    }

    public long getReadWriteShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readWriteShareWithWritersOnly_;
    }

    public long getReadWriteShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.readWriteShareWithNeitherReadersNorWriters_;
    }

    public long getReferenceCount() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.referenceCount_;
    }

    public long getRootDirectory() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.rootDirectory_;
    }

    public long getSaveLock() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.saveLock_;
    }

    public long getShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.shareWithReadersOnly_;
    }

    public long getShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.shareWithReadersAndWriters_;
    }

    public long getShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.shareWithWritersOnly_;
    }

    public long getShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.shareWithNeitherReadersNorWriters_;
    }

    public long getWriteOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.simple_.writeOnly_;
    }

    public long getWriteOnlyShareWithReadersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.writeOnlyShareWithReadersOnly_;
    }

    public long getWriteOnlyShareWithReadersAndWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.writeOnlyShareWithReadersAndWriters_;
    }

    public long getWriteOnlyShareWithWritersOnly() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.writeOnlyShareWithWritersOnly_;
    }

    public long getWriteOnlyShareWithNeitherReadersNorWriters() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.extended_.writeOnlyShareWithNeitherReadersNorWriters_;
    }

    public JobUsingObjectStructure[] getJobUsingObjectStructures() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve();
        return this.jobs_;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        this.retrieve();
    }

    private void retrieve() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        int n2;
        byte[] byArray;
        boolean bl;
        if (this.attributesRetrieved_) {
            return;
        }
        int n3 = this.system_.getVRM();
        int n4 = 2048;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n4), new ProgramParameter(BinaryConverter.intToByteArray(n4)), new ProgramParameter(new byte[]{-39, -42, -39, -42, -16, -14, -16, -16}), new ProgramParameter(this.createPathName()), new ProgramParameter(new byte[8])};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QP0LROR.PGM", programParameterArray);
        do {
            bl = false;
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray = programParameterArray[0].getOutputData();
            int n5 = BinaryConverter.byteArrayToInt(byArray, 0);
            if (n5 >= (n2 = BinaryConverter.byteArrayToInt(byArray, 4))) continue;
            bl = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieve object references receiver variable too small, bytes returned: " + n5 + ", bytes available: " + n2);
            }
            programParameterArray[0] = new ProgramParameter(n2);
            programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        } while (bl);
        this.attributesRetrieved_ = true;
        Converter converter = new Converter(this.system_.getJobCcsid(), this.system_);
        this.referenceCount_ = BinaryConverter.byteArrayToUnsignedInt(byArray, 8);
        this.inUseIndicator_ = BinaryConverter.byteArrayToInt(byArray, 12) == 1;
        n2 = BinaryConverter.byteArrayToInt(byArray, 16);
        int n6 = BinaryConverter.byteArrayToInt(byArray, 24);
        int n7 = BinaryConverter.byteArrayToInt(byArray, 32);
        int n8 = BinaryConverter.byteArrayToInt(byArray, 36);
        if (Trace.traceOn_ && (n = BinaryConverter.byteArrayToInt(byArray, 40)) > n8) {
            Trace.log(4, "Retrieve object references receiver variable too small, jobs returned: " + n8 + ", jobs available: " + n);
        }
        this.simple_ = new SimpleObjectReferenceTypesStructure(byArray, n2, converter);
        this.extended_ = new ExtendedObjectReferenceTypesStructure(byArray, n6, converter);
        this.jobs_ = new JobUsingObjectStructure[n8];
        for (n = 0; n < n8; ++n) {
            this.jobs_[n] = new JobUsingObjectStructure(byArray, n7, converter, n3);
            n7 += this.jobs_[n].displacementToNextJobEntry_;
        }
    }

    private static final class ExtendedObjectReferenceTypesStructure {
        long readOnlyShareWithReadersOnly_;
        long readOnlyShareWithWritersOnly_;
        long readOnlyShareWithReadersAndWriters_;
        long readOnlyShareWithNeitherReadersNorWriters_;
        long writeOnlyShareWithReadersOnly_;
        long writeOnlyShareWithWritersOnly_;
        long writeOnlyShareWithReadersAndWriters_;
        long writeOnlyShareWithNeitherReadersNorWriters_;
        long readWriteShareWithReadersOnly_;
        long readWriteShareWithWritersOnly_;
        long readWriteShareWithReadersAndWriters_;
        long readWriteShareWithNeitherReadersNorWriters_;
        long executeShareWithReadersOnly_;
        long executeShareWithWritersOnly_;
        long executeShareWithReadersAndWriters_;
        long executeShareWithNeitherReadersNorWriters_;
        long executeReadShareWithReadersOnly_;
        long executeReadShareWithWritersOnly_;
        long executeReadShareWithReadersAndWriters_;
        long executeReadShareWithNeitherReadersNorWriters_;
        long currentDirectory_;
        long rootDirectory_;
        long fileServerReference_;
        long fileServerWorkingDirectory_;

        ExtendedObjectReferenceTypesStructure(byte[] byArray, int n, Converter converter) {
            this.readOnlyShareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n);
            this.readOnlyShareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 4);
            this.readOnlyShareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 8);
            this.readOnlyShareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 12);
            this.writeOnlyShareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 16);
            this.writeOnlyShareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 20);
            this.writeOnlyShareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 24);
            this.writeOnlyShareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 28);
            this.readWriteShareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 32);
            this.readWriteShareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 36);
            this.readWriteShareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 40);
            this.readWriteShareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 44);
            this.executeShareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 48);
            this.executeShareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 52);
            this.executeShareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 56);
            this.executeShareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 60);
            this.executeReadShareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 64);
            this.executeReadShareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 68);
            this.executeReadShareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 72);
            this.executeReadShareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 76);
            this.currentDirectory_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 96);
            this.rootDirectory_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 100);
            this.fileServerReference_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 104);
            this.fileServerWorkingDirectory_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 108);
        }
    }

    public static class JobUsingObjectStructure {
        private int displacementToNextJobEntry_;
        private String jobName_;
        private String jobUser_;
        private String jobNumber_;
        private SimpleObjectReferenceTypesStructure jobSimple_;
        private ExtendedObjectReferenceTypesStructure jobExtended_;
        private SessionUsingObjectStructure[] sessions_;

        public String getJobName() {
            return this.jobName_;
        }

        public String getJobNumber() {
            return this.jobNumber_;
        }

        public String getJobUser() {
            return this.jobUser_;
        }

        public long getAttributeLock() {
            return this.jobSimple_.attributeLock_;
        }

        public long getCheckedOut() {
            return this.jobSimple_.checkedOut_;
        }

        public String getCheckedOutUserName() {
            return this.jobSimple_.checkedOutUserName_;
        }

        public long getCurrentDirectory() {
            return this.jobExtended_.currentDirectory_;
        }

        public long getExecute() {
            return this.jobSimple_.execute_;
        }

        public long getExecuteShareWithReadersOnly() {
            return this.jobExtended_.executeShareWithReadersOnly_;
        }

        public long getExecuteShareWithReadersAndWriters() {
            return this.jobExtended_.executeShareWithReadersAndWriters_;
        }

        public long getExecuteShareWithWritersOnly() {
            return this.jobExtended_.executeShareWithWritersOnly_;
        }

        public long getExecuteShareWithNeitherReadersNorWriters() {
            return this.jobExtended_.executeShareWithNeitherReadersNorWriters_;
        }

        public long getExecuteReadShareWithReadersOnly() {
            return this.jobExtended_.executeReadShareWithReadersOnly_;
        }

        public long getExecuteReadShareWithReadersAndWriters() {
            return this.jobExtended_.executeReadShareWithReadersAndWriters_;
        }

        public long getExecuteReadShareWithWritersOnly() {
            return this.jobExtended_.executeReadShareWithWritersOnly_;
        }

        public long getExecuteReadShareWithNeitherReadersNorWriters() {
            return this.jobExtended_.executeReadShareWithNeitherReadersNorWriters_;
        }

        public long getFileServerReference() {
            return this.jobExtended_.fileServerReference_;
        }

        public long getFileServerWorkingDirectory() {
            return this.jobExtended_.fileServerWorkingDirectory_;
        }

        public long getInternalSaveLock() {
            return this.jobSimple_.internalSaveLock_;
        }

        public long getLinkChangesLock() {
            return this.jobSimple_.linkChangesLock_;
        }

        public long getReadOnly() {
            return this.jobSimple_.readOnly_;
        }

        public long getReadOnlyShareWithReadersOnly() {
            return this.jobExtended_.readOnlyShareWithReadersOnly_;
        }

        public long getReadOnlyShareWithReadersAndWriters() {
            return this.jobExtended_.readOnlyShareWithReadersAndWriters_;
        }

        public long getReadOnlyShareWithWritersOnly() {
            return this.jobExtended_.readOnlyShareWithWritersOnly_;
        }

        public long getReadOnlyShareWithNeitherReadersNorWriters() {
            return this.jobExtended_.readOnlyShareWithNeitherReadersNorWriters_;
        }

        public long getReadWrite() {
            return this.jobSimple_.readWrite_;
        }

        public long getReadWriteShareWithReadersOnly() {
            return this.jobExtended_.readWriteShareWithReadersOnly_;
        }

        public long getReadWriteShareWithReadersAndWriters() {
            return this.jobExtended_.readWriteShareWithReadersAndWriters_;
        }

        public long getReadWriteShareWithWritersOnly() {
            return this.jobExtended_.readWriteShareWithWritersOnly_;
        }

        public long getReadWriteShareWithNeitherReadersNorWriters() {
            return this.jobExtended_.readWriteShareWithNeitherReadersNorWriters_;
        }

        public long getRootDirectory() {
            return this.jobExtended_.rootDirectory_;
        }

        public long getSaveLock() {
            return this.jobSimple_.saveLock_;
        }

        public long getShareWithReadersOnly() {
            return this.jobSimple_.shareWithReadersOnly_;
        }

        public long getShareWithReadersAndWriters() {
            return this.jobSimple_.shareWithReadersAndWriters_;
        }

        public long getShareWithWritersOnly() {
            return this.jobSimple_.shareWithWritersOnly_;
        }

        public long getShareWithNeitherReadersNorWriters() {
            return this.jobSimple_.shareWithNeitherReadersNorWriters_;
        }

        public long getWriteOnly() {
            return this.jobSimple_.writeOnly_;
        }

        public long getWriteOnlyShareWithReadersOnly() {
            return this.jobExtended_.writeOnlyShareWithReadersOnly_;
        }

        public long getWriteOnlyShareWithReadersAndWriters() {
            return this.jobExtended_.writeOnlyShareWithReadersAndWriters_;
        }

        public long getWriteOnlyShareWithWritersOnly() {
            return this.jobExtended_.writeOnlyShareWithWritersOnly_;
        }

        public long getWriteOnlyShareWithNeitherReadersNorWriters() {
            return this.jobExtended_.writeOnlyShareWithNeitherReadersNorWriters_;
        }

        public SessionUsingObjectStructure[] getSessionUsingObjectStructures() {
            return this.sessions_;
        }

        private JobUsingObjectStructure(byte[] byArray, int n, Converter converter, int n2) {
            int n3 = BinaryConverter.byteArrayToInt(byArray, n);
            int n4 = BinaryConverter.byteArrayToInt(byArray, n + 8);
            int n5 = BinaryConverter.byteArrayToInt(byArray, n + 12);
            this.displacementToNextJobEntry_ = BinaryConverter.byteArrayToInt(byArray, n + 16);
            this.jobName_ = converter.byteArrayToString(byArray, n + 20, 10).trim();
            this.jobUser_ = converter.byteArrayToString(byArray, n + 30, 10).trim();
            this.jobNumber_ = converter.byteArrayToString(byArray, n + 40, 6).trim();
            this.jobSimple_ = new SimpleObjectReferenceTypesStructure(byArray, n + n3, converter);
            this.jobExtended_ = new ExtendedObjectReferenceTypesStructure(byArray, n + n4, converter);
            if (n2 < 328704) {
                this.sessions_ = new SessionUsingObjectStructure[0];
            } else {
                int n6 = BinaryConverter.byteArrayToInt(byArray, n + 48);
                int n7 = BinaryConverter.byteArrayToInt(byArray, n + 52);
                this.sessions_ = new SessionUsingObjectStructure[n7];
                for (int i = 0; i < n7; ++i) {
                    this.sessions_[i] = new SessionUsingObjectStructure(byArray, n + n6, converter);
                    n6 += this.sessions_[i].displacementToNextSessionEntry_;
                }
            }
        }
    }

    public static class SessionUsingObjectStructure {
        private byte[] sessionIdentifier_ = new byte[8];
        private int displacementToNextSessionEntry_;
        private String userName_;
        private String workstationName_;
        private String workstationAddress_;

        public byte[] getSessionIdentifier() {
            return this.sessionIdentifier_;
        }

        public String getUserName() {
            return this.userName_;
        }

        public String getWorkstationAddress() {
            return this.workstationAddress_;
        }

        public String getWorkstationName() {
            return this.workstationName_;
        }

        private SessionUsingObjectStructure(byte[] byArray, int n, Converter converter) {
            System.arraycopy(byArray, n, this.sessionIdentifier_, 0, 8);
            this.displacementToNextSessionEntry_ = BinaryConverter.byteArrayToInt(byArray, n + 8);
            this.userName_ = converter.byteArrayToString(byArray, n + 12, 10).trim();
            this.workstationName_ = converter.byteArrayToString(byArray, n + 22, 15).trim();
            this.workstationAddress_ = converter.byteArrayToString(byArray, n + 37, 45).trim();
        }
    }

    private static final class SimpleObjectReferenceTypesStructure {
        long readOnly_;
        long writeOnly_;
        long readWrite_;
        long execute_;
        long shareWithReadersOnly_;
        long shareWithWritersOnly_;
        long shareWithReadersAndWriters_;
        long shareWithNeitherReadersNorWriters_;
        long attributeLock_;
        long saveLock_;
        long internalSaveLock_;
        long linkChangesLock_;
        long checkedOut_;
        String checkedOutUserName_;

        SimpleObjectReferenceTypesStructure(byte[] byArray, int n, Converter converter) {
            this.readOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n);
            this.writeOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 4);
            this.readWrite_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 8);
            this.execute_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 12);
            this.shareWithReadersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 16);
            this.shareWithWritersOnly_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 20);
            this.shareWithReadersAndWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 24);
            this.shareWithNeitherReadersNorWriters_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 28);
            this.attributeLock_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 32);
            this.saveLock_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 36);
            this.internalSaveLock_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 40);
            this.linkChangesLock_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 44);
            this.checkedOut_ = BinaryConverter.byteArrayToUnsignedInt(byArray, n + 48);
            this.checkedOutUserName_ = converter.byteArrayToString(byArray, n + 52, 10).trim();
        }
    }
}

