/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLClobLocator
implements SQLLocator {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private Object savedObject_;
    private int scale_;

    SQLClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.settings_ = sQLConversionSettings;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || JDUtilities.JDBCLevel_ < 20 || object instanceof Clob)) {
            JDError.throwSQLException(this, "07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof Reader) {
            if (n >= 0) {
                try {
                    int n2 = n < 1000000 ? n : 1000000;
                    Reader reader = (Reader)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[n2];
                    int n3 = 0;
                    int n4 = reader.read(cArray, 0, n2);
                    while (n4 > -1 && n3 < n) {
                        stringBuffer.append(cArray, 0, n4);
                        int n5 = n - (n3 += n4);
                        if (n5 < n2) {
                            n2 = n5;
                        }
                        n4 = reader.read(cArray, 0, n2);
                    }
                    this.value_ = stringBuffer.toString();
                    if (this.value_.length() < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else if (n == -2) {
                try {
                    int n6 = 1000000;
                    Reader reader = (Reader)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[n6];
                    int n7 = 0;
                    int n8 = reader.read(cArray, 0, n6);
                    while (n8 > -1) {
                        stringBuffer.append(cArray, 0, n8);
                        n7 += n8;
                        n8 = reader.read(cArray, 0, n6);
                    }
                    this.value_ = stringBuffer.toString();
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            this.value_ = clob.getSubString(1L, (int)clob.length());
        } else {
            JDError.throwSQLException(this, "07006");
        }
        int n9 = this.value_.length();
        if (n9 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToServer() throws SQLException {
        block42: {
            try {
                Object object = this.savedObject_;
                if (object instanceof String) {
                    String string = (String)object;
                    int n = this.settings_.getBidiStringType();
                    if (n == -1) {
                        n = this.converter_.bidiStringType_;
                    }
                    BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n);
                    bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                    bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                    byte[] byArray = this.converter_.stringToByteArray(string, bidiConversionProperties);
                    this.locator_.writeData(0L, byArray, true);
                    break block42;
                }
                if (object instanceof Reader) {
                    int n = this.scale_;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block42;
                    }
                    if (n > 0) {
                        try {
                            int n2 = n < 1000000 ? n : 1000000;
                            int n3 = this.settings_.getBidiStringType();
                            if (n3 == -1) {
                                n3 = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n3);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                            byte[] byArray = new byte[n2];
                            int n4 = 0;
                            int n5 = readerInputStream.read(byArray, 0, n2);
                            while (n5 > -1 && n4 < n) {
                                this.locator_.writeData(n4, byArray, 0, n5, true);
                                int n6 = n - (n4 += n5);
                                if (n6 < n2) {
                                    n2 = n6;
                                    if (readerInputStream.available() == 0 && n2 != 0) {
                                        readerInputStream.close();
                                        readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                                    }
                                }
                                n5 = readerInputStream.read(byArray, 0, n2);
                            }
                            readerInputStream.close();
                            if (n4 < n) {
                                JDError.throwSQLException(this, "07006");
                            }
                            break block42;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block42;
                    }
                    if (n == -2) {
                        try {
                            int n7 = 1000000;
                            int n8 = this.settings_.getBidiStringType();
                            if (n8 == -1) {
                                n8 = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n8);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n7);
                            byte[] byArray = new byte[n7];
                            int n9 = 0;
                            int n10 = readerInputStream.read(byArray, 0, n7);
                            while (n10 > -1) {
                                this.locator_.writeData(n9, byArray, 0, n10, true);
                                n9 += n10;
                                n10 = readerInputStream.read(byArray, 0, n7);
                            }
                            readerInputStream.close();
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block42;
                    } else {
                        JDError.throwSQLException(this, "07006");
                    }
                    break block42;
                }
                if (object instanceof InputStream) {
                    int n = this.scale_;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block42;
                    }
                    if (n > 0) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n11 = n < 1000000 ? n : 1000000;
                        byte[] byArray = new byte[n11];
                        try {
                            int n12 = 0;
                            int n13 = inputStream.read(byArray, 0, n11);
                            while (n13 > -1 && n12 < n) {
                                this.locator_.writeData(n12, byArray, 0, n13, true);
                                int n14 = n - (n12 += n13);
                                if (n14 < n11) {
                                    n11 = n14;
                                }
                                n13 = inputStream.read(byArray, 0, n11);
                            }
                            if (n12 < n) {
                                JDError.throwSQLException(this, "07006");
                            }
                            break block42;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block42;
                    }
                    if (n == -2) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n15 = 1000000;
                        byte[] byArray = new byte[n15];
                        try {
                            int n16 = 0;
                            int n17 = inputStream.read(byArray, 0, n15);
                            while (n17 > -1) {
                                this.locator_.writeData(n16, byArray, 0, n17, true);
                                n16 += n17;
                                n17 = inputStream.read(byArray, 0, n15);
                            }
                            break block42;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                            break block42;
                        }
                    }
                    JDError.throwSQLException(this, "07006");
                    break block42;
                }
                if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
                    Clob clob;
                    boolean bl = false;
                    if (object instanceof AS400JDBCClobLocator) {
                        clob = (AS400JDBCClobLocator)object;
                        AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                        synchronized (aS400JDBCClobLocator) {
                            if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                                this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                                this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                                ((AS400JDBCClobLocator)clob).savedObject_ = null;
                                this.writeToServer();
                                return;
                            }
                        }
                    }
                    if (!bl) {
                        clob = (Clob)object;
                        int n = (int)clob.length();
                        String string = clob.getSubString(1L, n);
                        this.locator_.writeData(0L, this.converter_.stringToByteArray(string), 0, n, true);
                        bl = true;
                        break block42;
                    } else {
                        JDError.throwSQLException(this, "07006");
                    }
                    break block42;
                }
                JDError.throwSQLException(this, "07006");
            }
            finally {
                this.savedObject_ = null;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 8;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "CLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 964;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "CLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] byArray = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(byArray, byArray.length);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

