/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400UnsignedBin8;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocRoot;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XmlException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.TimeZone;

class PcmlDocument
extends PcmlDocRoot {
    boolean compareSucceeded = true;
    static final long serialVersionUID = -8169008879805188674L;
    private static final String[] PCMLATTRIBUTES = new String[]{"version"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 1;
    private static final String DEFAULT_DATE_SEPARATOR = "hyphen";
    private static final String DEFAULT_TIME_SEPARATOR = "period";
    private String m_docName;
    private String m_XsdName;
    private String m_Version;
    private static AS400Bin2 m_Bin2 = new AS400Bin2();
    private static AS400UnsignedBin2 m_UBin2 = new AS400UnsignedBin2();
    private static AS400Bin4 m_Bin4 = new AS400Bin4();
    private static AS400UnsignedBin4 m_UBin4 = new AS400UnsignedBin4();
    private static AS400Bin8 m_Bin8 = new AS400Bin8();
    private static AS400UnsignedBin8 m_UBin8 = new AS400UnsignedBin8();
    private static AS400Float4 m_Float4 = new AS400Float4();
    private static AS400Float8 m_Float8 = new AS400Float8();
    private static AS400PackedDecimal m_Packed_15_5 = new AS400PackedDecimal(15, 5);
    private static AS400ZonedDecimal m_Zoned_15_5 = new AS400ZonedDecimal(15, 5);
    private long correlationID_ = 0L;
    protected transient AS400Text m_Text_1 = null;
    protected transient AS400Text m_Text_10 = null;
    protected transient AS400ByteArray m_Byte_1 = null;
    protected transient AS400ByteArray m_Byte_2 = null;
    protected transient AS400ByteArray m_Byte_3 = null;
    protected transient AS400ByteArray m_Byte_4 = null;
    private AS400 m_as400;
    private int m_as400Vrm = -1;
    private transient PcmlSpecificationException m_PcmlSpecificationException = null;
    private transient boolean m_bSerializingWithData = false;
    private transient long m_DeserializationTs = 0L;
    private transient PcmlProgram m_pcmlProgram;
    private transient Object correlationIDLock_ = new Object();
    private static final String XMLNS_STRING = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:noNamespaceSchemaLocation=";

    PcmlDocument(PcmlAttributeList pcmlAttributeList, String string) {
        this.setNodeType(1);
        this.m_XmlAttrs = pcmlAttributeList;
        this.m_docName = string;
        this.m_XsdName = "";
        this.m_Version = this.getAttributeValue("version");
    }

    public Object clone() {
        PcmlDocument pcmlDocument = (PcmlDocument)super.clone();
        pcmlDocument.addToHashtable(pcmlDocument);
        return pcmlDocument;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.correlationIDLock_ = new Object();
        this.m_DeserializationTs = this.getCorrelationID();
        objectInputStream.defaultReadObject();
        if (this.m_as400 == null) {
            this.m_as400Vrm = -1;
        }
        this.readObjectPostprocessing();
    }

    AS400 getAs400() {
        return this.m_as400;
    }

    long getDeserializationTimestamp() {
        return this.m_DeserializationTs;
    }

    String[] getAttributeList() {
        return PCMLATTRIBUTES;
    }

    boolean isSerializingWithData() {
        return this.m_bSerializingWithData;
    }

    void setSerializingWithData(boolean bl) {
        this.m_bSerializingWithData = bl;
    }

    int getAs400VRM() throws PcmlException {
        if (this.m_as400Vrm == -1) {
            try {
                this.m_as400Vrm = this.getAs400().getVRM();
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new PcmlException(aS400SecurityException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new PcmlException(unknownHostException);
            }
            catch (IOException iOException) {
                throw new PcmlException(iOException);
            }
        }
        return this.m_as400Vrm;
    }

    String getDocName() {
        return this.m_docName;
    }

    String getVersion() {
        return this.m_Version;
    }

    synchronized void setAs400(AS400 aS400) {
        this.m_as400 = aS400;
        this.m_as400Vrm = -1;
        this.m_Text_1 = null;
        this.m_Text_10 = null;
    }

    protected AS400DataType getConverter(int n, int n2, int n3, int n4, String string, String string2, String string3, String string4) throws PcmlException {
        switch (n) {
            case 1: {
                if (n4 != this.m_as400.getCcsid()) {
                    return new AS400Text(n2, n4, this.m_as400);
                }
                switch (n2) {
                    case 1: {
                        if (this.m_Text_1 == null) {
                            this.m_Text_1 = new AS400Text(n2, n4, this.m_as400);
                        }
                        return this.m_Text_1;
                    }
                    case 10: {
                        if (this.m_Text_10 == null) {
                            this.m_Text_10 = new AS400Text(n2, n4, this.m_as400);
                        }
                        return this.m_Text_10;
                    }
                }
                return new AS400Text(n2, n4, this.m_as400);
            }
            case 2: {
                if (n2 == 2) {
                    if (n3 == 16) {
                        return m_UBin2;
                    }
                    return m_Bin2;
                }
                if (n2 == 4) {
                    if (n3 == 32) {
                        return m_UBin4;
                    }
                    return m_Bin4;
                }
                if (n3 == 64) {
                    return m_UBin8;
                }
                return m_Bin8;
            }
            case 3: {
                if (n2 == 15 && n3 == 5) {
                    return m_Packed_15_5;
                }
                return new AS400PackedDecimal(n2, n3);
            }
            case 4: {
                if (n2 == 15 && n3 == 5) {
                    return m_Zoned_15_5;
                }
                return new AS400ZonedDecimal(n2, n3);
            }
            case 5: {
                if (n2 == 4) {
                    return m_Float4;
                }
                return m_Float8;
            }
            case 6: {
                switch (n2) {
                    case 1: {
                        if (this.m_Byte_1 == null) {
                            this.m_Byte_1 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_1;
                    }
                    case 2: {
                        if (this.m_Byte_2 == null) {
                            this.m_Byte_2 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_2;
                    }
                    case 3: {
                        if (this.m_Byte_3 == null) {
                            this.m_Byte_3 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_3;
                    }
                    case 4: {
                        if (this.m_Byte_4 == null) {
                            this.m_Byte_4 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_4;
                    }
                }
                return new AS400ByteArray(n2);
            }
            case 8: {
                int n5 = AS400Date.toFormat(string);
                if (string2 == null) {
                    return new AS400Date(this.getTimeZone(), n5);
                }
                return new AS400Date(this.getTimeZone(), n5, PcmlNode.separatorAsChar(string2));
            }
            case 9: {
                int n6 = AS400Time.toFormat(string3);
                if (string4 == null) {
                    return new AS400Time(this.getTimeZone(), n6);
                }
                return new AS400Time(this.getTimeZone(), n6, PcmlNode.separatorAsChar(string4));
            }
            case 10: {
                return new AS400Timestamp(this.getTimeZone());
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(n), "*"});
    }

    synchronized boolean callProgram(String string) throws AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException, IOException, PcmlException {
        this.m_pcmlProgram = this.getProgramNode(string);
        return this.m_pcmlProgram.callProgram(this.m_as400);
    }

    synchronized int getErrno(String string) throws PcmlException {
        return this.getProgramNode(string).getErrno();
    }

    synchronized int getIntReturnValue(String string) throws PcmlException {
        return this.getProgramNode(string).getIntReturnValue();
    }

    synchronized int getIntValue(String string) throws PcmlException {
        return this.getIntValue(string, new PcmlDimensions());
    }

    synchronized int getIntValue(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        Object object = this.getValue(string, pcmlDimensions);
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
    }

    synchronized String getStringValue(String string, int n) throws PcmlException {
        return this.getStringValue(string, new PcmlDimensions(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCorrelationID() {
        Object object = this.correlationIDLock_;
        synchronized (object) {
            return ++this.correlationID_;
        }
    }

    synchronized String getStringValue(String string, PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        return this.getDataNode(string).getStringValue(pcmlDimensions, n);
    }

    synchronized int getOutputsize(String string) throws PcmlException {
        return this.getOutputsize(string, new PcmlDimensions());
    }

    synchronized int getOutputsize(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        PcmlDocNode pcmlDocNode = (PcmlDocNode)this.getElement(string);
        if (pcmlDocNode != null && pcmlDocNode instanceof PcmlData) {
            return ((PcmlData)pcmlDocNode).getOutputsize(pcmlDimensions);
        }
        if (pcmlDocNode != null && pcmlDocNode instanceof PcmlStruct) {
            return ((PcmlStruct)pcmlDocNode).getOutputsize(pcmlDimensions);
        }
        return 0;
    }

    synchronized AS400Message[] getMessageList(String string) throws PcmlException {
        return this.getProgramNode(string).getMessageList();
    }

    synchronized ProgramCall getProgramCall() {
        return this.m_pcmlProgram == null ? null : this.m_pcmlProgram.getProgramCall();
    }

    synchronized Object getValue(String string) throws PcmlException {
        return this.getValue(string, new PcmlDimensions());
    }

    synchronized Object getValue(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.getDataNode(string).getValue(pcmlDimensions);
    }

    synchronized boolean isArray(String string) throws PcmlException {
        return this.getDataNode(string).isArray();
    }

    synchronized boolean isInArray(String string) throws PcmlException {
        return this.getDataNode(string).isInArray();
    }

    synchronized void setValue(String string, Object object) throws PcmlException {
        this.setValue(string, object, new PcmlDimensions());
    }

    synchronized void setValue(String string, Object object, PcmlDimensions pcmlDimensions) throws PcmlException {
        this.getDataNode(string).setValue(object, pcmlDimensions);
    }

    synchronized void setStringValue(String string, String string2, int n) throws PcmlException {
        this.setStringValue(string, string2, new PcmlDimensions(), n);
    }

    synchronized void setStringValue(String string, String string2, PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        this.getDataNode(string).setStringValue(string2, pcmlDimensions, n);
    }

    void setThreadsafeOverride(String string, boolean bl) throws PcmlException {
        this.getProgramNode(string).setThreadsafeOverride(bl);
    }

    void setPath(String string, String string2) throws PcmlException {
        this.getProgramNode(string).setPath(string2);
    }

    boolean getThreadsafeOverride(String string) throws PcmlException {
        return this.getProgramNode(string).getThreadsafeOverride();
    }

    void addToHashtable(PcmlDocNode pcmlDocNode) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            String string = pcmlDocNode2.getQualifiedName();
            if (!string.equals("")) {
                if (this.containsElement(string)) {
                    this.addPcmlSpecificationError("MULTIPLE_DEFINE", new Object[]{string});
                }
                this.addElement(pcmlDocNode2);
            }
            this.addToHashtable(pcmlDocNode2);
        }
    }

    private PcmlProgram getProgramNode(String string) throws PcmlException {
        PcmlNode pcmlNode = this.getElement(string);
        if (pcmlNode instanceof PcmlProgram) {
            return (PcmlProgram)pcmlNode;
        }
        if (pcmlNode == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<program>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<program>"});
    }

    private PcmlData getDataNode(String string) throws PcmlException {
        PcmlNode pcmlNode = this.getElement(string);
        if (pcmlNode instanceof PcmlData) {
            return (PcmlData)pcmlNode;
        }
        if (pcmlNode == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
    }

    PcmlSpecificationException getPcmlSpecificationException() {
        return this.m_PcmlSpecificationException;
    }

    void addPcmlSpecificationError(String string, Object[] objectArray) {
        if (this.m_PcmlSpecificationException == null) {
            this.m_PcmlSpecificationException = new PcmlSpecificationException(SystemResourceFinder.format("FAILED_TO_VALIDATE", new Object[]{this.m_docName}));
        }
        this.m_PcmlSpecificationException.addMessage(SystemResourceFinder.format(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateXPCML(String string, OutputStream outputStream) throws IOException, XmlException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions pcmlDimensions = new PcmlDimensions(nArray);
        try {
            printWriter.println("<?xml version=\"1.0\" ?>");
            printWriter.print("<xpcml version=\"6.0\"");
            printWriter.print(XMLNS_STRING);
            if (this.getXsdName() != "") {
                printWriter.println("'" + this.getXsdName() + "' >");
            } else {
                printWriter.println("'xpcml.xsd' >");
            }
            printWriter.println();
            if (string == null) {
                this.generateXPCML(this, this, printWriter, "", n, n2, pcmlDimensions);
            } else {
                this.generateXPCML(this, this.getProgramNode(string), printWriter, "", n, n2, pcmlDimensions);
            }
            printWriter.println("</xpcml>");
            if (printWriter.checkError()) {
                Trace.log(2, "Error when writing PCML to OutputStream.");
            }
        }
        finally {
            printWriter.close();
        }
    }

    private void generateXPCML(PcmlDocument pcmlDocument, PcmlDocNode pcmlDocNode, PrintWriter printWriter, String string, int n, int n2, PcmlDimensions pcmlDimensions) throws IOException, XmlException {
        block393: {
            int n3;
            PcmlDimensions pcmlDimensions2;
            boolean bl;
            String string2;
            block390: {
                block392: {
                    block391: {
                        block389: {
                            block388: {
                                int n4;
                                string2 = "";
                                bl = false;
                                pcmlDimensions2 = new PcmlDimensions();
                                pcmlDimensions2.add(0);
                                if (pcmlDocNode.getNodeType() == 2 || pcmlDocNode.getNodeType() == 1) {
                                    for (n4 = 0; n4 < pcmlDimensions.size(); ++n4) {
                                        pcmlDimensions.set(n4, 0);
                                    }
                                    n2 = 0;
                                    n = 0;
                                }
                                if (pcmlDocNode.getCountReps() == -10) {
                                    n4 = pcmlDocNode.getNodeType();
                                    int n5 = n4 == 4 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) : (n4 == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) : 1);
                                    pcmlDocNode.setCountReps(n5);
                                    pcmlDimensions.set(n2, 0);
                                }
                                if (pcmlDocNode.getNodeType() != 4) break block388;
                                n4 = ((PcmlData)pcmlDocNode).getDataType();
                                switch (n4) {
                                    case 1: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfStringParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfStringParm");
                                                    string2 = "arrayOfStringParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<stringParm");
                                            string2 = "stringParm";
                                        }
                                        break block389;
                                    }
                                    case 7: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfStructParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfStructParm");
                                                    string2 = "arrayOfStructParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<structParm");
                                            string2 = "structParm";
                                        }
                                        break block389;
                                    }
                                    case 6: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfHexBinaryParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfHexBinaryParm");
                                                    string2 = "arrayOfHexBinaryParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<hexBinaryParm");
                                            string2 = "hexBinaryParm";
                                        }
                                        break block389;
                                    }
                                    case 2: {
                                        if (pcmlDocNode.getAttributeValue("length").equals("4")) {
                                            if (pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("32")) {
                                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                    if (pcmlDimensions.at(n2) == 0) {
                                                        if (pcmlDocNode.getCondensedName() != "") {
                                                            printWriter.print(string);
                                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                            string2 = "arrayOfUnsignedIntParm";
                                                        } else {
                                                            printWriter.print(string);
                                                            printWriter.print("<arrayOfUnsignedIntParm");
                                                            string2 = "arrayOfUnsignedIntParm";
                                                        }
                                                    }
                                                } else if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = pcmlDocNode.getCondensedName();
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<unsignedIntParm");
                                                    string2 = "unsignedIntParm";
                                                }
                                            } else if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                if (pcmlDimensions.at(n2) == 0) {
                                                    if (pcmlDocNode.getCondensedName() != "") {
                                                        printWriter.print(string);
                                                        printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                        string2 = "arrayOfIntParm";
                                                    } else {
                                                        printWriter.print(string);
                                                        printWriter.print("<arrayOfIntParm");
                                                        string2 = "arrayOfIntParm";
                                                    }
                                                }
                                            } else if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print(string);
                                                printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                string2 = pcmlDocNode.getCondensedName();
                                            } else {
                                                printWriter.print(string);
                                                printWriter.print("<intParm");
                                                string2 = "intParm";
                                            }
                                        } else if (pcmlDocNode.getAttributeValue("length").equals("2")) {
                                            if (pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("16")) {
                                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                    if (pcmlDimensions.at(n2) == 0) {
                                                        if (pcmlDocNode.getCondensedName() != "") {
                                                            printWriter.print(string);
                                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                            string2 = "arrayOfUnsignedShortParm";
                                                        } else {
                                                            printWriter.print(string);
                                                            printWriter.print("<arrayOfUnsignedShortParm");
                                                            string2 = "arrayOfUnsignedShortParm";
                                                        }
                                                    }
                                                } else if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = pcmlDocNode.getCondensedName();
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<unsignedShortParm");
                                                    string2 = "unsignedShortParm";
                                                }
                                            } else if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                if (pcmlDimensions.at(n2) == 0) {
                                                    if (pcmlDocNode.getCondensedName() != "") {
                                                        printWriter.print(string);
                                                        printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                        string2 = "arrayOfShortParm";
                                                    } else {
                                                        printWriter.print(string);
                                                        printWriter.print("<arrayOfShortParm");
                                                        string2 = "arrayOfShortParm";
                                                    }
                                                }
                                            } else if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print(string);
                                                printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                string2 = pcmlDocNode.getCondensedName();
                                            } else {
                                                printWriter.print(string);
                                                printWriter.print("<shortParm");
                                                string2 = "shortParm";
                                            }
                                        } else if (pcmlDocNode.getAttributeValue("length").equals("8")) {
                                            if (pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("64")) {
                                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                    if (pcmlDimensions.at(n2) == 0) {
                                                        if (pcmlDocNode.getCondensedName() != "") {
                                                            printWriter.print(string);
                                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                            string2 = "arrayOfUnsignedLongParm";
                                                        } else {
                                                            printWriter.print(string);
                                                            printWriter.print("<arrayOfUnsignedLongParm");
                                                            string2 = "arrayOfUnsignedLongParm";
                                                        }
                                                    }
                                                } else if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = pcmlDocNode.getCondensedName();
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<unsignedLongParm");
                                                    string2 = "unsignedLongParm";
                                                }
                                            } else if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                if (pcmlDimensions.at(n2) == 0) {
                                                    if (pcmlDocNode.getCondensedName() != "") {
                                                        printWriter.print(string);
                                                        printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                        string2 = "arrayOfLongParm";
                                                    } else {
                                                        printWriter.print(string);
                                                        printWriter.print("<arrayOfLongParm");
                                                        string2 = "arrayOfLongParm";
                                                    }
                                                }
                                            } else if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print(string);
                                                printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                string2 = pcmlDocNode.getCondensedName();
                                            } else {
                                                printWriter.print(string);
                                                printWriter.print("<longParm");
                                                string2 = "longParm";
                                            }
                                        }
                                        break block389;
                                    }
                                    case 5: {
                                        if (pcmlDocNode.getAttributeValue("length").equals("4")) {
                                            if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                if (pcmlDimensions.at(n2) == 0) {
                                                    if (pcmlDocNode.getCondensedName() != "") {
                                                        printWriter.print(string);
                                                        printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                        string2 = "arrayOfFloatParm";
                                                    } else {
                                                        printWriter.print(string);
                                                        printWriter.print("<arrayOfFloatParm");
                                                        string2 = "arrayOfFloatParm";
                                                    }
                                                }
                                            } else if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print(string);
                                                printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                string2 = pcmlDocNode.getCondensedName();
                                            } else {
                                                printWriter.print(string);
                                                printWriter.print("<floatParm");
                                                string2 = "floatParm";
                                            }
                                        } else if (pcmlDocNode.getAttributeValue("length").equals("8")) {
                                            if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                                if (pcmlDimensions.at(n2) == 0) {
                                                    if (pcmlDocNode.getCondensedName() != "") {
                                                        printWriter.print(string);
                                                        printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                        string2 = "arrayOfDoubleParm";
                                                    } else {
                                                        printWriter.print(string);
                                                        printWriter.print("<arrayOfDoubleParm");
                                                        string2 = "arrayOfDoubleParm";
                                                    }
                                                }
                                            } else if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print(string);
                                                printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                string2 = pcmlDocNode.getCondensedName();
                                            } else {
                                                printWriter.print(string);
                                                printWriter.print("<doubleParm");
                                                string2 = "doubleParm";
                                            }
                                        }
                                        break block389;
                                    }
                                    case 4: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfZonedDecimalParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfZonedDecimalParm");
                                                    string2 = "arrayOfZonedDecimalParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<zonedDecimalParm");
                                            string2 = "zonedDecimalParm";
                                        }
                                        break block389;
                                    }
                                    case 3: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfPackedDecimalParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfPackedDecimalParm");
                                                    string2 = "arrayOfPackedDecimalParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<packedDecimalParm");
                                            string2 = "packedDecimalParm";
                                        }
                                        break block389;
                                    }
                                    case 8: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfDateParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfDateParm");
                                                    string2 = "arrayOfDateParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<dateParm");
                                            string2 = "dateParm";
                                        }
                                        break block389;
                                    }
                                    case 9: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfTimeParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfTimeParm");
                                                    string2 = "arrayOfTimeParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<timeParm");
                                            string2 = "timeParm";
                                        }
                                        break block389;
                                    }
                                    case 10: {
                                        if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                            if (pcmlDimensions.at(n2) == 0) {
                                                if (pcmlDocNode.getCondensedName() != "") {
                                                    printWriter.print(string);
                                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                                    string2 = "arrayOfTimestampParm";
                                                } else {
                                                    printWriter.print(string);
                                                    printWriter.print("<arrayOfTimestampParm");
                                                    string2 = "arrayOfTimestampParm";
                                                }
                                            }
                                        } else if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = pcmlDocNode.getCondensedName();
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<timestampParm");
                                            string2 = "timestampParm";
                                        }
                                        break block389;
                                    }
                                    default: {
                                        throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(n4), "*"});
                                    }
                                }
                            }
                            if (pcmlDocNode.getNodeType() == 3) {
                                if (((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                                    if (pcmlDimensions.at(n2) == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string);
                                            printWriter.print("<" + pcmlDocNode.getCondensedName());
                                            string2 = "arrayOfStruct";
                                        } else {
                                            printWriter.print(string);
                                            printWriter.print("<arrayOfStruct");
                                            string2 = "arrayOfStruct";
                                        }
                                    }
                                } else if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.print(string);
                                    printWriter.print("<" + pcmlDocNode.getCondensedName());
                                    string2 = pcmlDocNode.getCondensedName();
                                } else {
                                    printWriter.print(string);
                                    printWriter.print("<struct");
                                    string2 = "struct";
                                }
                            } else if (pcmlDocNode.getNodeType() == 2) {
                                printWriter.println();
                                printWriter.print(string + "<program");
                                string2 = "program";
                            } else if (pcmlDocNode.getNodeType() == 1) {
                                // empty if block
                            }
                        }
                        String[] stringArray = pcmlDocNode.getAttributeList();
                        if (!(pcmlDocNode.getCondensedName() != "" && !pcmlDocNode.getIsExtendedType() || pcmlDocNode.getNodeType() == 4 && pcmlDimensions.at(n2) > 0 || pcmlDocNode.getNodeType() == 3 && pcmlDimensions.at(n2) > 0)) {
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                if (pcmlDocNode.getAttributeValue(stringArray[n3]) == null) continue;
                                if (stringArray[n3].equals("usage")) {
                                    if (pcmlDocNode.getAttributeValue(stringArray[n3]).equals("input")) {
                                        printWriter.print(" passDirection=\"in\"");
                                        continue;
                                    }
                                    if (pcmlDocNode.getAttributeValue(stringArray[n3]).equals("output")) {
                                        printWriter.print(" passDirection=\"out\"");
                                        continue;
                                    }
                                    if (!pcmlDocNode.getAttributeValue(stringArray[n3]).equals("inputoutput")) continue;
                                    printWriter.print(" passDirection=\"inout\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("passby")) {
                                    printWriter.print(" passMode=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("type") || stringArray[n3].equals("length") && pcmlDocNode.getAttributeValue("type") != null && (pcmlDocNode.getAttributeValue("type").equals("int") || pcmlDocNode.getAttributeValue("type").equals("float"))) continue;
                                if (stringArray[n3].equals("length") && pcmlDocNode.getAttributeValue("type") != null && pcmlDocNode.getAttributeValue("type").equals("byte")) {
                                    printWriter.print(" totalBytes=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("length") && pcmlDocNode.getAttributeValue("type") != null && (pcmlDocNode.getAttributeValue("type").equals("zoned") || pcmlDocNode.getAttributeValue("type").equals("packed"))) {
                                    printWriter.print(" totalDigits=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("precision") && pcmlDocNode.getAttributeValue("type") != null && (pcmlDocNode.getAttributeValue("type").equals("zoned") || pcmlDocNode.getAttributeValue("type").equals("packed"))) {
                                    printWriter.print(" fractionDigits=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("version") || stringArray[n3].equals("init") || stringArray[n3].equals("precision")) continue;
                                if (stringArray[n3].equals("offsetfrom")) {
                                    printWriter.print(" offsetFrom=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("outputsize")) {
                                    printWriter.print(" outputSize=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("bidistringtype")) {
                                    printWriter.print(" bidiStringType=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("chartype")) {
                                    printWriter.print(" bytesPerChar=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("parseorder")) {
                                    printWriter.print(" parseOrder=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("entrypoint")) {
                                    printWriter.print(" entryPoint=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("threadsafe")) {
                                    printWriter.print(" threadSafe=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("returnvalue")) {
                                    printWriter.print(" returnValue=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("dateformat") && pcmlDocNode.getAttributeValue("type") != null && pcmlDocNode.getAttributeValue("type").equals("date")) {
                                    printWriter.print(" dateFormat=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("dateseparator") && pcmlDocNode.getAttributeValue("type") != null && pcmlDocNode.getAttributeValue("type").equals("date")) {
                                    printWriter.print(" dateSeparator=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("timeformat") && pcmlDocNode.getAttributeValue("type") != null && pcmlDocNode.getAttributeValue("type").equals("time")) {
                                    printWriter.print(" timeFormat=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                if (stringArray[n3].equals("timeseparator") && pcmlDocNode.getAttributeValue("type") != null && pcmlDocNode.getAttributeValue("type").equals("time")) {
                                    printWriter.print(" timeSeparator=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                                    continue;
                                }
                                printWriter.print(" " + stringArray[n3] + "=\"" + pcmlDocNode.getAttributeValue(stringArray[n3]) + "\"");
                            }
                        }
                        if (pcmlDocNode.getCountReps() != 0) {
                            pcmlDocNode.setCountReps(pcmlDocNode.getCountReps() - 1);
                        }
                        if (!pcmlDocNode.hasChildren()) break block390;
                        if (pcmlDocNode.getNodeType() != 1 && pcmlDimensions.at(n2) == 0) {
                            printWriter.println(">");
                        }
                        if (pcmlDocNode.getNodeType() == 4 && ((PcmlData)pcmlDocNode).getDataType() == 7 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                            if (pcmlDimensions.at(n2) > 0) {
                                printWriter.println(string + "  <struct_i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">");
                            } else {
                                printWriter.println(string + "  <struct_i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">");
                            }
                            string2 = "struct_i";
                        }
                        if (pcmlDocNode.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                            if (pcmlDimensions.at(n2) > 0) {
                                printWriter.println(string + "  <struct_i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">");
                            } else {
                                printWriter.println(string + "  <struct_i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">");
                            }
                            string2 = "struct_i";
                        }
                        if (pcmlDocNode.getNodeType() == 2) {
                            printWriter.println(string + "<parameterList>");
                        }
                        Enumeration enumeration = pcmlDocNode.getChildren();
                        while (enumeration.hasMoreElements()) {
                            int n6;
                            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
                            if (pcmlDocNode2.getNodeType() == 2) {
                                for (n6 = 0; n6 < pcmlDimensions.size(); ++n6) {
                                    pcmlDimensions.set(n6, 0);
                                }
                                n2 = 0;
                                n = 0;
                            }
                            if (pcmlDocNode2.getNodeType() == 3 && pcmlDocNode2.getParent().getName().trim().length() == 0) {
                                for (n6 = 0; n6 < pcmlDimensions.size(); ++n6) {
                                    pcmlDimensions.set(n6, 0);
                                }
                                n2 = 0;
                                n = 0;
                            }
                            if (pcmlDocNode2.getChildNbr() == 0 && (pcmlDocNode.getNodeType() == 4 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0)) {
                                ++n2;
                                if (++n > 9) {
                                    pcmlDimensions.add(0);
                                }
                            }
                            this.generateXPCML(pcmlDocument, pcmlDocNode2, printWriter, string + "    ", n, n2, pcmlDimensions);
                        }
                        if (pcmlDocNode.getNodeType() == 2) {
                            printWriter.println(string + "</parameterList>");
                        }
                        if (pcmlDocNode.getNodeType() != 4) break block391;
                        int n7 = ((PcmlData)pcmlDocNode).getDataType();
                        printWriter.print(string);
                        switch (n7) {
                            case 1: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</stringParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfStringParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 7: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.println("</structParm>");
                                    }
                                } else {
                                    printWriter.println("  </struct_i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print(string + "</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println(string + "</arrayOfStructParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 6: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</hexBinaryParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfHexBinaryParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 2: {
                                if (pcmlDocNode.getAttributeValue("length").equals("4") && pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("32")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</unsignedIntParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfUnsignedIntParm>");
                                            }
                                        }
                                    }
                                } else if (pcmlDocNode.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</intParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfIntParm>");
                                            }
                                        }
                                    }
                                } else if (pcmlDocNode.getAttributeValue("length").equals("2") && pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("16")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</unsignedShortParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfUnsignedShortParm>");
                                            }
                                        }
                                    }
                                } else if (pcmlDocNode.getAttributeValue("length").equals("2")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</shortParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfShortParm>");
                                            }
                                        }
                                    }
                                } else if (pcmlDocNode.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</longParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfLongParm>");
                                            }
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 5: {
                                if (pcmlDocNode.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</floatParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfFloatParm>");
                                            }
                                        }
                                    }
                                } else if (pcmlDocNode.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.print("</doubleParm>");
                                        }
                                    } else {
                                        printWriter.println("  </i>");
                                        if (pcmlDocNode.getCountReps() == 0) {
                                            if (pcmlDocNode.getCondensedName() != "") {
                                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                            } else {
                                                printWriter.println("</arrayOfDoubleParm>");
                                            }
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 4: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</zonedDecimalParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfZonedDecimalParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 3: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</packedDecimalParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfPackedDecimalParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 8: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</dateParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfDateParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 9: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</timeParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfTimeParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            case 10: {
                                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                                    if (pcmlDocNode.getCondensedName() != "") {
                                        printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                    } else {
                                        printWriter.print("</timestampParm>");
                                    }
                                } else {
                                    printWriter.println("  </i>");
                                    if (pcmlDocNode.getCountReps() == 0) {
                                        if (pcmlDocNode.getCondensedName() != "") {
                                            printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                                        } else {
                                            printWriter.println("</arrayOfTimestampParm>");
                                        }
                                    }
                                }
                                break block392;
                            }
                            default: {
                                throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(n7), "*"});
                            }
                        }
                    }
                    if (pcmlDocNode.getNodeType() == 3) {
                        printWriter.print(string);
                        if (((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) <= 0) {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.print("</" + pcmlDocNode.getCondensedName() + ">");
                            } else {
                                printWriter.println("</struct>");
                            }
                        } else {
                            printWriter.println("  </struct_i>");
                            if (pcmlDocNode.getCountReps() == 0) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.print(string + "</" + pcmlDocNode.getCondensedName() + ">");
                                } else {
                                    printWriter.println(string + "</arrayOfStruct>");
                                }
                            }
                        }
                    } else if (pcmlDocNode.getNodeType() != 1) {
                        printWriter.println(string + "</" + pcmlDocNode.getTagName() + ">");
                    }
                }
                if (pcmlDocNode.getNodeType() == 2) {
                    printWriter.println();
                }
                if (pcmlDocNode.getNodeType() == 4 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                    --n2;
                    --n;
                }
                if (pcmlDocNode.getCountReps() > 0) {
                    Integer n8 = new Integer(0);
                    if (pcmlDocNode.getNodeType() == 4 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0) {
                        n8 = new Integer(((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2));
                    }
                    if (pcmlDocNode.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0) {
                        n8 = new Integer(((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2));
                    }
                    if (pcmlDocNode.getNodeType() != 4 && pcmlDocNode.getNodeType() != 3) {
                        n8 = new Integer(0);
                    }
                    pcmlDimensions.set(n2, n8 - pcmlDocNode.getCountReps());
                    this.generateXPCML(pcmlDocument, pcmlDocNode, printWriter, string, n, n2, pcmlDimensions);
                } else {
                    pcmlDocNode.setCountReps(-10);
                }
                break block393;
            }
            if (pcmlDocNode.getNodeType() == 4 && !pcmlDocNode.getAttributeValue("type").equals("struct")) {
                String string3 = "";
                int[] nArray = new int[]{pcmlDocNode.getCountReps()};
                if (pcmlDocNode.getQualifiedName().trim().equals("")) {
                    string3 = "";
                } else {
                    try {
                        if (pcmlDocNode.getAttributeValue("type").equals("byte")) {
                            int n9 = ((PcmlData)pcmlDocNode).getLength(pcmlDimensions);
                            byte[] byArray = new byte[n9];
                            byArray = (byte[])pcmlDocument.getValue(pcmlDocNode.getQualifiedName(), pcmlDimensions);
                            if (byArray != null) {
                                string3 = BinaryConverter.bytesToString(byArray);
                            }
                        } else {
                            string3 = "";
                            Object object = pcmlDocument.getValue(pcmlDocNode.getQualifiedName(), pcmlDimensions);
                            if (object != null) {
                                string3 = object instanceof Date ? AS400Date.toXsdString(object, this.getTimeZone()) : (object instanceof Time ? AS400Time.toXsdString(object, this.getTimeZone()) : (object instanceof Timestamp ? AS400Timestamp.toXsdString(object, this.getTimeZone()) : object.toString()));
                            }
                        }
                    }
                    catch (PcmlException pcmlException) {
                        Trace.log(7, "No value for node: " + pcmlDocNode.getQualifiedName());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Trace.log(7, "Bad count value for node: " + pcmlDocNode.getQualifiedName());
                    }
                }
                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                    if (string2.equals("arrayOfStringParm") || string2.equals("arrayOfIntParm") || string2.equals("arrayOfLongParm") || string2.equals("arrayOfUnsignedLongParm") || string2.equals("arrayOfUnsignedIntParm") || string2.equals("arrayOfShortParm") || string2.equals("arrayOfUnsignedShortParm") || string2.equals("arrayOfFloatParm") || string2.equals("arrayOfDoubleParm") || string2.equals("arrayOfZonedDecimalParm") || string2.equals("arrayOfPackedDecimalParm") || string2.equals("arrayOfHexBinaryParm") || string2.equals("arrayOfDateParm") || string2.equals("arrayOfTimeParm") || string2.equals("arrayOfTimestampParm")) {
                        printWriter.println(">");
                    }
                    if (pcmlDimensions.at(n2) > 0) {
                        printWriter.print(string + "  <i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">" + string3);
                    } else {
                        printWriter.print(string + "  <i index=" + "\"" + pcmlDimensions.at(n2) + "\"" + ">" + string3);
                    }
                } else {
                    printWriter.print(">" + string3);
                }
                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                    printWriter.println("</i>");
                    bl = true;
                } else {
                    printWriter.println("</" + string2 + ">");
                    bl = true;
                }
            }
            if (!bl) {
                printWriter.println("/>");
            }
            if (pcmlDocNode.getCountReps() > 0) {
                n3 = pcmlDocNode.getNodeType() == 4 && ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) : (pcmlDocNode.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode).getXPCMLCount(pcmlDimensions2) : 0);
                int n10 = n3 - pcmlDocNode.getCountReps();
                pcmlDimensions.set(n2, n3 - pcmlDocNode.getCountReps());
                this.generateXPCML(pcmlDocument, pcmlDocNode, printWriter, string, n, n2, pcmlDimensions);
            } else {
                if (((PcmlData)pcmlDocNode).getXPCMLCount(pcmlDimensions2) > 0) {
                    n3 = ((PcmlData)pcmlDocNode).getDataType();
                    printWriter.print(string);
                    switch (n3) {
                        case 1: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfStringParm>");
                            break;
                        }
                        case 2: {
                            if (pcmlDocNode.getAttributeValue("length").equals("4") && pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("32")) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                    break;
                                }
                                printWriter.println("</arrayOfUnsignedIntParm>");
                                break;
                            }
                            if (pcmlDocNode.getAttributeValue("length").equals("4")) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                    break;
                                }
                                printWriter.println("</arrayOfIntParm>");
                                break;
                            }
                            if (pcmlDocNode.getAttributeValue("length").equals("2") && pcmlDocNode.getAttributeValue("precision") != null && pcmlDocNode.getAttributeValue("precision").equals("16")) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                    break;
                                }
                                printWriter.println("</arrayOfUnsignedShortParm>");
                                break;
                            }
                            if (pcmlDocNode.getAttributeValue("length").equals("2")) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                    break;
                                }
                                printWriter.println("</arrayOfShortParm>");
                                break;
                            }
                            if (!pcmlDocNode.getAttributeValue("length").equals("8")) break;
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfLongParm>");
                            break;
                        }
                        case 5: {
                            if (pcmlDocNode.getAttributeValue("length").equals("8")) {
                                if (pcmlDocNode.getCondensedName() != "") {
                                    printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                    break;
                                }
                                printWriter.println("</arrayOfDoubleParm>");
                                break;
                            }
                            if (!pcmlDocNode.getAttributeValue("length").equals("4")) break;
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfFloatParm>");
                            break;
                        }
                        case 4: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfZonedDecimalParm>");
                            break;
                        }
                        case 3: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfPackedDecimalParm>");
                            break;
                        }
                        case 6: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfHexBinaryParm>");
                            break;
                        }
                        case 8: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfDateParm>");
                            break;
                        }
                        case 9: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfTimeParm>");
                            break;
                        }
                        case 10: {
                            if (pcmlDocNode.getCondensedName() != "") {
                                printWriter.println("</" + pcmlDocNode.getCondensedName() + ">");
                                break;
                            }
                            printWriter.println("</arrayOfTimestampParm>");
                            break;
                        }
                    }
                }
                pcmlDocNode.setCountReps(-10);
            }
        }
        printWriter.flush();
    }

    void setXsdName(String string) {
        this.m_XsdName = string;
    }

    String getXsdName() {
        return this.m_XsdName;
    }

    void copyValues(PcmlDocNode pcmlDocNode, PcmlDocNode pcmlDocNode2) throws IOException, XmlException {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions pcmlDimensions = new PcmlDimensions(nArray);
        String[] stringArray = new String[30];
        String[] stringArray2 = new String[30];
        int n3 = 0;
        this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
    }

    void copyValues(PcmlDocNode pcmlDocNode, PcmlDocNode pcmlDocNode2, int n, int n2, PcmlDimensions pcmlDimensions, String[] stringArray, String[] stringArray2, int n3) throws IOException, XmlException {
        PcmlDimensions pcmlDimensions2 = new PcmlDimensions();
        pcmlDimensions2.add(0);
        if (n3 < 0) {
            n3 = 0;
        }
        if (pcmlDocNode2.getNodeType() == 2 || pcmlDocNode2.getNodeType() == 1) {
            int n4;
            for (n4 = 0; n4 < pcmlDimensions.size(); ++n4) {
                pcmlDimensions.set(n4, 0);
            }
            n2 = 0;
            n = 0;
            for (n4 = 0; n4 < 10; ++n4) {
                stringArray[n4] = "";
                stringArray2[n4] = "";
            }
            n3 = 0;
        }
        if (pcmlDocNode2.getNodeType() == 4 && pcmlDocNode2.getAttributeValue("type").equals("struct")) {
            PcmlDocNode pcmlDocNode3 = (PcmlDocNode)pcmlDocNode2.getParent();
            n3 = pcmlDocNode3.getNodeType() == 4 && pcmlDocNode3.getAttributeValue("type").equals("struct") ? ++n3 : 0;
            stringArray2[n3] = pcmlDocNode2.getName();
            stringArray[n3] = pcmlDocNode2.getAttributeValue("struct");
        }
        if (pcmlDocNode2.getCountReps() == -10) {
            int n5 = pcmlDocNode2.getNodeType();
            int n6 = n5 == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : (n5 == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : 1);
            pcmlDocNode2.setCountReps(n6);
            pcmlDimensions.set(n2, 0);
        }
        if (pcmlDocNode2.getCountReps() != 0) {
            pcmlDocNode2.setCountReps(pcmlDocNode2.getCountReps() - 1);
        }
        if (pcmlDocNode2.hasChildren()) {
            Serializable serializable;
            Enumeration enumeration = pcmlDocNode2.getChildren();
            while (enumeration.hasMoreElements()) {
                int n7;
                serializable = (PcmlDocNode)enumeration.nextElement();
                if (((PcmlDocNode)serializable).getNodeType() == 2) {
                    for (n7 = 0; n7 < pcmlDimensions.size(); ++n7) {
                        pcmlDimensions.set(n7, 0);
                    }
                    n2 = 0;
                    n = 0;
                    for (n7 = 0; n7 < 30; ++n7) {
                        stringArray[n7] = "";
                        stringArray2[n7] = "";
                    }
                    n3 = 0;
                }
                if (((PcmlDocNode)serializable).getNodeType() == 3 && ((PcmlNode)serializable).getParent().getName().trim().length() == 0) {
                    for (n7 = 0; n7 < pcmlDimensions.size(); ++n7) {
                        pcmlDimensions.set(n7, 0);
                    }
                    n2 = 0;
                    n = 0;
                    for (n7 = 0; n7 < 30; ++n7) {
                        stringArray[n7] = "";
                        stringArray2[n7] = "";
                    }
                    n3 = 0;
                }
                if (((PcmlNode)serializable).getChildNbr() == 0 && (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0)) {
                    ++n2;
                    if (++n > 9) {
                        pcmlDimensions.add(0);
                    }
                }
                this.copyValues(pcmlDocNode, (PcmlDocNode)serializable, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            }
            if (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0) {
                --n2;
                --n;
                --n3;
            }
            if (pcmlDocNode2.getCountReps() > 0) {
                serializable = new Integer(0);
                if (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0) {
                    serializable = new Integer(((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2));
                }
                if (pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0) {
                    serializable = new Integer(((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2));
                }
                if (pcmlDocNode2.getNodeType() != 4 && pcmlDocNode2.getNodeType() != 3) {
                    serializable = new Integer(0);
                }
                pcmlDimensions.set(n2, (Integer)serializable - pcmlDocNode2.getCountReps());
                this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            } else {
                pcmlDocNode2.setCountReps(-10);
            }
        } else if (pcmlDocNode2.getNodeType() == 4 && !pcmlDocNode2.getAttributeValue("type").equals("struct")) {
            int n8;
            block39: {
                String string = "";
                String string2 = "";
                int[] nArray = new int[]{pcmlDocNode2.getCountReps()};
                if (pcmlDocNode2.getQualifiedName().trim().equals("")) {
                    Object var13_19 = null;
                } else {
                    try {
                        int n9;
                        Object object = null;
                        if (pcmlDocNode2.getUsage() == 3 || (object = ((PcmlData)pcmlDocNode2).getValue(pcmlDimensions)) != null || (((PcmlDocNode)pcmlDocNode2.getParent()).getNodeType() != 4 || !((PcmlDocNode)pcmlDocNode2.getParent()).getAttributeValue("type").equals("struct")) && ((PcmlDocNode)pcmlDocNode2.getParent()).getNodeType() != 3) break block39;
                        n8 = 0;
                        for (PcmlDocNode pcmlDocNode4 = (PcmlDocNode)pcmlDocNode2.getParent(); pcmlDocNode4 != null && pcmlDocNode4.getNodeType() != 2 && n8 == 0; pcmlDocNode4 = (PcmlDocNode)pcmlDocNode4.getParent()) {
                            if (pcmlDocNode4.getNodeType() != 4 || !pcmlDocNode4.getAttributeValue("type").equals("struct")) continue;
                            n8 = 1;
                        }
                        if (n8 == 0) break block39;
                        String[] stringArray3 = new String[n3 + 1];
                        for (n9 = 0; n9 <= n3; ++n9) {
                            stringArray3[n9] = "";
                        }
                        n9 = 0;
                        for (int i = 0; i <= n3 && n9 == 0; ++i) {
                            stringArray3[i] = stringArray[i];
                            for (int j = i + 1; j <= n3; ++j) {
                                stringArray3[i] = stringArray3[i] + "." + stringArray2[j];
                            }
                            String string3 = pcmlDocNode2.getQualifiedName();
                            String string4 = string3.substring(string3.indexOf(stringArray2[n3]) + stringArray2[n3].length() + 1);
                            stringArray3[i] = stringArray3[i] + "." + string4;
                            String string5 = stringArray3[i];
                            PcmlDocRoot pcmlDocRoot = pcmlDocNode.getRootNode();
                            PcmlData pcmlData = null;
                            try {
                                pcmlData = (PcmlData)pcmlDocRoot.getElement(string5);
                            }
                            catch (NullPointerException nullPointerException) {
                                pcmlData = null;
                            }
                            if (pcmlData == null) continue;
                            int n10 = pcmlData.getNbrOfDimensions();
                            int[] nArray2 = new int[n10];
                            for (int j = 0; j < n10; ++j) {
                                nArray2[j] = pcmlDimensions.at(((PcmlData)pcmlDocNode2).getNbrOfDimensions() - n10 + j);
                            }
                            PcmlDimensions pcmlDimensions3 = new PcmlDimensions(nArray2);
                            object = pcmlData.getValue(pcmlDimensions3);
                            if (object == null) continue;
                            ((PcmlData)pcmlDocNode2).setValue(object, pcmlDimensions);
                            n9 = 1;
                        }
                    }
                    catch (PcmlException pcmlException) {
                        Trace.log(7, "No value for node: " + pcmlDocNode2.getQualifiedName());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Trace.log(7, "Bad count value for node: " + pcmlDocNode2.getQualifiedName());
                    }
                }
            }
            if (pcmlDocNode2.getCountReps() > 0) {
                n8 = pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : (pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : 0);
                pcmlDimensions.set(n2, n8 - pcmlDocNode2.getCountReps());
                this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            } else {
                pcmlDocNode2.setCountReps(-10);
            }
        }
    }

    public TimeZone getTimeZone() {
        return AS400.getDefaultTimeZone(this.getAs400());
    }
}

