/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DanglingReferenceException;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.NoSuchMemberError;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.impl.NameImpl;

public class MemberAccessImpl
extends NameImpl
implements MemberAccess {
    private static int Slot_member = 0;
    private static int Slot_qualifier = 1;
    private static int totalSlots = 2;

    static {
        int offset = NameImpl.totalSlots();
        Slot_member += offset;
        Slot_qualifier += offset;
    }

    public static int totalSlots() {
        return totalSlots + NameImpl.totalSlots();
    }

    @Override
    public Expression getQualifier() {
        return (Expression)this.slotGet(Slot_qualifier);
    }

    @Override
    public void setQualifier(Expression value) {
        this.slotSet(Slot_qualifier, value);
    }

    @Override
    public void setTopLevelQualifier(Expression value) {
        if (this.getQualifier() instanceof MemberAccess) {
            ((MemberAccess)this.getQualifier()).setTopLevelQualifier(value);
        } else {
            this.setQualifier(value);
        }
    }

    @Override
    public MemberAccess addQualifier(Expression expr) {
        MemberAccess newMA = IrFactory.INSTANCE.createMemberAccess();
        newMA.setId(this.getId());
        newMA.setQualifier(this.getQualifier());
        newMA.getAnnotations().addAll(this.getAnnotations());
        if (this.getQualifier() instanceof LHSExpr) {
            newMA.setQualifier(((LHSExpr)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof InvocationExpression) {
            newMA.setQualifier(((InvocationExpression)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof ThisExpression) {
            newMA.setQualifier(expr);
        }
        return newMA;
    }

    @Override
    public Member getMember() {
        if (this.slotGet(Slot_member) == null) {
            try {
                this.resolveMbr();
            }
            catch (NoSuchMemberError e) {
                throw new RuntimeException(e);
            }
            catch (DanglingReferenceException e1) {
                throw new RuntimeException(e1);
            }
        }
        return (Member)this.slotGet(Slot_member);
    }

    @Override
    public void setMember(Member mbr) {
        this.slotSet(Slot_member, mbr);
    }

    @Override
    public Type getType() {
        Type type = this.getMember().getType();
        if (type instanceof GenericType && type.getClassifier() == null) {
            type = ((GenericType)type).resolveTypeParameter(this.getQualifier().getType());
        }
        return type;
    }

    @Override
    public NamedElement getNamedElement() {
        return this.getMember();
    }

    @Override
    public boolean isNullable() {
        return this.getMember().isNullable();
    }

    private void resolveMbr() throws DanglingReferenceException, NoSuchMemberError {
        Container container = (Container)((Object)this.getQualifier().getType());
        if (container == null) {
            throw new DanglingReferenceException(this.getId());
        }
        Member result = null;
        for (Member mbr : container.getAllMembers()) {
            if (!mbr.getId().equalsIgnoreCase(this.getId())) continue;
            result = mbr;
            break;
        }
        if (result == null) {
            throw new NoSuchMemberError("Member not found: " + this.getId());
        }
        this.setMember(result);
    }

    @Override
    public Field resolveField() {
        Member mbr = this.getMember();
        if (mbr instanceof Field) {
            return (Field)mbr;
        }
        return null;
    }

    @Override
    public Member resolveMember() {
        return this.getMember();
    }

    @Override
    public Function resolveFunction() {
        Member mbr = this.getMember();
        if (mbr instanceof Function) {
            return (Function)mbr;
        }
        return null;
    }
}

