/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.NoSuchFunctionError;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.TernaryExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.impl.MultiOperandExpressionImpl;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class TernaryExpressionImpl
extends MultiOperandExpressionImpl
implements TernaryExpression {
    private boolean initialized = false;

    private void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.getOperands().isEmpty()) {
            this.getOperands().add(null);
            this.getOperands().add(null);
            this.getOperands().add(null);
        }
    }

    @Override
    protected Operation resolveOperation() {
        Operation op = IRUtils.getBinaryOperation(this.getOperandType(this.getFirst()), this.getOperandType(this.getSecond()), this.getOperator());
        if (op == null) {
            throw new NoSuchFunctionError();
        }
        return op;
    }

    @Override
    public Expression getFirst() {
        this.ensureInitialized();
        return this.getOperands().get(0);
    }

    @Override
    public Expression getSecond() {
        this.ensureInitialized();
        return this.getOperands().get(1);
    }

    @Override
    public Expression getThird() {
        this.ensureInitialized();
        return this.getOperands().get(2);
    }

    @Override
    public void setFirst(Expression expr) {
        this.ensureInitialized();
        this.getOperands().set(0, expr);
    }

    @Override
    public void setSecond(Expression expr) {
        this.ensureInitialized();
        this.getOperands().set(1, expr);
    }

    @Override
    public void setThird(Expression expr) {
        this.ensureInitialized();
        this.getOperands().set(2, expr);
    }

    @Override
    public Type getType() {
        Type thirdType;
        Expression secondExpr = this.getSecond();
        Expression thirdExpr = this.getThird();
        Type secondType = secondExpr == null ? null : secondExpr.getType();
        Type type = thirdType = thirdExpr == null ? null : thirdExpr.getType();
        if (secondType != null && thirdType != null) {
            return IRUtils.getCommonSupertype(secondType, thirdType);
        }
        return TypeUtils.Type_ANY;
    }

    @Override
    public boolean isNullable() {
        Expression secondExpr = this.getSecond();
        if (secondExpr instanceof TypedElement && ((TypedElement)((Object)secondExpr)).isNullable()) {
            return true;
        }
        Expression thirdExpr = this.getThird();
        return thirdExpr instanceof TypedElement && ((TypedElement)((Object)thirdExpr)).isNullable();
    }
}

