/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.BaseCompiler;
import org.eclipse.edt.compiler.SystemLibraryUtil;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.validation.DefaultFunctionValidator;
import org.eclipse.edt.compiler.internal.core.validation.DefaultPartValidator;
import org.eclipse.edt.compiler.internal.core.validation.DefaultStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.DefaultTypeValidator;
import org.eclipse.edt.compiler.internal.egl2mof.DefaultElementGenerator;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;

public class EDTCompiler
extends BaseCompiler {
    @Override
    public String getSystemEnvironmentPath() {
        if (this.systemEnvironmentRootPath == null) {
            StringBuilder buf = new StringBuilder(100);
            buf.append(SystemLibraryUtil.getSystemLibraryPath(BindingCreator.class, "lib"));
            buf.append(File.pathSeparatorChar);
            buf.append(super.getSystemEnvironmentPath());
            this.systemEnvironmentRootPath = buf.toString();
        }
        return this.systemEnvironmentRootPath;
    }

    @Override
    public List<ASTValidator> getValidatorsFor(Node node) {
        List<ASTValidator> validators = super.getValidatorsFor(node);
        if (validators == null) {
            validators = new ArrayList<ASTValidator>(1);
        }
        if (node instanceof Part) {
            validators.add(0, new DefaultPartValidator());
        } else if (node instanceof Type) {
            if (DefaultTypeValidator.isApplicableFor((Type)node)) {
                validators.add(0, new DefaultTypeValidator());
            }
        } else if (node instanceof NestedFunction || node instanceof Constructor) {
            validators.add(0, new DefaultFunctionValidator());
        } else if (validators.size() == 0 && node instanceof Statement) {
            validators.add(new DefaultStatementValidator());
        }
        return validators;
    }

    @Override
    public ElementGenerator getElementGeneratorFor(Node node) {
        ElementGenerator generator = super.getElementGeneratorFor(node);
        if (generator != null) {
            return generator;
        }
        return new DefaultElementGenerator();
    }
}

